/*
 *  IHU -- I Hear U, easy VoIP application using Speex and Qt
 *
 *  Copyright (C) 2003-2008 Matteo Trotta - <mrotta@users.sourceforge.net>
 *
 *  http://ihu.sourceforge.net
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 */

#include <qimage.h>
#include <qdict.h>
#include <qmime.h>
#include <qdragobject.h>

// images/configure.png
static const unsigned char image_1_data[] = {
    0x00,0x00,0x04,0x00,0x78,0x9c,0x95,0x93,0x6d,0x4b,0xc2,0x50,0x18,0x86,
    0xfb,0x59,0xfe,0x94,0xf0,0x0f,0x08,0x41,0x1f,0x24,0x34,0x42,0xb1,0x50,
    0x10,0xc5,0x40,0x2a,0x44,0x51,0x50,0x2a,0x94,0x52,0x68,0x2a,0xf8,0x46,
    0x46,0x49,0x89,0xd9,0x04,0xe7,0x07,0x61,0x56,0xa2,0x2e,0x94,0x69,0x09,
    0xa9,0xd4,0xc7,0xdd,0xed,0x9c,0x9a,0x98,0xae,0x17,0x3f,0xdc,0xb0,0x8d,
    0x73,0x5d,0xcf,0x79,0x9e,0x73,0x26,0x49,0xd2,0x8a,0x34,0x93,0x90,0xcd,
    0x86,0xf9,0x48,0x73,0x6b,0x7e,0xcb,0xaa,0x46,0x83,0xbe,0x20,0xd0,0x88,
    0xad,0x36,0x7a,0x0f,0x4d,0x6c,0x69,0xb5,0x34,0xff,0xe1,0x83,0x56,0x2b,
    0x88,0x43,0x6c,0xb5,0x64,0xf6,0x01,0x42,0xa3,0x81,0x76,0xbd,0x8e,0xc7,
    0x2a,0xb7,0xb4,0x43,0xe0,0xbf,0x58,0xae,0x8a,0xfb,0x0a,0xab,0xca,0xff,
    0xd4,0x23,0x71,0x90,0xef,0xa4,0x2e,0xcf,0xb2,0xa8,0x17,0x4b,0xa8,0x15,
    0x0a,0x0b,0x0e,0xb2,0xe6,0x7d,0x32,0x59,0x70,0x50,0x96,0xe3,0xe4,0xba,
    0x15,0xd4,0x4b,0x9f,0x6c,0x25,0x9f,0xff,0x91,0x17,0xdb,0xed,0xa9,0x43,
    0x61,0x69,0xdd,0x19,0xb6,0x9c,0x4e,0xab,0xf2,0x6f,0xe3,0x31,0x7a,0xcd,
    0xa6,0xdc,0x2f,0x8f,0x69,0x5d,0x15,0xf6,0x86,0x89,0xab,0xf3,0xa3,0x91,
    0x3c,0x67,0x7e,0x3a,0x67,0x7e,0x6e,0xcf,0x94,0x8d,0xc7,0x71,0x19,0x8d,
    0x2d,0xf0,0x64,0x4e,0x76,0x9d,0x0e,0xe3,0xe1,0x50,0xb5,0xdf,0x72,0x26,
    0xf3,0xc9,0xc6,0xa2,0xc8,0x47,0xc2,0xd8,0x37,0x18,0x16,0x1c,0xe4,0xac,
    0x8e,0x9d,0x4e,0xbc,0x0e,0x06,0x18,0x8a,0x22,0x5e,0xba,0x5d,0x3c,0x3f,
    0x3d,0xa1,0xdf,0xe9,0x50,0x67,0xed,0xaa,0x80,0xf3,0x70,0x18,0xe9,0x50,
    0x08,0x49,0xbf,0x1f,0x6e,0xbd,0xfe,0x9b,0x43,0x39,0x6f,0x12,0xf2,0x1c,
    0xd8,0xd9,0x81,0xdf,0x62,0x81,0xcf,0x6c,0xa6,0xef,0x6c,0x2e,0x87,0xbb,
    0x6c,0x96,0xb2,0x67,0x1e,0x0f,0x4e,0xdd,0x6e,0xec,0xae,0xaf,0xab,0xf6,
    0xa2,0x78,0x66,0x43,0x5c,0xa4,0x8f,0x6b,0x86,0xa1,0x6c,0xc4,0xe5,0xc2,
    0x91,0xdd,0x01,0xc7,0xda,0xda,0x9f,0xf7,0x51,0x71,0x7a,0x4d,0x5b,0xb8,
    0x4d,0xa5,0x70,0x71,0x72,0x42,0xd9,0xa0,0xd5,0x26,0x7b,0xb7,0x97,0xba,
    0xcf,0x07,0x46,0x23,0x8a,0xc9,0x24,0xb2,0x87,0x87,0x08,0xc8,0xac,0xcf,
    0x64,0xfa,0xf7,0xbf,0xa9,0x38,0xf6,0x36,0x36,0x50,0x4c,0x24,0xc0,0x78,
    0xbd,0xf0,0x6c,0x6e,0xe2,0x03,0xc5,0x7f,0xee,0xc5
};

// images/call.png
static const unsigned char image_2_data[] = {
    0x00,0x00,0x04,0x00,0x78,0x9c,0x7b,0xf1,0xf2,0x15,0xc3,0x0b,0x12,0x30,
    0x43,0x03,0xc3,0x7f,0x18,0x26,0x57,0x1f,0xa9,0x66,0xe0,0xd2,0x4b,0x8c,
    0x7e,0x7c,0x7a,0x09,0xe9,0x1f,0x4c,0x7a,0x29,0x09,0xe7,0xe1,0xac,0x97,
    0x16,0x76,0x0f,0xb4,0x7e,0x52,0xfc,0x8e,0x6e,0x06,0xa9,0x7a,0x01,0xe5,
    0xf4,0x4c,0x07
};

// images/hangup.png
static const unsigned char image_3_data[] = {
    0x00,0x00,0x04,0x00,0x78,0x9c,0x7b,0xf1,0xf2,0x15,0xc3,0x8b,0x51,0x3c,
    0x28,0x30,0x03,0xc3,0xff,0xff,0xc4,0x60,0x72,0xf5,0xe1,0x32,0x87,0x12,
    0xfd,0x84,0xdc,0x46,0xaa,0x5b,0x29,0xd1,0x4f,0x4e,0x38,0x0f,0x74,0x9c,
    0x0f,0x34,0x06,0x00,0x96,0x9a,0x8e,0xd3
};

// images/ihu.png
static const unsigned char image_4_data[] = {
    0x00,0x00,0x10,0x00,0x78,0x9c,0xe5,0x96,0xbf,0x4b,0xc3,0x50,0x10,0xc7,
    0x0b,0x52,0x41,0x50,0xc9,0x20,0x58,0x05,0x21,0x8b,0x08,0x56,0xa5,0x83,
    0xe2,0x20,0x42,0x5c,0x9d,0x02,0xe2,0xe4,0x52,0xdc,0xdc,0xf2,0x07,0x38,
    0x04,0x05,0xc1,0x41,0x32,0x38,0x38,0x46,0xd0,0xc9,0xa5,0xce,0x2e,0x99,
    0x9d,0x82,0xe0,0x20,0x82,0x04,0x0a,0x85,0xf8,0x03,0xb2,0x88,0xe0,0x74,
    0xfa,0x4d,0x7c,0x6d,0xf2,0x5a,0xd3,0xa4,0x79,0x89,0x83,0x07,0x5f,0xc2,
    0x0b,0x79,0x7c,0xee,0xee,0xdd,0xdd,0x8b,0xfb,0xfc,0x52,0x72,0x53,0xea,
    0xdb,0x08,0x4a,0xbb,0x2f,0xab,0x18,0x97,0xd7,0x5f,0xf3,0x8b,0xf0,0x21,
    0x8e,0x5d,0x04,0x5f,0x96,0x65,0x72,0x1c,0x87,0xea,0xf5,0x3a,0x49,0x92,
    0x44,0xb6,0x6d,0x13,0x4c,0xd3,0xb4,0x42,0xf8,0xba,0xae,0x93,0xaa,0xaa,
    0x64,0x18,0x06,0x29,0x8a,0xd2,0x7e,0x36,0x1a,0x8d,0x9f,0x1c,0x90,0xaf,
    0xbc,0xf8,0x60,0x2f,0x6c,0x6e,0x91,0x72,0x6d,0xd3,0xca,0x8d,0x43,0xeb,
    0x17,0x16,0x4d,0xad,0x76,0xf3,0xf3,0xf2,0x61,0x74,0x59,0xa1,0xb5,0x7b,
    0xa2,0xa5,0xbb,0xa8,0x16,0x4f,0x8b,0xe1,0x4f,0xec,0x68,0x5d,0x6c,0xa8,
    0x76,0x6e,0x85,0xea,0x90,0xf9,0x20,0xbe,0x26,0x71,0xd6,0xfb,0xcd,0x28,
    0xfb,0xb8,0x45,0xd4,0x7c,0xf3,0xfc,0x7a,0x0c,0xc7,0x9f,0x47,0x5f,0xe0,
    0xfc,0x61,0x97,0xaf,0x44,0x67,0x2e,0x51,0xeb,0x93,0xda,0xd6,0x2b,0xf7,
    0x22,0xf9,0x88,0x0f,0xbd,0x17,0xb6,0x68,0xbc,0x9d,0xb8,0x79,0xbe,0x08,
    0x1f,0xd0,0xe3,0xbc,0xf1,0x6c,0x9c,0x4f,0x98,0x27,0x8a,0x8f,0xfd,0x6c,
    0xd6,0xc4,0xf9,0x10,0xac,0x4b,0x3d,0x7d,0xc8,0xc2,0xc6,0xdc,0x8b,0x33,
    0xc6,0x86,0xe1,0x5b,0x91,0xb3,0x19,0x7b,0x31,0x5f,0x92,0xf2,0x31,0x13,
    0x45,0xf2,0xfb,0xc5,0xce,0xf3,0x2d,0xcb,0x12,0xc6,0xc7,0x3e,0xd6,0x73,
    0x49,0xd8,0x30,0xcf,0xf3,0x84,0xe6,0x1e,0x77,0x4e,0x1a,0x7e,0xf0,0x4e,
    0x0c,0x7f,0x72,0x4f,0xa7,0x83,0x13,0x23,0x35,0xbf,0x5a,0xad,0xb6,0x55,
    0x2e,0x97,0x07,0xe6,0x63,0xbe,0x6e,0x3f,0x52,0x6c,0xef,0x85,0x0d,0xb3,
    0xb9,0x76,0xfb,0xee,0x33,0x11,0x77,0xa5,0x52,0xc9,0xc4,0x66,0x9a,0x3f,
    0x32,0xfd,0xba,0xea,0xc7,0xdf,0x7d,0x0a,0xbe,0x1f,0xdf,0x50,0x69,0x68,
    0x4c,0xa2,0x99,0x43,0xd3,0x5f,0x0f,0xca,0x0d,0x6b,0x64,0xae,0x46,0xa6,
    0x69,0xc6,0xe6,0x9d,0xf1,0x79,0x65,0x65,0x43,0xb3,0x57,0xb6,0x9f,0x53,
    0xd4,0x77,0x5a,0x7e,0x52,0x1f,0xe2,0xf8,0x10,0xee,0xbd,0xdf,0xe2,0x47,
    0x6e,0xfa,0xed,0xcf,0xca,0x87,0x1e,0x3e,0xa2,0x3e,0xa0,0x36,0x31,0x23,
    0x86,0xa7,0xe5,0x4c,0xec,0xa4,0x7c,0xf4,0x24,0xee,0xb9,0xe0,0xae,0xeb,
    0xf4,0x3a,0xfe,0xcd,0xb2,0x9c,0x7d,0x52,0x7f,0xa2,0xf3,0x29,0xba,0x16,
    0xc9,0xee,0xe5,0x4b,0x1c,0x9b,0xf7,0x41,0x24,0x9b,0x57,0x9e,0xff,0xf8,
    0xff,0x51,0x5f,0x85,0x82,0xc7,0xca
};

// images/green.png
static const unsigned char image_5_data[] = {
    0x00,0x00,0x05,0x10,0x78,0x9c,0xa5,0xd4,0xbb,0x0d,0xc0,0x20,0x0c,0x04,
    0x50,0x7a,0x96,0x62,0x29,0x96,0x62,0xa6,0xd4,0x94,0xac,0x90,0x50,0xe0,
    0xc8,0xb2,0x0e,0x73,0x16,0x3a,0x59,0x4a,0x11,0x3f,0x21,0xf3,0xe9,0x63,
    0xa4,0x0e,0xaa,0xb5,0xf6,0xa2,0x42,0xff,0x7a,0xfd,0xe9,0x49,0xb0,0x18,
    0x0f,0xf5,0xe7,0x99,0x9d,0x77,0x32,0xf2,0x4a,0x59,0xc9,0x2a,0x9e,0x65,
    0x0d,0xe9,0xaf,0x33,0x45,0x05,0x79,0xda,0x12,0x47,0x8c,0xba,0x32,0x27,
    0xf1,0x7f,0x5b,0xcb,0x3a,0x68,0x2d,0x62,0x48,0x18,0x4b,0x3b,0xc8,0x88,
    0x3a,0x76,0x2e,0x37,0xeb,0xb1,0xf3,0xb1,0x89,0x3a,0xc8,0x42,0xfb,0xc6,
    0x38,0xbb,0x78,0x7b,0xcf,0x5a,0xec,0xf9,0xd1,0x67,0xf9,0x14,0xe6,0x4c,
    0x7b,0x5e,0xf4,0x8e,0x9d,0x8a,0xb9,0xf3,0xb7,0xef,0xc6,0xcd,0x3b,0xf6,
    0x01,0xed,0xbb,0x1c,0x84
};

// images/red.png
static const unsigned char image_6_data[] = {
    0x00,0x00,0x05,0x10,0x78,0x9c,0xa5,0xd4,0xc1,0x09,0xc0,0x20,0x0c,0x05,
    0x50,0xef,0x2e,0xe5,0x52,0x2e,0xe5,0x4c,0x3d,0x7b,0x74,0x05,0xdb,0x50,
    0xd2,0xca,0xe7,0x1b,0x23,0x1e,0x3e,0x58,0x69,0x1e,0xa2,0xd1,0xda,0x5a,
    0xa8,0x24,0xa5,0x94,0xce,0xc2,0xfe,0xb5,0xea,0x43,0xb8,0x68,0x3c,0x1e,
    0xab,0x8f,0xb1,0x4f,0xbd,0x95,0x21,0xb5,0x92,0x94,0xde,0xe8,0x37,0x9a,
    0x68,0xa1,0xa1,0xf5,0x39,0xff,0xe3,0x99,0x37,0x5a,0xea,0xa8,0x21,0xf5,
    0x92,0x67,0xfa,0x1b,0xa3,0x85,0x0e,0x5b,0x8b,0x1a,0x1a,0x8f,0x35,0x3a,
    0xcc,0xd8,0x75,0x70,0x5f,0x4e,0xd6,0x83,0xfb,0x83,0xd9,0x75,0x98,0xc5,
    0xce,0xcd,0xe3,0xcc,0x62,0x9d,0xbd,0xd7,0xf2,0xf6,0xcf,0xd8,0xcb,0xab,
    0x78,0x7a,0xda,0xf2,0x76,0xef,0xd8,0x2a,0x9e,0x3b,0x7f,0xfa,0x6e,0x9c,
    0xbc,0x63,0x37,0x48,0x72,0x1c,0x84
};

// images/open.png
static const unsigned char image_7_data[] = {
    0x00,0x00,0x05,0x10,0x78,0x9c,0xbd,0x93,0xcd,0x6a,0x53,0x41,0x18,0x86,
    0xbd,0x86,0xac,0x14,0xc1,0x62,0x73,0x03,0x91,0xf6,0x02,0x2c,0x91,0x60,
    0x7e,0x4c,0x6b,0xe3,0x0f,0x88,0x2b,0x17,0xda,0x95,0xbd,0x02,0x37,0x82,
    0x0a,0x4a,0x37,0x9a,0x2e,0x0c,0x58,0x93,0xd2,0xa4,0x6d,0xfe,0xba,0x08,
    0xa9,0xa6,0x24,0xa9,0x39,0x4d,0x4e,0x35,0x69,0x82,0xd6,0xa4,0x8b,0x24,
    0xb5,0x16,0x62,0xed,0x22,0xdb,0x80,0x1b,0xf3,0x38,0x33,0x20,0x84,0xe6,
    0xb4,0x16,0x2d,0x0e,0x3c,0xcc,0x07,0x67,0xbe,0x67,0xde,0xf9,0xe0,0xe8,
    0xba,0x7e,0x4a,0x37,0x40,0x2c,0x7a,0x31,0x3a,0xf3,0x27,0x7a,0x7b,0x8d,
    0x7c,0xc7,0xf1,0x1e,0x76,0xe6,0x24,0xf2,0x19,0xb9,0x4e,0xc2,0x71,0x98,
    0xe7,0xec,0x90,0x9b,0x5e,0xfe,0xe6,0x1e,0xd9,0x77,0x37,0xf8,0x0d,0xdf,
    0xe7,0x2e,0x8f,0x0a,0x5d,0x55,0x1f,0xf4,0x1e,0xe7,0x0e,0xf9,0x4d,0x3a,
    0x9e,0x14,0x7e,0xf2,0x50,0xeb,0x72,0x27,0xfa,0xe3,0x48,0x8e,0x7a,0xd3,
    0xd3,0xf7,0x5d,0xe5,0x90,0xf5,0x95,0x31,0x8f,0x62,0x74,0xfc,0x3a,0x37,
    0x6f,0xdd,0xc6,0x7d,0xf5,0x9a,0x62,0xcc,0x73,0x43,0x21,0x6b,0xa3,0x39,
    0xc9,0x5e,0xe9,0x70,0x3f,0xce,0xe3,0x1a,0x1d,0xa7,0xd3,0xe9,0x28,0xda,
    0xed,0x36,0xad,0x56,0x8b,0x66,0xb3,0x49,0xb5,0x5a,0xa5,0x54,0x2a,0x91,
    0xcf,0xe7,0x49,0xa7,0xd3,0x24,0x93,0x49,0x12,0x89,0x04,0x16,0x8b,0xa5,
    0xcf,0x73,0xe6,0x82,0x83,0x46,0xa3,0xc1,0x97,0x9d,0x1d,0xbe,0xef,0xef,
    0xd3,0xda,0xdb,0x53,0xf5,0xa7,0xcd,0x4d,0xf4,0xf5,0x75,0x52,0x2b,0x2b,
    0x44,0x63,0x31,0x5e,0xfb,0xfd,0xbc,0xf0,0x7a,0xb9,0x6c,0xb7,0x73,0xf0,
    0x5d,0x97,0x1e,0xbc,0x11,0x79,0x3d,0xd4,0xeb,0x75,0xea,0xc2,0xf5,0x75,
    0x77,0x97,0xe6,0xf6,0x36,0xb5,0xad,0x2d,0x8a,0x22,0xc7,0xbb,0x5c,0x8e,
    0xe4,0xf2,0x32,0x0b,0x8b,0x8b,0xca,0x73,0x6f,0x62,0x82,0xf3,0x83,0x83,
    0x7d,0x9e,0xd3,0x16,0x3b,0xe5,0x72,0x99,0x0f,0xc5,0x22,0xd5,0x5a,0x4d,
    0xf1,0x51,0xe4,0x28,0x6d,0x6c,0x90,0xd3,0x34,0xde,0xa6,0x52,0xc4,0x97,
    0x96,0x08,0xcc,0xce,0xe2,0x9d,0x9e,0xee,0xcb,0xf2,0xdb,0x23,0xe7,0x57,
    0xa9,0x54,0x48,0x67,0xb3,0x68,0x62,0x06,0x05,0x5d,0x47,0x5b,0x5b,0x23,
    0xbb,0xba,0xaa,0x72,0xc4,0xe2,0x71,0xe6,0x82,0x41,0x5e,0xcd,0xcc,0x70,
    0x7f,0x72,0x12,0x93,0xc9,0x64,0xe8,0xc9,0x64,0x32,0x04,0x43,0x21,0x16,
    0xc2,0x61,0x22,0x62,0x06,0x51,0xd1,0x17,0x8e,0x44,0x08,0xcd,0xcf,0xe3,
    0x0f,0x04,0x78,0xe9,0xf3,0xf1,0x5c,0xcc,0xe4,0xd9,0xd4,0x94,0x61,0x16,
    0x89,0xd9,0x6c,0xc6,0xe1,0x70,0x60,0x17,0x38,0x5d,0x2e,0x5c,0x02,0xb9,
    0x3b,0x9c,0x4e,0xd5,0x63,0xb3,0xd9,0xb0,0x5a,0xad,0x5c,0x1c,0x19,0x61,
    0x68,0x78,0x98,0x73,0x03,0x03,0xff,0xf4,0x8f,0xfe,0x2f,0x7e,0x01,0xbb,
    0x52,0xf7,0x07
};

// images/speaker.png
static const unsigned char image_8_data[] = {
    0x00,0x00,0x04,0x00,0x78,0x9c,0x8d,0x92,0x31,0x0a,0xc2,0x30,0x18,0x85,
    0xb3,0x78,0x8f,0x1e,0x21,0x88,0xee,0x39,0x42,0x11,0x9d,0xcd,0xe0,0x20,
    0x8e,0xe2,0x01,0x32,0x28,0x88,0x53,0x27,0x27,0xa1,0x41,0x1c,0xc4,0x03,
    0x74,0x2a,0x98,0x23,0xf4,0x06,0x39,0xca,0x6f,0x5e,0x6a,0xa1,0x94,0x86,
    0xfe,0x85,0x07,0x1d,0xf2,0xe5,0xfd,0x79,0xff,0x13,0xdb,0x99,0x10,0x0c,
    0xbd,0xde,0x1f,0x2a,0x8a,0x22,0x6a,0xb5,0xde,0x10,0x87,0xe9,0x54,0xd5,
    0xdf,0x96,0x6d,0x1a,0xd2,0xde,0x93,0xb5,0x96,0xe6,0x8b,0x25,0xfb,0x0e,
    0x78,0x37,0x81,0x55,0xce,0x45,0xd6,0x18,0x43,0x59,0x96,0xb1,0xf9,0xf3,
    0xf5,0xd6,0x72,0x81,0xd7,0x5a,0x53,0x9e,0xe7,0x6c,0xbe,0xaa,0x4b,0xf2,
    0x5e,0x05,0x46,0x46,0x4e,0x29,0x15,0xd9,0xdd,0xfe,0x30,0xc9,0x77,0xac,
    0xb5,0x2a,0xf8,0x8a,0xc8,0x40,0xf7,0x47,0xc9,0x66,0xb5,0x56,0xc1,0x53,
    0xb0,0x98,0x31,0xd6,0x18,0xc1,0x9a,0x35,0xc5,0x3a,0x27,0xe8,0x78,0xe2,
    0xed,0xaa,0xff,0x5e,0xcc,0x0c,0x5f,0xb0,0xf8,0x47,0xfe,0x2e,0xe4,0x8f,
    0x2e,0xa4,0xf8,0xe7,0xeb,0x12,0x3c,0xdb,0xac,0xfa,0xef,0x05,0x8b,0xfd,
    0x83,0x47,0xfe,0xa9,0x8e,0xa1,0x17,0xe8,0xe6,0x30,0x2b,0x70,0x90,0x94,
    0x32,0xc9,0x63,0xb7,0xa9,0x8c,0x71,0x37,0x38,0x68,0xec,0x0c,0x27,0xdf,
    0xd4,0xec,0xb8,0x6f,0x6a,0xb7,0xe8,0xbf,0xfb,0x77,0x77,0xe8,0xc5,0xf1,
    0x06,0x8f,0x0f,0xf9,0x0c,0xcf,0xff,0x00,0x8e,0x01,0x34,0x1d
};

// images/mic.png
static const unsigned char image_9_data[] = {
    0x00,0x00,0x04,0x00,0x78,0x9c,0x95,0x93,0x81,0x09,0xc0,0x30,0x08,0x04,
    0x1d,0x2f,0xe3,0x74,0x04,0x47,0xcb,0x66,0x36,0x4a,0x85,0x47,0x34,0x55,
    0xe1,0x69,0x4a,0x3d,0xdf,0x26,0x66,0xd1,0x43,0xab,0xd0,0x09,0x51,0x55,
    0xdf,0x6f,0x22,0x66,0xe1,0x23,0xe5,0xf5,0x39,0x65,0x49,0xc4,0xd8,0xbd,
    0xb7,0x69,0xca,0xf2,0xe7,0xaf,0xac,0x7c,0xef,0x98,0x97,0xf5,0xe4,0xac,
    0x80,0xb7,0x07,0xe6,0x47,0xd6,0x38,0x64,0x2f,0x7c,0xc6,0x6a,0x78,0x2e,
    0xfa,0xab,0x32,0xff,0xac,0x67,0xe5,0x33,0x7f,0xaf,0xd1,0xe1,0xa3,0xbf,
    0x9f,0x5f,0xec,0x1f,0x65,0x7d,0xfa,0x3a,0xf8,0x77,0xfa,0xc7,0x39,0xeb,
    0xee,0xff,0xb5,0x4e,0x98,0x9d,0xbf,0xfd,0xaf,0x6a,0xf8,0xff,0x75,0xce,
    0xbf,0xec,0x03,0xe6,0xb7,0x33,0x7f,0x55,0x8d,0xe9,0xfd,0x99,0xdc,0xdf,
    0x17,0xad,0x5e,0xa3,0x1a
};

// images/mic_mute.png
static const unsigned char image_10_data[] = {
    0x00,0x00,0x04,0x00,0x78,0x9c,0x8d,0x93,0x31,0x0e,0xc2,0x30,0x0c,0x45,
    0xb3,0x70,0x8f,0x1e,0x01,0x21,0xd8,0x73,0x84,0x0a,0xc1,0x4c,0x06,0x06,
    0xc4,0x29,0x3a,0x80,0x84,0x98,0x3a,0x31,0x21,0x35,0x42,0x1d,0x10,0x07,
    0x60,0x42,0xa2,0x37,0xe9,0x51,0x3e,0x71,0xa0,0x55,0xe2,0x24,0x2d,0x95,
    0xfe,0x50,0x39,0xcf,0xfe,0xb6,0x13,0xb1,0x99,0x08,0xc1,0x25,0x00,0xae,
    0xfa,0xfe,0x40,0x59,0x96,0x56,0xcb,0xd5,0x1a,0x01,0x93,0xe0,0xb8,0x54,
    0xdb,0x42,0x6b,0x8d,0xd9,0x7c,0x81,0x24,0xcb,0xf2,0x52,0x6d,0x37,0x5e,
    0x14,0x05,0xb2,0x2c,0x43,0xb2,0x2e,0xe3,0x0f,0xa7,0xb3,0xad,0xe9,0x9e,
    0x19,0xe4,0x9d,0x1c,0xcf,0x57,0x85,0xb6,0x95,0xc8,0xf3,0xa9,0x51,0xde,
    0xc7,0xb7,0xbb,0x3d,0x3c,0x36,0x92,0xab,0x63,0xb5,0x96,0x50,0x4a,0x58,
    0xc6,0x72,0x2e,0x13,0xf3,0xec,0xce,0x4b,0x49,0x48,0x29,0x70,0xb9,0x56,
    0x61,0x8d,0x04,0x4f,0x75,0xdd,0x1c,0xbd,0xd7,0x3f,0xf8,0xce,0x33,0xd5,
    0x4d,0xce,0x34,0xc1,0xbb,0xfd,0x92,0x67,0xaf,0x57,0xa3,0xa6,0x69,0xcc,
    0x4c,0xde,0x61,0xce,0xdf,0xff,0xad,0x3e,0x9a,0xdd,0x7e,0x67,0x15,0xed,
    0x77,0xcc,0x8f,0x11,0xdd,0x4d,0x8f,0x35,0xa2,0xba,0x63,0x77,0x64,0x28,
    0xe6,0x79,0x8e,0xc4,0x83,0xbb,0x30,0x24,0xc6,0x92,0x57,0xee,0x37,0xc6,
    0x51,0x0f,0x4a,0xa9,0x60,0x97,0xc1,0x6e,0x23,0xa2,0xf7,0x43,0x1f,0xbd,
    0x1b,0x7e,0xfe,0x03,0x33,0x3a,0x84,0xfd
};

// images/speaker_mute.png
static const unsigned char image_11_data[] = {
    0x00,0x00,0x04,0x00,0x78,0x9c,0xa5,0x93,0xd1,0x0d,0x80,0x30,0x08,0x44,
    0x19,0xaf,0xe3,0x38,0x42,0x47,0xeb,0x66,0x58,0x54,0x2a,0x85,0x13,0x1b,
    0xfd,0x20,0xda,0xe6,0xde,0x71,0x41,0x2c,0xb4,0x51,0x71,0x45,0xc4,0xec,
    0xcb,0x6b,0x50,0x21,0x6e,0xd5,0x67,0xd2,0xd5,0xca,0xfd,0xc1,0x72,0xd9,
    0x5a,0x3b,0x2a,0xf3,0x08,0x7d,0x3a,0x5b,0xbb,0x87,0x94,0xb0,0x7c,0x9d,
    0xad,0x46,0xce,0x79,0x6e,0x1a,0xac,0xf2,0x56,0x1b,0xd8,0x91,0xf9,0x2e,
    0xc4,0xdb,0x1c,0x96,0x57,0xad,0xf7,0xf0,0xbc,0xcf,0x60,0x79,0x95,0x23,
    0x8f,0x15,0x5e,0x59,0xbe,0x66,0x8f,0xe6,0x65,0xf3,0x87,0xf7,0xa9,0x3f,
    0x05,0x0f,0xd4,0x1f,0xcd,0x50,0xfb,0x8f,0x4c,0x2f,0x7b,0x94,0xed,0x0e,
    0x0f,0xbf,0x7c,0x0f,0xbd,0x87,0xee,0x0f,0xe2,0xed,0x2c,0xbf,0xee,0xff,
    0x93,0xc7,0x9f,0xff,0x2f,0xfa,0x9c,0xdf,0x20,0xd3,0xec,0xec,0x2d,0xd2,
    0x9c
};

// images/bell.png
static const unsigned char image_12_data[] = {
    0x00,0x00,0x04,0x00,0x78,0x9c,0x9d,0x93,0x4b,0x28,0x84,0x51,0x18,0x86,
    0x4f,0x08,0x0b,0x97,0xec,0x64,0xa5,0xac,0x94,0x22,0xd9,0xc8,0x2d,0x36,
    0x16,0x83,0x44,0x6e,0x25,0x4a,0x72,0x6d,0x50,0x83,0x9f,0xc9,0xfd,0xda,
    0x4f,0x99,0xd1,0xd4,0x24,0x16,0x44,0x89,0x44,0x48,0x46,0xa1,0x66,0x1a,
    0xa5,0x28,0x0b,0x49,0x91,0xb5,0x50,0x08,0x91,0xfb,0xe3,0x64,0xa1,0x49,
    0x63,0x18,0x5f,0x3d,0x9d,0xc5,0xe9,0x79,0xeb,0x7b,0x3b,0x47,0x08,0xe7,
    0x13,0x51,0x39,0x86,0x77,0x9a,0xca,0x0f,0xd7,0xbf,0x8e,0x57,0xbb,0x8d,
    0xa0,0x5e,0x1b,0xb1,0xd9,0x7a,0xb7,0x33,0x62,0x72,0x3a,0xf0,0x9c,0xbe,
    0xf8,0xf4,0x7d,0xa3,0xcb,0x19,0x30,0x18,0xdd,0xce,0xf0,0x54,0x77,0x3e,
    0xfd,0x70,0x4d,0xfd,0xbf,0x76,0x08,0xc8,0x1a,0xc4,0xaf,0x76,0x8e,0xec,
    0x92,0x96,0x7f,0xf9,0xc1,0x31,0xa5,0xf8,0xe4,0x99,0x28,0xd2,0x76,0xbb,
    0xed,0xfb,0x65,0xf6,0x7f,0xed,0x1f,0x98,0xd8,0x40,0x6e,0xd5,0xdf,0xf7,
    0x8f,0x57,0xb6,0xa8,0xeb,0x9c,0x20,0xa4,0x40,0xc5,0x2b,0xa5,0x09,0x8f,
    0xac,0x76,0x44,0xa3,0x85,0xe4,0xb2,0xa9,0x5f,0x33,0x92,0x94,0x4d,0xf6,
    0x6e,0x9e,0x79,0x07,0x42,0x2f,0xef,0x11,0x27,0xb7,0x88,0xc3,0x57,0xc4,
    0x86,0x3c,0x8b,0x17,0x51,0xcd,0xb3,0x2e,0x33,0xa2,0x0c,0xdb,0x5c,0xbf,
    0x81,0xfd,0x19,0xc4,0x99,0xe4,0x58,0xb2,0x2b,0xb1,0x3c,0x21,0x74,0xeb,
    0xd4,0xb5,0x8d,0xb8,0xf6,0x87,0xec,0x1c,0x3d,0xc1,0xe4,0x9d,0x83,0xbb,
    0x21,0x99,0x97,0x68,0x57,0xd1,0xea,0x4d,0x2e,0xfd,0x48,0xd5,0x8a,0xed,
    0x01,0x8c,0x97,0x0e,0xee,0x82,0x64,0x5c,0x52,0xbd,0x42,0xb5,0xf2,0x73,
    0x8f,0x79,0x4d,0x2b,0x94,0x2f,0x9d,0x30,0x73,0x0b,0x9a,0xe3,0x6f,0xae,
    0xf1,0x05,0xa1,0xec,0x13,0x96,0xaa,0xa2,0x9a,0xa6,0x9d,0x67,0x28,0x56,
    0x0c,0x57,0xa0,0x3b,0x05,0x5f,0xab,0x83,0x3b,0x2c,0xe9,0x91,0x74,0x3e,
    0x22,0x2a,0x16,0x49,0x2f,0x74,0xfe,0xa7,0xba,0xcc,0x16,0x12,0x74,0xcb,
    0xa4,0x4d,0x1e,0x90,0x6f,0x3b,0x27,0x71,0x07,0x22,0xd7,0xc0,0xbf,0xed,
    0x14,0x91,0xb1,0x4e,0x50,0xaa,0x99,0x38,0x4d,0xeb,0x9f,0xde,0x81,0xbe,
    0x6f,0x94,0xda,0x56,0x33,0x35,0xb2,0xaf,0x9a,0x66,0xd7,0x9d,0x7d,0x00,
    0x29,0x3a,0x07,0x59
};

// images/phone.png
static const unsigned char image_13_data[] = {
    0x00,0x00,0x07,0x90,0x78,0x9c,0xed,0xd4,0x5b,0x4c,0x13,0x56,0x00,0xc6,
    0x71,0x15,0x0b,0x43,0xe5,0x4e,0x87,0x03,0x67,0x88,0x9b,0x01,0x43,0xb2,
    0xa0,0x2c,0x73,0x8e,0x05,0x16,0x61,0x30,0x97,0x89,0xe2,0x40,0x4d,0x46,
    0x02,0xc1,0x0d,0x75,0x0f,0x83,0x8c,0x0c,0xb2,0x6c,0x50,0xa1,0xa0,0xe5,
    0x32,0x81,0xc8,0x2c,0x2d,0x2a,0x50,0x05,0xca,0xb0,0xd8,0x96,0x49,0x29,
    0x77,0x51,0xa0,0xb4,0x40,0x4b,0x21,0x38,0x11,0x06,0xd8,0xa2,0xd0,0xb2,
    0x5e,0xb0,0x17,0x28,0x6d,0xbf,0x95,0x98,0x25,0x0b,0x03,0xb7,0xec,0x75,
    0xfb,0xbf,0x9c,0xa7,0xf3,0xcb,0x97,0xf3,0x70,0x36,0x6d,0xfa,0xbf,0x97,
    0x75,0x81,0xdd,0x47,0x38,0xc3,0xe8,0x8a,0x08,0xbb,0xd1,0x17,0x51,0xdc,
    0x33,0x21,0x4f,0xe1,0x88,0x90,0xc2,0x93,0xe2,0x9b,0xe6,0x61,0x7c,0x79,
    0xbb,0x17,0xd1,0xd7,0x3b,0x72,0x92,0x68,0x9c,0x43,0xff,0xd4,0xbb,0xd8,
    0x32,0xb2,0xef,0x54,0xd5,0xfd,0x82,0x70,0x86,0xb0,0xf4,0x2b,0xbe,0x14,
    0x69,0x83,0x4f,0x50,0x21,0x5f,0x04,0x73,0x61,0x09,0x3f,0x28,0x4d,0x48,
    0x7b,0xba,0x8c,0x8f,0xa5,0x5a,0xec,0xe1,0xcb,0x70,0xf0,0x6a,0x9b,0x22,
    0x2a,0x8f,0x79,0x74,0x23,0xab,0xb8,0x6b,0xcc,0xfe,0xb3,0x1a,0xa1,0xd7,
    0xe7,0x75,0x02,0x66,0x34,0x4b,0x32,0x45,0x12,0xcb,0x70,0x65,0xfe,0x39,
    0x2a,0xb5,0xcb,0xa0,0xa8,0x2c,0x48,0x90,0x5b,0x11,0x26,0xd6,0xe2,0x84,
    0x78,0x0e,0x41,0xc2,0x05,0xf8,0x89,0x0c,0x38,0x3a,0x0e,0x38,0x35,0xce,
    0x61,0x3f,0xf9,0x27,0x65,0x1c,0xa9,0x24,0x64,0x3d,0x37,0x99,0x25,0xbc,
    0x74,0xea,0xf6,0x10,0x48,0x03,0x33,0xa8,0x5f,0xb6,0xa0,0x78,0x11,0xf8,
    0x42,0xbe,0x82,0xc8,0x61,0x15,0xde,0xe9,0xd2,0xe3,0x35,0xaa,0x0c,0x6e,
    0x79,0x03,0xd8,0x7f,0x4b,0x84,0x28,0xd1,0x2c,0xfc,0x45,0x46,0x38,0xdd,
    0x33,0xc3,0xfd,0xba,0x0e,0x7b,0x33,0x79,0xf8,0xe0,0xec,0x77,0x9f,0xac,
    0xe7,0x86,0x55,0x3e,0xc0,0x11,0x9b,0x91,0xf8,0xd4,0x82,0xe8,0xc9,0x15,
    0xf8,0x35,0xcd,0xc2,0x8b,0x3e,0x82,0x80,0x9a,0x21,0x1c,0x60,0x8d,0x23,
    0x94,0x29,0x41,0x62,0xff,0x24,0xd2,0x65,0xbf,0xe1,0x82,0xde,0x82,0xe4,
    0x39,0x13,0x22,0x25,0x26,0x78,0xe7,0x8d,0xe0,0x40,0x7a,0x0d,0x2f,0x3c,
    0x21,0x79,0xd7,0x7a,0xae,0x73,0x79,0x3f,0x88,0x52,0x2b,0x0e,0x3f,0xb2,
    0xe2,0x5d,0xe9,0x0a,0xec,0xcb,0x46,0xe0,0x59,0xf2,0x0c,0x31,0xbd,0x06,
    0xe4,0x3e,0x37,0x81,0xac,0x33,0x81,0xa4,0xb1,0x9d,0xf3,0x3a,0x24,0x8d,
    0xce,0x82,0x7e,0xb7,0x15,0xc9,0x5d,0xa3,0xd8,0xd9,0x36,0x8f,0x3d,0xdf,
    0x57,0xe9,0x3f,0x4a,0xa5,0x24,0x65,0x5d,0xab,0xdb,0xb2,0xd6,0xdd,0x5a,
    0x37,0x03,0x42,0xa7,0x19,0x21,0x62,0x0b,0x0e,0x0d,0x9a,0xb1,0x8d,0x3a,
    0x09,0x6f,0xba,0x1a,0x99,0xda,0x15,0x94,0x28,0x16,0x41,0x91,0xa9,0x70,
    0x5e,0x30,0x0e,0x3a,0xeb,0x2e,0x42,0xf9,0x8f,0xb0,0xbb,0x56,0x8c,0xf7,
    0xea,0x06,0x70,0x4c,0xa8,0xc0,0xab,0x4d,0x32,0xf8,0x53,0x58,0x88,0xcb,
    0xa1,0xc6,0xaf,0x75,0xdf,0x28,0x15,0xc3,0xb5,0xc2,0x08,0x37,0x9a,0x11,
    0xc4,0x22,0x03,0x3c,0xc8,0x4f,0xe0,0x49,0xd7,0x22,0x4c,0xb0,0x88,0x73,
    0xb5,0x4d,0xc8,0xae,0x66,0xc3,0xb7,0x61,0x0c,0x3e,0xf5,0xa3,0x88,0xbe,
    0x37,0x85,0xd0,0x41,0x0d,0x82,0x2b,0xdb,0x91,0xc3,0x60,0x21,0x90,0x3d,
    0x02,0x3b,0xfe,0x02,0xf6,0x65,0xde,0xd2,0xc4,0xa4,0x64,0x27,0xfc,0xd9,
    0x3d,0x99,0x75,0x2d,0x30,0x22,0xb7,0x91,0xef,0x49,0x16,0xab,0xb7,0x93,
    0x25,0x70,0xa4,0xcb,0xe0,0x52,0xb1,0x04,0x22,0xc3,0x08,0x97,0x4e,0x1d,
    0x76,0x36,0xfe,0x6a,0x7b,0x13,0x39,0xde,0xec,0x56,0xe2,0x34,0xad,0x1e,
    0x89,0xf5,0xdd,0x20,0x76,0x28,0xe1,0xc0,0x7b,0x86,0xd8,0x96,0x51,0xc4,
    0xf5,0x4c,0x81,0xd0,0xae,0x86,0x5f,0x01,0x17,0x27,0xc9,0xb4,0xb4,0xb5,
    0xbb,0x37,0x33,0x27,0x7a,0xb7,0x76,0x58,0xe0,0xc8,0x5e,0x81,0x73,0xd5,
    0x32,0x3c,0xae,0x18,0xb1,0x9d,0x65,0xc2,0xeb,0xdc,0xc7,0x88,0x2f,0xe7,
    0xc2,0x9f,0xfd,0x0b,0xec,0x3a,0xb5,0x08,0xe4,0x4f,0xe1,0x6b,0xe1,0x0c,
    0x7c,0x1e,0xa8,0x11,0xcc,0xe8,0x44,0xcc,0xcd,0x36,0x10,0xee,0xeb,0xe0,
    0xde,0xae,0x44,0xf0,0xa5,0x1a,0xac,0x75,0x09,0x95,0xa3,0x01,0x76,0xcd,
    0x3a,0xd5,0x2b,0x5c,0x13,0x9c,0xab,0x6d,0x6e,0xe9,0x8b,0x77,0xb1,0x6f,
    0xb1,0x6d,0xe7,0xcf,0xe2,0x7c,0xd7,0x43,0xc4,0xf7,0x4d,0xc3,0x97,0xfd,
    0x10,0xb1,0x74,0x2e,0x3c,0x1a,0x26,0xe0,0x28,0x58,0x82,0x57,0xbf,0x0e,
    0x27,0xe4,0x66,0x64,0xea,0xad,0x88,0x28,0xe3,0xfe,0xc5,0x5d,0xcd,0xe1,
    0x8e,0x3a,0xd0,0x81,0xb5,0x38,0xb6,0xa3,0x76,0x09,0xee,0x54,0xdb,0x9d,
    0x7c,0x03,0x88,0x25,0x06,0xb8,0xf0,0x94,0x38,0x7c,0xb5,0x01,0xe1,0xe5,
    0x3c,0x6c,0xe9,0x31,0xc2,0x75,0xc8,0x8c,0xa0,0xc7,0x16,0x9c,0x59,0x00,
    0x8a,0x4c,0x00,0xd5,0x62,0x45,0x8e,0x42,0x83,0x28,0x2a,0x7b,0x5d,0x77,
    0xb5,0x6d,0x37,0xe7,0x82,0x9c,0xe8,0xb3,0x33,0x6e,0x74,0xdb,0xce,0x42,
    0x03,0xbc,0xb3,0xf4,0x70,0xa9,0x34,0x62,0x73,0x8b,0x0a,0x6e,0xdd,0x1a,
    0x44,0x4e,0x9b,0x91,0xac,0x79,0xe1,0x95,0x59,0x81,0x02,0x8d,0x1e,0x9f,
    0xfe,0x2c,0x42,0x0c,0xb3,0x9b,0x13,0xfb,0x23,0x27,0x6e,0x23,0x77,0x35,
    0xf7,0xc2,0x41,0x5f,0xd7,0x8b,0x92,0x69,0x62,0xa1,0xd2,0xe6,0xea,0xe0,
    0x9b,0xab,0xc3,0xf1,0x61,0x33,0x28,0xcb,0x40,0xa9,0x6d,0x5b,0x91,0x7e,
    0x09,0x19,0xd3,0xf3,0x88,0x66,0x0b,0x14,0x51,0xd4,0x46,0x49,0x48,0x31,
    0x67,0xf7,0xf1,0xcb,0x0d,0x3b,0x5e,0x66,0xfe,0x51,0x40,0x46,0xf5,0x5b,
    0xde,0xa4,0xee,0x7c,0xcf,0x6f,0xc7,0x54,0x7b,0x33,0xb4,0x48,0x95,0x9a,
    0x70,0x59,0x67,0xc4,0xb9,0x81,0x09,0x9c,0x6e,0x1d,0xe6,0xf8,0x67,0x33,
    0xf3,0xcf,0xd2,0xb8,0x1b,0xfe,0x3b,0x7f,0x97,0x47,0xea,0x9d,0x63,0xbb,
    0xd2,0x5b,0xf1,0xfe,0x0d,0x11,0x0e,0x52,0x9b,0x65,0x6f,0x97,0xf2,0x3e,
    0xf4,0x49,0x63,0x78,0xfd,0x5b,0xef,0xbf,0xd4,0xef,0x18,0x14,0x9c,0x6e
};

// images/phone_no.png
static const unsigned char image_14_data[] = {
    0x00,0x00,0x07,0x90,0x78,0x9c,0xed,0x94,0x79,0x48,0xd3,0x61,0x1c,0xc6,
    0x2d,0x9b,0x65,0x65,0xe6,0xb1,0x24,0xed,0x8f,0x28,0x22,0x25,0x08,0xad,
    0xc8,0xca,0x28,0x48,0xb3,0x03,0x32,0x2d,0x3b,0x20,0x41,0x31,0xb2,0xec,
    0x8f,0x94,0x24,0x23,0xc8,0xab,0x59,0x99,0x99,0x1a,0x59,0xcb,0x99,0x39,
    0xd7,0x35,0xab,0xd9,0xb6,0x8e,0x39,0xef,0x2c,0x53,0x37,0x6d,0x3a,0xa5,
    0x43,0x94,0xb4,0x4d,0x53,0x67,0x3b,0xec,0xb7,0x4d,0xe7,0xb6,0xa7,0x89,
    0x4c,0x9d,0x69,0xf5,0x7f,0x3d,0xf0,0xc2,0xfb,0xbe,0xdf,0xe7,0xfb,0xe1,
    0x81,0xf7,0xb0,0xb2,0xfa,0xaf,0x71,0x01,0xa3,0x63,0x5c,0x89,0xec,0x1a,
    0xd2,0x51,0x46,0xa5,0xbf,0xef,0xdd,0x1a,0xff,0xcc,0xea,0x36,0x69,0x34,
    0x47,0x88,0x68,0x9e,0x18,0x67,0x8a,0x9a,0x70,0xf2,0xe9,0x3b,0x04,0xe5,
    0x96,0x27,0x47,0x64,0x73,0x36,0xfe,0x89,0x63,0xde,0xbb,0x54,0xdc,0xec,
    0x71,0x28,0xff,0xcd,0x55,0x3f,0x86,0x20,0xeb,0x14,0x5f,0x8c,0xd8,0x86,
    0xaf,0xc8,0x93,0x0e,0x80,0xd9,0x3f,0x88,0x6b,0x32,0x1d,0x62,0xbb,0x87,
    0xb0,0x5b,0xac,0xc2,0x32,0xbe,0x04,0xde,0xb7,0x4a,0xfb,0x02,0xae,0x30,
    0xf7,0x4c,0xc7,0xcc,0xac,0xfc,0x60,0x73,0xe4,0xa1,0xc0,0xc5,0x5c,0x4b,
    0x10,0x49,0x70,0xa3,0xf7,0x07,0xe8,0xaa,0x21,0xa4,0xc8,0x0d,0x08,0x93,
    0x1a,0xe1,0x2b,0x52,0x61,0x9f,0xa8,0x07,0x6b,0x05,0xfd,0x58,0x29,0xd4,
    0x60,0x4f,0x2b,0x60,0xf7,0xbc,0x07,0x5e,0x94,0xc7,0xb2,0xa9,0x73,0x5a,
    0x59,0x45,0xb1,0x04,0x97,0x0f,0x3d,0x7d,0x8f,0x84,0xfa,0x4e,0x98,0x3d,
    0xc7,0xa4,0xc3,0xd8,0xd1,0x24,0xc7,0xfa,0x4a,0x35,0x16,0x53,0x25,0x70,
    0xb8,0x52,0x0f,0xaf,0xfb,0x42,0x04,0x08,0xbb,0xe0,0x2e,0xd4,0xc2,0xee,
    0xb5,0x1e,0x8e,0xb9,0x04,0xa6,0x63,0x8e,0xc8,0x97,0xfe,0x16,0xbb,0x4c,
    0x8c,0xf0,0x6e,0x03,0x82,0xda,0x87,0x27,0x78,0x81,0x35,0xac,0x56,0x6c,
    0x65,0x36,0x22,0xbc,0xae,0x1d,0x67,0x25,0xdf,0x91,0xa8,0x36,0x20,0xaa,
    0x47,0x67,0xe1,0xf1,0x0b,0x8b,0x5a,0x32,0x15,0x77,0x41,0x4e,0x1d,0xc8,
    0x62,0x23,0xb6,0x7d,0x36,0x62,0x83,0x78,0x18,0x36,0xb7,0x9b,0x2d,0xfa,
    0x28,0x84,0x0e,0x09,0x4a,0x1d,0x28,0xbd,0x04,0x22,0x5a,0xba,0x2c,0x6a,
    0xcb,0xce,0xe7,0xab,0x77,0xc6,0xa4,0x44,0x24,0xdd,0x29,0x98,0x39,0x99,
    0x3b,0xab,0xa0,0x13,0xa4,0x0a,0x3d,0xb6,0x88,0x0c,0xd8,0xd8,0xa0,0xc7,
    0x5c,0x6a,0x3b,0x5c,0x69,0x0a,0xc4,0xab,0xc6,0xb3,0x47,0xd6,0xb6,0x82,
    0xc6,0x7a,0x39,0xb6,0xde,0x54,0x50,0x8f,0xbd,0x82,0x3e,0x2c,0x7a,0x25,
    0x81,0x7b,0x0a,0x0b,0x21,0xc9,0xd4,0xd0,0xc9,0xdc,0xe5,0x59,0x22,0x2c,
    0xcc,0xd3,0xc2,0x21,0x5b,0x0b,0x72,0x86,0x06,0x4e,0x94,0xaf,0x70,0xa6,
    0xa9,0xe0,0x5b,0x3b,0x80,0x13,0x8f,0x5e,0x59,0xe4,0x1b,0x19,0x5b,0x1b,
    0x94,0xf0,0xa1,0x97,0x21,0x99,0xc1,0x82,0x27,0xbb,0x19,0xd6,0xfc,0x7e,
    0x78,0xc4,0xdf,0x57,0x06,0x47,0x5f,0x08,0x9b,0xc8,0x3d,0x98,0x74,0xc7,
    0xd3,0xff,0xe2,0x73,0xbe,0x33,0x45,0xa4,0x98,0x47,0x69,0x84,0x2d,0x4d,
    0x02,0xfb,0xbc,0x41,0x90,0x19,0x5a,0xd8,0x57,0x10,0xbf,0x70,0xc3,0x9f,
    0x54,0x81,0x5c,0x2e,0xc3,0x6c,0xde,0x37,0x1c,0x28,0x6e,0x41,0x48,0xf5,
    0x17,0x90,0xca,0x14,0x58,0x79,0x95,0x8b,0x83,0x94,0xec,0xd8,0xc9,0xb9,
    0x67,0x30,0xdb,0xde,0xcd,0x2a,0x37,0xc0,0x96,0x3d,0x8c,0x05,0xf9,0x43,
    0x70,0xba,0xa1,0x1d,0x63,0x85,0xe6,0x70,0xe1,0xce,0xfe,0x34,0xb6,0x3e,
    0x2d,0xe8,0x84,0xdb,0x5b,0x05,0x7c,0x18,0x15,0x08,0xbe,0x57,0x0a,0xd2,
    0x1b,0x02,0x8e,0x65,0x32,0xf8,0x5c,0x7e,0xf8,0xcb,0xdd,0x20,0xd1,0x5b,
    0x56,0x59,0x17,0x11,0xf2,0x39,0x5c,0xcb,0xf3,0xb6,0x29,0x36,0x65,0xe7,
    0x77,0x21,0xb2,0xf2,0x23,0x42,0x6b,0x3a,0x2c,0x6a,0xb6,0xb5,0x83,0x70,
    0xa9,0x23,0xb0,0x4f,0xaa,0x47,0xbc,0xda,0x08,0xff,0xdb,0xdc,0x29,0xef,
    0xdc,0xec,0x67,0x0a,0xcf,0x89,0x7d,0x2e,0xa9,0x1a,0x90,0xaf,0x6b,0x60,
    0xcf,0x93,0x61,0xdb,0xad,0x42,0xf8,0xe5,0xf0,0x30,0xb3,0x5a,0x6b,0xc1,
    0xce,0xd0,0x01,0x54,0x83,0x11,0xc9,0x7d,0x4a,0x04,0x50,0xd9,0x53,0x72,
    0xcd,0x5e,0x3b,0x5a,0x57,0xa7,0x03,0xcd,0x94,0x33,0x4d,0x03,0xd7,0x24,
    0x35,0xec,0xe9,0x5a,0xcc,0x28,0x96,0xc3,0xa1,0x4a,0x89,0x1d,0x1d,0x7a,
    0x44,0x29,0x47,0x79,0x66,0xff,0xfe,0x17,0x42,0x04,0x33,0xab,0x38,0x07,
    0x6e,0x72,0x42,0xa6,0x63,0x8e,0xcc,0x1c,0xd3,0x1a,0x96,0x2e,0xbc,0xd4,
    0xd8,0x41,0x4e,0x93,0x99,0xb8,0x04,0x96,0x5e,0x24,0x10,0xd8,0xa4,0x47,
    0xca,0x10,0x90,0x65,0xca,0x96,0xa1,0x1e,0x44,0x5c,0x47,0x2f,0x82,0xd8,
    0xb5,0x7d,0xe6,0xbe,0xc0,0xf4,0xc2,0xf9,0xbf,0x63,0x9a,0xb5,0x2a,0xee,
    0xc1,0x6a,0xd7,0x84,0xaa,0x54,0xe7,0x73,0x1f,0xe4,0x2b,0xe2,0x54,0x88,
    0x11,0xeb,0x90,0x4e,0x68,0x71,0xa2,0xbe,0x0d,0x87,0x4b,0x9a,0x38,0xee,
    0x17,0x98,0xa9,0xc7,0xb3,0xb9,0xd3,0xfe,0x3b,0xbf,0x7b,0xe3,0x23,0x72,
    0x8a,0x79,0xb6,0x77,0xc9,0xd9,0x12,0x6c,0xbe,0x2b,0x84,0x37,0xb5,0x48,
    0xb2,0x2e,0x8b,0xb7,0xdd,0x2d,0x96,0xe1,0xf2,0x37,0xd9,0xfe,0x75,0xfd,
    0x04,0xed,0xe0,0x9e,0x4f
};

// images/save.png
static const unsigned char image_15_data[] = {
    0x00,0x00,0x04,0x00,0x78,0x9c,0x63,0x60,0xa0,0x1c,0x34,0x34,0x34,0xfc,
    0x27,0x07,0x23,0xeb,0x67,0x68,0x69,0xf9,0xef,0xeb,0xeb,0xfb,0xff,0xd8,
    0xb1,0x63,0x78,0x31,0x4c,0x0d,0x50,0x1b,0xdc,0x0c,0x52,0xf5,0x83,0x30,
    0x25,0xfa,0x41,0x6a,0x87,0xa3,0x7e,0x98,0x19,0xf8,0x30,0x4c,0x1d,0x2e,
    0xfd,0x44,0x63,0x32,0xed,0x27,0xd7,0xfd,0x94,0xfa,0x9f,0x96,0xfa,0x4f,
    0x5c,0xb8,0x02,0xa2,0xfe,0x93,0x8a,0x91,0xf3,0x10,0xb9,0xf9,0x10,0x00,
    0x27,0xcf,0x01,0x81
};

// images/ihu_tray.png
static const unsigned char image_16_data[] = {
    0x00,0x00,0x07,0x90,0x78,0x9c,0xa5,0x94,0x6b,0x48,0x53,0x61,0x18,0xc7,
    0xb7,0xa3,0xbb,0xe8,0xf0,0x4a,0x17,0x4a,0x56,0x49,0x25,0x16,0x96,0xa3,
    0x41,0x28,0xe1,0x25,0x1a,0x24,0x8a,0x34,0x47,0x12,0xc1,0xc4,0x0f,0x9a,
    0x13,0x24,0xf1,0x8b,0x65,0x5a,0x41,0x46,0x31,0x09,0x4a,0xfa,0xb0,0xdc,
    0xfc,0x24,0x7d,0x70,0xcc,0xc4,0xee,0x99,0x7e,0xb1,0x0f,0xa5,0xd5,0x44,
    0x66,0xea,0x40,0x71,0x69,0x17,0x10,0xad,0xc4,0xcb,0x74,0xd9,0xdc,0xbf,
    0xe7,0xcc,0x0d,0x8f,0xd3,0xb6,0xa5,0x0f,0xfc,0x39,0x2f,0xef,0x79,0xde,
    0xdf,0xf9,0x9f,0xe7,0x3c,0xcf,0x01,0xc0,0x83,0x1f,0x31,0x0c,0x93,0xc1,
    0xe7,0xf3,0x1b,0x79,0x3c,0x1e,0x68,0xad,0x08,0x0d,0x0d,0xdd,0xe7,0x2f,
    0x3f,0x58,0x51,0xfc,0x62,0x99,0x1c,0x75,0x11,0x3b,0x6e,0x2b,0xcc,0x90,
    0x90,0x10,0x6d,0x44,0x44,0x84,0x93,0x38,0x90,0x48,0x24,0x88,0x8c,0x8c,
    0x04,0xed,0xb1,0xbe,0xe5,0x5b,0xe1,0x66,0x66,0x66,0x9a,0x0c,0x06,0x03,
    0xb2,0xb3,0xb3,0x51,0x5f,0x5f,0x8f,0xb6,0xb6,0x36,0xa4,0xa7,0xa7,0x83,
    0xcf,0xbf,0x7f,0x99,0xf0,0xa9,0x9b,0xe5,0x16,0x15,0x15,0x99,0x14,0x85,
    0x1a,0xe4,0xea,0x4c,0x38,0xab,0x6b,0x46,0xee,0xf9,0x02,0xa8,0x54,0x2a,
    0xaa,0x85,0x99,0x84,0x51,0x86,0x41,0xda,0x66,0xb8,0x3b,0xd2,0xb2,0x4c,
    0xf2,0x8e,0x31,0x24,0xf7,0x3a,0x20,0xfb,0xb8,0x08,0xd9,0x53,0x2b,0xa4,
    0xa7,0x59,0xee,0x33,0x96,0x4b,0xbe,0x07,0xab,0x45,0x22,0x91,0xf4,0x7f,
    0xb9,0x09,0xca,0x02,0x93,0xc2,0x3c,0x8f,0xa3,0x16,0xb8,0xa5,0xb6,0xcc,
    0xe1,0x84,0xfa,0x02,0xf1,0x0a,0xdc,0x5c,0x1e,0xaf,0x84,0xfd,0x8e,0x53,
    0x54,0xf3,0xff,0xf2,0x9d,0x93,0x93,0x63,0x6a,0xff,0x3e,0x87,0xaa,0x71,
    0xc0,0x30,0x01,0x7c,0x5e,0x58,0x46,0xe5,0x25,0x0b,0x71,0xa7,0x59,0xee,
    0x3b,0x86,0xd1,0xe4,0x13,0x77,0x82,0xa4,0x0f,0xda,0x6b,0x42,0x42,0x61,
    0x53,0x53,0xd3,0xef,0x3f,0x4e,0x27,0x1c,0xcb,0x40,0xae,0x12,0x88,0x89,
    0x01,0xc4,0x62,0x20,0x3c,0xbc,0x9f,0xb8,0xd1,0x9d,0x62,0xb1,0x78,0x1b,
    0x31,0x47,0x49,0x0e,0xea,0xf1,0x33,0x81,0x98,0x94,0x1f,0xad,0x56,0xab,
    0x5b,0x6d,0x36,0x1b,0xbc,0xd1,0xd8,0x08,0xcf,0xbb,0x03,0x15,0x15,0x0f,
    0xdd,0xbd,0x4c,0xac,0x56,0xba,0xea,0x3c,0xeb,0xfc,0x40,0x5c,0x81,0x40,
    0xd0,0x52,0x5e,0x5e,0x8e,0xa5,0xa5,0x25,0x70,0xa3,0xae,0x0e,0x28,0x2e,
    0x06,0xc6,0xc7,0xa7,0x11,0x15,0x15,0xe5,0x9d,0x93,0xde,0x60,0xb9,0x54,
    0x83,0xd1,0x91,0x91,0x11,0xf8,0x46,0x67,0x27,0xa0,0xd5,0x02,0x0e,0x87,
    0x03,0x1a,0x8d,0x86,0x3b,0x83,0x01,0xb9,0x74,0x5f,0x95,0x97,0x97,0x37,
    0xbd,0x0e,0x4a,0x51,0x53,0x03,0x74,0x77,0x03,0x4e,0xaa,0x39,0x3b,0x27,
    0x1c,0xee,0x7b,0x9a,0xc9,0x44,0x7f,0x5c,0x46,0x14,0xa6,0xbf,0x52,0x5d,
    0xbd,0x11,0x16,0x0a,0xc5,0xca,0xd5,0xe5,0x72,0xc1,0x68,0x34,0xba,0x67,
    0x9a,0x55,0x30,0xfd,0xb0,0xf7,0x8e,0x49,0x5f,0xf5,0xa8,0x03,0x76,0xbb,
    0x7d,0x0d,0xb3,0xab,0x0b,0xa8,0xad,0x5d,0x59,0x0f,0x2f,0xb8,0x70,0xdb,
    0xf8,0x04,0x52,0xa9,0x14,0xf1,0xf1,0xf1,0xf3,0x42,0xa1,0xb0,0xc4,0x1f,
    0x53,0x66,0x81,0x9c,0xfa,0x7f,0xe8,0x64,0xef,0x3c,0x1e,0xb4,0xbf,0xc1,
    0xec,0xec,0xec,0x3a,0xaf,0x6c,0xdc,0xfa,0xe6,0xc2,0x7e,0xdd,0x2b,0x08,
    0xb6,0xef,0xc6,0xae,0x73,0xa5,0x33,0xc9,0x16,0xa8,0x37,0xe2,0x1d,0xef,
    0x47,0x2c,0xf1,0xda,0x49,0x13,0xee,0xd9,0xea,0x5b,0xc6,0x61,0xdd,0x73,
    0x54,0x5c,0xbb,0xe1,0xf6,0xdd,0xd0,0x00,0xb4,0xb4,0xac,0x72,0xaf,0x7f,
    0x05,0x8e,0x7c,0x58,0xc4,0xa1,0xd7,0x5f,0x90,0xf4,0x76,0x86,0x9d,0xc5,
    0xe6,0xd4,0x7e,0x48,0x7c,0xb9,0xb4,0xaf,0xf5,0xce,0xaa,0x57,0x49,0xdd,
    0x73,0x48,0xbd,0x7a,0x0f,0x53,0x3f,0x7e,0xba,0x7b,0x80,0xed,0x05,0x36,
    0x26,0x27,0x27,0xa1,0xb1,0x2e,0xc2,0x37,0x9f,0x3c,0xeb,0xd3,0x06,0x20,
    0x0a,0xc4,0x65,0x95,0x35,0x04,0x8c,0x39,0x00,0xab,0x15,0x28,0x2b,0x03,
    0x7a,0x7a,0x7a,0x50,0x58,0x52,0x0a,0xd9,0x8b,0xe1,0x8d,0xb8,0x77,0x33,
    0x06,0x20,0xf4,0xe1,0x5e,0x24,0x99,0x3d,0x9a,0xe2,0xe6,0xcb,0x2a,0xb5,
    0x7d,0x4a,0xa5,0xd2,0x1c,0x1b,0x6b,0x9d,0xa1,0xff,0xba,0x39,0x7c,0xcf,
    0x01,0x73,0xe2,0x4b,0x9b,0x9d,0x93,0xd3,0x91,0xf2,0x09,0x31,0xa7,0x06,
    0xd7,0x32,0x7d,0x45,0xcf,0x55,0x79,0xfc,0xb3,0xf5,0x7e,0x4c,0x67,0xc2,
    0xa8,0x95,0x52,0xf8,0x7c,0xdc,0xe4,0xf8,0xa8,0xf4,0x30,0xdb,0xe5,0xf4,
    0x6d,0x02,0xf5,0x18,0x57,0xc7,0x2c,0x88,0x93,0x5b,0xb0,0x93,0x98,0x07,
    0x59,0xa6,0x48,0xb4,0x7a,0x9e,0xbc,0x09,0xa8,0x77,0x14,0x6c,0xce,0xbf,
    0xce,0xff,0x05,0xfc,0xaa,0xfb,0x9f
};

// images/ihu_wait.png
static const unsigned char image_17_data[] = {
    0x00,0x00,0x07,0x90,0x78,0x9c,0x7d,0x94,0x0b,0x4c,0x93,0x67,0x14,0x86,
    0xa9,0x40,0x0b,0x45,0xa9,0x45,0x09,0x2a,0xc3,0x68,0xd4,0x0c,0x2f,0x53,
    0x26,0x8b,0x81,0x31,0xd9,0x94,0x4e,0xa7,0x1b,0x0e,0x89,0xce,0x18,0x35,
    0x6e,0xde,0x70,0x33,0xab,0x24,0x8b,0x46,0x71,0xea,0x90,0xe8,0xea,0x65,
    0x8a,0xd1,0x81,0xd6,0x4d,0x11,0x83,0xd4,0x29,0x03,0x75,0x53,0xc4,0x64,
    0xb2,0x6c,0x0a,0x62,0x11,0x0a,0x13,0x32,0x14,0x14,0xc1,0x8d,0x81,0xc2,
    0x28,0x97,0xd6,0x72,0x79,0xf6,0xfd,0x95,0x46,0x84,0xce,0x37,0x79,0xd3,
    0x3f,0xcd,0xf9,0x9e,0x9e,0x9e,0xef,0xbc,0xbf,0x8b,0x4b,0x7f,0x7d,0x95,
    0x95,0xe7,0xbe,0x32,0x35,0x77,0x56,0xc4,0xf1,0xbc,0x59,0x89,0xd7,0xef,
    0xd5,0xc6,0x9e,0xbf,0x45,0xec,0xe5,0x12,0x16,0xef,0x3d,0xce,0x04,0xcd,
    0x3c,0x44,0x09,0x81,0x61,0xef,0x6a,0xdd,0xdc,0xdc,0x46,0x39,0x39,0xde,
    0x4f,0xbb,0x72,0x4a,0xc7,0x2f,0x3a,0xf9,0xdb,0x5e,0x4d,0x6a,0xc1,0x61,
    0xed,0x95,0x12,0x36,0x16,0x3e,0xe4,0x44,0xad,0x19,0xc3,0x63,0x2b,0xdf,
    0x34,0xd8,0xf0,0x50,0xa9,0xed,0x4c,0x87,0x15,0x03,0x55,0xa5,0x82,0xed,
    0xef,0x8c,0x95,0x98,0x5b,0x26,0x5f,0x72,0xba,0xc0,0x6f,0xd5,0x99,0x7c,
    0xc3,0xfc,0x8c,0xe2,0xfb,0xdb,0x8b,0x6a,0x38,0xf4,0x4f,0x0b,0x29,0xcd,
    0x4f,0xd1,0x35,0x76,0xf1,0x71,0x6d,0x37,0x11,0x45,0xcd,0x04,0xae,0xd0,
    0x32,0x48,0x35,0x18,0xc1,0xc1,0xcb,0xcb,0x0b,0x6f,0x6f,0x6f,0x5c,0x5d,
    0x5d,0x99,0xfc,0xce,0x9c,0xd5,0xce,0xb8,0xeb,0x33,0x0a,0xbe,0x5e,0x74,
    0xee,0x36,0xdb,0x8d,0xd5,0x9c,0x7d,0xda,0x45,0xa2,0x19,0x56,0xd7,0x76,
    0x30,0xdb,0xd4,0xc8,0xb4,0xdc,0x36,0x86,0x27,0xd7,0xa0,0xde,0x6d,0x24,
    0xec,0x13,0x2d,0x7a,0xbd,0x9e,0xb9,0x73,0xe7,0x92,0x98,0x98,0x48,0x66,
    0x66,0x26,0xe1,0xe1,0xe1,0xa8,0xfd,0xf7,0xa5,0x08,0x7c,0x68,0x5f,0x6e,
    0x44,0xca,0xef,0xcc,0x11,0x8c,0x15,0x7f,0x75,0x31,0xbf,0xb2,0x83,0x57,
    0x2f,0x3d,0xc2,0x4f,0x5f,0xca,0xc4,0xd3,0xb7,0x99,0x9a,0x51,0xc1,0xdb,
    0x86,0x62,0x56,0xdc,0xac,0xe4,0xb3,0xfd,0x07,0xd1,0x2c,0x8f,0x21,0x32,
    0xe9,0x07,0x16,0x24,0xa5,0x13,0xb9,0x78,0x19,0xd1,0xd1,0xd1,0x62,0x1e,
    0x46,0x61,0x2a,0x07,0x0c,0x60,0x7a,0x6f,0xae,0xf7,0xb1,0x9b,0xf8,0x96,
    0x74,0x33,0xf3,0xcf,0x6e,0x42,0x4a,0x3a,0x90,0x1f,0x29,0x65,0xe8,0xc1,
    0xbf,0x59,0x70,0xa3,0x9d,0x9d,0x2d,0x36,0x12,0x5a,0x6d,0x6c,0xff,0xd7,
    0xc6,0x9b,0x1b,0xe3,0x09,0xce,0x79,0xc0,0x94,0x42,0x2b,0x41,0xb7,0x2c,
    0x04,0x5d,0x28,0x27,0x60,0xb6,0xc4,0xbd,0x28,0x71,0x91,0xc9,0xee,0xc4,
    0x29,0x14,0x8a,0x00,0x07,0xd7,0xed,0x4c,0x35,0xee,0xd7,0x3a,0x09,0x2f,
    0xea,0x22,0xb4,0xb0,0x13,0x65,0x72,0x25,0x23,0xf4,0x4d,0x6c,0x6b,0xee,
    0xe0,0x60,0xbd,0x19,0x5d,0x4d,0x23,0x9f,0xe6,0x57,0x10,0xb9,0x3e,0x0e,
    0x8d,0xb1,0x95,0xc9,0x26,0xec,0x5e,0x6a,0x6a,0x21,0x6c,0xe9,0x6a,0xc1,
    0x5b,0x66,0xe7,0xba,0xb8,0xac,0x91,0xee,0xb2,0x41,0xcc,0xdc,0xde,0xf7,
    0x98,0xc3,0x45,0x0c,0x3e,0x61,0x41,0x7d,0xd4,0x82,0xef,0x81,0x76,0x86,
    0x24,0x3c,0x64,0xa8,0xbe,0x99,0x88,0x7c,0x33,0x6b,0xd3,0x2f,0xb1,0x23,
    0x2d,0x8b,0x51,0x3f,0x96,0x11,0xb6,0x6e,0x33,0xd9,0x8f,0x5a,0xd8,0x54,
    0x0d,0xfa,0x3a,0xb8,0xdf,0xde,0xc5,0x86,0x8d,0x26,0xc1,0x6d,0xc2,0xd3,
    0xff,0x71,0xe7,0xb8,0xd7,0xbf,0xf8,0x56,0xe0,0xea,0x84,0x8f,0x4a,0xdc,
    0x8f,0xe2,0xbf,0x0b,0x9a,0xb5,0xf3,0xe2,0x95,0xa1,0x09,0x45,0x4d,0x5e,
    0x09,0xc5,0x78,0xea,0x6b,0x50,0x9d,0xb0,0xe2,0x9b,0x6a,0x41,0x75,0xad,
    0x95,0x61,0x17,0xab,0x88,0xd8,0xf3,0x3d,0xc7,0x53,0x4f,0xd1,0xd1,0xd9,
    0x89,0xb5,0x0b,0x22,0xa3,0x40,0xad,0x06,0x0f,0x0f,0x50,0x2a,0x4b,0x90,
    0x4d,0x7d,0x9f,0x71,0xf1,0x69,0xc8,0x3d,0x95,0x4f,0x04,0xd2,0x2a,0x93,
    0xc9,0x3e,0x74,0xcc,0x43,0x66,0xb8,0x77,0xc3,0xed,0x97,0x2e,0x3c,0xb3,
    0x3a,0xf0,0x3e,0xf9,0x94,0x21,0x87,0x2c,0x78,0x65,0xd8,0x78,0x25,0xfd,
    0x36,0xcb,0x62,0x37,0x51,0x55,0x55,0x85,0x43,0xc7,0x8e,0xd1,0xf3,0xdf,
    0x21,0x36,0xf6,0x94,0x7d,0x97,0xe5,0xd3,0x3f,0x60,0x58,0x88,0xc6,0xfe,
    0x2c,0xb8,0x0b,0x1d,0x5c,0xf7,0x94,0x3f,0x26,0xba,0x66,0xb7,0x36,0x7a,
    0x5c,0xb0,0xe1,0x9d,0x26,0xb8,0x87,0x9f,0xcd,0xc5,0x7d,0xc6,0x42,0xb4,
    0x5a,0x2d,0x36,0x9b,0x8d,0xde,0xda,0xbd,0x1b,0x56,0xad,0x82,0xea,0xea,
    0x26,0x54,0x2a,0x95,0x9d,0xe7,0x3d,0x72,0x4c,0x3f,0xae,0x24,0x45,0x66,
    0x53,0x90,0x22,0xc3,0x5c,0x36,0x30,0xdd,0x8a,0x4f,0xb2,0x15,0xbf,0x3d,
    0xed,0x8c,0x7d,0x63,0x26,0x77,0xef,0xde,0xa5,0xaf,0xae,0x5e,0x05,0x9d,
    0x0e,0xac,0x56,0x2b,0x31,0x31,0x31,0x2f,0xe4,0xb0,0x2f,0x57,0x92,0xf2,
    0x54,0x5d,0xf0,0x20,0xfd,0xa3,0x6a,0xb5,0xde,0x8a,0x6a,0x79,0x3a,0xf3,
    0x16,0x2c,0xe9,0xc7,0x94,0xb4,0x65,0x0b,0xe4,0xe5,0x41,0xa7,0x98,0xb9,
    0x94,0x93,0x5e,0xdc,0x9b,0x22,0x93,0x81,0xce,0x32,0xe8,0xb3,0xaf,0x70,
    0xd4,0xe0,0x5d,0xc5,0x0f,0x94,0x6f,0xad,0x64,0x73,0x5c,0x9c,0x53,0xae,
    0x46,0xf3,0xec,0xb3,0xbb,0xbb,0x1b,0x83,0xc1,0x60,0xcf,0xb4,0x64,0xc7,
    0x3e,0xfc,0x9f,0x26,0x6e,0x4d,0x9b,0x3c,0x52,0x97,0x55,0xbc,0xe9,0x5c,
    0x0e,0x6d,0x6d,0x6d,0x2f,0x30,0x73,0x73,0x61,0xc7,0x8e,0x67,0xcf,0x15,
    0xed,0xdd,0xec,0x32,0x9c,0x27,0x20,0x20,0x80,0xd1,0xa3,0x47,0xb7,0xca,
    0xe5,0xf2,0x35,0x2f,0xe3,0x06,0x99,0x08,0x16,0xfb,0x5f,0x36,0xa3,0xb0,
    0x95,0xe4,0xec,0x5f,0x31,0x9b,0xcd,0xfd,0x7a,0x95,0xb4,0x53,0xbc,0x97,
    0xc6,0x24,0x5d,0xc6,0xdd,0x77,0x04,0xc3,0x17,0xad,0x6d,0x9e,0x62,0x62,
    0xa9,0x33,0xde,0xb4,0x12,0x7c,0x04,0x2f,0x5b,0xb8,0xce,0x9e,0x2d,0x91,
    0xc3,0x09,0x49,0x3f,0x11,0xbb,0x35,0xde,0xde,0xf7,0x91,0x23,0x70,0xf6,
    0xec,0x73,0xee,0xb6,0x1a,0x78,0xad,0xc0,0xc2,0xf8,0x2b,0x0f,0x99,0x74,
    0xbd,0x59,0xca,0x62,0x7a,0x68,0x09,0x5e,0x7d,0xb9,0xe2,0x7b,0x9d,0x23,
    0xab,0x0e,0x4f,0xca,0x6b,0x21,0xf4,0xcb,0x03,0x34,0x3c,0x7e,0x62,0xdf,
    0x01,0x69,0x17,0x24,0xd5,0xd7,0xd7,0x13,0x53,0x6e,0xa1,0x6f,0xbd,0xe8,
    0xb9,0xdf,0x8c,0x9d,0x71,0x25,0xbf,0x57,0x06,0x0f,0xac,0x50,0x5e,0x0e,
    0xeb,0xd6,0x41,0x7e,0x7e,0x3e,0xcb,0xd7,0xac,0x25,0xe8,0xe7,0x0a,0x67,
    0xdc,0xfd,0x4e,0xb8,0x9f,0x0b,0x1b,0x7b,0xdc,0xd0,0xbb,0x3e,0x68,0x83,
    0xae,0x28,0x2a,0x2a,0xca,0xe8,0xe3,0x53,0xde,0x2c,0xde,0xeb,0x46,0xe5,
    0xc8,0xb1,0xc6,0xc0,0x4b,0x55,0x6d,0xbd,0x6a,0x72,0x42,0x4a,0x51,0x47,
    0xdc,0x41,0xfe,0xb2,0xbb,0x13,0xbf,0x1b,0xdd,0xd3,0xbf,0x34,0xef,0x2c,
    0x71,0xc6,0x53,0xac,0x52,0x88,0x4c,0x46,0x42,0xaf,0x3e,0x36,0xf4,0x30,
    0xb3,0x83,0xc5,0xdd,0xbc,0x8c,0xd7,0x57,0x53,0x4d,0xf8,0x07,0x9b,0xf0,
    0x13,0xcc,0x71,0x12,0x53,0xa1,0x78,0x7e,0x5e,0xf4,0xe6,0x2e,0x76,0x47,
    0x23,0xd5,0xf4,0x3e,0xf3,0x1f,0x82,0x61,0xba,0xcb
};

// images/lock.png
static const unsigned char image_18_data[] = {
    0x00,0x00,0x05,0x10,0x78,0x9c,0xb5,0x92,0x49,0x4c,0x53,0x51,0x14,0x86,
    0xd9,0x18,0x8d,0xf3,0x3c,0x32,0x29,0x91,0xc4,0x85,0x9a,0x18,0x63,0x34,
    0x6e,0x5c,0x9b,0x38,0xec,0x00,0xc1,0x28,0xa2,0x71,0xeb,0xd2,0x95,0xc3,
    0xca,0x8d,0x24,0xad,0x50,0x8b,0x4f,0x23,0xa9,0x62,0x5b,0xdb,0x32,0xd4,
    0x4a,0x29,0xc5,0xa2,0x21,0x4d,0x07,0x2c,0x2d,0xad,0x98,0xa6,0x54,0x60,
    0x41,0xf3,0x22,0x44,0x20,0xc5,0xa6,0x2e,0x3f,0xef,0x03,0x42,0x62,0x9f,
    0xa5,0x1a,0xe3,0x4d,0xbe,0xdc,0x9b,0x7b,0xcf,0xff,0x9d,0xb3,0xb8,0x45,
    0x45,0xff,0x77,0x45,0x82,0x41,0xfc,0x2e,0x17,0x21,0x8f,0x67,0x01,0xe5,
    0x1c,0x16,0x77,0x7f,0xe3,0xf0,0x8b,0x5c,0x22,0x1c,0x26,0x33,0x3f,0x4f,
    0x36,0x9b,0x25,0x93,0xc9,0x90,0x9e,0x9b,0x23,0x3e,0x34,0x84,0xf2,0xf6,
    0x27,0x8e,0x50,0x20,0xc0,0x67,0xd1,0xf7,0x7b,0x3a,0x4d,0x3c,0x12,0xc1,
    0xd3,0xd1,0x41,0x9f,0xcd,0x46,0x70,0x60,0x80,0x6f,0xd3,0xd3,0x44,0x7d,
    0x3e,0x42,0x7e,0x7f,0x41,0xd7,0x07,0x87,0x83,0x69,0x59,0x26,0x3a,0x38,
    0x48,0x8f,0xc5,0xb2,0x5c,0xef,0x16,0xae,0x3e,0xbb,0x9d,0xc9,0x89,0x09,
    0x3c,0x5d,0x5d,0x05,0x3d,0xfd,0xa2,0xff,0xcc,0xcc,0x0c,0xdd,0x26,0x93,
    0xaa,0xd6,0xac,0xd7,0x33,0x9a,0x48,0xe0,0xb6,0x5a,0x0b,0x7a,0x7a,0xc5,
    0x0c,0xa9,0x54,0x0a,0x4b,0x4b,0x8b,0xaa,0xd6,0xa0,0xd1,0x10,0x8b,0xc5,
    0xe8,0x36,0x1a,0x0b,0x7a,0x5e,0x18,0x5e,0xe3,0xff,0x94,0xe4,0x71,0xd3,
    0x53,0x55,0xad,0xb6,0x51,0x87,0xdb,0x17,0xa1,0xf5,0x79,0x7e,0x8f,0x63,
    0x44,0xe6,0x7a,0x7b,0x92,0x5a,0x73,0x8c,0x06,0xc7,0x38,0xd5,0x6d,0xc3,
    0xdc,0x74,0x4d,0xfe,0x42,0xd5,0xcb,0x30,0xf5,0xf6,0x24,0x97,0x4c,0x51,
    0xae,0xd9,0xbe,0xa0,0x64,0x72,0x3d,0xf7,0x3a,0xa3,0xdc,0x1a,0x4f,0x53,
    0xf7,0x03,0x2e,0x0a,0x2e,0xac,0xc0,0xf9,0x2c,0x9c,0x1b,0x4e,0xa3,0x64,
    0x72,0x3d,0x77,0xdb,0xbc,0x9c,0x1d,0x99,0xe5,0xc4,0x14,0x2b,0xf3,0x15,
    0x0e,0xc7,0xa1,0xd8,0x38,0x8b,0x92,0xc9,0xf5,0xdc,0x79,0xe2,0xe4,0x8c,
    0x77,0x8a,0xa3,0xa3,0xe4,0xe5,0x48,0x02,0x2a,0x3f,0xc2,0xae,0x4e,0xd8,
    0xa9,0x9b,0x42,0xc9,0xa8,0x3c,0x8f,0x6c,0x9c,0x72,0xca,0x54,0x06,0x59,
    0xe6,0x60,0x60,0x09,0x3f,0x54,0x78,0xa1,0xa4,0x17,0xb6,0x19,0x61,0xb3,
    0x01,0xb6,0x36,0xca,0x28,0x19,0x95,0x47,0x6b,0xe5,0xb8,0x4d,0xa6,0xcc,
    0x03,0xe5,0xef,0x59,0xd8,0x95,0xdc,0x3e,0x27,0xec,0x79,0x23,0xfa,0xdb,
    0x60,0x4b,0x1b,0x6c,0x6a,0x85,0xf5,0x92,0xd8,0x1f,0x08,0x8f,0x56,0xfd,
    0x8f,0x94,0xbb,0x63,0x26,0x99,0xd2,0x77,0x8b,0xf9,0xbd,0x6f,0x61,0xb7,
    0x98,0x7f,0x87,0x55,0xf4,0x7e,0xb5,0x38,0xc3,0xc6,0x67,0xb0,0x4e,0x0f,
    0x6b,0x9a,0x84,0xeb,0x7e,0x7e,0xcf,0x69,0xe3,0x18,0xc5,0x3d,0x4b,0xfd,
    0xdb,0x61,0xbb,0x59,0x38,0x96,0x66,0xd8,0x20,0x66,0x58,0xab,0x83,0xd5,
    0x1a,0x58,0xf5,0x50,0xf8,0x6e,0x8f,0xfd,0xd6,0x23,0x59,0xfb,0x39,0x79,
    0xa3,0x99,0x8a,0x06,0x89,0x03,0xf5,0x12,0xfb,0xaf,0x0a,0xae,0x48,0x94,
    0x5f,0x96,0x28,0xab,0x13,0xd4,0x4a,0x94,0xd6,0x48,0x94,0x54,0x0b,0xaa,
    0x24,0x0e,0xd5,0x34,0xa3,0x64,0xd4,0x3f,0xf1,0xdf,0xd6,0x4f,0xf1,0x47,
    0x07,0x75
};

// images/ihu_talk.png
static const unsigned char image_19_data[] = {
    0x00,0x00,0x07,0x90,0x78,0x9c,0xa5,0x94,0x5d,0x48,0x53,0x61,0x18,0xc7,
    0xcf,0xd4,0xd9,0x52,0xd4,0x94,0x0a,0x0a,0x56,0x48,0x31,0x2a,0x2c,0x07,
    0xdd,0x24,0x91,0x2c,0x18,0x24,0xca,0x60,0x1b,0x45,0x04,0x1b,0x5e,0x68,
    0x4e,0x90,0xc4,0x1b,0xcb,0xb4,0x82,0x8c,0x62,0x12,0x94,0x74,0xb1,0xdc,
    0x76,0x25,0x5d,0x38,0xce,0x12,0xfb,0x6e,0xe9,0x8d,0x5d,0x94,0x5a,0x1b,
    0xb2,0x20,0x07,0x8a,0x4b,0xfb,0x00,0xd9,0x2a,0x71,0x73,0x7a,0xb2,0x6d,
    0xff,0xde,0xf7,0xb8,0xe5,0x74,0xab,0x1d,0xf5,0x79,0xf8,0xf3,0x9e,0x8f,
    0xf7,0xfc,0x78,0xce,0x73,0x9e,0xff,0x61,0xc0,0xa4,0x4d,0x91,0x48,0x64,
    0x65,0x98,0xf4,0xfb,0xd6,0x95,0x0c,0xf3,0x93,0x67,0xae,0x68,0x70,0xb3,
    0xcc,0xcc,0xcc,0x4c,0x63,0x5e,0x5e,0x5e,0x38,0x2b,0x2b,0x0b,0xb9,0xb9,
    0xb9,0xc8,0xcf,0xcf,0xa7,0xd7,0x36,0x5d,0xab,0x42,0xa1,0x60,0x2d,0x16,
    0x0b,0x2a,0x2b,0x2b,0xd1,0xd9,0xd9,0x89,0xbe,0xbe,0x3e,0x94,0x97,0x97,
    0x93,0xbe,0xdc,0xbb,0x44,0xf0,0x65,0x1b,0xe5,0xd6,0xd4,0xd4,0xb0,0xca,
    0x6a,0x03,0x54,0x26,0x16,0xa7,0x4d,0x3d,0x50,0x9d,0xd3,0x43,0xab,0xd5,
    0x92,0x5e,0x38,0x89,0x30,0xb9,0x51,0xee,0xce,0x13,0x15,0xec,0xd1,0xfe,
    0x29,0x94,0xba,0x38,0xc8,0xdf,0x2f,0x42,0xfe,0xc4,0x03,0xe9,0x29,0xca,
    0x7d,0x4a,0xb9,0xa4,0xee,0x8f,0xad,0x1b,0xe1,0xca,0xd4,0x7a,0x56,0xe9,
    0x9c,0xc7,0x11,0x37,0x78,0xe9,0xdc,0x41,0x1c,0xd7,0x9d,0x27,0x3c,0x3d,
    0xcf,0x65,0x98,0x3a,0xfa,0x1d,0xfd,0xeb,0xe5,0x56,0x55,0x55,0xb1,0x8e,
    0x6f,0x41,0xb4,0x4c,0x03,0x96,0x19,0xe0,0xd3,0x42,0x04,0xcd,0x17,0xdd,
    0x84,0x3b,0x4b,0xb9,0x6f,0x33,0x32,0x0c,0x67,0x08,0x77,0x86,0xc8,0x2c,
    0xb8,0x56,0x99,0xac,0xba,0xbb,0xbb,0xfb,0xd7,0xef,0x70,0x18,0x5c,0x04,
    0x50,0xa9,0x81,0xc2,0x42,0x40,0x22,0x01,0x72,0x72,0x3e,0x10,0xee,0xb6,
    0x01,0x89,0x44,0xb2,0x9d,0x30,0x27,0x89,0x38,0xa1,0x5c,0x9d,0x4e,0xd7,
    0xeb,0xf5,0x7a,0x11,0x0f,0xab,0x15,0xb1,0x77,0x07,0x9a,0x9a,0x1e,0xf0,
    0xb3,0x4c,0xfc,0xd2,0x4b,0x56,0x93,0x50,0xcf,0x88,0xc5,0x62,0x7b,0x63,
    0x63,0x23,0x96,0x96,0x96,0x90,0x18,0x1d,0x1d,0x40,0x6d,0x2d,0x30,0x3d,
    0x3d,0x8b,0x82,0x82,0x82,0xb8,0x4f,0x5c,0x42,0xb9,0xa4,0x07,0x93,0x13,
    0x13,0x13,0x58,0x1b,0x03,0x03,0x80,0xd1,0x08,0x70,0x1c,0x07,0x83,0xc1,
    0x80,0x55,0x3e,0x4c,0x93,0xe4,0xdd,0xb4,0x1a,0x8d,0x66,0x36,0x09,0x4a,
    0xa2,0xad,0x0d,0x18,0x1a,0x02,0xc2,0xa4,0xe7,0xd4,0x27,0x09,0xdc,0x91,
    0x74,0xdc,0x8c,0x2d,0x5b,0xcd,0x97,0x5b,0x5b,0x53,0x61,0xa1,0x54,0x2e,
    0xaf,0xd1,0x68,0x14,0x36,0x9b,0x8d,0xf7,0x34,0xef,0x6b,0x01,0xf3,0xb0,
    0xf7,0x36,0x6b,0x6e,0x79,0xd8,0x8f,0x50,0x28,0xb4,0x8a,0x39,0x38,0x08,
    0xb4,0xb7,0x2f,0x1f,0x8f,0x2f,0x44,0x71,0xcb,0xf6,0x18,0x52,0xa9,0x14,
    0xc5,0xc5,0xc5,0xf3,0xd9,0xd9,0xd9,0x75,0xe9,0xb8,0x64,0xfe,0xc7,0x4e,
    0xba,0xe6,0x71,0xdf,0xf1,0x1a,0x81,0x40,0x20,0xa9,0x56,0x1a,0x37,0xbf,
    0x46,0xb1,0xcf,0xf4,0x12,0xe2,0x1d,0xbb,0xb1,0xeb,0x6c,0xfd,0x5c,0xa9,
    0x1b,0xba,0xff,0xf0,0x1c,0x44,0x33,0xbc,0xb7,0x46,0x23,0x38,0x64,0x7a,
    0x86,0xa6,0xab,0xd7,0xf9,0xba,0xbb,0xba,0x00,0xbb,0x7d,0x85,0x7b,0xed,
    0x0b,0x70,0xf8,0xdd,0x22,0x0e,0xbe,0xfa,0x8c,0x92,0x37,0x73,0xf4,0xd9,
    0x9e,0x7f,0x30,0x8d,0x71,0xaf,0xc6,0x55,0x32,0x14,0x44,0xd9,0x95,0xbb,
    0xf0,0x7f,0xff,0xc1,0xcf,0x00,0x9d,0x05,0x1a,0x3e,0x9f,0x0f,0x06,0xcf,
    0x22,0xd6,0xee,0x27,0x35,0x27,0xf5,0x38,0x15,0x97,0xaa,0x62,0x0c,0x98,
    0xe2,0x00,0x8f,0x07,0x68,0x68,0x00,0x86,0x87,0x87,0x51,0x5d,0x57,0x0f,
    0xf9,0xf3,0xf1,0x54,0xdc,0x3b,0x29,0xb8,0x17,0x88,0x9c,0x31,0xf9,0x13,
    0xf7,0xcb,0x9b,0x8d,0xa3,0x6a,0xb5,0xda,0x59,0x54,0xe4,0x99,0x23,0xff,
    0x75,0x67,0xce,0x9e,0xfd,0xce,0x03,0x2f,0xbc,0xa1,0x84,0x3d,0xfd,0xc2,
    0x5c,0xf1,0xb7,0x7e,0xda,0xef,0x47,0xf4,0x9c,0x8c,0xd2,0x31,0x91,0x08,
    0x37,0x12,0xee,0x37,0xc7,0x98,0x0e,0xa1,0xcc,0x54,0x99,0xc8,0x14,0x9a,
    0x7f,0x00,0xf7,0xb5,0x40,0x6c
};

// images/ihu_alarm.png
static const unsigned char image_20_data[] = {
    0x00,0x00,0x07,0x90,0x78,0x9c,0xed,0xd4,0x7f,0x4c,0xd4,0x65,0x00,0xc7,
    0x71,0x0d,0xd1,0xc8,0xf8,0xcd,0xa5,0xe1,0x6a,0xcc,0x72,0xd0,0xfa,0x47,
    0x73,0xeb,0x17,0x5b,0x6c,0xd2,0x62,0xb5,0x45,0x61,0xb8,0xfc,0xc3,0x4d,
    0x47,0xab,0x69,0x7f,0x84,0xab,0x65,0x6b,0x4b,0xa8,0x4e,0x0b,0xd3,0x22,
    0x26,0xf3,0xf0,0xcb,0x1a,0x48,0x2a,0x18,0x1e,0x3b,0x8f,0xe4,0x3c,0x04,
    0x41,0x52,0x02,0x0e,0xb8,0xe3,0x60,0x98,0x08,0x01,0xde,0x9d,0xc2,0x1d,
    0x1d,0x77,0xe7,0xf7,0x7e,0x7d,0xef,0xc7,0xbb,0x6f,0xf3,0x5f,0x60,0xac,
    0xd6,0x5f,0xf5,0x6c,0x9f,0x3d,0x7f,0x3d,0xaf,0x7d,0x9e,0x67,0xcf,0xf3,
    0xac,0x58,0xf1,0x6f,0x0d,0xf8,0x3f,0xcb,0xcf,0xfe,0x0b,0x06,0xf6,0xeb,
    0xcc,0x7c,0x7c,0x69,0x88,0xf7,0xcf,0x77,0xff,0x23,0xeb,0x03,0xbd,0x99,
    0x03,0x03,0xb7,0xa9,0xb1,0x7a,0x68,0x98,0x0b,0xf0,0xad,0x43,0xe2,0xc0,
    0x9d,0x20,0xaf,0x99,0xdd,0x6c,0xd4,0x5b,0x78,0xee,0x44,0x9b,0x7d,0xb9,
    0x56,0x81,0xda,0x34,0x59,0x6a,0xb4,0x70,0x7c,0xf6,0x1e,0xb5,0xee,0x20,
    0x65,0xce,0x08,0x7b,0xac,0x51,0x72,0x8d,0x6e,0xb6,0x1b,0x67,0xd8,0xda,
    0x37,0x47,0xa6,0xc1,0xc7,0xeb,0x63,0x10,0xdf,0x3c,0xc3,0x16,0xe5,0x4f,
    0x8e,0xa5,0xbc,0xb7,0xcf,0x0f,0x52,0xda,0x3f,0x4d,0x63,0x30,0xc2,0xf7,
    0x1e,0x78,0xd7,0x1a,0x22,0x6f,0xc8,0xc9,0xb3,0x9d,0x5e,0x1e,0x55,0x59,
    0x48,0x3e,0xd2,0xcf,0x96,0xd3,0x06,0xf2,0x0d,0x36,0xb2,0x0c,0x7e,0xe2,
    0xaf,0x86,0x49,0xf9,0x41,0x64,0x53,0x89,0x6e,0x51,0x33,0xb7,0xf6,0x1a,
    0xaf,0xca,0x46,0xd1,0x9d,0x08,0x05,0x13,0x21,0x32,0x5b,0x6c,0xac,0x13,
    0x86,0x79,0xfa,0xec,0x20,0xcf,0xa8,0xc7,0xc8,0x69,0x30,0x51,0xd4,0x3b,
    0xc1,0x27,0x96,0x3f,0xf8,0xdc,0x1b,0xa1,0x78,0x46,0x22,0xcf,0x24,0x91,
    0x7e,0x64,0x78,0xc9,0xbd,0x27,0x54,0xf7,0xa2,0x30,0x47,0xd9,0x76,0x33,
    0xca,0xf3,0xe6,0x10,0xab,0xab,0x86,0x49,0xab,0xb8,0x4b,0x61,0xb7,0x8f,
    0xc3,0xf7,0x24,0x94,0xa2,0x44,0xa9,0x4b,0x9e,0x67,0x45,0xde,0x1b,0xb1,
    0x21,0x5c,0xbc,0x4c,0x71,0xe7,0x08,0xeb,0xdb,0x66,0xd9,0xf8,0xd9,0x29,
    0xef,0x62,0xee,0xaa,0x73,0xd3,0xc4,0x76,0x84,0x79,0xc9,0x18,0xe1,0x85,
    0x81,0x30,0x0f,0xa9,0x26,0x48,0x17,0xe6,0x29,0x71,0x87,0xa8,0xb0,0x7b,
    0x28,0xb3,0x38,0xd9,0xd7,0x33,0x86,0xa0,0xbe,0x48,0x8e,0xfe,0x26,0x8f,
    0xd7,0x1b,0x79,0xf1,0x5c,0x3f,0x6f,0xf4,0xd9,0x79,0xa4,0xc5,0x42,0x56,
    0x99,0x7a,0x41,0xf7,0x89,0x4a,0x23,0x49,0x35,0x7e,0x92,0x4f,0xfa,0x51,
    0x94,0xfb,0x48,0x55,0xde,0x26,0x4d,0x70,0x93,0xdb,0xe3,0x61,0x6f,0x7d,
    0x0b,0x5f,0x9e,0xd1,0x90,0xd1,0x34,0xca,0x86,0xc6,0x11,0x0a,0xae,0x4e,
    0x92,0x33,0xe0,0x22,0xbb,0xb6,0x9d,0x43,0x75,0x6a,0x36,0x6b,0x86,0x89,
    0xd1,0xcf,0xf1,0x54,0xc9,0x69,0xd7,0x62,0xbd,0xd3,0x94,0xc6,0xf9,0xb5,
    0x4a,0x13,0x71,0x82,0x85,0xc4,0x9a,0x00,0x8a,0x3a,0x3f,0x89,0x1d,0x22,
    0xeb,0x9b,0x7f,0x97,0xcf,0xc4,0xca,0x93,0x5d,0x0e,0x76,0x9e,0x6c,0xa4,
    0xa8,0xb1,0x0b,0xc5,0x15,0x07,0x6b,0x74,0x77,0xd9,0xd1,0x3a,0xc2,0xae,
    0xeb,0x93,0xc4,0xb6,0xcf,0x93,0x79,0x54,0xbb,0xa0,0xbb,0xb2,0x61,0xbc,
    0x7b,0xd5,0x95,0x08,0x71,0x9a,0x10,0x09,0xa7,0x82,0xa4,0x1e,0xf7,0xb3,
    0x56,0x2d,0xf1,0x98,0xf6,0x16,0xbb,0xab,0xb5,0x64,0x69,0x7e,0x23,0xa6,
    0xc3,0xcd,0x66,0xfd,0x24,0x1f,0xf6,0x4d,0xb3,0xe1,0xda,0x3c,0xd9,0x75,
    0x1d,0x14,0xfe,0xd8,0x46,0xec,0x2f,0x22,0x29,0xed,0x0e,0xb2,0xbf,0x3e,
    0xbb,0xa0,0x1d,0x73,0x49,0x74,0x3e,0xa8,0x95,0x48,0x38,0x23,0xbb,0x95,
    0xf7,0xcf,0x65,0x75,0xab,0xdc,0x5d,0x6f,0x63,0x5f,0xe7,0x0d,0x76,0xff,
    0x3a,0x45,0x86,0xe6,0x06,0x3b,0x04,0x2d,0xa9,0x4d,0xe3,0xc4,0xf5,0x04,
    0x58,0xd7,0x2b,0xb2,0xdd,0x1a,0xa6,0xc4,0x1b,0xe5,0x95,0xaa,0x85,0x3b,
    0xff,0x95,0x35,0x6a,0xcf,0xe8,0xc3,0xf5,0x01,0x52,0x54,0xf2,0x9a,0x6f,
    0x7c,0x28,0x2a,0x7c,0x24,0xea,0x1c,0x6c,0x3b,0xd1,0xc4,0xcb,0xd5,0x3a,
    0x1e,0xb8,0xee,0x27,0x69,0x30,0xcc,0xd6,0x5b,0x11,0xde,0x99,0x83,0x72,
    0x09,0x54,0x91,0x28,0x87,0xec,0x2e,0xf2,0x55,0x9a,0x25,0xef,0x5e,0xbc,
    0x60,0x9b,0x4e,0x16,0xe4,0x9e,0xc7,0x7c,0xa4,0x7f,0xe1,0x25,0xb1,0xd6,
    0xcf,0xca,0x56,0x27,0xc9,0x5d,0x2e,0xf2,0xa6,0xc2,0x14,0xbb,0xee,0x7b,
    0x55,0x51,0x38,0xea,0xf2,0xf2,0xd6,0xcf,0x06,0x0a,0x1b,0xba,0x2e,0x2c,
    0xe7,0x4d,0x27,0x7d,0x65,0x9a,0x52,0x1c,0x73,0xc8,0xae,0x48,0xc6,0x61,
    0x91,0x37,0x87,0xc2,0x94,0x05,0xa1,0x52,0xee,0x56,0xee,0x0d,0x70,0x70,
    0x6a,0x96,0x02,0x4d,0x8f,0x3d,0x5f,0xd5,0x6c,0xfa,0x3b,0xff,0x4f,0xda,
    0xa7,0xa3,0xce,0x4d,0x07,0xdd,0x7c,0x64,0x96,0xf8,0x4e,0xf4,0xb3,0xb7,
    0x7f,0x9c,0x9d,0x97,0x87,0x96,0xd5,0xed,0xbf,0x9e,0x3f,0x01,0xf3,0x6e,
    0x49,0xc4
};

// images/pause.png
static const unsigned char image_21_data[] = {
    0x00,0x00,0x04,0x00,0x78,0x9c,0x63,0x60,0xa0,0x2a,0x60,0x04,0x62,0x66,
    0x20,0x66,0x81,0x62,0x26,0xa8,0x18,0x2e,0x71,0x14,0xbd,0xb7,0xee,0xed,
    0xf8,0x7f,0xed,0xf6,0xe6,0xff,0xc7,0xcf,0xcd,0xf8,0xdf,0xda,0x13,0xff,
    0x1f,0x28,0x26,0x04,0xc4,0x1c,0x38,0xc4,0xd9,0xd0,0xcc,0x60,0xbe,0x72,
    0x6b,0xc3,0xff,0x1f,0x3f,0xbe,0xfe,0xff,0xf6,0xed,0xe3,0xff,0x8a,0x06,
    0x7f,0x90,0x3a,0x3d,0x20,0x16,0xc5,0x21,0x2e,0x04,0x75,0x07,0x0c,0xb0,
    0x9c,0xbf,0xba,0x12,0xa8,0xee,0xf3,0xff,0xc7,0xcf,0x8f,0xfc,0xcf,0x2d,
    0x75,0x05,0xa9,0xb3,0x03,0x62,0x69,0x1c,0xe2,0x12,0x50,0x3f,0xc1,0xf5,
    0x9f,0xb9,0xb4,0xf0,0xff,0xf7,0xef,0x9f,0xfe,0xdf,0x7b,0xbc,0xe7,0x7f,
    0x6a,0xb6,0x39,0x48,0x9d,0x03,0x10,0xcb,0xe0,0x10,0x97,0x44,0xd7,0x7f,
    0x0c,0xe8,0xbf,0xcf,0x5f,0xde,0xfd,0xbf,0x76,0x6b,0xdd,0xff,0xd8,0x64,
    0x2d,0x90,0x3a,0x47,0x20,0x96,0xc5,0x22,0x8e,0x55,0xff,0xc1,0x53,0x13,
    0xfe,0xbf,0xff,0xf8,0xf8,0xff,0xd1,0xb3,0xd3,0xff,0x07,0x46,0xc9,0xc2,
    0xf5,0x63,0x11,0xc7,0xaa,0x7f,0xdf,0xb1,0xf6,0xff,0x8f,0x9e,0x1e,0xfb,
    0xbf,0x61,0x57,0xd1,0x7f,0xbf,0x30,0x29,0xb8,0x7e,0x2c,0xe2,0x58,0xf5,
    0x6f,0xd9,0x5f,0xf5,0xff,0xf4,0xc5,0xe9,0xff,0xe7,0xaf,0xf4,0x41,0xd1,
    0x8f,0x45,0x1c,0xab,0xfe,0x35,0x5b,0xf3,0xfe,0x6f,0xd9,0x9f,0xfb,0xbf,
    0x77,0x96,0xcd,0x7f,0xaf,0x60,0x49,0xb8,0x7e,0x2c,0xe2,0x58,0xf5,0x2f,
    0x5a,0x9d,0xfc,0x7f,0xea,0xbc,0x90,0xff,0x39,0xe5,0x6a,0xc8,0xea,0x64,
    0x70,0x88,0x63,0xe8,0xef,0x9b,0x1e,0xf4,0x3f,0x33,0xcf,0x0a,0xec,0x46,
    0xa8,0x3a,0x70,0xfc,0xe3,0x10,0x47,0x8f,0x7f,0x10,0x1b,0x94,0xa6,0xf4,
    0xa0,0xf2,0x76,0x50,0xb6,0x28,0x14,0xa3,0x8b,0xa3,0xa7,0x3f,0x50,0x5a,
    0x66,0x83,0x8a,0x4b,0x40,0x31,0x38,0xfd,0x43,0x31,0xba,0x38,0x7a,0xfa,
    0x87,0x99,0xc1,0x04,0x75,0x0b,0x33,0x03,0x6a,0xfe,0xc3,0x26,0xce,0x00,
    0x00,0x76,0x53,0x01,0xb9
};

// images/stop.png
static const unsigned char image_22_data[] = {
    0x00,0x00,0x04,0x00,0x78,0x9c,0xad,0x93,0xdd,0x4b,0x93,0x61,0x18,0x87,
    0x95,0xe9,0x41,0x7f,0x81,0x87,0x1a,0x52,0x04,0x65,0x44,0x07,0x15,0x61,
    0x11,0x1e,0x48,0xa5,0xc4,0x86,0x92,0x4a,0xa1,0x82,0x35,0x5b,0x52,0x39,
    0x14,0x96,0x64,0x0c,0xb5,0xd4,0x3e,0x74,0x41,0xe6,0x30,0x53,0xf3,0x03,
    0x37,0x49,0x5b,0xae,0xa6,0xf9,0x51,0x73,0x9b,0x4e,0x1c,0x2d,0x9d,0xd2,
    0x2c,0x8b,0x46,0x25,0x86,0x88,0xb6,0xe6,0xf4,0xf4,0xea,0x9d,0xbd,0x86,
    0xd0,0xab,0x10,0x74,0xc3,0x75,0xf4,0xdc,0xd7,0xcd,0xf3,0xf1,0x7b,0xc2,
    0xc2,0xfe,0x5b,0x85,0x0b,0xc8,0x04,0x22,0x44,0x22,0x25,0x58,0x5f,0x93,
    0x89,0xfd,0x7f,0xdc,0x19,0xb7,0x85,0x69,0x97,0x89,0xc9,0xe1,0x0e,0x26,
    0xec,0xad,0xb8,0x5f,0x3d,0xc2,0xd5,0xa7,0x67,0xf4,0xc5,0x3d,0x1c,0xa6,
    0x4a,0xac,0x9d,0xa5,0x98,0x1b,0x35,0xdc,0xd5,0xe6,0x20,0xf4,0x47,0x09,
    0x6c,0xdb,0x30,0x43,0xe6,0x1d,0xeb,0x62,0x75,0x65,0x79,0x8d,0x95,0x60,
    0x40,0xc0,0x4f,0x30,0xf0,0x83,0xe5,0xc0,0x12,0xfe,0xc5,0x79,0x16,0x17,
    0xe6,0x98,0x1a,0x69,0xa7,0xa4,0x20,0x35,0xe4,0xc7,0x8b,0x33,0x64,0xa2,
    0x1f,0xe1,0x71,0xb4,0xb3,0x1a,0xfc,0xc9,0xf7,0xcf,0x2e,0xe6,0x3e,0x8e,
    0x32,0xfb,0xc1,0xc1,0xb7,0xe9,0x21,0x7c,0x53,0xfd,0xcc,0xb8,0x9f,0x33,
    0x3e,0x58,0x83,0xb9,0x5e,0x85,0x46,0x75,0x32,0xe4,0xcb,0x05,0xa2,0xc5,
    0xb3,0x84,0x2a,0xf2,0xad,0xb5,0x89,0x95,0x65,0xbf,0xe0,0x8e,0x30,0xfb,
    0xde,0xc6,0x57,0xaf,0x15,0xdf,0xe4,0x4b,0x66,0xde,0x74,0x33,0x69,0x6b,
    0x66,0xc8,0xa0,0xc1,0x58,0x95,0xc1,0xe5,0xcc,0x23,0x21,0x3f,0x45,0x20,
    0x46,0xbc,0x93,0x35,0xdf,0xd5,0xaf,0x27,0xe0,0x5f,0x10,0x9c,0x1e,0x7c,
    0x9e,0x1e,0x3e,0x4d,0x58,0xf0,0x3a,0x9f,0xe0,0x71,0xb4,0x61,0x7b,0x5a,
    0x89,0x59,0x9f,0x43,0x63,0x69,0x12,0xb9,0xa9,0xfb,0x24,0x7d,0xa7,0x45,
    0xc7,0xd2,0xbc,0x0f,0xef,0x70,0x33,0xef,0x46,0x5a,0x18,0x7f,0xfd,0x90,
    0xb1,0xbe,0x5a,0xec,0xcf,0xaa,0xb0,0x34,0x15,0x62,0xb8,0x73,0x8a,0xaa,
    0x82,0x78,0x32,0x93,0x62,0x25,0x7d,0xbb,0xa9,0x82,0x2f,0x5e,0x3b,0x2e,
    0x73,0x19,0xce,0xee,0x9b,0x58,0x3b,0xb4,0xf4,0xb6,0x14,0xd2,0xf5,0x40,
    0x49,0xdb,0x6d,0x05,0xf5,0xd7,0x8e,0x72,0x43,0x19,0xc7,0x99,0xe3,0x31,
    0x92,0xfe,0x80,0xa1,0x18,0x77,0x7f,0x2d,0x83,0xad,0x6a,0x7a,0x9b,0x2e,
    0xd2,0x59,0x93,0x85,0xe1,0x96,0x9c,0xe6,0xd2,0x44,0xf4,0x45,0x87,0xd1,
    0x5d,0xd9,0x4f,0x71,0xf6,0xee,0x4d,0x7d,0x73,0x83,0x9a,0x81,0x96,0x7c,
    0xba,0xeb,0x94,0x18,0xab,0xd3,0x78,0x5c,0x9e,0x4c,0xdd,0xf5,0x04,0xaa,
    0xf3,0x0f,0x52,0x91,0xb7,0x17,0xed,0xf9,0x3d,0xa8,0xd3,0x77,0x91,0x9e,
    0x18,0x2d,0xe9,0x1b,0xef,0xe7,0xd2,0x50,0x9e,0x8e,0xee,0x6a,0x32,0x15,
    0xea,0x04,0xca,0x54,0x87,0x28,0xca,0xfa,0xed,0x5c,0x4a,0xdb,0xc9,0x05,
    0xc5,0x0e,0x94,0x8a,0xd8,0xcd,0xfc,0x08,0x7d,0xc9,0x69,0xd4,0xd9,0xc7,
    0xc8,0xcb,0x38,0xc0,0x39,0x45,0x1c,0x67,0x4f,0x6c,0x5f,0xdb,0x6b,0x88,
    0x90,0xb3,0x11,0x89,0xf7,0x97,0x89,0x79,0x8a,0x17,0xd7,0x52,0xb6,0x40,
    0x2e,0x91,0xbf,0x70,0x31,0xcf,0x51,0xe2,0xdc,0x98,0x2d,0x88,0x0e,0xfb,
    0x3b,0xff,0xeb,0x33,0xfe,0xf9,0xff,0xfd,0x02,0x57,0x8a,0x59,0x08
};

static struct EmbedImage {
    int width, height, depth;
    const unsigned char *data;
    ulong compressed;
    int numColors;
    const QRgb *colorTable;
    bool alpha;
    const char *name;
} embed_image_vec[] = {
    { 16, 16, 32, (const unsigned char*)image_1_data, 402, 0, 0, TRUE, "configure.png" },
    { 16, 16, 32, (const unsigned char*)image_2_data, 59, 0, 0, TRUE, "call.png" },
    { 16, 16, 32, (const unsigned char*)image_3_data, 50, 0, 0, TRUE, "hangup.png" },
    { 32, 32, 32, (const unsigned char*)image_4_data, 483, 0, 0, TRUE, "ihu.png" },
    { 18, 18, 32, (const unsigned char*)image_5_data, 145, 0, 0, TRUE, "green.png" },
    { 18, 18, 32, (const unsigned char*)image_6_data, 147, 0, 0, TRUE, "red.png" },
    { 18, 18, 32, (const unsigned char*)image_7_data, 479, 0, 0, TRUE, "open.png" },
    { 16, 16, 32, (const unsigned char*)image_8_data, 250, 0, 0, TRUE, "mic.png" },
    { 16, 16, 32, (const unsigned char*)image_9_data, 145, 0, 0, TRUE, "speaker.png" },
    { 16, 16, 32, (const unsigned char*)image_10_data, 246, 0, 0, TRUE, "mic_mute.png" },
    { 16, 16, 32, (const unsigned char*)image_11_data, 155, 0, 0, TRUE, "speaker_mute.png" },
    { 16, 16, 32, (const unsigned char*)image_12_data, 382, 0, 0, TRUE, "bell.png" },
    { 22, 22, 32, (const unsigned char*)image_13_data, 1008, 0, 0, TRUE, "phone.png" },
    { 22, 22, 32, (const unsigned char*)image_14_data, 873, 0, 0, TRUE, "phone_no.png" },
    { 16, 16, 32, (const unsigned char*)image_15_data, 88, 0, 0, TRUE, "save.png" },
    { 22, 22, 32, (const unsigned char*)image_16_data, 791, 0, 0, TRUE, "ihu_tray.png" },
    { 22, 22, 32, (const unsigned char*)image_17_data, 1186, 0, 0, TRUE, "ihu_wait.png" },
    { 18, 18, 32, (const unsigned char*)image_18_data, 548, 0, 0, TRUE, "lock.png" },
    { 22, 22, 32, (const unsigned char*)image_19_data, 706, 0, 0, TRUE, "ihu_talk.png" },
    { 22, 22, 32, (const unsigned char*)image_20_data, 828, 0, 0, TRUE, "ihu_alarm.png" },
    { 16, 16, 32, (const unsigned char*)image_21_data, 341, 0, 0, TRUE, "pause.png" },
    { 16, 16, 32, (const unsigned char*)image_22_data, 559, 0, 0, TRUE, "stop.png" },
    { 0, 0, 0, 0, 0, 0, 0, 0, 0 }
};

static QImage uic_findImage( const QString& name )
{
    for (int i=0; embed_image_vec[i].data; i++) {
	if ( QString::fromUtf8(embed_image_vec[i].name) == name ) {
	    QByteArray baunzip;
	    baunzip = qUncompress( embed_image_vec[i].data,
		embed_image_vec[i].compressed );
	    QImage img((uchar*)baunzip.data(),
			embed_image_vec[i].width,
			embed_image_vec[i].height,
			embed_image_vec[i].depth,
			(QRgb*)embed_image_vec[i].colorTable,
			embed_image_vec[i].numColors,
			QImage::BigEndian
		);
	    img = img.copy();
	    if ( embed_image_vec[i].alpha )
		img.setAlphaBuffer(TRUE);
	    return img;
        }
    }
    return QImage();
}

class MimeSourceFactory_ihu : public QMimeSourceFactory
{
public:
    MimeSourceFactory_ihu() {}
    ~MimeSourceFactory_ihu() {}
    const QMimeSource* data( const QString& abs_name ) const {
	const QMimeSource* d = QMimeSourceFactory::data( abs_name );
	if ( d || abs_name.isNull() ) return d;
	QImage img = uic_findImage( abs_name );
	if ( !img.isNull() )
	    ((QMimeSourceFactory*)this)->setImage( abs_name, img );
	return QMimeSourceFactory::data( abs_name );
    };
};

static QMimeSourceFactory* factory = 0;

void qInitImages_ihu()
{
    if ( !factory ) {
	factory = new MimeSourceFactory_ihu;
	QMimeSourceFactory::defaultFactory()->addFactory( factory );
    }
}

void qCleanupImages_ihu()
{
    if ( factory ) {
	QMimeSourceFactory::defaultFactory()->removeFactory( factory );
	delete factory;
	factory = 0;
    }
}

class StaticInitImages_ihu
{
public:
    StaticInitImages_ihu() { qInitImages_ihu(); }
    ~StaticInitImages_ihu() { qCleanupImages_ihu(); }
};

static StaticInitImages_ihu staticImages;
