#line 1034 "ifupdown.nw"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <assert.h>
#line 1045 "ifupdown.nw"
#include "header.h"
#line 1264 "ifupdown.nw"
#include <errno.h>
#line 1398 "ifupdown.nw"
#include <ctype.h>
#line 1241 "ifupdown.nw"
static int get_line(char **result, size_t *result_len, FILE *f, int *line);
#line 1468 "ifupdown.nw"
static char *next_word(char *buf, char *word, int maxlen);
#line 1705 "ifupdown.nw"
static address_family *get_address_family(address_family *af[], char *name);
#line 1740 "ifupdown.nw"
static method *get_method(address_family *af, char *name);
#line 1801 "ifupdown.nw"
static int duplicate_if(interface_defn *ifa, interface_defn *ifb);
#line 1920 "ifupdown.nw"
allowup_defn *get_allowup(allowup_defn **allowups, char *name);

#line 1958 "ifupdown.nw"
allowup_defn *add_allow_up(char *filename, int line,
	 allowup_defn *allow_up, char *iface_name);
#line 1175 "ifupdown.nw"
interfaces_file *read_interfaces(char *filename) {
	
#line 1211 "ifupdown.nw"
FILE *f;
int line;
#line 1248 "ifupdown.nw"
char *buf = NULL;
size_t buf_len = 0;
#line 1448 "ifupdown.nw"
interface_defn *currif = NULL;
mapping_defn *currmap = NULL;
enum { NONE, IFACE, MAPPING } currently_processing = NONE;
#line 1459 "ifupdown.nw"
char firstword[80];
char *rest;
#line 1177 "ifupdown.nw"
	interfaces_file *defn;

	
#line 1196 "ifupdown.nw"
defn = malloc(sizeof(interfaces_file));
if (defn == NULL) {
	return NULL;
}
defn->allowups = NULL;
defn->mappings = NULL;
defn->ifaces = NULL;
#line 1180 "ifupdown.nw"
	
#line 1216 "ifupdown.nw"
f = fopen(filename, "r");
if ( f == NULL ) return NULL;
line = 0;

#line 1182 "ifupdown.nw"
	while (
#line 1256 "ifupdown.nw"
get_line(&buf,&buf_len,f,&line)
#line 1182 "ifupdown.nw"
                                             ) {
		
#line 1495 "ifupdown.nw"
rest = next_word(buf, firstword, 80);
if (rest == NULL) continue; /* blank line */

if (strcmp(firstword, "mapping") == 0) {
	
#line 1547 "ifupdown.nw"
currmap = malloc(sizeof(mapping_defn));
if (currmap == NULL) {
	
#line 2009 "ifupdown.nw"
perror(filename);
return NULL;
#line 1550 "ifupdown.nw"
}
#line 1554 "ifupdown.nw"
currmap->max_matches = 0;
currmap->n_matches = 0;
currmap->match = NULL;

while((rest = next_word(rest, firstword, 80))) {
	if (currmap->max_matches == currmap->n_matches) {
		char **tmp;
		currmap->max_matches = currmap->max_matches * 2 + 1;
		tmp = realloc(currmap->match, 
			sizeof(*tmp) * currmap->max_matches);
		if (tmp == NULL) {
			currmap->max_matches = (currmap->max_matches - 1) / 2;
			
#line 2009 "ifupdown.nw"
perror(filename);
return NULL;
#line 1567 "ifupdown.nw"
		}
		currmap->match = tmp;
	}

	currmap->match[currmap->n_matches++] = strdup(firstword);
}
#line 1576 "ifupdown.nw"
currmap->script = NULL;

currmap->max_mappings = 0;
currmap->n_mappings = 0;
currmap->mapping = NULL;
#line 1584 "ifupdown.nw"
{
	mapping_defn **where = &defn->mappings;
	while(*where != NULL) {
		where = &(*where)->next;
	}
	*where = currmap;
	currmap->next = NULL;
}
#line 1500 "ifupdown.nw"
	currently_processing = MAPPING;
} else if (strcmp(firstword, "iface") == 0) {
	
#line 1636 "ifupdown.nw"
{
	
#line 1669 "ifupdown.nw"
char iface_name[80];
char address_family_name[80];
char method_name[80];

#line 1639 "ifupdown.nw"
	
#line 1657 "ifupdown.nw"
currif = malloc(sizeof(interface_defn));
if (!currif) {
	
#line 2009 "ifupdown.nw"
perror(filename);
return NULL;
#line 1660 "ifupdown.nw"
}

#line 1641 "ifupdown.nw"
	
#line 1675 "ifupdown.nw"
rest = next_word(rest, iface_name, 80);
rest = next_word(rest, address_family_name, 80);
rest = next_word(rest, method_name, 80);

if (rest == NULL) {
	
#line 2014 "ifupdown.nw"
fprintf(stderr, "%s:%d: too few parameters for iface line\n", filename, line);
return NULL;
#line 1681 "ifupdown.nw"
}

if (rest[0] != '\0') {
	
#line 2019 "ifupdown.nw"
fprintf(stderr, "%s:%d: too many parameters for iface line\n", filename, line);
return NULL;
#line 1685 "ifupdown.nw"
}

#line 1643 "ifupdown.nw"
	
#line 1691 "ifupdown.nw"
currif->logical_iface = strdup(iface_name);
if (!currif->logical_iface) {
	
#line 2009 "ifupdown.nw"
perror(filename);
return NULL;
#line 1694 "ifupdown.nw"
}
#line 1644 "ifupdown.nw"
	
#line 1709 "ifupdown.nw"
currif->address_family = get_address_family(addr_fams, address_family_name);
if (!currif->address_family) {
	
#line 2024 "ifupdown.nw"
fprintf(stderr, "%s:%d: unknown address type\n", filename, line);
return NULL;
#line 1712 "ifupdown.nw"
}
#line 1645 "ifupdown.nw"
	
#line 1744 "ifupdown.nw"
currif->method = get_method(currif->address_family, method_name);
if (!currif->method) {
	
#line 2029 "ifupdown.nw"
fprintf(stderr, "%s:%d: unknown method\n", filename, line);
return NULL;
#line 1747 "ifupdown.nw"
	return NULL; /* FIXME */
}
#line 1646 "ifupdown.nw"
	
#line 1767 "ifupdown.nw"
currif->automatic = 1;
currif->max_options = 0;
currif->n_options = 0;
currif->option = NULL;

#line 1648 "ifupdown.nw"
	
#line 1783 "ifupdown.nw"
{
	interface_defn **where = &defn->ifaces; 
	while(*where != NULL) {
		if (duplicate_if(*where, currif)) {
			
#line 2034 "ifupdown.nw"
fprintf(stderr, "%s:%d: duplicate interface\n", filename, line);
return NULL;
#line 1788 "ifupdown.nw"
		}
		where = &(*where)->next;
	}

	*where = currif;
	currif->next = NULL;
}
#line 1649 "ifupdown.nw"
}
#line 1503 "ifupdown.nw"
	currently_processing = IFACE;
} else if (strcmp(firstword, "auto") == 0) {
	
#line 1899 "ifupdown.nw"
allowup_defn *auto_ups = get_allowup(&defn->allowups, "auto");
if (!auto_ups) {
	
#line 2009 "ifupdown.nw"
perror(filename);
return NULL;
#line 1902 "ifupdown.nw"
}
while((rest = next_word(rest, firstword, 80))) {
	if (!add_allow_up(filename, line, auto_ups, firstword))
		return NULL;
}
#line 1506 "ifupdown.nw"
	currently_processing = NONE;
} else if (strncmp(firstword, "allow-", 6) == 0 && strlen(firstword) > 6) {
	
#line 1909 "ifupdown.nw"
allowup_defn *allow_ups = get_allowup(&defn->allowups, firstword + 6);
if (!allow_ups) {
	
#line 2009 "ifupdown.nw"
perror(filename);
return NULL;
#line 1912 "ifupdown.nw"
}
while((rest = next_word(rest, firstword, 80))) {
	if (!add_allow_up(filename, line, allow_ups, firstword))
		return NULL;
}
#line 1509 "ifupdown.nw"
	currently_processing = NONE;
} else {
	
#line 1516 "ifupdown.nw"
switch(currently_processing) {
	case IFACE:
		
#line 1822 "ifupdown.nw"
if (strcmp(firstword, "post-up") == 0) {
	strcpy(firstword, "up");
}
if (strcmp(firstword, "pre-down") == 0) {
	strcpy(firstword, "down");
} 
#line 1831 "ifupdown.nw"
{
	int i;

	if (strlen (rest) == 0) {
		
#line 2060 "ifupdown.nw"
fprintf(stderr, "%s:%d: option with empty value\n", filename, line);
return NULL;
#line 1836 "ifupdown.nw"
	}

	if (strcmp(firstword, "pre-up") != 0 
	    && strcmp(firstword, "up") != 0
	    && strcmp(firstword, "down") != 0
	    && strcmp(firstword, "post-down") != 0)
        {
		for (i = 0; i < currif->n_options; i++) {
			if (strcmp(currif->option[i].name, firstword) == 0) {
				
#line 2045 "ifupdown.nw"
fprintf(stderr, "%s:%d: duplicate option\n", filename, line);
return NULL;
#line 1846 "ifupdown.nw"
			}
		}
	}
}
#line 1858 "ifupdown.nw"
if (currif->n_options >= currif->max_options) {
	
#line 1880 "ifupdown.nw"
{
	variable *opt;
	currif->max_options = currif->max_options + 10;
	opt = realloc(currif->option, sizeof(*opt) * currif->max_options);
	if (opt == NULL) {
		
#line 2009 "ifupdown.nw"
perror(filename);
return NULL;
#line 1886 "ifupdown.nw"
	}
	currif->option = opt;
}
#line 1860 "ifupdown.nw"
}

currif->option[currif->n_options].name = strdup(firstword);
currif->option[currif->n_options].value = strdup(rest);

if (!currif->option[currif->n_options].name) {
	
#line 2009 "ifupdown.nw"
perror(filename);
return NULL;
#line 1867 "ifupdown.nw"
}

if (!currif->option[currif->n_options].value) {
	
#line 2009 "ifupdown.nw"
perror(filename);
return NULL;
#line 1871 "ifupdown.nw"
}

currif->n_options++;	
#line 1519 "ifupdown.nw"
		break;
	case MAPPING:
		
#line 1599 "ifupdown.nw"
if (strcmp(firstword, "script") == 0) {
	
#line 1609 "ifupdown.nw"
if (currmap->script != NULL) {
	
#line 2050 "ifupdown.nw"
fprintf(stderr, "%s:%d: duplicate script in mapping\n", filename, line);
return NULL;
#line 1611 "ifupdown.nw"
} else {
	currmap->script = strdup(rest);
}
#line 1601 "ifupdown.nw"
} else if (strcmp(firstword, "map") == 0) {
	
#line 1617 "ifupdown.nw"
if (currmap->max_mappings == currmap->n_mappings) {
	char **opt;
	currmap->max_mappings = currmap->max_mappings * 2 + 1;
	opt = realloc(currmap->mapping, sizeof(*opt) * currmap->max_mappings);
	if (opt == NULL) {
		
#line 2009 "ifupdown.nw"
perror(filename);
return NULL;
#line 1623 "ifupdown.nw"
	}
	currmap->mapping = opt;
}
currmap->mapping[currmap->n_mappings] = strdup(rest);
currmap->n_mappings++;
#line 1603 "ifupdown.nw"
} else {
	
#line 2055 "ifupdown.nw"
fprintf(stderr, "%s:%d: misplaced option\n", filename, line);
return NULL;
#line 1605 "ifupdown.nw"
}
#line 1522 "ifupdown.nw"
		break;
	case NONE:
	default:
		
#line 2055 "ifupdown.nw"
fprintf(stderr, "%s:%d: misplaced option\n", filename, line);
return NULL;
#line 1526 "ifupdown.nw"
}
#line 1512 "ifupdown.nw"
}
#line 1184 "ifupdown.nw"
	}
	if (
#line 1268 "ifupdown.nw"
ferror(f) != 0
#line 1185 "ifupdown.nw"
                                           ) {
		
#line 2009 "ifupdown.nw"
perror(filename);
return NULL;
#line 1187 "ifupdown.nw"
	}

	
#line 1222 "ifupdown.nw"
fclose(f);
line = -1;

#line 1191 "ifupdown.nw"
	return defn;
}
#line 1281 "ifupdown.nw"
static int get_line(char **result, size_t *result_len, FILE *f, int *line) {
	
#line 1306 "ifupdown.nw"
size_t pos;

#line 1284 "ifupdown.nw"
	do {
		
#line 1313 "ifupdown.nw"
pos = 0;
#line 1286 "ifupdown.nw"
		
#line 1324 "ifupdown.nw"
do {
	
#line 1345 "ifupdown.nw"
if (*result_len - pos < 10) {
	char *newstr = realloc(*result, *result_len * 2 + 80);
	if (newstr == NULL) {
		return 0;
	}
	*result = newstr;
	*result_len = *result_len * 2 + 80;
}
#line 1326 "ifupdown.nw"
	
#line 1374 "ifupdown.nw"
if (!fgets(*result + pos, *result_len - pos, f)) {
	if (ferror(f) == 0 && pos == 0) return 0;
	if (ferror(f) != 0) return 0;
}
pos += strlen(*result + pos);
#line 1327 "ifupdown.nw"
} while(
#line 1365 "ifupdown.nw"
pos == *result_len - 1 && (*result)[pos-1] != '\n'
#line 1327 "ifupdown.nw"
                                   );

#line 1386 "ifupdown.nw"
if (pos != 0 && (*result)[pos-1] == '\n') {
	(*result)[--pos] = '\0';
}

#line 1331 "ifupdown.nw"
(*line)++;

assert( (*result)[pos] == '\0' );
#line 1287 "ifupdown.nw"
		
#line 1402 "ifupdown.nw"
{ 
	int first = 0; 
	while (isspace((*result)[first]) && (*result)[first]) {
		first++;
	}

	memmove(*result, *result + first, pos - first + 1);
	pos -= first;
}
#line 1288 "ifupdown.nw"
	} while (
#line 1426 "ifupdown.nw"
(*result)[0] == '#'
#line 1288 "ifupdown.nw"
                               );

	while (
#line 1430 "ifupdown.nw"
(*result)[pos-1] == '\\'
#line 1290 "ifupdown.nw"
                               ) {
		
#line 1434 "ifupdown.nw"
(*result)[--pos] = '\0';
#line 1292 "ifupdown.nw"
		
#line 1324 "ifupdown.nw"
do {
	
#line 1345 "ifupdown.nw"
if (*result_len - pos < 10) {
	char *newstr = realloc(*result, *result_len * 2 + 80);
	if (newstr == NULL) {
		return 0;
	}
	*result = newstr;
	*result_len = *result_len * 2 + 80;
}
#line 1326 "ifupdown.nw"
	
#line 1374 "ifupdown.nw"
if (!fgets(*result + pos, *result_len - pos, f)) {
	if (ferror(f) == 0 && pos == 0) return 0;
	if (ferror(f) != 0) return 0;
}
pos += strlen(*result + pos);
#line 1327 "ifupdown.nw"
} while(
#line 1365 "ifupdown.nw"
pos == *result_len - 1 && (*result)[pos-1] != '\n'
#line 1327 "ifupdown.nw"
                                   );

#line 1386 "ifupdown.nw"
if (pos != 0 && (*result)[pos-1] == '\n') {
	(*result)[--pos] = '\0';
}

#line 1331 "ifupdown.nw"
(*line)++;

assert( (*result)[pos] == '\0' );
#line 1293 "ifupdown.nw"
	}

	
#line 1414 "ifupdown.nw"
while (isspace((*result)[pos-1])) { /* remove trailing whitespace */
	pos--;
}
(*result)[pos] = '\0';

#line 1297 "ifupdown.nw"
	return 1;
}
#line 1472 "ifupdown.nw"
static char *next_word(char *buf, char *word, int maxlen) {
	if (!buf) return NULL;
	if (!*buf) return NULL;

	while(!isspace(*buf) && *buf) {
		if (maxlen-- > 1) *word++ = *buf;
		buf++;
	}
	if (maxlen > 0) *word = '\0';

	while(isspace(*buf) && *buf) buf++;

	return buf;
}
#line 1721 "ifupdown.nw"
static address_family *get_address_family(address_family *af[], char *name) {
	int i;
	for (i = 0; af[i]; i++) {
		if (strcmp(af[i]->name, name) == 0) {
			return af[i];
		}
	}
	return NULL;
}
#line 1752 "ifupdown.nw"
static method *get_method(address_family *af, char *name) {
	int i;
	for (i = 0; i < af->n_methods; i++) {
		if (strcmp(af->method[i].name, name) == 0) {
			return &af->method[i];
		}
	}
	return NULL;
}
#line 1805 "ifupdown.nw"
static int duplicate_if(interface_defn *ifa, interface_defn *ifb) {
	if (strcmp(ifa->logical_iface, ifb->logical_iface) != 0) return 0;
	if (ifa->address_family != ifb->address_family) return 0;
	return 1;
}
#line 1923 "ifupdown.nw"
allowup_defn *get_allowup(allowup_defn **allowups, char *name) {
	for (; *allowups; allowups = &(*allowups)->next) {
		if (strcmp((*allowups)->when, name) == 0) break;
	}
	if (*allowups == NULL) {
		*allowups = malloc(sizeof(allowup_defn));
		if (*allowups == NULL) return NULL;
		(*allowups)->when = strdup(name);
		(*allowups)->next = NULL;
		(*allowups)->max_interfaces = 0;
		(*allowups)->n_interfaces = 0;
		(*allowups)->interfaces = NULL;
	}
	return *allowups;
}
#line 1948 "ifupdown.nw"
allowup_defn *find_allowup(interfaces_file *defn, char *name) {
	allowup_defn *allowups = defn->allowups;
	for (; allowups; allowups = allowups->next) {
		if (strcmp(allowups->when, name) == 0) break;
	}
	return allowups;
}
#line 1963 "ifupdown.nw"
allowup_defn *add_allow_up(char *filename, int line,
	allowup_defn *allow_up, char *iface_name)
{
	
#line 1973 "ifupdown.nw"
{
	int i;

	for (i = 0; i < allow_up->n_interfaces; i++) {
		if (strcmp(iface_name, allow_up->interfaces[i]) == 0) {
			
#line 2039 "ifupdown.nw"
fprintf(stderr, "%s:%d: interface %s declared allow-%s twice\n", 
	filename, line, iface_name, allow_up->when);
return NULL;
#line 1979 "ifupdown.nw"
		}
	}
}
#line 1967 "ifupdown.nw"
	
#line 1985 "ifupdown.nw"
if (allow_up->n_interfaces == allow_up->max_interfaces) {
	char **tmp;
	allow_up->max_interfaces *= 2;
	allow_up->max_interfaces++;
	tmp = realloc(allow_up->interfaces, 
		sizeof(*tmp) * allow_up->max_interfaces);
	if (tmp == NULL) {
		
#line 2009 "ifupdown.nw"
perror(filename);
return NULL;
#line 1993 "ifupdown.nw"
	}
	allow_up->interfaces = tmp;
}

allow_up->interfaces[allow_up->n_interfaces] = strdup(iface_name);
allow_up->n_interfaces++;
#line 1968 "ifupdown.nw"
	return allow_up;
}
