/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2011 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

//
//  A decorator for the ComboBox or SpinBox which selects a current instance of some family
//

#ifndef IGGFRAMECURRENTINSTANCE_H
#define IGGFRAMECURRENTINSTANCE_H


#include "iggframe.h"


class iObjectKey;

class iggWidgetKeySelectionBox;


class iggFrameCurrentInstance : public iggFrame
{

public:

	iggFrameCurrentInstance(bool withnone, const iString &title, const iString &item, const iObjectKey &key, const iObjectKey &maxkey, iggFrame *parent, bool spinbox = true, int index = -1, const iObjectKey *indkey = 0);

	virtual void OnCurrentInstanceChanged();

protected:

	virtual void UpdateChildren();

	bool mIsSpinBox, mWithNone;
	const iString &mItemText;
	iggWidgetKeySelectionBox *mBox;
	const iObjectKey &mKey, &mMaxKey;
};

#endif  // IGGFRAMECURRENTINSTANCE_H

