/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "icubeaxesactor.h"


#include "ierror.h"
#include "ioverlayhelper.h"

#include <vtkAxisActor2D.h>
#include <vtkProperty2D.h>
#include <vtkRenderer.h>
#include <vtkTextProperty.h>
#include <vtkViewport.h>

	
iCubeAxesActor* iCubeAxesActor::New(iRenderTool *rt)
{
	IERROR_ASSERT(rt);
	return new iCubeAxesActor(rt);
}


iCubeAxesActor::iCubeAxesActor(iRenderTool *rt) : mOverlayHelper(rt)
{
	this->XAxis->SetLabelTextProperty(this->AxisLabelTextProperty);
	this->YAxis->SetLabelTextProperty(this->AxisLabelTextProperty);
	this->ZAxis->SetLabelTextProperty(this->AxisLabelTextProperty);
	this->XAxis->SetTitleTextProperty(this->AxisTitleTextProperty);
	this->YAxis->SetTitleTextProperty(this->AxisTitleTextProperty);
	this->ZAxis->SetTitleTextProperty(this->AxisTitleTextProperty);

	this->SetFlyModeToOuterEdges();
	this->SetLabelFormat("%6.2g");
	this->ScalingOff();
	float b = 1.0;
	this->SetBounds(-b,b,-b,b,-b,b);
	this->SetNumberOfLabels(4);
	this->UseRangesOn();
	this->GetProperty()->SetColor(0.0,0.0,0.0);
}


iCubeAxesActor::~iCubeAxesActor()
{
}


int iCubeAxesActor::RenderOverlay(vtkViewport *viewport)
{
	return vtkCubeAxesActor2D::RenderOverlay(viewport);
}


int iCubeAxesActor::RenderOpaqueGeometry(vtkViewport *viewport)
{
	//
	//  First of all do nothing if no axes are visible
	//
	if(this->XAxisVisibility==0 && this->YAxisVisibility==0 && this->ZAxisVisibility==0)
	{
		return 0;
	}

	int renderedSomething = 0;
	int mag = mOverlayHelper->GetRenderingMagnification();
	//
	//  Scale fonts
	//
	this->AxisLabelTextProperty->SetFontSize(mOverlayHelper->GetFontSize(viewport,mag));
	this->AxisTitleTextProperty->SetFontSize(mOverlayHelper->GetFontSize(viewport,mag));
	this->FontFactor = mOverlayHelper->GetFontSize(viewport,mag)/10.0;

	mOverlayHelper->UpdateTextProperty(this->AxisLabelTextProperty);
	mOverlayHelper->UpdateTextProperty(this->AxisTitleTextProperty);

	if(mag == 1)
	{
		//
		//  Set colors (needed for VTK 5)
		//
		this->AxisLabelTextProperty->SetColor(this->GetOverlayHelper()->GetColor(viewport).ToVTK());
		this->AxisTitleTextProperty->SetColor(this->GetOverlayHelper()->GetColor(viewport).ToVTK());

		//
		//  Render and save axes positions
		//
		renderedSomething = vtkCubeAxesActor2D::RenderOpaqueGeometry(viewport);
		
		this->XAxis->GetPositionCoordinate()->GetValue(mPos1X);
		this->YAxis->GetPositionCoordinate()->GetValue(mPos1Y);
		this->ZAxis->GetPositionCoordinate()->GetValue(mPos1Z);

		this->XAxis->GetPosition2Coordinate()->GetValue(mPos2X);
		this->YAxis->GetPosition2Coordinate()->GetValue(mPos2Y);
		this->ZAxis->GetPosition2Coordinate()->GetValue(mPos2Z);
	}
	else
	{
		//
		//  compute shifts
		//
		int winij[2];
		mOverlayHelper->ComputePositionShiftsUnderMagnification(winij);
		//
		//  shift positions: positions are in viewport coordinates, so need to scale
		//  winij appropriately
		//
		int *s = viewport->GetSize();
		winij[0] *= s[0];
		winij[1] *= s[1];

		this->XAxis->GetPositionCoordinate()->SetValue(mag*mPos1X[0]-winij[0],mag*mPos1X[1]-winij[1]);
		this->YAxis->GetPositionCoordinate()->SetValue(mag*mPos1Y[0]-winij[0],mag*mPos1Y[1]-winij[1]);
		this->ZAxis->GetPositionCoordinate()->SetValue(mag*mPos1Z[0]-winij[0],mag*mPos1Z[1]-winij[1]);

		if(this->XAxis->GetPosition2Coordinate()->GetReferenceCoordinate() == 0) this->XAxis->GetPosition2Coordinate()->SetValue(mag*mPos2X[0]-winij[0],mag*mPos2X[1]-winij[1]); else this->XAxis->GetPosition2Coordinate()->SetValue(mag*mPos2X[0],mag*mPos2X[1]);
		if(this->YAxis->GetPosition2Coordinate()->GetReferenceCoordinate() == 0) this->YAxis->GetPosition2Coordinate()->SetValue(mag*mPos2Y[0]-winij[0],mag*mPos2Y[1]-winij[1]); else this->YAxis->GetPosition2Coordinate()->SetValue(mag*mPos2Y[0],mag*mPos2Y[1]);
		if(this->ZAxis->GetPosition2Coordinate()->GetReferenceCoordinate() == 0) this->ZAxis->GetPosition2Coordinate()->SetValue(mag*mPos2Z[0]-winij[0],mag*mPos2Z[1]-winij[1]); else this->ZAxis->GetPosition2Coordinate()->SetValue(mag*mPos2Z[0],mag*mPos2Z[1]);
		//	
		//Render the axes
		//
		if(this->XAxisVisibility)
		{
			renderedSomething += this->XAxis->RenderOpaqueGeometry(viewport);
		}
		if(this->YAxisVisibility)
		{
			renderedSomething += this->YAxis->RenderOpaqueGeometry(viewport);
		}
		if(this->ZAxisVisibility)
		{
			renderedSomething += this->ZAxis->RenderOpaqueGeometry(viewport);
		}
		
	}
	return renderedSomething;
}

