/***************************************************************************
 *   Copyright (C) 2004-2006 by Jim Campbell                               *
 *   ifpgui@gmail.com                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef PROGRESSDLG_H
#define PROGRESSDLG_H

#include <qdialog.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qprogressbar.h>

#include "ifpinterface.h"

extern int progress(void *context, struct ifp_transfer_status *status);

class ProgressWindow;

typedef struct progress_info
   {
   ProgressWindow *pgw;

   bool is_batch;          // ifp-gui defined is batch (user selected multiple files)
   int  total_transfered;  // The number of bytes transferred in the transfer so far
   int  total_to_transfer; // The total number of bytes expected during this transfer

   QString file_name; // the name of the current file
   int  file_bytes; // The number of bytes transferred for the current file
   int  file_total; // The number of bytes in the current file

   bool is_status_batch;   // libifp defined is batch (called up/download directory)
   int  batch_total;
   int  batch_bytes;

   int files_count; // The number of files successfully transferred so far.
   int files_total; // The number of files expected to be transferred in this batch.

   bool delete_success; // a return value for the ifp_delete function
   bool auto_convert;   // whether or not to convert the file after download
   }
ifp_progress_info;

class ProgressWindow: public QDialog
{
   Q_OBJECT

   public:
      ProgressWindow(const char *caption=0);
      ~ProgressWindow();

      bool cancel_progress;

      void updateProgress(ifp_progress_info *pg_info);
      void setFileName(const QString &fileName);
      void setFileProgress(int progress);
      void setFileProgressTarget(int totalSteps);
      void setTotalProgress(int progress);
      void setTotalProgressTarget(int totalSteps);
      void hideCancelBtn(void);
      void showCancelBtn(void);
      void removeStayOnTop(void);

   public slots:
      virtual void btnCancel_clicked();

   signals:
      void btnCancelClicked(void);


   private:
      QBoxLayout *layout;
      QProgressBar *fileprogress;
      QProgressBar *totalprogress;
      QLabel *lblFilename;
      QPushButton *btnCancel;
      QString lastFileName;
      QString truncateFileName(const QString &org, const QFontMetrics &fm, int width);
      QString truncateFilePath(QString &fileStr);

};

#endif //PROGRESSDLG
