#define PULSESHAPER_GAIN        1.000000f
#define PULSESHAPER_COEFF_SETS  192
static const complexf_t pulseshaper[PULSESHAPER_COEFF_SETS][27] =
{
    {
        {  -0.0020619018f,   -0.0010505915f},     /* Filter 0 */
        {   0.0003585523f,   -0.0011035106f},
        {  -0.0033205507f,   -0.0005259236f},
        {   0.0000000000f,   -0.0037433761f},
        {  -0.0024369440f,    0.0003859740f},
        {  -0.0015483286f,   -0.0047652653f},
        {  -0.0039043549f,    0.0019893682f},
        {  -0.0072869120f,   -0.0100295740f},
        {  -0.0031365185f,    0.0031365185f},
        {  -0.0318625939f,   -0.0231495296f},
        {   0.0179723867f,   -0.0352727949f},
        {  -0.0443341732f,   -0.0144050461f},
        {   0.0312604822f,   -0.1973709165f},
        {   0.3230605354f,    0.0000000000f},
        {   0.0505378020f,    0.3190831241f},
        {  -0.1900507362f,    0.0617512275f},
        {  -0.0211630887f,   -0.0415349002f},
        {  -0.0320270276f,    0.0232689976f},
        {  -0.0278489283f,   -0.0278489283f},
        {   0.0026072431f,   -0.0035885623f},
        {  -0.0110460175f,   -0.0056282270f},
        {   0.0013541001f,   -0.0041674916f},
        {  -0.0049488090f,   -0.0007838143f},
        {  -0.0000000000f,   -0.0024673208f},
        {  -0.0036972890f,    0.0005855930f},
        {  -0.0010388971f,   -0.0031973966f},
        {  -0.0010338346f,    0.0005267651f}
    },
    {
        {  -0.0020683708f,   -0.0010538876f},     /* Filter 1 */
        {   0.0003525575f,   -0.0010850603f},
        {  -0.0033401247f,   -0.0005290238f},
        {   0.0000000000f,   -0.0037242426f},
        {  -0.0024716928f,    0.0003914777f},
        {  -0.0015426375f,   -0.0047477499f},
        {  -0.0039641299f,    0.0020198251f},
        {  -0.0072818054f,   -0.0100225453f},
        {  -0.0032521646f,    0.0032521646f},
        {  -0.0319837501f,   -0.0232375547f},
        {   0.0178808444f,   -0.0350931330f},
        {  -0.0449835104f,   -0.0146160285f},
        {   0.0313889711f,   -0.1981821640f},
        {   0.3234303845f,    0.0000000000f},
        {   0.0504793852f,    0.3187142949f},
        {  -0.1892688035f,    0.0614971622f},
        {  -0.0208540454f,   -0.0409283686f},
        {  -0.0321881057f,    0.0233860277f},
        {  -0.0277423727f,   -0.0277423727f},
        {   0.0025114767f,   -0.0034567511f},
        {  -0.0110530868f,   -0.0056318290f},
        {   0.0013333687f,   -0.0041036870f},
        {  -0.0049666219f,   -0.0007866356f},
        {  -0.0000000000f,   -0.0024320363f},
        {  -0.0037159717f,    0.0005885521f},
        {  -0.0010327352f,   -0.0031784322f},
        {  -0.0010510198f,    0.0005355213f}
    },
    {
        {  -0.0020747359f,   -0.0010571307f},     /* Filter 2 */
        {   0.0003465273f,   -0.0010665015f},
        {  -0.0033595723f,   -0.0005321040f},
        {   0.0000000000f,   -0.0037048962f},
        {  -0.0025063405f,    0.0003969653f},
        {  -0.0015368271f,   -0.0047298674f},
        {  -0.0040238979f,    0.0020502784f},
        {  -0.0072762570f,   -0.0100149086f},
        {  -0.0033682442f,    0.0033682442f},
        {  -0.0321041418f,   -0.0233250244f},
        {   0.0177881547f,   -0.0349112193f},
        {  -0.0456347697f,   -0.0148276355f},
        {   0.0315173303f,   -0.1989925922f},
        {   0.3237966198f,    0.0000000000f},
        {   0.0504204080f,    0.3183419274f},
        {  -0.1884861003f,    0.0612428465f},
        {  -0.0205459255f,   -0.0403236493f},
        {  -0.0323471495f,    0.0235015798f},
        {  -0.0276351622f,   -0.0276351621f},
        {   0.0024160790f,   -0.0033254474f},
        {  -0.0110594921f,   -0.0056350927f},
        {   0.0013126376f,   -0.0040398833f},
        {  -0.0049840526f,   -0.0007893964f},
        {  -0.0000000000f,   -0.0023966537f},
        {  -0.0037344368f,    0.0005914767f},
        {  -0.0010265333f,   -0.0031593446f},
        {  -0.0010681046f,    0.0005442265f}
    },
    {
        {  -0.0020809967f,   -0.0010603208f},     /* Filter 3 */
        {   0.0003404626f,   -0.0010478361f},
        {  -0.0033788979f,   -0.0005351649f},
        {   0.0000000000f,   -0.0036853371f},
        {  -0.0025408856f,    0.0004024367f},
        {  -0.0015308989f,   -0.0047116222f},
        {  -0.0040836583f,    0.0020807278f},
        {  -0.0072702646f,   -0.0100066607f},
        {  -0.0034847552f,    0.0034847552f},
        {  -0.0322237637f,   -0.0234119347f},
        {   0.0176943134f,   -0.0347270454f},
        {  -0.0462879352f,   -0.0150398618f},
        {   0.0316455549f,   -0.1998021699f},
        {   0.3241592762f,    0.0000000000f},
        {   0.0503608735f,    0.3179660415f},
        {  -0.1877026542f,    0.0609882894f},
        {  -0.0202387338f,   -0.0397207515f},
        {  -0.0325041534f,    0.0236156498f},
        {  -0.0275273031f,   -0.0275273031f},
        {   0.0023210497f,   -0.0031946509f},
        {  -0.0110652351f,   -0.0056380189f},
        {   0.0012919081f,   -0.0039760844f},
        {  -0.0050011043f,   -0.0007920971f},
        {  -0.0000000000f,   -0.0023611717f},
        {  -0.0037526894f,    0.0005943676f},
        {  -0.0010202946f,   -0.0031401438f},
        {  -0.0010850831f,    0.0005528774f}
    },
    {
        {  -0.0020871540f,   -0.0010634581f},     /* Filter 4 */
        {   0.0003343643f,   -0.0010290677f},
        {  -0.0033980896f,   -0.0005382045f},
        {   0.0000000000f,   -0.0036655608f},
        {  -0.0025753233f,    0.0004078911f},
        {  -0.0015248506f,   -0.0046930077f},
        {  -0.0041434070f,    0.0021111713f},
        {  -0.0072638274f,   -0.0099978007f},
        {  -0.0036016954f,    0.0036016954f},
        {  -0.0323425986f,   -0.0234982733f},
        {   0.0175993179f,   -0.0345406062f},
        {  -0.0469429903f,   -0.0152527022f},
        {   0.0317736429f,   -0.2006108859f},
        {   0.3245182896f,    0.0000000000f},
        {   0.0503007794f,    0.3175866223f},
        {  -0.1869184792f,    0.0607334955f},
        {  -0.0199324784f,   -0.0391196915f},
        {  -0.0326591229f,    0.0237282418f},
        {  -0.0274188054f,   -0.0274188054f},
        {   0.0022263916f,   -0.0030643652f},
        {  -0.0110703162f,   -0.0056406079f},
        {   0.0012711815f,   -0.0039122945f},
        {  -0.0050177778f,   -0.0007947379f},
        {  -0.0000000000f,   -0.0023255964f},
        {  -0.0037707253f,    0.0005972242f},
        {  -0.0010140199f,   -0.0031208324f},
        {  -0.0011019602f,    0.0005614767f}
    },
    {
        {  -0.0020932061f,   -0.0010665418f},     /* Filter 5 */
        {   0.0003282310f,   -0.0010101913f},
        {  -0.0034171601f,   -0.0005412250f},
        {   0.0000000000f,   -0.0036455684f},
        {  -0.0026096525f,    0.0004133284f},
        {  -0.0015186844f,   -0.0046740300f},
        {  -0.0042031392f,    0.0021416064f},
        {  -0.0072569405f,   -0.0099883217f},
        {  -0.0037190588f,    0.0037190588f},
        {  -0.0324606458f,   -0.0235840397f},
        {   0.0175031682f,   -0.0343519019f},
        {  -0.0475999433f,   -0.0154661591f},
        {   0.0319015944f,   -0.2014187397f},
        {   0.3248737054f,    0.0000000000f},
        {   0.0502401324f,    0.3172037117f},
        {  -0.1861335945f,    0.0604784710f},
        {  -0.0196271574f,   -0.0385204653f},
        {  -0.0328120641f,    0.0238393600f},
        {  -0.0273096732f,   -0.0273096732f},
        {   0.0021321098f,   -0.0029345974f},
        {  -0.0110747363f,   -0.0056428600f},
        {   0.0012504589f,   -0.0038485167f},
        {  -0.0050340733f,   -0.0007973189f},
        {  -0.0000000000f,   -0.0022899307f},
        {  -0.0037885462f,    0.0006000468f},
        {  -0.0010077057f,   -0.0031013993f},
        {  -0.0011187340f,    0.0005700234f}
    },
    {
        {  -0.0020991518f,   -0.0010695713f},     /* Filter 6 */
        {   0.0003220639f,   -0.0009912107f},
        {  -0.0034360946f,   -0.0005442239f},
        {   0.0000000000f,   -0.0036253614f},
        {  -0.0026438710f,    0.0004187480f},
        {  -0.0015124002f,   -0.0046546893f},
        {  -0.0042628518f,    0.0021720315f},
        {  -0.0072496072f,   -0.0099782283f},
        {  -0.0038368434f,    0.0038368434f},
        {  -0.0325778977f,   -0.0236692282f},
        {   0.0174058626f,   -0.0341609287f},
        {  -0.0482587741f,   -0.0156802262f},
        {   0.0320294011f,   -0.2022256796f},
        {   0.3252254876f,    0.0000000000f},
        {   0.0501789307f,    0.3168172996f},
        {  -0.1853480191f,    0.0602232221f},
        {  -0.0193227779f,   -0.0379230869f},
        {  -0.0329629727f,    0.0239490016f},
        {  -0.0271999184f,   -0.0271999184f},
        {   0.0020382052f,   -0.0028053488f},
        {  -0.0110785003f,   -0.0056447778f},
        {   0.0012297420f,   -0.0037847567f},
        {  -0.0050499875f,   -0.0007998394f},
        {  -0.0000000000f,   -0.0022541739f},
        {  -0.0038061482f,    0.0006028347f},
        {  -0.0010013566f,   -0.0030818588f},
        {  -0.0011354014f,    0.0005785159f}
    },
    {
        {  -0.0021049923f,   -0.0010725471f},     /* Filter 7 */
        {   0.0003158634f,   -0.0009721276f},
        {  -0.0034549006f,   -0.0005472025f},
        {   0.0000000000f,   -0.0036049447f},
        {  -0.0026779756f,    0.0004241497f},
        {  -0.0015059960f,   -0.0046349792f},
        {  -0.0043225420f,    0.0022024452f},
        {  -0.0072418204f,   -0.0099675107f},
        {  -0.0039550473f,    0.0039550473f},
        {  -0.0326943386f,   -0.0237538274f},
        {   0.0173073982f,   -0.0339676816f},
        {  -0.0489194702f,   -0.0158948994f},
        {   0.0321570632f,   -0.2030317064f},
        {   0.3255736244f,    0.0000000000f},
        {   0.0501171763f,    0.3164273977f},
        {  -0.1845617592f,    0.0599677508f},
        {  -0.0190193487f,   -0.0373275735f},
        {  -0.0331118630f,    0.0240571767f},
        {  -0.0270895417f,   -0.0270895417f},
        {   0.0019446819f,   -0.0026766250f},
        {  -0.0110816114f,   -0.0056463630f},
        {   0.0012090309f,   -0.0037210144f},
        {  -0.0050655213f,   -0.0008022997f},
        {  -0.0000000000f,   -0.0022183301f},
        {  -0.0038235324f,    0.0006055880f},
        {  -0.0009949709f,   -0.0030622057f},
        {  -0.0011519648f,    0.0005869554f}
    },
    {
        {  -0.0021107264f,   -0.0010754688f},     /* Filter 8 */
        {   0.0003096295f,   -0.0009529418f},
        {  -0.0034735715f,   -0.0005501597f},
        {   0.0000000000f,   -0.0035843186f},
        {  -0.0027119655f,    0.0004295331f},
        {  -0.0014994741f,   -0.0046149068f},
        {  -0.0043822054f,    0.0022328452f},
        {  -0.0072335836f,   -0.0099561737f},
        {  -0.0040736649f,    0.0040736649f},
        {  -0.0328099690f,   -0.0238378378f},
        {   0.0172077747f,   -0.0337721594f},
        {  -0.0495820369f,   -0.0161101804f},
        {   0.0322845815f,   -0.2038368254f},
        {   0.3259181294f,    0.0000000000f},
        {   0.0500548715f,    0.3160340207f},
        {  -0.1837748387f,    0.0597120648f},
        {  -0.0187168672f,   -0.0367339203f},
        {  -0.0332587359f,    0.0241638860f},
        {  -0.0269785595f,   -0.0269785594f},
        {   0.0018515428f,   -0.0025484301f},
        {  -0.0110840763f,   -0.0056476190f},
        {   0.0011883268f,   -0.0036572938f},
        {  -0.0050806797f,   -0.0008047006f},
        {  -0.0000000000f,   -0.0021824000f},
        {  -0.0038407034f,    0.0006083077f},
        {  -0.0009885487f,   -0.0030424399f},
        {  -0.0011684229f,    0.0005953412f}
    },
    {
        {  -0.0021163512f,   -0.0010783348f},     /* Filter 9 */
        {   0.0003033628f,   -0.0009336547f},
        {  -0.0034921137f,   -0.0005530965f},
        {   0.0000000000f,   -0.0035634797f},
        {  -0.0027458380f,    0.0004348980f},
        {  -0.0014928333f,   -0.0045944683f},
        {  -0.0044418429f,    0.0022632320f},
        {  -0.0072248932f,   -0.0099442124f},
        {  -0.0041926924f,    0.0041926924f},
        {  -0.0329247776f,   -0.0239212511f},
        {   0.0171069856f,   -0.0335743496f},
        {  -0.0502464419f,   -0.0163260586f},
        {   0.0324119487f,   -0.2046409903f},
        {   0.3262589677f,    0.0000000000f},
        {   0.0499920157f,    0.3156371650f},
        {  -0.1829872716f,    0.0594561687f},
        {  -0.0184153382f,   -0.0361421361f},
        {  -0.0334035882f,    0.0242691274f},
        {  -0.0268669691f,   -0.0268669691f},
        {   0.0017587860f,   -0.0024207612f},
        {  -0.0110858859f,   -0.0056485410f},
        {   0.0011676322f,   -0.0035936024f},
        {  -0.0050954597f,   -0.0008070415f},
        {  -0.0000000000f,   -0.0021463869f},
        {  -0.0038576503f,    0.0006109918f},
        {  -0.0009820912f,   -0.0030225659f},
        {  -0.0011847721f,    0.0006036715f}
    },
    {
        {  -0.0021218707f,   -0.0010811471f},     /* Filter 10 */
        {   0.0002970631f,   -0.0009142662f},
        {  -0.0035105169f,   -0.0005560113f},
        {   0.0000000000f,   -0.0035424291f},
        {  -0.0027795897f,    0.0004402438f},
        {  -0.0014860735f,   -0.0045736640f},
        {  -0.0045014440f,    0.0022936003f},
        {  -0.0072157478f,   -0.0099316248f},
        {  -0.0043121270f,    0.0043121270f},
        {  -0.0330387505f,   -0.0240040573f},
        {   0.0170050359f,   -0.0333742621f},
        {  -0.0509126991f,   -0.0165425387f},
        {   0.0325391632f,   -0.2054441908f},
        {   0.3265961402f,    0.0000000000f},
        {   0.0499286139f,    0.3152368615f},
        {  -0.1821990707f,    0.0592000667f},
        {  -0.0181147701f,   -0.0355522381f},
        {  -0.0335464345f,    0.0243729114f},
        {  -0.0267547838f,   -0.0267547838f},
        {   0.0016664209f,   -0.0022936316f},
        {  -0.0110870524f,   -0.0056491353f},
        {   0.0011469467f,   -0.0035299389f},
        {  -0.0051098607f,   -0.0008093224f},
        {  -0.0000000000f,   -0.0021102948f},
        {  -0.0038743798f,    0.0006136415f},
        {  -0.0009756000f,   -0.0030025882f},
        {  -0.0012010169f,    0.0006119487f}
    },
    {
        {  -0.0021272804f,   -0.0010839035f},     /* Filter 11 */
        {   0.0002907313f,   -0.0008947789f},
        {  -0.0035287880f,   -0.0005589051f},
        {   0.0000000000f,   -0.0035211710f},
        {  -0.0028132202f,    0.0004455703f},
        {  -0.0014791959f,   -0.0045524968f},
        {  -0.0045610084f,    0.0023239498f},
        {  -0.0072061462f,   -0.0099184093f},
        {  -0.0044319669f,    0.0044319669f},
        {  -0.0331518885f,   -0.0240862569f},
        {   0.0169019206f,   -0.0331718869f},
        {  -0.0515807741f,   -0.0167596094f},
        {   0.0326662218f,   -0.2062464072f},
        {   0.3269296554f,    0.0000000000f},
        {   0.0498646641f,    0.3148330983f},
        {  -0.1814102747f,    0.0589437714f},
        {  -0.0178151678f,   -0.0349642354f},
        {  -0.0336872691f,    0.0244752336f},
        {  -0.0266420053f,   -0.0266420053f},
        {   0.0015744429f,   -0.0021670347f},
        {  -0.0110875784f,   -0.0056494033f},
        {   0.0011262723f,   -0.0034663098f},
        {  -0.0051238819f,   -0.0008115432f},
        {  -0.0000000000f,   -0.0020741216f},
        {  -0.0038908892f,    0.0006162563f},
        {  -0.0009690729f,   -0.0029824996f},
        {  -0.0012171503f,    0.0006201690f}
    },
    {
        {  -0.0021325818f,   -0.0010866047f},     /* Filter 12 */
        {   0.0002843666f,   -0.0008751904f},
        {  -0.0035469196f,   -0.0005617769f},
        {   0.0000000000f,   -0.0034997014f},
        {  -0.0028467280f,    0.0004508774f},
        {  -0.0014721991f,   -0.0045309631f},
        {  -0.0046205348f,    0.0023542801f},
        {  -0.0071960854f,   -0.0099045618f},
        {  -0.0045522045f,    0.0045522045f},
        {  -0.0332641784f,   -0.0241678403f},
        {   0.0167976380f,   -0.0329672208f},
        {  -0.0522506751f,   -0.0169772735f},
        {   0.0327931228f,   -0.2070476286f},
        {   0.3272594964f,    0.0000000000f},
        {   0.0498001678f,    0.3144258846f},
        {  -0.1806208765f,    0.0586872803f},
        {  -0.0175165287f,   -0.0343781233f},
        {  -0.0338261024f,    0.0245761020f},
        {  -0.0265286487f,   -0.0265286487f},
        {   0.0014828623f,   -0.0020409848f},
        {  -0.0110874640f,   -0.0056493451f},
        {   0.0011056098f,   -0.0034027170f},
        {  -0.0051375257f,   -0.0008137041f},
        {  -0.0000000000f,   -0.0020378694f},
        {  -0.0039071795f,    0.0006188364f},
        {  -0.0009625120f,   -0.0029623072f},
        {  -0.0012331777f,    0.0006283354f}
    },
    {
        {  -0.0021377717f,   -0.0010892491f},     /* Filter 13 */
        {   0.0002779697f,   -0.0008555029f},
        {  -0.0035649100f,   -0.0005646263f},
        {   0.0000000000f,   -0.0034780238f},
        {  -0.0028801083f,    0.0004561643f},
        {  -0.0014650844f,   -0.0045090662f},
        {  -0.0046800169f,    0.0023845877f},
        {  -0.0071855666f,   -0.0098900840f},
        {  -0.0046728389f,    0.0046728389f},
        {  -0.0333756137f,   -0.0242488027f},
        {   0.0166921866f,   -0.0327602608f},
        {  -0.0529223907f,   -0.0171955271f},
        {   0.0329198616f,   -0.2078478261f},
        {   0.3275856455f,    0.0000000000f},
        {   0.0497351290f,    0.3140152457f},
        {  -0.1798308921f,    0.0584305988f},
        {  -0.0172188616f,   -0.0337939187f},
        {  -0.0339629379f,    0.0246755187f},
        {  -0.0264147135f,   -0.0264147135f},
        {   0.0013916737f,   -0.0019154745f},
        {  -0.0110867107f,   -0.0056489612f},
        {   0.0010849601f,   -0.0033391637f},
        {  -0.0051507929f,   -0.0008158054f},
        {  -0.0000000000f,   -0.0020015478f},
        {  -0.0039232480f,    0.0006213814f},
        {  -0.0009559179f,   -0.0029420128f},
        {  -0.0012490941f,    0.0006364452f}
    },
    {
        {  -0.0021428519f,   -0.0010918376f},     /* Filter 14 */
        {   0.0002715416f,   -0.0008357192f},
        {  -0.0035827641f,   -0.0005674541f},
        {   0.0000000000f,   -0.0034561409f},
        {  -0.0029133560f,    0.0004614303f},
        {  -0.0014578511f,   -0.0044868044f},
        {  -0.0047394533f,    0.0024148721f},
        {  -0.0071745880f,   -0.0098749731f},
        {  -0.0047938623f,    0.0047938623f},
        {  -0.0334861824f,   -0.0243291356f},
        {   0.0165855627f,   -0.0325509996f},
        {  -0.0535958993f,   -0.0174143633f},
        {   0.0330464377f,   -0.2086469963f},
        {   0.3279080881f,    0.0000000000f},
        {   0.0496695465f,    0.3136011746f},
        {  -0.1790403429f,    0.0581737338f},
        {  -0.0169221683f,   -0.0332116253f},
        {  -0.0340977770f,    0.0247734851f},
        {  -0.0263002096f,   -0.0263002095f},
        {   0.0013008835f,   -0.0017905126f},
        {  -0.0110853211f,   -0.0056482532f},
        {   0.0010643250f,   -0.0032756556f},
        {  -0.0051636809f,   -0.0008178467f},
        {  -0.0000000000f,   -0.0019651518f},
        {  -0.0039390981f,    0.0006238918f},
        {  -0.0009492899f,   -0.0029216139f},
        {  -0.0012649024f,    0.0006445000f}
    },
    {
        {  -0.0021478235f,   -0.0010943707f},     /* Filter 15 */
        {   0.0002650826f,   -0.0008158402f},
        {  -0.0036004777f,   -0.0005702596f},
        {   0.0000000000f,   -0.0034340508f},
        {  -0.0029464795f,    0.0004666765f},
        {  -0.0014504998f,   -0.0044641793f},
        {  -0.0047988370f,    0.0024451296f},
        {  -0.0071631454f,   -0.0098592238f},
        {  -0.0049152798f,    0.0049152798f},
        {  -0.0335958803f,   -0.0244088358f},
        {   0.0164777696f,   -0.0323394438f},
        {  -0.0542712019f,   -0.0176337824f},
        {   0.0331728498f,   -0.2094451305f},
        {   0.3282268613f,    0.0000000000f},
        {   0.0496034263f,    0.3131837077f},
        {  -0.1782492532f,    0.0579166932f},
        {  -0.0166264567f,   -0.0326312586f},
        {  -0.0342306216f,    0.0248700024f},
        {  -0.0261851487f,   -0.0261851487f},
        {   0.0012104960f,   -0.0016661048f},
        {  -0.0110832996f,   -0.0056472232f},
        {   0.0010437052f,   -0.0032121944f},
        {  -0.0051761955f,   -0.0008198288f},
        {  -0.0000000000f,   -0.0019286856f},
        {  -0.0039547236f,    0.0006263667f},
        {  -0.0009426290f,   -0.0029011137f},
        {  -0.0012806020f,    0.0006524993f}
    },
    {
        {  -0.0021526811f,   -0.0010968458f},     /* Filter 16 */
        {   0.0002585916f,   -0.0007958630f},
        {  -0.0036180491f,   -0.0005730427f},
        {   0.0000000000f,   -0.0034117569f},
        {  -0.0029794678f,    0.0004719013f},
        {  -0.0014430304f,   -0.0044411910f},
        {  -0.0048581698f,    0.0024753611f},
        {  -0.0071512408f,   -0.0098428385f},
        {  -0.0050370769f,    0.0050370769f},
        {  -0.0337047030f,   -0.0244879001f},
        {   0.0163688011f,   -0.0321255811f},
        {  -0.0549482856f,   -0.0178537803f},
        {   0.0332990916f,   -0.2102421898f},
        {   0.3285419113f,    0.0000000000f},
        {   0.0495367633f,    0.3127628142f},
        {  -0.1774576372f,    0.0576594816f},
        {  -0.0163317246f,   -0.0320528142f},
        {  -0.0343614823f,    0.0249650783f},
        {  -0.0260695287f,   -0.0260695287f},
        {   0.0011205114f,   -0.0015422517f},
        {  -0.0110806487f,   -0.0056458725f},
        {   0.0010231017f,   -0.0031487834f},
        {  -0.0051883299f,   -0.0008217507f},
        {  -0.0000000000f,   -0.0018921522f},
        {  -0.0039701300f,    0.0006288068f},
        {  -0.0009359356f,   -0.0028805136f},
        {  -0.0012961871f,    0.0006604403f}
    },
    {
        {  -0.0021574284f,   -0.0010992647f},     /* Filter 17 */
        {   0.0002520699f,   -0.0007757912f},
        {  -0.0036354734f,   -0.0005758024f},
        {   0.0000000000f,   -0.0033892575f},
        {  -0.0030123189f,    0.0004771044f},
        {  -0.0014354426f,   -0.0044178382f},
        {  -0.0049174434f,    0.0025055626f},
        {  -0.0071388691f,   -0.0098258104f},
        {  -0.0051592580f,    0.0051592580f},
        {  -0.0338126301f,   -0.0245663138f},
        {   0.0162586580f,   -0.0319094130f},
        {  -0.0556271369f,   -0.0180743524f},
        {   0.0334251612f,   -0.2110381623f},
        {   0.3288532338f,    0.0000000000f},
        {   0.0494695653f,    0.3123385428f},
        {  -0.1766655070f,    0.0574021029f},
        {  -0.0160379814f,   -0.0314763108f},
        {  -0.0344903631f,    0.0250587156f},
        {  -0.0259533663f,   -0.0259533663f},
        {   0.0010309301f,   -0.0014189535f},
        {  -0.0110773713f,   -0.0056442026f},
        {   0.0010025158f,   -0.0030854265f},
        {  -0.0052000922f,   -0.0008236137f},
        {  -0.0000000000f,   -0.0018555547f},
        {  -0.0039853119f,    0.0006312114f},
        {  -0.0009292099f,   -0.0028598142f},
        {  -0.0013116612f,    0.0006683247f}
    },
    {
        {  -0.0021620629f,   -0.0011016261f},     /* Filter 18 */
        {   0.0002455178f,   -0.0007556262f},
        {  -0.0036527558f,   -0.0005785397f},
        {   0.0000000000f,   -0.0033665528f},
        {  -0.0030450357f,    0.0004822863f},
        {  -0.0014277367f,   -0.0043941217f},
        {  -0.0049766550f,    0.0025357324f},
        {  -0.0071260337f,   -0.0098081440f},
        {  -0.0052818148f,    0.0052818148f},
        {  -0.0339196635f,   -0.0246440780f},
        {   0.0161473402f,   -0.0316909395f},
        {  -0.0563077467f,   -0.0182954959f},
        {   0.0335510562f,   -0.2118330321f},
        {   0.3291608469f,    0.0000000000f},
        {   0.0494018279f,    0.3119108657f},
        {  -0.1758728665f,    0.0571445584f},
        {  -0.0157452306f,   -0.0309017550f},
        {  -0.0346172596f,    0.0251509113f},
        {  -0.0258366582f,   -0.0258366582f},
        {   0.0009417582f,   -0.0012962189f},
        {  -0.0110734677f,   -0.0056422136f},
        {   0.0009819489f,   -0.0030221280f},
        {  -0.0052114720f,   -0.0008254161f},
        {  -0.0000000000f,   -0.0018188896f},
        {  -0.0040002741f,    0.0006335812f},
        {  -0.0009224524f,   -0.0028390167f},
        {  -0.0013270241f,    0.0006761526f}
    },
    {
        {  -0.0021665839f,   -0.0011039297f},     /* Filter 19 */
        {   0.0002389352f,   -0.0007353671f},
        {  -0.0036698948f,   -0.0005812542f},
        {   0.0000000000f,   -0.0033436471f},
        {  -0.0030776105f,    0.0004874456f},
        {  -0.0014199134f,   -0.0043700441f},
        {  -0.0050358040f,    0.0025658703f},
        {  -0.0071127326f,   -0.0097898366f},
        {  -0.0054047443f,    0.0054047443f},
        {  -0.0340257897f,   -0.0247211833f},
        {   0.0160348403f,   -0.0314701461f},
        {  -0.0569901065f,   -0.0185172081f},
        {   0.0336767754f,   -0.2126267914f},
        {   0.3294647168f,    0.0000000000f},
        {   0.0493335604f,    0.3114798415f},
        {  -0.1750797642f,    0.0568868638f},
        {  -0.0154534710f,   -0.0303291444f},
        {  -0.0347421838f,    0.0252416741f},
        {  -0.0257194246f,   -0.0257194246f},
        {   0.0008529956f,   -0.0011740477f},
        {  -0.0110689444f,   -0.0056399089f},
        {   0.0009614017f,   -0.0029588901f},
        {  -0.0052224822f,   -0.0008271599f},
        {  -0.0000000000f,   -0.0017821677f},
        {  -0.0040150098f,    0.0006359151f},
        {  -0.0009156640f,   -0.0028181240f},
        {  -0.0013422743f,    0.0006839229f}
    },
    {
        {  -0.0021709935f,   -0.0011061764f},     /* Filter 20 */
        {   0.0002323231f,   -0.0007150169f},
        {  -0.0036868820f,   -0.0005839447f},
        {   0.0000000000f,   -0.0033205371f},
        {  -0.0031100445f,    0.0004925827f},
        {  -0.0014119724f,   -0.0043456043f},
        {  -0.0050948817f,    0.0025959719f},
        {  -0.0070989590f,   -0.0097708788f},
        {  -0.0055280441f,    0.0055280441f},
        {  -0.0341310065f,   -0.0247976278f},
        {   0.0159211695f,   -0.0312470546f},
        {  -0.0576741947f,   -0.0187394818f},
        {   0.0338023139f,   -0.2134194107f},
        {   0.3297648658f,    0.0000000000f},
        {   0.0492647580f,    0.3110454402f},
        {  -0.1742862004f,    0.0566290193f},
        {  -0.0151627154f,   -0.0297585045f},
        {  -0.0348651405f,    0.0253310073f},
        {  -0.0256016596f,   -0.0256016596f},
        {   0.0007646444f,   -0.0010524428f},
        {  -0.0110638054f,   -0.0056372904f},
        {   0.0009408753f,   -0.0028957165f},
        {  -0.0052331148f,   -0.0008288440f},
        {  -0.0000000000f,   -0.0017453870f},
        {  -0.0040295204f,    0.0006382133f},
        {  -0.0009088446f,   -0.0027971360f},
        {  -0.0013574107f,    0.0006916353f}
    },
    {
        {  -0.0021752882f,   -0.0011083647f},     /* Filter 21 */
        {   0.0002256805f,   -0.0006945730f},
        {  -0.0037037255f,   -0.0005866125f},
        {   0.0000000000f,   -0.0032972252f},
        {  -0.0031423371f,    0.0004976973f},
        {  -0.0014039134f,   -0.0043208011f},
        {  -0.0051538904f,    0.0026260383f},
        {  -0.0070847143f,   -0.0097512727f},
        {  -0.0056517100f,    0.0056517100f},
        {  -0.0342353018f,   -0.0248734028f},
        {   0.0158063103f,   -0.0310216307f},
        {  -0.0583600246f,   -0.0189623215f},
        {   0.0339276705f,   -0.2142108808f},
        {   0.3300612587f,    0.0000000000f},
        {   0.0491954263f,    0.3106076970f},
        {  -0.1734921841f,    0.0563710278f},
        {  -0.0148729578f,   -0.0291898232f},
        {  -0.0349861306f,    0.0254189118f},
        {  -0.0254833823f,   -0.0254833823f},
        {   0.0006767090f,   -0.0009314100f},
        {  -0.0110580501f,   -0.0056343580f},
        {   0.0009203707f,   -0.0028326096f},
        {  -0.0052433761f,   -0.0008304692f},
        {  -0.0000000000f,   -0.0017085512f},
        {  -0.0040438090f,    0.0006404764f},
        {  -0.0009019959f,   -0.0027760579f},
        {  -0.0013724328f,    0.0006992894f}
    },
    {
        {  -0.0021794696f,   -0.0011104952f},     /* Filter 22 */
        {   0.0002190094f,   -0.0006740415f},
        {  -0.0037204152f,   -0.0005892559f},
        {   0.0000000000f,   -0.0032737161f},
        {  -0.0031744818f,    0.0005027885f},
        {  -0.0013957372f,   -0.0042956373f},
        {  -0.0052128211f,    0.0026560650f},
        {  -0.0070700018f,   -0.0097310227f},
        {  -0.0057757379f,    0.0057757379f},
        {  -0.0343386669f,   -0.0249485018f},
        {   0.0156902759f,   -0.0307939004f},
        {  -0.0590475577f,   -0.0191857145f},
        {   0.0340528424f,   -0.2150011852f},
        {   0.3303539045f,    0.0000000000f},
        {   0.0491255647f,    0.3101666084f},
        {  -0.1726977302f,    0.0561128940f},
        {  -0.0145842116f,   -0.0286231268f},
        {  -0.0351051571f,    0.0255053896f},
        {  -0.0253645869f,   -0.0253645868f},
        {   0.0005891905f,   -0.0008109511f},
        {  -0.0110516828f,   -0.0056311136f},
        {   0.0008998894f,   -0.0027695749f},
        {  -0.0052532571f,   -0.0008320342f},
        {  -0.0000000000f,   -0.0016716548f},
        {  -0.0040578765f,    0.0006427045f},
        {  -0.0008951164f,   -0.0027548851f},
        {  -0.0013873415f,    0.0007068858f}
    },
    {
        {  -0.0021835332f,   -0.0011125657f},     /* Filter 23 */
        {   0.0002123080f,   -0.0006534169f},
        {  -0.0037369580f,   -0.0005918760f},
        {   0.0000000000f,   -0.0032500058f},
        {  -0.0032064778f,    0.0005078562f},
        {  -0.0013874429f,   -0.0042701101f},
        {  -0.0052716754f,    0.0026860528f},
        {  -0.0070548131f,   -0.0097101173f},
        {  -0.0059001204f,    0.0059001204f},
        {  -0.0344410900f,   -0.0250229166f},
        {   0.0155730524f,   -0.0305638362f},
        {  -0.0597367984f,   -0.0194096624f},
        {   0.0341778230f,   -0.2157902819f},
        {   0.3306427857f,    0.0000000000f},
        {   0.0490551686f,    0.3097221447f},
        {  -0.1719028769f,    0.0558546306f},
        {  -0.0142964714f,   -0.0280584049f},
        {  -0.0352222256f,    0.0255904448f},
        {  -0.0252452876f,   -0.0252452876f},
        {   0.0005020904f,   -0.0006910682f},
        {  -0.0110447047f,   -0.0056275581f},
        {   0.0008794327f,   -0.0027066155f},
        {  -0.0052627649f,   -0.0008335401f},
        {  -0.0000000000f,   -0.0016347116f},
        {  -0.0040717178f,    0.0006448967f},
        {  -0.0008882074f,   -0.0027336213f},
        {  -0.0014021320f,    0.0007144220f}
    },
    {
        {  -0.0021874838f,   -0.0011145787f},     /* Filter 24 */
        {   0.0002055786f,   -0.0006327059f},
        {  -0.0037533457f,   -0.0005944716f},
        {   0.0000000000f,   -0.0032260964f},
        {  -0.0032383252f,    0.0005129003f},
        {  -0.0013790323f,   -0.0042442251f},
        {  -0.0053304459f,    0.0027159978f},
        {  -0.0070391540f,   -0.0096885644f},
        {  -0.0060248575f,    0.0060248575f},
        {  -0.0345425735f,   -0.0250966487f},
        {   0.0154546458f,   -0.0303314503f},
        {  -0.0604277411f,   -0.0196341633f},
        {   0.0343026178f,   -0.2165782048f},
        {   0.3309279035f,    0.0000000000f},
        {   0.0489842529f,    0.3092744009f},
        {  -0.1711076163f,    0.0555962347f},
        {  -0.0140097447f,   -0.0274956721f},
        {  -0.0353373491f,    0.0256740870f},
        {  -0.0251254954f,   -0.0251254954f},
        {   0.0004154116f,   -0.0005717650f},
        {  -0.0110371168f,   -0.0056236919f},
        {   0.0008590005f,   -0.0026437316f},
        {  -0.0052719037f,   -0.0008349875f},
        {  -0.0000000000f,   -0.0015977154f},
        {  -0.0040853303f,    0.0006470528f},
        {  -0.0008812689f,   -0.0027122668f},
        {  -0.0014168097f,    0.0007219006f}
    },
    {
        {  -0.0021913182f,   -0.0011165324f},     /* Filter 25 */
        {   0.0001988203f,   -0.0006119059f},
        {  -0.0037695819f,   -0.0005970431f},
        {   0.0000000000f,   -0.0032019911f},
        {  -0.0032700204f,    0.0005179204f},
        {  -0.0013705037f,   -0.0042179768f},
        {  -0.0053891314f,    0.0027458996f},
        {  -0.0070230192f,   -0.0096663567f},
        {  -0.0061499438f,    0.0061499438f},
        {  -0.0346430960f,   -0.0251696825f},
        {   0.0153350520f,   -0.0300967342f},
        {  -0.0611203609f,   -0.0198592091f},
        {   0.0344272156f,   -0.2173648848f},
        {   0.3312092597f,    0.0000000000f},
        {   0.0489128097f,    0.3088233260f},
        {  -0.1703119776f,    0.0553377160f},
        {  -0.0137240371f,   -0.0269349394f},
        {  -0.0354505202f,    0.0257563106f},
        {  -0.0250052112f,   -0.0250052112f},
        {   0.0003291546f,   -0.0004530424f},
        {  -0.0110289268f,   -0.0056195189f},
        {   0.0008385950f,   -0.0025809300f},
        {  -0.0052806669f,   -0.0008363755f},
        {  -0.0000000000f,   -0.0015606744f},
        {  -0.0040987206f,    0.0006491736f},
        {  -0.0008743021f,   -0.0026908252f},
        {  -0.0014313705f,    0.0007293197f}
    },
    {
        {  -0.0021950358f,   -0.0011184266f},     /* Filter 26 */
        {   0.0001920348f,   -0.0005910222f},
        {  -0.0037856664f,   -0.0005995907f},
        {   0.0000000000f,   -0.0031776877f},
        {  -0.0033015580f,    0.0005229154f},
        {  -0.0013618591f,   -0.0041913714f},
        {  -0.0054477253f,    0.0027757547f},
        {  -0.0070064077f,   -0.0096434929f},
        {  -0.0062753772f,    0.0062753772f},
        {  -0.0347426640f,   -0.0252420229f},
        {   0.0152142751f,   -0.0298596961f},
        {  -0.0618146580f,   -0.0200847999f},
        {   0.0345516193f,   -0.2181503385f},
        {   0.3314868370f,    0.0000000000f},
        {   0.0488408446f,    0.3083689567f},
        {  -0.1695159803f,    0.0550790808f},
        {  -0.0134393508f,   -0.0263762111f},
        {  -0.0355617515f,    0.0258371249f},
        {  -0.0248844430f,   -0.0248844430f},
        {   0.0002433249f,   -0.0003349080f},
        {  -0.0110201366f,   -0.0056150400f},
        {   0.0008182166f,   -0.0025182118f},
        {  -0.0052890581f,   -0.0008377045f},
        {  -0.0000000000f,   -0.0015235876f},
        {  -0.0041118878f,    0.0006512590f},
        {  -0.0008673053f,   -0.0026692913f},
        {  -0.0014458149f,    0.0007366795f}
    },
    {
        {  -0.0021986382f,   -0.0011202621f},     /* Filter 27 */
        {   0.0001852208f,   -0.0005700511f},
        {  -0.0038015912f,   -0.0006021129f},
        {   0.0000000000f,   -0.0031531871f},
        {  -0.0033329427f,    0.0005278863f},
        {  -0.0013530973f,   -0.0041644052f},
        {  -0.0055062248f,    0.0028055617f},
        {  -0.0069893153f,   -0.0096199673f},
        {  -0.0064011503f,    0.0064011503f},
        {  -0.0348412605f,   -0.0253136575f},
        {   0.0150923097f,   -0.0296203256f},
        {  -0.0625106192f,   -0.0203109314f},
        {   0.0346758233f,   -0.2189345318f},
        {   0.3317606309f,    0.0000000000f},
        {   0.0487683599f,    0.3079113063f},
        {  -0.1687196397f,    0.0548203341f},
        {  -0.0131556897f,   -0.0258194949f},
        {  -0.0356710455f,    0.0259165316f},
        {  -0.0247632008f,   -0.0247632008f},
        {   0.0001579238f,   -0.0002173634f},
        {  -0.0110107504f,   -0.0056102576f},
        {   0.0007978665f,   -0.0024555805f},
        {  -0.0052970776f,   -0.0008389747f},
        {  -0.0000000000f,   -0.0014864566f},
        {  -0.0041248212f,    0.0006533075f},
        {  -0.0008602826f,   -0.0026476775f},
        {  -0.0014601426f,    0.0007439798f}
    },
    {
        {  -0.0022021205f,   -0.0011220364f},     /* Filter 28 */
        {   0.0001783784f,   -0.0005489924f},
        {  -0.0038173642f,   -0.0006046111f},
        {   0.0000000000f,   -0.0031284972f},
        {  -0.0033641641f,    0.0005328312f},
        {  -0.0013442186f,   -0.0041370795f},
        {  -0.0055646300f,    0.0028353206f},
        {  -0.0069717498f,   -0.0095957903f},
        {  -0.0065272595f,    0.0065272595f},
        {  -0.0349388718f,   -0.0253845763f},
        {   0.0149691501f,   -0.0293786112f},
        {  -0.0632082284f,   -0.0205375984f},
        {   0.0347998259f,   -0.2197174532f},
        {   0.3320306306f,    0.0000000000f},
        {   0.0486953528f,    0.3074503577f},
        {  -0.1679229530f,    0.0545614749f},
        {  -0.0128730542f,   -0.0252647915f},
        {  -0.0357784018f,    0.0259945305f},
        {  -0.0246414871f,   -0.0246414870f},
        {   0.0000729497f,   -0.0001004067f},
        {  -0.0110007658f,   -0.0056051701f},
        {   0.0007775460f,   -0.0023930406f},
        {  -0.0053047256f,   -0.0008401860f},
        {  -0.0000000000f,   -0.0014492849f},
        {  -0.0041375369f,    0.0006553215f},
        {  -0.0008532325f,   -0.0026259796f},
        {  -0.0014743520f,    0.0007512199f}
    },
    {
        {  -0.0022054869f,   -0.0011237517f},     /* Filter 29 */
        {   0.0001715097f,   -0.0005278527f},
        {  -0.0038329794f,   -0.0006070843f},
        {   0.0000000000f,   -0.0031036105f},
        {  -0.0033952242f,    0.0005377507f},
        {  -0.0013352233f,   -0.0041093948f},
        {  -0.0056229327f,    0.0028650273f},
        {  -0.0069537018f,   -0.0095709494f},
        {  -0.0066537014f,    0.0066537014f},
        {  -0.0350355011f,   -0.0254547815f},
        {   0.0148448026f,   -0.0291345655f},
        {  -0.0639074789f,   -0.0207647986f},
        {   0.0349236250f,   -0.2204990899f},
        {   0.3322968292f,    0.0000000000f},
        {   0.0486218279f,    0.3069861396f},
        {  -0.1671259528f,    0.0543025138f},
        {  -0.0125914531f,   -0.0247121182f},
        {  -0.0358838323f,    0.0260711303f},
        {  -0.0245193118f,   -0.0245193118f},
        {  -0.0000115916f,    0.0000159544f},
        {  -0.0109901946f,   -0.0055997838f},
        {   0.0007572560f,   -0.0023305944f},
        {  -0.0053120041f,   -0.0008413388f},
        {  -0.0000000000f,   -0.0014120734f},
        {  -0.0041500234f,    0.0006572991f},
        {  -0.0008461542f,   -0.0026041949f},
        {  -0.0014884430f,    0.0007583996f}
    },
    {
        {  -0.0022087339f,   -0.0011254062f},     /* Filter 30 */
        {   0.0001646126f,   -0.0005066256f},
        {  -0.0038484382f,   -0.0006095327f},
        {   0.0000000000f,   -0.0030785301f},
        {  -0.0034261244f,    0.0005426448f},
        {  -0.0013261120f,   -0.0040813532f},
        {  -0.0056811318f,    0.0028946812f},
        {  -0.0069351713f,   -0.0095454444f},
        {  -0.0067804730f,    0.0067804730f},
        {  -0.0351311327f,   -0.0255242620f},
        {   0.0147192622f,   -0.0288881786f},
        {  -0.0646083561f,   -0.0209925275f},
        {   0.0350472173f,   -0.2212794214f},
        {   0.3325592196f,    0.0000000000f},
        {   0.0485477870f,    0.3065186635f},
        {  -0.1663286640f,    0.0540434590f},
        {  -0.0123108854f,   -0.0241614731f},
        {  -0.0359873394f,    0.0261463325f},
        {  -0.0243966809f,   -0.0243966808f},
        {  -0.0000956984f,    0.0001317175f},
        {  -0.0109790280f,   -0.0055940942f},
        {   0.0007369976f,   -0.0022682453f},
        {  -0.0053189108f,   -0.0008424327f},
        {  -0.0000000000f,   -0.0013748253f},
        {  -0.0041622804f,    0.0006592405f},
        {  -0.0008390498f,   -0.0025823298f},
        {  -0.0015024151f,    0.0007655187f}
    },
    {
        {  -0.0022118625f,   -0.0011270002f},     /* Filter 31 */
        {   0.0001576893f,   -0.0004853179f},
        {  -0.0038637337f,   -0.0006119553f},
        {   0.0000000000f,   -0.0030532624f},
        {  -0.0034568576f,    0.0005475125f},
        {  -0.0013168842f,   -0.0040529530f},
        {  -0.0057392236f,    0.0029242805f},
        {  -0.0069161628f,   -0.0095192815f},
        {  -0.0069075694f,    0.0069075694f},
        {  -0.0352257635f,   -0.0255930153f},
        {   0.0145925305f,   -0.0286394536f},
        {  -0.0653108539f,   -0.0212207828f},
        {   0.0351705998f,   -0.2220584278f},
        {   0.3328177905f,    0.0000000000f},
        {   0.0484732318f,    0.3060479408f},
        {  -0.1655310827f,    0.0537843091f},
        {  -0.0120313580f,   -0.0236128695f},
        {  -0.0360889259f,    0.0262201394f},
        {  -0.0242736037f,   -0.0242736037f},
        {  -0.0001793695f,    0.0002468810f},
        {  -0.0109672808f,   -0.0055881087f},
        {   0.0007167720f,   -0.0022059974f},
        {  -0.0053254484f,   -0.0008434682f},
        {  -0.0000000000f,   -0.0013375415f},
        {  -0.0041743131f,    0.0006611462f},
        {  -0.0008319195f,   -0.0025603850f},
        {  -0.0015162684f,    0.0007725774f}
    },
    {
        {  -0.0022148733f,   -0.0011285343f},     /* Filter 32 */
        {   0.0001507411f,   -0.0004639333f},
        {  -0.0038788694f,   -0.0006143526f},
        {   0.0000000000f,   -0.0030278003f},
        {  -0.0034874241f,    0.0005523537f},
        {  -0.0013075407f,   -0.0040241966f},
        {  -0.0057972012f,    0.0029538215f},
        {  -0.0068966684f,   -0.0094924497f},
        {  -0.0070349865f,    0.0070349865f},
        {  -0.0353193822f,   -0.0256610332f},
        {   0.0144646069f,   -0.0283883894f},
        {  -0.0660149525f,   -0.0214495583f},
        {   0.0352937702f,   -0.2228360951f},
        {   0.3330725580f,    0.0000000000f},
        {   0.0483981644f,    0.3055739837f},
        {  -0.1647332531f,    0.0535250786f},
        {  -0.0117528734f,   -0.0230663128f},
        {  -0.0361885991f,    0.0262925563f},
        {  -0.0241500844f,   -0.0241500844f},
        {  -0.0002626055f,    0.0003614454f},
        {  -0.0109549473f,   -0.0055818244f},
        {   0.0006965800f,   -0.0021438527f},
        {  -0.0053316185f,   -0.0008444454f},
        {  -0.0000000000f,   -0.0013002283f},
        {  -0.0041861158f,    0.0006630156f},
        {  -0.0008247632f,   -0.0025383600f},
        {  -0.0015300010f,    0.0007795745f}
    },
    {
        {  -0.0022177623f,   -0.0011300064f},     /* Filter 33 */
        {   0.0001437652f,   -0.0004424639f},
        {  -0.0038938406f,   -0.0006167238f},
        {   0.0000000000f,   -0.0030021495f},
        {  -0.0035178221f,    0.0005571683f},
        {  -0.0012980817f,   -0.0039950848f},
        {  -0.0058550643f,    0.0029833043f},
        {  -0.0068766888f,   -0.0094649501f},
        {  -0.0071627177f,    0.0071627177f},
        {  -0.0354119781f,   -0.0257283081f},
        {   0.0143354881f,   -0.0281349795f},
        {  -0.0667206479f,   -0.0216788527f},
        {   0.0354167248f,   -0.2236123999f},
        {   0.3333235086f,    0.0000000000f},
        {   0.0483225860f,    0.3050968003f},
        {  -0.1639351598f,    0.0532657623f},
        {  -0.0114754349f,   -0.0225218090f},
        {  -0.0362863596f,    0.0263635834f},
        {  -0.0240261303f,   -0.0240261303f},
        {  -0.0003454002f,    0.0004754026f},
        {  -0.0109420370f,   -0.0055752463f},
        {   0.0006764229f,   -0.0020818155f},
        {  -0.0053374169f,   -0.0008453638f},
        {  -0.0000000000f,   -0.0012628858f},
        {  -0.0041976948f,    0.0006648496f},
        {  -0.0008175826f,   -0.0025162605f},
        {  -0.0015436150f,    0.0007865111f}
    },
    {
        {  -0.0022205325f,   -0.0011314178f},     /* Filter 34 */
        {   0.0001367646f,   -0.0004209182f},
        {  -0.0039086496f,   -0.0006190693f},
        {   0.0000000000f,   -0.0029763130f},
        {  -0.0035480443f,    0.0005619550f},
        {  -0.0012885070f,   -0.0039656166f},
        {  -0.0059128092f,    0.0030127268f},
        {  -0.0068562238f,   -0.0094367826f},
        {  -0.0072907606f,    0.0072907606f},
        {  -0.0355035484f,   -0.0257948378f},
        {   0.0142051710f,   -0.0278792178f},
        {  -0.0674279328f,   -0.0219086634f},
        {   0.0355394639f,   -0.2243873441f},
        {   0.3335706260f,    0.0000000000f},
        {   0.0482464973f,    0.3046163955f},
        {  -0.1631368376f,    0.0530063717f},
        {  -0.0111990442f,   -0.0219793618f},
        {  -0.0363822251f,    0.0264332338f},
        {  -0.0239017519f,   -0.0239017519f},
        {  -0.0004277512f,    0.0005887490f},
        {  -0.0109285481f,   -0.0055683734f},
        {   0.0006563010f,   -0.0020198867f},
        {  -0.0053428512f,   -0.0008462245f},
        {  -0.0000000000f,   -0.0012255137f},
        {  -0.0042090432f,    0.0006666470f},
        {  -0.0008103756f,   -0.0024940795f},
        {  -0.0015571057f,    0.0007933850f}
    },
    {
        {  -0.0022231823f,   -0.0011327680f},     /* Filter 35 */
        {   0.0001297372f,   -0.0003992901f},
        {  -0.0039232962f,   -0.0006213891f},
        {   0.0000000000f,   -0.0029502835f},
        {  -0.0035780951f,    0.0005667146f},
        {  -0.0012788172f,   -0.0039357947f},
        {  -0.0059704311f,    0.0030420866f},
        {  -0.0068352744f,   -0.0094079482f},
        {  -0.0074191106f,    0.0074191106f},
        {  -0.0355940851f,   -0.0258606166f},
        {   0.0140736575f,   -0.0276211080f},
        {  -0.0681367848f,   -0.0221389834f},
        {   0.0356619806f,   -0.2251608839f},
        {   0.3338139023f,    0.0000000000f},
        {   0.0481699031f,    0.3041327986f},
        {  -0.1623383067f,    0.0527469133f},
        {  -0.0109237052f,   -0.0214389786f},
        {  -0.0364761835f,    0.0265014986f},
        {  -0.0237769522f,   -0.0237769522f},
        {  -0.0005096614f,    0.0007014887f},
        {  -0.0109144832f,   -0.0055612069f},
        {   0.0006362162f,   -0.0019580722f},
        {  -0.0053479162f,   -0.0008470267f},
        {  -0.0000000000f,   -0.0011881132f},
        {  -0.0042201659f,    0.0006684086f},
        {  -0.0008031447f,   -0.0024718253f},
        {  -0.0015704775f,    0.0008001983f}
    },
    {
        {  -0.0022257106f,   -0.0011340562f},     /* Filter 36 */
        {   0.0001226858f,   -0.0003775881f},
        {  -0.0039377785f,   -0.0006236829f},
        {   0.0000000000f,   -0.0029240706f},
        {  -0.0036079683f,    0.0005714460f},
        {  -0.0012690123f,   -0.0039056182f},
        {  -0.0060279260f,    0.0030713817f},
        {  -0.0068138363f,   -0.0093784411f},
        {  -0.0075477654f,    0.0075477654f},
        {  -0.0356835773f,   -0.0259256365f},
        {   0.0139409476f,   -0.0273606501f},
        {  -0.0688471974f,   -0.0223698105f},
        {   0.0357842761f,   -0.2259330273f},
        {   0.3340533515f,    0.0000000000f},
        {   0.0480928020f,    0.3036460014f},
        {  -0.1615395679f,    0.0524873873f},
        {  -0.0106494241f,   -0.0209006716f},
        {  -0.0365682525f,    0.0265683906f},
        {  -0.0236517400f,   -0.0236517400f},
        {  -0.0005911249f,    0.0008136137f},
        {  -0.0108998530f,   -0.0055537525f},
        {   0.0006161688f,   -0.0018963726f},
        {  -0.0053526174f,   -0.0008477713f},
        {  -0.0000000000f,   -0.0011506901f},
        {  -0.0042310587f,    0.0006701339f},
        {  -0.0007958903f,   -0.0024494986f},
        {  -0.0015837296f,    0.0008069505f}
    },
    {
        {  -0.0022281185f,   -0.0011352831f},     /* Filter 37 */
        {   0.0001156098f,   -0.0003558105f},
        {  -0.0039520956f,   -0.0006259504f},
        {   0.0000000000f,   -0.0028976751f},
        {  -0.0036376653f,    0.0005761496f},
        {  -0.0012590926f,   -0.0038750887f},
        {  -0.0060852914f,    0.0031006109f},
        {  -0.0067919097f,   -0.0093482617f},
        {  -0.0076767172f,    0.0076767172f},
        {  -0.0357720145f,   -0.0259898899f},
        {   0.0138070366f,   -0.0270978352f},
        {  -0.0695591611f,   -0.0226011415f},
        {   0.0359063480f,   -0.2267037589f},
        {   0.3342889675f,    0.0000000000f},
        {   0.0480151982f,    0.3031560303f},
        {  -0.1607406510f,    0.0522278035f},
        {  -0.0103761991f,   -0.0203644373f},
        {  -0.0366584350f,    0.0266339120f},
        {  -0.0235261215f,   -0.0235261215f},
        {  -0.0006721419f,    0.0009251240f},
        {  -0.0108846506f,   -0.0055460065f},
        {   0.0005961600f,   -0.0018347918f},
        {  -0.0053569537f,   -0.0008484581f},
        {  -0.0000000000f,   -0.0011132506f},
        {  -0.0042417193f,    0.0006718223f},
        {  -0.0007886122f,   -0.0024270988f},
        {  -0.0015968572f,    0.0008136394f}
    },
    {
        {  -0.0022304022f,   -0.0011364467f},     /* Filter 38 */
        {   0.0001085087f,   -0.0003339556f},
        {  -0.0039662425f,   -0.0006281911f},
        {   0.0000000000f,   -0.0028710917f},
        {  -0.0036671818f,    0.0005808245f},
        {  -0.0012490578f,   -0.0038442047f},
        {  -0.0061425226f,    0.0031297716f},
        {  -0.0067694939f,   -0.0093174091f},
        {  -0.0078059632f,    0.0078059632f},
        {  -0.0358593925f,   -0.0260533737f},
        {   0.0136719292f,   -0.0268326719f},
        {  -0.0702726572f,   -0.0228329704f},
        {   0.0360281864f,   -0.2274730162f},
        {   0.3345206886f,    0.0000000000f},
        {   0.0479370898f,    0.3026628734f},
        {  -0.1599415609f,    0.0519681634f},
        {  -0.0101040387f,   -0.0198302924f},
        {  -0.0367467241f,    0.0266980579f},
        {  -0.0234001010f,   -0.0234001010f},
        {  -0.0007527098f,    0.0010360162f},
        {  -0.0108688882f,   -0.0055379751f},
        {   0.0005761918f,   -0.0017733359f},
        {  -0.0053609232f,   -0.0008490868f},
        {  -0.0000000000f,   -0.0010757878f},
        {  -0.0042521612f,    0.0006734762f},
        {  -0.0007813108f,   -0.0024046275f},
        {  -0.0016098620f,    0.0008202657f}
    },
    {
        {  -0.0022325659f,   -0.0011375491f},     /* Filter 39 */
        {   0.0001013836f,   -0.0003120266f},
        {  -0.0039802216f,   -0.0006304052f},
        {   0.0000000000f,   -0.0028443280f},
        {  -0.0036965139f,    0.0005854703f},
        {  -0.0012389084f,   -0.0038129681f},
        {  -0.0061996157f,    0.0031588620f},
        {  -0.0067465878f,   -0.0092858815f},
        {  -0.0079354970f,    0.0079354970f},
        {  -0.0359456982f,   -0.0261160785f},
        {   0.0135356225f,   -0.0265651549f},
        {  -0.0709876777f,   -0.0230652947f},
        {   0.0361497965f,   -0.2282408324f},
        {   0.3347485628f,    0.0000000000f},
        {   0.0478584820f,    0.3021665630f},
        {  -0.1591423172f,    0.0517084734f},
        {  -0.0098329431f,   -0.0192982375f},
        {  -0.0368331385f,    0.0267608416f},
        {  -0.0232736903f,   -0.0232736903f},
        {  -0.0008328273f,    0.0011462885f},
        {  -0.0108525630f,   -0.0055296570f},
        {   0.0005562642f,   -0.0017120052f},
        {  -0.0053645285f,   -0.0008496578f},
        {  -0.0000000000f,   -0.0010383048f},
        {  -0.0042623665f,    0.0006750925f},
        {  -0.0007739869f,   -0.0023820868f},
        {  -0.0016227434f,    0.0008268290f}
    },
    {
        {  -0.0022346067f,   -0.0011385890f},     /* Filter 40 */
        {   0.0000942350f,   -0.0002900256f},
        {  -0.0039940319f,   -0.0006325925f},
        {   0.0000000000f,   -0.0028173807f},
        {  -0.0037256640f,    0.0005900872f},
        {  -0.0012286457f,   -0.0037813826f},
        {  -0.0062565682f,    0.0031878807f},
        {  -0.0067231917f,   -0.0092536796f},
        {  -0.0080653181f,    0.0080653181f},
        {  -0.0360309323f,   -0.0261780046f},
        {   0.0133981115f,   -0.0262952744f},
        {  -0.0717042118f,   -0.0232981107f},
        {   0.0362711726f,   -0.2290071711f},
        {   0.3349726054f,    0.0000000000f},
        {   0.0477793762f,    0.3016671090f},
        {  -0.1583429520f,    0.0514487439f},
        {  -0.0095629171f,   -0.0187682815f},
        {  -0.0369176808f,    0.0268222652f},
        {  -0.0231468974f,   -0.0231468974f},
        {  -0.0009124926f,    0.0012559383f},
        {  -0.0108356778f,   -0.0055210536f},
        {   0.0005363782f,   -0.0016508024f},
        {  -0.0053677718f,   -0.0008501715f},
        {  -0.0000000000f,   -0.0010008101f},
        {  -0.0042723457f,    0.0006766731f},
        {  -0.0007666411f,   -0.0023594786f},
        {  -0.0016355037f,    0.0008333308f}
    },
    {
        {  -0.0022365232f,   -0.0011395655f},     /* Filter 41 */
        {   0.0000870628f,   -0.0002679518f},
        {  -0.0040076731f,   -0.0006347531f},
        {   0.0000000000f,   -0.0027902521f},
        {  -0.0037546254f,    0.0005946742f},
        {  -0.0012182683f,   -0.0037494443f},
        {  -0.0063133765f,    0.0032168260f},
        {  -0.0066993029f,   -0.0092207994f},
        {  -0.0081954182f,    0.0081954182f},
        {  -0.0361150801f,   -0.0262391416f},
        {   0.0132593976f,   -0.0260230330f},
        {  -0.0724222525f,   -0.0235314163f},
        {   0.0363923116f,   -0.2297720123f},
        {   0.3351927556f,    0.0000000000f},
        {   0.0476997708f,    0.3011645002f},
        {  -0.1575434521f,    0.0511889706f},
        {  -0.0092939607f,   -0.0182404248f},
        {  -0.0370003574f,    0.0268823332f},
        {  -0.0230197214f,   -0.0230197214f},
        {  -0.0009917019f,    0.0013649606f},
        {  -0.0108182392f,   -0.0055121682f},
        {   0.0005165348f,   -0.0015897306f},
        {  -0.0053706532f,   -0.0008506279f},
        {  -0.0000000000f,   -0.0009633032f},
        {  -0.0042820985f,    0.0006782178f},
        {  -0.0007592726f,   -0.0023368007f},
        {  -0.0016481390f,    0.0008397688f}
    },
    {
        {  -0.0022383190f,   -0.0011404805f},     /* Filter 42 */
        {   0.0000798669f,   -0.0002458049f},
        {  -0.0040211370f,   -0.0006368855f},
        {   0.0000000000f,   -0.0027629465f},
        {  -0.0037834012f,    0.0005992319f},
        {  -0.0012077784f,   -0.0037171597f},
        {  -0.0063700344f,    0.0032456946f},
        {  -0.0066749202f,   -0.0091872395f},
        {  -0.0083257964f,    0.0083257964f},
        {  -0.0361981388f,   -0.0262994873f},
        {   0.0131194860f,   -0.0257484410f},
        {  -0.0731417811f,   -0.0237652053f},
        {   0.0365132145f,   -0.2305353631f},
        {   0.3354090492f,    0.0000000000f},
        {   0.0476196755f,    0.3006587981f},
        {  -0.1567438739f,    0.0509291719f},
        {  -0.0090260797f,   -0.0177146788f},
        {  -0.0370811655f,    0.0269410438f},
        {  -0.0228921794f,   -0.0228921794f},
        {  -0.0010704568f,    0.0014733573f},
        {  -0.0108002480f,   -0.0055030012f},
        {   0.0004967352f,   -0.0015287938f},
        {  -0.0053731737f,   -0.0008510271f},
        {  -0.0000000000f,   -0.0009257855f},
        {  -0.0042916190f,    0.0006797257f},
        {  -0.0007518828f,   -0.0023140572f},
        {  -0.0016606527f,    0.0008461448f}
    },
    {
        {  -0.0022399887f,   -0.0011413312f},     /* Filter 43 */
        {   0.0000726493f,   -0.0002235915f},
        {  -0.0040344299f,   -0.0006389909f},
        {   0.0000000000f,   -0.0027354617f},
        {  -0.0038119815f,    0.0006037586f},
        {  -0.0011971748f,   -0.0036845251f},
        {  -0.0064265378f,    0.0032744845f},
        {  -0.0066500430f,   -0.0091529990f},
        {  -0.0084564442f,    0.0084564442f},
        {  -0.0362800956f,   -0.0263590324f},
        {   0.0129783713f,   -0.0254714879f},
        {  -0.0738627827f,   -0.0239994729f},
        {   0.0366338730f,   -0.2312971713f},
        {   0.3356214637f,    0.0000000000f},
        {   0.0475390854f,    0.3001499723f},
        {  -0.1559442033f,    0.0506693432f},
        {  -0.0087592798f,   -0.0171910545f},
        {  -0.0371601215f,    0.0269984086f},
        {  -0.0227642672f,   -0.0227642672f},
        {  -0.0011487520f,    0.0015811215f},
        {  -0.0107817128f,   -0.0054935571f},
        {   0.0004769806f,   -0.0014679953f},
        {  -0.0053753300f,   -0.0008513686f},
        {  -0.0000000000f,   -0.0008882574f},
        {  -0.0043009099f,    0.0006811972f},
        {  -0.0007444717f,   -0.0022912484f},
        {  -0.0016730382f,    0.0008524555f}
    },
    {
        {  -0.0022415348f,   -0.0011421190f},     /* Filter 44 */
        {   0.0000654088f,   -0.0002013077f},
        {  -0.0040475567f,   -0.0006410700f},
        {   0.0000000000f,   -0.0027078003f},
        {  -0.0038403710f,    0.0006082550f},
        {  -0.0011864571f,   -0.0036515394f},
        {  -0.0064828908f,    0.0033031978f},
        {  -0.0066246707f,   -0.0091180770f},
        {  -0.0085873575f,    0.0085873575f},
        {  -0.0363609391f,   -0.0264177686f},
        {   0.0128360470f,   -0.0251921607f},
        {  -0.0745852583f,   -0.0242342195f},
        {   0.0367542882f,   -0.2320574430f},
        {   0.3358299840f,    0.0000000000f},
        {   0.0474580032f,    0.2996380397f},
        {  -0.1551444498f,    0.0504094875f},
        {  -0.0084935567f,   -0.0166695436f},
        {  -0.0372372219f,    0.0270544253f},
        {  -0.0226359994f,   -0.0226359994f},
        {  -0.0012265888f,    0.0016882547f},
        {  -0.0107626298f,   -0.0054838338f},
        {   0.0004572711f,   -0.0014073357f},
        {  -0.0053771277f,   -0.0008516534f},
        {  -0.0000000000f,   -0.0008507286f},
        {  -0.0043099736f,    0.0006826328f},
        {  -0.0007370403f,   -0.0022683768f},
        {  -0.0016852985f,    0.0008587025f}
    },
    {
        {  -0.0022429558f,   -0.0011428431f},     /* Filter 45 */
        {   0.0000581457f,   -0.0001789542f},
        {  -0.0040605034f,   -0.0006431206f},
        {   0.0000000000f,   -0.0026799609f},
        {  -0.0038685641f,    0.0006127204f},
        {  -0.0011756279f,   -0.0036182106f},
        {  -0.0065390777f,    0.0033318265f},
        {  -0.0065988038f,   -0.0090824743f},
        {  -0.0087185352f,    0.0087185352f},
        {  -0.0364406716f,   -0.0264756977f},
        {   0.0126925250f,   -0.0249104828f},
        {  -0.0753091817f,   -0.0244694365f},
        {   0.0368744548f,   -0.2328161450f},
        {   0.3360346197f,    0.0000000000f},
        {   0.0473764318f,    0.2991230182f},
        {  -0.1543446506f,    0.0501496170f},
        {  -0.0082289214f,   -0.0161501676f},
        {  -0.0373124730f,    0.0271090985f},
        {  -0.0225073789f,   -0.0225073789f},
        {  -0.0013039662f,    0.0017947555f},
        {  -0.0107430073f,   -0.0054738356f},
        {   0.0004376090f,   -0.0013468222f},
        {  -0.0053785675f,   -0.0008518814f},
        {  -0.0000000000f,   -0.0008131900f},
        {  -0.0043188118f,    0.0006840326f},
        {  -0.0007295900f,   -0.0022454470f},
        {  -0.0016974336f,    0.0008648856f}
    },
    {
        {  -0.0022442531f,   -0.0011435041f},     /* Filter 46 */
        {   0.0000508607f,   -0.0001565332f},
        {  -0.0040732755f,   -0.0006451435f},
        {   0.0000000000f,   -0.0026519463f},
        {  -0.0038965612f,    0.0006171547f},
        {  -0.0011646849f,   -0.0035845316f},
        {  -0.0065951068f,    0.0033603747f},
        {  -0.0065724401f,   -0.0090461878f},
        {  -0.0088499695f,    0.0088499695f},
        {  -0.0365192713f,   -0.0265328037f},
        {   0.0125477901f,   -0.0246264247f},
        {  -0.0760345493f,   -0.0247051227f},
        {   0.0369943758f,   -0.2335732964f},
        {   0.3362353715f,    0.0000000000f},
        {   0.0472943732f,    0.2986049201f},
        {  -0.1535448176f,    0.0498897355f},
        {  -0.0079653685f,   -0.0156329159f},
        {  -0.0373858889f,    0.0271624382f},
        {  -0.0223784170f,   -0.0223784170f},
        {  -0.0013808793f,    0.0019006173f},
        {  -0.0107228440f,   -0.0054635619f},
        {   0.0004179944f,   -0.0012864544f},
        {  -0.0053796470f,   -0.0008520524f},
        {  -0.0000000000f,   -0.0007756478f},
        {  -0.0043274173f,    0.0006853956f},
        {  -0.0007221187f,   -0.0022224528f},
        {  -0.0017094449f,    0.0008710057f}
    },
    {
        {  -0.0022454243f,   -0.0011441008f},     /* Filter 47 */
        {   0.0000435551f,   -0.0001340487f},
        {  -0.0040858657f,   -0.0006471375f},
        {   0.0000000000f,   -0.0026237608f},
        {  -0.0039243606f,    0.0006215577f},
        {  -0.0011536312f,   -0.0035505117f},
        {  -0.0066509631f,    0.0033888350f},
        {  -0.0065455769f,   -0.0090092137f},
        {  -0.0089816572f,    0.0089816572f},
        {  -0.0365967449f,   -0.0265890915f},
        {   0.0124018566f,   -0.0243400141f},
        {  -0.0767613480f,   -0.0249412739f},
        {   0.0371140423f,   -0.2343288410f},
        {   0.3364322263f,    0.0000000000f},
        {   0.0472118307f,    0.2980837677f},
        {  -0.1527449650f,    0.0496298476f},
        {  -0.0077029082f,   -0.0151178086f},
        {  -0.0374574722f,    0.0272144465f},
        {  -0.0222491169f,   -0.0222491169f},
        {  -0.0014573283f,    0.0020058404f},
        {  -0.0107021433f,   -0.0054530144f},
        {   0.0003984276f,   -0.0012262341f},
        {  -0.0053803718f,   -0.0008521672f},
        {  -0.0000000000f,   -0.0007381110f},
        {  -0.0043357913f,    0.0006867219f},
        {  -0.0007146270f,   -0.0021993958f},
        {  -0.0017213310f,    0.0008770619f}
    },
    {
        {  -0.0022464703f,   -0.0011446338f},     /* Filter 48 */
        {   0.0000362282f,   -0.0001114988f},
        {  -0.0040982843f,   -0.0006491045f},
        {   0.0000000000f,   -0.0025953985f},
        {  -0.0039519572f,    0.0006259285f},
        {  -0.0011424645f,   -0.0035161441f},
        {  -0.0067066524f,    0.0034172101f},
        {  -0.0065182191f,   -0.0089715590f},
        {  -0.0091135918f,    0.0091135918f},
        {  -0.0366730754f,   -0.0266445489f},
        {   0.0122547132f,   -0.0240512288f},
        {  -0.0774895642f,   -0.0251778857f},
        {   0.0372334541f,   -0.2350827773f},
        {   0.3366251695f,    0.0000000000f},
        {   0.0471288033f,    0.2975595531f},
        {  -0.1519450992f,    0.0493699555f},
        {  -0.0074415407f,   -0.0146048459f},
        {  -0.0375272169f,    0.0272651190f},
        {  -0.0221194870f,   -0.0221194870f},
        {  -0.0015333122f,    0.0021104232f},
        {  -0.0106809137f,   -0.0054421973f},
        {   0.0003789110f,   -0.0011661681f},
        {  -0.0053807401f,   -0.0008522255f},
        {  -0.0000000000f,   -0.0007005733f},
        {  -0.0043439389f,    0.0006880123f},
        {  -0.0007071195f,   -0.0021762900f},
        {  -0.0017330882f,    0.0008830525f}
    },
    {
        {  -0.0022473903f,   -0.0011451026f},     /* Filter 49 */
        {   0.0000288809f,   -0.0000888863f},
        {  -0.0041105253f,   -0.0006510433f},
        {   0.0000000000f,   -0.0025668690f},
        {  -0.0039793495f,    0.0006302670f},
        {  -0.0011311858f,   -0.0034814320f},
        {  -0.0067621637f,    0.0034454945f},
        {  -0.0064903592f,   -0.0089332130f},
        {  -0.0092457714f,    0.0092457714f},
        {  -0.0367482531f,   -0.0266991688f},
        {   0.0121063640f,   -0.0237600772f},
        {  -0.0782191848f,   -0.0254149538f},
        {   0.0373526110f,   -0.2358351039f},
        {   0.3368142103f,    0.0000000000f},
        {   0.0470452963f,    0.2970323104f},
        {  -0.1511452494f,    0.0491100685f},
        {  -0.0071812658f,   -0.0140940276f},
        {  -0.0375951417f,    0.0273144693f},
        {  -0.0219895354f,   -0.0219895354f},
        {  -0.0016088279f,    0.0022143617f},
        {  -0.0106591532f,   -0.0054311098f},
        {   0.0003594448f,   -0.0011062575f},
        {  -0.0053807534f,   -0.0008522276f},
        {  -0.0000000000f,   -0.0006630402f},
        {  -0.0043518542f,    0.0006892660f},
        {  -0.0006995909f,   -0.0021531195f},
        {  -0.0017447212f,    0.0008889799f}
    },
    {
        {  -0.0022481826f,   -0.0011455063f},     /* Filter 50 */
        {   0.0000215124f,   -0.0000662085f},
        {  -0.0041225812f,   -0.0006529527f},
        {   0.0000000000f,   -0.0025381729f},
        {  -0.0040065374f,    0.0006345732f},
        {  -0.0011197964f,   -0.0034463789f},
        {  -0.0068174982f,    0.0034736888f},
        {  -0.0064619996f,   -0.0088941795f},
        {  -0.0093781859f,    0.0093781859f},
        {  -0.0368222770f,   -0.0267529502f},
        {   0.0119568064f,   -0.0234665539f},
        {  -0.0789501938f,   -0.0256524730f},
        {   0.0374715012f,   -0.2365857471f},
        {   0.3369993395f,    0.0000000000f},
        {   0.0469613070f,    0.2965020230f},
        {  -0.1503454306f,    0.0488501916f},
        {  -0.0069220926f,   -0.0135853716f},
        {  -0.0376612461f,    0.0273624970f},
        {  -0.0218592629f,   -0.0218592629f},
        {  -0.0016838770f,    0.0023176579f},
        {  -0.0106368706f,   -0.0054197563f},
        {   0.0003400298f,   -0.0010465041f},
        {  -0.0053804087f,   -0.0008521730f},
        {  -0.0000000000f,   -0.0006255130f},
        {  -0.0043595438f,    0.0006904839f},
        {  -0.0006920455f,   -0.0021298969f},
        {  -0.0017562251f,    0.0008948414f}
    },
    {
        {  -0.0022488502f,   -0.0011458464f},     /* Filter 51 */
        {   0.0000141245f,   -0.0000434707f},
        {  -0.0041344617f,   -0.0006548344f},
        {   0.0000000000f,   -0.0025093019f},
        {  -0.0040335180f,    0.0006388465f},
        {  -0.0011082965f,   -0.0034109859f},
        {  -0.0068726491f,    0.0035017896f},
        {  -0.0064331423f,   -0.0088544608f},
        {  -0.0095108389f,    0.0095108389f},
        {  -0.0368951402f,   -0.0268058885f},
        {   0.0118060423f,   -0.0231706626f},
        {  -0.0796825853f,   -0.0258904414f},
        {   0.0375901346f,   -0.2373347695f},
        {   0.3371805647f,    0.0000000000f},
        {   0.0468768425f,    0.2959687351f},
        {  -0.1495456540f,    0.0485903285f},
        {  -0.0066640196f,   -0.0130788749f},
        {  -0.0377255408f,    0.0274092098f},
        {  -0.0217286837f,   -0.0217286837f},
        {  -0.0017584537f,    0.0024203039f},
        {  -0.0106140636f,   -0.0054081355f},
        {   0.0003206673f,   -0.0009869126f},
        {  -0.0053797155f,   -0.0008520632f},
        {  -0.0000000000f,   -0.0005879963f},
        {  -0.0043670009f,    0.0006916650f},
        {  -0.0006844835f,   -0.0021066237f},
        {  -0.0017676012f,    0.0009006378f}
    },
    {
        {  -0.0022493906f,   -0.0011461218f},     /* Filter 52 */
        {   0.0000067158f,   -0.0000206692f},
        {  -0.0041461563f,   -0.0006566866f},
        {   0.0000000000f,   -0.0024802648f},
        {  -0.0040602898f,    0.0006430867f},
        {  -0.0010966851f,   -0.0033752497f},
        {  -0.0069276141f,    0.0035297957f},
        {  -0.0064037822f,   -0.0088140501f},
        {  -0.0096437180f,    0.0096437180f},
        {  -0.0369668239f,   -0.0268579697f},
        {   0.0116540714f,   -0.0228724030f},
        {  -0.0804163482f,   -0.0261288554f},
        {   0.0377085026f,   -0.2380821155f},
        {   0.3373578615f,    0.0000000000f},
        {   0.0467919009f,    0.2954324350f},
        {  -0.1487459309f,    0.0483304827f},
        {  -0.0064070501f,   -0.0125745438f},
        {  -0.0377880257f,    0.0274546077f},
        {  -0.0215977999f,   -0.0215977999f},
        {  -0.0018325584f,    0.0025223003f},
        {  -0.0105907396f,   -0.0053962514f},
        {   0.0003013579f,   -0.0009274844f},
        {  -0.0053786652f,   -0.0008518969f},
        {  -0.0000000000f,   -0.0005504888f},
        {  -0.0043742317f,    0.0006928102f},
        {  -0.0006769032f,   -0.0020832938f},
        {  -0.0017788493f,    0.0009063690f}
    },
    {
        {  -0.0022498023f,   -0.0011463315f},     /* Filter 53 */
        {  -0.0000007105f,    0.0000021866f},
        {  -0.0041576695f,   -0.0006585102f},
        {   0.0000000000f,   -0.0024510651f},
        {  -0.0040868488f,    0.0006472933f},
        {  -0.0010849638f,   -0.0033391752f},
        {  -0.0069823897f,    0.0035577053f},
        {  -0.0063739197f,   -0.0087729478f},
        {  -0.0097768207f,    0.0097768207f},
        {  -0.0370373273f,   -0.0269091934f},
        {   0.0115008908f,   -0.0225717691f},
        {  -0.0811514623f,   -0.0263677085f},
        {   0.0378266004f,   -0.2388277557f},
        {   0.3375312165f,    0.0000000000f},
        {   0.0467064846f,    0.2948931379f},
        {  -0.1479462926f,    0.0480706645f},
        {  -0.0061511870f,   -0.0120723842f},
        {  -0.0378487057f,    0.0274986943f},
        {  -0.0214666211f,   -0.0214666211f},
        {  -0.0019061921f,    0.0026236483f},
        {  -0.0105669024f,   -0.0053841057f},
        {   0.0002821033f,   -0.0008682246f},
        {  -0.0053772639f,   -0.0008516749f},
        {  -0.0000000000f,   -0.0005129974f},
        {  -0.0043812313f,    0.0006939189f},
        {  -0.0006693064f,   -0.0020599133f},
        {  -0.0017899694f,    0.0009120349f}
    },
    {
        {  -0.0022500878f,   -0.0011464770f},     /* Filter 54 */
        {  -0.0000081573f,    0.0000251055f},
        {  -0.0041690028f,   -0.0006603052f},
        {   0.0000000000f,   -0.0024216984f},
        {  -0.0041131960f,    0.0006514662f},
        {  -0.0010731328f,   -0.0033027631f},
        {  -0.0070369692f,    0.0035855149f},
        {  -0.0063435547f,   -0.0087311541f},
        {  -0.0099101441f,    0.0099101441f},
        {  -0.0371066415f,   -0.0269595532f},
        {   0.0113465049f,   -0.0222687697f},
        {  -0.0818879174f,   -0.0266069972f},
        {   0.0379444273f,   -0.2395716850f},
        {   0.3377006790f,    0.0000000000f},
        {   0.0466205992f,    0.2943508790f},
        {  -0.1471467472f,    0.0478108764f},
        {  -0.0058964369f,   -0.0115724089f},
        {  -0.0379075894f,    0.0275414759f},
        {  -0.0213351496f,   -0.0213351496f},
        {  -0.0019793489f,    0.0027243401f},
        {  -0.0105425517f,   -0.0053716984f},
        {   0.0002629036f,   -0.0008091340f},
        {  -0.0053755151f,   -0.0008513979f},
        {  -0.0000000000f,   -0.0004755140f},
        {  -0.0043880048f,    0.0006949917f},
        {  -0.0006616940f,   -0.0020364848f},
        {  -0.0018009641f,    0.0009176370f}
    },
    {
        {  -0.0022502440f,   -0.0011465566f},     /* Filter 55 */
        {  -0.0000156216f,    0.0000480783f},
        {  -0.0041801479f,   -0.0006620704f},
        {   0.0000000000f,   -0.0023921649f},
        {  -0.0041393246f,    0.0006556046f},
        {  -0.0010611914f,   -0.0032660113f},
        {  -0.0070913538f,    0.0036132252f},
        {  -0.0063126885f,   -0.0086886704f},
        {  -0.0100436811f,    0.0100436811f},
        {  -0.0371747573f,   -0.0270090421f},
        {   0.0111909061f,   -0.0219633899f},
        {  -0.0826257082f,   -0.0268467200f},
        {   0.0380619805f,   -0.2403138872f},
        {   0.3378661729f,    0.0000000000f},
        {   0.0465342410f,    0.2938056346f},
        {  -0.1463473013f,    0.0475511207f},
        {  -0.0056427969f,   -0.0110746124f},
        {  -0.0379646890f,    0.0275829612f},
        {  -0.0212033969f,   -0.0212033969f},
        {  -0.0020520317f,    0.0028243793f},
        {  -0.0105176937f,   -0.0053590326f},
        {   0.0002437596f,   -0.0007502150f},
        {  -0.0053734107f,   -0.0008510646f},
        {  -0.0000000000f,   -0.0004380525f},
        {  -0.0043945464f,    0.0006960278f},
        {  -0.0006540651f,   -0.0020130052f},
        {  -0.0018118257f,    0.0009231713f}
    },
    {
        {  -0.0022502727f,   -0.0011465712f},     /* Filter 56 */
        {  -0.0000231042f,    0.0000711074f},
        {  -0.0041911082f,   -0.0006638063f},
        {   0.0000000000f,   -0.0023624732f},
        {  -0.0041652385f,    0.0006597090f},
        {  -0.0010491418f,   -0.0032289263f},
        {  -0.0071455361f,    0.0036408325f},
        {  -0.0062813164f,   -0.0086454904f},
        {  -0.0101774269f,    0.0101774269f},
        {  -0.0372416715f,   -0.0270576581f},
        {   0.0110340968f,   -0.0216556342f},
        {  -0.0833648092f,   -0.0270868685f},
        {   0.0381792592f,   -0.2410543557f},
        {   0.3380277742f,    0.0000000000f},
        {   0.0464474173f,    0.2932574514f},
        {  -0.1455479905f,    0.0472914089f},
        {  -0.0053902680f,   -0.0105789967f},
        {  -0.0380200008f,    0.0276231475f},
        {  -0.0210713702f,   -0.0210713702f},
        {  -0.0021242368f,    0.0029237612f},
        {  -0.0104923262f,   -0.0053461072f},
        {   0.0002246725f,   -0.0006914707f},
        {  -0.0053709647f,   -0.0008506772f},
        {  -0.0000000000f,   -0.0004006073f},
        {  -0.0044008610f,    0.0006970279f},
        {  -0.0006464218f,   -0.0019894817f},
        {  -0.0018225596f,    0.0009286405f}
    },
    {
        {  -0.0022501716f,   -0.0011465197f},     /* Filter 57 */
        {  -0.0000306060f,    0.0000941955f},
        {  -0.0042018827f,   -0.0006655128f},
        {   0.0000000000f,   -0.0023326243f},
        {  -0.0041909284f,    0.0006637778f},
        {  -0.0010369820f,   -0.0031915023f},
        {  -0.0071995141f,    0.0036683357f},
        {  -0.0062494398f,   -0.0086016160f},
        {  -0.0103113770f,    0.0103113770f},
        {  -0.0373073694f,   -0.0271053905f},
        {   0.0108760800f,   -0.0213455089f},
        {  -0.0841052204f,   -0.0273274427f},
        {   0.0382962586f,   -0.2417930608f},
        {   0.3381854075f,    0.0000000000f},
        {   0.0463601257f,    0.2927063137f},
        {  -0.1447488052f,    0.0470317378f},
        {  -0.0051388586f,   -0.0100855779f},
        {  -0.0380735357f,    0.0276620429f},
        {  -0.0209390691f,   -0.0209390691f},
        {  -0.0021959615f,    0.0030224817f},
        {  -0.0104664619f,   -0.0053329287f},
        {   0.0002056433f,   -0.0006329051f},
        {  -0.0053681691f,   -0.0008502345f},
        {  -0.0000000000f,   -0.0003631842f},
        {  -0.0044069406f,    0.0006979908f},
        {  -0.0006387617f,   -0.0019659065f},
        {  -0.0018331638f,    0.0009340436f}
    },
    {
        {  -0.0022499438f,   -0.0011464036f},     /* Filter 58 */
        {  -0.0000381241f,    0.0001173340f},
        {  -0.0042124676f,   -0.0006671893f},
        {   0.0000000000f,   -0.0023026112f},
        {  -0.0042164035f,    0.0006678127f},
        {  -0.0010247148f,   -0.0031537479f},
        {  -0.0072532811f,    0.0036957313f},
        {  -0.0062170590f,   -0.0085570476f},
        {  -0.0104455273f,    0.0104455273f},
        {  -0.0373718527f,   -0.0271522404f},
        {   0.0107168551f,   -0.0210330123f},
        {  -0.0848469266f,   -0.0275684376f},
        {   0.0384129780f,   -0.2425299982f},
        {   0.3383391016f,    0.0000000000f},
        {   0.0462723730f,    0.2921522650f},
        {  -0.1439497886f,    0.0467721216f},
        {  -0.0048885718f,   -0.0095943625f},
        {  -0.0381252938f,    0.0276996474f},
        {  -0.0208065105f,   -0.0208065104f},
        {  -0.0022672080f,    0.0031205442f},
        {  -0.0104400974f,   -0.0053194953f},
        {   0.0001866731f,   -0.0005745208f},
        {  -0.0053650246f,   -0.0008497364f},
        {  -0.0000000000f,   -0.0003257856f},
        {  -0.0044127979f,    0.0006989185f},
        {  -0.0006310899f,   -0.0019422951f},
        {  -0.0018436386f,    0.0009393808f}
    },
    {
        {  -0.0022495854f,   -0.0011462210f},     /* Filter 59 */
        {  -0.0000456602f,    0.0001405276f},
        {  -0.0042228650f,   -0.0006688361f},
        {   0.0000000000f,   -0.0022724392f},
        {  -0.0042416532f,    0.0006718119f},
        {  -0.0010123388f,   -0.0031156583f},
        {  -0.0073068366f,    0.0037230192f},
        {  -0.0061841719f,   -0.0085117824f},
        {  -0.0105798714f,    0.0105798714f},
        {  -0.0374351001f,   -0.0271981923f},
        {   0.0105564182f,   -0.0207181373f},
        {  -0.0855898985f,   -0.0278098438f},
        {   0.0385294149f,   -0.2432651518f},
        {   0.3384888443f,    0.0000000000f},
        {   0.0461841561f,    0.2915952853f},
        {  -0.1431509477f,    0.0465125625f},
        {  -0.0046394033f,   -0.0091053416f},
        {  -0.0381752904f,    0.0277359720f},
        {  -0.0206736926f,   -0.0206736926f},
        {  -0.0023379747f,    0.0032179461f},
        {  -0.0104132366f,   -0.0053058091f},
        {   0.0001677624f,   -0.0005163194f},
        {  -0.0053615377f,   -0.0008491842f},
        {  -0.0000000000f,   -0.0002884118f},
        {  -0.0044184245f,    0.0006998097f},
        {  -0.0006234019f,   -0.0019186336f},
        {  -0.0018539861f,    0.0009446531f}
    },
    {
        {  -0.0022490980f,   -0.0011459727f},     /* Filter 60 */
        {  -0.0000532127f,    0.0001637720f},
        {  -0.0042330752f,   -0.0006704533f},
        {   0.0000000000f,   -0.0022421145f},
        {  -0.0042666731f,    0.0006757746f},
        {  -0.0009998548f,   -0.0030772368f},
        {  -0.0073601752f,    0.0037501966f},
        {  -0.0061507798f,   -0.0084658221f},
        {  -0.0107144051f,    0.0107144051f},
        {  -0.0374971151f,   -0.0272432488f},
        {   0.0103947715f,   -0.0204008878f},
        {  -0.0863341457f,   -0.0280516644f},
        {   0.0386455624f,   -0.2439984781f},
        {   0.3386346272f,    0.0000000000f},
        {   0.0460954822f,    0.2910354206f},
        {  -0.1423522805f,    0.0462530597f},
        {  -0.0043913598f,   -0.0086185289f},
        {  -0.0382235216f,    0.0277710140f},
        {  -0.0205406256f,   -0.0205406256f},
        {  -0.0024082571f,    0.0033146815f},
        {  -0.0103858860f,   -0.0052918732f},
        {   0.0001489124f,   -0.0004583052f},
        {  -0.0053577070f,   -0.0008485774f},
        {  -0.0000000000f,   -0.0002510630f},
        {  -0.0044238206f,    0.0007006644f},
        {  -0.0006157019f,   -0.0018949355f},
        {  -0.0018642004f,    0.0009498575f}
    },
    {
        {  -0.0022484808f,   -0.0011456582f},     /* Filter 61 */
        {  -0.0000607804f,    0.0001870628f},
        {  -0.0042430934f,   -0.0006720400f},
        {   0.0000000000f,   -0.0022116302f},
        {  -0.0042914705f,    0.0006797022f},
        {  -0.0009872642f,   -0.0030384868f},
        {  -0.0074132930f,    0.0037772614f},
        {  -0.0061168795f,   -0.0084191624f},
        {  -0.0108491236f,    0.0108491236f},
        {  -0.0375578842f,   -0.0272874001f},
        {   0.0102319154f,   -0.0200812646f},
        {  -0.0870796498f,   -0.0282938934f},
        {   0.0387614234f,   -0.2447299955f},
        {   0.3387764777f,    0.0000000000f},
        {   0.0460063488f,    0.2904726541f},
        {  -0.1415538244f,    0.0459936256f},
        {  -0.0041444459f,   -0.0081339331f},
        {  -0.0382700034f,    0.0278047850f},
        {  -0.0204073193f,   -0.0204073193f},
        {  -0.0024780545f,    0.0034107494f},
        {  -0.0103580480f,   -0.0052776890f},
        {   0.0001301236f,   -0.0004004791f},
        {  -0.0053535336f,   -0.0008479164f},
        {  -0.0000000000f,   -0.0002137479f},
        {  -0.0044289903f,    0.0007014831f},
        {  -0.0006079877f,   -0.0018711939f},
        {  -0.0018742850f,    0.0009549959f}
    },
    {
        {  -0.0022477336f,   -0.0011452775f},     /* Filter 62 */
        {  -0.0000683662f,    0.0002104096f},
        {  -0.0042529265f,   -0.0006735974f},
        {   0.0000000000f,   -0.0021809969f},
        {  -0.0043160343f,    0.0006835927f},
        {  -0.0009745664f,   -0.0029994070f},
        {  -0.0074661872f,    0.0038042124f},
        {  -0.0060824726f,   -0.0083718053f},
        {  -0.0109840200f,    0.0109840200f},
        {  -0.0376174025f,   -0.0273306427f},
        {   0.0100678484f,   -0.0197592651f},
        {  -0.0878263866f,   -0.0285365229f},
        {   0.0388769943f,   -0.2454596814f},
        {   0.3389143782f,    0.0000000000f},
        {   0.0459167605f,    0.2899070162f},
        {  -0.1407555807f,    0.0457342605f},
        {  -0.0038986588f,   -0.0076515486f},
        {  -0.0383147369f,    0.0278372858f},
        {  -0.0202737736f,   -0.0202737736f},
        {  -0.0025473698f,    0.0035061537f},
        {  -0.0103297257f,   -0.0052632581f},
        {   0.0001113966f,   -0.0003428435f},
        {  -0.0053490169f,   -0.0008472010f},
        {  -0.0000000000f,   -0.0001764611f},
        {  -0.0044339292f,    0.0007022654f},
        {  -0.0006002610f,   -0.0018474133f},
        {  -0.0018842402f,    0.0009600683f}
    },
    {
        {  -0.0022468561f,   -0.0011448304f},     /* Filter 63 */
        {  -0.0000759667f,    0.0002338013f},
        {  -0.0042625620f,   -0.0006751235f},
        {   0.0000000000f,   -0.0021502064f},
        {  -0.0043403667f,    0.0006874465f},
        {  -0.0009617615f,   -0.0029599977f},
        {  -0.0075188538f,    0.0038310474f},
        {  -0.0060475588f,   -0.0083237506f},
        {  -0.0111190914f,    0.0111190914f},
        {  -0.0376756581f,   -0.0273729679f},
        {   0.0099025724f,   -0.0194348927f},
        {  -0.0885743593f,   -0.0287795539f},
        {   0.0389922690f,   -0.2461874974f},
        {   0.3390482929f,    0.0000000000f},
        {   0.0458267191f,    0.2893385169f},
        {  -0.1399575771f,    0.0454749735f},
        {  -0.0036540038f,   -0.0071713863f},
        {  -0.0383577269f,    0.0278685199f},
        {  -0.0201399968f,   -0.0201399968f},
        {  -0.0026161974f,    0.0036008869f},
        {  -0.0103009234f,   -0.0052485826f},
        {   0.0000927328f,   -0.0002854022f},
        {  -0.0053441572f,   -0.0008464313f},
        {  -0.0000000000f,   -0.0001392054f},
        {  -0.0044386430f,    0.0007030120f},
        {  -0.0005925210f,   -0.0018235921f},
        {  -0.0018940611f,    0.0009650723f}
    },
    {
        {  -0.0022458480f,   -0.0011443167f},     /* Filter 64 */
        {  -0.0000835820f,    0.0002572390f},
        {  -0.0042720048f,   -0.0006766191f},
        {   0.0000000000f,   -0.0021192677f},
        {  -0.0043644688f,    0.0006912640f},
        {  -0.0009488505f,   -0.0029202617f},
        {  -0.0075712885f,    0.0038577642f},
        {  -0.0060121356f,   -0.0082749947f},
        {  -0.0112543303f,    0.0112543303f},
        {  -0.0377326433f,   -0.0274143701f},
        {   0.0097360827f,   -0.0191081382f},
        {  -0.0893235341f,   -0.0290229756f},
        {   0.0391072478f,   -0.2469134452f},
        {   0.3391782445f,    0.0000000000f},
        {   0.0457362256f,    0.2887671637f},
        {  -0.1391598293f,    0.0452157695f},
        {  -0.0034104848f,   -0.0066934534f},
        {  -0.0383989776f,    0.0278984903f},
        {  -0.0200059998f,   -0.0200059998f},
        {  -0.0026845378f,    0.0036949493f},
        {  -0.0102716430f,   -0.0052336635f},
        {   0.0000741335f,   -0.0002281595f},
        {  -0.0053389628f,   -0.0008456086f},
        {  -0.0000000000f,   -0.0001019889f},
        {  -0.0044431266f,    0.0007037221f},
        {  -0.0005847711f,   -0.0017997404f},
        {  -0.0019037530f,    0.0009700106f}
    },
    {
        {  -0.0022447108f,   -0.0011437373f},     /* Filter 65 */
        {  -0.0000912136f,    0.0002807266f},
        {  -0.0042812542f,   -0.0006780840f},
        {   0.0000000000f,   -0.0020881801f},
        {  -0.0043883332f,    0.0006950437f},
        {  -0.0009358341f,   -0.0028802012f},
        {  -0.0076234876f,    0.0038843610f},
        {  -0.0059762043f,   -0.0082255396f},
        {  -0.0113897330f,    0.0113897330f},
        {  -0.0377883557f,   -0.0274548475f},
        {   0.0095683866f,   -0.0187790160f},
        {  -0.0900739211f,   -0.0292667911f},
        {   0.0392219302f,   -0.2476375210f},
        {   0.3393042459f,    0.0000000000f},
        {   0.0456452799f,    0.2881929551f},
        {  -0.1383623364f,    0.0449566483f},
        {  -0.0031681003f,   -0.0062177469f},
        {  -0.0384385005f,    0.0279272053f},
        {  -0.0198717871f,   -0.0198717871f},
        {  -0.0027523906f,    0.0037883407f},
        {  -0.0102418869f,   -0.0052185020f},
        {   0.0000555987f,   -0.0001711151f},
        {  -0.0053334257f,   -0.0008447316f},
        {  -0.0000000000f,   -0.0000648082f},
        {  -0.0044473797f,    0.0007043957f},
        {  -0.0005770089f,   -0.0017758509f},
        {  -0.0019133143f,    0.0009748823f}
    },
    {
        {  -0.0022434404f,   -0.0011430900f},     /* Filter 66 */
        {  -0.0000988591f,    0.0003042571f},
        {  -0.0042903141f,   -0.0006795190f},
        {   0.0000000000f,   -0.0020569427f},
        {  -0.0044119618f,    0.0006987861f},
        {  -0.0009227124f,   -0.0028398167f},
        {  -0.0076754477f,    0.0039108359f},
        {  -0.0059397663f,   -0.0081753869f},
        {  -0.0115252954f,    0.0115252954f},
        {  -0.0378427866f,   -0.0274943939f},
        {   0.0093994769f,   -0.0184475121f},
        {  -0.0908254902f,   -0.0295109907f},
        {   0.0393363079f,   -0.2483596736f},
        {   0.3394262701f,    0.0000000000f},
        {   0.0455538916f,    0.2876159521f},
        {  -0.1375651403f,    0.0446976236f},
        {  -0.0029268546f,   -0.0057442757f},
        {  -0.0384763002f,    0.0279546684f},
        {  -0.0197373608f,   -0.0197373608f},
        {  -0.0028197549f,    0.0038810597f},
        {  -0.0102116616f,   -0.0052031015f},
        {   0.0000371295f,   -0.0001142728f},
        {  -0.0053275531f,   -0.0008438015f},
        {  -0.0000000000f,   -0.0000276667f},
        {  -0.0044514082f,    0.0007050338f},
        {  -0.0005692359f,   -0.0017519279f},
        {  -0.0019227418f,    0.0009796859f}
    },
    {
        {  -0.0022420391f,   -0.0011423760f},     /* Filter 67 */
        {  -0.0001065191f,    0.0003278322f},
        {  -0.0042991742f,   -0.0006809223f},
        {   0.0000000000f,   -0.0020255556f},
        {  -0.0044353502f,    0.0007024905f},
        {  -0.0009094853f,   -0.0027991078f},
        {  -0.0077271635f,    0.0039371865f},
        {  -0.0059028162f,   -0.0081245295f},
        {  -0.0116610092f,    0.0116610092f},
        {  -0.0378959245f,   -0.0275330008f},
        {   0.0092293595f,   -0.0181136380f},
        {  -0.0915782328f,   -0.0297555716f},
        {   0.0394503819f,   -0.2490799083f},
        {   0.3395443142f,    0.0000000000f},
        {   0.0454620561f,    0.2870361257f},
        {  -0.1367682311f,    0.0444386921f},
        {  -0.0026867496f,   -0.0052730430f},
        {  -0.0385123800f,    0.0279808820f},
        {  -0.0196027359f,   -0.0196027359f},
        {  -0.0028866289f,    0.0039731038f},
        {  -0.0101809712f,   -0.0051874639f},
        {   0.0000187268f,   -0.0000576352f},
        {  -0.0053213449f,   -0.0008428182f},
        {   0.0000000000f,    0.0000094350f},
        {  -0.0044552115f,    0.0007056362f},
        {  -0.0005614523f,   -0.0017279724f},
        {  -0.0019320384f,    0.0009844227f}
    },
    {
        {  -0.0022405060f,   -0.0011415948f},     /* Filter 68 */
        {  -0.0001141917f,    0.0003514459f},
        {  -0.0043078420f,   -0.0006822951f},
        {   0.0000000000f,   -0.0019940273f},
        {  -0.0044584965f,    0.0007061565f},
        {  -0.0008961544f,   -0.0027580796f},
        {  -0.0077786333f,    0.0039634116f},
        {  -0.0058653573f,   -0.0080729717f},
        {  -0.0117968713f,    0.0117968713f},
        {  -0.0379477617f,   -0.0275706627f},
        {   0.0090580301f,   -0.0177773850f},
        {  -0.0923321333f,   -0.0300005287f},
        {   0.0395641481f,   -0.2497981996f},
        {   0.3396583880f,    0.0000000000f},
        {   0.0453697749f,    0.2864534851f},
        {  -0.1359716398f,    0.0441798639f},
        {  -0.0024477914f,   -0.0048040611f},
        {  -0.0385467483f,    0.0280058520f},
        {  -0.0194679109f,   -0.0194679108f},
        {  -0.0029530116f,    0.0040644718f},
        {  -0.0101498145f,   -0.0051715888f},
        {   0.0000003917f,   -0.0000012056f},
        {  -0.0053148036f,   -0.0008417822f},
        {   0.0000000000f,    0.0000464885f},
        {  -0.0044587869f,    0.0007062025f},
        {  -0.0005536582f,   -0.0017039849f},
        {  -0.0019412022f,    0.0009890919f}
    },
    {
        {  -0.0022388438f,   -0.0011407479f},     /* Filter 69 */
        {  -0.0001218783f,    0.0003751028f},
        {  -0.0043163061f,   -0.0006836357f},
        {   0.0000000000f,   -0.0019623556f},
        {  -0.0044814011f,    0.0007097842f},
        {  -0.0008827194f,   -0.0027167309f},
        {  -0.0078298528f,    0.0039895092f},
        {  -0.0058273888f,   -0.0080207126f},
        {  -0.0119328775f,    0.0119328775f},
        {  -0.0379982948f,   -0.0276073771f},
        {   0.0088854919f,   -0.0174387598f},
        {  -0.0930871872f,   -0.0302458606f},
        {   0.0396776072f,   -0.2505145525f},
        {   0.3397684880f,    0.0000000000f},
        {   0.0452770566f,    0.2858680847f},
        {  -0.1351753758f,    0.0439211421f},
        {  -0.0022099760f,   -0.0043373221f},
        {  -0.0385794176f,    0.0280295876f},
        {  -0.0193328981f,   -0.0193328981f},
        {  -0.0030189005f,    0.0041551601f},
        {  -0.0101182016f,   -0.0051554812f},
        {  -0.0000178756f,    0.0000550153f},
        {  -0.0053079282f,   -0.0008406932f},
        {   0.0000000000f,    0.0000835019f},
        {  -0.0044621312f,    0.0007067322f},
        {  -0.0005458542f,   -0.0016799665f},
        {  -0.0019502349f,    0.0009936943f}
    },
    {
        {  -0.0022370475f,   -0.0011398326f},     /* Filter 70 */
        {  -0.0001295793f,    0.0003988042f},
        {  -0.0043245792f,   -0.0006849461f},
        {   0.0000000000f,   -0.0019305404f},
        {  -0.0045040620f,    0.0007133733f},
        {  -0.0008691803f,   -0.0026750618f},
        {  -0.0078808157f,    0.0040154761f},
        {  -0.0057889082f,   -0.0079677486f},
        {  -0.0120690194f,    0.0120690194f},
        {  -0.0380475075f,   -0.0276431323f},
        {   0.0087117470f,   -0.0170977662f},
        {  -0.0938433728f,   -0.0304915602f},
        {   0.0397907528f,   -0.2512289255f},
        {   0.3398745972f,    0.0000000000f},
        {   0.0451838979f,    0.2852799039f},
        {  -0.1343794616f,    0.0436625339f},
        {  -0.0019733077f,   -0.0038728344f},
        {  -0.0386103854f,    0.0280520870f},
        {  -0.0191976997f,   -0.0191976997f},
        {  -0.0030842956f,    0.0042451687f},
        {  -0.0100861291f,   -0.0051391395f},
        {  -0.0000360739f,    0.0001110239f},
        {  -0.0053007186f,   -0.0008395513f},
        {   0.0000000000f,    0.0001204636f},
        {  -0.0044652477f,    0.0007072258f},
        {  -0.0005380409f,   -0.0016559196f},
        {  -0.0019591345f,    0.0009982289f}
    },
    {
        {  -0.0022351193f,   -0.0011388502f},     /* Filter 71 */
        {  -0.0001372916f,    0.0004225402f},
        {  -0.0043326526f,   -0.0006862248f},
        {   0.0000000000f,   -0.0018985847f},
        {  -0.0045264729f,    0.0007169229f},
        {  -0.0008555388f,   -0.0026330778f},
        {  -0.0079315220f,    0.0040413123f},
        {  -0.0057499191f,   -0.0079140847f},
        {  -0.0122052947f,    0.0122052947f},
        {  -0.0380954013f,   -0.0276779292f},
        {   0.0085367892f,   -0.0167543922f},
        {  -0.0946006731f,   -0.0307376220f},
        {   0.0399035852f,   -0.2519413212f},
        {   0.3399767352f,    0.0000000000f},
        {   0.0450903019f,    0.2846889619f},
        {  -0.1335839077f,    0.0434040427f},
        {  -0.0017377909f,   -0.0034106068f},
        {  -0.0386396562f,    0.0280733535f},
        {  -0.0190623224f,   -0.0190623224f},
        {  -0.0031491979f,    0.0043344990f},
        {  -0.0100536090f,   -0.0051225696f},
        {  -0.0000542017f,    0.0001668158f},
        {  -0.0052931768f,   -0.0008383569f},
        {   0.0000000000f,    0.0001573786f},
        {  -0.0044681412f,    0.0007076840f},
        {  -0.0005302207f,   -0.0016318514f},
        {  -0.0019679000f,    0.0010026952f}
    },
    {
        {  -0.0022330599f,   -0.0011378009f},     /* Filter 72 */
        {  -0.0001450151f,    0.0004463107f},
        {  -0.0043405200f,   -0.0006874708f},
        {   0.0000000000f,   -0.0018664891f},
        {  -0.0045486380f,    0.0007204335f},
        {  -0.0008417947f,   -0.0025907777f},
        {  -0.0079819653f,    0.0040670144f},
        {  -0.0057104183f,   -0.0078597165f},
        {  -0.0123416968f,    0.0123416968f},
        {  -0.0381419710f,   -0.0277117641f},
        {   0.0083606221f,   -0.0164086448f},
        {  -0.0953590886f,   -0.0309840461f},
        {   0.0400161008f,   -0.2526517170f},
        {   0.3400748842f,    0.0000000000f},
        {   0.0449962735f,    0.2840952899f},
        {  -0.1327887358f,    0.0431456757f},
        {  -0.0015034225f,   -0.0029506329f},
        {  -0.0386672447f,    0.0280933977f},
        {  -0.0189267792f,   -0.0189267792f},
        {  -0.0032136048f,    0.0044231476f},
        {  -0.0100206356f,   -0.0051057689f},
        {  -0.0000722598f,    0.0002223928f},
        {  -0.0052853097f,   -0.0008371108f},
        {   0.0000000000f,    0.0001942402f},
        {  -0.0044708094f,    0.0007081066f},
        {  -0.0005223897f,   -0.0016077501f},
        {  -0.0019765358f,    0.0010070953f}
    },
    {
        {  -0.0022308664f,   -0.0011366832f},     /* Filter 73 */
        {  -0.0001527526f,    0.0004701241f},
        {  -0.0043481937f,   -0.0006886862f},
        {   0.0000000000f,   -0.0018342587f},
        {  -0.0045705499f,    0.0007239040f},
        {  -0.0008279475f,   -0.0025481605f},
        {  -0.0080321422f,    0.0040925809f},
        {  -0.0056704053f,   -0.0078046434f},
        {  -0.0124782163f,    0.0124782163f},
        {  -0.0381871931f,   -0.0277446198f},
        {   0.0081832497f,   -0.0160605319f},
        {  -0.0961186050f,   -0.0312308280f},
        {   0.0401282958f,   -0.2533600885f},
        {   0.3401690422f,    0.0000000000f},
        {   0.0449018114f,    0.2834988794f},
        {  -0.1319939386f,    0.0428874304f},
        {  -0.0012702110f,   -0.0024929295f},
        {  -0.0386931575f,    0.0281122245f},
        {  -0.0187910667f,   -0.0187910667f},
        {  -0.0032775125f,    0.0045111089f},
        {  -0.0099872186f,   -0.0050887420f},
        {  -0.0000902463f,    0.0002777495f},
        {  -0.0052771110f,   -0.0008358123f},
        {   0.0000000000f,    0.0002310499f},
        {  -0.0044732506f,    0.0007084933f},
        {  -0.0005145514f,   -0.0015836262f},
        {  -0.0019850362f,    0.0010114265f}
    },
    {
        {  -0.0022285419f,   -0.0011354988f},     /* Filter 74 */
        {  -0.0001605011f,    0.0004939715f},
        {  -0.0043556701f,   -0.0006898704f},
        {   0.0000000000f,   -0.0018018889f},
        {  -0.0045922082f,    0.0007273343f},
        {  -0.0008139998f,   -0.0025052338f},
        {  -0.0080820516f,    0.0041180110f},
        {  -0.0056298825f,   -0.0077488684f},
        {  -0.0126148560f,    0.0126148560f},
        {  -0.0382310777f,   -0.0277765039f},
        {   0.0080046651f,   -0.0157100397f},
        {  -0.0968791926f,   -0.0314779578f},
        {   0.0402401713f,   -0.2540664421f},
        {   0.3402592203f,    0.0000000000f},
        {   0.0448069181f,    0.2828997467f},
        {  -0.1311995619f,    0.0426293218f},
        {  -0.0010381516f,   -0.0020374872f},
        {  -0.0387173946f,    0.0281298337f},
        {  -0.0186551985f,   -0.0186551985f},
        {  -0.0033409256f,    0.0045983896f},
        {  -0.0099533576f,   -0.0050714890f},
        {  -0.0001081607f,    0.0003328846f},
        {  -0.0052685865f,   -0.0008344621f},
        {   0.0000000000f,    0.0002678034f},
        {  -0.0044754634f,    0.0007088438f},
        {  -0.0005067065f,   -0.0015594822f},
        {  -0.0019934027f,    0.0010156894f}
    },
    {
        {  -0.0022260831f,   -0.0011342460f},     /* Filter 75 */
        {  -0.0001682594f,    0.0005178491f},
        {  -0.0043629383f,   -0.0006910215f},
        {   0.0000000000f,   -0.0017693819f},
        {  -0.0046136165f,    0.0007307251f},
        {  -0.0007999506f,   -0.0024619949f},
        {  -0.0081316854f,    0.0041433007f},
        {  -0.0055888462f,   -0.0076923868f},
        {  -0.0127516043f,    0.0127516043f},
        {  -0.0382736074f,   -0.0278074035f},
        {   0.0078248748f,   -0.0153571814f},
        {  -0.0976408374f,   -0.0317254312f},
        {   0.0403517197f,   -0.2547707314f},
        {   0.3403453966f,    0.0000000000f},
        {   0.0447115990f,    0.2822979260f},
        {  -0.1304056099f,    0.0423713512f},
        {  -0.0008072533f,   -0.0015843239f},
        {  -0.0387399618f,    0.0281462298f},
        {  -0.0185191789f,   -0.0185191789f},
        {  -0.0034038419f,    0.0046849864f},
        {  -0.0099190609f,   -0.0050540140f},
        {  -0.0001260014f,    0.0003877925f},
        {  -0.0052597363f,   -0.0008330604f},
        {   0.0000000000f,    0.0003045018f},
        {  -0.0044774545f,    0.0007091591f},
        {  -0.0004988537f,   -0.0015353137f},
        {  -0.0020016361f,    0.0010198845f}
    },
    {
        {  -0.0022234937f,   -0.0011329266f},     /* Filter 76 */
        {  -0.0001760298f,    0.0005417639f},
        {  -0.0043700036f,   -0.0006921406f},
        {   0.0000000000f,   -0.0017367458f},
        {  -0.0046347647f,    0.0007340746f},
        {  -0.0007858009f,   -0.0024184465f},
        {  -0.0081810412f,    0.0041684487f},
        {  -0.0055472976f,   -0.0076352001f},
        {  -0.0128884592f,    0.0128884592f},
        {  -0.0383147780f,   -0.0278373157f},
        {   0.0076438761f,   -0.0150019516f},
        {  -0.0984035433f,   -0.0319732494f},
        {   0.0404629427f,   -0.2554729654f},
        {   0.3404275809f,    0.0000000000f},
        {   0.0446158526f,    0.2816934067f},
        {  -0.1296120935f,    0.0421135221f},
        {  -0.0005775139f,   -0.0011334349f},
        {  -0.0387608713f,    0.0281614214f},
        {  -0.0183830151f,   -0.0183830151f},
        {  -0.0034662576f,    0.0047708942f},
        {  -0.0098843276f,   -0.0050363165f},
        {  -0.0001437692f,    0.0004424761f},
        {  -0.0052505618f,   -0.0008316073f},
        {   0.0000000000f,    0.0003411385f},
        {  -0.0044792187f,    0.0007094385f},
        {  -0.0004909940f,   -0.0015111241f},
        {  -0.0020097374f,    0.0010240124f}
    },
    {
        {  -0.0022207691f,   -0.0011315384f},     /* Filter 77 */
        {  -0.0001838111f,    0.0005657123f},
        {  -0.0043768719f,   -0.0006932284f},
        {   0.0000000000f,   -0.0017039785f},
        {  -0.0046556572f,    0.0007373837f},
        {  -0.0007715502f,   -0.0023745874f},
        {  -0.0082301158f,    0.0041934535f},
        {  -0.0055052393f,   -0.0075773118f},
        {  -0.0130254114f,    0.0130254114f},
        {  -0.0383545750f,   -0.0278662299f},
        {   0.0074616682f,   -0.0146443485f},
        {  -0.0991672869f,   -0.0322214047f},
        {   0.0405738379f,   -0.2561731303f},
        {   0.3405057686f,    0.0000000000f},
        {   0.0445196833f,    0.2810862181f},
        {  -0.1288190325f,    0.0418558409f},
        {  -0.0003489325f,   -0.0006848186f},
        {  -0.0387801244f,    0.0281754096f},
        {  -0.0182467125f,   -0.0182467125f},
        {  -0.0035281741f,    0.0048561151f},
        {  -0.0098491643f,   -0.0050183999f},
        {  -0.0001614619f,    0.0004969285f},
        {  -0.0052410650f,   -0.0008301031f},
        {   0.0000000000f,    0.0003777139f},
        {  -0.0044807549f,    0.0007096819f},
        {  -0.0004831286f,   -0.0014869168f},
        {  -0.0020177053f,    0.0010280722f}
    },
    {
        {  -0.0022179116f,   -0.0011300824f},     /* Filter 78 */
        {  -0.0001916007f,    0.0005896863f},
        {  -0.0043835331f,   -0.0006942834f},
        {   0.0000000000f,   -0.0016710782f},
        {  -0.0046762880f,    0.0007406513f},
        {  -0.0007572001f,   -0.0023304223f},
        {  -0.0082789073f,    0.0042183140f},
        {  -0.0054626681f,   -0.0075187177f},
        {  -0.0131624584f,    0.0131624584f},
        {  -0.0383929951f,   -0.0278941437f},
        {   0.0072782560f,   -0.0142843817f},
        {  -0.0999320580f,   -0.0324698940f},
        {   0.0406843964f,   -0.2568711694f},
        {   0.3405799320f,    0.0000000000f},
        {   0.0444230929f,    0.2804763702f},
        {  -0.1280264277f,    0.0415983080f},
        {  -0.0001215183f,   -0.0002384932f},
        {  -0.0387977338f,    0.0281882036f},
        {  -0.0181102764f,   -0.0181102764f},
        {  -0.0035895900f,    0.0049406467f},
        {  -0.0098135759f,   -0.0050002667f},
        {  -0.0001790793f,    0.0005511493f},
        {  -0.0052312458f,   -0.0008285479f},
        {   0.0000000000f,    0.0004142275f},
        {  -0.0044820704f,    0.0007098902f},
        {  -0.0004752586f,   -0.0014626955f},
        {  -0.0020255376f,    0.0010320630f}
    },
    {
        {  -0.0022149197f,   -0.0011285579f},     /* Filter 79 */
        {  -0.0001994007f,    0.0006136924f},
        {  -0.0043899851f,   -0.0006953053f},
        {   0.0000000000f,   -0.0016380516f},
        {  -0.0046966573f,    0.0007438774f},
        {  -0.0007427516f,   -0.0022859543f},
        {  -0.0083274089f,    0.0042430267f},
        {  -0.0054195838f,   -0.0074594171f},
        {  -0.0132995926f,    0.0132995926f},
        {  -0.0384300398f,   -0.0279210583f},
        {   0.0070936379f,   -0.0139220482f},
        {  -0.1006978434f,   -0.0327187127f},
        {   0.0407946244f,   -0.2575671213f},
        {   0.3406501456f,    0.0000000000f},
        {   0.0443260808f,    0.2798638600f},
        {  -0.1272343255f,    0.0413409384f},
        {   0.0001047341f,    0.0002055523f},
        {  -0.0388137063f,    0.0281998083f},
        {  -0.0179737156f,   -0.0179737156f},
        {  -0.0036505044f,    0.0050244882f},
        {  -0.0097775620f,   -0.0049819167f},
        {  -0.0001966211f,    0.0006051376f},
        {  -0.0052211059f,   -0.0008269419f},
        {   0.0000000000f,    0.0004506776f},
        {  -0.0044831588f,    0.0007100626f},
        {  -0.0004673804f,   -0.0014384488f},
        {  -0.0020332365f,    0.0010359857f}
    },
    {
        {  -0.0022117956f,   -0.0011269662f},     /* Filter 80 */
        {  -0.0002072092f,    0.0006377245f},
        {  -0.0043962359f,   -0.0006962954f},
        {   0.0000000000f,   -0.0016048978f},
        {  -0.0047167638f,    0.0007470620f},
        {  -0.0007282033f,   -0.0022411794f},
        {  -0.0083756155f,    0.0042675892f},
        {  -0.0053759855f,   -0.0073994093f},
        {  -0.0134368115f,    0.0134368115f},
        {  -0.0384656852f,   -0.0279469562f},
        {   0.0069078131f,   -0.0135573465f},
        {  -0.1014646226f,   -0.0329678544f},
        {   0.0409045147f,   -0.2582609415f},
        {   0.3407163139f,    0.0000000000f},
        {   0.0442286557f,    0.2792487420f},
        {  -0.1264427052f,    0.0410837254f},
        {   0.0003298196f,    0.0006473074f},
        {  -0.0388280428f,    0.0282102244f},
        {  -0.0178370350f,   -0.0178370350f},
        {  -0.0037109171f,    0.0051076392f},
        {  -0.0097411254f,   -0.0049633513f},
        {  -0.0002140858f,    0.0006588884f},
        {  -0.0052106492f,   -0.0008252858f},
        {   0.0000000000f,    0.0004870592f},
        {  -0.0044840278f,    0.0007102002f},
        {  -0.0004594994f,   -0.0014141938f},
        {  -0.0020408022f,    0.0010398406f}
    },
    {
        {  -0.0022085377f,   -0.0011253062f},     /* Filter 81 */
        {  -0.0002150272f,    0.0006617856f},
        {  -0.0044022844f,   -0.0006972533f},
        {   0.0000000000f,   -0.0015716164f},
        {  -0.0047366037f,    0.0007502043f},
        {  -0.0007135575f,   -0.0021961043f},
        {  -0.0084235294f,    0.0042920026f},
        {  -0.0053318786f,   -0.0073387013f},
        {  -0.0135741072f,    0.0135741072f},
        {  -0.0384999357f,   -0.0279718407f},
        {   0.0067207811f,   -0.0131902755f},
        {  -0.1022323897f,   -0.0332173170f},
        {   0.0410140671f,   -0.2589526285f},
        {   0.3407785039f,    0.0000000000f},
        {   0.0441308133f,    0.2786309892f},
        {  -0.1256516079f,    0.0408266823f},
        {   0.0005537359f,    0.0010867680f},
        {  -0.0388407526f,    0.0282194586f},
        {  -0.0177002397f,   -0.0177002397f},
        {  -0.0037708270f,    0.0051900982f},
        {  -0.0097042763f,   -0.0049445757f},
        {  -0.0002314730f,    0.0007124005f},
        {  -0.0051998731f,   -0.0008235790f},
        {   0.0000000000f,    0.0005233689f},
        {  -0.0044846698f,    0.0007103019f},
        {  -0.0004516136f,   -0.0013899237f},
        {  -0.0020482334f,    0.0010436270f}
    },
    {
        {  -0.0022051449f,   -0.0011235774f},     /* Filter 82 */
        {  -0.0002228535f,    0.0006858725f},
        {  -0.0044081214f,   -0.0006981778f},
        {   0.0000000000f,   -0.0015382175f},
        {  -0.0047561744f,    0.0007533040f},
        {  -0.0006988141f,   -0.0021507287f},
        {  -0.0084711411f,    0.0043162620f},
        {  -0.0052872555f,   -0.0072772828f},
        {  -0.0137114739f,    0.0137114739f},
        {  -0.0385327768f,   -0.0279957011f},
        {   0.0065325459f,   -0.0128208432f},
        {  -0.1030011138f,   -0.0334670906f},
        {   0.0411232740f,   -0.2596421332f},
        {   0.3408366709f,    0.0000000000f},
        {   0.0440325565f,    0.2780106203f},
        {  -0.1248610407f,    0.0405698114f},
        {   0.0007764820f,    0.0015239316f},
        {  -0.0388518426f,    0.0282275159f},
        {  -0.0175633376f,   -0.0175633376f},
        {  -0.0038302342f,    0.0052718651f},
        {  -0.0096670126f,   -0.0049255890f},
        {  -0.0002487817f,    0.0007656713f},
        {  -0.0051887820f,   -0.0008218223f},
        {   0.0000000000f,    0.0005596113f},
        {  -0.0044850891f,    0.0007103683f},
        {  -0.0004437229f,   -0.0013656386f},
        {  -0.0020555298f,    0.0010473447f}
    },
    {
        {  -0.0022016193f,   -0.0011217811f},     /* Filter 83 */
        {  -0.0002306877f,    0.0007099836f},
        {  -0.0044137537f,   -0.0006990699f},
        {   0.0000000000f,   -0.0015046928f},
        {  -0.0047754808f,    0.0007563619f},
        {  -0.0006839732f,   -0.0021050531f},
        {  -0.0085184500f,    0.0043403671f},
        {  -0.0052421235f,   -0.0072151640f},
        {  -0.0138489067f,    0.0138489067f},
        {  -0.0385642057f,   -0.0280185355f},
        {   0.0063431077f,   -0.0124490497f},
        {  -0.1037708134f,   -0.0337171812f},
        {   0.0412321395f,   -0.2603294831f},
        {   0.3408908349f,    0.0000000000f},
        {   0.0439338918f,    0.2773876760f},
        {  -0.1240710155f,    0.0403131167f},
        {   0.0009980569f,    0.0019587970f},
        {  -0.0388613197f,    0.0282344015f},
        {  -0.0174263349f,   -0.0174263349f},
        {  -0.0038891349f,    0.0053529350f},
        {  -0.0096293377f,   -0.0049063926f},
        {  -0.0002660115f,    0.0008186992f},
        {  -0.0051773757f,   -0.0008200157f},
        {   0.0000000000f,    0.0005957808f},
        {  -0.0044852873f,    0.0007103997f},
        {  -0.0004358302f,   -0.0013413474f},
        {  -0.0020626926f,    0.0010509944f}
    },
    {
        {  -0.0021979595f,   -0.0011199163f},     /* Filter 84 */
        {  -0.0002385288f,    0.0007341161f},
        {  -0.0044191758f,   -0.0006999287f},
        {   0.0000000000f,   -0.0014710468f},
        {  -0.0047945159f,    0.0007593767f},
        {  -0.0006690369f,   -0.0020590840f},
        {  -0.0085654504f,    0.0043643149f},
        {  -0.0051964730f,   -0.0071523315f},
        {  -0.0139864014f,    0.0139864014f},
        {  -0.0385942197f,   -0.0280403419f},
        {   0.0061524667f,   -0.0120748958f},
        {  -0.1045414336f,   -0.0339675709f},
        {   0.0413406572f,   -0.2610146369f},
        {   0.3409410012f,    0.0000000000f},
        {   0.0438348202f,    0.2767621627f},
        {  -0.1232815667f,    0.0400566092f},
        {   0.0012184551f,    0.0023913529f},
        {  -0.0388691881f,    0.0282401182f},
        {  -0.0172892379f,   -0.0172892379f},
        {  -0.0039475340f,    0.0054333145f},
        {  -0.0095912629f,   -0.0048869925f},
        {  -0.0002831613f,    0.0008714809f},
        {  -0.0051656581f,   -0.0008181599f},
        {   0.0000000000f,    0.0006318766f},
        {  -0.0044852615f,    0.0007103956f},
        {  -0.0004279330f,   -0.0013170424f},
        {  -0.0020697195f,    0.0010545747f}
    },
    {
        {  -0.0021941651f,   -0.0011179829f},     /* Filter 85 */
        {  -0.0002463783f,    0.0007582745f},
        {  -0.0044243893f,   -0.0007007544f},
        {   0.0000000000f,   -0.0014372807f},
        {  -0.0048132753f,    0.0007623479f},
        {  -0.0006540040f,   -0.0020128174f},
        {  -0.0086121372f,    0.0043881031f},
        {  -0.0051503158f,   -0.0070888016f},
        {  -0.0141239484f,    0.0141239484f},
        {  -0.0386228004f,   -0.0280611071f},
        {   0.0059606207f,   -0.0116983767f},
        {  -0.1053130012f,   -0.0342182684f},
        {   0.0414488287f,   -0.2616976047f},
        {   0.3409871689f,    0.0000000000f},
        {   0.0437353400f,    0.2761340693f},
        {  -0.1224926731f,    0.0398002822f},
        {   0.0014376844f,    0.0028216146f},
        {  -0.0388754585f,    0.0282446739f},
        {  -0.0171520528f,   -0.0171520528f},
        {  -0.0040054273f,    0.0055129977f},
        {  -0.0095527829f,   -0.0048673860f},
        {  -0.0003002310f,    0.0009240159f},
        {  -0.0051536287f,   -0.0008162546f},
        {   0.0000000000f,    0.0006678940f},
        {  -0.0044850110f,    0.0007103560f},
        {  -0.0004200319f,   -0.0012927253f},
        {  -0.0020766136f,    0.0010580875f}
    },
    {
        {  -0.0021902362f,   -0.0011159811f},     /* Filter 86 */
        {  -0.0002542329f,    0.0007824483f},
        {  -0.0044293918f,   -0.0007015467f},
        {   0.0000000000f,   -0.0014034000f},
        {  -0.0048317621f,    0.0007652759f},
        {  -0.0006388765f,   -0.0019662596f},
        {  -0.0086585095f,    0.0044117309f},
        {  -0.0051036418f,   -0.0070245603f},
        {  -0.0142615460f,    0.0142615460f},
        {  -0.0386499515f,   -0.0280808335f},
        {   0.0057675762f,   -0.0113195056f},
        {  -0.1060854619f,   -0.0344692561f},
        {   0.0415566435f,   -0.2623783208f},
        {   0.3410293205f,    0.0000000000f},
        {   0.0436354594f,    0.2755034477f},
        {  -0.1217043906f,    0.0395441536f},
        {   0.0016557316f,    0.0032495562f},
        {  -0.0388801344f,    0.0282480711f},
        {  -0.0170147852f,   -0.0170147851f},
        {  -0.0040628131f,    0.0055919826f},
        {  -0.0095139053f,   -0.0048475769f},
        {  -0.0003172191f,    0.0009763001f},
        {  -0.0051412871f,   -0.0008142999f},
        {   0.0000000000f,    0.0007038334f},
        {  -0.0044845442f,    0.0007102820f},
        {  -0.0004121306f,   -0.0012684074f},
        {  -0.0020833727f,    0.0010615314f}
    },
    {
        {  -0.0021861730f,   -0.0011139108f},     /* Filter 87 */
        {  -0.0002620953f,    0.0008066464f},
        {  -0.0044341837f,   -0.0007023057f},
        {   0.0000000000f,   -0.0013694064f},
        {  -0.0048499731f,    0.0007681603f},
        {  -0.0006236529f,   -0.0019194063f},
        {  -0.0087045644f,    0.0044351971f},
        {  -0.0050564574f,   -0.0069596165f},
        {  -0.0143991860f,    0.0143991860f},
        {  -0.0386756494f,   -0.0280995041f},
        {   0.0055733286f,   -0.0109382733f},
        {  -0.1068588215f,   -0.0347205358f},
        {   0.0416641070f,   -0.2630568185f},
        {   0.3410674260f,    0.0000000000f},
        {   0.0435351743f,    0.2748702724f},
        {  -0.1209166937f,    0.0392882154f},
        {   0.0018726021f,    0.0036751886f},
        {  -0.0388832225f,    0.0282503148f},
        {  -0.0168774407f,   -0.0168774407f},
        {  -0.0041196955f,    0.0056702745f},
        {  -0.0094746364f,   -0.0048275684f},
        {  -0.0003341249f,    0.0010283306f},
        {  -0.0051286356f,   -0.0008122961f},
        {   0.0000000000f,    0.0007396959f},
        {  -0.0044838549f,    0.0007101728f},
        {  -0.0004042266f,   -0.0012440816f},
        {  -0.0020899954f,    0.0010649059f}
    },
    {
        {  -0.0021819745f,   -0.0011117715f},     /* Filter 88 */
        {  -0.0002699630f,    0.0008308606f},
        {  -0.0044387682f,   -0.0007030318f},
        {   0.0000000000f,   -0.0013352954f},
        {  -0.0048679066f,    0.0007710007f},
        {  -0.0006083359f,   -0.0018722654f},
        {  -0.0087502942f,    0.0044584976f},
        {  -0.0050087598f,   -0.0068939665f},
        {  -0.0145368636f,    0.0145368636f},
        {  -0.0386999026f,   -0.0281171251f},
        {   0.0053778807f,   -0.0105546851f},
        {  -0.1076330846f,   -0.0349721092f},
        {   0.0417712137f,   -0.2637330636f},
        {   0.3411015594f,    0.0000000000f},
        {   0.0434344921f,    0.2742345901f},
        {  -0.1201296241f,    0.0390324810f},
        {   0.0020882956f,    0.0040985108f},
        {  -0.0388847392f,    0.0282514167f},
        {  -0.0167400259f,   -0.0167400258f},
        {  -0.0041760679f,    0.0057478644f},
        {  -0.0094349725f,   -0.0048073586f},
        {  -0.0003509489f,    0.0010801096f},
        {  -0.0051156820f,   -0.0008102444f},
        {   0.0000000000f,    0.0007754711f},
        {  -0.0044829413f,    0.0007100281f},
        {  -0.0003963211f,   -0.0012197508f},
        {  -0.0020964853f,    0.0010682126f}
    },
    {
        {  -0.0021776429f,   -0.0011095645f},     /* Filter 89 */
        {  -0.0002778370f,    0.0008550943f},
        {  -0.0044431403f,   -0.0007037243f},
        {   0.0000000000f,   -0.0013010732f},
        {  -0.0048855597f,    0.0007737966f},
        {  -0.0005929253f,   -0.0018248365f},
        {  -0.0087956998f,    0.0044816329f},
        {  -0.0049605510f,   -0.0068276127f},
        {  -0.0146745726f,    0.0146745726f},
        {  -0.0387226943f,   -0.0281336842f},
        {   0.0051812346f,   -0.0101687455f},
        {  -0.1084082070f,   -0.0352239617f},
        {   0.0418779607f,   -0.2644070374f},
        {   0.3411316675f,    0.0000000000f},
        {   0.0433334131f,    0.2735964027f},
        {  -0.1193431900f,    0.0387769531f},
        {   0.0023028049f,    0.0045195090f},
        {  -0.0388846787f,    0.0282513728f},
        {  -0.0166025495f,   -0.0166025495f},
        {  -0.0042319331f,    0.0058247562f},
        {  -0.0093949236f,   -0.0047869527f},
        {  -0.0003676890f,    0.0011316304f},
        {  -0.0051024190f,   -0.0008081438f},
        {   0.0000000000f,    0.0008111646f},
        {  -0.0044818123f,    0.0007098493f},
        {  -0.0003884134f,   -0.0011954135f},
        {  -0.0021028389f,    0.0010714499f}
    },
    {
        {  -0.0021731767f,   -0.0011072888f},     /* Filter 90 */
        {  -0.0002857146f,    0.0008793391f},
        {  -0.0044472978f,   -0.0007043828f},
        {   0.0000000000f,   -0.0012667403f},
        {  -0.0049029332f,    0.0007765483f},
        {  -0.0005774216f,   -0.0017771208f},
        {  -0.0088407725f,    0.0045045986f},
        {  -0.0049118282f,   -0.0067605516f},
        {  -0.0148123088f,    0.0148123088f},
        {  -0.0387440238f,   -0.0281491810f},
        {   0.0049833907f,   -0.0097804550f},
        {  -0.1091841828f,   -0.0354760915f},
        {   0.0419843498f,   -0.2650787521f},
        {   0.3411577599f,    0.0000000000f},
        {   0.0432319421f,    0.2729557400f},
        {  -0.1185574135f,    0.0385216388f},
        {   0.0025161342f,    0.0049381914f},
        {  -0.0388830537f,    0.0282501922f},
        {  -0.0164650142f,   -0.0164650142f},
        {  -0.0042872929f,    0.0059009524f},
        {  -0.0093544891f,   -0.0047663503f},
        {  -0.0003843450f,    0.0011828923f},
        {  -0.0050888546f,   -0.0008059954f},
        {   0.0000000000f,    0.0008467735f},
        {  -0.0044804608f,    0.0007096353f},
        {  -0.0003805073f,   -0.0011710809f},
        {  -0.0021090603f,    0.0010746199f}
    },
    {
        {  -0.0021685765f,   -0.0011049449f},     /* Filter 91 */
        {  -0.0002935986f,    0.0009036035f},
        {  -0.0044512471f,   -0.0007050083f},
        {   0.0000000000f,   -0.0012322999f},
        {  -0.0049200227f,    0.0007792550f},
        {  -0.0005618260f,   -0.0017291225f},
        {  -0.0088855104f,    0.0045273937f},
        {  -0.0048625945f,   -0.0066927872f},
        {  -0.0149500663f,    0.0149500663f},
        {  -0.0387638855f,   -0.0281636114f},
        {   0.0047843480f,   -0.0093898117f},
        {  -0.1099610010f,   -0.0357284951f},
        {   0.0420903738f,   -0.2657481612f},
        {   0.3411798695f,    0.0000000000f},
        {   0.0431300782f,    0.2723125962f},
        {  -0.1177723028f,    0.0382665409f},
        {   0.0027282797f,    0.0053545504f},
        {  -0.0388798706f,    0.0282478795f},
        {  -0.0163274298f,   -0.0163274298f},
        {  -0.0043421423f,    0.0059764462f},
        {  -0.0093136782f,   -0.0047455561f},
        {  -0.0004009170f,    0.0012338955f},
        {  -0.0050749873f,   -0.0008037990f},
        {   0.0000000000f,    0.0008822936f},
        {  -0.0044788886f,    0.0007093863f},
        {  -0.0003725981f,   -0.0011467390f},
        {  -0.0021151462f,    0.0010777208f}
    },
    {
        {  -0.0021638398f,   -0.0011025314f},     /* Filter 92 */
        {  -0.0003014859f,    0.0009278782f},
        {  -0.0044549783f,   -0.0007055992f},
        {   0.0000000000f,   -0.0011977518f},
        {  -0.0049368271f,    0.0007819166f},
        {  -0.0005461373f,   -0.0016808379f},
        {  -0.0089299112f,    0.0045500170f},
        {  -0.0048128491f,   -0.0066243185f},
        {  -0.0150878344f,    0.0150878344f},
        {  -0.0387822560f,   -0.0281769583f},
        {   0.0045841073f,   -0.0089968171f},
        {  -0.1107386540f,   -0.0359811698f},
        {   0.0421960299f,   -0.2664152474f},
        {   0.3411979167f,    0.0000000000f},
        {   0.0430278192f,    0.2716669587f},
        {  -0.1169878611f,    0.0380116603f},
        {   0.0029392400f,    0.0057685833f},
        {  -0.0388751356f,    0.0282444393f},
        {  -0.0161897978f,   -0.0161897978f},
        {  -0.0043964844f,    0.0060512416f},
        {  -0.0092724890f,   -0.0047245691f},
        {  -0.0004174029f,    0.0012846341f},
        {  -0.0050608171f,   -0.0008015547f},
        {   0.0000000000f,    0.0009177243f},
        {  -0.0044771017f,    0.0007091032f},
        {  -0.0003646917f,   -0.0011224055f},
        {  -0.0021210958f,    0.0010807523f}
    },
    {
        {  -0.0021589676f,   -0.0011000489f},     /* Filter 93 */
        {  -0.0003093775f,    0.0009521661f},
        {  -0.0044584978f,   -0.0007061567f},
        {   0.0000000000f,   -0.0011630979f},
        {  -0.0049533429f,    0.0007845324f},
        {  -0.0005303585f,   -0.0016322755f},
        {  -0.0089739699f,    0.0045724660f},
        {  -0.0047625912f,   -0.0065551444f},
        {  -0.0152256120f,    0.0152256120f},
        {  -0.0387991482f,   -0.0281892312f},
        {   0.0043826721f,   -0.0086014783f},
        {  -0.1115171103f,   -0.0362341056f},
        {   0.0423013184f,   -0.2670800130f},
        {   0.3412119690f,    0.0000000000f},
        {   0.0429251774f,    0.2710189037f},
        {  -0.1162041184f,    0.0377570069f},
        {   0.0031490135f,    0.0061802870f},
        {  -0.0388688526f,    0.0282398744f},
        {  -0.0160521270f,   -0.0160521270f},
        {  -0.0044503172f,    0.0061253362f},
        {  -0.0092309301f,   -0.0047033938f},
        {  -0.0004338029f,    0.0013351080f},
        {  -0.0050463500f,   -0.0007992633f},
        {   0.0000000000f,    0.0009530667f},
        {  -0.0044750950f,    0.0007087854f},
        {  -0.0003567845f,   -0.0010980696f},
        {  -0.0021269106f,    0.0010837151f}
    },
    {
        {  -0.0021539626f,   -0.0010974987f},     /* Filter 94 */
        {  -0.0003172722f,    0.0009764635f},
        {  -0.0044618075f,   -0.0007066809f},
        {   0.0000000000f,   -0.0011283415f},
        {  -0.0049695747f,    0.0007871033f},
        {  -0.0005144884f,   -0.0015834325f},
        {  -0.0090176834f,    0.0045947392f},
        {  -0.0047118230f,   -0.0064852680f},
        {  -0.0153633929f,    0.0153633929f},
        {  -0.0388145423f,   -0.0282004157f},
        {   0.0041800420f,   -0.0082037943f},
        {  -0.1122963701f,   -0.0364873025f},
        {   0.0424062358f,   -0.2677424355f},
        {   0.3412220061f,    0.0000000000f},
        {   0.0428221507f,    0.2703684189f},
        {  -0.1154210879f,    0.0375025848f},
        {   0.0033575994f,    0.0065896599f},
        {  -0.0388610405f,    0.0282341986f},
        {  -0.0159144236f,   -0.0159144236f},
        {  -0.0045036391f,    0.0061987274f},
        {  -0.0091890036f,   -0.0046820312f},
        {  -0.0004501161f,    0.0013853149f},
        {  -0.0050315825f,   -0.0007969244f},
        {   0.0000000000f,    0.0009883163f},
        {  -0.0044728687f,    0.0007084328f},
        {  -0.0003488777f,   -0.0010737353f},
        {  -0.0021325913f,    0.0010866095f}
    },
    {
        {  -0.0021488207f,   -0.0010948788f},     /* Filter 95 */
        {  -0.0003251694f,    0.0010007685f},
        {  -0.0044648953f,   -0.0007071699f},
        {   0.0000000000f,   -0.0010934830f},
        {  -0.0049855152f,    0.0007896280f},
        {  -0.0004985286f,   -0.0015343131f},
        {  -0.0090610460f,    0.0046168336f},
        {  -0.0046605431f,   -0.0064146873f},
        {  -0.0155011700f,    0.0155011700f},
        {  -0.0388284352f,   -0.0282105095f},
        {   0.0039762170f,   -0.0078037652f},
        {  -0.1130764159f,   -0.0367407547f},
        {   0.0425107787f,   -0.2684024935f},
        {   0.3412280286f,    0.0000000000f},
        {   0.0427187389f,    0.2697155022f},
        {  -0.1146387803f,    0.0372483977f},
        {   0.0035649970f,    0.0069967006f},
        {  -0.0388516915f,    0.0282274062f},
        {  -0.0157766902f,   -0.0157766902f},
        {  -0.0045564491f,    0.0062714142f},
        {  -0.0091467091f,   -0.0046604811f},
        {  -0.0004663419f,    0.0014352527f},
        {  -0.0050165206f,   -0.0007945388f},
        {   0.0000000000f,    0.0010234687f},
        {  -0.0044704284f,    0.0007080463f},
        {  -0.0003409731f,   -0.0010494074f},
        {  -0.0021381359f,    0.0010894346f}
    },
    {
        {  -0.0021435458f,   -0.0010921912f},     /* Filter 96 */
        {  -0.0003330708f,    0.0010250866f},
        {  -0.0044677702f,   -0.0007076253f},
        {   0.0000000000f,   -0.0010585255f},
        {  -0.0050011665f,    0.0007921070f},
        {  -0.0004824799f,   -0.0014849205f},
        {  -0.0091040561f,    0.0046387483f},
        {  -0.0046087521f,   -0.0063434030f},
        {  -0.0156389384f,    0.0156389383f},
        {  -0.0388408234f,   -0.0282195101f},
        {   0.0037712026f,   -0.0074014019f},
        {  -0.1138572223f,   -0.0369944541f},
        {   0.0426149488f,   -0.2690601973f},
        {   0.3412300532f,    0.0000000000f},
        {   0.0426149488f,    0.2690601973f},
        {  -0.1138572223f,    0.0369944541f},
        {   0.0037712026f,    0.0074014019f},
        {  -0.0388408234f,    0.0282195101f},
        {  -0.0156389384f,   -0.0156389384f},
        {  -0.0046087521f,    0.0063434030f},
        {  -0.0091040561f,   -0.0046387483f},
        {  -0.0004824799f,    0.0014849205f},
        {  -0.0050011665f,   -0.0007921070f},
        {   0.0000000000f,    0.0010585255f},
        {  -0.0044677702f,    0.0007076253f},
        {  -0.0003330708f,   -0.0010250866f},
        {  -0.0021435458f,    0.0010921912f}
    },
    {
        {  -0.0021381359f,   -0.0010894346f},     /* Filter 97 */
        {  -0.0003409731f,    0.0010494074f},
        {  -0.0044704284f,   -0.0007080463f},
        {   0.0000000000f,   -0.0010234687f},
        {  -0.0050165206f,    0.0007945388f},
        {  -0.0004663419f,   -0.0014352527f},
        {  -0.0091467091f,    0.0046604811f},
        {  -0.0045564491f,   -0.0062714142f},
        {  -0.0157766902f,    0.0157766902f},
        {  -0.0388516915f,   -0.0282274062f},
        {   0.0035649970f,   -0.0069967006f},
        {  -0.1146387803f,   -0.0372483977f},
        {   0.0427187389f,   -0.2697155022f},
        {   0.3412280286f,    0.0000000000f},
        {   0.0425107787f,    0.2684024935f},
        {  -0.1130764159f,    0.0367407547f},
        {   0.0039762170f,    0.0078037652f},
        {  -0.0388284352f,    0.0282105095f},
        {  -0.0155011700f,   -0.0155011700f},
        {  -0.0046605431f,    0.0064146873f},
        {  -0.0090610460f,   -0.0046168336f},
        {  -0.0004985286f,    0.0015343131f},
        {  -0.0049855152f,   -0.0007896280f},
        {   0.0000000000f,    0.0010934830f},
        {  -0.0044648953f,    0.0007071699f},
        {  -0.0003251694f,   -0.0010007685f},
        {  -0.0021488207f,    0.0010948788f}
    },
    {
        {  -0.0021325913f,   -0.0010866095f},     /* Filter 98 */
        {  -0.0003488777f,    0.0010737353f},
        {  -0.0044728687f,   -0.0007084328f},
        {   0.0000000000f,   -0.0009883163f},
        {  -0.0050315825f,    0.0007969244f},
        {  -0.0004501161f,   -0.0013853149f},
        {  -0.0091890036f,    0.0046820312f},
        {  -0.0045036391f,   -0.0061987274f},
        {  -0.0159144236f,    0.0159144236f},
        {  -0.0388610405f,   -0.0282341986f},
        {   0.0033575994f,   -0.0065896598f},
        {  -0.1154210879f,   -0.0375025848f},
        {   0.0428221507f,   -0.2703684189f},
        {   0.3412220061f,    0.0000000000f},
        {   0.0424062358f,    0.2677424355f},
        {  -0.1122963701f,    0.0364873025f},
        {   0.0041800420f,    0.0082037943f},
        {  -0.0388145423f,    0.0282004157f},
        {  -0.0153633929f,   -0.0153633929f},
        {  -0.0047118230f,    0.0064852680f},
        {  -0.0090176834f,   -0.0045947392f},
        {  -0.0005144884f,    0.0015834325f},
        {  -0.0049695747f,   -0.0007871033f},
        {   0.0000000000f,    0.0011283415f},
        {  -0.0044618075f,    0.0007066809f},
        {  -0.0003172722f,   -0.0009764635f},
        {  -0.0021539626f,    0.0010974987f}
    },
    {
        {  -0.0021269106f,   -0.0010837151f},     /* Filter 99 */
        {  -0.0003567845f,    0.0010980696f},
        {  -0.0044750951f,   -0.0007087854f},
        {   0.0000000000f,   -0.0009530667f},
        {  -0.0050463500f,    0.0007992633f},
        {  -0.0004338029f,   -0.0013351080f},
        {  -0.0092309301f,    0.0047033938f},
        {  -0.0044503172f,   -0.0061253362f},
        {  -0.0160521270f,    0.0160521270f},
        {  -0.0388688526f,   -0.0282398744f},
        {   0.0031490135f,   -0.0061802870f},
        {  -0.1162041184f,   -0.0377570069f},
        {   0.0429251774f,   -0.2710189037f},
        {   0.3412119690f,    0.0000000000f},
        {   0.0423013183f,    0.2670800127f},
        {  -0.1115171103f,    0.0362341056f},
        {   0.0043826721f,    0.0086014783f},
        {  -0.0387991482f,    0.0281892312f},
        {  -0.0152256120f,   -0.0152256120f},
        {  -0.0047625912f,    0.0065551444f},
        {  -0.0089739698f,   -0.0045724660f},
        {  -0.0005303585f,    0.0016322755f},
        {  -0.0049533429f,   -0.0007845324f},
        {   0.0000000000f,    0.0011630979f},
        {  -0.0044584978f,    0.0007061567f},
        {  -0.0003093775f,   -0.0009521661f},
        {  -0.0021589676f,    0.0011000489f}
    },
    {
        {  -0.0021210958f,   -0.0010807523f},     /* Filter 100 */
        {  -0.0003646917f,    0.0011224055f},
        {  -0.0044771017f,   -0.0007091032f},
        {   0.0000000000f,   -0.0009177243f},
        {  -0.0050608171f,    0.0008015547f},
        {  -0.0004174029f,   -0.0012846341f},
        {  -0.0092724890f,    0.0047245691f},
        {  -0.0043964844f,   -0.0060512416f},
        {  -0.0161897978f,    0.0161897978f},
        {  -0.0388751356f,   -0.0282444393f},
        {   0.0029392400f,   -0.0057685833f},
        {  -0.1169878611f,   -0.0380116603f},
        {   0.0430278192f,   -0.2716669587f},
        {   0.3411979167f,    0.0000000000f},
        {   0.0421960299f,    0.2664152474f},
        {  -0.1107386540f,    0.0359811698f},
        {   0.0045841073f,    0.0089968171f},
        {  -0.0387822560f,    0.0281769583f},
        {  -0.0150878344f,   -0.0150878344f},
        {  -0.0048128491f,    0.0066243185f},
        {  -0.0089299112f,   -0.0045500170f},
        {  -0.0005461373f,    0.0016808379f},
        {  -0.0049368271f,   -0.0007819166f},
        {   0.0000000000f,    0.0011977518f},
        {  -0.0044549783f,    0.0007055992f},
        {  -0.0003014859f,   -0.0009278782f},
        {  -0.0021638398f,    0.0011025314f}
    },
    {
        {  -0.0021151462f,   -0.0010777208f},     /* Filter 101 */
        {  -0.0003725981f,    0.0011467390f},
        {  -0.0044788886f,   -0.0007093863f},
        {   0.0000000000f,   -0.0008822936f},
        {  -0.0050749873f,    0.0008037990f},
        {  -0.0004009170f,   -0.0012338955f},
        {  -0.0093136782f,    0.0047455561f},
        {  -0.0043421423f,   -0.0059764462f},
        {  -0.0163274298f,    0.0163274298f},
        {  -0.0388798706f,   -0.0282478795f},
        {   0.0027282797f,   -0.0053545504f},
        {  -0.1177723029f,   -0.0382665409f},
        {   0.0431300782f,   -0.2723125962f},
        {   0.3411798695f,    0.0000000000f},
        {   0.0420903738f,    0.2657481612f},
        {  -0.1099610010f,    0.0357284950f},
        {   0.0047843480f,    0.0093898117f},
        {  -0.0387638855f,    0.0281636114f},
        {  -0.0149500663f,   -0.0149500663f},
        {  -0.0048625945f,    0.0066927872f},
        {  -0.0088855104f,   -0.0045273937f},
        {  -0.0005618260f,    0.0017291225f},
        {  -0.0049200227f,   -0.0007792550f},
        {   0.0000000000f,    0.0012322999f},
        {  -0.0044512471f,    0.0007050083f},
        {  -0.0002935986f,   -0.0009036035f},
        {  -0.0021685765f,    0.0011049449f}
    },
    {
        {  -0.0021090603f,   -0.0010746199f},     /* Filter 102 */
        {  -0.0003805073f,    0.0011710809f},
        {  -0.0044804608f,   -0.0007096353f},
        {   0.0000000000f,   -0.0008467735f},
        {  -0.0050888546f,    0.0008059954f},
        {  -0.0003843450f,   -0.0011828923f},
        {  -0.0093544891f,    0.0047663503f},
        {  -0.0042872929f,   -0.0059009524f},
        {  -0.0164650142f,    0.0164650142f},
        {  -0.0388830537f,   -0.0282501922f},
        {   0.0025161341f,   -0.0049381913f},
        {  -0.1185574135f,   -0.0385216388f},
        {   0.0432319421f,   -0.2729557400f},
        {   0.3411577599f,    0.0000000000f},
        {   0.0419843498f,    0.2650787521f},
        {  -0.1091841828f,    0.0354760915f},
        {   0.0049833908f,    0.0097804550f},
        {  -0.0387440238f,    0.0281491810f},
        {  -0.0148123088f,   -0.0148123088f},
        {  -0.0049118282f,    0.0067605516f},
        {  -0.0088407725f,   -0.0045045986f},
        {  -0.0005774216f,    0.0017771208f},
        {  -0.0049029332f,   -0.0007765483f},
        {   0.0000000000f,    0.0012667403f},
        {  -0.0044472978f,    0.0007043828f},
        {  -0.0002857146f,   -0.0008793391f},
        {  -0.0021731767f,    0.0011072888f}
    },
    {
        {  -0.0021028389f,   -0.0010714499f},     /* Filter 103 */
        {  -0.0003884134f,    0.0011954135f},
        {  -0.0044818123f,   -0.0007098493f},
        {   0.0000000000f,   -0.0008111646f},
        {  -0.0051024190f,    0.0008081438f},
        {  -0.0003676890f,   -0.0011316304f},
        {  -0.0093949236f,    0.0047869527f},
        {  -0.0042319331f,   -0.0058247562f},
        {  -0.0166025495f,    0.0166025495f},
        {  -0.0388846787f,   -0.0282513728f},
        {   0.0023028049f,   -0.0045195090f},
        {  -0.1193431900f,   -0.0387769531f},
        {   0.0433334131f,   -0.2735964027f},
        {   0.3411316675f,    0.0000000000f},
        {   0.0418779606f,    0.2644070374f},
        {  -0.1084082070f,    0.0352239617f},
        {   0.0051812347f,    0.0101687456f},
        {  -0.0387226943f,    0.0281336842f},
        {  -0.0146745726f,   -0.0146745726f},
        {  -0.0049605510f,    0.0068276127f},
        {  -0.0087956998f,   -0.0044816329f},
        {  -0.0005929253f,    0.0018248365f},
        {  -0.0048855597f,   -0.0007737966f},
        {   0.0000000000f,    0.0013010732f},
        {  -0.0044431403f,    0.0007037243f},
        {  -0.0002778370f,   -0.0008550943f},
        {  -0.0021776429f,    0.0011095645f}
    },
    {
        {  -0.0020964853f,   -0.0010682126f},     /* Filter 104 */
        {  -0.0003963211f,    0.0012197508f},
        {  -0.0044829413f,   -0.0007100281f},
        {   0.0000000000f,   -0.0007754711f},
        {  -0.0051156820f,    0.0008102444f},
        {  -0.0003509489f,   -0.0010801096f},
        {  -0.0094349725f,    0.0048073586f},
        {  -0.0041760679f,   -0.0057478644f},
        {  -0.0167400259f,    0.0167400258f},
        {  -0.0388847392f,   -0.0282514167f},
        {   0.0020882956f,   -0.0040985108f},
        {  -0.1201296241f,   -0.0390324810f},
        {   0.0434344921f,   -0.2742345901f},
        {   0.3411015594f,    0.0000000000f},
        {   0.0417712137f,    0.2637330636f},
        {  -0.1076330846f,    0.0349721092f},
        {   0.0053778807f,    0.0105546851f},
        {  -0.0386999026f,    0.0281171251f},
        {  -0.0145368636f,   -0.0145368636f},
        {  -0.0050087598f,    0.0068939665f},
        {  -0.0087502942f,   -0.0044584976f},
        {  -0.0006083359f,    0.0018722654f},
        {  -0.0048679066f,   -0.0007710007f},
        {   0.0000000000f,    0.0013352954f},
        {  -0.0044387682f,    0.0007030318f},
        {  -0.0002699630f,   -0.0008308606f},
        {  -0.0021819745f,    0.0011117715f}
    },
    {
        {  -0.0020899954f,   -0.0010649059f},     /* Filter 105 */
        {  -0.0004042266f,    0.0012440816f},
        {  -0.0044838549f,   -0.0007101728f},
        {   0.0000000000f,   -0.0007396959f},
        {  -0.0051286356f,    0.0008122961f},
        {  -0.0003341249f,   -0.0010283306f},
        {  -0.0094746364f,    0.0048275684f},
        {  -0.0041196955f,   -0.0056702745f},
        {  -0.0168774407f,    0.0168774407f},
        {  -0.0388832225f,   -0.0282503148f},
        {   0.0018726021f,   -0.0036751886f},
        {  -0.1209166937f,   -0.0392882154f},
        {   0.0435351743f,   -0.2748702724f},
        {   0.3410674260f,    0.0000000000f},
        {   0.0416641070f,    0.2630568185f},
        {  -0.1068588215f,    0.0347205358f},
        {   0.0055733286f,    0.0109382733f},
        {  -0.0386756494f,    0.0280995041f},
        {  -0.0143991860f,   -0.0143991860f},
        {  -0.0050564574f,    0.0069596165f},
        {  -0.0087045644f,   -0.0044351971f},
        {  -0.0006236529f,    0.0019194063f},
        {  -0.0048499731f,   -0.0007681603f},
        {   0.0000000000f,    0.0013694064f},
        {  -0.0044341837f,    0.0007023057f},
        {  -0.0002620953f,   -0.0008066464f},
        {  -0.0021861730f,    0.0011139108f}
    },
    {
        {  -0.0020833727f,   -0.0010615314f},     /* Filter 106 */
        {  -0.0004121306f,    0.0012684074f},
        {  -0.0044845442f,   -0.0007102820f},
        {   0.0000000000f,   -0.0007038334f},
        {  -0.0051412871f,    0.0008142999f},
        {  -0.0003172191f,   -0.0009763001f},
        {  -0.0095139053f,    0.0048475769f},
        {  -0.0040628131f,   -0.0055919826f},
        {  -0.0170147852f,    0.0170147851f},
        {  -0.0388801344f,   -0.0282480711f},
        {   0.0016557316f,   -0.0032495562f},
        {  -0.1217043907f,   -0.0395441537f},
        {   0.0436354594f,   -0.2755034477f},
        {   0.3410293205f,    0.0000000000f},
        {   0.0415566435f,    0.2623783208f},
        {  -0.1060854619f,    0.0344692561f},
        {   0.0057675762f,    0.0113195056f},
        {  -0.0386499515f,    0.0280808335f},
        {  -0.0142615460f,   -0.0142615460f},
        {  -0.0051036418f,    0.0070245603f},
        {  -0.0086585095f,   -0.0044117309f},
        {  -0.0006388765f,    0.0019662596f},
        {  -0.0048317621f,   -0.0007652759f},
        {   0.0000000000f,    0.0014034000f},
        {  -0.0044293918f,    0.0007015467f},
        {  -0.0002542329f,   -0.0007824483f},
        {  -0.0021902362f,    0.0011159811f}
    },
    {
        {  -0.0020766136f,   -0.0010580875f},     /* Filter 107 */
        {  -0.0004200319f,    0.0012927253f},
        {  -0.0044850110f,   -0.0007103560f},
        {   0.0000000000f,   -0.0006678940f},
        {  -0.0051536287f,    0.0008162546f},
        {  -0.0003002310f,   -0.0009240159f},
        {  -0.0095527829f,    0.0048673860f},
        {  -0.0040054273f,   -0.0055129977f},
        {  -0.0171520528f,    0.0171520528f},
        {  -0.0388754585f,   -0.0282446739f},
        {   0.0014376844f,   -0.0028216146f},
        {  -0.1224926731f,   -0.0398002822f},
        {   0.0437353400f,   -0.2761340693f},
        {   0.3409871689f,    0.0000000000f},
        {   0.0414488287f,    0.2616976047f},
        {  -0.1053130012f,    0.0342182684f},
        {   0.0059606207f,    0.0116983767f},
        {  -0.0386228004f,    0.0280611071f},
        {  -0.0141239484f,   -0.0141239484f},
        {  -0.0051503158f,    0.0070888016f},
        {  -0.0086121372f,   -0.0043881031f},
        {  -0.0006540040f,    0.0020128174f},
        {  -0.0048132753f,   -0.0007623479f},
        {   0.0000000000f,    0.0014372807f},
        {  -0.0044243893f,    0.0007007544f},
        {  -0.0002463783f,   -0.0007582745f},
        {  -0.0021941651f,    0.0011179829f}
    },
    {
        {  -0.0020697195f,   -0.0010545747f},     /* Filter 108 */
        {  -0.0004279330f,    0.0013170424f},
        {  -0.0044852615f,   -0.0007103956f},
        {   0.0000000000f,   -0.0006318766f},
        {  -0.0051656581f,    0.0008181599f},
        {  -0.0002831613f,   -0.0008714809f},
        {  -0.0095912629f,    0.0048869925f},
        {  -0.0039475340f,   -0.0054333145f},
        {  -0.0172892379f,    0.0172892379f},
        {  -0.0388691881f,   -0.0282401182f},
        {   0.0012184551f,   -0.0023913529f},
        {  -0.1232815668f,   -0.0400566092f},
        {   0.0438348202f,   -0.2767621627f},
        {   0.3409410012f,    0.0000000000f},
        {   0.0413406572f,    0.2610146369f},
        {  -0.1045414336f,    0.0339675709f},
        {   0.0061524667f,    0.0120748958f},
        {  -0.0385942197f,    0.0280403419f},
        {  -0.0139864014f,   -0.0139864014f},
        {  -0.0051964730f,    0.0071523315f},
        {  -0.0085654504f,   -0.0043643149f},
        {  -0.0006690369f,    0.0020590840f},
        {  -0.0047945159f,   -0.0007593767f},
        {   0.0000000000f,    0.0014710468f},
        {  -0.0044191758f,    0.0006999287f},
        {  -0.0002385288f,   -0.0007341161f},
        {  -0.0021979595f,    0.0011199163f}
    },
    {
        {  -0.0020626926f,   -0.0010509944f},     /* Filter 109 */
        {  -0.0004358302f,    0.0013413474f},
        {  -0.0044852873f,   -0.0007103997f},
        {   0.0000000000f,   -0.0005957808f},
        {  -0.0051773757f,    0.0008200157f},
        {  -0.0002660115f,   -0.0008186991f},
        {  -0.0096293377f,    0.0049063926f},
        {  -0.0038891349f,   -0.0053529350f},
        {  -0.0174263349f,    0.0174263349f},
        {  -0.0388613197f,   -0.0282344015f},
        {   0.0009980569f,   -0.0019587970f},
        {  -0.1240710155f,   -0.0403131167f},
        {   0.0439338918f,   -0.2773876760f},
        {   0.3408908349f,    0.0000000000f},
        {   0.0412321395f,    0.2603294831f},
        {  -0.1037708134f,    0.0337171812f},
        {   0.0063431077f,    0.0124490497f},
        {  -0.0385642057f,    0.0280185355f},
        {  -0.0138489067f,   -0.0138489067f},
        {  -0.0052421235f,    0.0072151640f},
        {  -0.0085184500f,   -0.0043403671f},
        {  -0.0006839732f,    0.0021050531f},
        {  -0.0047754808f,   -0.0007563619f},
        {   0.0000000000f,    0.0015046928f},
        {  -0.0044137537f,    0.0006990699f},
        {  -0.0002306877f,   -0.0007099836f},
        {  -0.0022016193f,    0.0011217811f}
    },
    {
        {  -0.0020555298f,   -0.0010473447f},     /* Filter 110 */
        {  -0.0004437229f,    0.0013656386f},
        {  -0.0044850891f,   -0.0007103683f},
        {   0.0000000000f,   -0.0005596113f},
        {  -0.0051887820f,    0.0008218223f},
        {  -0.0002487817f,   -0.0007656713f},
        {  -0.0096670126f,    0.0049255890f},
        {  -0.0038302342f,   -0.0052718651f},
        {  -0.0175633376f,    0.0175633376f},
        {  -0.0388518426f,   -0.0282275159f},
        {   0.0007764820f,   -0.0015239316f},
        {  -0.1248610407f,   -0.0405698114f},
        {   0.0440325565f,   -0.2780106203f},
        {   0.3408366709f,    0.0000000000f},
        {   0.0411232740f,    0.2596421332f},
        {  -0.1030011138f,    0.0334670906f},
        {   0.0065325459f,    0.0128208432f},
        {  -0.0385327768f,    0.0279957011f},
        {  -0.0137114739f,   -0.0137114739f},
        {  -0.0052872555f,    0.0072772828f},
        {  -0.0084711411f,   -0.0043162620f},
        {  -0.0006988141f,    0.0021507287f},
        {  -0.0047561744f,   -0.0007533040f},
        {   0.0000000000f,    0.0015382175f},
        {  -0.0044081214f,    0.0006981778f},
        {  -0.0002228535f,   -0.0006858725f},
        {  -0.0022051449f,    0.0011235774f}
    },
    {
        {  -0.0020482334f,   -0.0010436270f},     /* Filter 111 */
        {  -0.0004516136f,    0.0013899237f},
        {  -0.0044846698f,   -0.0007103019f},
        {   0.0000000000f,   -0.0005233689f},
        {  -0.0051998731f,    0.0008235790f},
        {  -0.0002314730f,   -0.0007124005f},
        {  -0.0097042763f,    0.0049445757f},
        {  -0.0037708270f,   -0.0051900982f},
        {  -0.0177002397f,    0.0177002397f},
        {  -0.0388407526f,   -0.0282194586f},
        {   0.0005537359f,   -0.0010867680f},
        {  -0.1256516079f,   -0.0408266823f},
        {   0.0441308133f,   -0.2786309892f},
        {   0.3407785039f,    0.0000000000f},
        {   0.0410140671f,    0.2589526285f},
        {  -0.1022323897f,    0.0332173170f},
        {   0.0067207811f,    0.0131902755f},
        {  -0.0384999358f,    0.0279718407f},
        {  -0.0135741072f,   -0.0135741072f},
        {  -0.0053318786f,    0.0073387013f},
        {  -0.0084235294f,   -0.0042920026f},
        {  -0.0007135575f,    0.0021961043f},
        {  -0.0047366037f,   -0.0007502043f},
        {   0.0000000000f,    0.0015716164f},
        {  -0.0044022844f,    0.0006972533f},
        {  -0.0002150272f,   -0.0006617856f},
        {  -0.0022085377f,    0.0011253062f}
    },
    {
        {  -0.0020408022f,   -0.0010398406f},     /* Filter 112 */
        {  -0.0004594994f,    0.0014141938f},
        {  -0.0044840278f,   -0.0007102002f},
        {   0.0000000000f,   -0.0004870592f},
        {  -0.0052106492f,    0.0008252858f},
        {  -0.0002140858f,   -0.0006588884f},
        {  -0.0097411254f,    0.0049633513f},
        {  -0.0037109171f,   -0.0051076392f},
        {  -0.0178370350f,    0.0178370350f},
        {  -0.0388280428f,   -0.0282102244f},
        {   0.0003298196f,   -0.0006473074f},
        {  -0.1264427052f,   -0.0410837254f},
        {   0.0442286557f,   -0.2792487420f},
        {   0.3407163139f,    0.0000000000f},
        {   0.0409045147f,    0.2582609415f},
        {  -0.1014646226f,    0.0329678544f},
        {   0.0069078131f,    0.0135573465f},
        {  -0.0384656852f,    0.0279469562f},
        {  -0.0134368115f,   -0.0134368115f},
        {  -0.0053759855f,    0.0073994093f},
        {  -0.0083756155f,   -0.0042675892f},
        {  -0.0007282033f,    0.0022411794f},
        {  -0.0047167638f,   -0.0007470620f},
        {   0.0000000000f,    0.0016048978f},
        {  -0.0043962359f,    0.0006962954f},
        {  -0.0002072092f,   -0.0006377245f},
        {  -0.0022117956f,    0.0011269662f}
    },
    {
        {  -0.0020332365f,   -0.0010359857f},     /* Filter 113 */
        {  -0.0004673804f,    0.0014384488f},
        {  -0.0044831593f,   -0.0007100627f},
        {   0.0000000000f,   -0.0004506776f},
        {  -0.0052211059f,    0.0008269419f},
        {  -0.0001966211f,   -0.0006051376f},
        {  -0.0097775620f,    0.0049819167f},
        {  -0.0036505044f,   -0.0050244882f},
        {  -0.0179737156f,    0.0179737156f},
        {  -0.0388137063f,   -0.0281998083f},
        {   0.0001047341f,   -0.0002055523f},
        {  -0.1272343255f,   -0.0413409384f},
        {   0.0443260808f,   -0.2798638600f},
        {   0.3406501456f,    0.0000000000f},
        {   0.0407946244f,    0.2575671213f},
        {  -0.1006978434f,    0.0327187127f},
        {   0.0070936379f,    0.0139220482f},
        {  -0.0384300398f,    0.0279210583f},
        {  -0.0132995926f,   -0.0132995926f},
        {  -0.0054195838f,    0.0074594171f},
        {  -0.0083274089f,   -0.0042430267f},
        {  -0.0007427516f,    0.0022859543f},
        {  -0.0046966573f,   -0.0007438774f},
        {   0.0000000000f,    0.0016380516f},
        {  -0.0043899851f,    0.0006953053f},
        {  -0.0001994007f,   -0.0006136924f},
        {  -0.0022149197f,    0.0011285579f}
    },
    {
        {  -0.0020255376f,   -0.0010320630f},     /* Filter 114 */
        {  -0.0004752586f,    0.0014626955f},
        {  -0.0044820704f,   -0.0007098902f},
        {   0.0000000000f,   -0.0004142275f},
        {  -0.0052312458f,    0.0008285479f},
        {  -0.0001790793f,   -0.0005511493f},
        {  -0.0098135759f,    0.0050002667f},
        {  -0.0035895900f,   -0.0049406467f},
        {  -0.0181102764f,    0.0181102764f},
        {  -0.0387977338f,   -0.0281882036f},
        {  -0.0001215183f,    0.0002384932f},
        {  -0.1280264277f,   -0.0415983080f},
        {   0.0444230929f,   -0.2804763703f},
        {   0.3405799320f,    0.0000000000f},
        {   0.0406843964f,    0.2568711694f},
        {  -0.0999320580f,    0.0324698939f},
        {   0.0072782560f,    0.0142843817f},
        {  -0.0383929951f,    0.0278941437f},
        {  -0.0131624584f,   -0.0131624584f},
        {  -0.0054626681f,    0.0075187177f},
        {  -0.0082789073f,   -0.0042183140f},
        {  -0.0007572001f,    0.0023304223f},
        {  -0.0046762880f,   -0.0007406513f},
        {   0.0000000000f,    0.0016710782f},
        {  -0.0043835331f,    0.0006942834f},
        {  -0.0001916007f,   -0.0005896863f},
        {  -0.0022179116f,    0.0011300824f}
    },
    {
        {  -0.0020177053f,   -0.0010280722f},     /* Filter 115 */
        {  -0.0004831286f,    0.0014869168f},
        {  -0.0044807549f,   -0.0007096819f},
        {   0.0000000000f,   -0.0003777139f},
        {  -0.0052410650f,    0.0008301031f},
        {  -0.0001614619f,   -0.0004969285f},
        {  -0.0098491643f,    0.0050183999f},
        {  -0.0035281741f,   -0.0048561151f},
        {  -0.0182467125f,    0.0182467125f},
        {  -0.0387801244f,   -0.0281754096f},
        {  -0.0003489325f,    0.0006848186f},
        {  -0.1288190325f,   -0.0418558409f},
        {   0.0445196833f,   -0.2810862181f},
        {   0.3405057686f,    0.0000000000f},
        {   0.0405738379f,    0.2561731303f},
        {  -0.0991672869f,    0.0322214047f},
        {   0.0074616683f,    0.0146443485f},
        {  -0.0383545750f,    0.0278662299f},
        {  -0.0130254114f,   -0.0130254114f},
        {  -0.0055052393f,    0.0075773118f},
        {  -0.0082301158f,   -0.0041934535f},
        {  -0.0007715502f,    0.0023745874f},
        {  -0.0046556572f,   -0.0007373837f},
        {   0.0000000000f,    0.0017039785f},
        {  -0.0043768718f,    0.0006932284f},
        {  -0.0001838111f,   -0.0005657123f},
        {  -0.0022207691f,    0.0011315384f}
    },
    {
        {  -0.0020097374f,   -0.0010240124f},     /* Filter 116 */
        {  -0.0004909940f,    0.0015111241f},
        {  -0.0044792187f,   -0.0007094385f},
        {   0.0000000000f,   -0.0003411385f},
        {  -0.0052505618f,    0.0008316073f},
        {  -0.0001437692f,   -0.0004424761f},
        {  -0.0098843276f,    0.0050363165f},
        {  -0.0034662576f,   -0.0047708942f},
        {  -0.0183830151f,    0.0183830151f},
        {  -0.0387608713f,   -0.0281614214f},
        {  -0.0005775139f,    0.0011334349f},
        {  -0.1296120935f,   -0.0421135221f},
        {   0.0446158526f,   -0.2816934067f},
        {   0.3404275809f,    0.0000000000f},
        {   0.0404629427f,    0.2554729654f},
        {  -0.0984035433f,    0.0319732494f},
        {   0.0076438762f,    0.0150019516f},
        {  -0.0383147780f,    0.0278373157f},
        {  -0.0128884592f,   -0.0128884592f},
        {  -0.0055472976f,    0.0076352001f},
        {  -0.0081810412f,   -0.0041684487f},
        {  -0.0007858009f,    0.0024184465f},
        {  -0.0046347647f,   -0.0007340746f},
        {   0.0000000000f,    0.0017367458f},
        {  -0.0043700036f,    0.0006921406f},
        {  -0.0001760298f,   -0.0005417639f},
        {  -0.0022234937f,    0.0011329266f}
    },
    {
        {  -0.0020016361f,   -0.0010198845f},     /* Filter 117 */
        {  -0.0004988537f,    0.0015353137f},
        {  -0.0044774545f,   -0.0007091591f},
        {   0.0000000000f,   -0.0003045018f},
        {  -0.0052597363f,    0.0008330604f},
        {  -0.0001260014f,   -0.0003877925f},
        {  -0.0099190609f,    0.0050540140f},
        {  -0.0034038419f,   -0.0046849864f},
        {  -0.0185191789f,    0.0185191789f},
        {  -0.0387399618f,   -0.0281462298f},
        {  -0.0008072533f,    0.0015843239f},
        {  -0.1304056099f,   -0.0423713512f},
        {   0.0447115990f,   -0.2822979260f},
        {   0.3403453966f,    0.0000000000f},
        {   0.0403517197f,    0.2547707314f},
        {  -0.0976408374f,    0.0317254312f},
        {   0.0078248748f,    0.0153571814f},
        {  -0.0382736074f,    0.0278074035f},
        {  -0.0127516043f,   -0.0127516043f},
        {  -0.0055888462f,    0.0076923868f},
        {  -0.0081316854f,   -0.0041433007f},
        {  -0.0007999506f,    0.0024619949f},
        {  -0.0046136165f,   -0.0007307251f},
        {   0.0000000000f,    0.0017693819f},
        {  -0.0043629383f,    0.0006910215f},
        {  -0.0001682594f,   -0.0005178491f},
        {  -0.0022260831f,    0.0011342460f}
    },
    {
        {  -0.0019934027f,   -0.0010156894f},     /* Filter 118 */
        {  -0.0005067065f,    0.0015594822f},
        {  -0.0044754634f,   -0.0007088438f},
        {   0.0000000000f,   -0.0002678034f},
        {  -0.0052685865f,    0.0008344621f},
        {  -0.0001081607f,   -0.0003328846f},
        {  -0.0099533576f,    0.0050714890f},
        {  -0.0033409256f,   -0.0045983896f},
        {  -0.0186551985f,    0.0186551985f},
        {  -0.0387173945f,   -0.0281298337f},
        {  -0.0010381516f,    0.0020374872f},
        {  -0.1311995619f,   -0.0426293218f},
        {   0.0448069181f,   -0.2828997467f},
        {   0.3402592203f,    0.0000000000f},
        {   0.0402401713f,    0.2540664421f},
        {  -0.0968791926f,    0.0314779578f},
        {   0.0080046651f,    0.0157100397f},
        {  -0.0382310777f,    0.0277765039f},
        {  -0.0126148560f,   -0.0126148560f},
        {  -0.0056298825f,    0.0077488684f},
        {  -0.0080820516f,   -0.0041180110f},
        {  -0.0008139998f,    0.0025052338f},
        {  -0.0045922082f,   -0.0007273343f},
        {   0.0000000000f,    0.0018018889f},
        {  -0.0043556701f,    0.0006898704f},
        {  -0.0001605011f,   -0.0004939715f},
        {  -0.0022285419f,    0.0011354988f}
    },
    {
        {  -0.0019850362f,   -0.0010114265f},     /* Filter 119 */
        {  -0.0005145514f,    0.0015836262f},
        {  -0.0044732506f,   -0.0007084933f},
        {   0.0000000000f,   -0.0002310499f},
        {  -0.0052771110f,    0.0008358123f},
        {  -0.0000902463f,   -0.0002777495f},
        {  -0.0099872186f,    0.0050887420f},
        {  -0.0032775125f,   -0.0045111089f},
        {  -0.0187910667f,    0.0187910667f},
        {  -0.0386931575f,   -0.0281122245f},
        {  -0.0012702110f,    0.0024929295f},
        {  -0.1319939386f,   -0.0428874304f},
        {   0.0449018114f,   -0.2834988794f},
        {   0.3401690422f,    0.0000000000f},
        {   0.0401282958f,    0.2533600885f},
        {  -0.0961186050f,    0.0312308279f},
        {   0.0081832497f,    0.0160605319f},
        {  -0.0381871931f,    0.0277446198f},
        {  -0.0124782163f,   -0.0124782163f},
        {  -0.0056704053f,    0.0078046434f},
        {  -0.0080321422f,   -0.0040925809f},
        {  -0.0008279475f,    0.0025481605f},
        {  -0.0045705499f,   -0.0007239040f},
        {   0.0000000000f,    0.0018342587f},
        {  -0.0043481937f,    0.0006886862f},
        {  -0.0001527526f,   -0.0004701241f},
        {  -0.0022308664f,    0.0011366832f}
    },
    {
        {  -0.0019765358f,   -0.0010070953f},     /* Filter 120 */
        {  -0.0005223897f,    0.0016077501f},
        {  -0.0044708094f,   -0.0007081066f},
        {   0.0000000000f,   -0.0001942402f},
        {  -0.0052853097f,    0.0008371108f},
        {  -0.0000722598f,   -0.0002223928f},
        {  -0.0100206356f,    0.0051057689f},
        {  -0.0032136048f,   -0.0044231476f},
        {  -0.0189267792f,    0.0189267792f},
        {  -0.0386672447f,   -0.0280933977f},
        {  -0.0015034225f,    0.0029506329f},
        {  -0.1327887358f,   -0.0431456757f},
        {   0.0449962735f,   -0.2840952899f},
        {   0.3400748842f,    0.0000000000f},
        {   0.0400161008f,    0.2526517170f},
        {  -0.0953590886f,    0.0309840461f},
        {   0.0083606221f,    0.0164086448f},
        {  -0.0381419711f,    0.0277117641f},
        {  -0.0123416969f,   -0.0123416968f},
        {  -0.0057104183f,    0.0078597165f},
        {  -0.0079819653f,   -0.0040670144f},
        {  -0.0008417947f,    0.0025907777f},
        {  -0.0045486380f,   -0.0007204335f},
        {   0.0000000000f,    0.0018664891f},
        {  -0.0043405200f,    0.0006874708f},
        {  -0.0001450151f,   -0.0004463107f},
        {  -0.0022330599f,    0.0011378009f}
    },
    {
        {  -0.0019679000f,   -0.0010026952f},     /* Filter 121 */
        {  -0.0005302207f,    0.0016318514f},
        {  -0.0044681412f,   -0.0007076840f},
        {   0.0000000000f,   -0.0001573786f},
        {  -0.0052931768f,    0.0008383569f},
        {  -0.0000542017f,   -0.0001668158f},
        {  -0.0100536090f,    0.0051225696f},
        {  -0.0031491979f,   -0.0043344990f},
        {  -0.0190623224f,    0.0190623224f},
        {  -0.0386396562f,   -0.0280733535f},
        {  -0.0017377909f,    0.0034106068f},
        {  -0.1335839077f,   -0.0434040427f},
        {   0.0450903019f,   -0.2846889619f},
        {   0.3399767352f,    0.0000000000f},
        {   0.0399035852f,    0.2519413212f},
        {  -0.0946006731f,    0.0307376220f},
        {   0.0085367892f,    0.0167543922f},
        {  -0.0380954013f,    0.0276779292f},
        {  -0.0122052947f,   -0.0122052947f},
        {  -0.0057499191f,    0.0079140847f},
        {  -0.0079315220f,   -0.0040413123f},
        {  -0.0008555388f,    0.0026330778f},
        {  -0.0045264729f,   -0.0007169229f},
        {   0.0000000000f,    0.0018985847f},
        {  -0.0043326526f,    0.0006862248f},
        {  -0.0001372916f,   -0.0004225402f},
        {  -0.0022351193f,    0.0011388502f}
    },
    {
        {  -0.0019591345f,   -0.0009982289f},     /* Filter 122 */
        {  -0.0005380409f,    0.0016559196f},
        {  -0.0044652477f,   -0.0007072258f},
        {   0.0000000000f,   -0.0001204636f},
        {  -0.0053007186f,    0.0008395513f},
        {  -0.0000360739f,   -0.0001110239f},
        {  -0.0100861291f,    0.0051391395f},
        {  -0.0030842956f,   -0.0042451688f},
        {  -0.0191976997f,    0.0191976997f},
        {  -0.0386103853f,   -0.0280520870f},
        {  -0.0019733077f,    0.0038728344f},
        {  -0.1343794616f,   -0.0436625339f},
        {   0.0451838979f,   -0.2852799039f},
        {   0.3398745971f,    0.0000000000f},
        {   0.0397907528f,    0.2512289255f},
        {  -0.0938433728f,    0.0304915602f},
        {   0.0087117470f,    0.0170977662f},
        {  -0.0380475075f,    0.0276431323f},
        {  -0.0120690194f,   -0.0120690194f},
        {  -0.0057889082f,    0.0079677486f},
        {  -0.0078808157f,   -0.0040154761f},
        {  -0.0008691803f,    0.0026750618f},
        {  -0.0045040620f,   -0.0007133733f},
        {   0.0000000000f,    0.0019305404f},
        {  -0.0043245792f,    0.0006849461f},
        {  -0.0001295793f,   -0.0003988041f},
        {  -0.0022370475f,    0.0011398326f}
    },
    {
        {  -0.0019502349f,   -0.0009936943f},     /* Filter 123 */
        {  -0.0005458542f,    0.0016799665f},
        {  -0.0044621312f,   -0.0007067322f},
        {   0.0000000000f,   -0.0000835019f},
        {  -0.0053079282f,    0.0008406932f},
        {  -0.0000178756f,   -0.0000550153f},
        {  -0.0101182016f,    0.0051554812f},
        {  -0.0030189005f,   -0.0041551601f},
        {  -0.0193328981f,    0.0193328981f},
        {  -0.0385794176f,   -0.0280295876f},
        {  -0.0022099760f,    0.0043373221f},
        {  -0.1351753758f,   -0.0439211421f},
        {   0.0452770566f,   -0.2858680847f},
        {   0.3397684879f,    0.0000000000f},
        {   0.0396776072f,    0.2505145525f},
        {  -0.0930871855f,    0.0302458600f},
        {   0.0088854919f,    0.0174387598f},
        {  -0.0379982948f,    0.0276073771f},
        {  -0.0119328775f,   -0.0119328775f},
        {  -0.0058273888f,    0.0080207126f},
        {  -0.0078298528f,   -0.0039895092f},
        {  -0.0008827194f,    0.0027167309f},
        {  -0.0044814011f,   -0.0007097842f},
        {   0.0000000000f,    0.0019623556f},
        {  -0.0043163061f,    0.0006836357f},
        {  -0.0001218783f,   -0.0003751028f},
        {  -0.0022388438f,    0.0011407479f}
    },
    {
        {  -0.0019412022f,   -0.0009890919f},     /* Filter 124 */
        {  -0.0005536582f,    0.0017039849f},
        {  -0.0044587869f,   -0.0007062025f},
        {   0.0000000000f,   -0.0000464885f},
        {  -0.0053148036f,    0.0008417822f},
        {   0.0000003917f,    0.0000012056f},
        {  -0.0101498145f,    0.0051715888f},
        {  -0.0029530116f,   -0.0040644718f},
        {  -0.0194679109f,    0.0194679108f},
        {  -0.0385467483f,   -0.0280058520f},
        {  -0.0024477914f,    0.0048040611f},
        {  -0.1359716398f,   -0.0441798639f},
        {   0.0453697749f,   -0.2864534851f},
        {   0.3396583880f,    0.0000000000f},
        {   0.0395641480f,    0.2497981996f},
        {  -0.0923321333f,    0.0300005287f},
        {   0.0090580301f,    0.0177773850f},
        {  -0.0379477617f,    0.0275706627f},
        {  -0.0117968713f,   -0.0117968713f},
        {  -0.0058653573f,    0.0080729717f},
        {  -0.0077786333f,   -0.0039634116f},
        {  -0.0008961544f,    0.0027580796f},
        {  -0.0044584965f,   -0.0007061565f},
        {   0.0000000000f,    0.0019940273f},
        {  -0.0043078420f,    0.0006822951f},
        {  -0.0001141917f,   -0.0003514459f},
        {  -0.0022405060f,    0.0011415948f}
    },
    {
        {  -0.0019320383f,   -0.0009844227f},     /* Filter 125 */
        {  -0.0005614523f,    0.0017279724f},
        {  -0.0044552115f,   -0.0007056362f},
        {   0.0000000000f,   -0.0000094350f},
        {  -0.0053213449f,    0.0008428182f},
        {   0.0000187268f,    0.0000576352f},
        {  -0.0101809712f,    0.0051874639f},
        {  -0.0028866289f,   -0.0039731038f},
        {  -0.0196027359f,    0.0196027359f},
        {  -0.0385123811f,   -0.0279808828f},
        {  -0.0026867496f,    0.0052730430f},
        {  -0.1367682312f,   -0.0444386921f},
        {   0.0454620561f,   -0.2870361257f},
        {   0.3395443142f,    0.0000000000f},
        {   0.0394503819f,    0.2490799083f},
        {  -0.0915782327f,    0.0297555716f},
        {   0.0092293595f,    0.0181136380f},
        {  -0.0378959245f,    0.0275330008f},
        {  -0.0116610092f,   -0.0116610092f},
        {  -0.0059028162f,    0.0081245295f},
        {  -0.0077271635f,   -0.0039371865f},
        {  -0.0009094853f,    0.0027991078f},
        {  -0.0044353502f,   -0.0007024905f},
        {   0.0000000000f,    0.0020255556f},
        {  -0.0042991742f,    0.0006809223f},
        {  -0.0001065179f,   -0.0003278284f},
        {  -0.0022420391f,    0.0011423760f}
    },
    {
        {  -0.0019227418f,   -0.0009796859f},     /* Filter 126 */
        {  -0.0005692359f,    0.0017519279f},
        {  -0.0044514082f,   -0.0007050338f},
        {  -0.0000000000f,    0.0000276667f},
        {  -0.0053275531f,    0.0008438015f},
        {   0.0000371295f,    0.0001142729f},
        {  -0.0102116616f,    0.0052031015f},
        {  -0.0028197549f,   -0.0038810597f},
        {  -0.0197373608f,    0.0197373608f},
        {  -0.0384763002f,   -0.0279546684f},
        {  -0.0029268546f,    0.0057442757f},
        {  -0.1375651403f,   -0.0446976236f},
        {   0.0455538916f,   -0.2876159521f},
        {   0.3394262701f,    0.0000000000f},
        {   0.0393363079f,    0.2483596736f},
        {  -0.0908254902f,    0.0295109907f},
        {   0.0093994769f,    0.0184475121f},
        {  -0.0378427866f,    0.0274943939f},
        {  -0.0115252954f,   -0.0115252954f},
        {  -0.0059397663f,    0.0081753869f},
        {  -0.0076754477f,   -0.0039108359f},
        {  -0.0009227124f,    0.0028398167f},
        {  -0.0044119618f,   -0.0006987861f},
        {   0.0000000000f,    0.0020569427f},
        {  -0.0042903141f,    0.0006795190f},
        {  -0.0000988591f,   -0.0003042571f},
        {  -0.0022434404f,    0.0011430900f}
    },
    {
        {  -0.0019133143f,   -0.0009748823f},     /* Filter 127 */
        {  -0.0005770089f,    0.0017758509f},
        {  -0.0044473797f,   -0.0007043957f},
        {  -0.0000000000f,    0.0000648082f},
        {  -0.0053334257f,    0.0008447316f},
        {   0.0000555987f,    0.0001711151f},
        {  -0.0102418869f,    0.0052185020f},
        {  -0.0027523906f,   -0.0037883407f},
        {  -0.0198717871f,    0.0198717871f},
        {  -0.0384385005f,   -0.0279272053f},
        {  -0.0031681003f,    0.0062177469f},
        {  -0.1383623364f,   -0.0449566483f},
        {   0.0456452799f,   -0.2881929551f},
        {   0.3393042459f,    0.0000000000f},
        {   0.0392219302f,    0.2476375210f},
        {  -0.0900739211f,    0.0292667911f},
        {   0.0095683866f,    0.0187790160f},
        {  -0.0377883557f,    0.0274548475f},
        {  -0.0113897330f,   -0.0113897330f},
        {  -0.0059762043f,    0.0082255396f},
        {  -0.0076234874f,   -0.0038843609f},
        {  -0.0009358341f,    0.0028802012f},
        {  -0.0043883332f,   -0.0006950437f},
        {   0.0000000000f,    0.0020881801f},
        {  -0.0042812542f,    0.0006780840f},
        {  -0.0000912136f,   -0.0002807266f},
        {  -0.0022447108f,    0.0011437373f}
    },
    {
        {  -0.0019037530f,   -0.0009700106f},     /* Filter 128 */
        {  -0.0005847711f,    0.0017997404f},
        {  -0.0044431266f,   -0.0007037221f},
        {  -0.0000000000f,    0.0001019889f},
        {  -0.0053389628f,    0.0008456086f},
        {   0.0000741335f,    0.0002281595f},
        {  -0.0102716430f,    0.0052336635f},
        {  -0.0026845378f,   -0.0036949493f},
        {  -0.0200059998f,    0.0200059998f},
        {  -0.0383989776f,   -0.0278984903f},
        {  -0.0034104848f,    0.0066934534f},
        {  -0.1391598293f,   -0.0452157695f},
        {   0.0457362256f,   -0.2887671637f},
        {   0.3391782445f,    0.0000000000f},
        {   0.0391072478f,    0.2469134451f},
        {  -0.0893235341f,    0.0290229756f},
        {   0.0097360827f,    0.0191081383f},
        {  -0.0377326433f,    0.0274143701f},
        {  -0.0112543303f,   -0.0112543303f},
        {  -0.0060121356f,    0.0082749947f},
        {  -0.0075712885f,   -0.0038577642f},
        {  -0.0009488505f,    0.0029202617f},
        {  -0.0043644688f,   -0.0006912640f},
        {   0.0000000000f,    0.0021192677f},
        {  -0.0042720048f,    0.0006766191f},
        {  -0.0000835820f,   -0.0002572389f},
        {  -0.0022458480f,    0.0011443167f}
    },
    {
        {  -0.0018940611f,   -0.0009650723f},     /* Filter 129 */
        {  -0.0005925210f,    0.0018235921f},
        {  -0.0044386430f,   -0.0007030120f},
        {  -0.0000000000f,    0.0001392054f},
        {  -0.0053441572f,    0.0008464313f},
        {   0.0000927328f,    0.0002854022f},
        {  -0.0103009234f,    0.0052485826f},
        {  -0.0026161974f,   -0.0036008869f},
        {  -0.0201399968f,    0.0201399968f},
        {  -0.0383577269f,   -0.0278685199f},
        {  -0.0036540038f,    0.0071713863f},
        {  -0.1399575771f,   -0.0454749735f},
        {   0.0458267191f,   -0.2893385169f},
        {   0.3390482929f,    0.0000000000f},
        {   0.0389922690f,    0.2461874974f},
        {  -0.0885743593f,    0.0287795539f},
        {   0.0099025724f,    0.0194348927f},
        {  -0.0376756581f,    0.0273729679f},
        {  -0.0111190914f,   -0.0111190914f},
        {  -0.0060475588f,    0.0083237506f},
        {  -0.0075188538f,   -0.0038310474f},
        {  -0.0009617615f,    0.0029599977f},
        {  -0.0043403667f,   -0.0006874465f},
        {   0.0000000000f,    0.0021502064f},
        {  -0.0042625620f,    0.0006751235f},
        {  -0.0000759667f,   -0.0002338013f},
        {  -0.0022468561f,    0.0011448304f}
    },
    {
        {  -0.0018842402f,   -0.0009600683f},     /* Filter 130 */
        {  -0.0006002610f,    0.0018474133f},
        {  -0.0044339292f,   -0.0007022654f},
        {  -0.0000000000f,    0.0001764611f},
        {  -0.0053490169f,    0.0008472010f},
        {   0.0001113966f,    0.0003428435f},
        {  -0.0103297257f,    0.0052632581f},
        {  -0.0025473698f,   -0.0035061537f},
        {  -0.0202737736f,    0.0202737736f},
        {  -0.0383147369f,   -0.0278372858f},
        {  -0.0038986588f,    0.0076515487f},
        {  -0.1407555807f,   -0.0457342605f},
        {   0.0459167605f,   -0.2899070162f},
        {   0.3389143782f,    0.0000000000f},
        {   0.0388769943f,    0.2454596814f},
        {  -0.0878263866f,    0.0285365229f},
        {   0.0100678484f,    0.0197592651f},
        {  -0.0376174025f,    0.0273306427f},
        {  -0.0109840200f,   -0.0109840200f},
        {  -0.0060824726f,    0.0083718053f},
        {  -0.0074661872f,   -0.0038042124f},
        {  -0.0009745664f,    0.0029994070f},
        {  -0.0043160343f,   -0.0006835927f},
        {   0.0000000000f,    0.0021809969f},
        {  -0.0042529265f,    0.0006735974f},
        {  -0.0000683662f,   -0.0002104096f},
        {  -0.0022477336f,    0.0011452775f}
    },
    {
        {  -0.0018742850f,   -0.0009549959f},     /* Filter 131 */
        {  -0.0006079877f,    0.0018711939f},
        {  -0.0044289903f,   -0.0007014832f},
        {  -0.0000000000f,    0.0002137479f},
        {  -0.0053535336f,    0.0008479164f},
        {   0.0001301236f,    0.0004004791f},
        {  -0.0103580469f,    0.0052776885f},
        {  -0.0024780545f,   -0.0034107494f},
        {  -0.0204073193f,    0.0204073193f},
        {  -0.0382700034f,   -0.0278047850f},
        {  -0.0041444459f,    0.0081339331f},
        {  -0.1415538244f,   -0.0459936256f},
        {   0.0460063488f,   -0.2904726541f},
        {   0.3387764777f,    0.0000000000f},
        {   0.0387614234f,    0.2447299955f},
        {  -0.0870796498f,    0.0282938934f},
        {   0.0102319154f,    0.0200812646f},
        {  -0.0375578842f,    0.0272874001f},
        {  -0.0108491236f,   -0.0108491236f},
        {  -0.0061168795f,    0.0084191624f},
        {  -0.0074132930f,   -0.0037772614f},
        {  -0.0009872642f,    0.0030384868f},
        {  -0.0042914690f,   -0.0006797019f},
        {   0.0000000000f,    0.0022116302f},
        {  -0.0042430934f,    0.0006720400f},
        {  -0.0000607804f,   -0.0001870628f},
        {  -0.0022484808f,    0.0011456582f}
    },
    {
        {  -0.0018642004f,   -0.0009498575f},     /* Filter 132 */
        {  -0.0006157019f,    0.0018949356f},
        {  -0.0044238206f,   -0.0007006644f},
        {  -0.0000000000f,    0.0002510630f},
        {  -0.0053577070f,    0.0008485774f},
        {   0.0001489124f,    0.0004583052f},
        {  -0.0103858860f,    0.0052918732f},
        {  -0.0024082571f,   -0.0033146815f},
        {  -0.0205406256f,    0.0205406256f},
        {  -0.0382235216f,   -0.0277710140f},
        {  -0.0043913598f,    0.0086185289f},
        {  -0.1423522805f,   -0.0462530597f},
        {   0.0460954822f,   -0.2910354206f},
        {   0.3386346272f,    0.0000000000f},
        {   0.0386455624f,    0.2439984781f},
        {  -0.0863341457f,    0.0280516644f},
        {   0.0103947715f,    0.0204008878f},
        {  -0.0374971151f,    0.0272432488f},
        {  -0.0107144051f,   -0.0107144051f},
        {  -0.0061507798f,    0.0084658221f},
        {  -0.0073601752f,   -0.0037501966f},
        {  -0.0009998548f,    0.0030772368f},
        {  -0.0042666731f,   -0.0006757746f},
        {   0.0000000000f,    0.0022421145f},
        {  -0.0042330752f,    0.0006704533f},
        {  -0.0000532127f,   -0.0001637720f},
        {  -0.0022490980f,    0.0011459727f}
    },
    {
        {  -0.0018539858f,   -0.0009446530f},     /* Filter 133 */
        {  -0.0006234019f,    0.0019186336f},
        {  -0.0044184245f,   -0.0006998097f},
        {  -0.0000000000f,    0.0002884118f},
        {  -0.0053615377f,    0.0008491842f},
        {   0.0001677624f,    0.0005163194f},
        {  -0.0104132366f,    0.0053058091f},
        {  -0.0023379747f,   -0.0032179461f},
        {  -0.0206736926f,    0.0206736926f},
        {  -0.0381752904f,   -0.0277359720f},
        {  -0.0046394033f,    0.0091053416f},
        {  -0.1431509477f,   -0.0465125625f},
        {   0.0461841561f,   -0.2915952853f},
        {   0.3384888443f,    0.0000000000f},
        {   0.0385294149f,    0.2432651518f},
        {  -0.0855898984f,    0.0278098438f},
        {   0.0105564182f,    0.0207181373f},
        {  -0.0374351001f,    0.0271981923f},
        {  -0.0105798714f,   -0.0105798714f},
        {  -0.0061841719f,    0.0085117824f},
        {  -0.0073068366f,   -0.0037230192f},
        {  -0.0010123388f,    0.0031156583f},
        {  -0.0042416532f,   -0.0006718119f},
        {   0.0000000000f,    0.0022724392f},
        {  -0.0042228650f,    0.0006688361f},
        {  -0.0000456602f,   -0.0001405276f},
        {  -0.0022495854f,    0.0011462210f}
    },
    {
        {  -0.0018436386f,   -0.0009393808f},     /* Filter 134 */
        {  -0.0006310899f,    0.0019422951f},
        {  -0.0044127982f,   -0.0006989186f},
        {  -0.0000000000f,    0.0003257856f},
        {  -0.0053650246f,    0.0008497364f},
        {   0.0001866731f,    0.0005745208f},
        {  -0.0104400974f,    0.0053194953f},
        {  -0.0022672080f,   -0.0031205442f},
        {  -0.0208065105f,    0.0208065104f},
        {  -0.0381252938f,   -0.0276996474f},
        {  -0.0048885719f,    0.0095943625f},
        {  -0.1439497887f,   -0.0467721216f},
        {   0.0462723730f,   -0.2921522650f},
        {   0.3383391016f,    0.0000000000f},
        {   0.0384129780f,    0.2425299982f},
        {  -0.0848469266f,    0.0275684376f},
        {   0.0107168551f,    0.0210330123f},
        {  -0.0373718527f,    0.0271522404f},
        {  -0.0104455273f,   -0.0104455273f},
        {  -0.0062170590f,    0.0085570476f},
        {  -0.0072532811f,   -0.0036957313f},
        {  -0.0010247148f,    0.0031537479f},
        {  -0.0042164035f,   -0.0006678127f},
        {   0.0000000000f,    0.0023026112f},
        {  -0.0042124676f,    0.0006671893f},
        {  -0.0000381241f,   -0.0001173340f},
        {  -0.0022499438f,    0.0011464036f}
    },
    {
        {  -0.0018331638f,   -0.0009340436f},     /* Filter 135 */
        {  -0.0006387617f,    0.0019659065f},
        {  -0.0044069406f,   -0.0006979908f},
        {  -0.0000000000f,    0.0003631842f},
        {  -0.0053681691f,    0.0008502345f},
        {   0.0002056433f,    0.0006329051f},
        {  -0.0104664619f,    0.0053329287f},
        {  -0.0021959615f,   -0.0030224817f},
        {  -0.0209390691f,    0.0209390691f},
        {  -0.0380735357f,   -0.0276620429f},
        {  -0.0051388586f,    0.0100855779f},
        {  -0.1447488052f,   -0.0470317378f},
        {   0.0463601257f,   -0.2927063137f},
        {   0.3381854075f,    0.0000000000f},
        {   0.0382962586f,    0.2417930608f},
        {  -0.0841052204f,    0.0273274427f},
        {   0.0108760800f,    0.0213455089f},
        {  -0.0373073694f,    0.0271053905f},
        {  -0.0103113770f,   -0.0103113770f},
        {  -0.0062494398f,    0.0086016160f},
        {  -0.0071995141f,   -0.0036683357f},
        {  -0.0010369820f,    0.0031915023f},
        {  -0.0041909284f,   -0.0006637778f},
        {   0.0000000000f,    0.0023326243f},
        {  -0.0042018827f,    0.0006655128f},
        {  -0.0000306060f,   -0.0000941955f},
        {  -0.0022501716f,    0.0011465197f}
    },
    {
        {  -0.0018225596f,   -0.0009286405f},     /* Filter 136 */
        {  -0.0006464218f,    0.0019894817f},
        {  -0.0044008610f,   -0.0006970279f},
        {  -0.0000000000f,    0.0004006073f},
        {  -0.0053709647f,    0.0008506772f},
        {   0.0002246725f,    0.0006914707f},
        {  -0.0104923262f,    0.0053461072f},
        {  -0.0021242368f,   -0.0029237612f},
        {  -0.0210713702f,    0.0210713702f},
        {  -0.0380200008f,   -0.0276231475f},
        {  -0.0053902680f,    0.0105789967f},
        {  -0.1455479905f,   -0.0472914089f},
        {   0.0464474173f,   -0.2932574514f},
        {   0.3380277742f,    0.0000000000f},
        {   0.0381792592f,    0.2410543557f},
        {  -0.0833648092f,    0.0270868685f},
        {   0.0110340968f,    0.0216556342f},
        {  -0.0372416715f,    0.0270576581f},
        {  -0.0101774269f,   -0.0101774269f},
        {  -0.0062813164f,    0.0086454904f},
        {  -0.0071455361f,   -0.0036408325f},
        {  -0.0010491418f,    0.0032289263f},
        {  -0.0041652385f,   -0.0006597090f},
        {   0.0000000000f,    0.0023624732f},
        {  -0.0041911082f,    0.0006638063f},
        {  -0.0000231042f,   -0.0000711074f},
        {  -0.0022502727f,    0.0011465712f}
    },
    {
        {  -0.0018118257f,   -0.0009231713f},     /* Filter 137 */
        {  -0.0006540651f,    0.0020130052f},
        {  -0.0043945464f,   -0.0006960278f},
        {  -0.0000000000f,    0.0004380525f},
        {  -0.0053734107f,    0.0008510646f},
        {   0.0002437596f,    0.0007502151f},
        {  -0.0105176937f,    0.0053590326f},
        {  -0.0020520317f,   -0.0028243793f},
        {  -0.0212033969f,    0.0212033969f},
        {  -0.0379646890f,   -0.0275829612f},
        {  -0.0056427969f,    0.0110746124f},
        {  -0.1463473013f,   -0.0475511207f},
        {   0.0465342410f,   -0.2938056346f},
        {   0.3378661729f,    0.0000000000f},
        {   0.0380619805f,    0.2403138872f},
        {  -0.0826257082f,    0.0268467200f},
        {   0.0111909061f,    0.0219633900f},
        {  -0.0371747573f,    0.0270090421f},
        {  -0.0100436811f,   -0.0100436811f},
        {  -0.0063126885f,    0.0086886704f},
        {  -0.0070913538f,   -0.0036132252f},
        {  -0.0010611914f,    0.0032660113f},
        {  -0.0041393246f,   -0.0006556046f},
        {   0.0000000000f,    0.0023921649f},
        {  -0.0041801479f,    0.0006620704f},
        {  -0.0000156216f,   -0.0000480783f},
        {  -0.0022502440f,    0.0011465566f}
    },
    {
        {  -0.0018009641f,   -0.0009176370f},     /* Filter 138 */
        {  -0.0006616940f,    0.0020364848f},
        {  -0.0043880048f,   -0.0006949917f},
        {  -0.0000000000f,    0.0004755140f},
        {  -0.0053755151f,    0.0008513979f},
        {   0.0002629036f,    0.0008091340f},
        {  -0.0105425517f,    0.0053716984f},
        {  -0.0019793489f,   -0.0027243401f},
        {  -0.0213351496f,    0.0213351496f},
        {  -0.0379075894f,   -0.0275414759f},
        {  -0.0058964369f,    0.0115724090f},
        {  -0.1471467472f,   -0.0478108764f},
        {   0.0466205992f,   -0.2943508790f},
        {   0.3377006790f,    0.0000000000f},
        {   0.0379444273f,    0.2395716850f},
        {  -0.0818879174f,    0.0266069972f},
        {   0.0113465049f,    0.0222687697f},
        {  -0.0371066415f,    0.0269595532f},
        {  -0.0099101441f,   -0.0099101441f},
        {  -0.0063435547f,    0.0087311541f},
        {  -0.0070369692f,   -0.0035855149f},
        {  -0.0010731328f,    0.0033027631f},
        {  -0.0041131960f,   -0.0006514662f},
        {   0.0000000000f,    0.0024216984f},
        {  -0.0041690028f,    0.0006603052f},
        {  -0.0000081573f,   -0.0000251055f},
        {  -0.0022500878f,    0.0011464770f}
    },
    {
        {  -0.0017899694f,   -0.0009120349f},     /* Filter 139 */
        {  -0.0006693064f,    0.0020599133f},
        {  -0.0043812313f,   -0.0006939189f},
        {  -0.0000000000f,    0.0005129974f},
        {  -0.0053772639f,    0.0008516749f},
        {   0.0002821033f,    0.0008682246f},
        {  -0.0105669024f,    0.0053841057f},
        {  -0.0019061921f,   -0.0026236483f},
        {  -0.0214666211f,    0.0214666211f},
        {  -0.0378487057f,   -0.0274986943f},
        {  -0.0061511870f,    0.0120723842f},
        {  -0.1479462926f,   -0.0480706645f},
        {   0.0467064846f,   -0.2948931379f},
        {   0.3375312165f,    0.0000000000f},
        {   0.0378266004f,    0.2388277557f},
        {  -0.0811514623f,    0.0263677085f},
        {   0.0115008908f,    0.0225717691f},
        {  -0.0370373273f,    0.0269091934f},
        {  -0.0097768207f,   -0.0097768207f},
        {  -0.0063739197f,    0.0087729478f},
        {  -0.0069823897f,   -0.0035577053f},
        {  -0.0010849638f,    0.0033391752f},
        {  -0.0040868488f,   -0.0006472933f},
        {   0.0000000000f,    0.0024510651f},
        {  -0.0041576695f,    0.0006585102f},
        {  -0.0000007105f,   -0.0000021866f},
        {  -0.0022498023f,    0.0011463315f}
    },
    {
        {  -0.0017788493f,   -0.0009063690f},     /* Filter 140 */
        {  -0.0006769032f,    0.0020832938f},
        {  -0.0043742317f,   -0.0006928102f},
        {  -0.0000000000f,    0.0005504888f},
        {  -0.0053786652f,    0.0008518969f},
        {   0.0003013579f,    0.0009274844f},
        {  -0.0105907396f,    0.0053962514f},
        {  -0.0018325584f,   -0.0025223003f},
        {  -0.0215977999f,    0.0215977998f},
        {  -0.0377880256f,   -0.0274546077f},
        {  -0.0064070501f,    0.0125745438f},
        {  -0.1487459309f,   -0.0483304827f},
        {   0.0467919009f,   -0.2954324350f},
        {   0.3373578615f,    0.0000000000f},
        {   0.0377085026f,    0.2380821155f},
        {  -0.0804163482f,    0.0261288554f},
        {   0.0116540714f,    0.0228724030f},
        {  -0.0369668239f,    0.0268579697f},
        {  -0.0096437180f,   -0.0096437180f},
        {  -0.0064037822f,    0.0088140500f},
        {  -0.0069276141f,   -0.0035297957f},
        {  -0.0010966851f,    0.0033752497f},
        {  -0.0040602898f,   -0.0006430867f},
        {   0.0000000000f,    0.0024802648f},
        {  -0.0041461563f,    0.0006566866f},
        {   0.0000067158f,    0.0000206692f},
        {  -0.0022493906f,    0.0011461218f}
    },
    {
        {  -0.0017676012f,   -0.0009006378f},     /* Filter 141 */
        {  -0.0006844835f,    0.0021066237f},
        {  -0.0043670009f,   -0.0006916650f},
        {  -0.0000000000f,    0.0005879963f},
        {  -0.0053797155f,    0.0008520632f},
        {   0.0003206673f,    0.0009869126f},
        {  -0.0106140636f,    0.0054081355f},
        {  -0.0017584537f,   -0.0024203039f},
        {  -0.0217286837f,    0.0217286837f},
        {  -0.0377255408f,   -0.0274092098f},
        {  -0.0066640196f,    0.0130788749f},
        {  -0.1495456541f,   -0.0485903285f},
        {   0.0468768425f,   -0.2959687351f},
        {   0.3371805647f,    0.0000000000f},
        {   0.0375901346f,    0.2373347695f},
        {  -0.0796825853f,    0.0258904414f},
        {   0.0118060423f,    0.0231706626f},
        {  -0.0368951402f,    0.0268058885f},
        {  -0.0095108389f,   -0.0095108389f},
        {  -0.0064331423f,    0.0088544608f},
        {  -0.0068726491f,   -0.0035017896f},
        {  -0.0011082965f,    0.0034109859f},
        {  -0.0040335180f,   -0.0006388465f},
        {   0.0000000000f,    0.0025093019f},
        {  -0.0041344617f,    0.0006548344f},
        {   0.0000141245f,    0.0000434707f},
        {  -0.0022488502f,    0.0011458464f}
    },
    {
        {  -0.0017562251f,   -0.0008948414f},     /* Filter 142 */
        {  -0.0006920455f,    0.0021298969f},
        {  -0.0043595438f,   -0.0006904839f},
        {  -0.0000000000f,    0.0006255130f},
        {  -0.0053804086f,    0.0008521730f},
        {   0.0003400298f,    0.0010465041f},
        {  -0.0106368706f,    0.0054197563f},
        {  -0.0016838770f,   -0.0023176579f},
        {  -0.0218592629f,    0.0218592629f},
        {  -0.0376612461f,   -0.0273624970f},
        {  -0.0069220926f,    0.0135853716f},
        {  -0.1503454306f,   -0.0488501916f},
        {   0.0469613070f,   -0.2965020230f},
        {   0.3369993395f,    0.0000000000f},
        {   0.0374715012f,    0.2365857471f},
        {  -0.0789501938f,    0.0256524730f},
        {   0.0119568064f,    0.0234665539f},
        {  -0.0368222770f,    0.0267529502f},
        {  -0.0093781859f,   -0.0093781859f},
        {  -0.0064619996f,    0.0088941795f},
        {  -0.0068174982f,   -0.0034736888f},
        {  -0.0011197964f,    0.0034463789f},
        {  -0.0040065374f,   -0.0006345732f},
        {   0.0000000000f,    0.0025381729f},
        {  -0.0041225812f,    0.0006529527f},
        {   0.0000215125f,    0.0000662085f},
        {  -0.0022481826f,    0.0011455063f}
    },
    {
        {  -0.0017447212f,   -0.0008889799f},     /* Filter 143 */
        {  -0.0006995909f,    0.0021531195f},
        {  -0.0043518542f,   -0.0006892660f},
        {  -0.0000000000f,    0.0006630402f},
        {  -0.0053807534f,    0.0008522276f},
        {   0.0003594448f,    0.0011062575f},
        {  -0.0106591532f,    0.0054311098f},
        {  -0.0016088279f,   -0.0022143617f},
        {  -0.0219895354f,    0.0219895354f},
        {  -0.0375951417f,   -0.0273144693f},
        {  -0.0071812658f,    0.0140940276f},
        {  -0.1511452494f,   -0.0491100685f},
        {   0.0470452963f,   -0.2970323104f},
        {   0.3368142102f,    0.0000000000f},
        {   0.0373526110f,    0.2358351039f},
        {  -0.0782191848f,    0.0254149538f},
        {   0.0121063640f,    0.0237600772f},
        {  -0.0367482532f,    0.0266991688f},
        {  -0.0092457714f,   -0.0092457714f},
        {  -0.0064903592f,    0.0089332130f},
        {  -0.0067621637f,   -0.0034454945f},
        {  -0.0011311858f,    0.0034814320f},
        {  -0.0039793495f,   -0.0006302670f},
        {   0.0000000000f,    0.0025668690f},
        {  -0.0041105253f,    0.0006510433f},
        {   0.0000288809f,    0.0000888863f},
        {  -0.0022473903f,    0.0011451026f}
    },
    {
        {  -0.0017330882f,   -0.0008830525f},     /* Filter 144 */
        {  -0.0007071195f,    0.0021762900f},
        {  -0.0043439389f,   -0.0006880123f},
        {  -0.0000000000f,    0.0007005733f},
        {  -0.0053807400f,    0.0008522255f},
        {   0.0003789110f,    0.0011661681f},
        {  -0.0106809137f,    0.0054421973f},
        {  -0.0015333122f,   -0.0021104232f},
        {  -0.0221194870f,    0.0221194870f},
        {  -0.0375272169f,   -0.0272651190f},
        {  -0.0074415407f,    0.0146048459f},
        {  -0.1519450992f,   -0.0493699555f},
        {   0.0471288033f,   -0.2975595531f},
        {   0.3366251695f,    0.0000000000f},
        {   0.0372334541f,    0.2350827773f},
        {  -0.0774895642f,    0.0251778857f},
        {   0.0122547132f,    0.0240512288f},
        {  -0.0366730754f,    0.0266445489f},
        {  -0.0091135918f,   -0.0091135918f},
        {  -0.0065182191f,    0.0089715590f},
        {  -0.0067066524f,   -0.0034172101f},
        {  -0.0011424645f,    0.0035161441f},
        {  -0.0039519572f,   -0.0006259285f},
        {   0.0000000000f,    0.0025953985f},
        {  -0.0040982843f,    0.0006491045f},
        {   0.0000362282f,    0.0001114988f},
        {  -0.0022464703f,    0.0011446338f}
    },
    {
        {  -0.0017213310f,   -0.0008770619f},     /* Filter 145 */
        {  -0.0007146270f,    0.0021993958f},
        {  -0.0043357913f,   -0.0006867219f},
        {  -0.0000000000f,    0.0007381110f},
        {  -0.0053803718f,    0.0008521672f},
        {   0.0003984276f,    0.0012262341f},
        {  -0.0107021433f,    0.0054530144f},
        {  -0.0014573283f,   -0.0020058404f},
        {  -0.0222491169f,    0.0222491169f},
        {  -0.0374574722f,   -0.0272144465f},
        {  -0.0077029083f,    0.0151178087f},
        {  -0.1527449650f,   -0.0496298476f},
        {   0.0472118307f,   -0.2980837677f},
        {   0.3364322263f,    0.0000000000f},
        {   0.0371140423f,    0.2343288410f},
        {  -0.0767613480f,    0.0249412739f},
        {   0.0124018566f,    0.0243400141f},
        {  -0.0365967449f,    0.0265890915f},
        {  -0.0089816572f,   -0.0089816572f},
        {  -0.0065455769f,    0.0090092137f},
        {  -0.0066509631f,   -0.0033888350f},
        {  -0.0011536312f,    0.0035505117f},
        {  -0.0039243606f,   -0.0006215577f},
        {   0.0000000000f,    0.0026237608f},
        {  -0.0040858657f,    0.0006471375f},
        {   0.0000435551f,    0.0001340487f},
        {  -0.0022454243f,    0.0011441008f}
    },
    {
        {  -0.0017094449f,   -0.0008710057f},     /* Filter 146 */
        {  -0.0007221187f,    0.0022224528f},
        {  -0.0043274173f,   -0.0006853956f},
        {  -0.0000000000f,    0.0007756478f},
        {  -0.0053796470f,    0.0008520524f},
        {   0.0004179944f,    0.0012864544f},
        {  -0.0107228440f,    0.0054635619f},
        {  -0.0013808793f,   -0.0019006173f},
        {  -0.0223784170f,    0.0223784170f},
        {  -0.0373858889f,   -0.0271624382f},
        {  -0.0079653685f,    0.0156329160f},
        {  -0.1535448176f,   -0.0498897355f},
        {   0.0472943732f,   -0.2986049201f},
        {   0.3362353715f,    0.0000000000f},
        {   0.0369943758f,    0.2335732963f},
        {  -0.0760345493f,    0.0247051227f},
        {   0.0125477901f,    0.0246264247f},
        {  -0.0365192713f,    0.0265328037f},
        {  -0.0088499695f,   -0.0088499695f},
        {  -0.0065724401f,    0.0090461878f},
        {  -0.0065951068f,   -0.0033603747f},
        {  -0.0011646849f,    0.0035845316f},
        {  -0.0038965612f,   -0.0006171547f},
        {   0.0000000000f,    0.0026519463f},
        {  -0.0040732755f,    0.0006451435f},
        {   0.0000508607f,    0.0001565332f},
        {  -0.0022442531f,    0.0011435041f}
    },
    {
        {  -0.0016974336f,   -0.0008648856f},     /* Filter 147 */
        {  -0.0007295900f,    0.0022454470f},
        {  -0.0043188118f,   -0.0006840326f},
        {  -0.0000000000f,    0.0008131900f},
        {  -0.0053785675f,    0.0008518814f},
        {   0.0004376090f,    0.0013468222f},
        {  -0.0107430073f,    0.0054738356f},
        {  -0.0013039662f,   -0.0017947555f},
        {  -0.0225073789f,    0.0225073789f},
        {  -0.0373124730f,   -0.0271090985f},
        {  -0.0082289214f,    0.0161501676f},
        {  -0.1543446506f,   -0.0501496170f},
        {   0.0473764318f,   -0.2991230182f},
        {   0.3360346197f,    0.0000000000f},
        {   0.0368744548f,    0.2328161450f},
        {  -0.0753091817f,    0.0244694365f},
        {   0.0126925250f,    0.0249104828f},
        {  -0.0364406716f,    0.0264756977f},
        {  -0.0087185354f,   -0.0087185354f},
        {  -0.0065988038f,    0.0090824743f},
        {  -0.0065390777f,   -0.0033318265f},
        {  -0.0011756279f,    0.0036182106f},
        {  -0.0038685641f,   -0.0006127204f},
        {   0.0000000000f,    0.0026799609f},
        {  -0.0040605034f,    0.0006431206f},
        {   0.0000581457f,    0.0001789542f},
        {  -0.0022429558f,    0.0011428431f}
    },
    {
        {  -0.0016852985f,   -0.0008587025f},     /* Filter 148 */
        {  -0.0007370403f,    0.0022683768f},
        {  -0.0043099736f,   -0.0006826328f},
        {  -0.0000000000f,    0.0008507285f},
        {  -0.0053771277f,    0.0008516534f},
        {   0.0004572711f,    0.0014073357f},
        {  -0.0107626298f,    0.0054838338f},
        {  -0.0012265888f,   -0.0016882547f},
        {  -0.0226359994f,    0.0226359994f},
        {  -0.0372372219f,   -0.0270544253f},
        {  -0.0084935567f,    0.0166695436f},
        {  -0.1551444498f,   -0.0504094875f},
        {   0.0474580032f,   -0.2996380397f},
        {   0.3358299840f,    0.0000000000f},
        {   0.0367542882f,    0.2320574430f},
        {  -0.0745852583f,    0.0242342195f},
        {   0.0128360470f,    0.0251921607f},
        {  -0.0363609391f,    0.0264177686f},
        {  -0.0085873575f,   -0.0085873575f},
        {  -0.0066246707f,    0.0091180770f},
        {  -0.0064828908f,   -0.0033031978f},
        {  -0.0011864571f,    0.0036515394f},
        {  -0.0038403710f,   -0.0006082550f},
        {   0.0000000000f,    0.0027078003f},
        {  -0.0040475567f,    0.0006410700f},
        {   0.0000654088f,    0.0002013077f},
        {  -0.0022415348f,    0.0011421190f}
    },
    {
        {  -0.0016730382f,   -0.0008524555f},     /* Filter 149 */
        {  -0.0007444717f,    0.0022912484f},
        {  -0.0043009099f,   -0.0006811972f},
        {  -0.0000000000f,    0.0008882574f},
        {  -0.0053753300f,    0.0008513686f},
        {   0.0004769806f,    0.0014679953f},
        {  -0.0107817128f,    0.0054935571f},
        {  -0.0011487520f,   -0.0015811215f},
        {  -0.0227642672f,    0.0227642672f},
        {  -0.0371601215f,   -0.0269984086f},
        {  -0.0087592798f,    0.0171910545f},
        {  -0.1559442033f,   -0.0506693432f},
        {   0.0475390854f,   -0.3001499723f},
        {   0.3356214637f,    0.0000000000f},
        {   0.0366338730f,    0.2312971712f},
        {  -0.0738627827f,    0.0239994729f},
        {   0.0129783713f,    0.0254714879f},
        {  -0.0362800956f,    0.0263590324f},
        {  -0.0084564442f,   -0.0084564442f},
        {  -0.0066500430f,    0.0091529990f},
        {  -0.0064265378f,   -0.0032744845f},
        {  -0.0011971748f,    0.0036845251f},
        {  -0.0038119815f,   -0.0006037586f},
        {   0.0000000000f,    0.0027354617f},
        {  -0.0040344299f,    0.0006389909f},
        {   0.0000726493f,    0.0002235915f},
        {  -0.0022399887f,    0.0011413312f}
    },
    {
        {  -0.0016606527f,   -0.0008461448f},     /* Filter 150 */
        {  -0.0007518828f,    0.0023140572f},
        {  -0.0042916190f,   -0.0006797257f},
        {  -0.0000000000f,    0.0009257855f},
        {  -0.0053731737f,    0.0008510271f},
        {   0.0004967352f,    0.0015287938f},
        {  -0.0108002480f,    0.0055030012f},
        {  -0.0010704568f,   -0.0014733573f},
        {  -0.0228921794f,    0.0228921794f},
        {  -0.0370811655f,   -0.0269410438f},
        {  -0.0090260797f,    0.0177146788f},
        {  -0.1567438739f,   -0.0509291719f},
        {   0.0476196755f,   -0.3006587981f},
        {   0.3354090492f,    0.0000000000f},
        {   0.0365132145f,    0.2305353630f},
        {  -0.0731417811f,    0.0237652053f},
        {   0.0131194860f,    0.0257484410f},
        {  -0.0361981382f,    0.0262994869f},
        {  -0.0083257964f,   -0.0083257964f},
        {  -0.0066749202f,    0.0091872395f},
        {  -0.0063700344f,   -0.0032456946f},
        {  -0.0012077784f,    0.0037171597f},
        {  -0.0037834012f,   -0.0005992319f},
        {   0.0000000000f,    0.0027629465f},
        {  -0.0040211370f,    0.0006368855f},
        {   0.0000798669f,    0.0002458049f},
        {  -0.0022383190f,    0.0011404805f}
    },
    {
        {  -0.0016481390f,   -0.0008397688f},     /* Filter 151 */
        {  -0.0007592726f,    0.0023368007f},
        {  -0.0042820985f,   -0.0006782178f},
        {  -0.0000000000f,    0.0009633032f},
        {  -0.0053706532f,    0.0008506279f},
        {   0.0005165348f,    0.0015897306f},
        {  -0.0108182392f,    0.0055121682f},
        {  -0.0009917019f,   -0.0013649606f},
        {  -0.0230197214f,    0.0230197214f},
        {  -0.0370003574f,   -0.0268823332f},
        {  -0.0092939607f,    0.0182404248f},
        {  -0.1575434521f,   -0.0511889706f},
        {   0.0476997708f,   -0.3011645002f},
        {   0.3351927556f,    0.0000000000f},
        {   0.0363923116f,    0.2297720123f},
        {  -0.0724222525f,    0.0235314163f},
        {   0.0132593976f,    0.0260230330f},
        {  -0.0361150801f,    0.0262391416f},
        {  -0.0081954182f,   -0.0081954182f},
        {  -0.0066993029f,    0.0092207994f},
        {  -0.0063133765f,   -0.0032168260f},
        {  -0.0012182683f,    0.0037494443f},
        {  -0.0037546254f,   -0.0005946742f},
        {   0.0000000000f,    0.0027902521f},
        {  -0.0040076731f,    0.0006347531f},
        {   0.0000870628f,    0.0002679518f},
        {  -0.0022365232f,    0.0011395655f}
    },
    {
        {  -0.0016355037f,   -0.0008333308f},     /* Filter 152 */
        {  -0.0007666411f,    0.0023594786f},
        {  -0.0042723457f,   -0.0006766731f},
        {  -0.0000000000f,    0.0010008101f},
        {  -0.0053677718f,    0.0008501715f},
        {   0.0005363782f,    0.0016508024f},
        {  -0.0108356778f,    0.0055210536f},
        {  -0.0009124926f,   -0.0012559383f},
        {  -0.0231468974f,    0.0231468974f},
        {  -0.0369176808f,   -0.0268222652f},
        {  -0.0095629171f,    0.0187682815f},
        {  -0.1583429520f,   -0.0514487439f},
        {   0.0477793762f,   -0.3016671090f},
        {   0.3349726054f,    0.0000000000f},
        {   0.0362711726f,    0.2290071711f},
        {  -0.0717042118f,    0.0232981107f},
        {   0.0133981115f,    0.0262952744f},
        {  -0.0360309323f,    0.0261780046f},
        {  -0.0080653181f,   -0.0080653181f},
        {  -0.0067231917f,    0.0092536796f},
        {  -0.0062565682f,   -0.0031878807f},
        {  -0.0012286457f,    0.0037813826f},
        {  -0.0037256640f,   -0.0005900872f},
        {   0.0000000000f,    0.0028173807f},
        {  -0.0039940319f,    0.0006325925f},
        {   0.0000942350f,    0.0002900256f},
        {  -0.0022346067f,    0.0011385890f}
    },
    {
        {  -0.0016227434f,   -0.0008268290f},     /* Filter 153 */
        {  -0.0007739869f,    0.0023820868f},
        {  -0.0042623665f,   -0.0006750925f},
        {  -0.0000000000f,    0.0010383048f},
        {  -0.0053645285f,    0.0008496578f},
        {   0.0005562642f,    0.0017120052f},
        {  -0.0108525630f,    0.0055296570f},
        {  -0.0008328273f,   -0.0011462885f},
        {  -0.0232736903f,    0.0232736903f},
        {  -0.0368331385f,   -0.0267608416f},
        {  -0.0098329431f,    0.0192982375f},
        {  -0.1591423172f,   -0.0517084734f},
        {   0.0478584820f,   -0.3021665631f},
        {   0.3347485628f,    0.0000000000f},
        {   0.0361497965f,    0.2282408324f},
        {  -0.0709876776f,    0.0230652947f},
        {   0.0135356225f,    0.0265651549f},
        {  -0.0359456982f,    0.0261160785f},
        {  -0.0079354970f,   -0.0079354970f},
        {  -0.0067465878f,    0.0092858815f},
        {  -0.0061996157f,   -0.0031588620f},
        {  -0.0012389084f,    0.0038129681f},
        {  -0.0036965139f,   -0.0005854703f},
        {   0.0000000000f,    0.0028443280f},
        {  -0.0039802216f,    0.0006304052f},
        {   0.0001013836f,    0.0003120266f},
        {  -0.0022325659f,    0.0011375491f}
    },
    {
        {  -0.0016098620f,   -0.0008202657f},     /* Filter 154 */
        {  -0.0007813108f,    0.0024046275f},
        {  -0.0042521612f,   -0.0006734762f},
        {  -0.0000000000f,    0.0010757878f},
        {  -0.0053609232f,    0.0008490868f},
        {   0.0005761918f,    0.0017733360f},
        {  -0.0108688882f,    0.0055379751f},
        {  -0.0007527098f,   -0.0010360162f},
        {  -0.0234001010f,    0.0234001010f},
        {  -0.0367467241f,   -0.0266980579f},
        {  -0.0101040387f,    0.0198302924f},
        {  -0.1599415609f,   -0.0519681634f},
        {   0.0479370898f,   -0.3026628735f},
        {   0.3345206886f,    0.0000000000f},
        {   0.0360281864f,    0.2274730162f},
        {  -0.0702726572f,    0.0228329704f},
        {   0.0136719292f,    0.0268326719f},
        {  -0.0358593925f,    0.0260533737f},
        {  -0.0078059632f,   -0.0078059632f},
        {  -0.0067694939f,    0.0093174091f},
        {  -0.0061425226f,   -0.0031297716f},
        {  -0.0012490578f,    0.0038442047f},
        {  -0.0036671818f,   -0.0005808245f},
        {   0.0000000000f,    0.0028710917f},
        {  -0.0039662425f,    0.0006281911f},
        {   0.0001085087f,    0.0003339556f},
        {  -0.0022304022f,    0.0011364467f}
    },
    {
        {  -0.0015968572f,   -0.0008136394f},     /* Filter 155 */
        {  -0.0007886122f,    0.0024270988f},
        {  -0.0042417193f,   -0.0006718223f},
        {  -0.0000000000f,    0.0011132506f},
        {  -0.0053569537f,    0.0008484581f},
        {   0.0005961600f,    0.0018347918f},
        {  -0.0108846506f,    0.0055460065f},
        {  -0.0006721419f,   -0.0009251240f},
        {  -0.0235261215f,    0.0235261215f},
        {  -0.0366584350f,   -0.0266339120f},
        {  -0.0103761991f,    0.0203644374f},
        {  -0.1607406511f,   -0.0522278035f},
        {   0.0480151982f,   -0.3031560303f},
        {   0.3342889675f,    0.0000000000f},
        {   0.0359063480f,    0.2267037589f},
        {  -0.0695591611f,    0.0226011415f},
        {   0.0138070366f,    0.0270978352f},
        {  -0.0357720145f,    0.0259898899f},
        {  -0.0076767172f,   -0.0076767172f},
        {  -0.0067919097f,    0.0093482617f},
        {  -0.0060852914f,   -0.0031006109f},
        {  -0.0012590926f,    0.0038750887f},
        {  -0.0036376653f,   -0.0005761496f},
        {   0.0000000000f,    0.0028976751f},
        {  -0.0039520956f,    0.0006259504f},
        {   0.0001156098f,    0.0003558105f},
        {  -0.0022281185f,    0.0011352831f}
    },
    {
        {  -0.0015837296f,   -0.0008069505f},     /* Filter 156 */
        {  -0.0007958903f,    0.0024494986f},
        {  -0.0042310587f,   -0.0006701339f},
        {  -0.0000000000f,    0.0011506901f},
        {  -0.0053526174f,    0.0008477713f},
        {   0.0006161688f,    0.0018963726f},
        {  -0.0108998530f,    0.0055537525f},
        {  -0.0005911249f,   -0.0008136137f},
        {  -0.0236517400f,    0.0236517400f},
        {  -0.0365682525f,   -0.0265683906f},
        {  -0.0106494241f,    0.0209006716f},
        {  -0.1615395679f,   -0.0524873874f},
        {   0.0480928020f,   -0.3036460014f},
        {   0.3340533515f,    0.0000000000f},
        {   0.0357842761f,    0.2259330273f},
        {  -0.0688471974f,    0.0223698105f},
        {   0.0139409476f,    0.0273606502f},
        {  -0.0356835773f,    0.0259256365f},
        {  -0.0075477654f,   -0.0075477654f},
        {  -0.0068138363f,    0.0093784411f},
        {  -0.0060279260f,   -0.0030713817f},
        {  -0.0012690123f,    0.0039056182f},
        {  -0.0036079683f,   -0.0005714460f},
        {   0.0000000000f,    0.0029240706f},
        {  -0.0039377785f,    0.0006236829f},
        {   0.0001226858f,    0.0003775881f},
        {  -0.0022257106f,    0.0011340562f}
    },
    {
        {  -0.0015704775f,   -0.0008001983f},     /* Filter 157 */
        {  -0.0008031447f,    0.0024718253f},
        {  -0.0042201659f,   -0.0006684086f},
        {  -0.0000000000f,    0.0011881132f},
        {  -0.0053479162f,    0.0008470267f},
        {   0.0006362162f,    0.0019580722f},
        {  -0.0109144832f,    0.0055612069f},
        {  -0.0005096614f,   -0.0007014887f},
        {  -0.0237769522f,    0.0237769522f},
        {  -0.0364761835f,   -0.0265014986f},
        {  -0.0109237052f,    0.0214389786f},
        {  -0.1623383067f,   -0.0527469133f},
        {   0.0481699031f,   -0.3041327986f},
        {   0.3338139023f,    0.0000000000f},
        {   0.0356619806f,    0.2251608839f},
        {  -0.0681367848f,    0.0221389834f},
        {   0.0140736575f,    0.0276211080f},
        {  -0.0355940851f,    0.0258606166f},
        {  -0.0074191106f,   -0.0074191106f},
        {  -0.0068352744f,    0.0094079482f},
        {  -0.0059704311f,   -0.0030420866f},
        {  -0.0012788172f,    0.0039357947f},
        {  -0.0035780951f,   -0.0005667146f},
        {   0.0000000000f,    0.0029502835f},
        {  -0.0039232962f,    0.0006213891f},
        {   0.0001297372f,    0.0003992901f},
        {  -0.0022231823f,    0.0011327680f}
    },
    {
        {  -0.0015571057f,   -0.0007933850f},     /* Filter 158 */
        {  -0.0008103756f,    0.0024940796f},
        {  -0.0042090432f,   -0.0006666470f},
        {  -0.0000000000f,    0.0012255137f},
        {  -0.0053428512f,    0.0008462245f},
        {   0.0006563010f,    0.0020198867f},
        {  -0.0109285481f,    0.0055683734f},
        {  -0.0004277512f,   -0.0005887490f},
        {  -0.0239017519f,    0.0239017519f},
        {  -0.0363822251f,   -0.0264332338f},
        {  -0.0111990442f,    0.0219793618f},
        {  -0.1631368376f,   -0.0530063717f},
        {   0.0482464973f,   -0.3046163955f},
        {   0.3335706260f,    0.0000000000f},
        {   0.0355394639f,    0.2243873441f},
        {  -0.0674279327f,    0.0219086634f},
        {   0.0142051710f,    0.0278792178f},
        {  -0.0355035484f,    0.0257948378f},
        {  -0.0072907606f,   -0.0072907606f},
        {  -0.0068562238f,    0.0094367825f},
        {  -0.0059128092f,   -0.0030127268f},
        {  -0.0012885070f,    0.0039656166f},
        {  -0.0035480443f,   -0.0005619550f},
        {   0.0000000000f,    0.0029763130f},
        {  -0.0039086496f,    0.0006190693f},
        {   0.0001367646f,    0.0004209182f},
        {  -0.0022205325f,    0.0011314178f}
    },
    {
        {  -0.0015436150f,   -0.0007865111f},     /* Filter 159 */
        {  -0.0008175826f,    0.0025162605f},
        {  -0.0041976949f,   -0.0006648496f},
        {  -0.0000000000f,    0.0012628858f},
        {  -0.0053374169f,    0.0008453638f},
        {   0.0006764229f,    0.0020818155f},
        {  -0.0109420370f,    0.0055752463f},
        {  -0.0003454002f,   -0.0004754026f},
        {  -0.0240261303f,    0.0240261303f},
        {  -0.0362863596f,   -0.0263635834f},
        {  -0.0114754349f,    0.0225218090f},
        {  -0.1639351598f,   -0.0532657623f},
        {   0.0483225860f,   -0.3050968004f},
        {   0.3333235086f,    0.0000000000f},
        {   0.0354167248f,    0.2236123999f},
        {  -0.0667206479f,    0.0216788527f},
        {   0.0143354881f,    0.0281349795f},
        {  -0.0354119781f,    0.0257283081f},
        {  -0.0071627177f,   -0.0071627177f},
        {  -0.0068766888f,    0.0094649501f},
        {  -0.0058550643f,   -0.0029833043f},
        {  -0.0012980817f,    0.0039950848f},
        {  -0.0035178221f,   -0.0005571683f},
        {   0.0000000000f,    0.0030021495f},
        {  -0.0038938406f,    0.0006167238f},
        {   0.0001437652f,    0.0004424639f},
        {  -0.0022177623f,    0.0011300064f}
    },
    {
        {  -0.0015300010f,   -0.0007795745f},     /* Filter 160 */
        {  -0.0008247632f,    0.0025383600f},
        {  -0.0041861158f,   -0.0006630156f},
        {  -0.0000000000f,    0.0013002283f},
        {  -0.0053316185f,    0.0008444454f},
        {   0.0006965800f,    0.0021438527f},
        {  -0.0109549473f,    0.0055818244f},
        {  -0.0002626055f,   -0.0003614454f},
        {  -0.0241500844f,    0.0241500844f},
        {  -0.0361885991f,   -0.0262925563f},
        {  -0.0117528734f,    0.0230663128f},
        {  -0.1647332531f,   -0.0535250786f},
        {   0.0483981644f,   -0.3055739837f},
        {   0.3330725580f,    0.0000000000f},
        {   0.0352937702f,    0.2228360951f},
        {  -0.0660149525f,    0.0214495583f},
        {   0.0144646069f,    0.0283883894f},
        {  -0.0353193822f,    0.0256610332f},
        {  -0.0070349865f,   -0.0070349865f},
        {  -0.0068966684f,    0.0094924497f},
        {  -0.0057972012f,   -0.0029538215f},
        {  -0.0013075407f,    0.0040241966f},
        {  -0.0034874241f,   -0.0005523537f},
        {   0.0000000000f,    0.0030278003f},
        {  -0.0038788694f,    0.0006143526f},
        {   0.0001507411f,    0.0004639333f},
        {  -0.0022148733f,    0.0011285343f}
    },
    {
        {  -0.0015162684f,   -0.0007725774f},     /* Filter 161 */
        {  -0.0008319195f,    0.0025603850f},
        {  -0.0041743131f,   -0.0006611462f},
        {  -0.0000000000f,    0.0013375415f},
        {  -0.0053254484f,    0.0008434682f},
        {   0.0007167720f,    0.0022059974f},
        {  -0.0109672808f,    0.0055881087f},
        {  -0.0001793695f,   -0.0002468810f},
        {  -0.0242736037f,    0.0242736037f},
        {  -0.0360889259f,   -0.0262201394f},
        {  -0.0120313580f,    0.0236128695f},
        {  -0.1655310827f,   -0.0537843091f},
        {   0.0484732318f,   -0.3060479408f},
        {   0.3328177905f,    0.0000000000f},
        {   0.0351705998f,    0.2220584277f},
        {  -0.0653108539f,    0.0212207828f},
        {   0.0145925305f,    0.0286394536f},
        {  -0.0352257635f,    0.0255930153f},
        {  -0.0069075694f,   -0.0069075694f},
        {  -0.0069161628f,    0.0095192815f},
        {  -0.0057392236f,   -0.0029242805f},
        {  -0.0013168843f,    0.0040529530f},
        {  -0.0034568576f,   -0.0005475125f},
        {   0.0000000000f,    0.0030532624f},
        {  -0.0038637337f,    0.0006119553f},
        {   0.0001576893f,    0.0004853179f},
        {  -0.0022118625f,    0.0011270002f}
    },
    {
        {  -0.0015024151f,   -0.0007655187f},     /* Filter 162 */
        {  -0.0008390498f,    0.0025823298f},
        {  -0.0041622804f,   -0.0006592405f},
        {  -0.0000000000f,    0.0013748252f},
        {  -0.0053189108f,    0.0008424327f},
        {   0.0007369976f,    0.0022682453f},
        {  -0.0109790280f,    0.0055940942f},
        {  -0.0000956984f,   -0.0001317175f},
        {  -0.0243966809f,    0.0243966808f},
        {  -0.0359873394f,   -0.0261463325f},
        {  -0.0123108854f,    0.0241614731f},
        {  -0.1663286640f,   -0.0540434590f},
        {   0.0485477870f,   -0.3065186635f},
        {   0.3325592195f,    0.0000000000f},
        {   0.0350472173f,    0.2212794214f},
        {  -0.0646083561f,    0.0209925275f},
        {   0.0147192622f,    0.0288881786f},
        {  -0.0351311327f,    0.0255242620f},
        {  -0.0067804730f,   -0.0067804730f},
        {  -0.0069351713f,    0.0095454444f},
        {  -0.0056811318f,   -0.0028946812f},
        {  -0.0013261120f,    0.0040813532f},
        {  -0.0034261244f,   -0.0005426448f},
        {   0.0000000000f,    0.0030785301f},
        {  -0.0038484382f,    0.0006095327f},
        {   0.0001646126f,    0.0005066256f},
        {  -0.0022087339f,    0.0011254062f}
    },
    {
        {  -0.0014884430f,   -0.0007583996f},     /* Filter 163 */
        {  -0.0008461542f,    0.0026041949f},
        {  -0.0041500234f,   -0.0006572991f},
        {  -0.0000000000f,    0.0014120734f},
        {  -0.0053120041f,    0.0008413388f},
        {   0.0007572560f,    0.0023305944f},
        {  -0.0109901946f,    0.0055997838f},
        {  -0.0000115916f,   -0.0000159544f},
        {  -0.0245193118f,    0.0245193118f},
        {  -0.0358838323f,   -0.0260711303f},
        {  -0.0125914531f,    0.0247121182f},
        {  -0.1671259528f,   -0.0543025138f},
        {   0.0486218279f,   -0.3069861396f},
        {   0.3322968292f,    0.0000000000f},
        {   0.0349236250f,    0.2204990899f},
        {  -0.0639074789f,    0.0207647986f},
        {   0.0148448026f,    0.0291345655f},
        {  -0.0350355011f,    0.0254547815f},
        {  -0.0066537014f,   -0.0066537014f},
        {  -0.0069537018f,    0.0095709494f},
        {  -0.0056229327f,   -0.0028650273f},
        {  -0.0013352233f,    0.0041093948f},
        {  -0.0033952242f,   -0.0005377507f},
        {   0.0000000000f,    0.0031036105f},
        {  -0.0038329794f,    0.0006070843f},
        {   0.0001715097f,    0.0005278527f},
        {  -0.0022054869f,    0.0011237517f}
    },
    {
        {  -0.0014743520f,   -0.0007512199f},     /* Filter 164 */
        {  -0.0008532325f,    0.0026259796f},
        {  -0.0041375369f,   -0.0006553215f},
        {  -0.0000000000f,    0.0014492849f},
        {  -0.0053047256f,    0.0008401860f},
        {   0.0007775460f,    0.0023930406f},
        {  -0.0110007658f,    0.0056051701f},
        {   0.0000729497f,    0.0001004067f},
        {  -0.0246414870f,    0.0246414870f},
        {  -0.0357784018f,   -0.0259945305f},
        {  -0.0128730543f,    0.0252647915f},
        {  -0.1679229530f,   -0.0545614749f},
        {   0.0486953528f,   -0.3074503577f},
        {   0.3320306306f,    0.0000000000f},
        {   0.0347998259f,    0.2197174532f},
        {  -0.0632082284f,    0.0205375984f},
        {   0.0149691501f,    0.0293786112f},
        {  -0.0349388718f,    0.0253845763f},
        {  -0.0065272595f,   -0.0065272595f},
        {  -0.0069717498f,    0.0095957903f},
        {  -0.0055646300f,   -0.0028353206f},
        {  -0.0013442186f,    0.0041370795f},
        {  -0.0033641641f,   -0.0005328312f},
        {   0.0000000000f,    0.0031284972f},
        {  -0.0038173642f,    0.0006046111f},
        {   0.0001783784f,    0.0005489924f},
        {  -0.0022021205f,    0.0011220364f}
    },
    {
        {  -0.0014601426f,   -0.0007439798f},     /* Filter 165 */
        {  -0.0008602826f,    0.0026476775f},
        {  -0.0041248212f,   -0.0006533075f},
        {  -0.0000000000f,    0.0014864566f},
        {  -0.0052970776f,    0.0008389747f},
        {   0.0007978665f,    0.0024555805f},
        {  -0.0110107504f,    0.0056102576f},
        {   0.0001579238f,    0.0002173634f},
        {  -0.0247632008f,    0.0247632008f},
        {  -0.0356710455f,   -0.0259165316f},
        {  -0.0131556897f,    0.0258194949f},
        {  -0.1687196397f,   -0.0548203341f},
        {   0.0487683599f,   -0.3079113063f},
        {   0.3317606309f,    0.0000000000f},
        {   0.0346758233f,    0.2189345318f},
        {  -0.0625106192f,    0.0203109314f},
        {   0.0150923097f,    0.0296203256f},
        {  -0.0348412605f,    0.0253136575f},
        {  -0.0064011503f,   -0.0064011503f},
        {  -0.0069893153f,    0.0096199673f},
        {  -0.0055062248f,   -0.0028055617f},
        {  -0.0013530973f,    0.0041644052f},
        {  -0.0033329427f,   -0.0005278863f},
        {   0.0000000000f,    0.0031531871f},
        {  -0.0038015912f,    0.0006021129f},
        {   0.0001852208f,    0.0005700511f},
        {  -0.0021986382f,    0.0011202621f}
    },
    {
        {  -0.0014458149f,   -0.0007366795f},     /* Filter 166 */
        {  -0.0008673053f,    0.0026692913f},
        {  -0.0041118878f,   -0.0006512591f},
        {  -0.0000000000f,    0.0015235876f},
        {  -0.0052890581f,    0.0008377045f},
        {   0.0008182166f,    0.0025182118f},
        {  -0.0110201366f,    0.0056150401f},
        {   0.0002433249f,    0.0003349079f},
        {  -0.0248844430f,    0.0248844430f},
        {  -0.0355617515f,   -0.0258371249f},
        {  -0.0134393508f,    0.0263762111f},
        {  -0.1695159803f,   -0.0550790809f},
        {   0.0488408446f,   -0.3083689567f},
        {   0.3314868370f,    0.0000000000f},
        {   0.0345516193f,    0.2181503385f},
        {  -0.0618146579f,    0.0200847999f},
        {   0.0152142751f,    0.0298596961f},
        {  -0.0347426640f,    0.0252420229f},
        {  -0.0062753772f,   -0.0062753772f},
        {  -0.0070064077f,    0.0096434929f},
        {  -0.0054477253f,   -0.0027757547f},
        {  -0.0013618591f,    0.0041913714f},
        {  -0.0033015580f,   -0.0005229154f},
        {   0.0000000000f,    0.0031776877f},
        {  -0.0037856664f,    0.0005995907f},
        {   0.0001920348f,    0.0005910222f},
        {  -0.0021950358f,    0.0011184266f}
    },
    {
        {  -0.0014313705f,   -0.0007293197f},     /* Filter 167 */
        {  -0.0008743021f,    0.0026908252f},
        {  -0.0040987206f,   -0.0006491736f},
        {  -0.0000000000f,    0.0015606744f},
        {  -0.0052806669f,    0.0008363755f},
        {   0.0008385950f,    0.0025809300f},
        {  -0.0110289268f,    0.0056195189f},
        {   0.0003291546f,    0.0004530424f},
        {  -0.0250052112f,    0.0250052112f},
        {  -0.0354505202f,   -0.0257563105f},
        {  -0.0137240371f,    0.0269349394f},
        {  -0.1703119776f,   -0.0553377160f},
        {   0.0489128097f,   -0.3088233260f},
        {   0.3312092597f,    0.0000000000f},
        {   0.0344272156f,    0.2173648848f},
        {  -0.0611203609f,    0.0198592091f},
        {   0.0153350520f,    0.0300967342f},
        {  -0.0346430960f,    0.0251696825f},
        {  -0.0061499438f,   -0.0061499438f},
        {  -0.0070230192f,    0.0096663567f},
        {  -0.0053891314f,   -0.0027458996f},
        {  -0.0013705037f,    0.0042179768f},
        {  -0.0032700204f,   -0.0005179204f},
        {   0.0000000000f,    0.0032019911f},
        {  -0.0037695819f,    0.0005970431f},
        {   0.0001988203f,    0.0006119059f},
        {  -0.0021913182f,    0.0011165324f}
    },
    {
        {  -0.0014168097f,   -0.0007219006f},     /* Filter 168 */
        {  -0.0008812689f,    0.0027122668f},
        {  -0.0040853303f,   -0.0006470528f},
        {  -0.0000000000f,    0.0015977154f},
        {  -0.0052719037f,    0.0008349875f},
        {   0.0008590005f,    0.0026437316f},
        {  -0.0110371168f,    0.0056236919f},
        {   0.0004154116f,    0.0005717650f},
        {  -0.0251254954f,    0.0251254954f},
        {  -0.0353373491f,   -0.0256740870f},
        {  -0.0140097447f,    0.0274956721f},
        {  -0.1711076164f,   -0.0555962347f},
        {   0.0489842529f,   -0.3092744009f},
        {   0.3309279035f,    0.0000000000f},
        {   0.0343026178f,    0.2165782048f},
        {  -0.0604277411f,    0.0196341633f},
        {   0.0154546459f,    0.0303314503f},
        {  -0.0345425735f,    0.0250966487f},
        {  -0.0060248575f,   -0.0060248575f},
        {  -0.0070391540f,    0.0096885644f},
        {  -0.0053304459f,   -0.0027159978f},
        {  -0.0013790323f,    0.0042442251f},
        {  -0.0032383252f,   -0.0005129003f},
        {   0.0000000000f,    0.0032260964f},
        {  -0.0037533457f,    0.0005944716f},
        {   0.0002055786f,    0.0006327059f},
        {  -0.0021874838f,    0.0011145787f}
    },
    {
        {  -0.0014021320f,   -0.0007144220f},     /* Filter 169 */
        {  -0.0008882074f,    0.0027336214f},
        {  -0.0040717178f,   -0.0006448967f},
        {  -0.0000000000f,    0.0016347116f},
        {  -0.0052627649f,    0.0008335401f},
        {   0.0008794327f,    0.0027066155f},
        {  -0.0110447047f,    0.0056275581f},
        {   0.0005020904f,    0.0006910682f},
        {  -0.0252452876f,    0.0252452876f},
        {  -0.0352222256f,   -0.0255904448f},
        {  -0.0142964714f,    0.0280584049f},
        {  -0.1719028769f,   -0.0558546306f},
        {   0.0490551686f,   -0.3097221447f},
        {   0.3306427857f,    0.0000000000f},
        {   0.0341778230f,    0.2157902819f},
        {  -0.0597367984f,    0.0194096624f},
        {   0.0155730524f,    0.0305638362f},
        {  -0.0344410900f,    0.0250229166f},
        {  -0.0059001204f,   -0.0059001204f},
        {  -0.0070548131f,    0.0097101173f},
        {  -0.0052716754f,   -0.0026860528f},
        {  -0.0013874429f,    0.0042701101f},
        {  -0.0032064778f,   -0.0005078562f},
        {   0.0000000000f,    0.0032500058f},
        {  -0.0037369580f,    0.0005918760f},
        {   0.0002123080f,    0.0006534169f},
        {  -0.0021835332f,    0.0011125657f}
    },
    {
        {  -0.0013873415f,   -0.0007068858f},     /* Filter 170 */
        {  -0.0008951164f,    0.0027548851f},
        {  -0.0040578765f,   -0.0006427045f},
        {  -0.0000000000f,    0.0016716548f},
        {  -0.0052532571f,    0.0008320342f},
        {   0.0008998894f,    0.0027695749f},
        {  -0.0110516828f,    0.0056311136f},
        {   0.0005891905f,    0.0008109511f},
        {  -0.0253645869f,    0.0253645868f},
        {  -0.0351051571f,   -0.0255053896f},
        {  -0.0145842116f,    0.0286231268f},
        {  -0.1726977302f,   -0.0561128940f},
        {   0.0491255647f,   -0.3101666084f},
        {   0.3303539045f,    0.0000000000f},
        {   0.0340528424f,    0.2150011852f},
        {  -0.0590475577f,    0.0191857145f},
        {   0.0156902759f,    0.0307939004f},
        {  -0.0343386669f,    0.0249485018f},
        {  -0.0057757379f,   -0.0057757379f},
        {  -0.0070700018f,    0.0097310227f},
        {  -0.0052128211f,   -0.0026560650f},
        {  -0.0013957372f,    0.0042956373f},
        {  -0.0031744818f,   -0.0005027885f},
        {   0.0000000000f,    0.0032737161f},
        {  -0.0037204152f,    0.0005892559f},
        {   0.0002190094f,    0.0006740415f},
        {  -0.0021794696f,    0.0011104952f}
    },
    {
        {  -0.0013724328f,   -0.0006992894f},     /* Filter 171 */
        {  -0.0009019959f,    0.0027760579f},
        {  -0.0040438090f,   -0.0006404764f},
        {  -0.0000000000f,    0.0017085512f},
        {  -0.0052433760f,    0.0008304692f},
        {   0.0009203707f,    0.0028326096f},
        {  -0.0110580501f,    0.0056343580f},
        {   0.0006767090f,    0.0009314100f},
        {  -0.0254833823f,    0.0254833823f},
        {  -0.0349861306f,   -0.0254189118f},
        {  -0.0148729578f,    0.0291898232f},
        {  -0.1734921841f,   -0.0563710278f},
        {   0.0491954263f,   -0.3106076970f},
        {   0.3300612587f,    0.0000000000f},
        {   0.0339276705f,    0.2142108808f},
        {  -0.0583600246f,    0.0189623215f},
        {   0.0158063103f,    0.0310216307f},
        {  -0.0342353018f,    0.0248734028f},
        {  -0.0056517100f,   -0.0056517100f},
        {  -0.0070847143f,    0.0097512727f},
        {  -0.0051538904f,   -0.0026260383f},
        {  -0.0014039134f,    0.0043208011f},
        {  -0.0031423371f,   -0.0004976973f},
        {   0.0000000000f,    0.0032972252f},
        {  -0.0037037255f,    0.0005866125f},
        {   0.0002256805f,    0.0006945730f},
        {  -0.0021752882f,    0.0011083647f}
    },
    {
        {  -0.0013574107f,   -0.0006916353f},     /* Filter 172 */
        {  -0.0009088446f,    0.0027971360f},
        {  -0.0040295204f,   -0.0006382133f},
        {  -0.0000000000f,    0.0017453870f},
        {  -0.0052331148f,    0.0008288440f},
        {   0.0009408753f,    0.0028957165f},
        {  -0.0110638054f,    0.0056372904f},
        {   0.0007646444f,    0.0010524428f},
        {  -0.0256016596f,    0.0256016596f},
        {  -0.0348651405f,   -0.0253310073f},
        {  -0.0151627154f,    0.0297585045f},
        {  -0.1742862005f,   -0.0566290193f},
        {   0.0492647580f,   -0.3110454402f},
        {   0.3297648658f,    0.0000000000f},
        {   0.0338023139f,    0.2134194107f},
        {  -0.0576741947f,    0.0187394818f},
        {   0.0159211695f,    0.0312470546f},
        {  -0.0341310065f,    0.0247976278f},
        {  -0.0055280441f,   -0.0055280441f},
        {  -0.0070989590f,    0.0097708788f},
        {  -0.0050948817f,   -0.0025959719f},
        {  -0.0014119724f,    0.0043456043f},
        {  -0.0031100445f,   -0.0004925827f},
        {   0.0000000000f,    0.0033205371f},
        {  -0.0036868820f,    0.0005839447f},
        {   0.0002323231f,    0.0007150169f},
        {  -0.0021709935f,    0.0011061764f}
    },
    {
        {  -0.0013422743f,   -0.0006839229f},     /* Filter 173 */
        {  -0.0009156640f,    0.0028181240f},
        {  -0.0040150098f,   -0.0006359151f},
        {  -0.0000000000f,    0.0017821677f},
        {  -0.0052224822f,    0.0008271599f},
        {   0.0009614017f,    0.0029588901f},
        {  -0.0110689444f,    0.0056399089f},
        {   0.0008529956f,    0.0011740477f},
        {  -0.0257194246f,    0.0257194246f},
        {  -0.0347421838f,   -0.0252416741f},
        {  -0.0154534710f,    0.0303291445f},
        {  -0.1750797643f,   -0.0568868638f},
        {   0.0493335604f,   -0.3114798415f},
        {   0.3294647168f,    0.0000000000f},
        {   0.0336767754f,    0.2126267914f},
        {  -0.0569901065f,    0.0185172081f},
        {   0.0160348403f,    0.0314701461f},
        {  -0.0340257897f,    0.0247211833f},
        {  -0.0054047446f,   -0.0054047446f},
        {  -0.0071127326f,    0.0097898366f},
        {  -0.0050358040f,   -0.0025658703f},
        {  -0.0014199134f,    0.0043700441f},
        {  -0.0030776105f,   -0.0004874456f},
        {   0.0000000000f,    0.0033436471f},
        {  -0.0036698948f,    0.0005812542f},
        {   0.0002389352f,    0.0007353671f},
        {  -0.0021665839f,    0.0011039297f}
    },
    {
        {  -0.0013270241f,   -0.0006761526f},     /* Filter 174 */
        {  -0.0009224524f,    0.0028390167f},
        {  -0.0040002741f,   -0.0006335812f},
        {  -0.0000000000f,    0.0018188896f},
        {  -0.0052114720f,    0.0008254161f},
        {   0.0009819489f,    0.0030221280f},
        {  -0.0110734677f,    0.0056422136f},
        {   0.0009417582f,    0.0012962189f},
        {  -0.0258366582f,    0.0258366582f},
        {  -0.0346172596f,   -0.0251509113f},
        {  -0.0157452306f,    0.0309017550f},
        {  -0.1758728665f,   -0.0571445584f},
        {   0.0494018279f,   -0.3119108658f},
        {   0.3291608469f,    0.0000000000f},
        {   0.0335510562f,    0.2118330321f},
        {  -0.0563077467f,    0.0182954959f},
        {   0.0161473402f,    0.0316909395f},
        {  -0.0339196635f,    0.0246440780f},
        {  -0.0052818148f,   -0.0052818148f},
        {  -0.0071260337f,    0.0098081440f},
        {  -0.0049766550f,   -0.0025357324f},
        {  -0.0014277367f,    0.0043941217f},
        {  -0.0030450357f,   -0.0004822863f},
        {   0.0000000000f,    0.0033665528f},
        {  -0.0036527558f,    0.0005785397f},
        {   0.0002455178f,    0.0007556262f},
        {  -0.0021620629f,    0.0011016261f}
    },
    {
        {  -0.0013116612f,   -0.0006683247f},     /* Filter 175 */
        {  -0.0009292099f,    0.0028598142f},
        {  -0.0039853119f,   -0.0006312114f},
        {  -0.0000000000f,    0.0018555547f},
        {  -0.0052000922f,    0.0008236137f},
        {   0.0010025158f,    0.0030854265f},
        {  -0.0110773713f,    0.0056442026f},
        {   0.0010309301f,    0.0014189535f},
        {  -0.0259533663f,    0.0259533663f},
        {  -0.0344903630f,   -0.0250587156f},
        {  -0.0160379814f,    0.0314763108f},
        {  -0.1766655070f,   -0.0574021029f},
        {   0.0494695653f,   -0.3123385428f},
        {   0.3288532338f,    0.0000000000f},
        {   0.0334251612f,    0.2110381623f},
        {  -0.0556271369f,    0.0180743524f},
        {   0.0162586580f,    0.0319094130f},
        {  -0.0338126301f,    0.0245663138f},
        {  -0.0051592580f,   -0.0051592580f},
        {  -0.0071388691f,    0.0098258104f},
        {  -0.0049174434f,   -0.0025055626f},
        {  -0.0014354426f,    0.0044178382f},
        {  -0.0030123189f,   -0.0004771044f},
        {   0.0000000000f,    0.0033892575f},
        {  -0.0036354734f,    0.0005758024f},
        {   0.0002520699f,    0.0007757912f},
        {  -0.0021574284f,    0.0010992647f}
    },
    {
        {  -0.0012961871f,   -0.0006604403f},     /* Filter 176 */
        {  -0.0009359356f,    0.0028805136f},
        {  -0.0039701300f,   -0.0006288068f},
        {  -0.0000000000f,    0.0018921522f},
        {  -0.0051883299f,    0.0008217507f},
        {   0.0010231017f,    0.0031487834f},
        {  -0.0110806487f,    0.0056458725f},
        {   0.0011205114f,    0.0015422517f},
        {  -0.0260695287f,    0.0260695287f},
        {  -0.0343614823f,   -0.0249650782f},
        {  -0.0163317246f,    0.0320528142f},
        {  -0.1774576372f,   -0.0576594816f},
        {   0.0495367633f,   -0.3127628142f},
        {   0.3285419113f,    0.0000000000f},
        {   0.0332990916f,    0.2102421898f},
        {  -0.0549482856f,    0.0178537803f},
        {   0.0163688011f,    0.0321255811f},
        {  -0.0337047030f,    0.0244879001f},
        {  -0.0050370769f,   -0.0050370769f},
        {  -0.0071512408f,    0.0098428385f},
        {  -0.0048581698f,   -0.0024753611f},
        {  -0.0014430304f,    0.0044411910f},
        {  -0.0029794678f,   -0.0004719013f},
        {   0.0000000000f,    0.0034117569f},
        {  -0.0036180491f,    0.0005730427f},
        {   0.0002585916f,    0.0007958630f},
        {  -0.0021526811f,    0.0010968458f}
    },
    {
        {  -0.0012806020f,   -0.0006524993f},     /* Filter 177 */
        {  -0.0009426290f,    0.0029011137f},
        {  -0.0039547236f,   -0.0006263667f},
        {  -0.0000000000f,    0.0019286856f},
        {  -0.0051761955f,    0.0008198288f},
        {   0.0010437052f,    0.0032121944f},
        {  -0.0110832996f,    0.0056472232f},
        {   0.0012104960f,    0.0016661049f},
        {  -0.0261851487f,    0.0261851487f},
        {  -0.0342306216f,   -0.0248700024f},
        {  -0.0166264567f,    0.0326312586f},
        {  -0.1782492532f,   -0.0579166932f},
        {   0.0496034263f,   -0.3131837077f},
        {   0.3282268613f,    0.0000000000f},
        {   0.0331728498f,    0.2094451305f},
        {  -0.0542712019f,    0.0176337824f},
        {   0.0164777696f,    0.0323394438f},
        {  -0.0335958803f,    0.0244088358f},
        {  -0.0049152798f,   -0.0049152798f},
        {  -0.0071631454f,    0.0098592238f},
        {  -0.0047988370f,   -0.0024451296f},
        {  -0.0014504998f,    0.0044641793f},
        {  -0.0029464795f,   -0.0004666765f},
        {   0.0000000000f,    0.0034340501f},
        {  -0.0036004777f,    0.0005702596f},
        {   0.0002650826f,    0.0008158402f},
        {  -0.0021478235f,    0.0010943707f}
    },
    {
        {  -0.0012649024f,   -0.0006445000f},     /* Filter 178 */
        {  -0.0009492899f,    0.0029216139f},
        {  -0.0039390981f,   -0.0006238918f},
        {  -0.0000000000f,    0.0019651518f},
        {  -0.0051636809f,    0.0008178467f},
        {   0.0010643250f,    0.0032756556f},
        {  -0.0110853211f,    0.0056482532f},
        {   0.0013008835f,    0.0017905126f},
        {  -0.0263002096f,    0.0263002095f},
        {  -0.0340977770f,   -0.0247734851f},
        {  -0.0169221683f,    0.0332116253f},
        {  -0.1790403429f,   -0.0581737338f},
        {   0.0496695465f,   -0.3136011746f},
        {   0.3279080881f,    0.0000000000f},
        {   0.0330464377f,    0.2086469963f},
        {  -0.0535958992f,    0.0174143633f},
        {   0.0165855627f,    0.0325509996f},
        {  -0.0334861824f,    0.0243291356f},
        {  -0.0047938623f,   -0.0047938623f},
        {  -0.0071745880f,    0.0098749731f},
        {  -0.0047394533f,   -0.0024148721f},
        {  -0.0014578511f,    0.0044868044f},
        {  -0.0029133560f,   -0.0004614303f},
        {   0.0000000000f,    0.0034561409f},
        {  -0.0035827641f,    0.0005674541f},
        {   0.0002715416f,    0.0008357192f},
        {  -0.0021428519f,    0.0010918376f}
    },
    {
        {  -0.0012490941f,   -0.0006364452f},     /* Filter 179 */
        {  -0.0009559179f,    0.0029420128f},
        {  -0.0039232480f,   -0.0006213814f},
        {  -0.0000000000f,    0.0020015478f},
        {  -0.0051507929f,    0.0008158054f},
        {   0.0010849601f,    0.0033391637f},
        {  -0.0110867107f,    0.0056489612f},
        {   0.0013916737f,    0.0019154745f},
        {  -0.0264147135f,    0.0264147135f},
        {  -0.0339629379f,   -0.0246755187f},
        {  -0.0172188616f,    0.0337939187f},
        {  -0.1798308921f,   -0.0584305988f},
        {   0.0497351290f,   -0.3140152457f},
        {   0.3275856455f,    0.0000000000f},
        {   0.0329198616f,    0.2078478261f},
        {  -0.0529223907f,    0.0171955271f},
        {   0.0166921866f,    0.0327602608f},
        {  -0.0333756137f,    0.0242488027f},
        {  -0.0046728389f,   -0.0046728389f},
        {  -0.0071855666f,    0.0098900840f},
        {  -0.0046800169f,   -0.0023845877f},
        {  -0.0014650844f,    0.0045090662f},
        {  -0.0028801083f,   -0.0004561643f},
        {   0.0000000000f,    0.0034780238f},
        {  -0.0035649100f,    0.0005646263f},
        {   0.0002779697f,    0.0008555029f},
        {  -0.0021377717f,    0.0010892491f}
    },
    {
        {  -0.0012331777f,   -0.0006283354f},     /* Filter 180 */
        {  -0.0009625120f,    0.0029623072f},
        {  -0.0039071795f,   -0.0006188364f},
        {  -0.0000000000f,    0.0020378694f},
        {  -0.0051375257f,    0.0008137041f},
        {   0.0011056098f,    0.0034027170f},
        {  -0.0110874640f,    0.0056493451f},
        {   0.0014828623f,    0.0020409848f},
        {  -0.0265286487f,    0.0265286486f},
        {  -0.0338261024f,   -0.0245761020f},
        {  -0.0175165288f,    0.0343781233f},
        {  -0.1806208765f,   -0.0586872803f},
        {   0.0498001678f,   -0.3144258846f},
        {   0.3272594964f,    0.0000000000f},
        {   0.0327931228f,    0.2070476286f},
        {  -0.0522506751f,    0.0169772735f},
        {   0.0167976380f,    0.0329672208f},
        {  -0.0332641784f,    0.0241678403f},
        {  -0.0045522045f,   -0.0045522045f},
        {  -0.0071960854f,    0.0099045618f},
        {  -0.0046205348f,   -0.0023542801f},
        {  -0.0014721991f,    0.0045309631f},
        {  -0.0028467280f,   -0.0004508774f},
        {   0.0000000000f,    0.0034997014f},
        {  -0.0035469196f,    0.0005617769f},
        {   0.0002843666f,    0.0008751904f},
        {  -0.0021325818f,    0.0010866047f}
    },
    {
        {  -0.0012171503f,   -0.0006201690f},     /* Filter 181 */
        {  -0.0009690729f,    0.0029824996f},
        {  -0.0038908892f,   -0.0006162563f},
        {  -0.0000000000f,    0.0020741216f},
        {  -0.0051238819f,    0.0008115432f},
        {   0.0011262723f,    0.0034663098f},
        {  -0.0110875784f,    0.0056494033f},
        {   0.0015744429f,    0.0021670347f},
        {  -0.0266420053f,    0.0266420053f},
        {  -0.0336872691f,   -0.0244752336f},
        {  -0.0178151678f,    0.0349642354f},
        {  -0.1814102747f,   -0.0589437714f},
        {   0.0498646641f,   -0.3148330983f},
        {   0.3269296554f,    0.0000000000f},
        {   0.0326662218f,    0.2062464072f},
        {  -0.0515807741f,    0.0167596094f},
        {   0.0169019206f,    0.0331718869f},
        {  -0.0331518885f,    0.0240862569f},
        {  -0.0044319669f,   -0.0044319669f},
        {  -0.0072061462f,    0.0099184093f},
        {  -0.0045610084f,   -0.0023239498f},
        {  -0.0014791959f,    0.0045524968f},
        {  -0.0028132202f,   -0.0004455703f},
        {   0.0000000000f,    0.0035211710f},
        {  -0.0035287880f,    0.0005589051f},
        {   0.0002907313f,    0.0008947789f},
        {  -0.0021272804f,    0.0010839035f}
    },
    {
        {  -0.0012010169f,   -0.0006119487f},     /* Filter 182 */
        {  -0.0009756000f,    0.0030025882f},
        {  -0.0038743798f,   -0.0006136415f},
        {  -0.0000000000f,    0.0021102948f},
        {  -0.0051098607f,    0.0008093224f},
        {   0.0011469467f,    0.0035299389f},
        {  -0.0110870524f,    0.0056491353f},
        {   0.0016664209f,    0.0022936316f},
        {  -0.0267547838f,    0.0267547838f},
        {  -0.0335464345f,   -0.0243729114f},
        {  -0.0181147701f,    0.0355522381f},
        {  -0.1821990707f,   -0.0592000667f},
        {   0.0499286139f,   -0.3152368615f},
        {   0.3265961402f,    0.0000000000f},
        {   0.0325391632f,    0.2054441908f},
        {  -0.0509126991f,    0.0165425387f},
        {   0.0170050359f,    0.0333742622f},
        {  -0.0330387505f,    0.0240040573f},
        {  -0.0043121270f,   -0.0043121270f},
        {  -0.0072157478f,    0.0099316248f},
        {  -0.0045014440f,   -0.0022936003f},
        {  -0.0014860735f,    0.0045736640f},
        {  -0.0027795897f,   -0.0004402438f},
        {   0.0000000000f,    0.0035424291f},
        {  -0.0035105169f,    0.0005560113f},
        {   0.0002970631f,    0.0009142662f},
        {  -0.0021218707f,    0.0010811471f}
    },
    {
        {  -0.0011847721f,   -0.0006036715f},     /* Filter 183 */
        {  -0.0009820912f,    0.0030225659f},
        {  -0.0038576503f,   -0.0006109918f},
        {  -0.0000000000f,    0.0021463869f},
        {  -0.0050954597f,    0.0008070415f},
        {   0.0011676322f,    0.0035936024f},
        {  -0.0110858859f,    0.0056485410f},
        {   0.0017587860f,    0.0024207612f},
        {  -0.0268669691f,    0.0268669691f},
        {  -0.0334035882f,   -0.0242691274f},
        {  -0.0184153382f,    0.0361421361f},
        {  -0.1829872717f,   -0.0594561687f},
        {   0.0499920157f,   -0.3156371650f},
        {   0.3262589677f,    0.0000000000f},
        {   0.0324119487f,    0.2046409903f},
        {  -0.0502464419f,    0.0163260586f},
        {   0.0171069856f,    0.0335743496f},
        {  -0.0329247776f,    0.0239212511f},
        {  -0.0041926924f,   -0.0041926924f},
        {  -0.0072248932f,    0.0099442124f},
        {  -0.0044418429f,   -0.0022632320f},
        {  -0.0014928333f,    0.0045944683f},
        {  -0.0027458380f,   -0.0004348980f},
        {   0.0000000000f,    0.0035634797f},
        {  -0.0034921137f,    0.0005530965f},
        {   0.0003033628f,    0.0009336547f},
        {  -0.0021163512f,    0.0010783348f}
    },
    {
        {  -0.0011684229f,   -0.0005953412f},     /* Filter 184 */
        {  -0.0009885487f,    0.0030424399f},
        {  -0.0038407034f,   -0.0006083077f},
        {  -0.0000000000f,    0.0021824000f},
        {  -0.0050806797f,    0.0008047006f},
        {   0.0011883268f,    0.0036572938f},
        {  -0.0110840763f,    0.0056476190f},
        {   0.0018515428f,    0.0025484301f},
        {  -0.0269785595f,    0.0269785594f},
        {  -0.0332587359f,   -0.0241638860f},
        {  -0.0187168673f,    0.0367339203f},
        {  -0.1837748388f,   -0.0597120648f},
        {   0.0500548715f,   -0.3160340207f},
        {   0.3259181294f,    0.0000000000f},
        {   0.0322845815f,    0.2038368254f},
        {  -0.0495820369f,    0.0161101804f},
        {   0.0172077747f,    0.0337721594f},
        {  -0.0328099690f,    0.0238378378f},
        {  -0.0040736649f,   -0.0040736649f},
        {  -0.0072335836f,    0.0099561737f},
        {  -0.0043822054f,   -0.0022328452f},
        {  -0.0014994741f,    0.0046149068f},
        {  -0.0027119655f,   -0.0004295331f},
        {   0.0000000000f,    0.0035843186f},
        {  -0.0034735715f,    0.0005501597f},
        {   0.0003096295f,    0.0009529418f},
        {  -0.0021107264f,    0.0010754688f}
    },
    {
        {  -0.0011519648f,   -0.0005869554f},     /* Filter 185 */
        {  -0.0009949709f,    0.0030622057f},
        {  -0.0038235324f,   -0.0006055880f},
        {  -0.0000000000f,    0.0022183301f},
        {  -0.0050655213f,    0.0008022997f},
        {   0.0012090309f,    0.0037210144f},
        {  -0.0110816114f,    0.0056463630f},
        {   0.0019446819f,    0.0026766250f},
        {  -0.0270895417f,    0.0270895417f},
        {  -0.0331118630f,   -0.0240571767f},
        {  -0.0190193487f,    0.0373275735f},
        {  -0.1845617592f,   -0.0599677508f},
        {   0.0501171763f,   -0.3164273977f},
        {   0.3255736244f,    0.0000000000f},
        {   0.0321570632f,    0.2030317064f},
        {  -0.0489194701f,    0.0158948994f},
        {   0.0173073982f,    0.0339676816f},
        {  -0.0326943386f,    0.0237538274f},
        {  -0.0039550473f,   -0.0039550473f},
        {  -0.0072418204f,    0.0099675107f},
        {  -0.0043225420f,   -0.0022024452f},
        {  -0.0015059960f,    0.0046349792f},
        {  -0.0026779756f,   -0.0004241497f},
        {   0.0000000000f,    0.0036049447f},
        {  -0.0034549005f,    0.0005472025f},
        {   0.0003158634f,    0.0009721276f},
        {  -0.0021049923f,    0.0010725471f}
    },
    {
        {  -0.0011354014f,   -0.0005785159f},     /* Filter 186 */
        {  -0.0010013566f,    0.0030818588f},
        {  -0.0038061486f,   -0.0006028347f},
        {  -0.0000000000f,    0.0022541739f},
        {  -0.0050499875f,    0.0007998394f},
        {   0.0012297420f,    0.0037847567f},
        {  -0.0110785003f,    0.0056447778f},
        {   0.0020382052f,    0.0028053488f},
        {  -0.0271999184f,    0.0271999184f},
        {  -0.0329629727f,   -0.0239490016f},
        {  -0.0193227779f,    0.0379230869f},
        {  -0.1853480191f,   -0.0602232221f},
        {   0.0501789307f,   -0.3168172996f},
        {   0.3252254876f,    0.0000000000f},
        {   0.0320294011f,    0.2022256796f},
        {  -0.0482587741f,    0.0156802262f},
        {   0.0174058626f,    0.0341609287f},
        {  -0.0325778977f,    0.0236692282f},
        {  -0.0038368434f,   -0.0038368434f},
        {  -0.0072496072f,    0.0099782283f},
        {  -0.0042628518f,   -0.0021720315f},
        {  -0.0015124002f,    0.0046546893f},
        {  -0.0026438710f,   -0.0004187480f},
        {   0.0000000000f,    0.0036253614f},
        {  -0.0034360946f,    0.0005442239f},
        {   0.0003220639f,    0.0009912107f},
        {  -0.0020991518f,    0.0010695713f}
    },
    {
        {  -0.0011187340f,   -0.0005700234f},     /* Filter 187 */
        {  -0.0010077057f,    0.0031013993f},
        {  -0.0037885462f,   -0.0006000468f},
        {  -0.0000000000f,    0.0022899307f},
        {  -0.0050340712f,    0.0007973185f},
        {   0.0012504589f,    0.0038485167f},
        {  -0.0110747363f,    0.0056428600f},
        {   0.0021321098f,    0.0029345974f},
        {  -0.0273096732f,    0.0273096732f},
        {  -0.0328120641f,   -0.0238393600f},
        {  -0.0196271574f,    0.0385204653f},
        {  -0.1861335945f,   -0.0604784710f},
        {   0.0502401324f,   -0.3172037117f},
        {   0.3248737054f,    0.0000000000f},
        {   0.0319015944f,    0.2014187397f},
        {  -0.0475999433f,    0.0154661591f},
        {   0.0175031683f,    0.0343519019f},
        {  -0.0324606458f,    0.0235840397f},
        {  -0.0037190588f,   -0.0037190588f},
        {  -0.0072569405f,    0.0099883217f},
        {  -0.0042031392f,   -0.0021416064f},
        {  -0.0015186844f,    0.0046740300f},
        {  -0.0026096525f,   -0.0004133284f},
        {   0.0000000000f,    0.0036455684f},
        {  -0.0034171601f,    0.0005412250f},
        {   0.0003282310f,    0.0010101913f},
        {  -0.0020932061f,    0.0010665418f}
    },
    {
        {  -0.0011019602f,   -0.0005614767f},     /* Filter 188 */
        {  -0.0010140199f,    0.0031208324f},
        {  -0.0037707253f,   -0.0005972242f},
        {  -0.0000000000f,    0.0023255964f},
        {  -0.0050177778f,    0.0007947379f},
        {   0.0012711815f,    0.0039122945f},
        {  -0.0110703162f,    0.0056406079f},
        {   0.0022263916f,    0.0030643652f},
        {  -0.0274188054f,    0.0274188054f},
        {  -0.0326591229f,   -0.0237282417f},
        {  -0.0199324784f,    0.0391196915f},
        {  -0.1869184792f,   -0.0607334955f},
        {   0.0503007794f,   -0.3175866223f},
        {   0.3245182896f,    0.0000000000f},
        {   0.0317736429f,    0.2006108859f},
        {  -0.0469429903f,    0.0152527022f},
        {   0.0175993179f,    0.0345406062f},
        {  -0.0323425986f,    0.0234982733f},
        {  -0.0036016954f,   -0.0036016954f},
        {  -0.0072638274f,    0.0099978007f},
        {  -0.0041434070f,   -0.0021111713f},
        {  -0.0015248506f,    0.0046930077f},
        {  -0.0025753233f,   -0.0004078911f},
        {   0.0000000000f,    0.0036655608f},
        {  -0.0033980896f,    0.0005382045f},
        {   0.0003343644f,    0.0010290677f},
        {  -0.0020871540f,    0.0010634581f}
    },
    {
        {  -0.0010850831f,   -0.0005528774f},     /* Filter 189 */
        {  -0.0010202946f,    0.0031401438f},
        {  -0.0037526894f,   -0.0005943676f},
        {  -0.0000000000f,    0.0023611717f},
        {  -0.0050011043f,    0.0007920971f},
        {   0.0012919081f,    0.0039760844f},
        {  -0.0110652351f,    0.0056380189f},
        {   0.0023210497f,    0.0031946509f},
        {  -0.0275273031f,    0.0275273031f},
        {  -0.0325041534f,   -0.0236156498f},
        {  -0.0202387338f,    0.0397207515f},
        {  -0.1877026542f,   -0.0609882894f},
        {   0.0503608735f,   -0.3179660415f},
        {   0.3241592762f,    0.0000000000f},
        {   0.0316455557f,    0.1998021754f},
        {  -0.0462879351f,    0.0150398618f},
        {   0.0176943134f,    0.0347270454f},
        {  -0.0322237637f,    0.0234119347f},
        {  -0.0034847552f,   -0.0034847552f},
        {  -0.0072702646f,    0.0100066607f},
        {  -0.0040836583f,   -0.0020807278f},
        {  -0.0015308989f,    0.0047116222f},
        {  -0.0025408856f,   -0.0004024367f},
        {   0.0000000000f,    0.0036853371f},
        {  -0.0033788979f,    0.0005351649f},
        {   0.0003404626f,    0.0010478361f},
        {  -0.0020809967f,    0.0010603208f}
    },
    {
        {  -0.0010681046f,   -0.0005442265f},     /* Filter 190 */
        {  -0.0010265333f,    0.0031593446f},
        {  -0.0037344368f,   -0.0005914767f},
        {  -0.0000000000f,    0.0023966537f},
        {  -0.0049840526f,    0.0007893964f},
        {   0.0013126376f,    0.0040398833f},
        {  -0.0110594921f,    0.0056350927f},
        {   0.0024160790f,    0.0033254474f},
        {  -0.0276351622f,    0.0276351621f},
        {  -0.0323471495f,   -0.0235015798f},
        {  -0.0205459255f,    0.0403236493f},
        {  -0.1884861004f,   -0.0612428465f},
        {   0.0504204080f,   -0.3183419274f},
        {   0.3237966197f,    0.0000000000f},
        {   0.0315173303f,    0.1989925921f},
        {  -0.0456347697f,    0.0148276355f},
        {   0.0177881547f,    0.0349112193f},
        {  -0.0321041418f,    0.0233250244f},
        {  -0.0033682442f,   -0.0033682442f},
        {  -0.0072762570f,    0.0100149086f},
        {  -0.0040238979f,   -0.0020502784f},
        {  -0.0015368271f,    0.0047298674f},
        {  -0.0025063405f,   -0.0003969653f},
        {   0.0000000000f,    0.0037048962f},
        {  -0.0033595723f,    0.0005321040f},
        {   0.0003465273f,    0.0010665015f},
        {  -0.0020747359f,    0.0010571307f}
    },
    {
        {  -0.0010510198f,   -0.0005355213f},     /* Filter 191 */
        {  -0.0010327352f,    0.0031784322f},
        {  -0.0037159717f,   -0.0005885521f},
        {  -0.0000000000f,    0.0024320363f},
        {  -0.0049666219f,    0.0007866356f},
        {   0.0013333687f,    0.0041036870f},
        {  -0.0110530868f,    0.0056318290f},
        {   0.0025114767f,    0.0034567511f},
        {  -0.0277423727f,    0.0277423726f},
        {  -0.0321881057f,   -0.0233860277f},
        {  -0.0208540454f,    0.0409283686f},
        {  -0.1892688035f,   -0.0614971622f},
        {   0.0504793852f,   -0.3187142949f},
        {   0.3234303845f,    0.0000000000f},
        {   0.0313889711f,    0.1981821640f},
        {  -0.0449835104f,    0.0146160285f},
        {   0.0178808444f,    0.0350931330f},
        {  -0.0319837501f,    0.0232375547f},
        {  -0.0032521646f,   -0.0032521646f},
        {  -0.0072818054f,    0.0100225453f},
        {  -0.0039641299f,   -0.0020198251f},
        {  -0.0015426375f,    0.0047477499f},
        {  -0.0024716928f,   -0.0003914777f},
        {   0.0000000000f,    0.0037242426f},
        {  -0.0033401247f,    0.0005290238f},
        {   0.0003525575f,    0.0010850603f},
        {  -0.0020683708f,    0.0010538876f}
    }
};
