{- This module was generated from data in the Kate syntax
   highlighting file matlab.xml, version 1.30, by  -}

module Text.Highlighting.Kate.Syntax.Matlab
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Data.Map (fromList)
import Control.Monad.State
import Data.Char (isSpace)
import Data.Maybe (fromMaybe)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Matlab"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.m;*.M"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpressionInternal pEndLine

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "Matlab" }
  context <- currentContext <|> (pushContext "_normal" >> currentContext)
  result <- parseRules context
  optional $ eof >> pEndLine
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

startingState = SyntaxState {synStContexts = fromList [("Matlab",["_normal"])], synStLanguage = "Matlab", synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  case context of
    "_normal" -> (popContext) >> pEndLine
    "_adjoint" -> (popContext) >> pEndLine
    _ -> return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe NormalTok $ lookup context defaultAttributes))

list_KeywordsList = Set.fromList $ words $ "break case catch classdef continue else elseif end for function global if otherwise parfor persistent return spmd switch try while methods properties events"

regex_'5ba'2dzA'2dZ'5d'5cw'2a'28'3f'3d'27'29 = compileRegex "[a-zA-Z]\\w*(?=')"
regex_'28'5cd'2b'28'5c'2e'5cd'2b'29'3f'7c'5c'2e'5cd'2b'29'28'5beE'5d'5b'2b'2d'5d'3f'5cd'2b'29'3f'5bij'5d'3f'28'3f'3d'27'29 = compileRegex "(\\d+(\\.\\d+)?|\\.\\d+)([eE][+-]?\\d+)?[ij]?(?=')"
regex_'5b'5c'29'5c'5d'7d'5d'28'3f'3d'27'29 = compileRegex "[\\)\\]}](?=')"
regex_'5c'2e'27'28'3f'3d'27'29 = compileRegex "\\.'(?=')"
regex_'27'5b'5e'27'5d'2a'28'27'27'5b'5e'27'5d'2a'29'2a'27'28'3f'3d'5b'5e'27'5d'7c'24'29 = compileRegex "'[^']*(''[^']*)*'(?=[^']|$)"
regex_'27'5b'5e'27'5d'2a'28'27'27'5b'5e'27'5d'2a'29'2a = compileRegex "'[^']*(''[^']*)*"
regex_'25'2e'2a'24 = compileRegex "%.*$"
regex_'21'2e'2a'24 = compileRegex "!.*$"
regex_'5ba'2dzA'2dZ'5d'5cw'2a = compileRegex "[a-zA-Z]\\w*"
regex_'28'5cd'2b'28'5c'2e'5cd'2b'29'3f'7c'5c'2e'5cd'2b'29'28'5beE'5d'5b'2b'2d'5d'3f'5cd'2b'29'3f'5bij'5d'3f = compileRegex "(\\d+(\\.\\d+)?|\\.\\d+)([eE][+-]?\\d+)?[ij]?"
regex_'27'2b = compileRegex "'+"

defaultAttributes = [("_normal",NormalTok),("_adjoint",NormalTok)]

parseRules "_normal" =
  (((pRegExpr regex_'5ba'2dzA'2dZ'5d'5cw'2a'28'3f'3d'27'29 >>= withAttribute NormalTok) >>~ pushContext "_adjoint")
   <|>
   ((pRegExpr regex_'28'5cd'2b'28'5c'2e'5cd'2b'29'3f'7c'5c'2e'5cd'2b'29'28'5beE'5d'5b'2b'2d'5d'3f'5cd'2b'29'3f'5bij'5d'3f'28'3f'3d'27'29 >>= withAttribute FloatTok) >>~ pushContext "_adjoint")
   <|>
   ((pRegExpr regex_'5b'5c'29'5c'5d'7d'5d'28'3f'3d'27'29 >>= withAttribute NormalTok) >>~ pushContext "_adjoint")
   <|>
   ((pRegExpr regex_'5c'2e'27'28'3f'3d'27'29 >>= withAttribute NormalTok) >>~ pushContext "_adjoint")
   <|>
   ((pRegExpr regex_'27'5b'5e'27'5d'2a'28'27'27'5b'5e'27'5d'2a'29'2a'27'28'3f'3d'5b'5e'27'5d'7c'24'29 >>= withAttribute StringTok))
   <|>
   ((pRegExpr regex_'27'5b'5e'27'5d'2a'28'27'27'5b'5e'27'5d'2a'29'2a >>= withAttribute CharTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_KeywordsList >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'25'2e'2a'24 >>= withAttribute CommentTok))
   <|>
   ((pRegExpr regex_'21'2e'2a'24 >>= withAttribute BaseNTok))
   <|>
   ((pRegExpr regex_'5ba'2dzA'2dZ'5d'5cw'2a >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'28'5cd'2b'28'5c'2e'5cd'2b'29'3f'7c'5c'2e'5cd'2b'29'28'5beE'5d'5b'2b'2d'5d'3f'5cd'2b'29'3f'5bij'5d'3f >>= withAttribute FloatTok))
   <|>
   ((pAnyChar "()[]{}" >>= withAttribute NormalTok))
   <|>
   ((pString False "..." >>= withAttribute NormalTok))
   <|>
   ((pString False "==" >>= withAttribute NormalTok))
   <|>
   ((pString False "~=" >>= withAttribute NormalTok))
   <|>
   ((pString False "<=" >>= withAttribute NormalTok))
   <|>
   ((pString False ">=" >>= withAttribute NormalTok))
   <|>
   ((pString False "&&" >>= withAttribute NormalTok))
   <|>
   ((pString False "||" >>= withAttribute NormalTok))
   <|>
   ((pString False ".*" >>= withAttribute NormalTok))
   <|>
   ((pString False ".^" >>= withAttribute NormalTok))
   <|>
   ((pString False "./" >>= withAttribute NormalTok))
   <|>
   ((pString False ".'" >>= withAttribute NormalTok))
   <|>
   ((pAnyChar "*+-/\\&|<>~^=,;:@" >>= withAttribute NormalTok)))

parseRules "_adjoint" =
  ((pRegExpr regex_'27'2b >>= withAttribute NormalTok) >>~ (popContext))

parseRules "" = parseRules "_normal"

parseRules x = fail $ "Unknown context" ++ x
