{- This module was generated from data in the Kate syntax
   highlighting file djangotemplate.xml, version 1.3, by Matthew Marshall (matthew@matthewmarshall.org) -}

module Text.Highlighting.Kate.Syntax.Djangotemplate
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert
import qualified Text.Highlighting.Kate.Syntax.Css
import qualified Text.Highlighting.Kate.Syntax.Javascript
import Text.ParserCombinators.Parsec hiding (State)
import Data.Map (fromList)
import Control.Monad.State
import Data.Char (isSpace)
import Data.Maybe (fromMaybe)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Django HTML Template"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.htm;*.html"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpressionInternal pEndLine

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "Django HTML Template" }
  context <- currentContext <|> (pushContext "Start" >> currentContext)
  result <- parseRules context
  optional $ eof >> pEndLine
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

startingState = SyntaxState {synStContexts = fromList [("Django HTML Template",["Start"])], synStLanguage = "Django HTML Template", synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  case context of
    "Start" -> return ()
    "In Block" -> return ()
    "FindTemplate" -> return ()
    "Template Comment" -> return ()
    "Template Var" -> return ()
    "Template Filter" -> return ()
    "Template Tag" -> return ()
    "Found Block Tag" -> return ()
    "In Block Tag" -> return ()
    "Non Matching Tag" -> return ()
    "In Template Tag" -> return ()
    "Single A-string" -> return ()
    "Single Q-string" -> return ()
    "FindHTML" -> return ()
    "FindEntityRefs" -> return ()
    "FindPEntityRefs" -> return ()
    "FindAttributes" -> return ()
    "FindDTDRules" -> return ()
    "Comment" -> return ()
    "CDATA" -> return ()
    "PI" -> return ()
    "Doctype" -> return ()
    "Doctype Internal Subset" -> return ()
    "Doctype Markupdecl" -> return ()
    "Doctype Markupdecl DQ" -> return ()
    "Doctype Markupdecl SQ" -> return ()
    "El Open" -> return ()
    "El Close" -> return ()
    "El Close 2" -> return ()
    "El Close 3" -> return ()
    "CSS" -> return ()
    "CSS content" -> return ()
    "JS" -> return ()
    "JS content" -> return ()
    "JS comment close" -> (popContext) >> pEndLine
    "Value" -> return ()
    "Value NQ" -> (popContext >> popContext) >> pEndLine
    "Value DQ" -> return ()
    "Value SQ" -> return ()
    _ -> return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe NormalTok $ lookup context defaultAttributes))

list_blocktags = Set.fromList $ words $ "for block if ifequal ifnotequal ifchanged blocktrans spaceless autoescape"
list_endblocktags = Set.fromList $ words $ "endfor endblock endif endifequal endifnotequal endifchanged endblocktrans endspaceless endautoescape"

regex_'5c'7b'25'5cs'2aend'5ba'2dz'5d'2b'5cs'2a'25'5c'7d = compileRegex "\\{%\\s*end[a-z]+\\s*%\\}"
regex_'5c'7b'25'5cs'2acomment'5cs'2a'25'5c'7d = compileRegex "\\{%\\s*comment\\s*%\\}"
regex_'5c'7b'25'5cs'2aendcomment'5cs'2a'25'5c'7d = compileRegex "\\{%\\s*endcomment\\s*%\\}"
regex_'28'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'29 = compileRegex "([A-Za-z_:][\\w.:_-]*)"
regex_'3c'21DOCTYPE'5cs'2b = compileRegex "<!DOCTYPE\\s+"
regex_'3c'5c'3f'5b'5cw'3a'2d'5d'2a = compileRegex "<\\?[\\w:-]*"
regex_'3cstyle'5cb = compileRegex "<style\\b"
regex_'3cscript'5cb = compileRegex "<script\\b"
regex_'3cpre'5cb = compileRegex "<pre\\b"
regex_'3cdiv'5cb = compileRegex "<div\\b"
regex_'3ctable'5cb = compileRegex "<table\\b"
regex_'3c'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a = compileRegex "<[A-Za-z_:][\\w.:_-]*"
regex_'3c'2fpre'5cb = compileRegex "</pre\\b"
regex_'3c'2fdiv'5cb = compileRegex "</div\\b"
regex_'3c'2ftable'5cb = compileRegex "</table\\b"
regex_'3c'2f'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a = compileRegex "</[A-Za-z_:][\\w.:_-]*"
regex_'26'28'23'5b0'2d9'5d'2b'7c'23'5bxX'5d'5b0'2d9A'2dFa'2df'5d'2b'7c'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'29'3b = compileRegex "&(#[0-9]+|#[xX][0-9A-Fa-f]+|[A-Za-z_:][\\w.:_-]*);"
regex_'25'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'3b = compileRegex "%[A-Za-z_:][\\w.:_-]*;"
regex_'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a = compileRegex "[A-Za-z_:][\\w.:_-]*"
regex_'5cs'2b'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a = compileRegex "\\s+[A-Za-z_:][\\w.:_-]*"
regex_'3c'21'28ELEMENT'7cENTITY'7cATTLIST'7cNOTATION'29'5cb = compileRegex "<!(ELEMENT|ENTITY|ATTLIST|NOTATION)\\b"
regex_'2d'28'2d'28'3f'21'2d'3e'29'29'2b = compileRegex "-(-(?!->))+"
regex_'5cS = compileRegex "\\S"
regex_'3c'2fstyle'5cb = compileRegex "</style\\b"
regex_'3c'2fscript'5cb = compileRegex "</script\\b"
regex_'2f'2f'28'3f'3d'2e'2a'3c'2fscript'5cb'29 = compileRegex "//(?=.*</script\\b)"
regex_'2f'28'3f'21'3e'29 = compileRegex "/(?!>)"
regex_'5b'5e'2f'3e'3c'22'27'5cs'5d = compileRegex "[^/><\"'\\s]"

defaultAttributes = [("Start",NormalTok),("In Block",NormalTok),("FindTemplate",NormalTok),("Template Comment",CommentTok),("Template Var",FunctionTok),("Template Filter",OtherTok),("Template Tag",FunctionTok),("Found Block Tag",FunctionTok),("In Block Tag",FunctionTok),("Non Matching Tag",FunctionTok),("In Template Tag",FunctionTok),("Single A-string",StringTok),("Single Q-string",StringTok),("FindHTML",NormalTok),("FindEntityRefs",NormalTok),("FindPEntityRefs",NormalTok),("FindAttributes",NormalTok),("FindDTDRules",NormalTok),("Comment",CommentTok),("CDATA",NormalTok),("PI",NormalTok),("Doctype",NormalTok),("Doctype Internal Subset",NormalTok),("Doctype Markupdecl",NormalTok),("Doctype Markupdecl DQ",StringTok),("Doctype Markupdecl SQ",StringTok),("El Open",NormalTok),("El Close",NormalTok),("El Close 2",NormalTok),("El Close 3",NormalTok),("CSS",NormalTok),("CSS content",NormalTok),("JS",NormalTok),("JS content",NormalTok),("JS comment close",CommentTok),("Value",NormalTok),("Value NQ",NormalTok),("Value DQ",StringTok),("Value SQ",StringTok)]

parseRules "Start" =
  (((pRegExpr regex_'5c'7b'25'5cs'2aend'5ba'2dz'5d'2b'5cs'2a'25'5c'7d >>= withAttribute ErrorTok))
   <|>
   ((parseRules "FindTemplate"))
   <|>
   ((parseRules "FindHTML")))

parseRules "In Block" =
  (((lookAhead (pRegExpr regex_'5c'7b'25'5cs'2aend'5ba'2dz'5d'2b'5cs'2a'25'5c'7d) >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((parseRules "FindTemplate"))
   <|>
   ((parseRules "FindHTML")))

parseRules "FindTemplate" =
  (((pRegExpr regex_'5c'7b'25'5cs'2acomment'5cs'2a'25'5c'7d >>= withAttribute CommentTok) >>~ pushContext "Template Comment")
   <|>
   ((pDetect2Chars False '{' '{' >>= withAttribute FunctionTok) >>~ pushContext "Template Var")
   <|>
   ((pDetect2Chars False '{' '%' >>= withAttribute FunctionTok) >>~ pushContext "Template Tag"))

parseRules "Template Comment" =
  ((pRegExpr regex_'5c'7b'25'5cs'2aendcomment'5cs'2a'25'5c'7d >>= withAttribute CommentTok) >>~ (popContext))

parseRules "Template Var" =
  (((pDetect2Chars False '}' '}' >>= withAttribute FunctionTok) >>~ (popContext))
   <|>
   ((pDetectChar False '|' >>= withAttribute OtherTok) >>~ pushContext "Template Filter")
   <|>
   ((pDetect2Chars False '{' '{' >>= withAttribute ErrorTok))
   <|>
   ((pDetect2Chars False '{' '%' >>= withAttribute ErrorTok))
   <|>
   ((pDetect2Chars False '%' '}' >>= withAttribute ErrorTok)))

parseRules "Template Filter" =
  (((pDetect2Chars False '}' '}' >>= withAttribute FunctionTok) >>~ (popContext >> popContext))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext "Single A-string")
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext "Single Q-string")
   <|>
   ((pDetect2Chars False '{' '{' >>= withAttribute ErrorTok))
   <|>
   ((pDetect2Chars False '{' '%' >>= withAttribute ErrorTok))
   <|>
   ((pDetect2Chars False '%' '}' >>= withAttribute ErrorTok)))

parseRules "Template Tag" =
  (((lookAhead (pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_blocktags) >> pushContext "Found Block Tag" >> currentContext >>= parseRules))
   <|>
   ((pDetectIdentifier >>= withAttribute FunctionTok) >>~ pushContext "In Template Tag"))

parseRules "Found Block Tag" =
  ((pRegExpr regex_'28'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'29 >>= withAttribute FunctionTok) >>~ pushContext "In Block Tag")

parseRules "In Block Tag" =
  (((pRegExprDynamic "\\{%\\s*end%1\\s*%\\}" >>= withAttribute FunctionTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((lookAhead (pRegExpr regex_'5c'7b'25'5cs'2aend'5ba'2dz'5d'2b'5cs'2a'25'5c'7d) >> pushContext "Non Matching Tag" >> currentContext >>= parseRules))
   <|>
   ((pDetect2Chars False '%' '}' >>= withAttribute FunctionTok) >>~ pushContext "In Block")
   <|>
   ((parseRules "In Template Tag")))

parseRules "Non Matching Tag" =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_endblocktags >>= withAttribute ErrorTok) >>~ (popContext))
   <|>
   ((pDetectIdentifier >>= withAttribute FunctionTok) >>~ (popContext)))

parseRules "In Template Tag" =
  (((pDetect2Chars False '%' '}' >>= withAttribute FunctionTok) >>~ (popContext >> popContext))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext "Single A-string")
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext "Single Q-string")
   <|>
   ((pDetect2Chars False '{' '{' >>= withAttribute ErrorTok))
   <|>
   ((pDetect2Chars False '{' '%' >>= withAttribute ErrorTok))
   <|>
   ((pDetect2Chars False '}' '}' >>= withAttribute ErrorTok)))

parseRules "Single A-string" =
  (((pHlCStringChar >>= withAttribute StringTok))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext)))

parseRules "Single Q-string" =
  (((pHlCStringChar >>= withAttribute StringTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext)))

parseRules "FindHTML" =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pDetectIdentifier >>= withAttribute NormalTok))
   <|>
   ((pString False "<!--" >>= withAttribute CommentTok) >>~ pushContext "Comment")
   <|>
   ((pString False "<![CDATA[" >>= withAttribute BaseNTok) >>~ pushContext "CDATA")
   <|>
   ((pRegExpr regex_'3c'21DOCTYPE'5cs'2b >>= withAttribute DataTypeTok) >>~ pushContext "Doctype")
   <|>
   ((pRegExpr regex_'3c'5c'3f'5b'5cw'3a'2d'5d'2a >>= withAttribute KeywordTok) >>~ pushContext "PI")
   <|>
   ((pRegExpr regex_'3cstyle'5cb >>= withAttribute KeywordTok) >>~ pushContext "CSS")
   <|>
   ((pRegExpr regex_'3cscript'5cb >>= withAttribute KeywordTok) >>~ pushContext "JS")
   <|>
   ((pRegExpr regex_'3cpre'5cb >>= withAttribute KeywordTok) >>~ pushContext "El Open")
   <|>
   ((pRegExpr regex_'3cdiv'5cb >>= withAttribute KeywordTok) >>~ pushContext "El Open")
   <|>
   ((pRegExpr regex_'3ctable'5cb >>= withAttribute KeywordTok) >>~ pushContext "El Open")
   <|>
   ((pRegExpr regex_'3c'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a >>= withAttribute KeywordTok) >>~ pushContext "El Open")
   <|>
   ((pRegExpr regex_'3c'2fpre'5cb >>= withAttribute KeywordTok) >>~ pushContext "El Close")
   <|>
   ((pRegExpr regex_'3c'2fdiv'5cb >>= withAttribute KeywordTok) >>~ pushContext "El Close")
   <|>
   ((pRegExpr regex_'3c'2ftable'5cb >>= withAttribute KeywordTok) >>~ pushContext "El Close")
   <|>
   ((pRegExpr regex_'3c'2f'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a >>= withAttribute KeywordTok) >>~ pushContext "El Close")
   <|>
   ((parseRules "FindDTDRules"))
   <|>
   ((parseRules "FindEntityRefs")))

parseRules "FindEntityRefs" =
  (((pRegExpr regex_'26'28'23'5b0'2d9'5d'2b'7c'23'5bxX'5d'5b0'2d9A'2dFa'2df'5d'2b'7c'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'29'3b >>= withAttribute DecValTok))
   <|>
   ((pAnyChar "&<" >>= withAttribute ErrorTok)))

parseRules "FindPEntityRefs" =
  (((pRegExpr regex_'26'28'23'5b0'2d9'5d'2b'7c'23'5bxX'5d'5b0'2d9A'2dFa'2df'5d'2b'7c'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'29'3b >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'25'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'3b >>= withAttribute DecValTok))
   <|>
   ((pAnyChar "&%" >>= withAttribute ErrorTok)))

parseRules "FindAttributes" =
  (((pColumn 0 >> pRegExpr regex_'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'5cs'2b'5bA'2dZa'2dz'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a >>= withAttribute OtherTok))
   <|>
   ((pDetectChar False '=' >>= withAttribute OtherTok) >>~ pushContext "Value"))

parseRules "FindDTDRules" =
  ((pRegExpr regex_'3c'21'28ELEMENT'7cENTITY'7cATTLIST'7cNOTATION'29'5cb >>= withAttribute DataTypeTok) >>~ pushContext "Doctype Markupdecl")

parseRules "Comment" =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((parseRules "FindTemplate"))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok))
   <|>
   ((pString False "-->" >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'2d'28'2d'28'3f'21'2d'3e'29'29'2b >>= withAttribute ErrorTok)))

parseRules "CDATA" =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pDetectIdentifier >>= withAttribute NormalTok))
   <|>
   ((pString False "]]>" >>= withAttribute BaseNTok) >>~ (popContext))
   <|>
   ((pString False "]]&gt;" >>= withAttribute DecValTok)))

parseRules "PI" =
  ((pDetect2Chars False '?' '>' >>= withAttribute KeywordTok) >>~ (popContext))

parseRules "Doctype" =
  (((pDetectChar False '>' >>= withAttribute DataTypeTok) >>~ (popContext))
   <|>
   ((pDetectChar False '[' >>= withAttribute DataTypeTok) >>~ pushContext "Doctype Internal Subset"))

parseRules "Doctype Internal Subset" =
  (((pDetectChar False ']' >>= withAttribute DataTypeTok) >>~ (popContext))
   <|>
   ((parseRules "FindDTDRules"))
   <|>
   ((pString False "<!--" >>= withAttribute CommentTok) >>~ pushContext "Comment")
   <|>
   ((pRegExpr regex_'3c'5c'3f'5b'5cw'3a'2d'5d'2a >>= withAttribute KeywordTok) >>~ pushContext "PI")
   <|>
   ((parseRules "FindPEntityRefs")))

parseRules "Doctype Markupdecl" =
  (((pDetectChar False '>' >>= withAttribute DataTypeTok) >>~ (popContext))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext "Doctype Markupdecl DQ")
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext "Doctype Markupdecl SQ"))

parseRules "Doctype Markupdecl DQ" =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((parseRules "FindPEntityRefs")))

parseRules "Doctype Markupdecl SQ" =
  (((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((parseRules "FindPEntityRefs")))

parseRules "El Open" =
  (((pDetect2Chars False '/' '>' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pDetectChar False '>' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((parseRules "FindAttributes"))
   <|>
   ((parseRules "FindTemplate"))
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute ErrorTok)))

parseRules "El Close" =
  (((pDetectChar False '>' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute ErrorTok)))

parseRules "El Close 2" =
  (((pDetectChar False '>' >>= withAttribute KeywordTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute ErrorTok)))

parseRules "El Close 3" =
  (((pDetectChar False '>' >>= withAttribute KeywordTok) >>~ (popContext >> popContext >> popContext >> popContext))
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute ErrorTok)))

parseRules "CSS" =
  (((pDetect2Chars False '/' '>' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pDetectChar False '>' >>= withAttribute KeywordTok) >>~ pushContext "CSS content")
   <|>
   ((parseRules "FindAttributes"))
   <|>
   ((parseRules "FindTemplate"))
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute ErrorTok)))

parseRules "CSS content" =
  (((pRegExpr regex_'3c'2fstyle'5cb >>= withAttribute KeywordTok) >>~ pushContext "El Close 2")
   <|>
   ((parseRules "FindTemplate"))
   <|>
   ((Text.Highlighting.Kate.Syntax.Css.parseExpression)))

parseRules "JS" =
  (((pDetect2Chars False '/' '>' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pDetectChar False '>' >>= withAttribute KeywordTok) >>~ pushContext "JS content")
   <|>
   ((parseRules "FindTemplate"))
   <|>
   ((parseRules "FindAttributes"))
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute ErrorTok)))

parseRules "JS content" =
  (((pRegExpr regex_'3c'2fscript'5cb >>= withAttribute KeywordTok) >>~ pushContext "El Close 2")
   <|>
   ((pRegExpr regex_'2f'2f'28'3f'3d'2e'2a'3c'2fscript'5cb'29 >>= withAttribute CommentTok) >>~ pushContext "JS comment close")
   <|>
   ((parseRules "FindTemplate"))
   <|>
   ((Text.Highlighting.Kate.Syntax.Javascript.parseExpression)))

parseRules "JS comment close" =
  (((pRegExpr regex_'3c'2fscript'5cb >>= withAttribute KeywordTok) >>~ pushContext "El Close 3")
   <|>
   ((parseRules "FindTemplate"))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd))))

parseRules "Value" =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext "Value DQ")
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext "Value SQ")
   <|>
   ((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   (pushContext "Value NQ" >> currentContext >>= parseRules))

parseRules "Value NQ" =
  (((parseRules "FindEntityRefs"))
   <|>
   ((parseRules "FindTemplate"))
   <|>
   ((pRegExpr regex_'2f'28'3f'21'3e'29 >>= withAttribute StringTok))
   <|>
   ((pRegExpr regex_'5b'5e'2f'3e'3c'22'27'5cs'5d >>= withAttribute StringTok))
   <|>
   ((popContext >> popContext) >> currentContext >>= parseRules))

parseRules "Value DQ" =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules "FindTemplate"))
   <|>
   ((parseRules "FindEntityRefs")))

parseRules "Value SQ" =
  (((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext >> popContext))
   <|>
   ((parseRules "FindTemplate"))
   <|>
   ((parseRules "FindEntityRefs")))

parseRules "" = parseRules "Start"

parseRules x = fail $ "Unknown context" ++ x
