{- This module was generated from data in the Kate syntax highlighting file yaml.xml, version 1.1,
   by  Dr Orlovsky MA (dr.orlovsky@gmail.com) -}

module Text.Highlighting.Kate.Syntax.Yaml ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec
import Control.Monad (when)
import Data.Map (fromList)
import Data.Maybe (fromMaybe, maybeToList)

-- | Full name of language.
syntaxName :: String
syntaxName = "YAML"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.yaml;*.yml"

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "YAML" }
  context <- currentContext <|> (pushContext "normal" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("YAML",["normal"])], synStLanguage = "YAML", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  lookAhead $ newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "normal" -> return () >> pHandleEndLine
    "dash" -> (popContext) >> pEndLine
    "header" -> (popContext) >> pEndLine
    "EOD" -> return () >> pHandleEndLine
    "directive" -> (popContext) >> pEndLine
    "attribute" -> (popContext >> popContext) >> pEndLine
    "attribute-inline" -> return () >> pHandleEndLine
    "attribute-pre" -> (popContext) >> pEndLine
    "attribute-pre-inline" -> (popContext) >> pEndLine
    "list" -> return () >> pHandleEndLine
    "hash" -> return () >> pHandleEndLine
    "attribute-string" -> return () >> pHandleEndLine
    "attribute-stringx" -> return () >> pHandleEndLine
    "attribute-string-inline" -> return () >> pHandleEndLine
    "attribute-stringx-inline" -> return () >> pHandleEndLine
    "attribute-end" -> (popContext >> popContext >> popContext) >> pEndLine
    "attribute-end-inline" -> (popContext >> popContext >> popContext) >> pEndLine
    "string" -> return () >> pHandleEndLine
    "stringx" -> return () >> pHandleEndLine
    "comment" -> (popContext) >> pEndLine
    _ -> pHandleEndLine

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  let labs = attr : maybeToList (lookup attr styles)
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (labs, txt)

styles = [("Comment","co"),("End of Document","co"),("Document Header","ot"),("Data Types","dt"),("Alias","dt"),("Reference","dt"),("Key","fu"),("Directive","ot"),("Operator","kw"),("Error","er")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))


regex_'2d'2d'2d = compileRegex "---"
regex_'5c'2e'5c'2e'5c'2e'24 = compileRegex "\\.\\.\\.$"
regex_'25 = compileRegex "%"
regex_'21'21'5cS'2b = compileRegex "!!\\S+"
regex_'26'5cS'2b = compileRegex "&\\S+"
regex_'5c'2a'5cS'2b = compileRegex "\\*\\S+"
regex_'5c'3f'3f'5cs'2a'5b'5e'22'27'23'2d'5d'5b'5e'3a'23'5d'2a'3a = compileRegex "\\??\\s*[^\"'#-][^:#]*:"
regex_'5c'3f'3f'5cs'2a'22'5b'5e'22'23'5d'2b'22'5cs'2a'3a = compileRegex "\\??\\s*\"[^\"#]+\"\\s*:"
regex_'5c'3f'3f'5cs'2a'27'5b'5e'27'23'5d'2b'27'5cs'2a'3a = compileRegex "\\??\\s*'[^'#]+'\\s*:"
regex_null'24 = compileRegex "null$"
regex_'2e = compileRegex "."
regex_'5cs'2a = compileRegex "\\s*"
regex_'2c'5cs = compileRegex ",\\s"

defaultAttributes = [("normal","Normal Text"),("dash","List"),("header","Document Header"),("EOD","End of Document"),("directive","Directive"),("attribute","Attribute"),("attribute-inline","Attribute"),("attribute-pre","Attribute"),("attribute-pre-inline","Attribute"),("list","List"),("hash","Hash"),("attribute-string","String"),("attribute-stringx","String"),("attribute-string-inline","String"),("attribute-stringx-inline","String"),("attribute-end","Error"),("attribute-end-inline","Error"),("string","String"),("stringx","String"),("comment","Comment")]

parseRules "normal" = 
  do (attr, result) <- (((pColumn 0 >> pRegExpr regex_'2d'2d'2d >>= withAttribute "Document Header") >>~ pushContext "header")
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'5c'2e'5c'2e'5c'2e'24 >>= withAttribute "End of Document") >>~ pushContext "EOD")
                        <|>
                        ((pColumn 0 >> pRegExpr regex_'25 >>= withAttribute "Directive") >>~ pushContext "directive")
                        <|>
                        ((pDetectSpaces >>= withAttribute "Normal Text"))
                        <|>
                        ((pDetectChar False '#' >>= withAttribute "Comment") >>~ pushContext "comment")
                        <|>
                        ((pFirstNonSpace >> pDetectChar False '-' >>= withAttribute "Operator") >>~ pushContext "dash")
                        <|>
                        ((pDetectChar False '[' >>= withAttribute "Operator") >>~ pushContext "list")
                        <|>
                        ((pDetectChar False '{' >>= withAttribute "Operator") >>~ pushContext "hash")
                        <|>
                        ((pFirstNonSpace >> pRegExpr regex_'21'21'5cS'2b >>= withAttribute "Data Types"))
                        <|>
                        ((pFirstNonSpace >> pRegExpr regex_'26'5cS'2b >>= withAttribute "Alias"))
                        <|>
                        ((pFirstNonSpace >> pRegExpr regex_'5c'2a'5cS'2b >>= withAttribute "Reference"))
                        <|>
                        ((pRegExpr regex_'5c'3f'3f'5cs'2a'5b'5e'22'27'23'2d'5d'5b'5e'3a'23'5d'2a'3a >>= withAttribute "Key") >>~ pushContext "attribute-pre")
                        <|>
                        ((pRegExpr regex_'5c'3f'3f'5cs'2a'22'5b'5e'22'23'5d'2b'22'5cs'2a'3a >>= withAttribute "Key") >>~ pushContext "attribute-pre")
                        <|>
                        ((pRegExpr regex_'5c'3f'3f'5cs'2a'27'5b'5e'27'23'5d'2b'27'5cs'2a'3a >>= withAttribute "Key") >>~ pushContext "attribute-pre")
                        <|>
                        ((pDetectChar False '\'' >>= withAttribute "String") >>~ pushContext "string")
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ pushContext "stringx"))
     return (attr, result)

parseRules "dash" = 
  do (attr, result) <- (((pDetectSpaces >>= withAttribute "List"))
                        <|>
                        ((pDetectChar False '#' >>= withAttribute "Comment") >>~ pushContext "comment")
                        <|>
                        ((pRegExpr regex_null'24 >>= withAttribute "Data Types"))
                        <|>
                        ((pRegExpr regex_'21'21'5cS'2b >>= withAttribute "Data Types"))
                        <|>
                        ((pRegExpr regex_'26'5cS'2b >>= withAttribute "Alias"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5cS'2b >>= withAttribute "Reference"))
                        <|>
                        ((lookAhead (pRegExpr regex_'2e) >> return ([],"") ) >>~ (popContext)))
     return (attr, result)

parseRules "header" = 
  do (attr, result) <- ((pDetectChar False '#' >>= withAttribute "Comment") >>~ pushContext "comment")
     return (attr, result)

parseRules "EOD" = 
  pzero

parseRules "directive" = 
  pzero

parseRules "attribute" = 
  do (attr, result) <- ((pDetectChar False '#' >>= withAttribute "Comment") >>~ pushContext "comment")
     return (attr, result)

parseRules "attribute-inline" = 
  do (attr, result) <- (((pDetectChar False ',' >>= withAttribute "Operator") >>~ (popContext >> popContext))
                        <|>
                        ((lookAhead (pDetectChar False '}') >> return ([],"") ) >>~ (popContext >> popContext))
                        <|>
                        ((pDetectChar False '#' >>= withAttribute "Comment") >>~ pushContext "comment"))
     return (attr, result)

parseRules "attribute-pre" = 
  do (attr, result) <- (((pDetectSpaces >>= withAttribute "Attribute"))
                        <|>
                        ((pDetectChar False '#' >>= withAttribute "Comment") >>~ pushContext "comment")
                        <|>
                        ((pRegExpr regex_null'24 >>= withAttribute "Data Types"))
                        <|>
                        ((pRegExpr regex_'21'21'5cS'2b >>= withAttribute "Data Types"))
                        <|>
                        ((pDetectChar False '[' >>= withAttribute "Operator") >>~ pushContext "list")
                        <|>
                        ((pDetectChar False '{' >>= withAttribute "Operator") >>~ pushContext "hash")
                        <|>
                        ((pDetectChar False '\'' >>= withAttribute "String") >>~ pushContext "attribute-string")
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ pushContext "attribute-stringx")
                        <|>
                        ((pRegExpr regex_'26'5cS'2b >>= withAttribute "Alias") >>~ pushContext "attribute")
                        <|>
                        ((pRegExpr regex_'5c'2a'5cS'2b >>= withAttribute "Reference") >>~ pushContext "attribute")
                        <|>
                        ((pRegExpr regex_'2e >>= withAttribute "Attribute") >>~ pushContext "attribute"))
     return (attr, result)

parseRules "attribute-pre-inline" = 
  do (attr, result) <- (((pDetectSpaces >>= withAttribute "Attribute"))
                        <|>
                        ((pDetectChar False '#' >>= withAttribute "Comment") >>~ pushContext "comment")
                        <|>
                        ((pString False "null" >>= withAttribute "Data Types"))
                        <|>
                        ((pRegExpr regex_'21'21'5cS'2b >>= withAttribute "Data Types"))
                        <|>
                        ((pDetectChar False '[' >>= withAttribute "Operator") >>~ pushContext "list")
                        <|>
                        ((pDetectChar False '{' >>= withAttribute "Operator") >>~ pushContext "hash")
                        <|>
                        ((pDetectChar False '\'' >>= withAttribute "String") >>~ pushContext "attribute-string-inline")
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ pushContext "attribute-stringx-inline")
                        <|>
                        ((pRegExpr regex_'26'5cS'2b >>= withAttribute "Alias") >>~ pushContext "attribute-inline")
                        <|>
                        ((pRegExpr regex_'5c'2a'5cS'2b >>= withAttribute "Reference") >>~ pushContext "attribute-inline")
                        <|>
                        ((pDetectChar False ',' >>= withAttribute "Operator") >>~ (popContext))
                        <|>
                        ((lookAhead (pDetectChar False '}') >> return ([],"") ) >>~ (popContext))
                        <|>
                        ((pRegExpr regex_'2e >>= withAttribute "Attribute") >>~ pushContext "attribute-inline"))
     return (attr, result)

parseRules "list" = 
  do (attr, result) <- (((pDetectSpaces >>= withAttribute "List"))
                        <|>
                        ((pDetectChar False '#' >>= withAttribute "Comment") >>~ pushContext "comment")
                        <|>
                        ((pDetectChar False ']' >>= withAttribute "Operator") >>~ (popContext))
                        <|>
                        ((pRegExpr regex_'5c'3f'3f'5cs'2a'5b'5e'22'27'23'2d'5d'5b'5e'3a'23'5d'2a'3a >>= withAttribute "Key") >>~ pushContext "attribute-pre")
                        <|>
                        ((pRegExpr regex_'5c'3f'3f'5cs'2a'22'5b'5e'22'23'5d'2b'22'5cs'2a'3a >>= withAttribute "Key") >>~ pushContext "attribute-pre")
                        <|>
                        ((pRegExpr regex_'5c'3f'3f'5cs'2a'27'5b'5e'27'23'5d'2b'27'5cs'2a'3a >>= withAttribute "Key") >>~ pushContext "attribute-pre")
                        <|>
                        ((pString False "null" >>= withAttribute "Data Types"))
                        <|>
                        ((pRegExpr regex_'21'21'5cS'2b >>= withAttribute "Data Types"))
                        <|>
                        ((pDetectChar False '[' >>= withAttribute "Operator") >>~ pushContext "list")
                        <|>
                        ((pDetectChar False '{' >>= withAttribute "Operator") >>~ pushContext "hash")
                        <|>
                        ((pRegExpr regex_'26'5cS'2b >>= withAttribute "Alias"))
                        <|>
                        ((pRegExpr regex_'5c'2a'5cS'2b >>= withAttribute "Reference"))
                        <|>
                        ((pDetectChar False '\'' >>= withAttribute "String") >>~ pushContext "string")
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ pushContext "stringx")
                        <|>
                        ((pDetectChar False ',' >>= withAttribute "Operator")))
     return (attr, result)

parseRules "hash" = 
  do (attr, result) <- (((pDetectSpaces >>= withAttribute "Hash"))
                        <|>
                        ((pDetectChar False '#' >>= withAttribute "Comment") >>~ pushContext "comment")
                        <|>
                        ((pRegExpr regex_'5c'3f'3f'5cs'2a'5b'5e'22'27'23'2d'5d'5b'5e'3a'23'5d'2a'3a >>= withAttribute "Key") >>~ pushContext "attribute-pre-inline")
                        <|>
                        ((pRegExpr regex_'5c'3f'3f'5cs'2a'22'5b'5e'22'23'5d'2b'22'5cs'2a'3a >>= withAttribute "Key") >>~ pushContext "attribute-pre-inline")
                        <|>
                        ((pRegExpr regex_'5c'3f'3f'5cs'2a'27'5b'5e'27'23'5d'2b'27'5cs'2a'3a >>= withAttribute "Key") >>~ pushContext "attribute-pre-inline")
                        <|>
                        ((pDetectChar False '}' >>= withAttribute "Operator") >>~ (popContext)))
     return (attr, result)

parseRules "attribute-string" = 
  do (attr, result) <- (((pDetectIdentifier >>= withAttribute "String"))
                        <|>
                        ((pDetectChar False '\'' >>= withAttribute "String") >>~ pushContext "attribute-end"))
     return (attr, result)

parseRules "attribute-stringx" = 
  do (attr, result) <- (((pDetectIdentifier >>= withAttribute "String"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ pushContext "attribute-end"))
     return (attr, result)

parseRules "attribute-string-inline" = 
  do (attr, result) <- (((pDetectIdentifier >>= withAttribute "String"))
                        <|>
                        ((pDetectChar False '\'' >>= withAttribute "String") >>~ pushContext "attribute-end-inline"))
     return (attr, result)

parseRules "attribute-stringx-inline" = 
  do (attr, result) <- (((pDetectIdentifier >>= withAttribute "String"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ pushContext "attribute-end-inline"))
     return (attr, result)

parseRules "attribute-end" = 
  pzero

parseRules "attribute-end-inline" = 
  do (attr, result) <- (((pRegExpr regex_'5cs'2a >>= withAttribute "Normal Text"))
                        <|>
                        ((lookAhead (pDetectChar False '}') >> return ([],"") ) >>~ (popContext >> popContext >> popContext))
                        <|>
                        ((pRegExpr regex_'2c'5cs >>= withAttribute "Operator") >>~ (popContext >> popContext >> popContext)))
     return (attr, result)

parseRules "string" = 
  do (attr, result) <- (((pDetectIdentifier >>= withAttribute "String"))
                        <|>
                        ((pDetectChar False '\'' >>= withAttribute "String") >>~ (popContext)))
     return (attr, result)

parseRules "stringx" = 
  do (attr, result) <- (((pDetectIdentifier >>= withAttribute "String"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ (popContext)))
     return (attr, result)

parseRules "comment" = 
  pzero

parseRules x = fail $ "Unknown context" ++ x
