{- This module was generated from data in the Kate syntax highlighting file modula-2.xml, version 1.03,
   by   -}

module Text.Highlighting.Kate.Syntax.Modula2 ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec
import Control.Monad (when)
import Data.Map (fromList)
import Data.Maybe (fromMaybe, maybeToList)

import qualified Data.Set as Set
-- | Full name of language.
syntaxName :: String
syntaxName = "Modula-2"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.mod;*.def;*.mi;*.md"

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "Modula-2" }
  context <- currentContext <|> (pushContext "Normal" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("Modula-2",["Normal"])], synStLanguage = "Modula-2", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  lookAhead $ newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "Normal" -> return () >> pHandleEndLine
    "String1" -> (popContext) >> pEndLine
    "String2" -> (popContext) >> pEndLine
    "Comment2" -> return () >> pHandleEndLine
    "Comment3" -> (popContext) >> pEndLine
    "Prep1" -> return () >> pHandleEndLine
    _ -> pHandleEndLine

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  let labs = attr : maybeToList (lookup attr styles)
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (labs, txt)

styles = [("Keyword","kw"),("Type","dt"),("Number","dv"),("String","st"),("Directive","ot"),("Comment","co")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))

list_directives = Set.fromList $ words $ "ASSEMBLER ALLOCATE DEALLOCATE SIZE Write WriteString WriteCard WriteLn WriteBf WriteInt WriteReal WriteLongReal Read ReadString ReadCard ReadInt ReadReal ReadLongReal Open Close OpenInput OpenOutput Accessible Erase EOF Done EmptyString Assign Append Length StrEq Copy Concat pos Delete Insert compare CAPS PutBf GetArgs GetEnv ResetClock UserTime SystemTime GetChar GetInt GetCard GetString GetReal GetLongReal PutChar PutInt PutCard PutString PutReal PutLongReal PutLn"
list_keywords = Set.fromList $ words $ "AND ARRAY ASM BEGIN CASE CONST DIV DO ELSE ELSIF END FOR IF IMPLEMENTATION IN SET INCL EXCL ABS BITSET CAP CHR DEC HALT HIGH INC MAX MIN ODD ORD PROC TRUNC VAL MOD NIL NOT OF OR PROCEDURE MODULE DEFINITION RECORD REPEAT THEN TO TYPE UNTIL LOOP VAR WHILE WITH EXIT FALSE TRUE BY FROM IMPORT EXPORT QUALIFIED RETURN NEWPROCESS TRANSFER IOTRANSFER FOREIGN"
list_types = Set.fromList $ words $ "INTEGER CARDINAL SHORTINT SHORTCARD LONGINT LONGREAL CHAR BOOLEAN POINTER ADDRESS ADR REAL File"


defaultAttributes = [("Normal","Normal Text"),("String1","String"),("String2","String"),("Comment2","Comment"),("Comment3","Comment"),("Prep1","Directive")]

parseRules "Normal" = 
  do (attr, result) <- (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute "Keyword"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_directives >>= withAttribute "Directive"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_types >>= withAttribute "Type"))
                        <|>
                        ((pFloat >>= withAttribute "Number"))
                        <|>
                        ((pInt >>= withAttribute "Number"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ pushContext "String1")
                        <|>
                        ((pDetectChar False '\'' >>= withAttribute "String") >>~ pushContext "String2")
                        <|>
                        ((pString False "(*$" >>= withAttribute "Directive") >>~ pushContext "Prep1")
                        <|>
                        ((pDetect2Chars False '(' '*' >>= withAttribute "Comment") >>~ pushContext "Comment2"))
     return (attr, result)

parseRules "String1" = 
  do (attr, result) <- ((pDetectChar False '"' >>= withAttribute "String") >>~ (popContext))
     return (attr, result)

parseRules "String2" = 
  do (attr, result) <- ((pDetectChar False '\'' >>= withAttribute "String") >>~ (popContext))
     return (attr, result)

parseRules "Comment2" = 
  do (attr, result) <- ((pDetect2Chars False '*' ')' >>= withAttribute "Comment") >>~ (popContext))
     return (attr, result)

parseRules "Comment3" = 
  pzero

parseRules "Prep1" = 
  do (attr, result) <- ((pString False "$*)" >>= withAttribute "Directive") >>~ pushContext "Prep1")
     return (attr, result)

parseRules x = fail $ "Unknown context" ++ x
