{- This module was generated from data in the Kate syntax highlighting file mips.xml, version 1.03,
   by  Dominik Haumann (dhdev@gmx.de) -}

module Text.Highlighting.Kate.Syntax.Mips ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec
import Control.Monad (when)
import Data.Map (fromList)
import Data.Maybe (fromMaybe, maybeToList)

import qualified Data.Set as Set
-- | Full name of language.
syntaxName :: String
syntaxName = "MIPS Assembler"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.s;"

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "MIPS Assembler" }
  context <- currentContext <|> (pushContext "normal" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("MIPS Assembler",["normal"])], synStLanguage = "MIPS Assembler", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = True, synStKeywordCaseSensitive = False, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  lookAhead $ newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "normal" -> return () >> pHandleEndLine
    "string" -> return () >> pHandleEndLine
    _ -> pHandleEndLine

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  let labs = attr : maybeToList (lookup attr styles)
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (labs, txt)

styles = [("Hardware Instruction","kw"),("Pseudo Instruction","fu"),("Other Register","dt"),("Main Register","dt"),("Floating Point Register","fl"),("Section","dt"),("Type","kw"),("Comment","co"),("Char","ch"),("String","st"),("Label","ot"),("Decimal","dv"),("Octal","bn"),("Hex","bn"),("Float","fl"),("Region Marker","re")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))

list_type = Set.fromList $ words $ ".align .ascii .asciiz .byte .double .extern .float .globl .half .sdata .set .space .word"
list_section = Set.fromList $ words $ ".data .kdata .ktext .text"
list_hardware = Set.fromList $ words $ "abs.d abs.s add add.d add.s addi addiu addu and andi bc0f bc0t bc1f bc1t bc2f bc2t bc3f bc3t beq bgez bgezal bgtz blez bltz bltzal bne break c.eq.d c.eq.s c.seq.s c.seq.d c.ueq.s c.ueq.d c.olt.d c.olt.s c.ole.d c.ole.s c.ult.d c.ult.s c.ule.d c.ule.s c.le.d c.le.s c.lt.d c.lt.s c.un.s c.un.d cvt.d.s cvt.d.w cvt.s.d cvt.s.w cvt.w.d cvt.w.s div.d div.s j jal jalr jr lb lbu lh lhu lui lw lwc0 lwc1 lwc2 lwc3 lwl lwr mfc0 mfc1 mfc2 mfc3 mfhi mflo mtc0 mtc1 mtc2 mtc3 mthi mtlo mul.d mul.s mult multu nor or ori rfe sb sh sw swcl swl swr sll sllv slt slti sltiu sra srav srl srlv sub sub.d sub.s subu sw swc0 swc1 swc2 swc3 swl swr syscall xor xori"
list_pseudo = Set.fromList $ words $ "abs b beqz bge bgeu bgt bgtu ble bleu blt bltu bnez div divu l.d l.s la ld li li.d li.s mfc0.d mfc1.d mfc2.d mfc3.d mov.d mov.s move mul mulo mulou neg neg.d neg.s negu nop not rem remu rol ror s.d s.s sd seq sge sgeu sgt sgtu sle sleu sne ulh ulhu ulw ush usw"
list_register1 = Set.fromList $ words $ "$0 $1 $2 $3 $4 $5 $6 $7 $8 $9 $10 $11 $12 $13 $14 $15 $16 $17 $18 $19 $20 $21 $22 $23 $24 $25 $26 $27 $28 $29 $30 $31 $zero $t0 $t1 $t2 $t3 $t4 $t5 $t6 $t7 $t8 $t9"
list_register2 = Set.fromList $ words $ "$v0 $v1 $a0 $a1 $a2 $a3 $k0 $k1 $at $gp $sp $fp $s0 $s1 $s2 $s3 $s4 $s5 $s6 $s7 $ra"
list_fp = Set.fromList $ words $ "$f0 $f1 $f2 $f3 $f4 $f5 $f6 $f7 $f8 $f9 $f10 $f11 $f12 $f13 $f14 $f15 $f16 $f17 $f18 $f19 $f20 $f21 $f22 $f23 $f24 $f25 $f26 $f27 $f28 $f29 $f30 $f31"

regex_'23'5cs'2aBEGIN'2e'2a'24 = compileRegex "#\\s*BEGIN.*$"
regex_'23'5cs'2aEND'2e'2a'24 = compileRegex "#\\s*END.*$"
regex_'23'2e'2a'24 = compileRegex "#.*$"
regex_'5b'5cw'5f'5c'2e'5d'2b'3a = compileRegex "[\\w_\\.]+:"
regex_'5c'5c'2e = compileRegex "\\\\."

defaultAttributes = [("normal","Normal Text"),("string","String")]

parseRules "normal" = 
  do (attr, result) <- (((pKeyword " \n\t():!+,-<=>%&*/;?[]^{|}~\\" list_hardware >>= withAttribute "Hardware Instruction"))
                        <|>
                        ((pKeyword " \n\t():!+,-<=>%&*/;?[]^{|}~\\" list_pseudo >>= withAttribute "Pseudo Instruction"))
                        <|>
                        ((pKeyword " \n\t():!+,-<=>%&*/;?[]^{|}~\\" list_register1 >>= withAttribute "Other Register"))
                        <|>
                        ((pKeyword " \n\t():!+,-<=>%&*/;?[]^{|}~\\" list_register2 >>= withAttribute "Main Register"))
                        <|>
                        ((pKeyword " \n\t():!+,-<=>%&*/;?[]^{|}~\\" list_fp >>= withAttribute "Floating Point Register"))
                        <|>
                        ((pKeyword " \n\t():!+,-<=>%&*/;?[]^{|}~\\" list_section >>= withAttribute "Type"))
                        <|>
                        ((pKeyword " \n\t():!+,-<=>%&*/;?[]^{|}~\\" list_type >>= withAttribute "Section"))
                        <|>
                        ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aBEGIN'2e'2a'24 >>= withAttribute "Region Marker"))
                        <|>
                        ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aEND'2e'2a'24 >>= withAttribute "Region Marker"))
                        <|>
                        ((pRegExpr regex_'23'2e'2a'24 >>= withAttribute "Comment"))
                        <|>
                        ((pFirstNonSpace >> pRegExpr regex_'5b'5cw'5f'5c'2e'5d'2b'3a >>= withAttribute "Label"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ pushContext "string")
                        <|>
                        ((pFloat >>= withAttribute "Float"))
                        <|>
                        ((pHlCOct >>= withAttribute "Octal"))
                        <|>
                        ((pHlCHex >>= withAttribute "Hex"))
                        <|>
                        ((pInt >>= withAttribute "Decimal")))
     return (attr, result)

parseRules "string" = 
  do (attr, result) <- (((pRegExpr regex_'5c'5c'2e >>= withAttribute "Char"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ (popContext)))
     return (attr, result)

parseRules x = fail $ "Unknown context" ++ x
