(*
 * Hedgewars, a free turn based strategy game
 * Copyright (c) 2004-2011 Andrey Korotaev <unC0Rr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *)

{$INCLUDE "options.inc"}

unit uLandTemplates;
interface
uses SDLh;

const NTPX = Low(TSDL_Rect.x);

type PPointArray = ^TPointArray;
     TPointArray = array[0..64] of TSDL_Rect;
     TEdgeTemplate = record
                     BasePoints: PPointArray;
                     BasePointsCount: Longword;
                     FillPoints: PPointArray;
                     FillPointsCount: Longword;
                     BezierizeCount: Longword;
                     RandPassesCount: Longword;
                     TemplateHeight, TemplateWidth: Longword;
                     canMirror, canFlip, isNegative, canInvert: boolean;
                     hasGirders: boolean;
                     MaxHedgeHogs: Longword;
                     end;
///////////////////////// ORIGINAL SET //////////////////////////////
/// Area expanded to 2848x1424 at Tiys request to move out border ///
/////////////////////////////////////////////////////////////////////
const Template0Points: array[0..18] of TSDL_Rect =
      (
       (x:  810; y: 1424; w:    1; h:    1),
       (x:  560; y: 1160; w:  130; h:  170),
       (x:  742; y: 1106; w:  316; h:  150),
       (x:  638; y:  786; w:  270; h:  180),
       (x:  646; y:  576; w:  242; h:  156),
       (x:  952; y:  528; w:  610; h:  300),
       (x: 1150; y:  868; w:  352; h:  324),
       (x: 1050; y: 1424; w:  500; h:    1),
       (x: 1650; y: 1500; w:    1; h:    1),
       (x: 1890; y: 1424; w:    1; h:    1),
       (x: 1852; y: 1304; w:   74; h:   12),
       (x: 1648; y:  975; w:   68; h:  425),
       (x: 1826; y:  992; w:  140; h:  142),
       (x: 1710; y:  592; w:  150; h:  350),
       (x: 1988; y:  594; w:  148; h:  242),
       (x: 2018; y:  872; w:  276; h:  314),
       (x: 2110; y: 1250; w:  130; h:   86),
       (x: 2134; y: 1424; w:    1; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1)
      );
      Template0FPoints: array[0..0] of TPoint =
      (
       (x: 1023; y:    0)
      );

const Template1Points: array[0..15] of TSDL_Rect =
      (
       (x:  800; y: 1424; w:   25; h:    1),
       (x:  684; y: 1292; w:  254; h:   58),
       (x:  892; y: 1034; w:  100; h:  200),
       (x:  654; y:  646; w:  276; h:  380),
       (x: 1020; y:  654; w:  125; h:  270),
       (x: 1080; y:  950; w:   96; h:  390),
       (x: 1226; y: 1014; w:  110; h:  350),
       (x: 1200; y:  586; w:  150; h:  380),
       (x: 1400; y:  586; w:  170; h:  375),
       (x: 1412; y:  990; w:  188; h:  298),
       (x: 1640; y: 1068; w:  136; h:  172),
       (x: 1670; y:  594; w:  120; h:  392),
       (x: 1914; y:  594; w:  364; h:  362),
       (x: 1850; y: 1052; w:  315; h:  232),
       (x: 1860; y: 1424; w:   25; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1)
      );
      Template1FPoints: array[0..0] of TPoint =
      (
       (x: 1023; y:    0)
      );

const Template2Points: array[0..21] of TSDL_Rect =
      (
       (x:  754; y: 1424; w:    1; h:    1),
       (x:  632; y: 1326; w:  226; h:   60),
       (x:  520; y: 1246; w:  298; h:   62),
       (x:  680; y: 1104; w:  210; h:  102),
       (x:  608; y:  822; w:  192; h:  248),
       (x:  692; y:  560; w:  206; h:  240),
       (x:  926; y:  572; w:   92; h:  334),
       (x:  862; y:  928; w:  226; h:  126),
       (x:  956; y: 1078; w:  268; h:  156),
       (x: 1122; y:  564; w:  138; h:  500),
       (x: 1290; y:  556; w:   94; h:  352),
       (x: 1298; y:  962; w:  170; h:  264),
       (x: 1492; y:  784; w:   84; h:  446),
       (x: 1606; y:  600; w:  158; h:  278),
       (x: 1700; y:  890; w:  104; h:  336),
       (x: 1816; y:  946; w:   90; h:  398),
       (x: 1946; y:  592; w:  134; h:  532),
       (x: 2102; y:  646; w:  156; h:  258),
       (x: 2100; y:  948; w:  132; h:  340),
       (x: 1934; y: 1298; w:  252; h:   82),
       (x: 2004; y: 1424; w:    1; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1)
      );
      Template2FPoints: array[0..0] of TPoint =
      (
       (x: 1023; y:    0)
      );

const Template3Points: array[0..16] of TSDL_Rect =
      (
       (x:  748; y: 1424; w:    1; h:    1),
       (x:  636; y: 1252; w:  208; h:   72),
       (x:  898; y: 1110; w:  308; h:   60),
       (x: 1128; y: 1252; w:  434; h:   40),
       (x: 1574; y: 1112; w:  332; h:   40),
       (x: 1802; y: 1238; w:  226; h:   36),
       (x: 1930; y: 1424; w:    1; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x: 2060; y:  898; w:  111; h:  111),
       (x: 1670; y:  876; w:   34; h:  102),
       (x: 1082; y:  814; w:  284; h:  132),
       (x:  630; y:  728; w:  126; h:  168),
       (x:  810; y:  574; w:  114; h:  100),
       (x: 1190; y:  572; w:  352; h:  120),
       (x: 1674; y:  528; w:   60; h:  240),
       (x: 1834; y:  622; w:  254; h:  116),
       (x: NTPX; y:    0; w:    1; h:    1)
      );
      Template3FPoints: array[0..0] of TPoint =
      (
       (x: 1023; y:    0)
      );

const Template4Points: array[0..22] of TSDL_Rect =
      (
       (x:  818; y: 1424; w:    1; h:    1),
       (x:  648; y: 1300; w:  186; h:   62),
       (x:  672; y: 1092; w:  254; h:  138),
       (x: 1010; y: 1168; w:   90; h:  166),
       (x: 1220; y: 1016; w:  224; h:  258),
       (x: 1642; y: 1158; w:   96; h:  146),
       (x: 1950; y: 1098; w:  224; h:  134),
       (x: 1930; y: 1302; w:  210; h:   54),
       (x: 1932; y: 1424; w:    1; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x:  602; y:  818; w:  110; h:   92),
       (x:  652; y:  712; w:  160; h:   32),
       (x:  550; y:  568; w:  134; h:   78),
       (x: 1102; y:  560; w:  132; h:   84),
       (x: 1102; y:  708; w:  230; h:   36),
       (x: 1120; y:  808; w:  166; h:   96),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x: 2102; y:  834; w:  202; h:   42),
       (x: 1652; y:  788; w:  134; h:   98),
       (x: 1614; y:  552; w:  116; h:  154),
       (x: 1828; y:  652; w:  150; h:   70),
       (x: 2150; y:  552; w:   86; h:  220),
       (x: NTPX; y:    0; w:    1; h:    1)
      );
      Template4FPoints: array[0..0] of TPoint =
      (
       (x: 1023; y:    0)
      );

const Template5Points: array[0..15] of TSDL_Rect =
      (
       (x:  674; y: 1424; w:    1; h:    1),
       (x:  590; y: 1318; w:  168; h:   26),
       (x:  782; y:  976; w:  122; h:  314),
       (x:  968; y: 1144; w:   56; h:  180),
       (x: 1078; y: 1256; w:   64; h:   56),
       (x: 1140; y: 1050; w:  106; h:  220),
       (x: 1044; y:  896; w:  162; h:  140),
       (x:  896; y:  610; w:  886; h:  174),
       (x: 1334; y:  848; w:  296; h:  108),
       (x: 1350; y: 1152; w:  152; h:  146),
       (x: 1572; y: 1174; w:   60; h:  152),
       (x: 1684; y: 1122; w:  150; h:  138),
       (x: 1894; y:  764; w:   56; h:  582),
       (x: 2020; y: 1174; w:   94; h:  232),
       (x: 2012; y: 1424; w:    1; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1)
       );
      Template5FPoints: array[0..0] of TPoint =
      (
       (x: 1023; y:    0)
      );

const Template6Points: array[0..13] of TSDL_Rect =
      (
       (x:  768; y: 1422; w:    2; h:    2),
       (x:  666; y: 1240; w:  302; h:  110),
       (x:  694; y:  912; w:  104; h:  290),
       (x:  970; y:  980; w:  364; h:  122),
       (x:  968; y:  840; w:  368; h:  100),
       (x:  632; y:  660; w:  482; h:  130),
       (x: 1178; y:  642; w:   62; h:   64),
       (x: 1390; y:  554; w:   58; h:  246),
       (x: 1600; y:  676; w:  590; h:   98),
       (x: 1488; y:  842; w:  214; h:  188),
       (x: 1450; y: 1086; w:  406; h:   92),
       (x: 1984; y:  902; w:  190; h:  412),
       (x: 2046; y: 1420; w:    2; h:    2),
       (x: NTPX; y:    0; w:    1; h:    1)
       );
      Template6FPoints: array[0..0] of TPoint =
      (
       (x: 1023; y:    0)
      );

const Template7Points: array[0..5] of TSDL_Rect =
      (
       (x:  562; y: 1424; w:  400; h:    1),
       (x:  626; y:  634; w:  142; h:  360),
       (x: 1336; y: 1140; w:  400; h:  200),
       (x: 1976; y:  576; w:  186; h:  550),
       (x: 1830; y: 1424; w:  454; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1)
      );
      Template7FPoints: array[0..0] of TPoint =
      (
       (x: 1023; y:    0)
      );


const Template8Points: array[0..19] of TSDL_Rect =
      (
       (x:  764; y: 1424; w:   20; h:    1),
       (x:  690; y: 1260; w:   64; h:   62),
       (x:  886; y: 1150; w:   52; h:  146),
       (x:  656; y:  990; w:  116; h:  144),
       (x:  870; y:  868; w:  138; h:  168),
       (x:  642; y:  642; w:  158; h:  162),
       (x:  908; y:  710; w:  198; h:   72),
       (x: 1170; y:  628; w:  118; h:  134),
       (x: 1036; y: 1118; w:  142; h:  132),
       (x: 1368; y: 1100; w:  172; h:   58),
       (x: 1370; y: 1204; w:  172; h:   62),
       (x: 1632; y: 1104; w:   82; h:  226),
       (x: 1756; y:  994; w:   64; h:  152),
       (x: 1614; y:  734; w:  106; h:  152),
       (x: 1810; y:  660; w:  380; h:   82),
       (x: 1928; y:  822; w:   30; h:  118),
       (x: 1940; y:  988; w:  212; h:   50),
       (x: 1864; y: 1146; w:  128; h:  146),
       (x: 2030; y: 1424; w:   20; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1)
      );
      Template8FPoints: array[0..0] of TPoint =
      (
       (x: 1023; y:    0)
      );

const Template9Points: array[0..31] of TSDL_Rect =
      (
       (x:  740; y: 1424; w:    1; h:    1),
       (x:  676; y: 1302; w:   44; h:   54),
       (x:  834; y: 1236; w:   58; h:   90),
       (x:  666; y: 1134; w:   80; h:   80),
       (x:  646; y: 1004; w:   96; h:  108),
       (x:  826; y: 1046; w:  110; h:  112),
       (x:  634; y:  692; w:  118; h:  164),
       (x:  828; y:  796; w:  130; h:  110),
       (x:  916; y:  598; w:  344; h:   78),
       (x: 1088; y:  826; w:   50; h:   40),
       (x: 1026; y:  960; w:   32; h:  148),
       (x: 1098; y: 1050; w:  160; h:   34),
       (x: 1074; y: 1188; w:   36; h:  136),
       (x: 1414; y: 1248; w:   48; h:   48),
       (x: 1486; y: 1128; w:   64; h:   88),
       (x: 1358; y: 1060; w:   70; h:   74),
       (x: 1516; y:  996; w:   68; h:   70),
       (x: 1518; y:  884; w:   68; h:   82),
       (x: 1358; y:  724; w:   44; h:  140),
       (x: 1672; y:  706; w:   52; h:   66),
       (x: 1654; y:  902; w:   58; h:   66),
       (x: 1634; y: 1160; w:   76; h:  112),
       (x: 1780; y: 1162; w:  124; h:   64),
       (x: 1872; y:  872; w:   54; h:  134),
       (x: 1810; y:  596; w:  246; h:   62),
       (x: 2106; y:  554; w:   38; h:  238),
       (x: 2212; y:  748; w:   28; h:   28),
       (x: 2092; y:  924; w:  144; h:   94),
       (x: 2032; y: 1078; w:  248; h:   20),
       (x: 2032; y: 1202; w:  238; h:   16),
       (x: 2080; y: 1424; w:    1; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1)
      );
      Template9FPoints: array[0..0] of TPoint =
      (
       (x: 1023; y:    0)
      );

const Template10Points: array[0..13] of TSDL_Rect =
      (
       (x:  588; y: 1424; w:  190; h:    1),
       (x:  640; y: 1082; w:  140; h:  150),
       (x:  714; y:  868; w:  352; h:   94),
       (x: 1126; y:  646; w:  106; h:  282),
       (x: 1302; y:  790; w:  368; h:  142),
       (x: 1358; y:  988; w:  116; h:  244),
       (x: 1276; y: 1424; w:   14; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x: 1464; y: 1424; w:   22; h:    1),
       (x: 1688; y: 1195; w:  120; h:  120),
       (x: 1858; y:  674; w:  354; h:  448),
       (x: 2088; y: 1195; w:  120; h:  120),
       (x: 2182; y: 1424; w:    2; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1)
      );
      Template10FPoints: array[0..0] of TPoint =
      (
       (x: 1023; y:    0)
      );

const Template11Points: array[0..9] of TSDL_Rect =
      (
       (x:  674; y: 1424; w:  166; h:    1),
       (x:  730; y: 1262; w:   96; h:   92),
       (x:  892; y: 1090; w:  152; h:  250),
       (x: 1146; y: 1046; w:   36; h:  270),
       (x: 1338; y: 1026; w:   54; h:  224),
       (x: 1534; y: 1046; w:   44; h:  216),
       (x: 1692; y: 1030; w:   46; h:  300),
       (x: 1848; y: 1064; w:  158; h:  272),
       (x: 1984; y: 1424; w:  136; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1)
      );
      Template11FPoints: array[0..0] of TPoint =
      (
       (x: 1023; y:    0)
      );

const Template12Points: array[0..13] of TSDL_Rect =
      (
       (x:  760; y: 1424; w:    2; h:    2),
       (x:  642; y: 1030; w:   46; h:  286),
       (x:  854; y: 1072; w:  194; h:   56),
       (x:  654; y:  734; w:  534; h:  200),
       (x: 1270; y:  676; w:   58; h:  468),
       (x: 1476; y:  672; w:  198; h:  112),
       (x: 1400; y: 1424; w:   64; h:    2),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x: 1644; y: 1424; w:   64; h:    2),
       (x: 1756; y:  894; w:  184; h:   94),
       (x: 2000; y:  814; w:   76; h:  358),
       (x: 2148; y:  984; w:  108; h:  304),
       (x: 2088; y: 1424; w:  176; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1)
      );
      Template12FPoints: array[0..0] of TPoint =
      (
       (x: 1023; y:    0)
      );

const Template13Points: array[0..15] of TSDL_Rect =
      (
       (x:  846; y: 1424; w:  140; h:    2),
       (x:  680; y: 1272; w:  196; h:   32),
       (x:  654; y: 1080; w:  262; h:  134),
       (x: 1054; y: 1072; w:  220; h:  136),
       (x: 1008; y:  890; w:  268; h:  110),
       (x:  700; y:  762; w:  104; h:  200),
       (x:  846; y:  624; w:  306; h:   58),
       (x: 1316; y:  588; w:   84; h:  206),
       (x: 1548; y:  574; w:  104; h:  220),
       (x: 1826; y:  576; w:  120; h:  202),
       (x: 1956; y:  818; w:  192; h:   68),
       (x: 1626; y:  948; w:  246; h:   88),
       (x: 1656; y: 1106; w:  194; h:  150),
       (x: 1968; y: 1106; w:  198; h:  152),
       (x: 1844; y: 1424; w:    2; h:    2),
       (x: NTPX; y:    0; w:    1; h:    1)
      );
      Template13FPoints: array[0..0] of TPoint =
      (
       (x: 1023; y:    0)
      );

const Template14Points: array[0..13] of TSDL_Rect =
      (
       (x:  686; y: 1424; w:    2; h:    2),
       (x:  644; y: 1286; w:   84; h:   54),
       (x:  612; y: 1086; w:  150; h:  166),
       (x: 1078; y: 1240; w:  186; h:   98),
       (x: 1144; y: 1004; w:  124; h:   58),
       (x: 1020; y:  582; w:  112; h:  194),
       (x: 1388; y:  660; w:   92; h:  132),
       (x: 1710; y:  574; w:  154; h:  196),
       (x: 1560; y:  974; w:  118; h:   64),
       (x: 1452; y: 1222; w:  328; h:   92),
       (x: 1996; y: 1030; w:  242; h:  222),
       (x: 1998; y: 1316; w:  254; h:   50),
       (x: 2008; y: 1424; w:    2; h:    2),
       (x: NTPX; y:    0; w:    1; h:    1)
      );
      Template14FPoints: array[0..0] of TPoint =
      (
       (x: 1023; y:    0)
      );

const Template15Points: array[0..23] of TSDL_Rect =
      (
       (x:  702; y: 1424; w:    2; h:    2),
       (x:  640; y: 1290; w:   44; h:   94),
       (x:  750; y: 1262; w:   44; h:   94),
       (x:  860; y: 1306; w:   78; h:   70),
       (x:  866; y: 1424; w:    2; h:    2),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x: 1204; y: 1424; w:    2; h:    2),
       (x: 1120; y: 1182; w:  108; h:  174),
       (x:  884; y: 1024; w:  314; h:   98),
       (x:  710; y:  882; w:   76; h:  230),
       (x:  834; y:  686; w:  220; h:  154),
       (x: 1240; y:  674; w:   56; h:  266),
       (x: 1424; y:  644; w:   78; h:  304),
       (x: 1648; y:  646; w:  116; h:  162),
       (x: 1980; y:  726; w:  190; h:  228),
       (x: 1760; y: 1004; w:  140; h:   84),
       (x: 1596; y: 1140; w:  242; h:  118),
       (x: 1616; y: 1424; w:    2; h:    2),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x: 1894; y: 1424; w:    2; h:    2),
       (x: 1850; y: 1328; w:   88; h:   34),
       (x: 1998; y: 1238; w:   96; h:  112),
       (x: 2056; y: 1424; w:    2; h:    2),
       (x: NTPX; y:    0; w:    1; h:    1)
      );
      Template15FPoints: array[0..0] of TPoint =
      (
       (x: 1023; y:    0)
      );

const Template16Points: array[0..28] of TSDL_Rect =
      (
       (x:  700; y: 1424; w:    2; h:    2),
       (x:  794; y: 1302; w:   58; h:   62),
       (x:  780; y: 1170; w:   94; h:   90),
       (x:  586; y: 1026; w:   80; h:  220),
       (x:  776; y: 1000; w:   82; h:  118),
       (x:  582; y:  728; w:  134; h:  226),
       (x:  768; y:  728; w:   52; h:   52),
       (x:  872; y:  574; w:   56; h:  212),
       (x:  988; y:  722; w:   60; h:   62),
       (x: 1118; y:  724; w:  108; h:  218),
       (x: 1012; y:  916; w:   36; h:  168),
       (x: 1128; y: 1056; w:  140; h:  134),
       (x:  988; y: 1250; w:   74; h:   82),
       (x: 1150; y: 1424; w:  102; h:    2),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x: 1704; y: 1424; w:   72; h:    2),
       (x: 1626; y: 1308; w:  266; h:   34),
       (x: 1624; y: 1148; w:  252; h:   80),
       (x: 1612; y:  976; w:  256; h:   94),
       (x: 1540; y:  834; w:  174; h:   86),
       (x: 1796; y:  718; w:  156; h:   96),
       (x: 1486; y:  614; w:  206; h:   66),
       (x: 1846; y:  556; w:  152; h:   40),
       (x: 2108; y:  672; w:   60; h:  162),
       (x: 1942; y:  888; w:  146; h:   80),
       (x: 2086; y: 1034; w:  178; h:  122),
       (x: 1972; y: 1220; w:   34; h:  124),
       (x: 2098; y: 1424; w:   52; h:    2),
       (x: NTPX; y:    0; w:    1; h:    1)
      );
      Template16FPoints: array[0..0] of TPoint =
      (
       (x: 1023; y:    0)
      );

const Template17Points: array[0..13] of TSDL_Rect =
      (
       (x:  630; y: 1424; w:    2; h:    2),
       (x:  566; y: 1256; w:  128; h:  118),
       (x:  752; y: 1256; w:   98; h:  114),
       (x:  748; y: 1074; w:  140; h:  138),
       (x:  956; y: 1072; w:  136; h:  142),
       (x: 1146; y: 1070; w:  114; h:  252),
       (x: 1324; y:  778; w:  120; h:  390),
       (x: 1522; y:  862; w:  114; h:  210),
       (x: 1724; y:  706; w:  130; h:  252),
       (x: 1936; y:  606; w:  278; h:  234),
       (x: 1924; y: 1044; w:  272; h:   52),
       (x: 1972; y: 1252; w:  180; h:   56),
       (x: 1998; y: 1424; w:   42; h:    2),
       (x: NTPX; y:    0; w:    1; h:    1)
      );
      Template17FPoints: array[0..0] of TPoint =
      (
       (x: 1023; y:    0)
      );
//////////////////// MIXING AND MATCHING ORIGINAL //////////////////////////////////////
const Template18Points: array[0..32] of TSDL_Rect =
      (
       (x:  610; y: 1424; w:    1; h:    1),
       (x:  360; y: 1160; w:  130; h:  170),
       (x:  542; y: 1106; w:  316; h:  150),
       (x:  438; y:  786; w:  270; h:  180),
       (x:  446; y:  576; w:  242; h:  156),
       (x:  752; y:  528; w:  610; h:  300),
       (x:  950; y:  868; w:  352; h:  324),
       (x:  850; y: 1424; w:  500; h:    1),
       (x: 1450; y: 1500; w:    1; h:    1),
       (x: 1690; y: 1424; w:    1; h:    1),
       (x: 1652; y: 1304; w:   74; h:   12),
       (x: 1448; y:  975; w:   68; h:  425),
       (x: 1626; y:  992; w:  140; h:  142),
       (x: 1510; y:  592; w:  150; h:  350),
       (x: 1788; y:  594; w:  148; h:  242),
       (x: 1818; y:  872; w:  276; h:  314),
       (x: 1910; y: 1250; w:  130; h:   86),
       (x: 1934; y: 1424; w:    1; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x: 2230; y: 1424; w:    2; h:    2),
       (x: 2166; y: 1256; w:  128; h:  118),
       (x: 2352; y: 1256; w:   98; h:  114),
       (x: 2348; y: 1074; w:  140; h:  138),
       (x: 2556; y: 1072; w:  136; h:  142),
       (x: 2746; y: 1070; w:  114; h:  252),
       (x: 2924; y:  778; w:  120; h:  390),
       (x: 3122; y:  862; w:  114; h:  210),
       (x: 3324; y:  706; w:  130; h:  252),
       (x: 3536; y:  606; w:  278; h:  234),
       (x: 3524; y: 1044; w:  272; h:   52),
       (x: 3572; y: 1252; w:  180; h:   56),
       (x: 3598; y: 1424; w:   42; h:    2),
       (x: NTPX; y:    0; w:    1; h:    1)
      );
      Template18FPoints: array[0..0] of TPoint =
      (
       (x: 2047; y:    0)
      );

const Template19Points: array[0..44] of TSDL_Rect =
      (
       (x:  600; y: 1424; w:   25; h:    1),
       (x:  484; y: 1292; w:  254; h:   58),
       (x:  692; y: 1034; w:  100; h:  200),
       (x:  454; y:  646; w:  276; h:  380),
       (x:  820; y:  654; w:  125; h:  270),
       (x:  880; y:  950; w:   96; h:  390),
       (x: 1026; y: 1014; w:  110; h:  350),
       (x: 1000; y:  586; w:  150; h:  380),
       (x: 1200; y:  586; w:  170; h:  375),
       (x: 1212; y:  990; w:  188; h:  298),
       (x: 1440; y: 1068; w:  136; h:  172),
       (x: 1470; y:  594; w:  120; h:  392),
       (x: 1714; y:  594; w:  364; h:  362),
       (x: 1650; y: 1052; w:  315; h:  232),
       (x: 1660; y: 1424; w:   25; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x: 2000; y: 1424; w:    2; h:    2),
       (x: 2094; y: 1302; w:   58; h:   62),
       (x: 2080; y: 1170; w:   94; h:   90),
       (x: 1886; y: 1026; w:   80; h:  220),
       (x: 2076; y: 1000; w:   82; h:  118),
       (x: 1882; y:  728; w:  134; h:  226),
       (x: 2068; y:  728; w:   52; h:   52),
       (x: 2172; y:  574; w:   56; h:  212),
       (x: 2288; y:  722; w:   60; h:   62),
       (x: 2418; y:  724; w:  108; h:  218),
       (x: 2312; y:  916; w:   36; h:  168),
       (x: 2428; y: 1056; w:  140; h:  134),
       (x: 2288; y: 1250; w:   74; h:   82),
       (x: 2450; y: 1424; w:  102; h:    2),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x: 3004; y: 1424; w:   72; h:    2),
       (x: 2926; y: 1308; w:  266; h:   34),
       (x: 2924; y: 1148; w:  252; h:   80),
       (x: 2912; y:  976; w:  256; h:   94),
       (x: 2840; y:  834; w:  174; h:   86),
       (x: 3096; y:  718; w:  156; h:   96),
       (x: 2786; y:  614; w:  206; h:   66),
       (x: 3146; y:  556; w:  152; h:   40),
       (x: 3408; y:  672; w:   60; h:  162),
       (x: 3242; y:  888; w:  146; h:   80),
       (x: 3386; y: 1034; w:  178; h:  122),
       (x: 3272; y: 1220; w:   34; h:  124),
       (x: 3398; y: 1424; w:   52; h:    2),
       (x: NTPX; y:    0; w:    1; h:    1)
      );
      Template19FPoints: array[0..0] of TPoint =
      (
       (x: 2047; y:    0)
      );

const Template20Points: array[0..45] of TSDL_Rect =
      (
       (x:  554; y: 1424; w:    1; h:    1),
       (x:  432; y: 1326; w:  226; h:   60),
       (x:  320; y: 1246; w:  298; h:   62),
       (x:  480; y: 1104; w:  210; h:  102),
       (x:  408; y:  822; w:  192; h:  248),
       (x:  492; y:  560; w:  206; h:  240),
       (x:  726; y:  572; w:   92; h:  334),
       (x:  662; y:  928; w:  226; h:  126),
       (x:  756; y: 1078; w:  268; h:  156),
       (x:  922; y:  564; w:  138; h:  500),
       (x: 1090; y:  556; w:   94; h:  352),
       (x: 1098; y:  962; w:  170; h:  264),
       (x: 1292; y:  784; w:   84; h:  446),
       (x: 1406; y:  600; w:  158; h:  278),
       (x: 1500; y:  890; w:  104; h:  336),
       (x: 1616; y:  946; w:   90; h:  398),
       (x: 1746; y:  592; w:  134; h:  532),
       (x: 1902; y:  646; w:  156; h:  258),
       (x: 1900; y:  948; w:  132; h:  340),
       (x: 1734; y: 1298; w:  252; h:   82),
       (x: 1804; y: 1424; w:    1; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x: 2102; y: 1424; w:    2; h:    2),
       (x: 2040; y: 1290; w:   44; h:   94),
       (x: 2150; y: 1262; w:   44; h:   94),
       (x: 2260; y: 1306; w:   78; h:   70),
       (x: 2266; y: 1424; w:    2; h:    2),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x: 2604; y: 1424; w:    2; h:    2),
       (x: 2520; y: 1182; w:  108; h:  174),
       (x: 2284; y: 1024; w:  314; h:   98),
       (x: 2110; y:  882; w:   76; h:  230),
       (x: 2234; y:  686; w:  220; h:  154),
       (x: 2640; y:  674; w:   56; h:  266),
       (x: 2824; y:  644; w:   78; h:  304),
       (x: 3048; y:  646; w:  116; h:  162),
       (x: 3380; y:  726; w:  190; h:  228),
       (x: 3160; y: 1004; w:  140; h:   84),
       (x: 2996; y: 1140; w:  242; h:  118),
       (x: 3016; y: 1424; w:    2; h:    2),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x: 3294; y: 1424; w:    2; h:    2),
       (x: 3250; y: 1328; w:   88; h:   34),
       (x: 3398; y: 1238; w:   96; h:  112),
       (x: 3456; y: 1424; w:    2; h:    2),
       (x: NTPX; y:    0; w:    1; h:    1)
      );
      Template20FPoints: array[0..0] of TPoint =
      (
       (x: 2047; y:    0)
      );

const Template21Points: array[0..30] of TSDL_Rect =
      (
       (x:  548; y: 1424; w:    1; h:    1),
       (x:  436; y: 1252; w:  208; h:   72),
       (x:  698; y: 1110; w:  308; h:   60),
       (x:  928; y: 1252; w:  434; h:   40),
       (x: 1374; y: 1112; w:  332; h:   40),
       (x: 1602; y: 1238; w:  226; h:   36),
       (x: 1730; y: 1424; w:    1; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x: 1860; y:  898; w:  111; h:  111),
       (x: 1470; y:  876; w:   34; h:  102),
       (x:  882; y:  814; w:  284; h:  132),
       (x:  430; y:  728; w:  126; h:  168),
       (x:  610; y:  574; w:  114; h:  100),
       (x:  990; y:  572; w:  352; h:  120),
       (x: 1474; y:  528; w:   60; h:  240),
       (x: 1634; y:  622; w:  254; h:  116),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x: 1936; y: 1424; w:    2; h:    2),
       (x: 1894; y: 1286; w:   84; h:   54),
       (x: 1862; y: 1086; w:  150; h:  166),
       (x: 2328; y: 1240; w:  186; h:   98),
       (x: 2394; y: 1004; w:  124; h:   58),
       (x: 2270; y:  582; w:  112; h:  194),
       (x: 2638; y:  660; w:   92; h:  132),
       (x: 2960; y:  574; w:  154; h:  196),
       (x: 2810; y:  974; w:  118; h:   64),
       (x: 2702; y: 1222; w:  328; h:   92),
       (x: 3246; y: 1030; w:  242; h:  222),
       (x: 3248; y: 1316; w:  254; h:   50),
       (x: 3258; y: 1424; w:    2; h:    2),
       (x: NTPX; y:    0; w:    1; h:    1)
      );
      Template21FPoints: array[0..0] of TPoint =
      (
       (x: 2047; y:    0)
      );

const Template22Points: array[0..38] of TSDL_Rect =
      (
       (x:  618; y: 1424; w:    1; h:    1),
       (x:  448; y: 1300; w:  186; h:   62),
       (x:  472; y: 1092; w:  254; h:  138),
       (x:  810; y: 1168; w:   90; h:  166),
       (x: 1020; y: 1016; w:  224; h:  258),
       (x: 1442; y: 1158; w:   96; h:  146),
       (x: 1750; y: 1098; w:  224; h:  134),
       (x: 1730; y: 1302; w:  210; h:   54),
       (x: 1732; y: 1424; w:    1; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x:  402; y:  818; w:  110; h:   92),
       (x:  452; y:  712; w:  160; h:   32),
       (x:  350; y:  568; w:  134; h:   78),
       (x:  902; y:  560; w:  132; h:   84),
       (x:  902; y:  708; w:  230; h:   36),
       (x:  920; y:  808; w:  166; h:   96),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x: 1902; y:  834; w:  202; h:   42),
       (x: 1452; y:  788; w:  134; h:   98),
       (x: 1414; y:  552; w:  116; h:  154),
       (x: 1628; y:  652; w:  150; h:   70),
       (x: 1950; y:  552; w:   86; h:  220),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x: 2246; y: 1424; w:  140; h:    2),
       (x: 2080; y: 1272; w:  196; h:   32),
       (x: 2054; y: 1080; w:  262; h:  134),
       (x: 2454; y: 1072; w:  220; h:  136),
       (x: 2408; y:  890; w:  268; h:  110),
       (x: 2100; y:  762; w:  104; h:  200),
       (x: 2246; y:  624; w:  306; h:   58),
       (x: 2716; y:  588; w:   84; h:  206),
       (x: 2948; y:  574; w:  104; h:  220),
       (x: 3226; y:  576; w:  120; h:  202),
       (x: 3356; y:  818; w:  192; h:   68),
       (x: 3026; y:  948; w:  246; h:   88),
       (x: 3056; y: 1106; w:  194; h:  150),
       (x: 3368; y: 1106; w:  198; h:  152),
       (x: 3244; y: 1424; w:    2; h:    2),
       (x: NTPX; y:    0; w:    1; h:    1)
      );
      Template22FPoints: array[0..0] of TPoint =
      (
       (x: 2047; y:    0)
      );

const Template23Points: array[0..29] of TSDL_Rect =
      (
       (x:  474; y: 1424; w:    1; h:    1),
       (x:  390; y: 1318; w:  168; h:   26),
       (x:  582; y:  976; w:  122; h:  314),
       (x:  768; y: 1144; w:   56; h:  180),
       (x:  878; y: 1256; w:   64; h:   56),
       (x:  940; y: 1050; w:  106; h:  220),
       (x:  844; y:  896; w:  162; h:  140),
       (x:  696; y:  610; w:  886; h:  174),
       (x: 1134; y:  848; w:  296; h:  108),
       (x: 1150; y: 1152; w:  152; h:  146),
       (x: 1372; y: 1174; w:   60; h:  152),
       (x: 1484; y: 1122; w:  150; h:  138),
       (x: 1694; y:  764; w:   56; h:  582),
       (x: 1820; y: 1174; w:   94; h:  232),
       (x: 1812; y: 1424; w:    1; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x: 2110; y: 1424; w:    2; h:    2),
       (x: 1992; y: 1030; w:   46; h:  286),
       (x: 2204; y: 1072; w:  194; h:   56),
       (x: 2004; y:  734; w:  534; h:  200),
       (x: 2620; y:  676; w:   58; h:  468),
       (x: 2826; y:  672; w:  198; h:  112),
       (x: 2750; y: 1424; w:   64; h:    2),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x: 2994; y: 1424; w:   64; h:    2),
       (x: 3106; y:  894; w:  184; h:   94),
       (x: 3350; y:  814; w:   76; h:  358),
       (x: 3498; y:  984; w:  108; h:  304),
       (x: 3438; y: 1424; w:  176; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1)
       );
      Template23FPoints: array[0..0] of TPoint =
      (
       (x: 2047; y:    0)
      );

const Template24Points: array[0..23] of TSDL_Rect =
      (
       (x:  474; y: 1424; w:  166; h:    1),
       (x:  530; y: 1262; w:   96; h:   92),
       (x:  692; y: 1090; w:  152; h:  250),
       (x: 946; y: 1046; w:   36; h:  270),
       (x: 1138; y: 1026; w:   54; h:  224),
       (x: 1334; y: 1046; w:   44; h:  216),
       (x: 1492; y: 1030; w:   46; h:  300),
       (x: 1648; y: 1064; w:  158; h:  272),
       (x: 1784; y: 1424; w:  136; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x: 2068; y: 1422; w:    2; h:    2),
       (x: 1966; y: 1240; w:  302; h:  110),
       (x: 1994; y:  912; w:  104; h:  290),
       (x: 2270; y:  980; w:  364; h:  122),
       (x: 2268; y:  840; w:  368; h:  100),
       (x: 1932; y:  660; w:  482; h:  130),
       (x: 2478; y:  642; w:   62; h:   64),
       (x: 2690; y:  554; w:   58; h:  246),
       (x: 2900; y:  676; w:  590; h:   98),
       (x: 2788; y:  842; w:  214; h:  188),
       (x: 2750; y: 1086; w:  406; h:   92),
       (x: 3284; y:  902; w:  190; h:  412),
       (x: 3346; y: 1420; w:    2; h:    2),
       (x: NTPX; y:    0; w:    1; h:    1)
       );
      Template24FPoints: array[0..0] of TPoint =
      (
       (x: 2047; y:    0)
      );

const Template25Points: array[0..19] of TSDL_Rect =
      (
       (x:  362; y: 1424; w:  400; h:    1),
       (x:  426; y:  634; w:  142; h:  360),
       (x: 1136; y: 1140; w:  400; h:  200),
       (x: 1776; y:  576; w:  186; h:  550),
       (x: 1630; y: 1424; w:  454; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x: 1938; y: 1424; w:  190; h:    1),
       (x: 1990; y: 1082; w:  140; h:  150),
       (x: 2064; y:  868; w:  352; h:   94),
       (x: 2476; y:  646; w:  106; h:  282),
       (x: 2652; y:  790; w:  368; h:  142),
       (x: 2708; y:  988; w:  116; h:  244),
       (x: 2626; y: 1424; w:   14; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x: 2814; y: 1424; w:   22; h:    1),
       (x: 3038; y: 1195; w:  120; h:  120),
       (x: 3208; y:  674; w:  354; h:  448),
       (x: 3438; y: 1195; w:  120; h:  120),
       (x: 3532; y: 1424; w:    2; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1)
      );
      Template25FPoints: array[0..0] of TPoint =
      (
       (x: 2047; y:    0)
      );


const Template26Points: array[0..51] of TSDL_Rect =
      (
       (x:  564; y: 1424; w:   20; h:    1),
       (x:  490; y: 1260; w:   64; h:   62),
       (x:  686; y: 1150; w:   52; h:  146),
       (x:  456; y:  990; w:  116; h:  144),
       (x:  670; y:  868; w:  138; h:  168),
       (x:  442; y:  642; w:  158; h:  162),
       (x:  708; y:  710; w:  198; h:   72),
       (x:  970; y:  628; w:  118; h:  134),
       (x:  836; y: 1118; w:  142; h:  132),
       (x: 1168; y: 1100; w:  172; h:   58),
       (x: 1170; y: 1204; w:  172; h:   62),
       (x: 1432; y: 1104; w:   82; h:  226),
       (x: 1556; y:  994; w:   64; h:  152),
       (x: 1414; y:  734; w:  106; h:  152),
       (x: 1610; y:  660; w:  380; h:   82),
       (x: 1728; y:  822; w:   30; h:  118),
       (x: 1740; y:  988; w:  212; h:   50),
       (x: 1664; y: 1146; w:  128; h:  146),
       (x: 1830; y: 1424; w:   20; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x: 2140; y: 1424; w:    1; h:    1),
       (x: 2076; y: 1302; w:   44; h:   54),
       (x: 2234; y: 1236; w:   58; h:   90),
       (x: 2066; y: 1134; w:   80; h:   80),
       (x: 2046; y: 1004; w:   96; h:  108),
       (x: 2226; y: 1046; w:  110; h:  112),
       (x: 2034; y:  692; w:  118; h:  164),
       (x: 2228; y:  796; w:  130; h:  110),
       (x: 2316; y:  598; w:  344; h:   78),
       (x: 2488; y:  826; w:   50; h:   40),
       (x: 2426; y:  960; w:   32; h:  148),
       (x: 2498; y: 1050; w:  160; h:   34),
       (x: 2474; y: 1188; w:   36; h:  136),
       (x: 2814; y: 1248; w:   48; h:   48),
       (x: 2886; y: 1128; w:   64; h:   88),
       (x: 2758; y: 1060; w:   70; h:   74),
       (x: 2916; y:  996; w:   68; h:   70),
       (x: 2918; y:  884; w:   68; h:   82),
       (x: 2758; y:  724; w:   44; h:  140),
       (x: 3072; y:  706; w:   52; h:   66),
       (x: 3054; y:  902; w:   58; h:   66),
       (x: 3034; y: 1160; w:   76; h:  112),
       (x: 3180; y: 1162; w:  124; h:   64),
       (x: 3272; y:  872; w:   54; h:  134),
       (x: 3210; y:  596; w:  246; h:   62),
       (x: 3506; y:  554; w:   38; h:  238),
       (x: 3612; y:  748; w:   28; h:   28),
       (x: 3492; y:  924; w:  144; h:   94),
       (x: 3432; y: 1078; w:  248; h:   20),
       (x: 3432; y: 1202; w:  238; h:   16),
       (x: 3480; y: 1424; w:    1; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1)
      );
      Template26FPoints: array[0..0] of TPoint =
      (
       (x: 2047; y:    0)
      );

const Template27Points: array[0..42] of TSDL_Rect =
      (
       (x:  610; y: 1424; w:    1; h:    1),
       (x:  360; y: 1160; w:  130; h:  170),
       (x:  542; y: 1106; w:  316; h:  150),
       (x:  438; y:  786; w:  270; h:  180),
       (x:  446; y:  576; w:  242; h:  156),
       (x:  752; y:  528; w:  610; h:  300),
       (x:  950; y:  868; w:  352; h:  324),
       (x:  850; y: 1424; w:  500; h:    1),
       (x: 1450; y: 1500; w:    1; h:    1),
       (x: 1690; y: 1424; w:    1; h:    1),
       (x: 1652; y: 1304; w:   74; h:   12),
       (x: 1448; y:  975; w:   68; h:  425),
       (x: 1626; y:  992; w:  140; h:  142),
       (x: 1510; y:  592; w:  150; h:  350),
       (x: 1788; y:  594; w:  148; h:  242),
       (x: 1818; y:  872; w:  276; h:  314),
       (x: 1910; y: 1250; w:  130; h:   86),
       (x: 1934; y: 1424; w:    1; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x: 2202; y: 1424; w:    2; h:    2),
       (x: 2140; y: 1290; w:   44; h:   94),
       (x: 2250; y: 1262; w:   44; h:   94),
       (x: 2360; y: 1306; w:   78; h:   70),
       (x: 2366; y: 1424; w:    2; h:    2),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x: 2704; y: 1424; w:    2; h:    2),
       (x: 2620; y: 1182; w:  108; h:  174),
       (x: 2384; y: 1024; w:  314; h:   98),
       (x: 2210; y:  882; w:   76; h:  230),
       (x: 2334; y:  686; w:  220; h:  154),
       (x: 2740; y:  674; w:   56; h:  266),
       (x: 2924; y:  644; w:   78; h:  304),
       (x: 3148; y:  646; w:  116; h:  162),
       (x: 3480; y:  726; w:  190; h:  228),
       (x: 3260; y: 1004; w:  140; h:   84),
       (x: 3096; y: 1140; w:  242; h:  118),
       (x: 3116; y: 1424; w:    2; h:    2),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x: 3394; y: 1424; w:    2; h:    2),
       (x: 3350; y: 1328; w:   88; h:   34),
       (x: 3498; y: 1238; w:   96; h:  112),
       (x: 3556; y: 1424; w:    2; h:    2),
       (x: NTPX; y:    0; w:    1; h:    1)
      );
      Template27FPoints: array[0..0] of TPoint =
      (
       (x: 2047; y:    0)
      );

const Template28Points: array[0..29] of TSDL_Rect =
      (
       (x:  600; y: 1424; w:   25; h:    1),
       (x:  484; y: 1292; w:  254; h:   58),
       (x:  692; y: 1034; w:  100; h:  200),
       (x:  454; y:  646; w:  276; h:  380),
       (x:  820; y:  654; w:  125; h:  270),
       (x:  880; y:  950; w:   96; h:  390),
       (x: 1026; y: 1014; w:  110; h:  350),
       (x: 1000; y:  586; w:  150; h:  380),
       (x: 1200; y:  586; w:  170; h:  375),
       (x: 1212; y:  990; w:  188; h:  298),
       (x: 1440; y: 1068; w:  136; h:  172),
       (x: 1470; y:  594; w:  120; h:  392),
       (x: 1714; y:  594; w:  364; h:  362),
       (x: 1650; y: 1052; w:  315; h:  232),
       (x: 1660; y: 1424; w:   25; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x: 1986; y: 1424; w:    2; h:    2),
       (x: 1944; y: 1286; w:   84; h:   54),
       (x: 1912; y: 1086; w:  150; h:  166),
       (x: 2378; y: 1240; w:  186; h:   98),
       (x: 2444; y: 1004; w:  124; h:   58),
       (x: 2320; y:  582; w:  112; h:  194),
       (x: 2688; y:  660; w:   92; h:  132),
       (x: 3010; y:  574; w:  154; h:  196),
       (x: 2860; y:  974; w:  118; h:   64),
       (x: 2752; y: 1222; w:  328; h:   92),
       (x: 3296; y: 1030; w:  242; h:  222),
       (x: 3298; y: 1316; w:  254; h:   50),
       (x: 3308; y: 1424; w:    2; h:    2),
       (x: NTPX; y:    0; w:    1; h:    1)
      );
      Template28FPoints: array[0..0] of TPoint =
      (
       (x: 2047; y:    0)
      );

const Template29Points: array[0..37] of TSDL_Rect =
      (
       (x:  554; y: 1424; w:    1; h:    1),
       (x:  432; y: 1326; w:  226; h:   60),
       (x:  320; y: 1246; w:  298; h:   62),
       (x:  480; y: 1104; w:  210; h:  102),
       (x:  408; y:  822; w:  192; h:  248),
       (x:  492; y:  560; w:  206; h:  240),
       (x:  726; y:  572; w:   92; h:  334),
       (x:  662; y:  928; w:  226; h:  126),
       (x:  756; y: 1078; w:  268; h:  156),
       (x:  922; y:  564; w:  138; h:  500),
       (x: 1090; y:  556; w:   94; h:  352),
       (x: 1098; y:  962; w:  170; h:  264),
       (x: 1292; y:  784; w:   84; h:  446),
       (x: 1406; y:  600; w:  158; h:  278),
       (x: 1500; y:  890; w:  104; h:  336),
       (x: 1616; y:  946; w:   90; h:  398),
       (x: 1746; y:  592; w:  134; h:  532),
       (x: 1902; y:  646; w:  156; h:  258),
       (x: 1900; y:  948; w:  132; h:  340),
       (x: 1734; y: 1298; w:  252; h:   82),
       (x: 1804; y: 1424; w:    1; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x: 2096; y: 1424; w:  140; h:    2),
       (x: 1930; y: 1272; w:  196; h:   32),
       (x: 1904; y: 1080; w:  262; h:  134),
       (x: 2304; y: 1072; w:  220; h:  136),
       (x: 2258; y:  890; w:  268; h:  110),
       (x: 1950; y:  762; w:  104; h:  200),
       (x: 2096; y:  624; w:  306; h:   58),
       (x: 2566; y:  588; w:   84; h:  206),
       (x: 2798; y:  574; w:  104; h:  220),
       (x: 3076; y:  576; w:  120; h:  202),
       (x: 3206; y:  818; w:  192; h:   68),
       (x: 2876; y:  948; w:  246; h:   88),
       (x: 2906; y: 1106; w:  194; h:  150),
       (x: 3218; y: 1106; w:  198; h:  152),
       (x: 3094; y: 1424; w:    2; h:    2),
       (x: NTPX; y:    0; w:    1; h:    1)
      );
      Template29FPoints: array[0..0] of TPoint =
      (
       (x: 2047; y:    0)
      );

const Template30Points: array[0..30] of TSDL_Rect =
      (
       (x:  548; y: 1424; w:    1; h:    1),
       (x:  436; y: 1252; w:  208; h:   72),
       (x:  698; y: 1110; w:  308; h:   60),
       (x:  928; y: 1252; w:  434; h:   40),
       (x: 1374; y: 1112; w:  332; h:   40),
       (x: 1602; y: 1238; w:  226; h:   36),
       (x: 1730; y: 1424; w:    1; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x: 1860; y:  898; w:  111; h:  111),
       (x: 1470; y:  876; w:   34; h:  102),
       (x:  882; y:  814; w:  284; h:  132),
       (x:  430; y:  728; w:  126; h:  168),
       (x:  610; y:  574; w:  114; h:  100),
       (x:  990; y:  572; w:  352; h:  120),
       (x: 1474; y:  528; w:   60; h:  240),
       (x: 1634; y:  622; w:  254; h:  116),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x: 1960; y: 1424; w:    2; h:    2),
       (x: 1842; y: 1030; w:   46; h:  286),
       (x: 2054; y: 1072; w:  194; h:   56),
       (x: 1854; y:  734; w:  534; h:  200),
       (x: 2470; y:  676; w:   58; h:  468),
       (x: 2676; y:  672; w:  198; h:  112),
       (x: 2600; y: 1424; w:   64; h:    2),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x: 2844; y: 1424; w:   64; h:    2),
       (x: 2956; y:  894; w:  184; h:   94),
       (x: 3200; y:  814; w:   76; h:  358),
       (x: 3348; y:  984; w:  108; h:  304),
       (x: 3288; y: 1424; w:  176; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1)
      );
      Template30FPoints: array[0..0] of TPoint =
      (
       (x: 2047; y:    0)
      );

const Template31Points: array[0..32] of TSDL_Rect =
      (
       (x:  618; y: 1424; w:    1; h:    1),
       (x:  448; y: 1300; w:  186; h:   62),
       (x:  472; y: 1092; w:  254; h:  138),
       (x:  810; y: 1168; w:   90; h:  166),
       (x: 1020; y: 1016; w:  224; h:  258),
       (x: 1442; y: 1158; w:   96; h:  146),
       (x: 1750; y: 1098; w:  224; h:  134),
       (x: 1730; y: 1302; w:  210; h:   54),
       (x: 1732; y: 1424; w:    1; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x:  402; y:  818; w:  110; h:   92),
       (x:  452; y:  712; w:  160; h:   32),
       (x:  350; y:  568; w:  134; h:   78),
       (x:  902; y:  560; w:  132; h:   84),
       (x:  902; y:  708; w:  230; h:   36),
       (x:  920; y:  808; w:  166; h:   96),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x: 1902; y:  834; w:  202; h:   42),
       (x: 1452; y:  788; w:  134; h:   98),
       (x: 1414; y:  552; w:  116; h:  154),
       (x: 1628; y:  652; w:  150; h:   70),
       (x: 1950; y:  552; w:   86; h:  220),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x: 2274; y: 1424; w:  166; h:    1),
       (x: 2330; y: 1262; w:   96; h:   92),
       (x: 2492; y: 1090; w:  152; h:  250),
       (x: 2746; y: 1046; w:   36; h:  270),
       (x: 2938; y: 1026; w:   54; h:  224),
       (x: 3134; y: 1046; w:   44; h:  216),
       (x: 3292; y: 1030; w:   46; h:  300),
       (x: 3448; y: 1064; w:  158; h:  272),
       (x: 3584; y: 1424; w:  136; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1)
      );
      Template31FPoints: array[0..0] of TPoint =
      (
       (x: 2047; y:    0)
      );

const Template32Points: array[0..29] of TSDL_Rect =
      (
       (x:  474; y: 1424; w:    1; h:    1),
       (x:  390; y: 1318; w:  168; h:   26),
       (x:  582; y:  976; w:  122; h:  314),
       (x:  768; y: 1144; w:   56; h:  180),
       (x:  878; y: 1256; w:   64; h:   56),
       (x:  940; y: 1050; w:  106; h:  220),
       (x:  844; y:  896; w:  162; h:  140),
       (x:  696; y:  610; w:  886; h:  174),
       (x: 1134; y:  848; w:  296; h:  108),
       (x: 1150; y: 1152; w:  152; h:  146),
       (x: 1372; y: 1174; w:   60; h:  152),
       (x: 1484; y: 1122; w:  150; h:  138),
       (x: 1694; y:  764; w:   56; h:  582),
       (x: 1820; y: 1174; w:   94; h:  232),
       (x: 1812; y: 1424; w:    1; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x: 2088; y: 1424; w:  190; h:    1),
       (x: 2140; y: 1082; w:  140; h:  150),
       (x: 2214; y:  868; w:  352; h:   94),
       (x: 2626; y:  646; w:  106; h:  282),
       (x: 2802; y:  790; w:  368; h:  142),
       (x: 2858; y:  988; w:  116; h:  244),
       (x: 2776; y: 1424; w:   14; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x: 2964; y: 1424; w:   22; h:    1),
       (x: 3188; y: 1195; w:  120; h:  120),
       (x: 3358; y:  674; w:  354; h:  448),
       (x: 3588; y: 1195; w:  120; h:  120),
       (x: 3682; y: 1424; w:    2; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1)
      );
      Template32FPoints: array[0..0] of TPoint =
      (
         (x: 2047; y:    0)
      );

const Template33Points: array[0..45] of TSDL_Rect =
      (
       (x:  568; y: 1422; w:    2; h:    2),
       (x:  466; y: 1240; w:  302; h:  110),
       (x:  494; y:  912; w:  104; h:  290),
       (x:  770; y:  980; w:  364; h:  122),
       (x:  768; y:  840; w:  368; h:  100),
       (x:  432; y:  660; w:  482; h:  130),
       (x:  978; y:  642; w:   62; h:   64),
       (x: 1190; y:  554; w:   58; h:  246),
       (x: 1400; y:  676; w:  590; h:   98),
       (x: 1288; y:  842; w:  214; h:  188),
       (x: 1250; y: 1086; w:  406; h:   92),
       (x: 1784; y:  902; w:  190; h:  412),
       (x: 1846; y: 1420; w:    2; h:    2),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x: 2140; y: 1424; w:    1; h:    1),
       (x: 2076; y: 1302; w:   44; h:   54),
       (x: 2234; y: 1236; w:   58; h:   90),
       (x: 2066; y: 1134; w:   80; h:   80),
       (x: 2046; y: 1004; w:   96; h:  108),
       (x: 2226; y: 1046; w:  110; h:  112),
       (x: 2034; y:  692; w:  118; h:  164),
       (x: 2228; y:  796; w:  130; h:  110),
       (x: 2316; y:  598; w:  344; h:   78),
       (x: 2488; y:  826; w:   50; h:   40),
       (x: 2426; y:  960; w:   32; h:  148),
       (x: 2498; y: 1050; w:  160; h:   34),
       (x: 2474; y: 1188; w:   36; h:  136),
       (x: 2814; y: 1248; w:   48; h:   48),
       (x: 2886; y: 1128; w:   64; h:   88),
       (x: 2758; y: 1060; w:   70; h:   74),
       (x: 2916; y:  996; w:   68; h:   70),
       (x: 2918; y:  884; w:   68; h:   82),
       (x: 2758; y:  724; w:   44; h:  140),
       (x: 3072; y:  706; w:   52; h:   66),
       (x: 3054; y:  902; w:   58; h:   66),
       (x: 3034; y: 1160; w:   76; h:  112),
       (x: 3180; y: 1162; w:  124; h:   64),
       (x: 3272; y:  872; w:   54; h:  134),
       (x: 3210; y:  596; w:  246; h:   62),
       (x: 3506; y:  554; w:   38; h:  238),
       (x: 3612; y:  748; w:   28; h:   28),
       (x: 3492; y:  924; w:  144; h:   94),
       (x: 3432; y: 1078; w:  248; h:   20),
       (x: 3432; y: 1202; w:  238; h:   16),
       (x: 3480; y: 1424; w:    1; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1)
      );
      Template33FPoints: array[0..0] of TPoint =
      (
       (x: 2047; y:    0)
      );

const Template34Points: array[0..25] of TSDL_Rect =
      (
       (x:  362; y: 1424; w:  400; h:    1),
       (x:  426; y:  634; w:  142; h:  360),
       (x: 1136; y: 1140; w:  400; h:  200),
       (x: 1776; y:  576; w:  186; h:  550),
       (x: 1630; y: 1424; w:  454; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x: 1964; y: 1424; w:   20; h:    1),
       (x: 1890; y: 1260; w:   64; h:   62),
       (x: 2086; y: 1150; w:   52; h:  146),
       (x: 1856; y:  990; w:  116; h:  144),
       (x: 2070; y:  868; w:  138; h:  168),
       (x: 1842; y:  642; w:  158; h:  162),
       (x: 2108; y:  710; w:  198; h:   72),
       (x: 2370; y:  628; w:  118; h:  134),
       (x: 2236; y: 1118; w:  142; h:  132),
       (x: 2568; y: 1100; w:  172; h:   58),
       (x: 2570; y: 1204; w:  172; h:   62),
       (x: 2832; y: 1104; w:   82; h:  226),
       (x: 2956; y:  994; w:   64; h:  152),
       (x: 2814; y:  734; w:  106; h:  152),
       (x: 3010; y:  660; w:  380; h:   82),
       (x: 3128; y:  822; w:   30; h:  118),
       (x: 3140; y:  988; w:  212; h:   50),
       (x: 3064; y: 1146; w:  128; h:  146),
       (x: 3230; y: 1424; w:   20; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1)
      );
      Template34FPoints: array[0..0] of TPoint =
      (
       (x: 2047; y:    0)
      );

const Template35Points: array[0..48] of TSDL_Rect =
      (
       (x:  564; y: 1424; w:   20; h:    1),
       (x:  490; y: 1260; w:   64; h:   62),
       (x:  686; y: 1150; w:   52; h:  146),
       (x:  456; y:  990; w:  116; h:  144),
       (x:  670; y:  868; w:  138; h:  168),
       (x:  442; y:  642; w:  158; h:  162),
       (x:  708; y:  710; w:  198; h:   72),
       (x:  970; y:  628; w:  118; h:  134),
       (x:  836; y: 1118; w:  142; h:  132),
       (x: 1168; y: 1100; w:  172; h:   58),
       (x: 1170; y: 1204; w:  172; h:   62),
       (x: 1432; y: 1104; w:   82; h:  226),
       (x: 1556; y:  994; w:   64; h:  152),
       (x: 1414; y:  734; w:  106; h:  152),
       (x: 1610; y:  660; w:  380; h:   82),
       (x: 1728; y:  822; w:   30; h:  118),
       (x: 1740; y:  988; w:  212; h:   50),
       (x: 1664; y: 1146; w:  128; h:  146),
       (x: 1830; y: 1424; w:   20; h:    1),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x: 2100; y: 1424; w:    2; h:    2),
       (x: 2194; y: 1302; w:   58; h:   62),
       (x: 2180; y: 1170; w:   94; h:   90),
       (x: 1986; y: 1026; w:   80; h:  220),
       (x: 2176; y: 1000; w:   82; h:  118),
       (x: 1982; y:  728; w:  134; h:  226),
       (x: 2168; y:  728; w:   52; h:   52),
       (x: 2272; y:  574; w:   56; h:  212),
       (x: 2388; y:  722; w:   60; h:   62),
       (x: 2518; y:  724; w:  108; h:  218),
       (x: 2412; y:  916; w:   36; h:  168),
       (x: 2528; y: 1056; w:  140; h:  134),
       (x: 2388; y: 1250; w:   74; h:   82),
       (x: 2550; y: 1424; w:  102; h:    2),
       (x: NTPX; y:    0; w:    1; h:    1),
       (x: 3104; y: 1424; w:   72; h:    2),
       (x: 3026; y: 1308; w:  266; h:   34),
       (x: 3024; y: 1148; w:  252; h:   80),
       (x: 3012; y:  976; w:  256; h:   94),
       (x: 2940; y:  834; w:  174; h:   86),
       (x: 3196; y:  718; w:  156; h:   96),
       (x: 2886; y:  614; w:  206; h:   66),
       (x: 3246; y:  556; w:  152; h:   40),
       (x: 3508; y:  672; w:   60; h:  162),
       (x: 3342; y:  888; w:  146; h:   80),
       (x: 3486; y: 1034; w:  178; h:  122),
       (x: 3372; y: 1220; w:   34; h:  124),
       (x: 3498; y: 1424; w:   52; h:    2),
       (x: NTPX; y:    0; w:    1; h:    1)
      );
      Template35FPoints: array[0..0] of TPoint =
      (
       (x: 2047; y:    0)
      );

///////////////////////// CAVERNS ///////////////////////////////////
const Template36Points: array[0..18] of TSDL_Rect =
      (
       (x:  324; y:  756; w:  196; h:  204),
       (x:  224; y:  596; w:  404; h:   60),
       (x:  240; y:  268; w:  464; h:  152),
       (x:  876; y:  236; w:  168; h:  348),
       (x: 1204; y:   56; w:  148; h:  700),
       (x: 1516; y:   52; w:  192; h:  664),
       (x: 1808; y:   60; w:  328; h:  496),
       (x: 2292; y:   92; w:  184; h:  492),
       (x: 2664; y:  216; w:  196; h:  340),
       (x: 3004; y:  108; w:  176; h:  480),
       (x: 3260; y:  368; w:  120; h:  348),
       (x: 3476; y:  460; w:  208; h:  448),
       (x: 3268; y:  906; w:  192; h:   96),
       (x: 2876; y:  664; w:  204; h:  310),
       (x: 2240; y:  748; w:  344; h:  224),
       (x: 1584; y:  796; w:  440; h:  250),
       (x:  892; y:  852; w:  324; h:  184),
       (x:  576; y:  976; w:   16; h:   28),
       (x: NTPX; y:    0; w:    1; h:    1)
      );
      Template36FPoints: array[0..0] of TPoint =
      (
       (x: 2047; y:    0)
      );
////////////////////////////// ... Silly ...  ////////////////////////////////
/// Ok. Tiy does not care for these.  Perhaps they could be saved.
/// For now, just rare.
//////////////////////////////////////////////////////////////////////////////

// maybe Tiy would be ok with this if it was smoother/more climable and a bit shorter?
const Template37Points: array[0..27] of TSDL_Rect =
      (
       (x:  700; y: 2100; w: 20; h: 75),
       (x:  800; y: 1200; w: 20; h: 75),
       (x:  900; y:  400; w: 20; h: 50),
       (x: 1100; y:  600; w: 20; h: 50),
       (x: 1300; y:  900; w: 20; h: 50),
       (x: 1000; y: 1000; w: 20; h: 50),
       (x: 1700; y: 1850; w: 20; h: 75),
       (x: 2048; y: 2100; w: 20; h: 75),
       (x: NTPX; y:    0; w:  1; h:  1),
       (x: 2048; y: 2100; w: 20; h: 50),
       (x: 2400; y: 1850; w: 20; h: 50),
       (x: 2600; y: 1000; w: 20; h: 75),
       (x: 2800; y:  900; w: 20; h: 50),
       (x: 3000; y:  600; w: 20; h: 50),
       (x: 3200; y:  400; w: 20; h: 50),
       (x: 3300; y: 1200; w: 20; h: 50),
       (x: 3400; y: 2100; w: 20; h: 75),
       (x: NTPX; y:    0; w:  1; h:  1),
       (x: 1450; y:  700; w: 25; h: 25),
       (x: 1850; y:  650; w: 25; h: 25),
       (x: 2250; y:  800; w: 25; h: 25),
       (x: 2500; y:  700; w: 25; h: 25),
       (x: NTPX; y:    0; w:  1; h:  1),
       (x: 1550; y: 1500; w: 25; h: 25),
       (x: 1830; y: 1150; w: 25; h: 25),
       (x: 2260; y: 1000; w: 25; h: 25),
       (x: 2250; y: 1200; w: 25; h: 25),
       (x: NTPX; y:    0; w:  1; h:  1)
      );
      Template37FPoints: array[0..0] of TPoint =
      (
       (x: 2047; y:    0)
      );
// attempt to make a series of moderate hills/valleys - was before I really figured out the whole probabilities thing
const Template38Points: array[0..16] of TSDL_Rect =
      (
       (x:  100; y: 2100; w:   1; h:    1),
       (x:  100; y: 1600; w: 300; h:  500),
       (x:  400; y:  600; w: 300; h: 1500),
       (x:  700; y: 1600; w: 300; h:  600),
       (x: 1000; y: 1800; w: 300; h:  300),
       (x: 1300; y:  500; w: 300; h: 1600),
       (x: 1600; y: 1700; w: 300; h:  400),
       (x: 1600; y: 1600; w: 300; h:  500),
       (x: 1600; y: 1400; w: 300; h:  700),
       (x: 2200; y:  300; w: 300; h: 1800),
       (x: 2500; y: 1500; w: 300; h:  600),
       (x: 2800; y: 1900; w: 300; h:  200),
       (x: 3100; y: 1600; w: 300; h:  500),
       (x: 3400; y:  600; w: 300; h: 1500),
       (x: 3700; y: 1800; w: 200; h:  300),
       (x: 3700; y: 2100; w:   1; h:    1),
       (x: NTPX; y:    0; w:   1; h:    1)
      );
      Template38FPoints: array[0..0] of TPoint =
      (
       (x: 2047; y:    0)
      );

// 8 tiny islands
const Template39Points: array[0..39] of TSDL_Rect =
      (
       (x:   90; y: 520; w:   1; h:   1),
       (x:   90; y: 350; w:  10; h: 150),
       (x:  170; y: 350; w:  10; h: 150),
       (x:  170; y: 520; w:   1; h:   1),
       (x: NTPX; y:   0; w:   1; h:   1),
       (x:  270; y: 520; w:   1; h:   1),
       (x:  270; y: 350; w:  10; h: 150),
       (x:  350; y: 350; w:  10; h: 150),
       (x:  350; y: 520; w:   1; h:   1),
       (x: NTPX; y:   0; w:   1; h:   1),
       (x:  450; y: 520; w:   1; h:   1),
       (x:  450; y: 350; w:  10; h: 150),
       (x:  530; y: 350; w:  10; h: 150),
       (x:  530; y: 520; w:   1; h:   1),
       (x: NTPX; y:   0; w:   1; h:   1),
       (x:  630; y: 520; w:   1; h:   1),
       (x:  630; y: 350; w:  10; h: 150),
       (x:  710; y: 350; w:  10; h: 150),
       (x:  710; y: 520; w:   1; h:   1),
       (x: NTPX; y:   0; w:   1; h:   1),
       (x:  810; y: 520; w:   1; h:   1),
       (x:  810; y: 350; w:  10; h: 150),
       (x:  890; y: 350; w:  10; h: 150),
       (x:  890; y: 520; w:   1; h:   1),
       (x: NTPX; y:   0; w:   1; h:   1),
       (x:  990; y: 520; w:   1; h:   1),
       (x:  990; y: 350; w:  10; h: 150),
       (x: 1070; y: 350; w:  10; h: 150),
       (x: 1070; y: 520; w:   1; h:   1),
       (x: NTPX; y:   0; w:   1; h:   1),
       (x: 1170; y: 520; w:   1; h:   1),
       (x: 1170; y: 350; w:  10; h: 150),
       (x: 1250; y: 350; w:  10; h: 150),
       (x: 1250; y: 520; w:   1; h:   1),
       (x: NTPX; y:   0; w:   1; h:   1),
       (x: 1350; y: 520; w:   1; h:   1),
       (x: 1350; y: 350; w:  10; h: 150),
       (x: 1430; y: 350; w:  10; h: 150),
       (x: 1430; y: 520; w:   1; h:   1),
       (x: NTPX; y:   0; w:   1; h:   1)
      );
      Template39FPoints: array[0..0] of TPoint =
      (
       (x: 512; y:    0)
      );
const Template40Points: array[0..7] of TSDL_Rect =
      (
       (x:   90; y: 1050; w:    1; h:   1),
       (x:  100; y:  800; w:  100; h: 200),
       (x:  300; y:  600; w:  100; h: 200),
       (x:  500; y:  200; w:  100; h: 200),
       (x:  700; y:  600; w:  100; h: 100),
       (x:  900; y:  800; w:  100; h: 200),
       (x:  900; y: 1050; w:    1; h:   1),
       (x: NTPX; y:    0; w:    1; h:   1)
      );
      Template40FPoints: array[0..0] of TPoint =
      (
       (x: 512; y:    0)
      );
// Many islands
const Template41Points: array[0..86] of TSDL_Rect =
      (
       (x:   95; y: 500; w:   1; h:   1),
       (x:  100; y: 275; w:  25; h: 100),
       (x:  325; y: 275; w:  25; h: 100),
       (x:  330; y: 500; w:   1; h:   1),
       (x: NTPX; y:   0; w:   1; h:   1),
       (x:  725; y: 125; w:   1; h:   1),
       (x:  725; y:  25; w:   5; h:  25),
       (x:  825; y:  35; w:   5; h:  10),
       (x:  825; y: 135; w:   1; h:   1),
       (x: NTPX; y:   0; w:   1; h:   1),
       (x: 1150; y: 550; w:  25; h:  50),
       (x: 1250; y: 300; w:  25; h:  50),
       (x: 1350; y: 300; w:  25; h:  50),
       (x: 1400; y: 575; w:  25; h:  50),
       (x: NTPX; y:   0; w:   1; h:   1),
       (x:  525; y:1050; w:  50; h:  50),
       (x:  700; y: 800; w: 100; h: 150),
       (x:  950; y: 900; w: 100; h: 150),
       (x: 1100; y:1100; w:  50; h:  50),
       (x: NTPX; y:   0; w:   1; h:   1),
       (x:  175; y:1500; w:   1; h:   1),
       (x:  210; y:1400; w:   5; h:  25),
       (x:  240; y:1400; w:   5; h:  25),
       (x:  275; y:1510; w:   1; h:   1),
       (x: NTPX; y:   0; w:   1; h:   1),
       (x:  450; y:1800; w: 100; h: 100),
       (x:  600; y:1750; w: 100; h: 100),
       (x:  750; y:1750; w: 100; h: 100),
       (x:  950; y:1850; w: 100; h: 100),
       (x: NTPX; y:   0; w:   1; h:   1),
       (x: 1075; y:1450; w:   1; h:   1),
       (x: 1110; y:1300; w:   5; h:  25),
       (x: 1140; y:1300; w:   5; h:  25),
       (x: 1175; y:1430; w:   1; h:   1),
       (x: NTPX; y:   0; w:   1; h:   1),
       (x: 1600; y:1250; w:  25; h: 100),
       (x: 1700; y:1150; w:  25; h: 100),
       (x: 1850; y: 500; w:  50; h: 100),
       (x: 1950; y: 550; w:  50; h: 150),
       (x: 2250; y:1150; w:  25; h: 100),
       (x: 2350; y:1250; w:  25; h: 100),
       (x: NTPX; y:   0; w:   1; h:   1),
       (x: 1750; y:2010; w:   1; h:   1),
       (x: 1900; y:1870; w:  50; h:  50),
       (x: 2050; y:1870; w:  50; h:  50),
       (x: 2175; y:2010; w:   1; h:   1),
       (x: NTPX; y:   0; w:   1; h:   1),
       (x: 2500; y:1700; w:   1; h:   1),
       (x: 2575; y:1500; w:  10; h:  50),
       (x: 2650; y:1500; w:  10; h:  50),
       (x: 2700; y:1690; w:   1; h:   1),
       (x: NTPX; y:   0; w:   1; h:   1),
       (x: 2000; y: 125; w:   1; h:   1),
       (x: 2050; y:  50; w:  25; h:  25),
       (x: 2100; y:  50; w:  25; h:  25),
       (x: 2150; y: 150; w:   1; h:   1),
       (x: NTPX; y:   0; w:   1; h:   1),
       (x: 2600; y: 250; w:  25; h: 100),
       (x: 2750; y: 400; w:  50; h:  50),
       (x: 2900; y: 525; w:  50; h:  50),
       (x: 3150; y: 550; w:  50; h: 100),
       (x: NTPX; y:   0; w:   1; h:   1),
       (x: 2800; y:1150; w:   1; h:   1),
       (x: 2840; y: 950; w:  25; h:  25),
       (x: 2880; y: 950; w:  25; h:  25),
       (x: 2900; y:1150; w:   1; h:   1),
       (x: NTPX; y:   0; w:   1; h:   1),
       (x: 3075; y:1985; w:   1; h:   1),
       (x: 3325; y:1700; w:  50; h: 100),
       (x: 3475; y:1700; w:  50; h: 100),
       (x: 3625; y:1985; w:   1; h:   1),
       (x: NTPX; y:   0; w:   1; h:   1),
       (x: 3200; y:1450; w:   1; h:   1),
       (x: 3240; y:1350; w:  25; h:  25),
       (x: 3280; y:1350; w:  25; h:  25),
       (x: 3300; y:1450; w:   1; h:   1),
       (x: NTPX; y:   0; w:   1; h:   1),
       (x: 3500; y:1050; w:  25; h:  50),
       (x: 3650; y: 600; w:  50; h: 100),
       (x: 3800; y: 600; w:  50; h: 100),
       (x: 3900; y:1000; w:  25; h:  50),
       (x: NTPX; y:   0; w:   1; h:   1),
       (x: 3800; y: 200; w:  25; h:  50),
       (x: 3875; y: 100; w:  50; h:  50),
       (x: 3925; y:  50; w:  50; h:  25),
       (x: 4050; y: 125; w:  25; h:  50),
       (x: NTPX; y:   0; w:   1; h:   1)
      );
      Template41FPoints: array[0..0] of TPoint =
      (
       (x: 2047; y:    0)
      );
// 2 tiny islands
const Template42Points: array[0..13] of TSDL_Rect =
      (
       (x:   90; y: 520; w:   1; h:   1),
       (x:   90; y:  50; w:  10; h:  50),
       (x:  170; y: 200; w:  10; h:  50),
       (x:  270; y: 350; w:  10; h:  50),
       (x:  350; y: 150; w:  10; h:  50),
       (x:  350; y: 520; w:   1; h:   1),
       (x: NTPX; y:   0; w:   1; h:   1),
       (x: 1170; y: 520; w:   1; h:   1),
       (x: 1170; y: 150; w:  10; h:  50),
       (x: 1250; y: 350; w:  10; h:  50),
       (x: 1350; y: 200; w:  10; h:  50),
       (x: 1430; y:  50; w:  10; h:  50),
       (x: 1430; y: 520; w:   1; h:   1),
       (x: NTPX; y:   0; w:   1; h:   1)
      );
      Template42FPoints: array[0..0] of TPoint =
      (
       (x: 512; y:    0)
      );

////////////////////////////////////////////////////////////////////////
const EdgeTemplates: array[0..42] of TEdgeTemplate =
      (
       (BasePoints: @Template0Points;
        BasePointsCount: Succ(High(Template0Points));
        FillPoints: @Template0FPoints;
        FillPointsCount: Succ(High(Template0FPoints));
        BezierizeCount: 3;
        RandPassesCount: 8;
        TemplateHeight: 1424; TemplateWidth: 2848;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: true;
        MaxHedgehogs: 18;
       ),
       (BasePoints: @Template1Points;
        BasePointsCount: Succ(High(Template1Points));
        FillPoints: @Template1FPoints;
        FillPointsCount: Succ(High(Template1FPoints));
        BezierizeCount: 3;
        RandPassesCount: 7;
        TemplateHeight: 1424; TemplateWidth: 2848;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: true;
        MaxHedgehogs: 18;
       ),
       (BasePoints: @Template2Points;
        BasePointsCount: Succ(High(Template2Points));
        FillPoints: @Template2FPoints;
        FillPointsCount: Succ(High(Template2FPoints));
        BezierizeCount: 2;
        RandPassesCount: 6;
        TemplateHeight: 1424; TemplateWidth: 2848;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: true;
        MaxHedgehogs: 18;
       ),
       (BasePoints: @Template3Points;
        BasePointsCount: Succ(High(Template3Points));
        FillPoints: @Template3FPoints;
        FillPointsCount: Succ(High(Template3FPoints));
        BezierizeCount: 3;
        RandPassesCount: 4;
        TemplateHeight: 1424; TemplateWidth: 2848;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: true;
        MaxHedgehogs: 18;
       ),
       (BasePoints: @Template4Points;
        BasePointsCount: Succ(High(Template4Points));
        FillPoints: @Template4FPoints;
        FillPointsCount: Succ(High(Template4FPoints));
        BezierizeCount: 3;
        RandPassesCount: 4;
        TemplateHeight: 1424; TemplateWidth: 2848;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: true;
        MaxHedgehogs: 18;
       ),
       (BasePoints: @Template5Points;
        BasePointsCount: Succ(High(Template5Points));
        FillPoints: @Template5FPoints;
        FillPointsCount: Succ(High(Template5FPoints));
        BezierizeCount: 2;
        RandPassesCount: 8;
        TemplateHeight: 1424; TemplateWidth: 2848;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: true;
        MaxHedgehogs: 18;
       ),
       (BasePoints: @Template6Points;
        BasePointsCount: Succ(High(Template6Points));
        FillPoints: @Template6FPoints;
        FillPointsCount: Succ(High(Template6FPoints));
        BezierizeCount: 2;
        RandPassesCount: 5;
        TemplateHeight: 1424; TemplateWidth: 2848;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: true;
        MaxHedgehogs: 18;
       ),
       (BasePoints: @Template7Points;
        BasePointsCount: Succ(High(Template7Points));
        FillPoints: @Template7FPoints;
        FillPointsCount: Succ(High(Template7FPoints));
        BezierizeCount: 4;
        RandPassesCount: 4;
        TemplateHeight: 1424; TemplateWidth: 2848;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: true;
        MaxHedgehogs: 18;
       ),
       (BasePoints: @Template8Points;
        BasePointsCount: Succ(High(Template8Points));
        FillPoints: @Template8FPoints;
        FillPointsCount: Succ(High(Template8FPoints));
        BezierizeCount: 2;
        RandPassesCount: 7;
        TemplateHeight: 1424; TemplateWidth: 2848;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: true;
        MaxHedgehogs: 18;
       ),
       (BasePoints: @Template9Points;
        BasePointsCount: Succ(High(Template9Points));
        FillPoints: @Template9FPoints;
        FillPointsCount: Succ(High(Template9FPoints));
        BezierizeCount: 1;
        RandPassesCount: 5;
        TemplateHeight: 1424; TemplateWidth: 2848;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: true;
        MaxHedgehogs: 18;
       ),
       (BasePoints: @Template10Points;
        BasePointsCount: Succ(High(Template10Points));
        FillPoints: @Template10FPoints;
        FillPointsCount: Succ(High(Template10FPoints));
        BezierizeCount: 2;
        RandPassesCount: 6;
        TemplateHeight: 1424; TemplateWidth: 2848;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: true;
        MaxHedgehogs: 18;
       ),
       (BasePoints: @Template11Points;
        BasePointsCount: Succ(High(Template11Points));
        FillPoints: @Template11FPoints;
        FillPointsCount: Succ(High(Template11FPoints));
        BezierizeCount: 1;
        RandPassesCount: 8;
        TemplateHeight: 1424; TemplateWidth: 2848;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: true;
        MaxHedgehogs: 18;
       ),
       (BasePoints: @Template12Points;
        BasePointsCount: Succ(High(Template12Points));
        FillPoints: @Template12FPoints;
        FillPointsCount: Succ(High(Template12FPoints));
        BezierizeCount: 3;
        RandPassesCount: 8;
        TemplateHeight: 1424; TemplateWidth: 2848;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: true;
        MaxHedgehogs: 18;
       ),
       (BasePoints: @Template13Points;
        BasePointsCount: Succ(High(Template13Points));
        FillPoints: @Template13FPoints;
        FillPointsCount: Succ(High(Template13FPoints));
        BezierizeCount: 3;
        RandPassesCount: 5;
        TemplateHeight: 1424; TemplateWidth: 2848;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: true;
        MaxHedgehogs: 18;
       ),
       (BasePoints: @Template14Points;
        BasePointsCount: Succ(High(Template14Points));
        FillPoints: @Template14FPoints;
        FillPointsCount: Succ(High(Template14FPoints));
        BezierizeCount: 3;
        RandPassesCount: 7;
        TemplateHeight: 1424; TemplateWidth: 2848;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: true;
        MaxHedgehogs: 18;
       ),
       (BasePoints: @Template15Points;
        BasePointsCount: Succ(High(Template15Points));
        FillPoints: @Template15FPoints;
        FillPointsCount: Succ(High(Template15FPoints));
        BezierizeCount: 2;
        RandPassesCount: 6;
        TemplateHeight: 1424; TemplateWidth: 2848;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: true;
        MaxHedgehogs: 18;
       ),
       (BasePoints: @Template16Points;
        BasePointsCount: Succ(High(Template16Points));
        FillPoints: @Template16FPoints;
        FillPointsCount: Succ(High(Template16FPoints));
        BezierizeCount: 2;
        RandPassesCount: 6;
        TemplateHeight: 1424; TemplateWidth: 2848;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: true;
        MaxHedgehogs: 18;
       ),
       (BasePoints: @Template17Points;
        BasePointsCount: Succ(High(Template17Points));
        FillPoints: @Template17FPoints;
        FillPointsCount: Succ(High(Template17FPoints));
        BezierizeCount: 3;
        RandPassesCount: 7;
        TemplateHeight: 1424; TemplateWidth: 2848;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: true;
        MaxHedgehogs: 18;
       ),
       (BasePoints: @Template18Points;
        BasePointsCount: Succ(High(Template18Points));
        FillPoints: @Template18FPoints;
        FillPointsCount: Succ(High(Template18FPoints));
        BezierizeCount: 3;
        RandPassesCount: 8;
        TemplateHeight: 1424; TemplateWidth: 3900;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: true;
        MaxHedgehogs: 36;
       ),
       (BasePoints: @Template19Points;
        BasePointsCount: Succ(High(Template19Points));
        FillPoints: @Template19FPoints;
        FillPointsCount: Succ(High(Template19FPoints));
        BezierizeCount: 3;
        RandPassesCount: 7;
        TemplateHeight: 1424; TemplateWidth: 3900;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: true;
        MaxHedgehogs: 36;
       ),
       (BasePoints: @Template20Points;
        BasePointsCount: Succ(High(Template20Points));
        FillPoints: @Template20FPoints;
        FillPointsCount: Succ(High(Template20FPoints));
        BezierizeCount: 2;
        RandPassesCount: 6;
        TemplateHeight: 1424; TemplateWidth: 3900;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: true;
        MaxHedgehogs: 36;
       ),
       (BasePoints: @Template21Points;
        BasePointsCount: Succ(High(Template21Points));
        FillPoints: @Template21FPoints;
        FillPointsCount: Succ(High(Template21FPoints));
        BezierizeCount: 3;
        RandPassesCount: 4;
        TemplateHeight: 1424; TemplateWidth: 3900;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: true;
        MaxHedgehogs: 36;
       ),
       (BasePoints: @Template22Points;
        BasePointsCount: Succ(High(Template22Points));
        FillPoints: @Template22FPoints;
        FillPointsCount: Succ(High(Template22FPoints));
        BezierizeCount: 3;
        RandPassesCount: 4;
        TemplateHeight: 1424; TemplateWidth: 3900;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: true;
        MaxHedgehogs: 36;
       ),
       (BasePoints: @Template23Points;
        BasePointsCount: Succ(High(Template23Points));
        FillPoints: @Template23FPoints;
        FillPointsCount: Succ(High(Template23FPoints));
        BezierizeCount: 2;
        RandPassesCount: 8;
        TemplateHeight: 1424; TemplateWidth: 3900;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: true;
        MaxHedgehogs: 36;
       ),
       (BasePoints: @Template24Points;
        BasePointsCount: Succ(High(Template24Points));
        FillPoints: @Template24FPoints;
        FillPointsCount: Succ(High(Template24FPoints));
        BezierizeCount: 2;
        RandPassesCount: 5;
        TemplateHeight: 1424; TemplateWidth: 3900;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: true;
        MaxHedgehogs: 36;
       ),
       (BasePoints: @Template25Points;
        BasePointsCount: Succ(High(Template25Points));
        FillPoints: @Template25FPoints;
        FillPointsCount: Succ(High(Template25FPoints));
        BezierizeCount: 4;
        RandPassesCount: 4;
        TemplateHeight: 1424; TemplateWidth: 3900;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: true;
        MaxHedgehogs: 36;
       ),
       (BasePoints: @Template26Points;
        BasePointsCount: Succ(High(Template26Points));
        FillPoints: @Template26FPoints;
        FillPointsCount: Succ(High(Template26FPoints));
        BezierizeCount: 2;
        RandPassesCount: 7;
        TemplateHeight: 1424; TemplateWidth: 3900;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: true;
        MaxHedgehogs: 36;
       ),
       (BasePoints: @Template27Points;
        BasePointsCount: Succ(High(Template27Points));
        FillPoints: @Template27FPoints;
        FillPointsCount: Succ(High(Template27FPoints));
        BezierizeCount: 1;
        RandPassesCount: 5;
        TemplateHeight: 1424; TemplateWidth: 3900;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: true;
        MaxHedgehogs: 36;
       ),
       (BasePoints: @Template28Points;
        BasePointsCount: Succ(High(Template28Points));
        FillPoints: @Template28FPoints;
        FillPointsCount: Succ(High(Template28FPoints));
        BezierizeCount: 2;
        RandPassesCount: 6;
        TemplateHeight: 1424; TemplateWidth: 3900;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: true;
        MaxHedgehogs: 36;
       ),
       (BasePoints: @Template29Points;
        BasePointsCount: Succ(High(Template29Points));
        FillPoints: @Template29FPoints;
        FillPointsCount: Succ(High(Template29FPoints));
        BezierizeCount: 1;
        RandPassesCount: 8;
        TemplateHeight: 1424; TemplateWidth: 3900;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: true;
        MaxHedgehogs: 36;
       ),
       (BasePoints: @Template30Points;
        BasePointsCount: Succ(High(Template30Points));
        FillPoints: @Template30FPoints;
        FillPointsCount: Succ(High(Template30FPoints));
        BezierizeCount: 3;
        RandPassesCount: 8;
        TemplateHeight: 1424; TemplateWidth: 3900;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: true;
        MaxHedgehogs: 36;
       ),
       (BasePoints: @Template31Points;
        BasePointsCount: Succ(High(Template31Points));
        FillPoints: @Template31FPoints;
        FillPointsCount: Succ(High(Template31FPoints));
        BezierizeCount: 3;
        RandPassesCount: 5;
        TemplateHeight: 1424; TemplateWidth: 3900;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: true;
        MaxHedgehogs: 36;
       ),
       (BasePoints: @Template32Points;
        BasePointsCount: Succ(High(Template32Points));
        FillPoints: @Template32FPoints;
        FillPointsCount: Succ(High(Template32FPoints));
        BezierizeCount: 3;
        RandPassesCount: 7;
        TemplateHeight: 1424; TemplateWidth: 3900;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: true;
        MaxHedgehogs: 36;
       ),
       (BasePoints: @Template33Points;
        BasePointsCount: Succ(High(Template33Points));
        FillPoints: @Template33FPoints;
        FillPointsCount: Succ(High(Template33FPoints));
        BezierizeCount: 2;
        RandPassesCount: 6;
        TemplateHeight: 1424; TemplateWidth: 3900;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: true;
        MaxHedgehogs: 36;
       ),
       (BasePoints: @Template34Points;
        BasePointsCount: Succ(High(Template34Points));
        FillPoints: @Template34FPoints;
        FillPointsCount: Succ(High(Template34FPoints));
        BezierizeCount: 2;
        RandPassesCount: 6;
        TemplateHeight: 1424; TemplateWidth: 3900;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: true;
        MaxHedgehogs: 36;
       ),
       (BasePoints: @Template35Points;
        BasePointsCount: Succ(High(Template35Points));
        FillPoints: @Template35FPoints;
        FillPointsCount: Succ(High(Template35FPoints));
        BezierizeCount: 3;
        RandPassesCount: 7;
        TemplateHeight: 1424; TemplateWidth: 3900;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: true;
        MaxHedgehogs: 36;
       ),
       (BasePoints: @Template36Points;
        BasePointsCount: Succ(High(Template36Points));
        FillPoints: @Template36FPoints;
        FillPointsCount: Succ(High(Template36FPoints));
        BezierizeCount: 4;
        RandPassesCount: 12;
        TemplateHeight: 1024; TemplateWidth: 4096;
        canMirror: true; canFlip: false; isNegative: true; canInvert: false;
        hasGirders: false;
        MaxHedgehogs: 32;
       ),
       (BasePoints: @Template37Points;
        BasePointsCount: Succ(High(Template37Points));
        FillPoints: @Template37FPoints;
        FillPointsCount: Succ(High(Template37FPoints));
        BezierizeCount: 3;
        RandPassesCount: 3;
        TemplateHeight: 2048; TemplateWidth: 4096;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: true;
        MaxHedgehogs: 48;
       ),
       (BasePoints: @Template38Points;
        BasePointsCount: Succ(High(Template38Points));
        FillPoints: @Template38FPoints;
        FillPointsCount: Succ(High(Template38FPoints));
        BezierizeCount: 4;
        RandPassesCount: 4;
        TemplateHeight: 2048; TemplateWidth: 4096;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: true;
        MaxHedgehogs: 48;
       ),
       (BasePoints: @Template39Points;
        BasePointsCount: Succ(High(Template39Points));
        FillPoints: @Template39FPoints;
        FillPointsCount: Succ(High(Template39FPoints));
        BezierizeCount: 3;
        RandPassesCount: 3;
        TemplateHeight: 512; TemplateWidth: 1536;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: false;
        MaxHedgehogs: 8;
       ),
       (BasePoints: @Template40Points;
        BasePointsCount: Succ(High(Template40Points));
        FillPoints: @Template40FPoints;
        FillPointsCount: Succ(High(Template40FPoints));
        BezierizeCount: 3;
        RandPassesCount: 3;
        TemplateHeight: 1024; TemplateWidth: 1024;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: false;
        MaxHedgehogs: 8;
       ),
       (BasePoints: @Template41Points;
        BasePointsCount: Succ(High(Template41Points));
        FillPoints: @Template41FPoints;
        FillPointsCount: Succ(High(Template41FPoints));
        BezierizeCount: 3;
        RandPassesCount: 5;
        TemplateHeight: 2048; TemplateWidth: 4096;
        canMirror: true; canFlip: true; isNegative: false; canInvert: false;
        hasGirders: true;
        MaxHedgehogs: 48;
       ),
       (BasePoints: @Template42Points;
        BasePointsCount: Succ(High(Template42Points));
        FillPoints: @Template42FPoints;
        FillPointsCount: Succ(High(Template42FPoints));
        BezierizeCount: 3;
        RandPassesCount: 3;
        TemplateHeight: 512; TemplateWidth: 1536;
        canMirror: true; canFlip: false; isNegative: false; canInvert: false;
        hasGirders: false;
        MaxHedgehogs: 8;
       )
      );
const SmallTemplates: array[0..2] of Longword = ( 39, 40, 42 );
const MediumTemplates: array[0..17] of Longword =
      ( 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 );
const LargeTemplates: array[0..19] of Longword =
      (
        18, 19, 20, 21, 22, 23, 24, 25, 26, 27,
        28, 29, 30, 31, 32, 33, 34, 35, 37, 38
      );
const CavernTemplates: array[0..4] of Longword = (36, 2, 3, 21, 29);
//const WackyTemplates: array[0..4] of Longword = (37, 38, 39, 40, 41);
const WackyTemplates: array[0..2] of Longword = (37, 38, 41);

implementation

end.
