module System.Directory
  ( Permissions
     (  Permissions
     ,  readable               -- :: Permissions -> Bool 
     ,  writable               -- :: Permissions -> Bool
     ,  executable             -- :: Permissions -> Bool
     ,  searchable             -- :: Permissions -> Bool
     )

  -- * Actions on directories
  , createDirectory           -- :: FilePath -> IO ()
  , removeDirectory           -- :: FilePath -> IO ()
  , renameDirectory           -- :: FilePath -> FilePath -> IO ()

  , getDirectoryContents      -- :: FilePath -> IO [FilePath]
  , getCurrentDirectory       -- :: IO FilePath
  , setCurrentDirectory       -- :: FilePath -> IO ()

  -- * Actions on files
  , removeFile                -- :: FilePath -> IO ()
  , renameFile                -- :: FilePath -> FilePath -> IO ()

  -- * Existence tests
  , doesFileExist             -- :: FilePath -> IO Bool
  , doesDirectoryExist        -- :: FilePath -> IO Bool

  -- * Setting and retrieving permissions
  , getPermissions            -- :: FilePath -> IO Permissions
  , setPermissions            -- :: FilePath -> Permissions -> IO ()

  -- * Timestamps
  , getModificationTime       -- :: FilePath -> IO ClockTime

  ) where

import Directory
