{-# language ForeignFunctionInterface, EmptyDataDecls #-}

module Sound.SFML.LowLevel where


import Control.Applicative

import Foreign.Ptr
import Foreign.C.String


-- * SoundBuffer

data SoundBuffer

sfSoundBuffer_CreateFromFile :: FilePath -> IO (Ptr SoundBuffer)
sfSoundBuffer_CreateFromFile path = withCString path c__sfSoundBuffer_CreateFromFile

foreign import ccall "sfSoundBuffer_CreateFromFile" c__sfSoundBuffer_CreateFromFile ::
    CString -> IO (Ptr SoundBuffer)

foreign import ccall sfSoundBuffer_Destroy :: Ptr SoundBuffer -> IO ()


-- * Sound

data Sound

foreign import ccall sfSound_Create :: IO (Ptr Sound)

foreign import ccall sfSound_SetBuffer :: Ptr Sound -> Ptr SoundBuffer -> IO ()

foreign import ccall sfSound_Play :: Ptr Sound -> IO ()

foreign import ccall sfSound_Stop :: Ptr Sound -> IO ()

foreign import ccall sfSound_Destroy :: Ptr Sound -> IO ()

foreign import ccall sfSound_SetLoop :: Ptr Sound -> Bool -> IO ()

foreign import ccall sfSound_SetVolume :: Ptr Sound -> Float -> IO ()

foreign import ccall sfSound_GetStatus :: Ptr Sound -> IO Int

getStatus s = toStatus <$> sfSound_GetStatus s

toStatus :: Int -> Status
toStatus = toEnum

data Status
    = Stopped
    | Paused
    | Playing
  deriving (Eq, Enum, Show)


-- * Music

data Music

sfMusic_CreateFromFile :: FilePath -> IO (Ptr Music)
sfMusic_CreateFromFile path = withCString path c__sfMusic_CreateFromFile

foreign import ccall "sfMusic_CreateFromFile" c__sfMusic_CreateFromFile :: CString -> IO (Ptr Music)

foreign import ccall sfMusic_Destroy :: Ptr Music -> IO ()

foreign import ccall sfMusic_Play :: Ptr Music -> IO ()

foreign import ccall sfMusic_Stop :: Ptr Music -> IO ()

foreign import ccall sfMusic_SetLoop :: Ptr Music -> Bool -> IO ()

foreign import ccall sfMusic_SetVolume :: Ptr Music -> Float -> IO ()

foreign import ccall sfMusic_GetDuration :: Ptr Music -> IO Float

