-- |
-- Module:     FRP.NetWire
-- Copyright:  (c) 2011 Ertugrul Soeylemez
-- License:    BSD3
-- Maintainer: Ertugrul Soeylemez <es@ertes.de>
--
-- Arrowized FRP implementation for networking applications.  The aim of
-- this library is to provide a convenient FRP implementation, which
-- should enable you to write entirely pure network sessions.

module FRP.NetWire
    ( -- * Wires
      Wire, Output, Time,
      WireState(..),
      mkGen, toGen,

      -- * Reactive sessions
      Session,
      stepWire,
      stepWireDelta,
      stepWireTime,
      withWire,

      -- * Testing wires
      testWire,
      testWireStr,

      -- * Pure wires
      SF,
      stepSF,
      stepWirePure,

      -- * Inhibition
      InhibitException(..),
      inhibitEx,
      noEvent,

      -- * Netwire Reexports
      module FRP.NetWire.Analyze,
      module FRP.NetWire.Calculus,
      module FRP.NetWire.Event,
      module FRP.NetWire.IO,
      module FRP.NetWire.Random,
      module FRP.NetWire.Request,
      module FRP.NetWire.Switch,
      module FRP.NetWire.Tools,

      -- * Other convenience reexports
      module Control.Monad.IO.Class,
      module Control.Monad.IO.Control,
      module Data.Functor.Identity
    )
    where

import Control.Monad.IO.Class
import Control.Monad.IO.Control
import Data.Functor.Identity
import FRP.NetWire.Analyze
import FRP.NetWire.Calculus
import FRP.NetWire.Event
import FRP.NetWire.IO
import FRP.NetWire.Pure
import FRP.NetWire.Random
import FRP.NetWire.Request
import FRP.NetWire.Session
import FRP.NetWire.Switch
import FRP.NetWire.Tools
import FRP.NetWire.Wire
