module Spread.Constants where
import Data.Word
import Data.Binary
import Data.Binary.Put
import Data.Binary.Get
import Network
uNRELIABLE_MESS        = 0x00000001 ::Word32
rELIABLE_MESS          = 0x00000002::Word32
fIFO_MESS              = 0x00000004::Word32
cAUSAL_MESS            = 0x00000080::Word32
aGREED_MESS            = 0x00000010::Word32
sAFE_MESS              = 0x00000020::Word32
rEGULAR_MESS           = 0x0000003f::Word32
sELF_DISCARD           = 0x00000040::Word32
rEG_MEMB_MESS          = 0x00001000::Word32
tRANSITION_MESS        = 0x00002000::Word32
cAUSED_BY_JOIN         = 0x00000100::Word32
cAUSED_BY_LEAVE        = 0x00000200::Word32
cAUSED_BY_DISCONNECT   = 0x00000400::Word32
cAUSED_BY_NETWORK      = 0x00000800::Word32
mEMBERSHIP_MESS        = 0x00003f00::Word32
rEJECT_MESS  = 0x00400000 ::Word32

--detect the endianness of the architecture we're running on
aRCH_ENDIAN = if (runGet getWord16host (runPut $ putWord16be (0x0001::Word16))) == 0x0001 then 
                  (0x00000000::Word32) 
              else 
                  (0x80000080 ::Word32)
--aRCH_ENDIAN = 0x80000080


eNDIAN_TYPE = 0x80000080 :: Word32
---- Service-types used only within the package.
jOIN_MESS            = 0x00010000 ::Word32
lEAVE_MESS           = 0x00020000::Word32
kILL_MESS            = 0x00040000::Word32
gROUPS_MESS          = 0x00080000::Word32

-- Lengths
mAX_MESSAGE_LENGTH = 140000 :: Int
mAX_GROUP_NAME = 32 :: Int
mAX_PRIVATE_NAME = 10 :: Int
mAX_AUTH_NAME :: Int
mAX_AUTH_NAME = 30
mAX_AUTH_METHODS :: Int
mAX_AUTH_METHODS = 3

dEFAULT_SPREAD_PORT :: PortNumber
dEFAULT_SPREAD_PORT = 4803

sP_MAJOR_VERSION = 4 :: Word8
sP_MINOR_VERSION = 0 :: Word8
sP_PATCH_VERSION = 0 :: Word8

aCCEPT_SESSION = 1 :: Int