# -- coding: utf-8
""" singleton.py - Singleton design-pattern implemented using
    meta-classes. 

    This module is part of the HarvestMan program.
    For licensing information see the file LICENSE.txt that
    is included in this distribution.

    Author: Anand B Pillai <anand at harvestmanontheweb.com>

    Created Anand B Pillai Feb 2 2007
    

    Copyright(C) 2007, Anand B Pillai.
    
"""

__version__ = '2.0 b1'
__author__ = 'Anand B Pillai'

class SingletonMeta(type):
    """ A type for Singleton classes """

    def my_new(cls,name,bases=(),dct={}):
        if not cls.instance:
            cls.instance = object.__new__(cls)
                
        return cls.instance
    
    def __init__(cls, name, bases, dct):
        super(SingletonMeta, cls).__init__(name, bases, dct)
        cls.instance = None
        cls.__new__ = cls.my_new

class SingletonMeta2(type):
    """ A type for Singleton classes """    

    def __init__(self, *args):
        type.__init__(self, *args)
        self._instances = {}

    def __call__(self, *args):
        if not args in self._instances:
            self._instances[args] = type.__call__(self, *args)
        return self._instances[args]
    
class Singleton(object):
    """ The default implementation for a Python Singleton class """

    __metaclass__ = SingletonMeta

    def getInstance(cls, *args):
        if not cls.instance:
            cls(*args)
        return cls.instance

    getInstance = classmethod(getInstance)


