// ****************************************************************************
//  Project:        GUYMAGER
// ****************************************************************************
//  Programmer:     Guy Voncken
//                  Police Grand-Ducale
//                  Service de Police Judiciaire
//                  Section Nouvelles Technologies
// ****************************************************************************
//  Module:         Different utility functions
// ****************************************************************************

#include "common.h"

#include <QtGui>

#include "config.h"

#define MEMWATCH
#define MEMWATCH_NOCPP
#include "memwatch.h"
#undef malloc   // These have been defined in memwatch.h. We must undefine them
#undef free     // in order to be able to access std::malloc and std::free

#include "util.h"

static QMutex MutexMemAccess;


void *UtilMemAlloc (size_t Size, const char *pFile, int Line)
{
   void *pMem;

   if (CONFIG(UseMemWatch))
   {
      MutexMemAccess.lock();
      pMem = mwMalloc (Size, pFile, Line);
      MutexMemAccess.unlock();
   }
   else
   {
      pMem = malloc(Size);
   }

   return pMem;
}

void UtilMemFree (void *pMem, const char *pFile, int Line)
{
   if (CONFIG(UseMemWatch))
   {
      MutexMemAccess.lock();
      mwFree (pMem, pFile, Line);
      MutexMemAccess.unlock();
   }
   else
   {
      free (pMem);
   }
}

