// ****************************************************************************
//  Project:        GUYMAGER
// ****************************************************************************
//  Programmer:     Guy Voncken
//                  Police Grand-Ducale
//                  Service de Police Judiciaire
//                  Section Nouvelles Technologies
// ****************************************************************************
//  Module:         Private definitions of acquisition dialog
// ****************************************************************************


#ifndef __DLGACQUIRE_PRIVATE_H__
#define __DLGACQUIRE_PRIVATE_H__

#include <QtGui> //lint !e537 Repeated include

#ifndef __COMMON_H__
   #include "common.h"
#endif

class   t_DlgAcquireLineEdit;
typedef t_DlgAcquireLineEdit *t_pDlgAcquireLineEdit;

class   t_DlgAcquireLineEdit: public QLineEdit
{
   Q_OBJECT

   public:
      t_DlgAcquireLineEdit (QWidget *pParent, const QString &Name)
         :QLineEdit (pParent)
      {
         this->Name = Name;
         CHK_QT_EXIT (connect (this, SIGNAL (textEdited     (const QString &)),
                               this, SLOT   (SlotTextEdited (const QString &))))

      }

     ~t_DlgAcquireLineEdit() {}

     void TextUpdated (void)
     {
        emit SignalTextEdited (this, text());
     }

   public:
      QString Name;

   private slots:
      void SlotTextEdited (const QString &Text)
      {
         emit SignalTextEdited (this, Text);
      }

   signals:
      void SignalTextEdited (t_DlgAcquireLineEdit *pDlgAcquireLineEdit, const QString &Text);
};

#endif

