// ****************************************************************************
//  Project:        GUYMAGER
// ****************************************************************************
//  Programmer:     Guy Voncken
//                  Police Grand-Ducale
//                  Service de Police Judiciaire
//                  Section Nouvelles Technologies
// ****************************************************************************
//  Module:         Dialog that is opened when aborting an acquisition
// ****************************************************************************

#include "dlgabort.h"



// -----------------------------
//           Constants
// -----------------------------


// -----------------------------
//           Classes
// -----------------------------

class t_DlgAbortLocal
{
   public:
      QCheckBox *pCheckBoxDelete;
};

t_DlgAbort::t_DlgAbort (void)
{
   CHK_EXIT (ERROR_DLGABORT_CONSTRUCTOR_NOT_SUPPORTED)
} //lint !e1401 pOwn not initialised

t_DlgAbort::t_DlgAbort (t_pcDevice pDevice, QWidget *pParent, Qt::WFlags Flags)
   :QDialog (pParent, Flags)
{
   static bool Initialised = false;
   QString     Text;
   bool        Acquisition;

   if (!Initialised)
   {
      CHK_EXIT (TOOL_ERROR_REGISTER_CODE (ERROR_DLGABORT_CONSTRUCTOR_NOT_SUPPORTED))
      Initialised = true;
   }

   pOwn = new t_DlgAbortLocal;

   Acquisition = ((pDevice->State == t_Device::Acquire) ||
                  (pDevice->State == t_Device::AcquirePaused));
   if (Acquisition)
        Text = tr ("Do you want to abort the acquisition of %1?" ) .arg(pDevice->LinuxDevice);
   else Text = tr ("Do you want to abort the verification of %1?") .arg(pDevice->LinuxDevice);

   QVBoxLayout *pMainLayout  = new QVBoxLayout ();
   QHBoxLayout *pButtonLayout= new QHBoxLayout ();
   QLabel      *pLabel       = new QLabel      (Text, this);
   QPushButton *pButtonOk    = new QPushButton (QObject::tr("Ok"    ), this);
   QPushButton *pButtonCancel= new QPushButton (QObject::tr("Cancel"), this);
   pOwn->pCheckBoxDelete     = new QCheckBox   (tr("Delete partial image files"), this);
   pOwn->pCheckBoxDelete->setChecked (Acquisition);

   pMainLayout->addWidget   (pLabel);
   pMainLayout->addWidget   (pOwn->pCheckBoxDelete);
   pMainLayout->addLayout   (pButtonLayout);
   pButtonLayout->addWidget (pButtonOk);
   pButtonLayout->addWidget (pButtonCancel);

   setLayout (pMainLayout);
   setWindowTitle (tr("Abort?", "Dialog title"));

   CHK_QT_EXIT (connect (pButtonOk    , SIGNAL (released()), this, SLOT(accept())))
   CHK_QT_EXIT (connect (pButtonCancel, SIGNAL (released()), this, SLOT(reject())))
}


t_DlgAbort::~t_DlgAbort ()
{
   delete pOwn;
}


APIRET t_DlgAbort::Show (t_pcDevice pDevice, bool &Abort, bool &Delete)
{
   t_DlgAbort *pDlg;
   int          Result;

   pDlg = new t_DlgAbort (pDevice);
   pDlg->setModal  (true);
   Result = pDlg->exec();
   Abort  = (Result == QDialog::Accepted);
   Delete = (Abort && pDlg->pOwn->pCheckBoxDelete->isChecked());
   delete pDlg;

   return NO_ERROR;
}

