/*
 * Guifications - The end all, be all, toaster popup plugin
 * Copyright (C) 2003-2005 Gary Kramlich
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef GF_DISPLAY_H
#define GF_DISPLAY_H

typedef struct _GfDisplay GfDisplay;

#define GF_DISPLAY(obj)	((GfDisplay *)obj)

#include <glib.h>

#include <plugin.h>

#include "gf_event_info.h"
#include "gf_notification.h"

typedef enum _GfDisplayPosition {
	GF_DISPLAY_POSITION_NW = 0,
	GF_DISPLAY_POSITION_NE,
	GF_DISPLAY_POSITION_SW,
	GF_DISPLAY_POSITION_SE,
	GF_DISPLAY_POSITION_UNKNOWN
} GfDisplayPosition;

typedef enum _GfDisplayZoom {
	GF_DISPLAY_ZOOM_200 = 0,
	GF_DISPLAY_ZOOM_175,
	GF_DISPLAY_ZOOM_150,
	GF_DISPLAY_ZOOM_125,
	GF_DISPLAY_ZOOM_100,
	GF_DISPLAY_ZOOM_75,
	GF_DISPLAY_ZOOM_50,
	GF_DISPLAY_ZOOM_25,
	GF_DISPLAY_ZOOM_UNKNOWN
} GfDisplayZoom;

G_BEGIN_DECLS

GfDisplay *gf_display_new();
void gf_display_destroy(GfDisplay *display);

GfEventInfo *gf_display_get_event_info(GfDisplay *display);

void gf_display_show_event(GfEventInfo *info, GfNotification *notification);

void gf_display_init(PurplePlugin *plugin);
void gf_display_uninit();

#if GTK_CHECK_VERSION(2,2,0)
gint gf_display_get_default_screen();
gint gf_display_get_screen_count();
gint gf_display_get_default_monitor();
gint gf_display_get_monitor_count();
#endif /* GTK_CHECK_VERSION(2,2,0) */

gboolean gf_display_screen_saver_is_running();

G_END_DECLS

#endif /* GF_DISPLAY_H */
