/*
 * Copyright (c) 2005, Christian Biere
 *
 *----------------------------------------------------------------------
 * This file is part of gtk-gnutella.
 *
 *  gtk-gnutella is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  gtk-gnutella is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with gtk-gnutella; if not, write to the Free Software
 *  Foundation, Inc.:
 *      59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *----------------------------------------------------------------------
 */

/**
 * @ingroup lib
 * @file
 *
 * Tiger S boxes.
 *
 * This file comes from http://www.cs.technion.ac.il/~biham/Reports/Tiger/
 *
 */

#include "common.h"

#define D(x, y) ((guint64) (x) << 32 | (y))

static const guint64 tiger_sboxes[4 * 256] = {
	D(0x02AAB17CUL, 0xF7E90C5EUL)  /*    0 */,
	D(0xAC424B03UL, 0xE243A8ECUL)  /*    1 */,
	D(0x72CD5BE3UL, 0x0DD5FCD3UL)  /*    2 */,
	D(0x6D019B93UL, 0xF6F97F3AUL)  /*    3 */,
	D(0xCD9978FFUL, 0xD21F9193UL)  /*    4 */,
	D(0x7573A1C9UL, 0x708029E2UL)  /*    5 */,
	D(0xB164326BUL, 0x922A83C3UL)  /*    6 */,
	D(0x46883EEEUL, 0x04915870UL)  /*    7 */,
	D(0xEAACE305UL, 0x7103ECE6UL)  /*    8 */,
	D(0xC54169B8UL, 0x08A3535CUL)  /*    9 */,
	D(0x4CE75491UL, 0x8DDEC47CUL)  /*   10 */,
	D(0x0AA2F4DFUL, 0xDC0DF40CUL)  /*   11 */,
	D(0x10B76F18UL, 0xA74DBEFAUL)  /*   12 */,
	D(0xC6CCB623UL, 0x5AD1AB6AUL)  /*   13 */,
	D(0x13726121UL, 0x572FE2FFUL)  /*   14 */,
	D(0x1A488C6FUL, 0x199D921EUL)  /*   15 */,
	D(0x4BC9F9F4UL, 0xDA0007CAUL)  /*   16 */,
	D(0x26F5E6F6UL, 0xE85241C7UL)  /*   17 */,
	D(0x859079DBUL, 0xEA5947B6UL)  /*   18 */,
	D(0x4F1885C5UL, 0xC99E8C92UL)  /*   19 */,
	D(0xD78E761EUL, 0xA96F864BUL)  /*   20 */,
	D(0x8E36428CUL, 0x52B5C17DUL)  /*   21 */,
	D(0x69CF6827UL, 0x373063C1UL)  /*   22 */,
	D(0xB607C93DUL, 0x9BB4C56EUL)  /*   23 */,
	D(0x7D820E76UL, 0x0E76B5EAUL)  /*   24 */,
	D(0x645C9CC6UL, 0xF07FDC42UL)  /*   25 */,
	D(0xBF38A078UL, 0x243342E0UL)  /*   26 */,
	D(0x5F6B343CUL, 0x9D2E7D04UL)  /*   27 */,
	D(0xF2C28AEBUL, 0x600B0EC6UL)  /*   28 */,
	D(0x6C0ED85FUL, 0x7254BCACUL)  /*   29 */,
	D(0x71592281UL, 0xA4DB4FE5UL)  /*   30 */,
	D(0x1967FA69UL, 0xCE0FED9FUL)  /*   31 */,
	D(0xFD5293F8UL, 0xB96545DBUL)  /*   32 */,
	D(0xC879E9D7UL, 0xF2A7600BUL)  /*   33 */,
	D(0x86024892UL, 0x0193194EUL)  /*   34 */,
	D(0xA4F9533BUL, 0x2D9CC0B3UL)  /*   35 */,
	D(0x9053836CUL, 0x15957613UL)  /*   36 */,
	D(0xDB6DCF8AUL, 0xFC357BF1UL)  /*   37 */,
	D(0x18BEEA7AUL, 0x7A370F57UL)  /*   38 */,
	D(0x037117CAUL, 0x50B99066UL)  /*   39 */,
	D(0x6AB30A97UL, 0x74424A35UL)  /*   40 */,
	D(0xF4E92F02UL, 0xE325249BUL)  /*   41 */,
	D(0x7739DB07UL, 0x061CCAE1UL)  /*   42 */,
	D(0xD8F3B49CUL, 0xECA42A05UL)  /*   43 */,
	D(0xBD56BE3FUL, 0x51382F73UL)  /*   44 */,
	D(0x45FAED58UL, 0x43B0BB28UL)  /*   45 */,
	D(0x1C813D5CUL, 0x11BF1F83UL)  /*   46 */,
	D(0x8AF0E4B6UL, 0xD75FA169UL)  /*   47 */,
	D(0x33EE18A4UL, 0x87AD9999UL)  /*   48 */,
	D(0x3C26E8EAUL, 0xB1C94410UL)  /*   49 */,
	D(0xB510102BUL, 0xC0A822F9UL)  /*   50 */,
	D(0x141EEF31UL, 0x0CE6123BUL)  /*   51 */,
	D(0xFC65B900UL, 0x59DDB154UL)  /*   52 */,
	D(0xE0158640UL, 0xC5E0E607UL)  /*   53 */,
	D(0x884E0798UL, 0x26C3A3CFUL)  /*   54 */,
	D(0x930D0D95UL, 0x23C535FDUL)  /*   55 */,
	D(0x35638D75UL, 0x4E9A2B00UL)  /*   56 */,
	D(0x4085FCCFUL, 0x40469DD5UL)  /*   57 */,
	D(0xC4B17AD2UL, 0x8BE23A4CUL)  /*   58 */,
	D(0xCAB2F0FCUL, 0x6A3E6A2EUL)  /*   59 */,
	D(0x2860971AUL, 0x6B943FCDUL)  /*   60 */,
	D(0x3DDE6EE2UL, 0x12E30446UL)  /*   61 */,
	D(0x6222F32AUL, 0xE01765AEUL)  /*   62 */,
	D(0x5D550BB5UL, 0x478308FEUL)  /*   63 */,
	D(0xA9EFA98DUL, 0xA0EDA22AUL)  /*   64 */,
	D(0xC351A716UL, 0x86C40DA7UL)  /*   65 */,
	D(0x1105586DUL, 0x9C867C84UL)  /*   66 */,
	D(0xDCFFEE85UL, 0xFDA22853UL)  /*   67 */,
	D(0xCCFBD026UL, 0x2C5EEF76UL)  /*   68 */,
	D(0xBAF294CBUL, 0x8990D201UL)  /*   69 */,
	D(0xE69464F5UL, 0x2AFAD975UL)  /*   70 */,
	D(0x94B013AFUL, 0xDF133E14UL)  /*   71 */,
	D(0x06A7D1A3UL, 0x2823C958UL)  /*   72 */,
	D(0x6F95FE51UL, 0x30F61119UL)  /*   73 */,
	D(0xD92AB34EUL, 0x462C06C0UL)  /*   74 */,
	D(0xED7BDE33UL, 0x887C71D2UL)  /*   75 */,
	D(0x79746D6EUL, 0x6518393EUL)  /*   76 */,
	D(0x5BA41938UL, 0x5D713329UL)  /*   77 */,
	D(0x7C1BA6B9UL, 0x48A97564UL)  /*   78 */,
	D(0x31987C19UL, 0x7BFDAC67UL)  /*   79 */,
	D(0xDE6C23C4UL, 0x4B053D02UL)  /*   80 */,
	D(0x581C49FEUL, 0xD002D64DUL)  /*   81 */,
	D(0xDD474D63UL, 0x38261571UL)  /*   82 */,
	D(0xAA4546C3UL, 0xE473D062UL)  /*   83 */,
	D(0x928FCE34UL, 0x9455F860UL)  /*   84 */,
	D(0x48161BBAUL, 0xCAAB94D9UL)  /*   85 */,
	D(0x63912430UL, 0x770E6F68UL)  /*   86 */,
	D(0x6EC8A5E6UL, 0x02C6641CUL)  /*   87 */,
	D(0x87282515UL, 0x337DDD2BUL)  /*   88 */,
	D(0x2CDA6B42UL, 0x034B701BUL)  /*   89 */,
	D(0xB03D37C1UL, 0x81CB096DUL)  /*   90 */,
	D(0xE1084382UL, 0x66C71C6FUL)  /*   91 */,
	D(0x2B3180C7UL, 0xEB51B255UL)  /*   92 */,
	D(0xDF92B82FUL, 0x96C08BBCUL)  /*   93 */,
	D(0x5C68C8C0UL, 0xA632F3BAUL)  /*   94 */,
	D(0x5504CC86UL, 0x1C3D0556UL)  /*   95 */,
	D(0xABBFA4E5UL, 0x5FB26B8FUL)  /*   96 */,
	D(0x41848B0AUL, 0xB3BACEB4UL)  /*   97 */,
	D(0xB334A273UL, 0xAA445D32UL)  /*   98 */,
	D(0xBCA696F0UL, 0xA85AD881UL)  /*   99 */,
	D(0x24F6EC65UL, 0xB528D56CUL)  /*  100 */,
	D(0x0CE1512EUL, 0x90F4524AUL)  /*  101 */,
	D(0x4E9DD79DUL, 0x5506D35AUL)  /*  102 */,
	D(0x258905FAUL, 0xC6CE9779UL)  /*  103 */,
	D(0x2019295BUL, 0x3E109B33UL)  /*  104 */,
	D(0xF8A9478BUL, 0x73A054CCUL)  /*  105 */,
	D(0x2924F2F9UL, 0x34417EB0UL)  /*  106 */,
	D(0x3993357DUL, 0x536D1BC4UL)  /*  107 */,
	D(0x38A81AC2UL, 0x1DB6FF8BUL)  /*  108 */,
	D(0x47C4FBF1UL, 0x7D6016BFUL)  /*  109 */,
	D(0x1E0FAADDUL, 0x7667E3F5UL)  /*  110 */,
	D(0x7ABCFF62UL, 0x938BEB96UL)  /*  111 */,
	D(0xA78DAD94UL, 0x8FC179C9UL)  /*  112 */,
	D(0x8F1F98B7UL, 0x2911E50DUL)  /*  113 */,
	D(0x61E48EAEUL, 0x27121A91UL)  /*  114 */,
	D(0x4D62F7ADUL, 0x31859808UL)  /*  115 */,
	D(0xECEBA345UL, 0xEF5CEAEBUL)  /*  116 */,
	D(0xF5CEB25EUL, 0xBC9684CEUL)  /*  117 */,
	D(0xF633E20CUL, 0xB7F76221UL)  /*  118 */,
	D(0xA32CDF06UL, 0xAB8293E4UL)  /*  119 */,
	D(0x985A202CUL, 0xA5EE2CA4UL)  /*  120 */,
	D(0xCF0B8447UL, 0xCC8A8FB1UL)  /*  121 */,
	D(0x9F765244UL, 0x979859A3UL)  /*  122 */,
	D(0xA8D516B1UL, 0xA1240017UL)  /*  123 */,
	D(0x0BD7BA3EUL, 0xBB5DC726UL)  /*  124 */,
	D(0xE54BCA55UL, 0xB86ADB39UL)  /*  125 */,
	D(0x1D7A3AFDUL, 0x6C478063UL)  /*  126 */,
	D(0x519EC608UL, 0xE7669EDDUL)  /*  127 */,
	D(0x0E5715A2UL, 0xD149AA23UL)  /*  128 */,
	D(0x177D4571UL, 0x848FF194UL)  /*  129 */,
	D(0xEEB55F32UL, 0x41014C22UL)  /*  130 */,
	D(0x0F5E5CA1UL, 0x3A6E2EC2UL)  /*  131 */,
	D(0x8029927BUL, 0x75F5C361UL)  /*  132 */,
	D(0xAD139FABUL, 0xC3D6E436UL)  /*  133 */,
	D(0x0D5DF1A9UL, 0x4CCF402FUL)  /*  134 */,
	D(0x3E8BD948UL, 0xBEA5DFC8UL)  /*  135 */,
	D(0xA5A0D357UL, 0xBD3FF77EUL)  /*  136 */,
	D(0xA2D12E25UL, 0x1F74F645UL)  /*  137 */,
	D(0x66FD9E52UL, 0x5E81A082UL)  /*  138 */,
	D(0x2E0C90CEUL, 0x7F687A49UL)  /*  139 */,
	D(0xC2E8BCBEUL, 0xBA973BC5UL)  /*  140 */,
	D(0x000001BCUL, 0xE509745FUL)  /*  141 */,
	D(0x423777BBUL, 0xE6DAB3D6UL)  /*  142 */,
	D(0xD1661C7EUL, 0xAEF06EB5UL)  /*  143 */,
	D(0xA1781F35UL, 0x4DAACFD8UL)  /*  144 */,
	D(0x2D11284AUL, 0x2B16AFFCUL)  /*  145 */,
	D(0xF1FC4F67UL, 0xFA891D1FUL)  /*  146 */,
	D(0x73ECC25DUL, 0xCB920ADAUL)  /*  147 */,
	D(0xAE610C22UL, 0xC2A12651UL)  /*  148 */,
	D(0x96E0A810UL, 0xD356B78AUL)  /*  149 */,
	D(0x5A9A381FUL, 0x2FE7870FUL)  /*  150 */,
	D(0xD5AD62EDUL, 0xE94E5530UL)  /*  151 */,
	D(0xD225E5E8UL, 0x368D1427UL)  /*  152 */,
	D(0x65977B70UL, 0xC7AF4631UL)  /*  153 */,
	D(0x99F889B2UL, 0xDE39D74FUL)  /*  154 */,
	D(0x233F30BFUL, 0x54E1D143UL)  /*  155 */,
	D(0x9A9675D3UL, 0xD9A63C97UL)  /*  156 */,
	D(0x5470554FUL, 0xF334F9A8UL)  /*  157 */,
	D(0x166ACB74UL, 0x4A4F5688UL)  /*  158 */,
	D(0x70C74CAAUL, 0xB2E4AEADUL)  /*  159 */,
	D(0xF0D09164UL, 0x6F294D12UL)  /*  160 */,
	D(0x57B82A89UL, 0x684031D1UL)  /*  161 */,
	D(0xEFD95A5AUL, 0x61BE0B6BUL)  /*  162 */,
	D(0x2FBD12E9UL, 0x69F2F29AUL)  /*  163 */,
	D(0x9BD37013UL, 0xFEFF9FE8UL)  /*  164 */,
	D(0x3F9B0404UL, 0xD6085A06UL)  /*  165 */,
	D(0x4940C1F3UL, 0x166CFE15UL)  /*  166 */,
	D(0x09542C4DUL, 0xCDF3DEFBUL)  /*  167 */,
	D(0xB4C52183UL, 0x85CD5CE3UL)  /*  168 */,
	D(0xC935B7DCUL, 0x4462A641UL)  /*  169 */,
	D(0x3417F8A6UL, 0x8ED3B63FUL)  /*  170 */,
	D(0xB8095929UL, 0x5B215B40UL)  /*  171 */,
	D(0xF99CDAEFUL, 0x3B8C8572UL)  /*  172 */,
	D(0x018C0614UL, 0xF8FCB95DUL)  /*  173 */,
	D(0x1B14ACCDUL, 0x1A3ACDF3UL)  /*  174 */,
	D(0x84D471F2UL, 0x00BB732DUL)  /*  175 */,
	D(0xC1A3110EUL, 0x95E8DA16UL)  /*  176 */,
	D(0x430A7220UL, 0xBF1A82B8UL)  /*  177 */,
	D(0xB77E090DUL, 0x39DF210EUL)  /*  178 */,
	D(0x5EF4BD9FUL, 0x3CD05E9DUL)  /*  179 */,
	D(0x9D4FF6DAUL, 0x7E57A444UL)  /*  180 */,
	D(0xDA1D60E1UL, 0x83D4A5F8UL)  /*  181 */,
	D(0xB287C384UL, 0x17998E47UL)  /*  182 */,
	D(0xFE3EDC12UL, 0x1BB31886UL)  /*  183 */,
	D(0xC7FE3CCCUL, 0x980CCBEFUL)  /*  184 */,
	D(0xE46FB590UL, 0x189BFD03UL)  /*  185 */,
	D(0x3732FD46UL, 0x9A4C57DCUL)  /*  186 */,
	D(0x7EF700A0UL, 0x7CF1AD65UL)  /*  187 */,
	D(0x59C64468UL, 0xA31D8859UL)  /*  188 */,
	D(0x762FB0B4UL, 0xD45B61F6UL)  /*  189 */,
	D(0x155BAED0UL, 0x99047718UL)  /*  190 */,
	D(0x68755E4CUL, 0x3D50BAA6UL)  /*  191 */,
	D(0xE9214E7FUL, 0x22D8B4DFUL)  /*  192 */,
	D(0x2ADDBF53UL, 0x2EAC95F4UL)  /*  193 */,
	D(0x32AE3909UL, 0xB4BD0109UL)  /*  194 */,
	D(0x834DF537UL, 0xB08E3450UL)  /*  195 */,
	D(0xFA209DA8UL, 0x4220728DUL)  /*  196 */,
	D(0x9E691D9BUL, 0x9EFE23F7UL)  /*  197 */,
	D(0x0446D288UL, 0xC4AE8D7FUL)  /*  198 */,
	D(0x7B4CC524UL, 0xE169785BUL)  /*  199 */,
	D(0x21D87F01UL, 0x35CA1385UL)  /*  200 */,
	D(0xCEBB400FUL, 0x137B8AA5UL)  /*  201 */,
	D(0x272E2B66UL, 0x580796BEUL)  /*  202 */,
	D(0x36122641UL, 0x25C2B0DEUL)  /*  203 */,
	D(0x057702BDUL, 0xAD1EFBB2UL)  /*  204 */,
	D(0xD4BABB8EUL, 0xACF84BE9UL)  /*  205 */,
	D(0x91583139UL, 0x641BC67BUL)  /*  206 */,
	D(0x8BDC2DE0UL, 0x8036E024UL)  /*  207 */,
	D(0x603C8156UL, 0xF49F68EDUL)  /*  208 */,
	D(0xF7D236F7UL, 0xDBEF5111UL)  /*  209 */,
	D(0x9727C459UL, 0x8AD21E80UL)  /*  210 */,
	D(0xA08A0896UL, 0x670A5FD7UL)  /*  211 */,
	D(0xCB4A8F43UL, 0x09EBA9CBUL)  /*  212 */,
	D(0x81AF564BUL, 0x0F7036A1UL)  /*  213 */,
	D(0xC0B99AA7UL, 0x78199ABDUL)  /*  214 */,
	D(0x959F1EC8UL, 0x3FC8E952UL)  /*  215 */,
	D(0x8C505077UL, 0x794A81B9UL)  /*  216 */,
	D(0x3ACAAF8FUL, 0x056338F0UL)  /*  217 */,
	D(0x07B43F50UL, 0x627A6778UL)  /*  218 */,
	D(0x4A44AB49UL, 0xF5ECCC77UL)  /*  219 */,
	D(0x3BC3D6E4UL, 0xB679EE98UL)  /*  220 */,
	D(0x9CC0D4D1UL, 0xCF14108CUL)  /*  221 */,
	D(0x4406C00BUL, 0x206BC8A0UL)  /*  222 */,
	D(0x82A18854UL, 0xC8D72D89UL)  /*  223 */,
	D(0x67E366B3UL, 0x5C3C432CUL)  /*  224 */,
	D(0xB923DD61UL, 0x102B37F2UL)  /*  225 */,
	D(0x56AB2779UL, 0xD884271DUL)  /*  226 */,
	D(0xBE83E1B0UL, 0xFF1525AFUL)  /*  227 */,
	D(0xFB7C65D4UL, 0x217E49A9UL)  /*  228 */,
	D(0x6BDBE0E7UL, 0x6D48E7D4UL)  /*  229 */,
	D(0x08DF8287UL, 0x45D9179EUL)  /*  230 */,
	D(0x22EA6A9AUL, 0xDD53BD34UL)  /*  231 */,
	D(0xE36E141CUL, 0x5622200AUL)  /*  232 */,
	D(0x7F805D1BUL, 0x8CB750EEUL)  /*  233 */,
	D(0xAFE5C7A5UL, 0x9F58E837UL)  /*  234 */,
	D(0xE27F996AUL, 0x4FB1C23CUL)  /*  235 */,
	D(0xD3867DFBUL, 0x0775F0D0UL)  /*  236 */,
	D(0xD0E673DEUL, 0x6E88891AUL)  /*  237 */,
	D(0x123AEB9EUL, 0xAFB86C25UL)  /*  238 */,
	D(0x30F1D5D5UL, 0xC145B895UL)  /*  239 */,
	D(0xBB434A2DUL, 0xEE7269E7UL)  /*  240 */,
	D(0x78CB67ECUL, 0xF931FA38UL)  /*  241 */,
	D(0xF33B0372UL, 0x323BBF9CUL)  /*  242 */,
	D(0x52D66336UL, 0xFB279C74UL)  /*  243 */,
	D(0x505F33ACUL, 0x0AFB4EAAUL)  /*  244 */,
	D(0xE8A5CD99UL, 0xA2CCE187UL)  /*  245 */,
	D(0x53497480UL, 0x1E2D30BBUL)  /*  246 */,
	D(0x8D2D5711UL, 0xD5876D90UL)  /*  247 */,
	D(0x1F1A4128UL, 0x91BC038EUL)  /*  248 */,
	D(0xD6E2E71DUL, 0x82E56648UL)  /*  249 */,
	D(0x74036C3AUL, 0x497732B7UL)  /*  250 */,
	D(0x89B67ED9UL, 0x6361F5ABUL)  /*  251 */,
	D(0xFFED95D8UL, 0xF1EA02A2UL)  /*  252 */,
	D(0xE72B3BD6UL, 0x1464D43DUL)  /*  253 */,
	D(0xA6300F17UL, 0x0BDC4820UL)  /*  254 */,
	D(0xEBC18760UL, 0xED78A77AUL)  /*  255 */,
	D(0xE6A6BE5AUL, 0x05A12138UL)  /*  256 */,
	D(0xB5A122A5UL, 0xB4F87C98UL)  /*  257 */,
	D(0x563C6089UL, 0x140B6990UL)  /*  258 */,
	D(0x4C46CB2EUL, 0x391F5DD5UL)  /*  259 */,
	D(0xD932ADDBUL, 0xC9B79434UL)  /*  260 */,
	D(0x08EA70E4UL, 0x2015AFF5UL)  /*  261 */,
	D(0xD765A667UL, 0x3E478CF1UL)  /*  262 */,
	D(0xC4FB757EUL, 0xAB278D99UL)  /*  263 */,
	D(0xDF11C686UL, 0x2D6E0692UL)  /*  264 */,
	D(0xDDEB84F1UL, 0x0D7F3B16UL)  /*  265 */,
	D(0x6F2EF604UL, 0xA665EA04UL)  /*  266 */,
	D(0x4A8E0F0FUL, 0xF0E0DFB3UL)  /*  267 */,
	D(0xA5EDEEF8UL, 0x3DBCBA51UL)  /*  268 */,
	D(0xFC4F0A2AUL, 0x0EA4371EUL)  /*  269 */,
	D(0xE83E1DA8UL, 0x5CB38429UL)  /*  270 */,
	D(0xDC8FF882UL, 0xBA1B1CE2UL)  /*  271 */,
	D(0xCD45505EUL, 0x8353E80DUL)  /*  272 */,
	D(0x18D19A00UL, 0xD4DB0717UL)  /*  273 */,
	D(0x34A0CFEDUL, 0xA5F38101UL)  /*  274 */,
	D(0x0BE77E51UL, 0x8887CAF2UL)  /*  275 */,
	D(0x1E341438UL, 0xB3C45136UL)  /*  276 */,
	D(0xE05797F4UL, 0x9089CCF9UL)  /*  277 */,
	D(0xFFD23F9DUL, 0xF2591D14UL)  /*  278 */,
	D(0x543DDA22UL, 0x8595C5CDUL)  /*  279 */,
	D(0x661F81FDUL, 0x99052A33UL)  /*  280 */,
	D(0x8736E641UL, 0xDB0F7B76UL)  /*  281 */,
	D(0x15227725UL, 0x418E5307UL)  /*  282 */,
	D(0xE25F7F46UL, 0x162EB2FAUL)  /*  283 */,
	D(0x48A8B212UL, 0x6C13D9FEUL)  /*  284 */,
	D(0xAFDC5417UL, 0x92E76EEAUL)  /*  285 */,
	D(0x03D912BFUL, 0xC6D1898FUL)  /*  286 */,
	D(0x31B1AAFAUL, 0x1B83F51BUL)  /*  287 */,
	D(0xF1AC2796UL, 0xE42AB7D9UL)  /*  288 */,
	D(0x40A3A7D7UL, 0xFCD2EBACUL)  /*  289 */,
	D(0x1056136DUL, 0x0AFBBCC5UL)  /*  290 */,
	D(0x7889E1DDUL, 0x9A6D0C85UL)  /*  291 */,
	D(0xD3352578UL, 0x2A7974AAUL)  /*  292 */,
	D(0xA7E25D09UL, 0x078AC09BUL)  /*  293 */,
	D(0xBD4138B3UL, 0xEAC6EDD0UL)  /*  294 */,
	D(0x920ABFBEUL, 0x71EB9E70UL)  /*  295 */,
	D(0xA2A5D0F5UL, 0x4FC2625CUL)  /*  296 */,
	D(0xC054E36BUL, 0x0B1290A3UL)  /*  297 */,
	D(0xF6DD59FFUL, 0x62FE932BUL)  /*  298 */,
	D(0x35373545UL, 0x11A8AC7DUL)  /*  299 */,
	D(0xCA845E91UL, 0x72FADCD4UL)  /*  300 */,
	D(0x84F82B60UL, 0x329D20DCUL)  /*  301 */,
	D(0x79C62CE1UL, 0xCD672F18UL)  /*  302 */,
	D(0x8B09A2ADUL, 0xD124642CUL)  /*  303 */,
	D(0xD0C1E96AUL, 0x19D9E726UL)  /*  304 */,
	D(0x5A786A9BUL, 0x4BA9500CUL)  /*  305 */,
	D(0x0E020336UL, 0x634C43F3UL)  /*  306 */,
	D(0xC17B474AUL, 0xEB66D822UL)  /*  307 */,
	D(0x6A731AE3UL, 0xEC9BAAC2UL)  /*  308 */,
	D(0x8226667AUL, 0xE0840258UL)  /*  309 */,
	D(0x67D45676UL, 0x91CAECA5UL)  /*  310 */,
	D(0x1D94155CUL, 0x4875ADB5UL)  /*  311 */,
	D(0x6D00FD98UL, 0x5B813FDFUL)  /*  312 */,
	D(0x51286EFCUL, 0xB774CD06UL)  /*  313 */,
	D(0x5E883447UL, 0x1FA744AFUL)  /*  314 */,
	D(0xF72CA0AEUL, 0xE761AE2EUL)  /*  315 */,
	D(0xBE40E4CDUL, 0xAEE8E09AUL)  /*  316 */,
	D(0xE9970BBBUL, 0x5118F665UL)  /*  317 */,
	D(0x726E4BEBUL, 0x33DF1964UL)  /*  318 */,
	D(0x703B0007UL, 0x29199762UL)  /*  319 */,
	D(0x4631D816UL, 0xF5EF30A7UL)  /*  320 */,
	D(0xB880B5B5UL, 0x1504A6BEUL)  /*  321 */,
	D(0x641793C3UL, 0x7ED84B6CUL)  /*  322 */,
	D(0x7B21ED77UL, 0xF6E97D96UL)  /*  323 */,
	D(0x77630631UL, 0x2EF96B73UL)  /*  324 */,
	D(0xAE528948UL, 0xE86FF3F4UL)  /*  325 */,
	D(0x53DBD7F2UL, 0x86A3F8F8UL)  /*  326 */,
	D(0x16CADCE7UL, 0x4CFC1063UL)  /*  327 */,
	D(0x005C19BDUL, 0xFA52C6DDUL)  /*  328 */,
	D(0x68868F5DUL, 0x64D46AD3UL)  /*  329 */,
	D(0x3A9D512CUL, 0xCF1E186AUL)  /*  330 */,
	D(0x367E62C2UL, 0x385660AEUL)  /*  331 */,
	D(0xE359E7EAUL, 0x77DCB1D7UL)  /*  332 */,
	D(0x526C0773UL, 0x749ABE6EUL)  /*  333 */,
	D(0x735AE5F9UL, 0xD09F734BUL)  /*  334 */,
	D(0x493FC7CCUL, 0x8A558BA8UL)  /*  335 */,
	D(0xB0B9C153UL, 0x3041AB45UL)  /*  336 */,
	D(0x321958BAUL, 0x470A59BDUL)  /*  337 */,
	D(0x852DB00BUL, 0x5F46C393UL)  /*  338 */,
	D(0x91209B2BUL, 0xD336B0E5UL)  /*  339 */,
	D(0x6E604F7DUL, 0x659EF19FUL)  /*  340 */,
	D(0xB99A8AE2UL, 0x782CCB24UL)  /*  341 */,
	D(0xCCF52AB6UL, 0xC814C4C7UL)  /*  342 */,
	D(0x4727D9AFUL, 0xBE11727BUL)  /*  343 */,
	D(0x7E950D0CUL, 0x0121B34DUL)  /*  344 */,
	D(0x756F4356UL, 0x70AD471FUL)  /*  345 */,
	D(0xF5ADD442UL, 0x615A6849UL)  /*  346 */,
	D(0x4E87E099UL, 0x80B9957AUL)  /*  347 */,
	D(0x2ACFA1DFUL, 0x50AEE355UL)  /*  348 */,
	D(0xD898263AUL, 0xFD2FD556UL)  /*  349 */,
	D(0xC8F4924DUL, 0xD80C8FD6UL)  /*  350 */,
	D(0xCF99CA3DUL, 0x754A173AUL)  /*  351 */,
	D(0xFE477BACUL, 0xAF91BF3CUL)  /*  352 */,
	D(0xED5371F6UL, 0xD690C12DUL)  /*  353 */,
	D(0x831A5C28UL, 0x5E687094UL)  /*  354 */,
	D(0xC5D3C90AUL, 0x3708A0A4UL)  /*  355 */,
	D(0x0F7F9037UL, 0x17D06580UL)  /*  356 */,
	D(0x19F9BB13UL, 0xB8FDF27FUL)  /*  357 */,
	D(0xB1BD6F1BUL, 0x4D502843UL)  /*  358 */,
	D(0x1C761BA3UL, 0x8FFF4012UL)  /*  359 */,
	D(0x0D1530C4UL, 0xE2E21F3BUL)  /*  360 */,
	D(0x8943CE69UL, 0xA7372C8AUL)  /*  361 */,
	D(0xE5184E11UL, 0xFEB5CE66UL)  /*  362 */,
	D(0x618BDB80UL, 0xBD736621UL)  /*  363 */,
	D(0x7D29BAD6UL, 0x8B574D0BUL)  /*  364 */,
	D(0x81BB613EUL, 0x25E6FE5BUL)  /*  365 */,
	D(0x071C9C10UL, 0xBC07913FUL)  /*  366 */,
	D(0xC7BEEB79UL, 0x09AC2D97UL)  /*  367 */,
	D(0xC3E58D35UL, 0x3BC5D757UL)  /*  368 */,
	D(0xEB017892UL, 0xF38F61E8UL)  /*  369 */,
	D(0xD4EFFB9CUL, 0x9B1CC21AUL)  /*  370 */,
	D(0x99727D26UL, 0xF494F7ABUL)  /*  371 */,
	D(0xA3E063A2UL, 0x956B3E03UL)  /*  372 */,
	D(0x9D4A8B9AUL, 0x4AA09C30UL)  /*  373 */,
	D(0x3F6AB7D5UL, 0x00090FB4UL)  /*  374 */,
	D(0x9CC0F2A0UL, 0x57268AC0UL)  /*  375 */,
	D(0x3DEE9D2DUL, 0xEDBF42D1UL)  /*  376 */,
	D(0x330F49C8UL, 0x7960A972UL)  /*  377 */,
	D(0xC6B27202UL, 0x87421B41UL)  /*  378 */,
	D(0x0AC59EC0UL, 0x7C00369CUL)  /*  379 */,
	D(0xEF4EAC49UL, 0xCB353425UL)  /*  380 */,
	D(0xF450244EUL, 0xEF0129D8UL)  /*  381 */,
	D(0x8ACC46E5UL, 0xCAF4DEB6UL)  /*  382 */,
	D(0x2FFEAB63UL, 0x989263F7UL)  /*  383 */,
	D(0x8F7CB9FEUL, 0x5D7A4578UL)  /*  384 */,
	D(0x5BD8F764UL, 0x4E634635UL)  /*  385 */,
	D(0x427A7315UL, 0xBF2DC900UL)  /*  386 */,
	D(0x17D0C4AAUL, 0x2125261CUL)  /*  387 */,
	D(0x3992486CUL, 0x93518E50UL)  /*  388 */,
	D(0xB4CBFEE0UL, 0xA2D7D4C3UL)  /*  389 */,
	D(0x7C75D620UL, 0x2C5DDD8DUL)  /*  390 */,
	D(0xDBC295D8UL, 0xE35B6C61UL)  /*  391 */,
	D(0x60B369D3UL, 0x02032B19UL)  /*  392 */,
	D(0xCE42685FUL, 0xDCE44132UL)  /*  393 */,
	D(0x06F3DDB9UL, 0xDDF65610UL)  /*  394 */,
	D(0x8EA4D21DUL, 0xB5E148F0UL)  /*  395 */,
	D(0x20B0FCE6UL, 0x2FCD496FUL)  /*  396 */,
	D(0x2C1B9123UL, 0x58B0EE31UL)  /*  397 */,
	D(0xB28317B8UL, 0x18F5A308UL)  /*  398 */,
	D(0xA89C1E18UL, 0x9CA6D2CFUL)  /*  399 */,
	D(0x0C6B1857UL, 0x6AAADBC8UL)  /*  400 */,
	D(0xB65DEAA9UL, 0x1299FAE3UL)  /*  401 */,
	D(0xFB2B794BUL, 0x7F1027E7UL)  /*  402 */,
	D(0x04E4317FUL, 0x443B5BEBUL)  /*  403 */,
	D(0x4B852D32UL, 0x5939D0A6UL)  /*  404 */,
	D(0xD5AE6BEEUL, 0xFB207FFCUL)  /*  405 */,
	D(0x309682B2UL, 0x81C7D374UL)  /*  406 */,
	D(0xBAE309A1UL, 0x94C3B475UL)  /*  407 */,
	D(0x8CC3F97BUL, 0x13B49F05UL)  /*  408 */,
	D(0x98A9422FUL, 0xF8293967UL)  /*  409 */,
	D(0x244B16B0UL, 0x1076FF7CUL)  /*  410 */,
	D(0xF8BF571CUL, 0x663D67EEUL)  /*  411 */,
	D(0x1F0D6758UL, 0xEEE30DA1UL)  /*  412 */,
	D(0xC9B611D9UL, 0x7ADEB9B7UL)  /*  413 */,
	D(0xB7AFD588UL, 0x7B6C57A2UL)  /*  414 */,
	D(0x6290AE84UL, 0x6B984FE1UL)  /*  415 */,
	D(0x94DF4CDEUL, 0xACC1A5FDUL)  /*  416 */,
	D(0x058A5BD1UL, 0xC5483AFFUL)  /*  417 */,
	D(0x63166CC1UL, 0x42BA3C37UL)  /*  418 */,
	D(0x8DB8526EUL, 0xB2F76F40UL)  /*  419 */,
	D(0xE1088003UL, 0x6F0D6D4EUL)  /*  420 */,
	D(0x9E0523C9UL, 0x971D311DUL)  /*  421 */,
	D(0x45EC2824UL, 0xCC7CD691UL)  /*  422 */,
	D(0x575B8359UL, 0xE62382C9UL)  /*  423 */,
	D(0xFA9E400DUL, 0xC4889995UL)  /*  424 */,
	D(0xD1823ECBUL, 0x45721568UL)  /*  425 */,
	D(0xDAFD983BUL, 0x8206082FUL)  /*  426 */,
	D(0xAA7D2908UL, 0x2386A8CBUL)  /*  427 */,
	D(0x269FCD44UL, 0x03B87588UL)  /*  428 */,
	D(0x1B91F5F7UL, 0x28BDD1E0UL)  /*  429 */,
	D(0xE4669F39UL, 0x040201F6UL)  /*  430 */,
	D(0x7A1D7C21UL, 0x8CF04ADEUL)  /*  431 */,
	D(0x65623C29UL, 0xD79CE5CEUL)  /*  432 */,
	D(0x23684490UL, 0x96C00BB1UL)  /*  433 */,
	D(0xAB9BF187UL, 0x9DA503BAUL)  /*  434 */,
	D(0xBC23ECB1UL, 0xA458058EUL)  /*  435 */,
	D(0x9A58DF01UL, 0xBB401ECCUL)  /*  436 */,
	D(0xA070E868UL, 0xA85F143DUL)  /*  437 */,
	D(0x4FF18830UL, 0x7DF2239EUL)  /*  438 */,
	D(0x14D565B4UL, 0x1A641183UL)  /*  439 */,
	D(0xEE133374UL, 0x52701602UL)  /*  440 */,
	D(0x950E3DCFUL, 0x3F285E09UL)  /*  441 */,
	D(0x59930254UL, 0xB9C80953UL)  /*  442 */,
	D(0x3BF29940UL, 0x8930DA6DUL)  /*  443 */,
	D(0xA955943FUL, 0x53691387UL)  /*  444 */,
	D(0xA15EDECAUL, 0xA9CB8784UL)  /*  445 */,
	D(0x29142127UL, 0x352BE9A0UL)  /*  446 */,
	D(0x76F0371FUL, 0xFF4E7AFBUL)  /*  447 */,
	D(0x0239F450UL, 0x274F2228UL)  /*  448 */,
	D(0xBB073AF0UL, 0x1D5E868BUL)  /*  449 */,
	D(0xBFC80571UL, 0xC10E96C1UL)  /*  450 */,
	D(0xD2670885UL, 0x68222E23UL)  /*  451 */,
	D(0x9671A3D4UL, 0x8E80B5B0UL)  /*  452 */,
	D(0x55B5D38AUL, 0xE193BB81UL)  /*  453 */,
	D(0x693AE2D0UL, 0xA18B04B8UL)  /*  454 */,
	D(0x5C48B4ECUL, 0xADD5335FUL)  /*  455 */,
	D(0xFD743B19UL, 0x4916A1CAUL)  /*  456 */,
	D(0x25770181UL, 0x34BE98C4UL)  /*  457 */,
	D(0xE77987E8UL, 0x3C54A4ADUL)  /*  458 */,
	D(0x28E11014UL, 0xDA33E1B9UL)  /*  459 */,
	D(0x270CC59EUL, 0x226AA213UL)  /*  460 */,
	D(0x71495F75UL, 0x6D1A5F60UL)  /*  461 */,
	D(0x9BE853FBUL, 0x60AFEF77UL)  /*  462 */,
	D(0xADC786A7UL, 0xF7443DBFUL)  /*  463 */,
	D(0x09044561UL, 0x73B29A82UL)  /*  464 */,
	D(0x58BC7A66UL, 0xC232BD5EUL)  /*  465 */,
	D(0xF306558CUL, 0x673AC8B2UL)  /*  466 */,
	D(0x41F639C6UL, 0xB6C9772AUL)  /*  467 */,
	D(0x216DEFE9UL, 0x9FDA35DAUL)  /*  468 */,
	D(0x11640CC7UL, 0x1C7BE615UL)  /*  469 */,
	D(0x93C43694UL, 0x565C5527UL)  /*  470 */,
	D(0xEA038E62UL, 0x46777839UL)  /*  471 */,
	D(0xF9ABF3CEUL, 0x5A3E2469UL)  /*  472 */,
	D(0x741E768DUL, 0x0FD312D2UL)  /*  473 */,
	D(0x0144B883UL, 0xCED652C6UL)  /*  474 */,
	D(0xC20B5A5BUL, 0xA33F8552UL)  /*  475 */,
	D(0x1AE69633UL, 0xC3435A9DUL)  /*  476 */,
	D(0x97A28CA4UL, 0x088CFDECUL)  /*  477 */,
	D(0x8824A43CUL, 0x1E96F420UL)  /*  478 */,
	D(0x37612FA6UL, 0x6EEEA746UL)  /*  479 */,
	D(0x6B4CB165UL, 0xF9CF0E5AUL)  /*  480 */,
	D(0x43AA1C06UL, 0xA0ABFB4AUL)  /*  481 */,
	D(0x7F4DC26FUL, 0xF162796BUL)  /*  482 */,
	D(0x6CBACC8EUL, 0x54ED9B0FUL)  /*  483 */,
	D(0xA6B7FFEFUL, 0xD2BB253EUL)  /*  484 */,
	D(0x2E25BC95UL, 0xB0A29D4FUL)  /*  485 */,
	D(0x86D6A58BUL, 0xDEF1388CUL)  /*  486 */,
	D(0xDED74AC5UL, 0x76B6F054UL)  /*  487 */,
	D(0x8030BDBCUL, 0x2B45805DUL)  /*  488 */,
	D(0x3C81AF70UL, 0xE94D9289UL)  /*  489 */,
	D(0x3EFF6DDAUL, 0x9E3100DBUL)  /*  490 */,
	D(0xB38DC39FUL, 0xDFCC8847UL)  /*  491 */,
	D(0x12388552UL, 0x8D17B87EUL)  /*  492 */,
	D(0xF2DA0ED2UL, 0x40B1B642UL)  /*  493 */,
	D(0x44CEFADCUL, 0xD54BF9A9UL)  /*  494 */,
	D(0x1312200EUL, 0x433C7EE6UL)  /*  495 */,
	D(0x9FFCC84FUL, 0x3A78C748UL)  /*  496 */,
	D(0xF0CD1F72UL, 0x248576BBUL)  /*  497 */,
	D(0xEC697405UL, 0x3638CFE4UL)  /*  498 */,
	D(0x2BA7B67CUL, 0x0CEC4E4CUL)  /*  499 */,
	D(0xAC2F4DF3UL, 0xE5CE32EDUL)  /*  500 */,
	D(0xCB33D143UL, 0x26EA4C11UL)  /*  501 */,
	D(0xA4E9044CUL, 0xC77E58BCUL)  /*  502 */,
	D(0x5F513293UL, 0xD934FCEFUL)  /*  503 */,
	D(0x5DC96455UL, 0x06E55444UL)  /*  504 */,
	D(0x50DE418FUL, 0x317DE40AUL)  /*  505 */,
	D(0x388CB31AUL, 0x69DDE259UL)  /*  506 */,
	D(0x2DB4A834UL, 0x55820A86UL)  /*  507 */,
	D(0x9010A91EUL, 0x84711AE9UL)  /*  508 */,
	D(0x4DF7F0B7UL, 0xB1498371UL)  /*  509 */,
	D(0xD62A2EABUL, 0xC0977179UL)  /*  510 */,
	D(0x22FAC097UL, 0xAA8D5C0EUL)  /*  511 */,
	D(0xF49FCC2FUL, 0xF1DAF39BUL)  /*  512 */,
	D(0x487FD5C6UL, 0x6FF29281UL)  /*  513 */,
	D(0xE8A30667UL, 0xFCDCA83FUL)  /*  514 */,
	D(0x2C9B4BE3UL, 0xD2FCCE63UL)  /*  515 */,
	D(0xDA3FF74BUL, 0x93FBBBC2UL)  /*  516 */,
	D(0x2FA165D2UL, 0xFE70BA66UL)  /*  517 */,
	D(0xA103E279UL, 0x970E93D4UL)  /*  518 */,
	D(0xBECDEC77UL, 0xB0E45E71UL)  /*  519 */,
	D(0xCFB41E72UL, 0x3985E497UL)  /*  520 */,
	D(0xB70AAA02UL, 0x5EF75017UL)  /*  521 */,
	D(0xD42309F0UL, 0x3840B8E0UL)  /*  522 */,
	D(0x8EFC1AD0UL, 0x35898579UL)  /*  523 */,
	D(0x96C6920BUL, 0xE2B2ABC5UL)  /*  524 */,
	D(0x66AF4163UL, 0x375A9172UL)  /*  525 */,
	D(0x2174ABDCUL, 0xCA7127FBUL)  /*  526 */,
	D(0xB33CCEA6UL, 0x4A72FF41UL)  /*  527 */,
	D(0xF04A4933UL, 0x083066A5UL)  /*  528 */,
	D(0x8D970ACDUL, 0xD7289AF5UL)  /*  529 */,
	D(0x8F96E8E0UL, 0x31C8C25EUL)  /*  530 */,
	D(0xF3FEC022UL, 0x76875D47UL)  /*  531 */,
	D(0xEC7BF310UL, 0x056190DDUL)  /*  532 */,
	D(0xF5ADB0AEUL, 0xBB0F1491UL)  /*  533 */,
	D(0x9B50F885UL, 0x0FD58892UL)  /*  534 */,
	D(0x49754883UL, 0x58B74DE8UL)  /*  535 */,
	D(0xA3354FF6UL, 0x91531C61UL)  /*  536 */,
	D(0x0702BBE4UL, 0x81D2C6EEUL)  /*  537 */,
	D(0x89FB2405UL, 0x7DEDED98UL)  /*  538 */,
	D(0xAC307513UL, 0x8596E902UL)  /*  539 */,
	D(0x1D2D3580UL, 0x172772EDUL)  /*  540 */,
	D(0xEB738FC2UL, 0x8E6BC30DUL)  /*  541 */,
	D(0x5854EF8FUL, 0x63044326UL)  /*  542 */,
	D(0x9E5C5232UL, 0x5ADD3BBEUL)  /*  543 */,
	D(0x90AA53CFUL, 0x325C4623UL)  /*  544 */,
	D(0xC1D24D51UL, 0x349DD067UL)  /*  545 */,
	D(0x2051CFEEUL, 0xA69EA624UL)  /*  546 */,
	D(0x13220F0AUL, 0x862E7E4FUL)  /*  547 */,
	D(0xCE393994UL, 0x04E04864UL)  /*  548 */,
	D(0xD9C42CA4UL, 0x7086FCB7UL)  /*  549 */,
	D(0x685AD223UL, 0x8A03E7CCUL)  /*  550 */,
	D(0x066484B2UL, 0xAB2FF1DBUL)  /*  551 */,
	D(0xFE9D5D70UL, 0xEFBF79ECUL)  /*  552 */,
	D(0x5B13B9DDUL, 0x9C481854UL)  /*  553 */,
	D(0x15F0D475UL, 0xED1509ADUL)  /*  554 */,
	D(0x0BEBCD06UL, 0x0EC79851UL)  /*  555 */,
	D(0xD58C6791UL, 0x183AB7F8UL)  /*  556 */,
	D(0xD1187C50UL, 0x52F3EEE4UL)  /*  557 */,
	D(0xC95D1192UL, 0xE54E82FFUL)  /*  558 */,
	D(0x86EEA14CUL, 0xB9AC6CA2UL)  /*  559 */,
	D(0x3485BEB1UL, 0x53677D5DUL)  /*  560 */,
	D(0xDD191D78UL, 0x1F8C492AUL)  /*  561 */,
	D(0xF60866BAUL, 0xA784EBF9UL)  /*  562 */,
	D(0x518F643BUL, 0xA2D08C74UL)  /*  563 */,
	D(0x8852E956UL, 0xE1087C22UL)  /*  564 */,
	D(0xA768CB8DUL, 0xC410AE8DUL)  /*  565 */,
	D(0x38047726UL, 0xBFEC8E1AUL)  /*  566 */,
	D(0xA67738B4UL, 0xCD3B45AAUL)  /*  567 */,
	D(0xAD16691CUL, 0xEC0DDE19UL)  /*  568 */,
	D(0xC6D43193UL, 0x80462E07UL)  /*  569 */,
	D(0xC5A5876DUL, 0x0BA61938UL)  /*  570 */,
	D(0x16B9FA1FUL, 0xA58FD840UL)  /*  571 */,
	D(0x188AB117UL, 0x3CA74F18UL)  /*  572 */,
	D(0xABDA2F98UL, 0xC99C021FUL)  /*  573 */,
	D(0x3E0580ABUL, 0x134AE816UL)  /*  574 */,
	D(0x5F3B05B7UL, 0x73645ABBUL)  /*  575 */,
	D(0x2501A2BEUL, 0x5575F2F6UL)  /*  576 */,
	D(0x1B2F7400UL, 0x4E7E8BA9UL)  /*  577 */,
	D(0x1CD75803UL, 0x71E8D953UL)  /*  578 */,
	D(0x7F6ED895UL, 0x62764E30UL)  /*  579 */,
	D(0xB15926FFUL, 0x596F003DUL)  /*  580 */,
	D(0x9F65293DUL, 0xA8C5D6B9UL)  /*  581 */,
	D(0x6ECEF04DUL, 0xD690F84CUL)  /*  582 */,
	D(0x4782275FUL, 0xFF33AF88UL)  /*  583 */,
	D(0xE4143308UL, 0x3F820801UL)  /*  584 */,
	D(0xFD0DFE40UL, 0x9A1AF9B5UL)  /*  585 */,
	D(0x4325A334UL, 0x2CDB396BUL)  /*  586 */,
	D(0x8AE77E62UL, 0xB301B252UL)  /*  587 */,
	D(0xC36F9E9FUL, 0x6655615AUL)  /*  588 */,
	D(0x85455A2DUL, 0x92D32C09UL)  /*  589 */,
	D(0xF2C7DEA9UL, 0x49477485UL)  /*  590 */,
	D(0x63CFB4C1UL, 0x33A39EBAUL)  /*  591 */,
	D(0x83B040CCUL, 0x6EBC5462UL)  /*  592 */,
	D(0x3B9454C8UL, 0xFDB326B0UL)  /*  593 */,
	D(0x56F56A9EUL, 0x87FFD78CUL)  /*  594 */,
	D(0x2DC2940DUL, 0x99F42BC6UL)  /*  595 */,
	D(0x98F7DF09UL, 0x6B096E2DUL)  /*  596 */,
	D(0x19A6E01EUL, 0x3AD852BFUL)  /*  597 */,
	D(0x42A99CCBUL, 0xDBD4B40BUL)  /*  598 */,
	D(0xA59998AFUL, 0x45E9C559UL)  /*  599 */,
	D(0x366295E8UL, 0x07D93186UL)  /*  600 */,
	D(0x6B48181BUL, 0xFAA1F773UL)  /*  601 */,
	D(0x1FEC57E2UL, 0x157A0A1DUL)  /*  602 */,
	D(0x4667446AUL, 0xF6201AD5UL)  /*  603 */,
	D(0xE615EBCAUL, 0xCFB0F075UL)  /*  604 */,
	D(0xB8F31F4FUL, 0x68290778UL)  /*  605 */,
	D(0x22713ED6UL, 0xCE22D11EUL)  /*  606 */,
	D(0x3057C1A7UL, 0x2EC3C93BUL)  /*  607 */,
	D(0xCB46ACC3UL, 0x7C3F1F2FUL)  /*  608 */,
	D(0xDBB893FDUL, 0x02AAF50EUL)  /*  609 */,
	D(0x331FD92EUL, 0x600B9FCFUL)  /*  610 */,
	D(0xA498F961UL, 0x48EA3AD6UL)  /*  611 */,
	D(0xA8D8426EUL, 0x8B6A83EAUL)  /*  612 */,
	D(0xA089B274UL, 0xB7735CDCUL)  /*  613 */,
	D(0x87F6B373UL, 0x1E524A11UL)  /*  614 */,
	D(0x118808E5UL, 0xCBC96749UL)  /*  615 */,
	D(0x9906E4C7UL, 0xB19BD394UL)  /*  616 */,
	D(0xAFED7F7EUL, 0x9B24A20CUL)  /*  617 */,
	D(0x6509EADEUL, 0xEB3644A7UL)  /*  618 */,
	D(0x6C1EF1D3UL, 0xE8EF0EDEUL)  /*  619 */,
	D(0xB9C97D43UL, 0xE9798FB4UL)  /*  620 */,
	D(0xA2F2D784UL, 0x740C28A3UL)  /*  621 */,
	D(0x7B849647UL, 0x6197566FUL)  /*  622 */,
	D(0x7A5BE3E6UL, 0xB65F069DUL)  /*  623 */,
	D(0xF96330EDUL, 0x78BE6F10UL)  /*  624 */,
	D(0xEEE60DE7UL, 0x7A076A15UL)  /*  625 */,
	D(0x2B4BEE4AUL, 0xA08B9BD0UL)  /*  626 */,
	D(0x6A56A63EUL, 0xC7B8894EUL)  /*  627 */,
	D(0x02121359UL, 0xBA34FEF4UL)  /*  628 */,
	D(0x4CBF99F8UL, 0x283703FCUL)  /*  629 */,
	D(0x39807135UL, 0x0CAF30C8UL)  /*  630 */,
	D(0xD0A77A89UL, 0xF017687AUL)  /*  631 */,
	D(0xF1C1A9EBUL, 0x9E423569UL)  /*  632 */,
	D(0x8C797628UL, 0x2DEE8199UL)  /*  633 */,
	D(0x5D1737A5UL, 0xDD1F7ABDUL)  /*  634 */,
	D(0x4F53433CUL, 0x09A9FA80UL)  /*  635 */,
	D(0xFA8B0C53UL, 0xDF7CA1D9UL)  /*  636 */,
	D(0x3FD9DCBCUL, 0x886CCB77UL)  /*  637 */,
	D(0xC040917CUL, 0xA91B4720UL)  /*  638 */,
	D(0x7DD00142UL, 0xF9D1DCDFUL)  /*  639 */,
	D(0x8476FC1DUL, 0x4F387B58UL)  /*  640 */,
	D(0x23F8E7C5UL, 0xF3316503UL)  /*  641 */,
	D(0x032A2244UL, 0xE7E37339UL)  /*  642 */,
	D(0x5C87A5D7UL, 0x50F5A74BUL)  /*  643 */,
	D(0x082B4CC4UL, 0x3698992EUL)  /*  644 */,
	D(0xDF917BECUL, 0xB858F63CUL)  /*  645 */,
	D(0x3270B8FCUL, 0x5BF86DDAUL)  /*  646 */,
	D(0x10AE72BBUL, 0x29B5DD76UL)  /*  647 */,
	D(0x576AC94EUL, 0x7700362BUL)  /*  648 */,
	D(0x1AD112DAUL, 0xC61EFB8FUL)  /*  649 */,
	D(0x691BC30EUL, 0xC5FAA427UL)  /*  650 */,
	D(0xFF246311UL, 0xCC327143UL)  /*  651 */,
	D(0x3142368EUL, 0x30E53206UL)  /*  652 */,
	D(0x71380E31UL, 0xE02CA396UL)  /*  653 */,
	D(0x958D5C96UL, 0x0AAD76F1UL)  /*  654 */,
	D(0xF8D6F430UL, 0xC16DA536UL)  /*  655 */,
	D(0xC8FFD13FUL, 0x1BE7E1D2UL)  /*  656 */,
	D(0x7578AE66UL, 0x004DDBE1UL)  /*  657 */,
	D(0x05833F01UL, 0x067BE646UL)  /*  658 */,
	D(0xBB34B5ADUL, 0x3BFE586DUL)  /*  659 */,
	D(0x095F34C9UL, 0xA12B97F0UL)  /*  660 */,
	D(0x247AB645UL, 0x25D60CA8UL)  /*  661 */,
	D(0xDCDBC6F3UL, 0x017477D1UL)  /*  662 */,
	D(0x4A2E14D4UL, 0xDECAD24DUL)  /*  663 */,
	D(0xBDB5E6D9UL, 0xBE0A1EEBUL)  /*  664 */,
	D(0x2A7E70F7UL, 0x794301ABUL)  /*  665 */,
	D(0xDEF42D8AUL, 0x270540FDUL)  /*  666 */,
	D(0x01078EC0UL, 0xA34C22C1UL)  /*  667 */,
	D(0xE5DE511AUL, 0xF4C16387UL)  /*  668 */,
	D(0x7EBB3A52UL, 0xBD9A330AUL)  /*  669 */,
	D(0x77697857UL, 0xAA7D6435UL)  /*  670 */,
	D(0x004E8316UL, 0x03AE4C32UL)  /*  671 */,
	D(0xE7A21020UL, 0xAD78E312UL)  /*  672 */,
	D(0x9D41A70CUL, 0x6AB420F2UL)  /*  673 */,
	D(0x28E06C18UL, 0xEA1141E6UL)  /*  674 */,
	D(0xD2B28CBDUL, 0x984F6B28UL)  /*  675 */,
	D(0x26B75F6CUL, 0x446E9D83UL)  /*  676 */,
	D(0xBA47568CUL, 0x4D418D7FUL)  /*  677 */,
	D(0xD80BADBFUL, 0xE6183D8EUL)  /*  678 */,
	D(0x0E206D7FUL, 0x5F166044UL)  /*  679 */,
	D(0xE258A439UL, 0x11CBCA3EUL)  /*  680 */,
	D(0x723A1746UL, 0xB21DC0BCUL)  /*  681 */,
	D(0xC7CAA854UL, 0xF5D7CDD3UL)  /*  682 */,
	D(0x7CAC3288UL, 0x3D261D9CUL)  /*  683 */,
	D(0x7690C264UL, 0x23BA942CUL)  /*  684 */,
	D(0x17E55524UL, 0x478042B8UL)  /*  685 */,
	D(0xE0BE4776UL, 0x56A2389FUL)  /*  686 */,
	D(0x4D289B5EUL, 0x67AB2DA0UL)  /*  687 */,
	D(0x44862B9CUL, 0x8FBBFD31UL)  /*  688 */,
	D(0xB47CC804UL, 0x9D141365UL)  /*  689 */,
	D(0x822C1B36UL, 0x2B91C793UL)  /*  690 */,
	D(0x4EB14655UL, 0xFB13DFD8UL)  /*  691 */,
	D(0x1ECBBA07UL, 0x14E2A97BUL)  /*  692 */,
	D(0x6143459DUL, 0x5CDE5F14UL)  /*  693 */,
	D(0x53A8FBF1UL, 0xD5F0AC89UL)  /*  694 */,
	D(0x97EA04D8UL, 0x1C5E5B00UL)  /*  695 */,
	D(0x622181A8UL, 0xD4FDB3F3UL)  /*  696 */,
	D(0xE9BCD341UL, 0x572A1208UL)  /*  697 */,
	D(0x14112586UL, 0x43CCE58AUL)  /*  698 */,
	D(0x9144C5FEUL, 0xA4C6E0A4UL)  /*  699 */,
	D(0x0D33D065UL, 0x65CF620FUL)  /*  700 */,
	D(0x54A48D48UL, 0x9F219CA1UL)  /*  701 */,
	D(0xC43E5EACUL, 0x6D63C821UL)  /*  702 */,
	D(0xA9728B3AUL, 0x72770DAFUL)  /*  703 */,
	D(0xD7934E7BUL, 0x20DF87EFUL)  /*  704 */,
	D(0xE35503B6UL, 0x1A3E86E5UL)  /*  705 */,
	D(0xCAE321FBUL, 0xC819D504UL)  /*  706 */,
	D(0x129A50B3UL, 0xAC60BFA6UL)  /*  707 */,
	D(0xCD5E68EAUL, 0x7E9FB6C3UL)  /*  708 */,
	D(0xB01C9019UL, 0x9483B1C7UL)  /*  709 */,
	D(0x3DE93CD5UL, 0xC295376CUL)  /*  710 */,
	D(0xAED52EDFUL, 0x2AB9AD13UL)  /*  711 */,
	D(0x2E60F512UL, 0xC0A07884UL)  /*  712 */,
	D(0xBC3D86A3UL, 0xE36210C9UL)  /*  713 */,
	D(0x35269D9BUL, 0x163951CEUL)  /*  714 */,
	D(0x0C7D6E2AUL, 0xD0CDB5FAUL)  /*  715 */,
	D(0x59E86297UL, 0xD87F5733UL)  /*  716 */,
	D(0x298EF221UL, 0x898DB0E7UL)  /*  717 */,
	D(0x55000029UL, 0xD1A5AA7EUL)  /*  718 */,
	D(0x8BC08AE1UL, 0xB5061B45UL)  /*  719 */,
	D(0xC2C31C2BUL, 0x6C92703AUL)  /*  720 */,
	D(0x94CC596BUL, 0xAF25EF42UL)  /*  721 */,
	D(0x0A1D73DBUL, 0x22540456UL)  /*  722 */,
	D(0x04B6A0F9UL, 0xD9C4179AUL)  /*  723 */,
	D(0xEFFDAFA2UL, 0xAE3D3C60UL)  /*  724 */,
	D(0xF7C8075BUL, 0xB49496C4UL)  /*  725 */,
	D(0x9CC5C714UL, 0x1D1CD4E3UL)  /*  726 */,
	D(0x78BD1638UL, 0x218E5534UL)  /*  727 */,
	D(0xB2F11568UL, 0xF850246AUL)  /*  728 */,
	D(0xEDFABCFAUL, 0x9502BC29UL)  /*  729 */,
	D(0x796CE5F2UL, 0xDA23051BUL)  /*  730 */,
	D(0xAAE128B0UL, 0xDC93537CUL)  /*  731 */,
	D(0x3A493DA0UL, 0xEE4B29AEUL)  /*  732 */,
	D(0xB5DF6B2CUL, 0x416895D7UL)  /*  733 */,
	D(0xFCABBD25UL, 0x122D7F37UL)  /*  734 */,
	D(0x70810B58UL, 0x105DC4B1UL)  /*  735 */,
	D(0xE10FDD37UL, 0xF7882A90UL)  /*  736 */,
	D(0x524DCAB5UL, 0x518A3F5CUL)  /*  737 */,
	D(0x3C9E8587UL, 0x8451255BUL)  /*  738 */,
	D(0x40298281UL, 0x19BD34E2UL)  /*  739 */,
	D(0x74A05B6FUL, 0x5D3CECCBUL)  /*  740 */,
	D(0xB6100215UL, 0x42E13ECAUL)  /*  741 */,
	D(0x0FF979D1UL, 0x2F59E2ACUL)  /*  742 */,
	D(0x6037DA27UL, 0xE4F9CC50UL)  /*  743 */,
	D(0x5E92975AUL, 0x0DF1847DUL)  /*  744 */,
	D(0xD66DE190UL, 0xD3E623FEUL)  /*  745 */,
	D(0x5032D6B8UL, 0x7B568048UL)  /*  746 */,
	D(0x9A36B7CEUL, 0x8235216EUL)  /*  747 */,
	D(0x80272A7AUL, 0x24F64B4AUL)  /*  748 */,
	D(0x93EFED8BUL, 0x8C6916F7UL)  /*  749 */,
	D(0x37DDBFF4UL, 0x4CCE1555UL)  /*  750 */,
	D(0x4B95DB5DUL, 0x4B99BD25UL)  /*  751 */,
	D(0x92D3FDA1UL, 0x69812FC0UL)  /*  752 */,
	D(0xFB1A4A9AUL, 0x90660BB6UL)  /*  753 */,
	D(0x730C1969UL, 0x46A4B9B2UL)  /*  754 */,
	D(0x81E289AAUL, 0x7F49DA68UL)  /*  755 */,
	D(0x64669A0FUL, 0x83B1A05FUL)  /*  756 */,
	D(0x27B3FF7DUL, 0x9644F48BUL)  /*  757 */,
	D(0xCC6B615CUL, 0x8DB675B3UL)  /*  758 */,
	D(0x674F20B9UL, 0xBCEBBE95UL)  /*  759 */,
	D(0x6F312382UL, 0x75655982UL)  /*  760 */,
	D(0x5AE48871UL, 0x3E45CF05UL)  /*  761 */,
	D(0xBF619F99UL, 0x54C21157UL)  /*  762 */,
	D(0xEABAC460UL, 0x40A8EAE9UL)  /*  763 */,
	D(0x454C6FE9UL, 0xF2C0C1CDUL)  /*  764 */,
	D(0x419CF649UL, 0x6412691CUL)  /*  765 */,
	D(0xD3DC3BEFUL, 0x265B0F70UL)  /*  766 */,
	D(0x6D0E60F5UL, 0xC3578A9EUL)  /*  767 */,
	D(0x5B0E6085UL, 0x26323C55UL)  /*  768 */,
	D(0x1A46C1A9UL, 0xFA1B59F5UL)  /*  769 */,
	D(0xA9E245A1UL, 0x7C4C8FFAUL)  /*  770 */,
	D(0x65CA5159UL, 0xDB2955D7UL)  /*  771 */,
	D(0x05DB0A76UL, 0xCE35AFC2UL)  /*  772 */,
	D(0x81EAC77EUL, 0xA9113D45UL)  /*  773 */,
	D(0x528EF88AUL, 0xB6AC0A0DUL)  /*  774 */,
	D(0xA09EA253UL, 0x597BE3FFUL)  /*  775 */,
	D(0x430DDFB3UL, 0xAC48CD56UL)  /*  776 */,
	D(0xC4B3A67AUL, 0xF45CE46FUL)  /*  777 */,
	D(0x4ECECFD8UL, 0xFBE2D05EUL)  /*  778 */,
	D(0x3EF56F10UL, 0xB39935F0UL)  /*  779 */,
	D(0x0B22D682UL, 0x9CD619C6UL)  /*  780 */,
	D(0x17FD460AUL, 0x74DF2069UL)  /*  781 */,
	D(0x6CF8CC8EUL, 0x8510ED40UL)  /*  782 */,
	D(0xD6C824BFUL, 0x3A6ECAA7UL)  /*  783 */,
	D(0x61243D58UL, 0x1A817049UL)  /*  784 */,
	D(0x048BACB6UL, 0xBBC163A2UL)  /*  785 */,
	D(0xD9A38AC2UL, 0x7D44CC32UL)  /*  786 */,
	D(0x7FDDFF5BUL, 0xAAF410ABUL)  /*  787 */,
	D(0xAD6D495AUL, 0xA804824BUL)  /*  788 */,
	D(0xE1A6A74FUL, 0x2D8C9F94UL)  /*  789 */,
	D(0xD4F78512UL, 0x35DEE8E3UL)  /*  790 */,
	D(0xFD4B7F88UL, 0x6540D893UL)  /*  791 */,
	D(0x247C2004UL, 0x2AA4BFDAUL)  /*  792 */,
	D(0x096EA1C5UL, 0x17D1327CUL)  /*  793 */,
	D(0xD56966B4UL, 0x361A6685UL)  /*  794 */,
	D(0x277DA5C3UL, 0x1221057DUL)  /*  795 */,
	D(0x94D59893UL, 0xA43ACFF7UL)  /*  796 */,
	D(0x64F0C51CUL, 0xCDC02281UL)  /*  797 */,
	D(0x3D33BCC4UL, 0xFF6189DBUL)  /*  798 */,
	D(0xE005CB18UL, 0x4CE66AF1UL)  /*  799 */,
	D(0xFF5CCD1DUL, 0x1DB99BEAUL)  /*  800 */,
	D(0xB0B854A7UL, 0xFE42980FUL)  /*  801 */,
	D(0x7BD46A6AUL, 0x718D4B9FUL)  /*  802 */,
	D(0xD10FA8CCUL, 0x22A5FD8CUL)  /*  803 */,
	D(0xD3148495UL, 0x2BE4BD31UL)  /*  804 */,
	D(0xC7FA975FUL, 0xCB243847UL)  /*  805 */,
	D(0x4886ED1EUL, 0x5846C407UL)  /*  806 */,
	D(0x28CDDB79UL, 0x1EB70B04UL)  /*  807 */,
	D(0xC2B00BE2UL, 0xF573417FUL)  /*  808 */,
	D(0x5C959045UL, 0x2180F877UL)  /*  809 */,
	D(0x7A6BDDFFUL, 0xF370EB00UL)  /*  810 */,
	D(0xCE509E38UL, 0xD6D9D6A4UL)  /*  811 */,
	D(0xEBEB0F00UL, 0x647FA702UL)  /*  812 */,
	D(0x1DCC06CFUL, 0x76606F06UL)  /*  813 */,
	D(0xE4D9F28BUL, 0xA286FF0AUL)  /*  814 */,
	D(0xD85A305DUL, 0xC918C262UL)  /*  815 */,
	D(0x475B1D87UL, 0x32225F54UL)  /*  816 */,
	D(0x2D4FB516UL, 0x68CCB5FEUL)  /*  817 */,
	D(0xA679B9D9UL, 0xD72BBA20UL)  /*  818 */,
	D(0x53841C0DUL, 0x912D43A5UL)  /*  819 */,
	D(0x3B7EAA48UL, 0xBF12A4E8UL)  /*  820 */,
	D(0x781E0E47UL, 0xF22F1DDFUL)  /*  821 */,
	D(0xEFF20CE6UL, 0x0AB50973UL)  /*  822 */,
	D(0x20D261D1UL, 0x9DFFB742UL)  /*  823 */,
	D(0x16A12B03UL, 0x062A2E39UL)  /*  824 */,
	D(0x1960EB22UL, 0x39650495UL)  /*  825 */,
	D(0x251C16FEUL, 0xD50EB8B8UL)  /*  826 */,
	D(0x9AC0C330UL, 0xF826016EUL)  /*  827 */,
	D(0xED152665UL, 0x953E7671UL)  /*  828 */,
	D(0x02D63194UL, 0xA6369570UL)  /*  829 */,
	D(0x5074F083UL, 0x94B1C987UL)  /*  830 */,
	D(0x70BA598CUL, 0x90B25CE1UL)  /*  831 */,
	D(0x794A1581UL, 0x0B9742F6UL)  /*  832 */,
	D(0x0D5925E9UL, 0xFCAF8C6CUL)  /*  833 */,
	D(0x3067716CUL, 0xD868744EUL)  /*  834 */,
	D(0x910AB077UL, 0xE8D7731BUL)  /*  835 */,
	D(0x6A61BBDBUL, 0x5AC42F61UL)  /*  836 */,
	D(0x93513EFBUL, 0xF0851567UL)  /*  837 */,
	D(0xF494724BUL, 0x9E83E9D5UL)  /*  838 */,
	D(0xE887E198UL, 0x5C09648DUL)  /*  839 */,
	D(0x34B1D3C6UL, 0x75370CFDUL)  /*  840 */,
	D(0xDC35E433UL, 0xBC0D255DUL)  /*  841 */,
	D(0xD0AAB842UL, 0x34131BE0UL)  /*  842 */,
	D(0x08042A50UL, 0xB48B7EAFUL)  /*  843 */,
	D(0x9997C4EEUL, 0x44A3AB35UL)  /*  844 */,
	D(0x829A7B49UL, 0x201799D0UL)  /*  845 */,
	D(0x263B8307UL, 0xB7C54441UL)  /*  846 */,
	D(0x752F95F4UL, 0xFD6A6CA6UL)  /*  847 */,
	D(0x92721740UL, 0x2C08C6E5UL)  /*  848 */,
	D(0x2A8AB754UL, 0xA795D9EEUL)  /*  849 */,
	D(0xA442F755UL, 0x2F72943DUL)  /*  850 */,
	D(0x2C31334EUL, 0x19781208UL)  /*  851 */,
	D(0x4FA98D7CUL, 0xEAEE6291UL)  /*  852 */,
	D(0x55C3862FUL, 0x665DB309UL)  /*  853 */,
	D(0xBD061017UL, 0x5D53B1F3UL)  /*  854 */,
	D(0x46FE6CB8UL, 0x40413F27UL)  /*  855 */,
	D(0x3FE03792UL, 0xDF0CFA59UL)  /*  856 */,
	D(0xCFE70037UL, 0x2EB85E8FUL)  /*  857 */,
	D(0xA7BE29E7UL, 0xADBCE118UL)  /*  858 */,
	D(0xE544EE5CUL, 0xDE8431DDUL)  /*  859 */,
	D(0x8A781B1BUL, 0x41F1873EUL)  /*  860 */,
	D(0xA5C94C78UL, 0xA0D2F0E7UL)  /*  861 */,
	D(0x39412E28UL, 0x77B60728UL)  /*  862 */,
	D(0xA1265EF3UL, 0xAFC9A62CUL)  /*  863 */,
	D(0xBCC2770CUL, 0x6A2506C5UL)  /*  864 */,
	D(0x3AB66DD5UL, 0xDCE1CE12UL)  /*  865 */,
	D(0xE65499D0UL, 0x4A675B37UL)  /*  866 */,
	D(0x7D8F5234UL, 0x81BFD216UL)  /*  867 */,
	D(0x0F6F64FCUL, 0xEC15F389UL)  /*  868 */,
	D(0x74EFBE61UL, 0x8B5B13C8UL)  /*  869 */,
	D(0xACDC82B7UL, 0x14273E1DUL)  /*  870 */,
	D(0xDD40BFE0UL, 0x03199D17UL)  /*  871 */,
	D(0x37E99257UL, 0xE7E061F8UL)  /*  872 */,
	D(0xFA526269UL, 0x04775AAAUL)  /*  873 */,
	D(0x8BBBF63AUL, 0x463D56F9UL)  /*  874 */,
	D(0xF0013F15UL, 0x43A26E64UL)  /*  875 */,
	D(0xA8307E9FUL, 0x879EC898UL)  /*  876 */,
	D(0xCC4C27A4UL, 0x150177CCUL)  /*  877 */,
	D(0x1B432F2CUL, 0xCA1D3348UL)  /*  878 */,
	D(0xDE1D1F8FUL, 0x9F6FA013UL)  /*  879 */,
	D(0x606602A0UL, 0x47A7DDD6UL)  /*  880 */,
	D(0xD237AB64UL, 0xCC1CB2C7UL)  /*  881 */,
	D(0x9B938E72UL, 0x25FCD1D3UL)  /*  882 */,
	D(0xEC4E0370UL, 0x8E0FF476UL)  /*  883 */,
	D(0xFEB2FBDAUL, 0x3D03C12DUL)  /*  884 */,
	D(0xAE0BCED2UL, 0xEE43889AUL)  /*  885 */,
	D(0x22CB8923UL, 0xEBFB4F43UL)  /*  886 */,
	D(0x69360D01UL, 0x3CF7396DUL)  /*  887 */,
	D(0x855E3602UL, 0xD2D4E022UL)  /*  888 */,
	D(0x073805BAUL, 0xD01F784CUL)  /*  889 */,
	D(0x33E17A13UL, 0x3852F546UL)  /*  890 */,
	D(0xDF487405UL, 0x8AC7B638UL)  /*  891 */,
	D(0xBA92B29CUL, 0x678AA14AUL)  /*  892 */,
	D(0x0CE89FC7UL, 0x6CFAADCDUL)  /*  893 */,
	D(0x5F9D4E09UL, 0x08339E34UL)  /*  894 */,
	D(0xF1AFE929UL, 0x1F5923B9UL)  /*  895 */,
	D(0x6E3480F6UL, 0x0F4A265FUL)  /*  896 */,
	D(0xEEBF3A2AUL, 0xB29B841CUL)  /*  897 */,
	D(0xE21938A8UL, 0x8F91B4ADUL)  /*  898 */,
	D(0x57DFEFF8UL, 0x45C6D3C3UL)  /*  899 */,
	D(0x2F006B0BUL, 0xF62CAAF2UL)  /*  900 */,
	D(0x62F479EFUL, 0x6F75EE78UL)  /*  901 */,
	D(0x11A55AD4UL, 0x1C8916A9UL)  /*  902 */,
	D(0xF229D290UL, 0x84FED453UL)  /*  903 */,
	D(0x42F1C27BUL, 0x16B000E6UL)  /*  904 */,
	D(0x2B1F7674UL, 0x9823C074UL)  /*  905 */,
	D(0x4B76ECA3UL, 0xC2745360UL)  /*  906 */,
	D(0x8C98F463UL, 0xB91691BDUL)  /*  907 */,
	D(0x14BCC93CUL, 0xF1ADE66AUL)  /*  908 */,
	D(0x8885213EUL, 0x6D458397UL)  /*  909 */,
	D(0x8E177DF0UL, 0x274D4711UL)  /*  910 */,
	D(0xB49B73B5UL, 0x503F2951UL)  /*  911 */,
	D(0x10168168UL, 0xC3F96B6BUL)  /*  912 */,
	D(0x0E3D963BUL, 0x63CAB0AEUL)  /*  913 */,
	D(0x8DFC4B56UL, 0x55A1DB14UL)  /*  914 */,
	D(0xF789F135UL, 0x6E14DE5CUL)  /*  915 */,
	D(0x683E68AFUL, 0x4E51DAC1UL)  /*  916 */,
	D(0xC9A84F9DUL, 0x8D4B0FD9UL)  /*  917 */,
	D(0x3691E03FUL, 0x52A0F9D1UL)  /*  918 */,
	D(0x5ED86E46UL, 0xE1878E80UL)  /*  919 */,
	D(0x3C711A0EUL, 0x99D07150UL)  /*  920 */,
	D(0x5A0865B2UL, 0x0C4E9310UL)  /*  921 */,
	D(0x56FBFC1FUL, 0xE4F0682EUL)  /*  922 */,
	D(0xEA8D5DE3UL, 0x105EDF9BUL)  /*  923 */,
	D(0x71ABFDB1UL, 0x2379187AUL)  /*  924 */,
	D(0x2EB99DE1UL, 0xBEE77B9CUL)  /*  925 */,
	D(0x21ECC0EAUL, 0x33CF4523UL)  /*  926 */,
	D(0x59A4D752UL, 0x1805C7A1UL)  /*  927 */,
	D(0x3896F5EBUL, 0x56AE7C72UL)  /*  928 */,
	D(0xAA638F3DUL, 0xB18F75DCUL)  /*  929 */,
	D(0x9F39358DUL, 0xABE9808EUL)  /*  930 */,
	D(0xB7DEFA91UL, 0xC00B72ACUL)  /*  931 */,
	D(0x6B5541FDUL, 0x62492D92UL)  /*  932 */,
	D(0x6DC6DEE8UL, 0xF92E4D5BUL)  /*  933 */,
	D(0x353F57ABUL, 0xC4BEEA7EUL)  /*  934 */,
	D(0x735769D6UL, 0xDA5690CEUL)  /*  935 */,
	D(0x0A234AA6UL, 0x42391484UL)  /*  936 */,
	D(0xF6F95080UL, 0x28F80D9DUL)  /*  937 */,
	D(0xB8E319A2UL, 0x7AB3F215UL)  /*  938 */,
	D(0x31AD9C11UL, 0x51341A4DUL)  /*  939 */,
	D(0x773C22A5UL, 0x7BEF5805UL)  /*  940 */,
	D(0x45C7561AUL, 0x07968633UL)  /*  941 */,
	D(0xF913DA9EUL, 0x249DBE36UL)  /*  942 */,
	D(0xDA652D9BUL, 0x78A64C68UL)  /*  943 */,
	D(0x4C27A97FUL, 0x3BC334EFUL)  /*  944 */,
	D(0x76621220UL, 0xE66B17F4UL)  /*  945 */,
	D(0x96774389UL, 0x9ACD7D0BUL)  /*  946 */,
	D(0xF3EE5BCAUL, 0xE0ED6782UL)  /*  947 */,
	D(0x409F7536UL, 0x00C879FCUL)  /*  948 */,
	D(0x06D09A39UL, 0xB5926DB6UL)  /*  949 */,
	D(0x6F83AEB0UL, 0x317AC588UL)  /*  950 */,
	D(0x01E6CA4AUL, 0x86381F21UL)  /*  951 */,
	D(0x66FF3462UL, 0xD19F3025UL)  /*  952 */,
	D(0x72207C24UL, 0xDDFD3BFBUL)  /*  953 */,
	D(0x4AF6B6D3UL, 0xE2ECE2EBUL)  /*  954 */,
	D(0x9C994DBEUL, 0xC7EA08DEUL)  /*  955 */,
	D(0x49ACE597UL, 0xB09A8BC4UL)  /*  956 */,
	D(0xB38C4766UL, 0xCF0797BAUL)  /*  957 */,
	D(0x131B9373UL, 0xC57C2A75UL)  /*  958 */,
	D(0xB1822CCEUL, 0x61931E58UL)  /*  959 */,
	D(0x9D7555B9UL, 0x09BA1C0CUL)  /*  960 */,
	D(0x127FAFDDUL, 0x937D11D2UL)  /*  961 */,
	D(0x29DA3BADUL, 0xC66D92E4UL)  /*  962 */,
	D(0xA2C1D571UL, 0x54C2ECBCUL)  /*  963 */,
	D(0x58C5134DUL, 0x82F6FE24UL)  /*  964 */,
	D(0x1C3AE351UL, 0x5B62274FUL)  /*  965 */,
	D(0xE907C82EUL, 0x01CB8126UL)  /*  966 */,
	D(0xF8ED0919UL, 0x13E37FCBUL)  /*  967 */,
	D(0x3249D8F9UL, 0xC80046C9UL)  /*  968 */,
	D(0x80CF9BEDUL, 0xE388FB63UL)  /*  969 */,
	D(0x1881539AUL, 0x116CF19EUL)  /*  970 */,
	D(0x5103F3F7UL, 0x6BD52457UL)  /*  971 */,
	D(0x15B7E6F5UL, 0xAE47F7A8UL)  /*  972 */,
	D(0xDBD7C6DEUL, 0xD47E9CCFUL)  /*  973 */,
	D(0x44E55C41UL, 0x0228BB1AUL)  /*  974 */,
	D(0xB647D425UL, 0x5EDB4E99UL)  /*  975 */,
	D(0x5D11882BUL, 0xB8AAFC30UL)  /*  976 */,
	D(0xF5098BBBUL, 0x29D3212AUL)  /*  977 */,
	D(0x8FB5EA14UL, 0xE90296B3UL)  /*  978 */,
	D(0x677B9421UL, 0x57DD025AUL)  /*  979 */,
	D(0xFB58E7C0UL, 0xA390ACB5UL)  /*  980 */,
	D(0x89D3674CUL, 0x83BD4A01UL)  /*  981 */,
	D(0x9E2DA4DFUL, 0x4BF3B93BUL)  /*  982 */,
	D(0xFCC41E32UL, 0x8CAB4829UL)  /*  983 */,
	D(0x03F38C96UL, 0xBA582C52UL)  /*  984 */,
	D(0xCAD1BDBDUL, 0x7FD85DB2UL)  /*  985 */,
	D(0xBBB442C1UL, 0x6082AE83UL)  /*  986 */,
	D(0xB95FE86BUL, 0xA5DA9AB0UL)  /*  987 */,
	D(0xB22E0467UL, 0x3771A93FUL)  /*  988 */,
	D(0x845358C9UL, 0x493152D8UL)  /*  989 */,
	D(0xBE2A4886UL, 0x97B4541EUL)  /*  990 */,
	D(0x95A2DC2DUL, 0xD38E6966UL)  /*  991 */,
	D(0xC02C11ACUL, 0x923C852BUL)  /*  992 */,
	D(0x2388B199UL, 0x0DF2A87BUL)  /*  993 */,
	D(0x7C8008FAUL, 0x1B4F37BEUL)  /*  994 */,
	D(0x1F70D0C8UL, 0x4D54E503UL)  /*  995 */,
	D(0x5490ADECUL, 0x7ECE57D4UL)  /*  996 */,
	D(0x002B3C27UL, 0xD9063A3AUL)  /*  997 */,
	D(0x7EAEA384UL, 0x8030A2BFUL)  /*  998 */,
	D(0xC602326DUL, 0xED2003C0UL)  /*  999 */,
	D(0x83A7287DUL, 0x69A94086UL)  /* 1000 */,
	D(0xC57A5FCBUL, 0x30F57A8AUL)  /* 1001 */,
	D(0xB56844E4UL, 0x79EBE779UL)  /* 1002 */,
	D(0xA373B40FUL, 0x05DCBCE9UL)  /* 1003 */,
	D(0xD71A786EUL, 0x88570EE2UL)  /* 1004 */,
	D(0x879CBACDUL, 0xBDE8F6A0UL)  /* 1005 */,
	D(0x976AD1BCUL, 0xC164A32FUL)  /* 1006 */,
	D(0xAB21E25EUL, 0x9666D78BUL)  /* 1007 */,
	D(0x901063AAUL, 0xE5E5C33CUL)  /* 1008 */,
	D(0x9818B344UL, 0x48698D90UL)  /* 1009 */,
	D(0xE36487AEUL, 0x3E1E8ABBUL)  /* 1010 */,
	D(0xAFBDF931UL, 0x893BDCB4UL)  /* 1011 */,
	D(0x6345A0DCUL, 0x5FBBD519UL)  /* 1012 */,
	D(0x8628FE26UL, 0x9B9465CAUL)  /* 1013 */,
	D(0x1E5D0160UL, 0x3F9C51ECUL)  /* 1014 */,
	D(0x4DE44006UL, 0xA15049B7UL)  /* 1015 */,
	D(0xBF6C70E5UL, 0xF776CBB1UL)  /* 1016 */,
	D(0x411218F2UL, 0xEF552BEDUL)  /* 1017 */,
	D(0xCB0C0708UL, 0x705A36A3UL)  /* 1018 */,
	D(0xE74D1475UL, 0x4F986044UL)  /* 1019 */,
	D(0xCD56D943UL, 0x0EA8280EUL)  /* 1020 */,
	D(0xC12591D7UL, 0x535F5065UL)  /* 1021 */,
	D(0xC83223F1UL, 0x720AEF96UL)  /* 1022 */,
	D(0xC3A0396FUL, 0x7363A51FUL)  /* 1023 */
};

#undef D
