#!/usr/bin/perl -w

use strict;

use lib './';

use gtablix::treedumper;

sub debug_tree {
	my ($data, $title) = @_;
	
	my $treedumper = Mup::TreeDumper->new (data => $data,
                                         title => $title);

  my $window = Gtk2::Window->new;
  $window->set_default_size (400, 300);
  $window->signal_connect (destroy => sub { Gtk2->main_quit });
  my $scroller = Gtk2::ScrolledWindow->new;
  $scroller->set_policy ('automatic', 'automatic');
  $scroller->set_shadow_type ('in');
  $window->add ($scroller);
  $scroller->add ($treedumper);
  $window->show_all;
 
}

1;
