//*****************************************************************************
//                                PrcGSchem.hpp                               *
//                               ---------------                              *
//  Description : Provides an interface to the application gSchem which is a  *
//                schematic editor. If the currently loaded netlist file is   *
//                derived from a gSchem schematic file the user can envoke    *
//                gschem and edit the schematic.                              *
//  Started     : 18/02/2008                                                  *
//  Last Update : 19/02/2008                                                  *
//  Copyright   : (C) 2004 by MSWaters                                        *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef PRCGSCHEM_HPP
#define PRCGSCHEM_HPP

// System Includes

using  namespace  std;

#include <iostream>

// wxWindows Includes

#include <wx/wx.h>
#include <wx/tokenzr.h>

// Application Includes

#include "base/PrcBase.hpp"

// Local Constant Declarations


//*****************************************************************************

class PrcGSchem : public PrcBase
{
  private :

    ArrayFileName  m_oafnSchems; // The full names of the schematic file/s

  public :

    PrcGSchem( void );
   ~PrcGSchem( );

    bool  bSetSchems( const wxString & rosFileNames );
    bool  bSetSchems( const wxArrayString & roasFileNames );

    const wxString      &   rosGetSchems( void );
    const ArrayFileName & roafnGetSchems( void ) { return( m_oafnSchems ); }

    bool  bExec( void );
};

//*****************************************************************************

#endif // PRCGSCHEM_HPP
