//*****************************************************************************
//                                DlgPrefs.hpp                                *
//                               --------------                               *
//  Description : This dialogue is used to enter applications preferences.    *
//  Started     : 17/10/2006                                                  *
//  Last Update : 28/02/2008                                                  *
//  Copyright   : (C) 2006 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef DLGPREFS_HPP
#define DLGPREFS_HPP

// System Includes

#include <iostream>

// wxWidgets Includes

#include <wx/wx.h>
#include <wx/config.h>
#include <wx/tooltip.h>

// Application Includes

#include "utility/PnlValue.hpp"
#include "utility/TextCtrl.hpp"

// Local Constant Declarations


//*****************************************************************************

class DlgPrefs : public wxDialog
{
  private:

    // Pointer to global configuration object
    wxConfig    * m_poConfig;

    // Display controls
    wxStaticText  m_oLblWaveViewer;
    wxChoice      m_oChoWaveViewer;
    wxStaticText  m_oLblTmpFileMgt;
    wxChoice      m_oChoTmpFileMgt;
    PnlValue      m_oPnlMaxLines;
    wxCheckBox    m_oCbxToolTips;

    // Button controls
    wxButton      m_oBtnOk;
    wxButton      m_oBtnCancel;

    // Object initialization functions
    void  Initialize( void );
    void  Create    ( void );
    void  ToolTips  ( void );
    void  DoLayout  ( void );

    void  SetValues( void );
    void  GetValues( void );

  public:

    DlgPrefs( wxWindow * poWin );
   ~DlgPrefs( );

    bool  bClear( void );

    const  wxString  rosGetWaveViewer( void )
                          { return( m_oChoWaveViewer.GetStringSelection( ) ); }
    int  iGetMaxLines  ( void ) { return( (int) m_oPnlMaxLines.liGetValue( ) ); }
    int  iGetTmpFileMgt( void ) { return( m_oChoTmpFileMgt.GetSelection( ) ); }

    // Event handlers
    void  OnBtnOk    ( wxCommandEvent & roEvtCmd );
    void  OnBtnCancel( wxCommandEvent & roEvtCmd );

    friend  class  FrmMain;

    // In order to be able to react to a menu command, it must be given a
    // unique identifier such as a const or an enum.
    enum eDlgItemID
    {
      ID_PNL_MAXLINES = 0,

      ID_CBX_TOOLTIPS,

      ID_CHO_WAVEVIEWER,
      ID_CHO_TMPFILEMGT,

      ID_BTN_OK,
      ID_BTN_CANCEL,

      ID_UNUSED,      // Assigned to controls for which events are not used

      ID_FST = ID_PNL_MAXLINES,
      ID_LST = ID_BTN_CANCEL
    };

    // Leave this as the last line as private access is envoked by macro
    DECLARE_EVENT_TABLE( )
};

//*****************************************************************************

#endif // DLGPREFS_HPP
