//*****************************************************************************
//                              CmdGnuCapOPT.cpp                              *
//                             ------------------                             *
//  Started     : 11/09/2006                                                  *
//  Last Update : 04/02/2008                                                  *
//  Copyright   : (C) 2006 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#include "gnucap/commands/CmdGnuCapOPT.hpp"

//*****************************************************************************
// Constructor.

CmdGnuCapOPT::CmdGnuCapOPT( void )
{
  bClear( );
}

//*****************************************************************************
// Destructor.

CmdGnuCapOPT::~CmdGnuCapOPT( )
{
}

//*****************************************************************************
// Parse the OPTIONS command string.
//
// Return Values :
//   TRUE  - Success
//   FALSE - Failure

bool  CmdGnuCapOPT::bParse( void )
{
  wxStringTokenizer  ostk1;
  wxString           os1, os2;
  size_t             szt1;
  long               li1;
  double             df1;

  m_bIsOk = FALSE;

  // Tokenize the command string
  ostk1.SetString( *this );
  if( ostk1.CountTokens( ) < 2 ) return( m_bIsOk );

  // Check command type
  os1 = ostk1.GetNextToken( ).Left( 8 ).Upper( );
  if( os1 != wxT(".OPTIONS") )   return( m_bIsOk );
  m_osName = wxT("OPTIONS");

  m_bIsOk = TRUE;

  // Extract each parameter value
  while( ostk1.HasMoreTokens( ) )
  {
    // Extract the field name and the associated value
    os1 = ostk1.GetNextToken( );
    os2 = wxT("");
    if( (szt1=os1.find( wxT("=") )) != wxString::npos )
    {
      os2 = os1.Right( os1.Length( )-szt1-1 );
      os1 = os1.Left( szt1 );
      ConvertType::bStrToInt( os2, &li1 );
      ConvertType::bStrToFlt( os2, &df1 );
    }

    // Set the display control value
    if(      os1 == wxT("ABSTOL")   ) m_fABSTOL   = (float) df1;
    else if( os1 == wxT("BYPASS")   ) m_bBYPASS   = TRUE;
    else if( os1 == wxT("CHGTOL")   ) m_fCHGTOL   = (float) df1;
    else if( os1 == wxT("CSTRAY" )  ) m_bCSTRAY   = TRUE;
    else if( os1 == wxT("DAMPMAX")  ) m_fDAMPMAX  = (float) df1;
    else if( os1 == wxT("DAMPMIN")  ) m_fDAMPMIN  = (float) df1;
    else if( os1 == wxT("DAMPST")   ) m_iDAMPST   = (int)   li1;
    else if( os1 == wxT("DEFAD")    ) m_fDEFAD    = (float) df1;
    else if( os1 == wxT("DEFAS")    ) m_fDEFAS    = (float) df1;
    else if( os1 == wxT("DEFL")     ) m_fDEFL     = (float) df1;
    else if( os1 == wxT("DEFW")     ) m_fDEFW     = (float) df1;
    else if( os1 == wxT("DTMIN")    ) m_fDTMIN    = (float) df1;
    else if( os1 == wxT("DTRATIO")  ) m_fDTRATIO  = (float) df1;
    else if( os1 == wxT("FLOOR")    ) m_fFLOOR    = (float) df1;
    else if( os1 == wxT("GMIN")     ) m_fGMIN     = (float) df1;
    else if( os1 == wxT("HARMS")    ) m_iHARMS    = (int)   li1;
    else if( os1 == wxT("INCMODE")  ) m_bINCMODE  = TRUE;
    else if( os1 == wxT("ITL1")     ) m_iITL1     = (int)   li1;
    else if( os1 == wxT("ITL2")     ) m_iITL2     = (int)   li1;
    else if( os1 == wxT("ITL4")     ) m_iITL4     = (int)   li1;
    else if( os1 == wxT("ITL7")     ) m_iITL7     = (int)   li1;
    else if( os1 == wxT("ITL8")     ) m_iITL8     = (int)   li1;
    else if( os1 == wxT("LIMIT")    ) m_fLIMIT    = (float) df1;
    else if( os1 == wxT("LUBYPASS") ) m_bLUBYPASS = TRUE;
    else if( os1 == wxT("METHOD")   ) m_osMETHOD  = os2;
    else if( os1 == wxT("MODE")     ) m_osMODE    = os2;
    else if( os1 == wxT("NOBYP")    ) m_bBYPASS   = FALSE;
    else if( os1 == wxT("NOCSTRAY") ) m_bCSTRAY   = FALSE;
    else if( os1 == wxT("NOINC")    ) m_bINCMODE  = FALSE;
    else if( os1 == wxT("NOLUBYP")  ) m_bLUBYPASS = FALSE;
    else if( os1 == wxT("NORSTRAY") ) m_bRSTRAY   = FALSE;
    else if( os1 == wxT("NOTRACEL") ) m_bTRACEL   = FALSE;
    else if( os1 == wxT("NOVBYP")   ) m_bVBYPASS  = FALSE;
    else if( os1 == wxT("NUMDGT")   ) m_iNUMDGT   = (int)   li1;
    else if( os1 == wxT("ORDER")    ) m_osORDER   = os2;
    else if( os1 == wxT("RELTOL")   ) m_fRELTOL   = (float) df1;
    else if( os1 == wxT("RSTRAY")   ) m_bRSTRAY   = TRUE;
    else if( os1 == wxT("SEED")     ) m_fSEED     = (float) df1;
    else if( os1 == wxT("SHORT")    ) m_fSHORT    = (float) df1;
    else if( os1 == wxT("TEMPAMB")  ) m_fTEMPAMB  = (float) df1;
    else if( os1 == wxT("TNOM")     ) m_fTNOM     = (float) df1;
    else if( os1 == wxT("TRACEL")   ) m_bTRACEL   = TRUE;
    else if( os1 == wxT("TRANSITS") ) m_iTRANSITS = (int)   li1;
    else if( os1 == wxT("TRREJECT") ) m_fTRREJECT = (float) df1;
    else if( os1 == wxT("TRSTEPG")  ) m_fTRSTEPG  = (float) df1;
    else if( os1 == wxT("TRSTEPS")  ) m_fTRSTEPS  = (float) df1;
    else if( os1 == wxT("TRTOL")    ) m_fTRTOL    = (float) df1;
    else if( os1 == wxT("VBYPASS")  ) m_bVBYPASS  = TRUE;
    else if( os1 == wxT("VFLOOR")   ) m_fVFLOOR   = (float) df1;
    else if( os1 == wxT("VMAX")     ) m_fVMAX     = (float) df1;
    else if( os1 == wxT("VMIN")     ) m_fVMIN     = (float) df1;
    else if( os1 == wxT("VNTOL")    ) m_fVNTOL    = (float) df1;
    else if( os1 == wxT("WCZERO")   ) m_fWCZERO   = (float) df1;
    else m_bIsOk = FALSE;
  }

  m_bIsOk = TRUE;

  return( m_bIsOk );
}

//*****************************************************************************
// Format the OPTIONS command string.
//
// Return Values :
//   TRUE  - Success
//   FALSE - Failure

bool  CmdGnuCapOPT::bFormat( void )
{
  wxString  os1;

  m_bIsOk = FALSE;

  os1 = wxT(".OPTIONS NOPAGE");

  if( m_fABSTOL   != GC_ABSTOL )
    os1 << wxT(" ABSTOL=")   << wxString::Format( wxT("%.2E"), m_fABSTOL );
  if( m_bBYPASS   != GC_BYPASS )
    os1 << wxT(' ') << ( m_bBYPASS ? wxT("BYPASS") : wxT("NOBYP") );
  if( m_fCHGTOL   != GC_CHGTOL )
    os1 << wxT(" CHGTOL=")   << wxString::Format( wxT("%.2E"), m_fCHGTOL );
  if( m_bCSTRAY   != GC_CSTRAY )
    os1 << wxT(' ') << ( m_bCSTRAY ? wxT("CSTRAY") : wxT("NOCSTRAY") );
  if( m_fDAMPMAX  != GC_DAMPMAX )
    os1 << wxT(" DAMPMAX=")  << wxString::Format( wxT("%.2f"), m_fDAMPMAX );
  if( m_fDAMPMIN  != GC_DAMPMIN )
    os1 << wxT(" DAMPMIN=")  << wxString::Format( wxT("%.2f"), m_fDAMPMIN );
  if( m_iDAMPST   != GC_DAMPST )
    os1 << wxT(" DAMPST=")   << m_iDAMPST;
  if( m_fDEFAD    != GC_DEFAD )
    os1 << wxT(" DEFAD=")    << wxString::Format( wxT("%.2E"), m_fDEFAD );
  if( m_fDEFAS    != GC_DEFAS )
    os1 << wxT(" DEFAS=")    << wxString::Format( wxT("%.2E"), m_fDEFAS );
  if( m_fDEFL     != GC_DEFL )
    os1 << wxT(" DEFL=")     << wxString::Format( wxT("%.2E"), m_fDEFL );
  if( m_fDEFW     != GC_DEFW )
    os1 << wxT(" DEFW=")     << wxString::Format( wxT("%.2E"), m_fDEFW );
  if( m_fDTMIN    != GC_DTMIN )
    os1 << wxT(" DTMIN=")    << wxString::Format( wxT("%.2E"), m_fDTMIN );
  if( m_fDTRATIO  != GC_DTRATIO )
    os1 << wxT(" DTRATIO=")  << wxString::Format( wxT("%.2E"), m_fDTRATIO );
  if( m_fFLOOR    != GC_FLOOR )
    os1 << wxT(" FLOOR=")    << wxString::Format( wxT("%.2E"), m_fFLOOR );
  if( m_fGMIN     != GC_GMIN )
    os1 << wxT(" GMIN=")     << wxString::Format( wxT("%.2E"), m_fGMIN );
  if( m_iHARMS    != GC_HARMS )
    os1 << wxT(" HARMS=")    << m_iHARMS;
  if( m_bINCMODE  != GC_INCMODE )
    os1 << wxT(' ') << ( m_bINCMODE ? wxT("INCMODE") : wxT("NOINC") );
  if( m_iITL1     != GC_ITL1 )
    os1 << wxT(" ITL1=")     << m_iITL1;
  if( m_iITL2     != GC_ITL2 )
    os1 << wxT(" ITL2=")     << m_iITL2;
  if( m_iITL4     != GC_ITL4 )
    os1 << wxT(" ITL4=")     << m_iITL4;
  if( m_iITL7     != GC_ITL7 )
    os1 << wxT(" ITL7=")     << m_iITL7;
  if( m_iITL8     != GC_ITL8 )
    os1 << wxT(" ITL8=")     << m_iITL8;
  if( m_fLIMIT    != GC_LIMIT )
    os1 << wxT(" LIMIT=")    << wxString::Format( wxT("%.2E"), m_fLIMIT );
  if( m_bLUBYPASS != GC_LUBYPASS )
    os1 << wxT(' ') << ( m_bLUBYPASS ? wxT("LUBYP") : wxT("NOLUBYP") );
  if( m_osMETHOD  != GC_METHOD )
    os1 << wxT(" METHOD=")   << m_osMETHOD.Upper( );
  if( m_osMODE    != GC_MODE )
    os1 << wxT(" MODE=")     << m_osMODE.Upper( );
  if( m_iNUMDGT   != GC_NUMDGT )
    os1 << wxT(" NUMDGT=")   << m_iNUMDGT;
  if( m_osORDER   != GC_ORDER )
    os1 << wxT(" ORDER=")    << m_osORDER.Upper( );
  if( m_fRELTOL   !=  GC_RELTOL )
    os1 << wxT(" RELTOL=")   << wxString::Format( wxT("%.4f"), m_fRELTOL );
  if( m_bRSTRAY   != GC_RSTRAY )
    os1 << wxT(' ') << ( m_bRSTRAY ? wxT("RSTRAY") : wxT("NORSTRAY") );
  if( m_fSEED     != GC_SEED )
    os1 << wxT(" SEED=")     << wxString::Format( wxT("%.2f"), m_fSEED );
  if( m_fSHORT    != GC_SHORT )
    os1 << wxT(" SHORT=")    << wxString::Format( wxT("%.2E"), m_fSHORT );
  if( m_fTEMPAMB  !=  GC_TEMPAMB )
    os1 << wxT(" TEMPAMB=")  << wxString::Format( wxT("%.2f"), m_fTEMPAMB );
  if( m_fTNOM     != GC_TNOM )
    os1 << wxT(" TNOM=")     << wxString::Format( wxT("%.2f"), m_fTNOM );
  if( m_bTRACEL   != GC_TRACEL )
    os1 << wxT(' ') << ( m_bTRACEL ? wxT("TRACEL") : wxT("NOTRACEL") );
  if( m_iTRANSITS != GC_TRANSITS )
    os1 << wxT(" TRANSITS=") << m_iTRANSITS;
  if( m_fTRREJECT != GC_TRREJECT )
    os1 << wxT(" TRREJECT=") << wxString::Format( wxT("%.2f"), m_fTRREJECT );
  if( m_fTRSTEPG  !=  GC_TRSTEPG )
    os1 << wxT(" TRSTEPG=")  << wxString::Format( wxT("%.2f"), m_fTRSTEPG );
  if( m_fTRSTEPS  !=  GC_TRSTEPS )
    os1 << wxT(" TRSTEPS=")  << wxString::Format( wxT("%.2f"), m_fTRSTEPS );
  if( m_fTRTOL    !=  GC_TRTOL )
    os1 << wxT(" TRTOL=")    << wxString::Format( wxT("%.2f"), m_fTRTOL );
  if( m_bVBYPASS  != GC_VBYPASS )
    os1 << wxT(' ') << ( m_bVBYPASS ? wxT("VBYPASS") : wxT("NOVBYP") );
  if( m_fVFLOOR   !=  GC_VFLOOR )
    os1 << wxT(" VFLOOR=")   << wxString::Format( wxT("%.2E"), m_fVFLOOR );
  if( m_fVMAX     !=   GC_VMAX )
    os1 << wxT(" VMAX=")     << wxString::Format( wxT("%.2f"), m_fVMAX );
  if( m_fVMIN     !=  GC_VMIN )
    os1 << wxT(" VMIN=")     << wxString::Format( wxT("%.2f"), m_fVMIN );
  if( m_fVNTOL    !=  GC_VNTOL )
    os1 << wxT(" VNTOL=")    << wxString::Format( wxT("%.2E"), m_fVNTOL );
  if( m_fWCZERO   != GC_WCZERO )
    os1 << wxT(" WCZERO=")   << wxString::Format( wxT("%.2E"), m_fWCZERO );

  *((wxString *) this) = os1;

  m_bIsOk = TRUE;

  return( m_bIsOk );
}

//*****************************************************************************
// Clear the object attributes.
//
// Return Values :
//   TRUE  - Success
//   FALSE - Failure

bool  CmdGnuCapOPT::bClear( void )
{
  CmdBase::bClear( );

  m_fABSTOL   = GC_ABSTOL;
  m_fCHGTOL   = GC_CHGTOL;
  m_fDEFAD    = GC_DEFAD;
  m_fDEFAS    = GC_DEFAS;
  m_fDEFL     = GC_DEFL;
  m_fDEFW     = GC_DEFW;
  m_fGMIN     = GC_GMIN;
  m_iITL1     = GC_ITL1;
  m_iITL2     = GC_ITL2;
  m_iITL4     = GC_ITL4;
  m_osMETHOD  = GC_METHOD;
  m_fRELTOL   = GC_RELTOL;
  m_fTNOM     = GC_TNOM;
  m_fTRTOL    = GC_TRTOL;
  m_fVNTOL    = GC_VNTOL;

  m_bBYPASS   = GC_BYPASS;
  m_bCSTRAY   = GC_CSTRAY;
  m_fDAMPMAX  = GC_DAMPMAX;
  m_fDAMPMIN  = GC_DAMPMIN;
  m_iDAMPST   = GC_DAMPST;
  m_fDTMIN    = GC_DTMIN;
  m_fDTRATIO  = GC_DTRATIO;
  m_fFLOOR    = GC_FLOOR;
  m_iHARMS    = GC_HARMS;
  m_bINCMODE  = GC_INCMODE;
  m_iITL7     = GC_ITL7;
  m_iITL8     = GC_ITL8;
  m_fLIMIT    = GC_LIMIT;
  m_bLUBYPASS = GC_LUBYPASS;
  m_osMODE    = GC_MODE;
  m_iNUMDGT   = GC_NUMDGT;
  m_osORDER   = GC_ORDER;
  m_bRSTRAY   = GC_RSTRAY;
  m_fSEED     = GC_SEED;
  m_fSHORT    = GC_SHORT;
  m_fTEMPAMB  = GC_TEMPAMB;
  m_bTRACEL   = GC_TRACEL;
  m_iTRANSITS = GC_TRANSITS;
  m_fTRREJECT = GC_TRREJECT;
  m_fTRSTEPG  = GC_TRSTEPG;
  m_fTRSTEPS  = GC_TRSTEPS;
  m_bVBYPASS  = GC_VBYPASS;
  m_fVFLOOR   = GC_VFLOOR;
  m_fVMAX     = GC_VMAX;
  m_fVMIN     = GC_VMIN;
  m_fWCZERO   = GC_WCZERO;

  return( TRUE );
}

//*****************************************************************************
//                                                                            *
//                                 Test Utility                               *
//                                                                            *
//*****************************************************************************

#ifdef TEST_UTIL

// System include files


// Application includes


// Function prototypes

void  Usage( char * psAppName );

//*****************************************************************************

int  main( int argc, char * argv[ ] )
{
  wxString  osCmd;
  wxString  os1;

  // Validate the argument count passed to the application
  if( argc > 2 )           { Usage( argv[ 0 ] ); exit( EXIT_FAILURE ); }

  // Process the command line arguments
  os1 = wxConvLibc.cMB2WC( argv[ 1 ] );
  if( argc > 1 )
  {
    if( os1 == wxT("-h") ) { Usage( argv[ 0 ] ); exit( EXIT_SUCCESS ); }
    else                   { Usage( argv[ 0 ] ); exit( EXIT_FAILURE ); }
  }

  // Display the utility banner
  cout << "\n  Class CmdGnuCapOPT Test Utility"
       << "\n     Version 1.00 (04/02/2008)\n";

  // Create a NG-SPICE OPTIONS command object
  CmdGnuCapOPT  oCmd_OPT;

  // Use the following command example to check the formatter and the parser :
  osCmd << wxT(".OPTIONS NOPAGE ABSTOL=1.20E-12 NOBYP CHGTOL=1.20E-14 ")
        << wxT("NOCSTRAY DAMPMAX=0.90 DAMPMIN=0.60 DAMPST=1 DEFAD=1.10E-14 ")
        << wxT("DEFAS=1.10E-14 DEFL=1.20E-04 DEFW=1.20E-04 DTMIN=1.10E-12 ")
        << wxT("DTRATIO=1.10E+09 FLOOR=1.10E-21 GMIN=1.20E-12 HARMS=10 NOINC ")
        << wxT("ITL1=200 ITL2=70 ITL4=30 ITL7=2 ITL8=200 LIMIT=1.10E+10 ")
        << wxT("NOLUBYP METHOD=EULER MODE=ANALOG NUMDGT=6 ORDER=FORWARD ")
        << wxT("RELTOL=0.0030 RSTRAY SEED=2.00 SHORT=1.10E-07 TEMPAMB=30.00 ")
        << wxT("TNOM=35.00 NOTRACEL TRANSITS=3 TRREJECT=0.60 TRSTEPG=3.00 ")
        << wxT("TRSTEPS=9.00 TRTOL=9.00 VBYPASS VFLOOR=1.10E-15 VMAX=40.00 ")
        << wxT("VMIN=-20.00 VNTOL=3.00E-06 WCZERO=1.10E-09");

  // Set things up for a formatter test
  oCmd_OPT.bClear( );
  oCmd_OPT.m_fABSTOL   = 1.2E-12;
  oCmd_OPT.m_bBYPASS   = FALSE;
  oCmd_OPT.m_fCHGTOL   = 1.2E-14;
  oCmd_OPT.m_bCSTRAY   = FALSE;
  oCmd_OPT.m_fDAMPMAX  = 0.9;
  oCmd_OPT.m_fDAMPMIN  = 0.6;
  oCmd_OPT.m_iDAMPST   = 1;
  oCmd_OPT.m_fDEFAD    = 1.1E-14;
  oCmd_OPT.m_fDEFAS    = 1.1E-14;
  oCmd_OPT.m_fDEFL     = 1.2E-04;
  oCmd_OPT.m_fDEFW     = 1.2E-04;
  oCmd_OPT.m_fDTMIN    = 1.1E-12;
  oCmd_OPT.m_fDTRATIO  = 1.1E+09;
  oCmd_OPT.m_fFLOOR    = 1.1E-21;
  oCmd_OPT.m_fGMIN     = 1.2E-12;
  oCmd_OPT.m_iHARMS    = 10;
  oCmd_OPT.m_bINCMODE  = FALSE;
  oCmd_OPT.m_iITL1     = 200;
  oCmd_OPT.m_iITL2     = 70;
  oCmd_OPT.m_iITL4     = 30;
  oCmd_OPT.m_iITL7     = 2;
  oCmd_OPT.m_iITL8     = 200;
  oCmd_OPT.m_fLIMIT    = 1.1E+10;
  oCmd_OPT.m_bLUBYPASS = FALSE;
  oCmd_OPT.m_osMETHOD  = wxT("EULER");
  oCmd_OPT.m_osMODE    = wxT("ANALOG");
  oCmd_OPT.m_iNUMDGT   = 6;
  oCmd_OPT.m_osORDER   = wxT("FORWARD");
  oCmd_OPT.m_fRELTOL   = 3.0E-03;
  oCmd_OPT.m_bRSTRAY   = TRUE;
  oCmd_OPT.m_fSEED     = 2.0;
  oCmd_OPT.m_fSHORT    = 1.1E-07;
  oCmd_OPT.m_fTEMPAMB  = 30.0;
  oCmd_OPT.m_fTNOM     = 35.0;
  oCmd_OPT.m_bTRACEL   = FALSE;
  oCmd_OPT.m_iTRANSITS = 3;
  oCmd_OPT.m_fTRREJECT = 0.6;
  oCmd_OPT.m_fTRSTEPG  = 3.0;
  oCmd_OPT.m_fTRSTEPS  = 9.0;
  oCmd_OPT.m_fTRTOL    = 9.0;
  oCmd_OPT.m_bVBYPASS  = TRUE;
  oCmd_OPT.m_fVFLOOR   = 1.1E-15;
  oCmd_OPT.m_fVMAX     = 40.0;
  oCmd_OPT.m_fVMIN     = -20.0;
  oCmd_OPT.m_fVNTOL    = 3.0E-06;
  oCmd_OPT.m_fWCZERO   = 1.1E-09;
  cout << "\nRun Formatter     : " << ( oCmd_OPT.bFormat( ) ? "OK" : "FAULT" );
  cout << "\nTest Cmd Format   : " << ( oCmd_OPT == osCmd   ? "OK" : "FAULT" );
  cout << "\nExample Command   : " << osCmd   .mb_str( );
  cout << "\noCmd_OPT Contents : " << oCmd_OPT.mb_str( ) << '\n';

  // Set things up for a parser test
  oCmd_OPT.bClear( );
  oCmd_OPT = osCmd;
  cout << "\nRun Parser        : " << ( oCmd_OPT.bParse( ) ? "OK" : "FAULT" );
  oCmd_OPT.bFormat( );
  cout << "\nTest Cmd Format   : " << ( oCmd_OPT == osCmd  ? "OK" : "FAULT" );
  cout << "\nExample Command   : " << osCmd   .mb_str( );
  cout << "\noCmd_OPT Contents : " << oCmd_OPT.mb_str( ) << '\n';

  cout << '\n';

  exit( EXIT_SUCCESS );
}

//*****************************************************************************

void  Usage( char * psAppName )
{
  cout << "\nUsage   : " << psAppName << " [-OPTIONS]"
       << "\nOptions :"
       << "\n  -h : Print usage (this message)\n";
}

#endif // TEST_UTIL

//*****************************************************************************
