//*****************************************************************************
//                               PnlAnaBase.hpp                               *
//                              ----------------                              *
//  Description : This class derives from the wxPanel class and provides a    *
//                base class for all analysis panel classes.                  *
//  Started     : 26/04/2004                                                  *
//  Last Update : 09/10/2007                                                  *
//  Copyright   : (C) 2004 by MSWaters                                        *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef PNLANABASE_HPP
#define PNLANABASE_HPP

// System Includes

#include <iostream>

// wxWindows Library Includes

#include <wx/wx.h>

// Application Includes

#include "TypeDefs.hpp"
#include "utility/PnlValue.hpp"
#include "netlist/NetList.hpp"
#include "netlist/Simulation.hpp"

// Local Constant Declarations


//*****************************************************************************

class PnlAnaBase : public wxPanel
{
  private:

    // Error message
    wxString     m_osErrMsg;

  protected:

    // Sweep settings
    wxStaticBox  m_oSbxSwpPars;
    PnlValue     m_oPnlStart;
    PnlValue     m_oPnlStop;
    PnlValue     m_oPnlStep;

    // Step scale specifier
    wxRadioBox   m_oRbxStepScale;

    // Initial conditions
    wxRadioBox   m_oRbxInitC;

    // Parameters to be calculated
    wxStaticBox  m_oSbxCalcPars;
    wxCheckBox   m_oCbxVoltage;
    wxCheckBox   m_oCbxCurrent;
    wxCheckBox   m_oCbxPower;
    wxCheckBox   m_oCbxResist;

    // Complex Parts
    wxStaticBox  m_oSbxCpxPrt;
    wxCheckBox   m_oCbxMag;
    wxCheckBox   m_oCbxPhase;
    wxCheckBox   m_oCbxReal;
    wxCheckBox   m_oCbxImag;
    wxCheckBox   m_oCbxMagDb;

    // Input signal source, value and units
    wxStaticBox  m_oSbxSigSrc;
    wxChoice     m_oChoSigSrcCpnt;
    PnlValue     m_oPnlSigSrcLvl;

    // .OPTIONS configuration dialog button
    wxButton     m_oBtnOPTIONS;

    // Analysis temperature
    wxStaticBox  m_oSbxTemp;
    PnlValue     m_oPnlTemp;

    // The simulator engine and analysis types of the panel
    eSimrType    m_eSimrType;
    eAnaType     m_eAnaType;

    // Functions to create the display objects
    void  CreateBase  ( void );
    void  CreateSigSrc( void );
    void  CreateCpxPrt( void );
    void  CreateTemp  ( void );

    bool  bIsCreatedBase  ( void )
              { return( m_oSbxSwpPars   .GetParent( )!=NULL ? TRUE : FALSE ); }
    bool  bIsCreatedSigSrc( void )
              { return( m_oChoSigSrcCpnt.GetParent( )!=NULL ? TRUE : FALSE ); }
    bool  bIsCreatedCpxPrt( void )
              { return( m_oSbxCpxPrt    .GetParent( )!=NULL ? TRUE : FALSE ); }
    bool  bIsCreatedTemp  ( void )
              { return( m_oPnlTemp      .GetParent( )!=NULL ? TRUE : FALSE ); }
    bool  bIsCreatedScale ( void )
              { return( m_oRbxStepScale .GetParent( )!=NULL ? TRUE : FALSE ); }
    bool  bIsCreatedInitC ( void )
              { return( m_oRbxInitC     .GetParent( )!=NULL ? TRUE : FALSE ); }

    void  LoadSigSrcCpnts( Simulation & roSim, wxString osPrefixes );
    bool  bSetSigSrc( Simulation & roSim );
    bool  bSetSigSrcUnits( void );

  public:

    PnlAnaBase( wxWindow * poWin );
   ~PnlAnaBase( );

    bool  bClear( void );
    bool  bIsOk( void ) { return( m_osErrMsg.IsEmpty( ) ); }

    bool  bSetSimrType( eSimrType eSimrType );
    bool  bSetAnaType ( eAnaType  eAnaType );

    eSimrType  eGetSimrType( void ) { return( m_eSimrType ); }
    eAnaType   eGetAnaType ( void ) { return( m_eAnaType ); }

    const wxString & rosGetErrMsg( void ) { return( m_osErrMsg ); }
          void          SetErrMsg( const wxString & rosErrMsg )
                                     { if( bIsOk( ) ) m_osErrMsg = rosErrMsg; }

    bool  bLoad( Simulation & roSim );
    bool  bSave( Simulation & roSim );

    friend  class  FrmMain;
    friend  class  NbkGnuCap;
    friend  class  NbkNgSpice;

    // In order to be able to react to a menu command, it must be given a
    // unique identifier such as a const or an enum.
    enum ePnlItemID
    {
      ID_PNL_START = 1,
      ID_PNL_STOP,
      ID_PNL_STEP,

      ID_RBX_STEPSCALE,
      ID_RBX_INITC,

      ID_CHO_SIGSRCCPNT,
      ID_PNL_SIGSRCLVL,

      ID_CBX_MAG,
      ID_CBX_PHASE,
      ID_CBX_REAL,
      ID_CBX_IMAG,
      ID_CBX_MAGDB,

      ID_CBX_VOLT,
      ID_CBX_CURR,
      ID_CBX_PWR,
      ID_CBX_RES,

      ID_BTN_OPTIONS,

      ID_PNL_TEMP,

      ID_UNUSED,        // Assigned to controls for which events are not used

      ID_FST = ID_PNL_START,
      ID_LST = ID_PNL_TEMP
    };
};

//*****************************************************************************

#endif // PNLANABASE_HPP
