//*****************************************************************************
//                                 CmdBase.hpp                                *
//                                -------------                               *
//  Description : This is the base class for all command classes. It has some *
//                characteristics of structure in that some attributes have   *
//                public access; this simplifies the classes interface.       *
//  Started     : 31/08/2006                                                  *
//  Last Update : 30/01/2008                                                  *
//  Copyright   : (C) 2006 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef CMDBASE_HPP
#define CMDBASE_HPP

// System Includes

using  namespace  std;

#include <iostream>

// wxWidgets Includes

#include <wx/wx.h>

// Application Includes


// Local Constant Declarations


//*****************************************************************************

struct CmdBase : public wxString
{
  protected :

    bool  m_bIsOk;

  public :

    wxString  m_osName;

              CmdBase( void );
    virtual  ~CmdBase( );

    bool  bClear( void );
    bool  bIsOk( void ) { return( m_bIsOk ); }

    virtual  bool  bParse ( void ) = 0;
    virtual  bool  bFormat( void ) = 0;

    void  Print( const char * psPrefix="" );
};

//*****************************************************************************

#endif // CMDBASE_HPP
