#
# Gramps - a GTK+/GNOME based genealogy program
#
# Copyright (C) 2000-2006  Donald N. Allingham
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

# $Id: __init__.py 16035 2010-10-24 14:43:47Z bmcage $

"""The core library of GRAMPS objects"""

# Dates
from gen.lib.date import Date, DateError, Span

# Secondary objects
from gen.lib.secondaryobj import SecondaryObject
from gen.lib.address import Address
from gen.lib.location import Location
from gen.lib.attribute import Attribute
from gen.lib.eventref import EventRef
from gen.lib.ldsord import LdsOrd
from gen.lib.mediaref import MediaRef 
from gen.lib.name import Name
from gen.lib.reporef import RepoRef
from gen.lib.srcref import SourceRef
from gen.lib.surname import Surname
from gen.lib.url import Url
from gen.lib.witness import Witness
from gen.lib.childref import ChildRef

# Primary objects
from gen.lib.primaryobj import PrimaryObject
from gen.lib.person import Person
from gen.lib.personref import PersonRef
from gen.lib.family import Family
from gen.lib.event import Event
from gen.lib.place import Place
from gen.lib.src import Source
from gen.lib.mediaobj import MediaObject
from gen.lib.repo import Repository
from gen.lib.note import Note

# Table objects
from gen.lib.tag import Tag

# These are actually metadata
from gen.lib.genderstats import GenderStats
from gen.lib.researcher import Researcher

# Type classes
from gen.lib.grampstype import GrampsType
from gen.lib.nametype import NameType
from gen.lib.attrtype import AttributeType
from gen.lib.urltype import UrlType
from gen.lib.childreftype import ChildRefType
from gen.lib.repotype import RepositoryType
from gen.lib.eventtype import EventType
from gen.lib.familyreltype import FamilyRelType
from gen.lib.srcmediatype import SourceMediaType
from gen.lib.eventroletype import EventRoleType
from gen.lib.markertype import MarkerType
from gen.lib.nameorigintype import NameOriginType
from gen.lib.notetype import NoteType
from gen.lib.styledtexttagtype import StyledTextTagType

# Text
from gen.lib.styledtexttag import StyledTextTag
from gen.lib.styledtext import StyledText
