#ifndef GPSSHOGI_GUI_BOARD_H
#define GPSSHOGI_GUI_BOARD_H
#include "gpsshogi/gui/abstractBoard.h"
#include "osl/state/numEffectState.h"
#include "osl/container/moveVector.h"

namespace gpsshogi
{
  namespace gui
  {
    class Board : public AbstractBoard
    {
      Q_OBJECT
    public:
      Board(const osl::NumEffectState& state, QWidget *parent = 0);
      void toggleOrientation();
      void setView(bool sente);
      const osl::state::NumEffectState& getState() const {
	return state;
      }
      void setManualMovement(bool enable) {
	allowManualMovement = enable;
      }
      bool isSenteView() const {
	return senteView;
      }
      enum EffectType { NONE, BLACK, WHITE, BOTH };
      void setEffectType(EffectType type) {
	effect = type;
	update();
      }
      EffectType getEffectType() const {
	return effect;
      }
      void highlightLastMove(bool on) { 
	highlight_enabled = on; 
	update();
      }
      void highlightBookMove(bool on) { 
	highlight_book = on; 
	updateBook();
	update();
      }
    protected:
      void paintEvent(QPaintEvent *);
      void mousePressEvent(QMouseEvent *);
      void mouseReleaseEvent(QMouseEvent *);
      void updateBook();
    public slots:
      void move(osl::Move m);
      void setState(const osl::state::NumEffectState& state, osl::Move last_move=osl::Move());
    signals:
      void moved(osl::Move);
      void statusChanged();
    protected:
      virtual osl::Piece pieceOf(int i);
      virtual int countPiecesOnStand(osl::Player, osl::Ptype);
      virtual osl::Piece pieceAt(osl::Square);
      virtual osl::Piece getReservePiece(osl::Ptype);
      virtual osl::Piece getStandPiece(osl::Player, osl::Ptype);
      virtual bool reversed() const {
	return !senteView;
      }
      bool senteView;
      osl::state::NumEffectState state;
    private:
      bool allowManualMovement;
      osl::Square highlight;
      EffectType effect;
      osl::MoveVector book_moves;
      static bool highlight_enabled, highlight_book;
    };
  }
}
#endif // GPSSHOGI_GUI_BOARD_H
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
