#include "piecePair.h"

#include "osl/eval/ppair/piecePairPieceEval.h"
#include "osl/eval/endgame/attackDefense.h"
#include "osl/eval/progressEval.h"
#include "osl/state/numEffectState.h"

#include <qpainter.h>

PiecePair::PiecePair(const osl::NumEffectState& state,
		     QWidget *parent)
  : gpsshogi::gui::Board(state, parent)
{
  setManualMovement(false);
}

void PiecePair::paintPiece(QPainter *painter, int x, int y, osl::Piece piece)
{
  painter->drawText(x - 5, y + 15, QString("%1").arg(values[piece.number()]));
  // fixme pieces on stand
}

void OpeningPair::updateValues()
{
  osl::eval::ppair::PiecePairPieceEval::setValues(state, values);
}

void EndingPieces::updateValues()
{
  osl::eval::endgame::AttackDefense::setValues(state, values);
}

void ProgressPieces::updateValues()
{
  osl::eval::ProgressEval::setValues(state, values);
  for (osl::PieceValues::iterator p=values.begin(); p!=values.end(); ++p)
    *p /= 16;
}

int ProgressPieces::progress16()
{
  osl::state::NumEffectState nState(state);
  osl::eval::ProgressEval eval(nState);
  return eval.progress16().value();
}

void ProgressPieces::setProgress(int progress)
{
  osl::eval::ProgressEval::setValues(state, osl::Progress16(progress), values);
  update();
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
