/* pvFile.t.cc
 */
#include "pvFile.h"

#include "gtest/gtest.h"

using namespace gpsshogi;
using namespace osl;

TEST(PvFileTest, testConstruct)
{
  {
    gpsshogi::PVFileWriter pw("pvFile-test.gz");
  }
  {
    gpsshogi::PVFileReader pr("pvFile-test.gz");
  }
}

TEST(PvFileTest, testRW)
{
  PVVector pv;
  pv.push_back(Move(Position(7,7),Position(7,6),PAWN,PTYPE_EMPTY,false,BLACK));
  pv.push_back(Move(Position(3,3),Position(3,4),PAWN,PTYPE_EMPTY,false,WHITE));
  {
    gpsshogi::PVFileWriter pw("pvFile-test.gz");
  }
  {
    int c = gpsshogi::PVFileReader::countPosition("pvFile-test.gz");
    EXPECT_EQ(0, c);
  }
  {
    gpsshogi::PVFileWriter pw("pvFile-test.gz");
    pw.newPosition(3, 4);
    pw.addPv(pv);
  }
  {
    gpsshogi::PVFileReader pr("pvFile-test.gz");
    int r, p;
    pr.newPosition(r, p);
    EXPECT_EQ(3, r);
    EXPECT_EQ(4, p);

    PVVector pv2;
    pr.readPv(pv2);
    EXPECT_EQ(pv.size(), pv2.size());
    EXPECT_TRUE(std::equal(pv.begin(), pv.end(), pv2.begin()));
  }
  {
    int c = gpsshogi::PVFileReader::countPosition("pvFile-test.gz");
    EXPECT_EQ(1, c);
  }
}

/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
