#!/usr/bin/perl -w
use strict;
use Getopt::Std;
use IO::File;
use CheckEval;

my %options;
getopts('x:y:X:Y:N:', \%options);

my $pdp_filename = $options{'y'};
my $property_filename = $options{'x'};
my $max_id = 240000;
$max_id = $options{'N'}
    if $options{'N'};
my $xbase = "x";
$xbase = $options{'X'}
    if $options{'X'};
my $ybase = "y";
$xbase = $options{'Y'}
    if $options{'Y'};

my $x_out     = "discri-$xbase.txt";
my $xS_out    = "discri-$xbase-S.txt";
my $xSe_out   = "discri-$xbase-Se.txt";
my $xSek_out  = "discri-$xbase-Sek.txt";
my $xSekc_out = "discri-$xbase-Sekc.txt";
my $y_out     = "discri-$ybase.txt";
my $conty_out = "discri-$ybase-cont.txt";
my $logy_out = "discri-$ybase-cont-log.txt";

die "please specify pdp_filename and property_filename"
    unless $pdp_filename && $property_filename;

open (PDP, "$pdp_filename")
    || die $!;
open (X, "> $x_out")
    || die $!;
open (XS, "> $xS_out")
    || die $!;
open (XSE, "> $xSe_out")
    || die $!;
open (XSEK, "> $xSek_out")
    || die $!;
open (XSEKC, "> $xSekc_out")
    || die $!;
open (Y, "> $y_out")
    || die $!;
open (CONTY, "> $conty_out")
    || die $!;
open (LOGY, "> $logy_out")
    || die $!;
my $prop_io = new IO::File("< $property_filename")
    || die $!;

sub print_x ($$) {
    my ($record_id, $state_id) = @_;
    my @properties = CheckEval::getProperties($prop_io, $record_id, $state_id);
    my $blackStand = &CheckEval::makeBlackStand(@properties);
    my $blackBinaryStand = &CheckEval::makeBinaryBlackStand(@properties);
    my $whiteCastleEffect = &CheckEval::makeWhiteCastleEffect(@properties);
    my $whiteKingPos = &CheckEval::makeWhiteKingPosition(@properties);
    my $whiteCastlePieces = &CheckEval::makeWhiteCastlePieces(@properties);
    print X "$blackStand\n";
    print XS "$blackBinaryStand $blackStand\n";
    print XSE "$blackBinaryStand $blackStand $whiteCastleEffect\n";
    print XSEK "$blackBinaryStand $blackStand $whiteCastleEffect".
	" $whiteKingPos\n";
    print XSEKC "$blackBinaryStand $blackStand $whiteCastleEffect".
	" $whiteKingPos $whiteCastlePieces\n";
}

my $num_proofs = 0;
my $num_disproofs = 0;
my $disproof_counter = 0;
while (<PDP>) {
    my ($record_id, $state_id, $defense_p, $defense_d,
	$attack_p, $attack_d, $tsumero_p, $tsumero_d) = split(/\s+/);
    last
	if ($record_id >= $max_id);
    if ($state_id % 2==0) {
	# ˵ͤä̤Ȥ ()
	if ($tsumero_p > 0) {
	    # print STDERR "$record_id, $state_id\n";
	    print Y "1\n";
	    my $invy = 1.0/$tsumero_p;
	    print CONTY "$invy\n";
	    my $invlogy = 1.0/log($tsumero_p);
	    print LOGY "$invlogy\n";
	    &print_x($record_id, $state_id);
	    ++$num_proofs;
	}
    } else {
	die
	    unless ($state_id % 2==1); 
	# ͤʤä̤Ȥ ()
	if (($attack_d > 1) && ($disproof_counter++ % 8 == 0)) {
	    # print STDERR "$record_id, $state_id\n";
	    my $invy = 1.0/$attack_d;
	    print Y "-1\n";
	    print CONTY "-$invy\n";
	    my $invlogy = 1.0/log($attack_d);
	    print LOGY "-$invlogy\n";
	    &print_x($record_id, $state_id);
	    ++$num_disproofs;
	}
    }
}

print STDERR "p $num_proofs, $num_disproofs\n";
