/* A Bison parser, made by GNU Bison 2.0.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     ABORT = 258,
     ATTACH = 259,
     BREAK = 260,
     BUS = 261,
     CLEAR = 262,
     DISASSEMBLE = 263,
     DUMP = 264,
     ENDM = 265,
     FREQUENCY = 266,
     HELP = 267,
     LOAD = 268,
     LOG = 269,
     LIST = 270,
     NODE = 271,
     MACRO = 272,
     MODULE = 273,
     PROCESSOR = 274,
     QUIT = 275,
     RESET = 276,
     RUN = 277,
     SET = 278,
     SHELL = 279,
     STEP = 280,
     STIMULUS = 281,
     SYMBOL = 282,
     TRACE = 283,
     gpsim_VERSION = 284,
     X = 285,
     ICD = 286,
     END_OF_COMMAND = 287,
     MACROBODY_T = 288,
     MACROINVOCATION_T = 289,
     INDIRECT = 290,
     END_OF_INPUT = 291,
     BIT_FLAG = 292,
     EXPRESSION_OPTION = 293,
     NUMERIC_OPTION = 294,
     STRING_OPTION = 295,
     CMD_SUBTYPE = 296,
     SYMBOL_OPTION = 297,
     LITERAL_INT_T = 298,
     LITERAL_BOOL_T = 299,
     LITERAL_FLOAT_T = 300,
     LITERAL_STRING_T = 301,
     LITERAL_ARRAY_T = 302,
     SYMBOL_T = 303,
     PIN_T = 304,
     PORT_T = 305,
     EQU_T = 306,
     AND_T = 307,
     COLON_T = 308,
     COMMENT_T = 309,
     DIV_T = 310,
     EOLN_T = 311,
     MINUS_T = 312,
     MPY_T = 313,
     OR_T = 314,
     PLUS_T = 315,
     SHL_T = 316,
     SHR_T = 317,
     XOR_T = 318,
     INDEXERLEFT_T = 319,
     INDEXERRIGHT_T = 320,
     DECLARE_TYPE = 321,
     DECLARE_INT_T = 322,
     DECLARE_FLOAT_T = 323,
     DECLARE_BOOL_T = 324,
     DECLARE_CHAR_T = 325,
     LOR_T = 326,
     LAND_T = 327,
     NE_T = 328,
     EQ_T = 329,
     ABS_T = 330,
     MAX_T = 331,
     MIN_T = 332,
     GE_T = 333,
     GT_T = 334,
     LE_T = 335,
     LT_T = 336,
     IND_T = 337,
     BITS_T = 338,
     BIT_T = 339,
     WORD_T = 340,
     LADDR_T = 341,
     HIGH_T = 342,
     LOW_T = 343,
     INDEXED_T = 344,
     UNARYOP_PREC = 345,
     ONESCOMP_T = 346,
     LNOT_T = 347,
     POW_T = 348,
     REG_T = 349
   };
#endif
#define ABORT 258
#define ATTACH 259
#define BREAK 260
#define BUS 261
#define CLEAR 262
#define DISASSEMBLE 263
#define DUMP 264
#define ENDM 265
#define FREQUENCY 266
#define HELP 267
#define LOAD 268
#define LOG 269
#define LIST 270
#define NODE 271
#define MACRO 272
#define MODULE 273
#define PROCESSOR 274
#define QUIT 275
#define RESET 276
#define RUN 277
#define SET 278
#define SHELL 279
#define STEP 280
#define STIMULUS 281
#define SYMBOL 282
#define TRACE 283
#define gpsim_VERSION 284
#define X 285
#define ICD 286
#define END_OF_COMMAND 287
#define MACROBODY_T 288
#define MACROINVOCATION_T 289
#define INDIRECT 290
#define END_OF_INPUT 291
#define BIT_FLAG 292
#define EXPRESSION_OPTION 293
#define NUMERIC_OPTION 294
#define STRING_OPTION 295
#define CMD_SUBTYPE 296
#define SYMBOL_OPTION 297
#define LITERAL_INT_T 298
#define LITERAL_BOOL_T 299
#define LITERAL_FLOAT_T 300
#define LITERAL_STRING_T 301
#define LITERAL_ARRAY_T 302
#define SYMBOL_T 303
#define PIN_T 304
#define PORT_T 305
#define EQU_T 306
#define AND_T 307
#define COLON_T 308
#define COMMENT_T 309
#define DIV_T 310
#define EOLN_T 311
#define MINUS_T 312
#define MPY_T 313
#define OR_T 314
#define PLUS_T 315
#define SHL_T 316
#define SHR_T 317
#define XOR_T 318
#define INDEXERLEFT_T 319
#define INDEXERRIGHT_T 320
#define DECLARE_TYPE 321
#define DECLARE_INT_T 322
#define DECLARE_FLOAT_T 323
#define DECLARE_BOOL_T 324
#define DECLARE_CHAR_T 325
#define LOR_T 326
#define LAND_T 327
#define NE_T 328
#define EQ_T 329
#define ABS_T 330
#define MAX_T 331
#define MIN_T 332
#define GE_T 333
#define GT_T 334
#define LE_T 335
#define LT_T 336
#define IND_T 337
#define BITS_T 338
#define BIT_T 339
#define WORD_T 340
#define LADDR_T 341
#define HIGH_T 342
#define LOW_T 343
#define INDEXED_T 344
#define UNARYOP_PREC 345
#define ONESCOMP_T 346
#define LNOT_T 347
#define POW_T 348
#define REG_T 349




/* Copy the first part of user declarations.  */
#line 2 "parse.yy"

/* Parser for gpsim
   Copyright (C) 1999 Scott Dattalo

This file is part of gpsim.

gpsim is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

gpsim is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with gpsim; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <stdio.h>
#include <iostream>
#include <iomanip>
#include <string>
#include <list>
#include <vector>
#include <unistd.h>
#include <glib.h>
using namespace std;

#include "misc.h"
#include "command.h"

#include "cmd_attach.h"
#include "cmd_break.h"
#include "cmd_bus.h"
#include "cmd_clear.h"
#include "cmd_disasm.h"
#include "cmd_dump.h"
#include "cmd_frequency.h"
#include "cmd_help.h"
#include "cmd_list.h"
#include "cmd_load.h"
#include "cmd_log.h"
#include "cmd_node.h"
#include "cmd_macro.h"
#include "cmd_module.h"
#include "cmd_processor.h"
#include "cmd_quit.h"
#include "cmd_reset.h"
#include "cmd_run.h"
#include "cmd_set.h"
#include "cmd_step.h"
#include "cmd_shell.h"
#include "cmd_stimulus.h"
#include "cmd_symbol.h"
#include "cmd_trace.h"
#include "cmd_version.h"
#include "cmd_x.h"
#include "cmd_icd.h"
#include "../src/expr.h"
#include "../src/operator.h"

#include "../src/symbol.h"
#include "../src/stimuli.h"

extern void lexer_setMacroBodyMode();
extern void lexer_InvokeMacro(Macro *m);
extern void lexer_setDeclarationMode();


#define YYERROR_VERBOSE

extern char *yytext; 
int quit_parse=0;
int abort_gpsim=0;
int parser_warnings;
int parser_spanning_lines=0;
int gAbortParserOnSyntaxError=0;
extern int use_gui;
extern int quit_state;

extern command *getLastKnownCommand();
extern void init_cmd_state();
extern const char * GetLastFullCommand();
// From scan.ll
void FlushLexerBuffer();

void yyerror(char *message)
{
  printf("***ERROR: %s while parsing:\n'%s'\n",message, yytext);
  const char *last = GetLastFullCommand();
  if (last)
    printf(" Last command: %s\n", last);
  init_cmd_state();
  // JRH - I added this hoping that it is an appropriate
  //       place to clear the lexer buffer. An example of
  //       failed command where this is needed is to index
  //       into an undefined symbol. (i.e. undefinedsymbol[0])
  FlushLexerBuffer();
}


int toInt(Expression *expr)
{

  try {
    if(expr) {

      Value *v = expr->evaluate();
      if (v) {
	int i;
	v->get(i);
	return i;
      }
    }

  }

  catch (Error *err) {
    if(err)
      cout << "ERROR:" << err->toString() << endl;
    delete err;
  }

  return -1;
}



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 1
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 138 "parse.yy"
typedef union YYSTYPE {
  guint32              i;
  guint64             li;
  float                f;
  char                *s;
  cmd_options        *co;
  cmd_options_num   *con;
  cmd_options_str   *cos;
  cmd_options_expr  *coe;

  BinaryOperator*           BinaryOperator_P;
  Boolean*                  Boolean_P;
  Expression*               Expression_P;
  Float*                    Float_P;
  Integer*                  Integer_P;
  String*                   String_P;
  Value*                    Symbol_P;
  Pin_t*                    Pin_P;

  StringList_t             *StringList_P;
  ExprList_t               *ExprList_P;
  PinList_t                *PinList_P;

  Macro                    *Macro_P;
} YYSTYPE;
/* Line 190 of yacc.c.  */
#line 421 "parse.cc"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */
#line 166 "parse.yy"

/* Define the interface to the lexer */
extern int yylex(YYSTYPE* lvalP);


/* Line 213 of yacc.c.  */
#line 437 "parse.cc"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

# ifndef YYFREE
#  define YYFREE free
# endif
# ifndef YYMALLOC
#  define YYMALLOC malloc
# endif

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   else
#    define YYSTACK_ALLOC alloca
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (defined (YYSTYPE_IS_TRIVIAL) && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short int yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short int) + sizeof (YYSTYPE))			\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined (__GNUC__) && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short int yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  134
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   538

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  101
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  61
/* YYNRULES -- Number of rules. */
#define YYNRULES  200
/* YYNRULES -- Number of states. */
#define YYNSTATES  278

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   349

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      95,    96,     2,     2,    97,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,    98,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    99,     2,   100,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short int yyprhs[] =
{
       0,     0,     3,     6,    10,    11,    13,    15,    17,    19,
      21,    23,    25,    27,    29,    31,    33,    35,    37,    39,
      41,    43,    45,    47,    49,    51,    53,    55,    57,    59,
      61,    63,    65,    67,    69,    71,    73,    75,    78,    79,
      81,    83,    87,    89,    92,    94,    96,    99,   103,   107,
     110,   112,   115,   118,   120,   123,   125,   128,   130,   134,
     138,   143,   150,   155,   162,   164,   167,   169,   172,   175,
     177,   180,   184,   187,   190,   194,   198,   200,   203,   205,
     208,   211,   215,   217,   220,   223,   227,   229,   232,   234,
     236,   238,   241,   245,   247,   250,   253,   255,   257,   260,
     263,   266,   268,   271,   274,   277,   279,   284,   287,   290,
     292,   295,   298,   301,   304,   307,   309,   311,   314,   316,
     319,   321,   323,   325,   326,   327,   336,   337,   339,   343,
     344,   346,   348,   351,   353,   356,   357,   358,   364,   365,
     367,   369,   371,   373,   375,   377,   380,   383,   386,   389,
     391,   394,   396,   398,   403,   407,   412,   417,   424,   431,
     438,   445,   454,   463,   465,   467,   470,   472,   476,   480,
     484,   488,   492,   496,   500,   504,   508,   512,   516,   520,
     524,   528,   532,   536,   540,   544,   548,   550,   553,   556,
     559,   562,   565,   568,   572,   574,   576,   578,   580,   582,
     587
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short int yyrhs[] =
{
     102,     0,    -1,   103,   104,    -1,   102,   103,   104,    -1,
      -1,   106,    -1,   107,    -1,   108,    -1,   111,    -1,   112,
      -1,   144,    -1,   113,    -1,   114,    -1,   115,    -1,   116,
      -1,   117,    -1,   118,    -1,   109,    -1,   119,    -1,   120,
      -1,   136,    -1,   121,    -1,   122,    -1,   123,    -1,   124,
      -1,   125,    -1,   126,    -1,   127,    -1,   128,    -1,   129,
      -1,   131,    -1,   132,    -1,   133,    -1,   134,    -1,   135,
      -1,    36,    -1,     1,    -1,   105,    56,    -1,    -1,    54,
      -1,     3,    -1,     4,    48,   157,    -1,     5,    -1,     5,
      43,    -1,   110,    -1,    14,    -1,    14,   148,    -1,    14,
     148,   158,    -1,     5,   148,   158,    -1,     5,   148,    -1,
       6,    -1,     6,   153,    -1,     7,   154,    -1,     8,    -1,
       8,   154,    -1,     9,    -1,     9,   148,    -1,    48,    -1,
      95,   154,    96,    -1,    48,    51,   154,    -1,    48,    64,
     158,    65,    -1,    48,    64,   158,    65,    51,   154,    -1,
      94,    95,   154,    96,    -1,    94,    95,   154,    96,    51,
     154,    -1,    11,    -1,    11,   154,    -1,    12,    -1,    12,
      46,    -1,    12,    48,    -1,    15,    -1,    15,   148,    -1,
      13,   148,    46,    -1,    13,    46,    -1,    13,    48,    -1,
      13,    48,    48,    -1,    13,    46,    46,    -1,    16,    -1,
      16,   153,    -1,    18,    -1,    18,   148,    -1,    18,   152,
      -1,    18,   152,   153,    -1,    19,    -1,    19,   148,    -1,
      19,    46,    -1,    19,    46,    46,    -1,    20,    -1,    20,
     154,    -1,    21,    -1,    22,    -1,    23,    -1,    23,   148,
      -1,    23,   148,   154,    -1,    25,    -1,    25,   154,    -1,
      25,   148,    -1,    24,    -1,    26,    -1,    26,   149,    -1,
     129,   130,    -1,   129,    32,    -1,   150,    -1,   130,   148,
      -1,   130,   152,    -1,   130,   155,    -1,    27,    -1,    27,
      46,    51,   161,    -1,    27,    46,    -1,    27,    48,    -1,
      28,    -1,    28,   154,    -1,    28,   151,    -1,    28,   152,
      -1,    28,   148,    -1,    28,   150,    -1,    29,    -1,    30,
      -1,    30,   154,    -1,    31,    -1,    31,   152,    -1,    17,
      -1,   137,    -1,    34,    -1,    -1,    -1,    46,    17,   138,
     140,   104,   139,   141,   143,    -1,    -1,    46,    -1,   140,
      97,    46,    -1,    -1,   142,    -1,    33,    -1,   142,    33,
      -1,    10,    -1,    46,    10,    -1,    -1,    -1,    98,   145,
     147,   146,    46,    -1,    -1,    67,    -1,    68,    -1,    69,
      -1,    70,    -1,    37,    -1,    41,    -1,    38,   154,    -1,
      39,   154,    -1,    40,    46,    -1,    40,    48,    -1,    46,
      -1,   153,    46,    -1,   159,    -1,   160,    -1,    94,    95,
     154,    96,    -1,    99,   158,   100,    -1,    49,    95,    48,
      96,    -1,    49,    95,    43,    96,    -1,    49,    95,    48,
      97,    48,    96,    -1,    49,    95,    48,    97,    43,    96,
      -1,    50,    95,    48,    97,    48,    96,    -1,    50,    95,
      48,    97,    43,    96,    -1,    50,    95,    48,    97,    48,
      97,    48,    96,    -1,    50,    95,    48,    97,    48,    97,
      43,    96,    -1,    48,    -1,   156,    -1,   157,   156,    -1,
     154,    -1,   158,    97,   154,    -1,   154,    60,   154,    -1,
     154,    57,   154,    -1,   154,    58,   154,    -1,   154,    55,
     154,    -1,   154,    52,   154,    -1,   154,    59,   154,    -1,
     154,    63,   154,    -1,   154,    61,   154,    -1,   154,    62,
     154,    -1,   154,    74,   154,    -1,   154,    73,   154,    -1,
     154,    81,   154,    -1,   154,    79,   154,    -1,   154,    80,
     154,    -1,   154,    78,   154,    -1,   154,    72,   154,    -1,
     154,    71,   154,    -1,   154,    53,   154,    -1,   161,    -1,
      60,   160,    -1,    57,   160,    -1,    91,   160,    -1,    92,
     160,    -1,    58,   160,    -1,    52,   160,    -1,    95,   154,
      96,    -1,    43,    -1,    44,    -1,    46,    -1,    45,    -1,
      48,    -1,    48,    64,   158,    65,    -1,    47,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short int yyrline[] =
{
       0,   311,   311,   315,   321,   323,   324,   325,   326,   327,
     328,   329,   330,   331,   332,   333,   334,   335,   336,   337,
     338,   339,   340,   341,   342,   343,   344,   345,   346,   347,
     348,   349,   350,   351,   352,   353,   363,   380,   384,   386,
     390,   399,   403,   404,   405,   409,   410,   411,   416,   417,
     421,   422,   425,   429,   430,   434,   435,   439,   447,   451,
     460,   466,   473,   480,   490,   491,   495,   496,   497,   501,
     502,   505,   516,   530,   543,   557,   577,   578,   582,   583,
     584,   585,   590,   594,   598,   602,   608,   613,   622,   626,
     630,   631,   632,   636,   637,   638,   642,   645,   649,   653,
     657,   667,   673,   679,   685,   695,   696,   698,   699,   704,
     705,   706,   707,   708,   709,   712,   716,   717,   721,   722,
     743,   744,   745,   751,   753,   750,   758,   760,   765,   773,
     775,   779,   780,   784,   785,   806,   811,   805,   822,   823,
     824,   825,   826,   850,   856,   862,   865,   874,   881,   900,
     901,   907,   908,   909,   913,   916,   917,   918,   919,   920,
     921,   922,   923,   924,   928,   929,   933,   934,   938,   939,
     940,   941,   942,   943,   944,   945,   946,   947,   948,   949,
     950,   951,   952,   953,   954,   955,   959,   960,   961,   962,
     963,   964,   965,   966,   969,   970,   971,   972,   973,   974,
     975
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "ABORT", "ATTACH", "BREAK", "BUS",
  "CLEAR", "DISASSEMBLE", "DUMP", "ENDM", "FREQUENCY", "HELP", "LOAD",
  "LOG", "LIST", "NODE", "MACRO", "MODULE", "PROCESSOR", "QUIT", "RESET",
  "RUN", "SET", "SHELL", "STEP", "STIMULUS", "SYMBOL", "TRACE",
  "gpsim_VERSION", "X", "ICD", "END_OF_COMMAND", "MACROBODY_T",
  "MACROINVOCATION_T", "INDIRECT", "END_OF_INPUT", "BIT_FLAG",
  "EXPRESSION_OPTION", "NUMERIC_OPTION", "STRING_OPTION", "CMD_SUBTYPE",
  "SYMBOL_OPTION", "LITERAL_INT_T", "LITERAL_BOOL_T", "LITERAL_FLOAT_T",
  "LITERAL_STRING_T", "LITERAL_ARRAY_T", "SYMBOL_T", "PIN_T", "PORT_T",
  "EQU_T", "AND_T", "COLON_T", "COMMENT_T", "DIV_T", "EOLN_T", "MINUS_T",
  "MPY_T", "OR_T", "PLUS_T", "SHL_T", "SHR_T", "XOR_T", "INDEXERLEFT_T",
  "INDEXERRIGHT_T", "DECLARE_TYPE", "DECLARE_INT_T", "DECLARE_FLOAT_T",
  "DECLARE_BOOL_T", "DECLARE_CHAR_T", "LOR_T", "LAND_T", "NE_T", "EQ_T",
  "ABS_T", "MAX_T", "MIN_T", "GE_T", "GT_T", "LE_T", "LT_T", "IND_T",
  "BITS_T", "BIT_T", "WORD_T", "LADDR_T", "HIGH_T", "LOW_T", "INDEXED_T",
  "UNARYOP_PREC", "ONESCOMP_T", "LNOT_T", "POW_T", "REG_T", "'('", "')'",
  "','", "'\\\\'", "'{'", "'}'", "$accept", "list_of_commands", "cmd",
  "rol", "opt_comment", "aborting", "attach_cmd", "break_cmd", "log_cmd",
  "break_set", "bus_cmd", "clear_cmd", "disassemble_cmd", "dump_cmd",
  "eval_cmd", "frequency_cmd", "help_cmd", "list_cmd", "load_cmd",
  "node_cmd", "module_cmd", "processor_cmd", "quit_cmd", "reset_cmd",
  "run_cmd", "set_cmd", "step_cmd", "shell_cmd", "stimulus_cmd",
  "stimulus_opt", "symbol_cmd", "trace_cmd", "version_cmd", "x_cmd",
  "icd_cmd", "macro_cmd", "macrodef_directive", "@1", "@2",
  "opt_mdef_arglist", "mdef_body", "mdef_body_", "mdef_end",
  "declaration_cmd", "@3", "@4", "opt_declaration_type", "bit_flag",
  "cmd_subtype", "expression_option", "numeric_option", "string_option",
  "string_list", "expr", "array", "pin", "pin_list", "expr_list",
  "binary_expr", "unary_expr", "literal", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short int yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,    40,    41,    44,    92,   123,
     125
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,   101,   102,   102,   103,   103,   103,   103,   103,   103,
     103,   103,   103,   103,   103,   103,   103,   103,   103,   103,
     103,   103,   103,   103,   103,   103,   103,   103,   103,   103,
     103,   103,   103,   103,   103,   103,   103,   104,   105,   105,
     106,   107,   108,   108,   108,   109,   109,   109,   110,   110,
     111,   111,   112,   113,   113,   114,   114,   115,   115,   115,
     115,   115,   115,   115,   116,   116,   117,   117,   117,   118,
     118,   119,   119,   119,   119,   119,   120,   120,   121,   121,
     121,   121,   122,   122,   122,   122,   123,   123,   124,   125,
     126,   126,   126,   127,   127,   127,   128,   129,   129,   129,
     129,   130,   130,   130,   130,   131,   131,   131,   131,   132,
     132,   132,   132,   132,   132,   133,   134,   134,   135,   135,
     136,   136,   136,   138,   139,   137,   140,   140,   140,   141,
     141,   142,   142,   143,   143,   145,   146,   144,   147,   147,
     147,   147,   147,   148,   149,   150,   151,   152,   152,   153,
     153,   154,   154,   154,   155,   156,   156,   156,   156,   156,
     156,   156,   156,   156,   157,   157,   158,   158,   159,   159,
     159,   159,   159,   159,   159,   159,   159,   159,   159,   159,
     159,   159,   159,   159,   159,   159,   160,   160,   160,   160,
     160,   160,   160,   160,   161,   161,   161,   161,   161,   161,
     161
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     2,     3,     0,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     0,     1,
       1,     3,     1,     2,     1,     1,     2,     3,     3,     2,
       1,     2,     2,     1,     2,     1,     2,     1,     3,     3,
       4,     6,     4,     6,     1,     2,     1,     2,     2,     1,
       2,     3,     2,     2,     3,     3,     1,     2,     1,     2,
       2,     3,     1,     2,     2,     3,     1,     2,     1,     1,
       1,     2,     3,     1,     2,     2,     1,     1,     2,     2,
       2,     1,     2,     2,     2,     1,     4,     2,     2,     1,
       2,     2,     2,     2,     2,     1,     1,     2,     1,     2,
       1,     1,     1,     0,     0,     8,     0,     1,     3,     0,
       1,     1,     2,     1,     2,     0,     0,     5,     0,     1,
       1,     1,     1,     1,     1,     2,     2,     2,     2,     1,
       2,     1,     1,     4,     3,     4,     4,     6,     6,     6,
       6,     8,     8,     1,     1,     2,     1,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     1,     2,     2,     2,
       2,     2,     2,     3,     1,     1,     1,     1,     1,     4,
       1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char yydefact[] =
{
       0,    36,    40,     0,    42,    50,     0,    53,    55,    64,
      66,     0,    45,    69,    76,   120,    78,    82,    86,    88,
      89,    90,    96,    93,    97,   105,   109,   115,   116,   118,
     122,    35,     0,    57,     0,     0,   135,     0,    38,     5,
       6,     7,    17,    44,     8,     9,    11,    12,    13,    14,
      15,    16,    18,    19,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    32,    33,    34,    20,   121,
      10,     0,   143,    43,    49,   149,    51,   194,   195,   197,
     196,   200,   198,     0,     0,     0,     0,     0,     0,     0,
       0,    52,   151,   152,   186,    54,    56,    65,    67,    68,
      72,    73,     0,    46,    70,    77,     0,    79,    80,    84,
      83,    87,    91,    95,    94,   144,    98,   107,   108,     0,
       0,   113,   114,   111,   112,   110,   117,   119,   123,     0,
       0,     0,     0,   138,     1,    38,    39,     2,     0,   100,
      99,   101,   163,     0,     0,   164,    41,   166,    48,   150,
       0,   192,   188,   191,   187,   189,   190,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    75,    74,    71,
      47,   147,   148,    81,    85,    92,     0,   145,   146,   126,
      59,     0,     0,    58,   139,   140,   141,   142,   136,     3,
      37,     0,   102,   103,   104,     0,     0,   165,     0,     0,
       0,   193,   172,   185,   171,   169,   170,   173,   168,   175,
     176,   174,   184,   183,   178,   177,   182,   180,   181,   179,
     106,   127,    38,    60,    62,     0,     0,     0,     0,     0,
     167,   199,   153,     0,   124,     0,     0,   137,   154,   156,
     155,     0,     0,   128,   129,    61,    63,     0,     0,     0,
       0,   131,     0,   130,   158,   157,   160,   159,     0,   133,
       0,   125,   132,     0,     0,   134,   162,   161
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short int yydefgoto[] =
{
      -1,    37,    38,   137,   138,    39,    40,    41,    42,    43,
      44,    45,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    61,    62,   140,
      63,    64,    65,    66,    67,    68,    69,   189,   254,   232,
     262,   263,   271,    70,   133,   235,   198,    74,   116,   122,
     123,   108,    76,   147,   204,   145,   146,   148,    92,    93,
      94
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -132
static const short int yypact[] =
{
     170,  -132,  -132,   -40,    34,   -12,    51,    51,    30,    51,
      54,    28,    30,    30,   -12,  -132,   104,   -30,    51,  -132,
    -132,    30,  -132,   209,    38,   177,   190,  -132,    51,    72,
    -132,  -132,    66,   -33,    29,    51,  -132,    32,    77,  -132,
    -132,  -132,  -132,  -132,  -132,  -132,  -132,  -132,  -132,  -132,
    -132,  -132,  -132,  -132,  -132,  -132,  -132,  -132,  -132,  -132,
    -132,  -132,    43,  -132,  -132,  -132,  -132,  -132,  -132,  -132,
    -132,   161,  -132,  -132,    51,  -132,    93,  -132,  -132,  -132,
    -132,  -132,    88,   231,   231,   231,   231,   231,   231,    85,
      51,   376,  -132,  -132,  -132,   376,  -132,   376,  -132,  -132,
     126,   155,   171,    51,  -132,    93,   195,  -132,   -12,   203,
    -132,   376,    51,  -132,   376,  -132,  -132,   156,  -132,    51,
      51,  -132,  -132,  -132,  -132,   376,   376,  -132,  -132,    51,
      51,    51,   256,    23,  -132,    77,  -132,  -132,   202,  -132,
     -14,  -132,  -132,   164,   165,  -132,   161,   376,   154,  -132,
      51,  -132,  -132,  -132,  -132,  -132,  -132,    51,   286,    51,
      51,    51,    51,    51,    51,    51,    51,    51,    51,    51,
      51,    51,    51,    51,    51,    51,    51,  -132,  -132,  -132,
     154,  -132,  -132,    93,  -132,   376,    74,   376,   376,   216,
     376,     7,   316,  -132,  -132,  -132,  -132,  -132,  -132,  -132,
    -132,    51,  -132,  -132,  -132,   -18,   215,  -132,    51,     8,
     346,  -132,   433,   406,   447,   433,   447,   433,   433,   141,
     141,   433,   457,    55,    69,    69,  -132,  -132,  -132,  -132,
    -132,  -132,   -27,   219,   220,   226,   108,   184,   135,   176,
     376,  -132,  -132,   240,  -132,    51,    51,  -132,  -132,  -132,
    -132,    39,    67,  -132,   254,   376,   376,   194,   196,   206,
     148,  -132,    18,   266,  -132,  -132,  -132,  -132,    89,  -132,
     295,  -132,  -132,   211,   214,  -132,  -132,  -132
};

/* YYPGOTO[NTERM-NUM].  */
static const short int yypgoto[] =
{
    -132,  -132,   269,  -131,  -132,  -132,  -132,  -132,  -132,  -132,
    -132,  -132,  -132,  -132,  -132,  -132,  -132,  -132,  -132,  -132,
    -132,  -132,  -132,  -132,  -132,  -132,  -132,  -132,  -132,  -132,
    -132,  -132,  -132,  -132,  -132,  -132,  -132,  -132,  -132,  -132,
    -132,  -132,  -132,  -132,  -132,  -132,  -132,    -2,  -132,   250,
    -132,   -24,    -1,    -6,  -132,   174,  -132,   -61,  -132,   210,
     138
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -5
static const short int yytable[] =
{
      91,    95,   124,    97,   199,   127,    96,    72,    71,   102,
     103,   104,   111,   105,   107,   110,   109,   114,   129,   112,
     125,   113,   126,    72,   121,   237,   106,   136,   269,   132,
     238,   130,   134,     1,    75,     2,     3,     4,     5,     6,
       7,     8,   180,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,   270,    72,    30,    72,    31,   191,
     243,    72,   233,   241,   100,   139,   101,    73,    32,   115,
      33,   119,   257,   128,   158,   201,    -4,   258,    -4,   209,
     194,   195,   196,   197,    77,    78,    79,    80,    81,    82,
      98,   244,    99,    83,   208,   208,   185,   183,    84,    85,
     259,    86,   106,   187,   188,   260,   203,    77,    78,    79,
      80,    81,    82,   190,   131,   192,    34,    35,   171,   172,
      36,   136,   273,   173,   174,   175,   176,   274,   202,   149,
     236,    72,    87,    88,   106,    89,    90,   173,   174,   175,
     176,   210,   150,   212,   213,   214,   215,   216,   217,   218,
     219,   220,   221,   222,   223,   224,   225,   226,   227,   228,
     229,     1,   177,     2,     3,     4,     5,     6,     7,     8,
     157,     9,    10,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,   240,   178,    30,   208,    31,   186,   248,   142,
     143,   144,   169,   170,   171,   172,    32,   179,    33,   173,
     174,   175,   176,   117,    -4,   118,    -4,    72,   119,   120,
     106,   250,   251,    77,    78,    79,    80,    81,    82,   255,
     256,   181,    83,   182,   267,   268,    72,    84,    85,   184,
      86,   208,    77,    78,    79,    80,    81,    82,   200,   205,
     206,    83,   231,   239,    34,    35,    84,    85,    36,    86,
     245,   246,   247,   252,    77,    78,    79,    80,    81,    82,
     249,    87,    88,    83,    89,    90,   253,   261,    84,    85,
     264,    86,   265,   151,   152,   153,   154,   155,   156,   272,
      87,    88,   266,    89,    90,   275,   135,   276,   159,   160,
     277,   161,   141,   162,   163,   164,   165,   166,   167,   168,
     207,     0,    87,    88,   230,     0,    90,   169,   170,   171,
     172,     0,     0,     0,   173,   174,   175,   176,   159,   160,
       0,   161,     0,   162,   163,   164,   165,   166,   167,   168,
       0,     0,   193,     0,     0,     0,     0,   169,   170,   171,
     172,     0,     0,     0,   173,   174,   175,   176,   159,   160,
       0,   161,     0,   162,   163,   164,   165,   166,   167,   168,
       0,     0,   211,     0,     0,     0,     0,   169,   170,   171,
     172,     0,     0,     0,   173,   174,   175,   176,   159,   160,
       0,   161,     0,   162,   163,   164,   165,   166,   167,   168,
       0,     0,   234,     0,     0,     0,     0,   169,   170,   171,
     172,     0,     0,     0,   173,   174,   175,   176,   159,   160,
       0,   161,     0,   162,   163,   164,   165,   166,   167,   168,
       0,     0,   242,     0,     0,     0,     0,   169,   170,   171,
     172,     0,     0,     0,   173,   174,   175,   176,   159,    -5,
       0,   161,     0,   162,   163,   164,   165,   166,   167,   168,
       0,     0,     0,     0,     0,     0,     0,   169,   170,   171,
     172,     0,     0,     0,   173,   174,   175,   176,   161,     0,
       0,   163,     0,     0,   166,   167,     0,     0,     0,     0,
       0,     0,     0,     0,   169,   170,   171,   172,   166,   167,
       0,   173,   174,   175,   176,     0,     0,     0,   169,   170,
     171,   172,     0,     0,     0,   173,   174,   175,   176,   170,
     171,   172,     0,     0,     0,   173,   174,   175,   176
};

static const short int yycheck[] =
{
       6,     7,    26,     9,   135,    29,     8,    37,    48,    11,
      12,    13,    18,    14,    16,    17,    46,    23,    51,    21,
      26,    23,    28,    37,    26,    43,    40,    54,    10,    35,
      48,    64,     0,     1,    46,     3,     4,     5,     6,     7,
       8,     9,   103,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    46,    37,    34,    37,    36,   130,
      97,    37,    65,    65,    46,    32,    48,    43,    46,    41,
      48,    38,    43,    17,    90,    99,    54,    48,    56,   150,
      67,    68,    69,    70,    43,    44,    45,    46,    47,    48,
      46,   232,    48,    52,    97,    97,   112,   108,    57,    58,
      43,    60,    40,   119,   120,    48,   140,    43,    44,    45,
      46,    47,    48,   129,    95,   131,    94,    95,    73,    74,
      98,    54,    43,    78,    79,    80,    81,    48,   140,    46,
     201,    37,    91,    92,    40,    94,    95,    78,    79,    80,
      81,   157,    64,   159,   160,   161,   162,   163,   164,   165,
     166,   167,   168,   169,   170,   171,   172,   173,   174,   175,
     176,     1,    46,     3,     4,     5,     6,     7,     8,     9,
      95,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,   208,    48,    34,    97,    36,    51,   100,    48,
      49,    50,    71,    72,    73,    74,    46,    46,    48,    78,
      79,    80,    81,    46,    54,    48,    56,    37,    38,    39,
      40,    96,    97,    43,    44,    45,    46,    47,    48,   245,
     246,    46,    52,    48,    96,    97,    37,    57,    58,    46,
      60,    97,    43,    44,    45,    46,    47,    48,    56,    95,
      95,    52,    46,    48,    94,    95,    57,    58,    98,    60,
      51,    51,    46,    97,    43,    44,    45,    46,    47,    48,
      96,    91,    92,    52,    94,    95,    46,    33,    57,    58,
      96,    60,    96,    83,    84,    85,    86,    87,    88,    33,
      91,    92,    96,    94,    95,    10,    37,    96,    52,    53,
      96,    55,    62,    57,    58,    59,    60,    61,    62,    63,
     146,    -1,    91,    92,   186,    -1,    95,    71,    72,    73,
      74,    -1,    -1,    -1,    78,    79,    80,    81,    52,    53,
      -1,    55,    -1,    57,    58,    59,    60,    61,    62,    63,
      -1,    -1,    96,    -1,    -1,    -1,    -1,    71,    72,    73,
      74,    -1,    -1,    -1,    78,    79,    80,    81,    52,    53,
      -1,    55,    -1,    57,    58,    59,    60,    61,    62,    63,
      -1,    -1,    96,    -1,    -1,    -1,    -1,    71,    72,    73,
      74,    -1,    -1,    -1,    78,    79,    80,    81,    52,    53,
      -1,    55,    -1,    57,    58,    59,    60,    61,    62,    63,
      -1,    -1,    96,    -1,    -1,    -1,    -1,    71,    72,    73,
      74,    -1,    -1,    -1,    78,    79,    80,    81,    52,    53,
      -1,    55,    -1,    57,    58,    59,    60,    61,    62,    63,
      -1,    -1,    96,    -1,    -1,    -1,    -1,    71,    72,    73,
      74,    -1,    -1,    -1,    78,    79,    80,    81,    52,    53,
      -1,    55,    -1,    57,    58,    59,    60,    61,    62,    63,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,    72,    73,
      74,    -1,    -1,    -1,    78,    79,    80,    81,    55,    -1,
      -1,    58,    -1,    -1,    61,    62,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    71,    72,    73,    74,    61,    62,
      -1,    78,    79,    80,    81,    -1,    -1,    -1,    71,    72,
      73,    74,    -1,    -1,    -1,    78,    79,    80,    81,    72,
      73,    74,    -1,    -1,    -1,    78,    79,    80,    81
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,     1,     3,     4,     5,     6,     7,     8,     9,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      34,    36,    46,    48,    94,    95,    98,   102,   103,   106,
     107,   108,   109,   110,   111,   112,   113,   114,   115,   116,
     117,   118,   119,   120,   121,   122,   123,   124,   125,   126,
     127,   128,   129,   131,   132,   133,   134,   135,   136,   137,
     144,    48,    37,    43,   148,    46,   153,    43,    44,    45,
      46,    47,    48,    52,    57,    58,    60,    91,    92,    94,
      95,   154,   159,   160,   161,   154,   148,   154,    46,    48,
      46,    48,   148,   148,   148,   153,    40,   148,   152,    46,
     148,   154,   148,   148,   154,    41,   149,    46,    48,    38,
      39,   148,   150,   151,   152,   154,   154,   152,    17,    51,
      64,    95,   154,   145,     0,   103,    54,   104,   105,    32,
     130,   150,    48,    49,    50,   156,   157,   154,   158,    46,
      64,   160,   160,   160,   160,   160,   160,    95,   154,    52,
      53,    55,    57,    58,    59,    60,    61,    62,    63,    71,
      72,    73,    74,    78,    79,    80,    81,    46,    48,    46,
     158,    46,    48,   153,    46,   154,    51,   154,   154,   138,
     154,   158,   154,    96,    67,    68,    69,    70,   147,   104,
      56,    99,   148,   152,   155,    95,    95,   156,    97,   158,
     154,    96,   154,   154,   154,   154,   154,   154,   154,   154,
     154,   154,   154,   154,   154,   154,   154,   154,   154,   154,
     161,    46,   140,    65,    96,   146,   158,    43,    48,    48,
     154,    65,    96,    97,   104,    51,    51,    46,   100,    96,
      96,    97,    97,    46,   139,   154,   154,    43,    48,    43,
      48,    33,   141,   142,    96,    96,    96,    96,    97,    10,
      46,   143,    33,    43,    48,    10,    96,    96
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (N)								\
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (0)
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
              (Loc).first_line, (Loc).first_column,	\
              (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Type, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short int *bottom, short int *top)
#else
static void
yy_stack_print (bottom, top)
    short int *bottom;
    short int *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);


# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yymsg, yytype, yyvaluep)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */






/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  /* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;

  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short int yyssa[YYINITDEPTH];
  short int *yyss = yyssa;
  register short int *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;


  yyvsp[0] = yylval;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short int *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short int *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a look-ahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to look-ahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 311 "parse.yy"
    { 
        init_cmd_state();

      }
    break;

  case 3:
#line 316 "parse.yy"
    { 
        init_cmd_state();
      }
    break;

  case 35:
#line 354 "parse.yy"
    {
       //if(verbose&2)
         cout << "got an END_OF_INPUT\n";
        /* If we're processing a command file then quit parsing 
         * when we run out of input */
	 //if(Gcmd_file_ref_count)
       	 //quit_parse = 1;
       YYABORT;
     }
    break;

  case 36:
#line 363 "parse.yy"
    {

       init_cmd_state();
       yyclearin;
       // FIXME
       // In some cases we may wish to abort parsing while in others not.
       if (gAbortParserOnSyntaxError) {
         YYABORT;
       }
     }
    break;

  case 40:
#line 391 "parse.yy"
    {
       	  abort_gpsim = 1;
          quit_parse = 1;
          YYABORT;
          }
    break;

  case 41:
#line 399 "parse.yy"
    {attach.attach((yyvsp[-1].Symbol_P),(yyvsp[0].PinList_P)); delete (yyvsp[0].PinList_P);}
    break;

  case 42:
#line 403 "parse.yy"
    {c_break.list();}
    break;

  case 43:
#line 404 "parse.yy"
    {c_break.list((yyvsp[0].Integer_P)->getVal());delete (yyvsp[0].Integer_P);}
    break;

  case 44:
#line 405 "parse.yy"
    {  }
    break;

  case 45:
#line 409 "parse.yy"
    {c_log.log();}
    break;

  case 46:
#line 410 "parse.yy"
    {c_log.log((yyvsp[0].co));}
    break;

  case 47:
#line 411 "parse.yy"
    {c_log.log((yyvsp[-1].co),(yyvsp[0].ExprList_P));}
    break;

  case 48:
#line 416 "parse.yy"
    {(yyval.i)=c_break.set_break((yyvsp[-1].co),(yyvsp[0].ExprList_P));}
    break;

  case 49:
#line 417 "parse.yy"
    {(yyval.i)=c_break.set_break((yyvsp[0].co));}
    break;

  case 50:
#line 421 "parse.yy"
    {c_bus.list_busses();}
    break;

  case 51:
#line 422 "parse.yy"
    {c_bus.add_busses((yyvsp[0].StringList_P)); delete (yyvsp[0].StringList_P);}
    break;

  case 52:
#line 425 "parse.yy"
    {clear.clear((yyvsp[0].Expression_P));}
    break;

  case 53:
#line 429 "parse.yy"
    {disassemble.disassemble(0);}
    break;

  case 54:
#line 430 "parse.yy"
    {disassemble.disassemble((yyvsp[0].Expression_P));}
    break;

  case 55:
#line 434 "parse.yy"
    {dump.dump(2);}
    break;

  case 56:
#line 435 "parse.yy"
    {dump.dump((yyvsp[0].co)->value);}
    break;

  case 57:
#line 439 "parse.yy"
    {c_symbol.dump_one((yyvsp[0].Symbol_P));}
    break;

  case 58:
#line 447 "parse.yy"
    {
                                          c_symbol.EvaluateAndDisplay((yyvsp[-1].Expression_P));
                                          delete (yyvsp[-1].Expression_P);
                                        }
    break;

  case 59:
#line 451 "parse.yy"
    {
	                                  try {
                                            (yyvsp[-2].Symbol_P)->set((yyvsp[0].Expression_P));
					  }
					  catch(Error Message)  {
					    GetUserInterface().DisplayMessage("%s (maybe missing quotes?)\n", Message.toString().c_str());
					  }
                                          (yyvsp[-2].Symbol_P)->update();
                                        }
    break;

  case 60:
#line 461 "parse.yy"
    {
                                          c_symbol.dump((yyvsp[-3].Symbol_P),(yyvsp[-1].ExprList_P));
                                          (yyvsp[-1].ExprList_P)->clear();
                                          delete (yyvsp[-1].ExprList_P);
                                        }
    break;

  case 61:
#line 467 "parse.yy"
    {
                                          c_symbol.Set((yyvsp[-5].Symbol_P), (yyvsp[-3].ExprList_P), (yyvsp[0].Expression_P));
                                          (yyvsp[-3].ExprList_P)->clear();
                                          delete (yyvsp[-3].ExprList_P);
                                          delete (yyvsp[0].Expression_P);
                                        }
    break;

  case 62:
#line 474 "parse.yy"
    {
					  int i=toInt((yyvsp[-1].Expression_P));
					  if (i>=0)
					    c_x.x(toInt((yyvsp[-1].Expression_P)));
                                          delete (yyvsp[-1].Expression_P);
                                        }
    break;

  case 63:
#line 481 "parse.yy"
    {
					  int i=toInt((yyvsp[-3].Expression_P));
					  if (i>=0)
					    c_x.x(toInt((yyvsp[-3].Expression_P)), (yyvsp[0].Expression_P));
                                          delete (yyvsp[-3].Expression_P);
                                        }
    break;

  case 64:
#line 490 "parse.yy"
    {frequency.print();}
    break;

  case 65:
#line 491 "parse.yy"
    {frequency.set((yyvsp[0].Expression_P));}
    break;

  case 66:
#line 495 "parse.yy"
    {help.help(); }
    break;

  case 67:
#line 496 "parse.yy"
    {help.help((yyvsp[0].String_P)->getVal()); delete (yyvsp[0].String_P);}
    break;

  case 68:
#line 497 "parse.yy"
    {help.help((yyvsp[0].Symbol_P));}
    break;

  case 69:
#line 501 "parse.yy"
    {c_list.list();}
    break;

  case 70:
#line 502 "parse.yy"
    {c_list.list((yyvsp[0].co));}
    break;

  case 71:
#line 506 "parse.yy"
    {
            quit_parse = c_load.load((yyvsp[-1].co)->value,(yyvsp[0].String_P)->getVal()) == 0;
            delete (yyvsp[0].String_P);

            if(quit_parse)
            {
              quit_parse = 0;
              YYABORT;
            }
          }
    break;

  case 72:
#line 518 "parse.yy"
    {
            quit_parse = c_load.load((yyvsp[0].String_P)->getVal(), (const char *)NULL) == 0;
            delete (yyvsp[0].String_P);
            quit_parse =0;

            if(quit_parse)
            {
              quit_parse = 0;
              YYABORT;
            }

          }
    break;

  case 73:
#line 532 "parse.yy"
    {
            quit_parse = c_load.load((yyvsp[0].Symbol_P)) == 0;
            quit_parse =0;

            if(quit_parse)
            {
              quit_parse = 0;
              YYABORT;
            }

          }
    break;

  case 74:
#line 545 "parse.yy"
    {
            //                        filename,   processor
            quit_parse = c_load.load((yyvsp[0].Symbol_P), (yyvsp[-1].Symbol_P)) == 0;
            delete (yyvsp[-1].Symbol_P);
            delete (yyvsp[0].Symbol_P);

            if(quit_parse)
            {
              quit_parse = 0;
              YYABORT;
            }
          }
    break;

  case 75:
#line 561 "parse.yy"
    {
            //                        filename,   processor
            quit_parse = c_load.load((yyvsp[0].String_P), (yyvsp[-1].String_P)) == 0;
            delete (yyvsp[-1].String_P);
            delete (yyvsp[0].String_P);

            if(quit_parse)
            {
              quit_parse = 0;
              YYABORT;
            }
          }
    break;

  case 76:
#line 577 "parse.yy"
    {c_node.list_nodes();}
    break;

  case 77:
#line 578 "parse.yy"
    {c_node.add_nodes((yyvsp[0].StringList_P));  delete (yyvsp[0].StringList_P);}
    break;

  case 78:
#line 582 "parse.yy"
    {c_module.module();}
    break;

  case 79:
#line 583 "parse.yy"
    {c_module.module((yyvsp[0].co));}
    break;

  case 80:
#line 584 "parse.yy"
    {c_module.module((yyvsp[0].cos),(list <string> *)0);}
    break;

  case 81:
#line 586 "parse.yy"
    {c_module.module((yyvsp[-1].cos), (yyvsp[0].StringList_P));}
    break;

  case 82:
#line 591 "parse.yy"
    {
            c_processor.processor();
          }
    break;

  case 83:
#line 595 "parse.yy"
    {
            c_processor.processor((yyvsp[0].co)->value);
          }
    break;

  case 84:
#line 599 "parse.yy"
    {
            c_processor.processor((yyvsp[0].String_P)->getVal(),0);
          }
    break;

  case 85:
#line 603 "parse.yy"
    { 
            c_processor.processor((yyvsp[-1].String_P)->getVal(),(yyvsp[0].String_P)->getVal());
          }
    break;

  case 86:
#line 609 "parse.yy"
    { 
            quit_parse = 1;
	    YYABORT;
          }
    break;

  case 87:
#line 614 "parse.yy"
    {
            quit_parse = 1;
	    //quit_state = $2;  // FIXME need to evaluate expr
	    YYABORT;
	  }
    break;

  case 88:
#line 622 "parse.yy"
    { reset.reset(); }
    break;

  case 89:
#line 626 "parse.yy"
    { c_run.run();}
    break;

  case 90:
#line 630 "parse.yy"
    {c_set.set();}
    break;

  case 91:
#line 631 "parse.yy"
    {c_set.set((yyvsp[0].co)->value,0);}
    break;

  case 92:
#line 632 "parse.yy"
    {c_set.set((yyvsp[-1].co)->value,(yyvsp[0].Expression_P));}
    break;

  case 93:
#line 636 "parse.yy"
    {step.step(1);}
    break;

  case 94:
#line 637 "parse.yy"
    {step.step((yyvsp[0].Expression_P));}
    break;

  case 95:
#line 638 "parse.yy"
    {step.over();}
    break;

  case 96:
#line 642 "parse.yy"
    {c_shell.shell((yyvsp[0].String_P)); delete (yyvsp[0].String_P);}
    break;

  case 97:
#line 646 "parse.yy"
    {
          c_stimulus.stimulus();
          }
    break;

  case 98:
#line 650 "parse.yy"
    {
          c_stimulus.stimulus((yyvsp[0].co)->value);
          }
    break;

  case 99:
#line 654 "parse.yy"
    {
          /* do nothing */
          }
    break;

  case 100:
#line 658 "parse.yy"
    { 
            if(verbose)
              cout << " end of stimulus command\n";
            c_stimulus.end();
          }
    break;

  case 101:
#line 668 "parse.yy"
    {
            if(verbose)
              cout << "parser sees stimulus with numeric option\n";
            c_stimulus.stimulus((yyvsp[0].coe));
          }
    break;

  case 102:
#line 674 "parse.yy"
    {
            if(verbose)
              cout << "parser sees stimulus with bit flag: " << (yyvsp[0].co)->value << '\n';
            c_stimulus.stimulus((yyvsp[0].co)->value);
          }
    break;

  case 103:
#line 680 "parse.yy"
    {
            if(verbose)
              cout << "parser sees stimulus with string option\n";
            c_stimulus.stimulus((yyvsp[0].cos));
          }
    break;

  case 104:
#line 686 "parse.yy"
    { 
            if(verbose)
              cout << "parser sees stimulus with an array\n";
            c_stimulus.stimulus((yyvsp[0].ExprList_P));
          }
    break;

  case 105:
#line 695 "parse.yy"
    {c_symbol.dump_all();}
    break;

  case 106:
#line 697 "parse.yy"
    {c_symbol.add_one((yyvsp[-2].String_P)->getVal(), (yyvsp[0].Expression_P)); delete (yyvsp[0].Expression_P);}
    break;

  case 107:
#line 698 "parse.yy"
    {c_symbol.dump_one((yyvsp[0].String_P)->getVal());}
    break;

  case 108:
#line 699 "parse.yy"
    {c_symbol.dump_one((yyvsp[0].Symbol_P));}
    break;

  case 109:
#line 704 "parse.yy"
    { c_trace.trace(); }
    break;

  case 110:
#line 705 "parse.yy"
    { c_trace.trace((yyvsp[0].Expression_P)); }
    break;

  case 111:
#line 706 "parse.yy"
    { c_trace.trace((yyvsp[0].con)); }
    break;

  case 112:
#line 707 "parse.yy"
    { c_trace.trace((yyvsp[0].cos)); }
    break;

  case 113:
#line 708 "parse.yy"
    { c_trace.trace((yyvsp[0].co)); }
    break;

  case 114:
#line 709 "parse.yy"
    { c_trace.trace((yyvsp[0].coe)); }
    break;

  case 115:
#line 712 "parse.yy"
    {version.version();}
    break;

  case 116:
#line 716 "parse.yy"
    { c_x.x();}
    break;

  case 117:
#line 717 "parse.yy"
    { c_x.x((yyvsp[0].Expression_P)); }
    break;

  case 118:
#line 721 "parse.yy"
    { c_icd.icd(); }
    break;

  case 119:
#line 722 "parse.yy"
    { c_icd.icd((yyvsp[0].cos)); }
    break;

  case 120:
#line 743 "parse.yy"
    { c_macro.list();}
    break;

  case 121:
#line 744 "parse.yy"
    { }
    break;

  case 122:
#line 745 "parse.yy"
    { lexer_InvokeMacro((yyvsp[0].Macro_P)); }
    break;

  case 123:
#line 751 "parse.yy"
    {c_macro.define((yyvsp[-1].String_P)->getVal()); delete (yyvsp[-1].String_P);}
    break;

  case 124:
#line 753 "parse.yy"
    {lexer_setMacroBodyMode();}
    break;

  case 127:
#line 761 "parse.yy"
    {
            c_macro.add_parameter((yyvsp[0].String_P)->getVal());
	    delete (yyvsp[0].String_P);
	  }
    break;

  case 128:
#line 766 "parse.yy"
    {
	    c_macro.add_parameter((yyvsp[0].String_P)->getVal());
	    delete (yyvsp[0].String_P);
	  }
    break;

  case 130:
#line 775 "parse.yy"
    {; }
    break;

  case 131:
#line 779 "parse.yy"
    {c_macro.add_body((yyvsp[0].s));}
    break;

  case 132:
#line 780 "parse.yy"
    {c_macro.add_body((yyvsp[0].s));}
    break;

  case 133:
#line 784 "parse.yy"
    {c_macro.end_define();}
    break;

  case 134:
#line 785 "parse.yy"
    {c_macro.end_define((yyvsp[-1].String_P)->getVal()); delete (yyvsp[-1].String_P); }
    break;

  case 135:
#line 806 "parse.yy"
    {
		       cout << "declaration\n";
		       lexer_setDeclarationMode();
		     }
    break;

  case 136:
#line 811 "parse.yy"
    {
		       cout << " type:" << (yyvsp[0].i) << endl;
		     }
    break;

  case 137:
#line 815 "parse.yy"
    {
		       cout << "identifier: " << (yyvsp[0].String_P)->getVal() << endl;  delete (yyvsp[0].String_P);
		     }
    break;

  case 138:
#line 822 "parse.yy"
    { (yyval.i)=0; }
    break;

  case 139:
#line 823 "parse.yy"
    { (yyval.i) = 1; cout <<"int type\n";}
    break;

  case 140:
#line 824 "parse.yy"
    { (yyval.i) = 2; cout <<"float type\n";}
    break;

  case 141:
#line 825 "parse.yy"
    { (yyval.i) = 3; cout <<"bool type\n";}
    break;

  case 142:
#line 826 "parse.yy"
    { (yyval.i) = 4; cout <<"char type\n";}
    break;

  case 143:
#line 851 "parse.yy"
    {
	 (yyval.co) = (yyvsp[0].co);
      }
    break;

  case 144:
#line 857 "parse.yy"
    {
	 (yyval.co) = (yyvsp[0].co);
      }
    break;

  case 145:
#line 862 "parse.yy"
    { (yyval.coe) = new cmd_options_expr((yyvsp[-1].co),(yyvsp[0].Expression_P)); }
    break;

  case 146:
#line 866 "parse.yy"
    { 

	        (yyval.con) = new cmd_options_num;
	        (yyval.con)->co = (yyvsp[-1].co);
	      }
    break;

  case 147:
#line 875 "parse.yy"
    { 
          (yyval.cos) = new cmd_options_str((yyvsp[0].String_P)->getVal());
          (yyval.cos)->co  = (yyvsp[-1].co);
          if(verbose&2)
            cout << " name " << (yyval.cos)->co->name << " value " << (yyval.cos)->str << " got a string option \n"; 
        }
    break;

  case 148:
#line 882 "parse.yy"
    { 
          String *pValue = dynamic_cast<String*>((yyvsp[0].Symbol_P));
          if(pValue != NULL) {
            (yyval.cos) = new cmd_options_str(pValue->getVal());
            (yyval.cos)->co  = (yyvsp[-1].co);
            if(verbose&2)
              cout << " name " << (yyval.cos)->co->name << " value " << (yyval.cos)->str << " got a string option \n"; 
          }
          else {
            cout << " option variable '"
                 << (yyvsp[0].Symbol_P)->name()
                 << "' is not a string"
                 << endl; 
          }
        }
    break;

  case 149:
#line 900 "parse.yy"
    {(yyval.StringList_P) = new StringList_t(); (yyval.StringList_P)->push_back((yyvsp[0].String_P)->getVal());}
    break;

  case 150:
#line 901 "parse.yy"
    {(yyvsp[-1].StringList_P)->push_back((yyvsp[0].String_P)->getVal());}
    break;

  case 151:
#line 907 "parse.yy"
    {(yyval.Expression_P)=(yyvsp[0].BinaryOperator_P);}
    break;

  case 152:
#line 908 "parse.yy"
    {(yyval.Expression_P)=(yyvsp[0].Expression_P);}
    break;

  case 153:
#line 909 "parse.yy"
    {(yyval.Expression_P)=new RegisterExpression(toInt((yyvsp[-1].Expression_P)));
                                                         delete (yyvsp[-1].Expression_P); }
    break;

  case 154:
#line 913 "parse.yy"
    {(yyval.ExprList_P)=(yyvsp[-1].ExprList_P);}
    break;

  case 155:
#line 916 "parse.yy"
    {(yyval.Pin_P)=new Pin_t(Pin_t::ePackageBased | Pin_t::eActiveProc, (yyvsp[-1].Symbol_P));}
    break;

  case 156:
#line 917 "parse.yy"
    {(yyval.Pin_P)=new Pin_t(Pin_t::ePackageBased | Pin_t::eActiveProc, (yyvsp[-1].Integer_P));}
    break;

  case 157:
#line 918 "parse.yy"
    {(yyval.Pin_P)=new Pin_t(Pin_t::ePackageBased, (yyvsp[-3].Symbol_P),(yyvsp[-1].Symbol_P));}
    break;

  case 158:
#line 919 "parse.yy"
    {(yyval.Pin_P)=new Pin_t(Pin_t::ePackageBased, (yyvsp[-3].Symbol_P),(yyvsp[-1].Integer_P));}
    break;

  case 159:
#line 920 "parse.yy"
    {(yyval.Pin_P)=new Pin_t(Pin_t::ePortBased | Pin_t::eActiveProc, NULL, (yyvsp[-3].Symbol_P), (yyvsp[-1].Symbol_P));}
    break;

  case 160:
#line 921 "parse.yy"
    {(yyval.Pin_P)=new Pin_t(Pin_t::ePortBased | Pin_t::eActiveProc, NULL, (yyvsp[-3].Symbol_P), (yyvsp[-1].Integer_P));}
    break;

  case 161:
#line 922 "parse.yy"
    {(yyval.Pin_P)=new Pin_t(Pin_t::ePortBased, (yyvsp[-5].Symbol_P),(yyvsp[-3].Symbol_P),(yyvsp[-1].Symbol_P));}
    break;

  case 162:
#line 923 "parse.yy"
    {(yyval.Pin_P)=new Pin_t(Pin_t::ePortBased, (yyvsp[-5].Symbol_P),(yyvsp[-3].Symbol_P),(yyvsp[-1].Integer_P));}
    break;

  case 163:
#line 924 "parse.yy"
    {(yyval.Pin_P)=new Pin_t(Pin_t::ePortBased, (yyvsp[0].Symbol_P));}
    break;

  case 164:
#line 928 "parse.yy"
    {(yyval.PinList_P) = new PinList_t(); (yyval.PinList_P)->push_back((yyvsp[0].Pin_P));}
    break;

  case 165:
#line 929 "parse.yy"
    {(yyvsp[-1].PinList_P)->push_back((yyvsp[0].Pin_P));}
    break;

  case 166:
#line 933 "parse.yy"
    {(yyval.ExprList_P) = new ExprList_t(); (yyval.ExprList_P)->push_back((yyvsp[0].Expression_P));}
    break;

  case 167:
#line 934 "parse.yy"
    {(yyvsp[-2].ExprList_P)->push_back((yyvsp[0].Expression_P));}
    break;

  case 168:
#line 938 "parse.yy"
    {(yyval.BinaryOperator_P) = new OpAdd((yyvsp[-2].Expression_P), (yyvsp[0].Expression_P));}
    break;

  case 169:
#line 939 "parse.yy"
    {(yyval.BinaryOperator_P) = new OpSub((yyvsp[-2].Expression_P), (yyvsp[0].Expression_P));}
    break;

  case 170:
#line 940 "parse.yy"
    {(yyval.BinaryOperator_P) = new OpMpy((yyvsp[-2].Expression_P), (yyvsp[0].Expression_P));}
    break;

  case 171:
#line 941 "parse.yy"
    {(yyval.BinaryOperator_P) = new OpDiv((yyvsp[-2].Expression_P), (yyvsp[0].Expression_P));}
    break;

  case 172:
#line 942 "parse.yy"
    {(yyval.BinaryOperator_P) = new OpAnd((yyvsp[-2].Expression_P), (yyvsp[0].Expression_P));}
    break;

  case 173:
#line 943 "parse.yy"
    {(yyval.BinaryOperator_P) = new OpOr((yyvsp[-2].Expression_P), (yyvsp[0].Expression_P));}
    break;

  case 174:
#line 944 "parse.yy"
    {(yyval.BinaryOperator_P) = new OpXor((yyvsp[-2].Expression_P), (yyvsp[0].Expression_P));}
    break;

  case 175:
#line 945 "parse.yy"
    {(yyval.BinaryOperator_P) = new OpShl((yyvsp[-2].Expression_P), (yyvsp[0].Expression_P));}
    break;

  case 176:
#line 946 "parse.yy"
    {(yyval.BinaryOperator_P) = new OpShr((yyvsp[-2].Expression_P), (yyvsp[0].Expression_P));}
    break;

  case 177:
#line 947 "parse.yy"
    {(yyval.BinaryOperator_P) = new OpEq((yyvsp[-2].Expression_P), (yyvsp[0].Expression_P));}
    break;

  case 178:
#line 948 "parse.yy"
    {(yyval.BinaryOperator_P) = new OpNe((yyvsp[-2].Expression_P), (yyvsp[0].Expression_P));}
    break;

  case 179:
#line 949 "parse.yy"
    {(yyval.BinaryOperator_P) = new OpLt((yyvsp[-2].Expression_P), (yyvsp[0].Expression_P));}
    break;

  case 180:
#line 950 "parse.yy"
    {(yyval.BinaryOperator_P) = new OpGt((yyvsp[-2].Expression_P), (yyvsp[0].Expression_P));}
    break;

  case 181:
#line 951 "parse.yy"
    {(yyval.BinaryOperator_P) = new OpLe((yyvsp[-2].Expression_P), (yyvsp[0].Expression_P));}
    break;

  case 182:
#line 952 "parse.yy"
    {(yyval.BinaryOperator_P) = new OpGe((yyvsp[-2].Expression_P), (yyvsp[0].Expression_P));}
    break;

  case 183:
#line 953 "parse.yy"
    {(yyval.BinaryOperator_P) = new OpLogicalAnd((yyvsp[-2].Expression_P), (yyvsp[0].Expression_P));}
    break;

  case 184:
#line 954 "parse.yy"
    {(yyval.BinaryOperator_P) = new OpLogicalOr((yyvsp[-2].Expression_P), (yyvsp[0].Expression_P));}
    break;

  case 185:
#line 955 "parse.yy"
    {(yyval.BinaryOperator_P) = new OpAbstractRange((yyvsp[-2].Expression_P), (yyvsp[0].Expression_P));}
    break;

  case 186:
#line 959 "parse.yy"
    {(yyval.Expression_P)=(yyvsp[0].Expression_P);}
    break;

  case 187:
#line 960 "parse.yy"
    {(yyval.Expression_P) = new OpPlus((yyvsp[0].Expression_P));}
    break;

  case 188:
#line 961 "parse.yy"
    {(yyval.Expression_P) = new OpNegate((yyvsp[0].Expression_P));}
    break;

  case 189:
#line 962 "parse.yy"
    {(yyval.Expression_P) = new OpOnescomp((yyvsp[0].Expression_P));}
    break;

  case 190:
#line 963 "parse.yy"
    {(yyval.Expression_P) = new OpLogicalNot((yyvsp[0].Expression_P));}
    break;

  case 191:
#line 964 "parse.yy"
    {(yyval.Expression_P) = new OpIndirect((yyvsp[0].Expression_P));}
    break;

  case 192:
#line 965 "parse.yy"
    {(yyval.Expression_P) = new OpAddressOf((yyvsp[0].Expression_P));}
    break;

  case 193:
#line 966 "parse.yy"
    {(yyval.Expression_P)=(yyvsp[-1].Expression_P);}
    break;

  case 194:
#line 969 "parse.yy"
    {(yyval.Expression_P) = new LiteralInteger((yyvsp[0].Integer_P));}
    break;

  case 195:
#line 970 "parse.yy"
    {(yyval.Expression_P) = new LiteralBoolean((yyvsp[0].Boolean_P));}
    break;

  case 196:
#line 971 "parse.yy"
    {(yyval.Expression_P) = new LiteralString((yyvsp[0].String_P));}
    break;

  case 197:
#line 972 "parse.yy"
    {(yyval.Expression_P) = new LiteralFloat((yyvsp[0].Float_P));}
    break;

  case 198:
#line 973 "parse.yy"
    {(yyval.Expression_P) = new LiteralSymbol((yyvsp[0].Symbol_P));}
    break;

  case 199:
#line 974 "parse.yy"
    {(yyval.Expression_P) = new IndexedSymbol((yyvsp[-3].Symbol_P),(yyvsp[-1].ExprList_P));}
    break;

  case 200:
#line 975 "parse.yy"
    {(yyval.Expression_P) = new LiteralArray((yyvsp[0].ExprList_P)); }
    break;


    }

/* Line 1037 of yacc.c.  */
#line 2714 "parse.cc"

  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  const char* yyprefix;
	  char *yymsg;
	  int yyx;

	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  int yyxbegin = yyn < 0 ? -yyn : 0;

	  /* Stay within bounds of both yycheck and yytname.  */
	  int yychecklim = YYLAST - yyn;
	  int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
	  int yycount = 0;

	  yyprefix = ", expecting ";
	  for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      {
		yysize += yystrlen (yyprefix) + yystrlen (yytname [yyx]);
		yycount += 1;
		if (yycount == 5)
		  {
		    yysize = 0;
		    break;
		  }
	      }
	  yysize += (sizeof ("syntax error, unexpected ")
		     + yystrlen (yytname[yytype]));
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "syntax error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yyprefix = ", expecting ";
		  for (yyx = yyxbegin; yyx < yyxend; ++yyx)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			yyp = yystpcpy (yyp, yyprefix);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yyprefix = " or ";
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("syntax error");
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse look-ahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* If at end of input, pop the error token,
	     then the rest of the stack, then return failure.  */
	  if (yychar == YYEOF)
	     for (;;)
	       {

		 YYPOPSTACK;
		 if (yyssp == yyss)
		   YYABORT;
		 yydestruct ("Error: popping",
                             yystos[*yyssp], yyvsp);
	       }
        }
      else
	{
	  yydestruct ("Error: discarding", yytoken, &yylval);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse look-ahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

#ifdef __GNUC__
  /* Pacify GCC when the user code never invokes YYERROR and the label
     yyerrorlab therefore never appears in user code.  */
  if (0)
     goto yyerrorlab;
#endif

yyvsp -= yylen;
  yyssp -= yylen;
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;


      yydestruct ("Error: popping", yystos[yystate], yyvsp);
      YYPOPSTACK;
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  *++yyvsp = yylval;


  /* Shift the error token. */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yydestruct ("Error: discarding lookahead",
              yytoken, &yylval);
  yychar = YYEMPTY;
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 978 "parse.yy"


       // parsing is over 

//--------------------------
// This initialization could be done by the compiler. However
// it requires two passes through because the token values are
// defined by the parser output (eg. y.tab.h) while at the same
// time the parser depends on the .h files in which these classes
// are defined.

void initialize_commands(void)
{
  static bool initialized = 0;

  if(initialized)
    return;

  if(verbose)
    cout << __FUNCTION__ << "()\n";

  attach.token_value = ATTACH;
  c_break.token_value = BREAK;
  // c_bus.token_value = BUS;
  clear.token_value = CLEAR;
  disassemble.token_value = DISASSEMBLE;
  dump.token_value = DUMP;
  frequency.token_value = FREQUENCY;
  help.token_value = HELP;
  c_list.token_value = LIST;
  c_load.token_value = LOAD;
  c_log.token_value = LOG;
  c_macro.token_value = MACRO;
  c_module.token_value = MODULE;
  c_node.token_value = NODE;
  c_processor.token_value = PROCESSOR;
  quit.token_value = QUIT;
  reset.token_value = RESET;
  c_run.token_value = RUN;
  c_set.token_value = SET;
  step.token_value = STEP;
  c_stimulus.token_value = STIMULUS;
  c_symbol.token_value = SYMBOL;
  c_trace.token_value = TRACE;
  version.token_value = gpsim_VERSION;
  c_x.token_value = X;
  c_icd.token_value = ICD;
  c_shell.token_value = SHELL;

  initialized = 1;

  parser_spanning_lines = 0;
  parser_warnings = 1; // display parser warnings.
}

