# tests/test_idle.py
#
#

__copyright__ = 'this file is in the public domain'

from gozerbot.bot import Bot
from gozerbot.generic import stringinlist, waitforqueue
from gozerbot.plugins import plugins
import unittest, Queue, time

plugins.reload('gozerplugs.plugs', 'idle')

class test_idle(unittest.TestCase):
    b = Bot()
    b.userhosts['test'] = 'test@test'
    b.userhosts['test2'] = 'test2@test2'

    def test_idle2(self):
        self.b.fakein(':test!test@test PRIVMSG #test :bla')
        time.sleep(2)
        result = self.b.test('idle')
        self.assert_(stringinlist('is idle', result))

    def test_idle2(self):
        self.b.fakein(':test!test@test PRIVMSG #test :bla')
        result = self.b.test('idle')
        self.assert_(stringinlist('is not idle', result))

    def test_idle3(self):
        result = self.b.test('idle mek99ker')
        self.assert_(stringinlist("can't get userhost", result))

    def test_idle4(self):
        result = self.b.test('idle test2')
        self.assert_(stringinlist("haven't seen", result))

    def test_idle5(self):
        self.b.fakein(':test!test@test PRIVMSG #test :bla')
        time.sleep(3)
        result = self.b.test('idle test')
        self.assert_(stringinlist('is idle', result))

    def test_idle6(self):
        self.b.fakein(':test!test@test PRIVMSG #test :bla')
        result = self.b.test('idle test')
        self.assert_(stringinlist('is not idle', result))
