# tests/test_chanperm.py
#
#

__copyright__ = 'this file is in the public domain'

from gozerbot.bot import Bot
from gozerbot.generic import stringinlist, waitforqueue
from gozerbot.plugins import plugins
import unittest

plugins.reload('gozerplugs.plugs', 'chanperm')

class test_chanperm(unittest.TestCase):
    b = Bot()
    b.userhosts['test'] = 'test@test'
    b.channels['#test'] = {}
    
    def test_chanperm(self):
        result = self.b.test('chanperm')
        self.assert_(stringinlist('no permissions', result))

    def test_chanperm2(self):
        self.b.test('chanperm-add mekker')
        result = self.b.test('chanperm')
        self.b.test('chanperm-del mekker')
        self.assert_(stringinlist('MEKKER', result))

    def test_chanpermadd(self):
        result = self.b.test('chanperm-add')
        self.assert_(stringinlist('<perm>', result))

    def test_chanpermadd2(self):
        result = self.b.test('chanperm-add oper')
        self.assert_(stringinlist("can't set", result))

    def test_chanpermadd3(self):
        self.b.test('chanperm-add MEKKER')
        result = self.b.test('chanperm-add MEKKER')
        self.b.test('chanperm-del mekker')
        self.assert_(stringinlist('already', result))

    def test_chanpermadd4(self):
        result = self.b.test('chanperm-add mekker')
        self.b.test('chanperm-del mekker')
        self.assert_(stringinlist('added', result))

    def test_chanpermdel(self):
        result = self.b.test('chanperm-del')
        self.assert_(stringinlist('<perm>', result))

    def test_chanpermdel2(self):
        self.b.test('chanperm-add MEKKER')
        result = self.b.test('chanperm-del MEKKER')
        self.b.test('chanperm-del mekker')
        self.assert_(stringinlist('deleted', result))

    def test_chanpermdel3(self):
        result = self.b.test('chanperm-del MEKKER')
        self.b.test('chanperm-del mekker')
        self.assert_(stringinlist('there is no', result))
