# Description: tracks when a nick is last seen
# Author: Wijnand 'tehmaze' Modderman
# Website: http://tehmaze.com
# License: BSD

from gozerbot.callbacks import callbacks
from gozerbot.commands import cmnds
from gozerbot.datadir import datadir
from gozerbot.pdod import Pdod
from gozerbot.persistconfig import PersistConfig
import os, datetime

cfg = PersistConfig()
cfg.define('tz', '+0100')

class Seen(Pdod):
    def __init__(self):
        Pdod.__init__(self, os.path.join(datadir, 'seen'))

    def handle_seen(self, bot, ievent):
        if not ievent.args:
            ievent.missing('<nick>')
            return
        nick = ievent.args[0].lower()
        if not self.data.has_key(nick):
            alts = [x for x in self.data.keys() if nick in x]
            if alts:
                alts.sort()
                if len(alts) > 10:
                    nums = len(alts) - 10
                    alts = ', '.join(alts[:10]) + ' + %d others' % nums
                else:
                    alts = ', '.join(alts)
                ievent.reply('no logs for %s, however, I remember seeing: %s' % (nick, alts))
            else:
                ievent.reply('no logs for %s' % nick)
        else:
            text = self.data[nick]['text'] and ': %s' % self.data[nick]['text'] or ''
            ievent.reply('%s was last seen on %s at %s, %s%s' % (nick, self.data[nick]['bot'], 
                self.data[nick]['time'].strftime('%a, %d %b %Y %H:%M:%S '+cfg.get('tz')), 
                self.data[nick]['what'], text))

    def privmsgcb(self, bot, ievent):
        self.data[ievent.nick.lower()] = {
            'time':    datetime.datetime.now(),
            'text':    ievent.origtxt,
            'bot':     bot.name,
            'channel': ievent.channel,
            'what':    'saying',
            }

    def joincb(self, bot, ievent):
        self.data[ievent.nick.lower()] = {
            'time':    datetime.datetime.now(),
            'text':    '',
            'bot':     bot.name,
            'channel': ievent.channel,
            'what':    'joining %s' % ievent.channel,
            }
    
    def partcb(self, bot, ievent):
        self.data[ievent.nick.lower()] = {
            'time':    datetime.datetime.now(),
            'text':    ievent.txt,
            'bot':     bot.name,
            'channel': ievent.channel,
            'what':    'parting %s' % ievent.channel,
            }
    
    def quitcb(self, bot, ievent):
        self.data[ievent.nick.lower()] = {
            'time':    datetime.datetime.now(),
            'text':    ievent.txt,
            'bot':     bot.name,
            'channel': ievent.channel,
            'what':    'quitting',
            }
    

    def size(self):
        return len(self.data.keys())

def init():
    global seen
    seen = Seen()
    callbacks.add('PRIVMSG', seen.privmsgcb)
    callbacks.add('JOIN', seen.joincb)
    callbacks.add('PART', seen.partcb)
    callbacks.add('QUIT', seen.quitcb)
    cmnds.add('seen', seen.handle_seen, ['ANON', 'USER'])
    return 1

def shutdown():
    global seen
    seen.save()
    del seen

def size():
    global seen
    return seen.size()
