# gozerbot/runner.py
#
#

""" thread to run jobs """

__copyright__ = 'this file is in the public domain'

from gozerbot.thr import start_new_thread
from gozerbot.generic import handle_exception, rlog, lockdec
from gozerbot.threadloop import ThreadLoop
import Queue, time, thread

runlock = thread.allocate_lock()
locked = lockdec(runlock)

class Runner(ThreadLoop):

    @locked
    def handle(self, descr, func, *args, **kwargs):
        try:
            rlog(1, 'runner', 'running %s: %s' % (descr, str(func)))
            start = time.time()
            func(*args, **kwargs)
            elapsed = time.time() - start
            if elapsed > 1:
                rlog(10, 'runner', 'ALERT %s %s job taking too long: %s \
seconds' % (descr, str(func), elapsed))
        except Exception, ex:
            handle_exception()

runner = Runner('runner')
