// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GOOCANVASMM_ENUMS_H
#define _GOOCANVASMM_ENUMS_H


#include <glibmm.h>

/* Copyright (C) 1998-2006 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <goocanvasutils.h>

#include <cairomm/enums.h>
#include <cairomm/pattern.h>
#include <cairomm/context.h> // For Cairo::Matrix


namespace Goocanvas
{

/** @addtogroup goocanvasmmEnums Enums and Flags */

/**
 * @ingroup goocanvasmmEnums
 * @par Bitwise operators:
 * <tt>%PointerEvents operator|(PointerEvents, PointerEvents)</tt><br>
 * <tt>%PointerEvents operator&(PointerEvents, PointerEvents)</tt><br>
 * <tt>%PointerEvents operator^(PointerEvents, PointerEvents)</tt><br>
 * <tt>%PointerEvents operator~(PointerEvents)</tt><br>
 * <tt>%PointerEvents& operator|=(PointerEvents&, PointerEvents)</tt><br>
 * <tt>%PointerEvents& operator&=(PointerEvents&, PointerEvents)</tt><br>
 * <tt>%PointerEvents& operator^=(PointerEvents&, PointerEvents)</tt><br>
 */
enum PointerEvents
{
  EVENTS_VISIBLE_MASK = 1 << 0,
  EVENTS_PAINTED_MASK = 1 << 1,
  EVENTS_FILL_MASK = 1 << 2,
  EVENTS_STROKE_MASK = 1 << 3,
  EVENTS_NONE = 0,
  EVENTS_VISIBLE_PAINTED = 0x1,
  EVENTS_VISIBLE_FILL = 0x1,
  EVENTS_VISIBLE_STROKE = 0x1,
  EVENTS_VISIBLE = 0x1,
  EVENTS_PAINTED = 0x2,
  EVENTS_FILL = 0x4,
  EVENTS_STROKE = 0x8,
  EVENTS_ALL = 0x4
};

/** @ingroup goocanvasmmEnums */
inline PointerEvents operator|(PointerEvents lhs, PointerEvents rhs)
  { return static_cast<PointerEvents>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup goocanvasmmEnums */
inline PointerEvents operator&(PointerEvents lhs, PointerEvents rhs)
  { return static_cast<PointerEvents>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup goocanvasmmEnums */
inline PointerEvents operator^(PointerEvents lhs, PointerEvents rhs)
  { return static_cast<PointerEvents>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup goocanvasmmEnums */
inline PointerEvents operator~(PointerEvents flags)
  { return static_cast<PointerEvents>(~static_cast<unsigned>(flags)); }

/** @ingroup goocanvasmmEnums */
inline PointerEvents& operator|=(PointerEvents& lhs, PointerEvents rhs)
  { return (lhs = static_cast<PointerEvents>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup goocanvasmmEnums */
inline PointerEvents& operator&=(PointerEvents& lhs, PointerEvents rhs)
  { return (lhs = static_cast<PointerEvents>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup goocanvasmmEnums */
inline PointerEvents& operator^=(PointerEvents& lhs, PointerEvents rhs)
  { return (lhs = static_cast<PointerEvents>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Goocanvas


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Goocanvas::PointerEvents> : public Glib::Value_Flags<Goocanvas::PointerEvents>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Goocanvas
{

/**
 * @ingroup goocanvasmmEnums
 */
enum ItemVisibility
{
  ITEM_HIDDEN,
  ITEM_INVISIBLE,
  ITEM_VISIBLE,
  ITEM_VISIBLE_ABOVE_THRESHOLD
};

} // namespace Goocanvas


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Goocanvas::ItemVisibility> : public Glib::Value_Enum<Goocanvas::ItemVisibility>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Goocanvas
{

/**
 * @ingroup goocanvasmmEnums
 */
enum PathCommandType
{
  PATH_MOVE_TO,
  PATH_CLOSE_PATH,
  PATH_LINE_TO,
  PATH_HORIZONTAL_LINE_TO,
  PATH_VERTICAL_LINE_TO,
  PATH_CURVE_TO,
  PATH_SMOOTH_CURVE_TO,
  PATH_QUADRATIC_CURVE_TO,
  PATH_SMOOTH_QUADRATIC_CURVE_TO,
  PATH_ELLIPTICAL_ARC
};

} // namespace Goocanvas


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Goocanvas::PathCommandType> : public Glib::Value_Enum<Goocanvas::PathCommandType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Goocanvas
{


} //namespace Goocanvas

namespace Glib
{

#ifndef DOXYGEN_SHOULD_SKIP_THIS
// Make the cairo enums and structures work with Glib::Value using the
// GTypes goocanvas defines for them in goocanvasutil.h

template<>
class Value<Cairo::Pattern> : public Glib::ValueBase_Boxed
{
public:
  static GType value_type() G_GNUC_CONST;

  void set(const Cairo::Pattern& data) { set_boxed(data.cobj()); }
  Cairo::Pattern get() const { return Cairo::Pattern(static_cast<cairo_pattern_t*>(get_boxed())); }
};

template<>
class Value<Cairo::Matrix*> : public Glib::ValueBase_Boxed
{
public:
  static GType value_type() G_GNUC_CONST;

  void set(const Cairo::Matrix* data) { set_boxed(data); }
  Cairo::Matrix* get() const { return static_cast<Cairo::Matrix*>(get_boxed()); }
};

template<>
class Value<Cairo::FillRule> : public Glib::Value_Enum<Cairo::FillRule>
{
public:
  static GType value_type() G_GNUC_CONST;
};

template<>
class Value<Cairo::Operator> : public Glib::Value_Enum<Cairo::Operator>
{
public:
  static GType value_type() G_GNUC_CONST;
};

template<>
class Value<Cairo::Antialias> : public Glib::Value_Enum<Cairo::Antialias>
{
public:
  static GType value_type() G_GNUC_CONST;
};

template<>
class Value<Cairo::LineCap> : public Glib::Value_Enum<Cairo::LineCap>
{
public:
  static GType value_type() G_GNUC_CONST;
};

template<>
class Value<Cairo::LineJoin> : public Glib::Value_Enum<Cairo::LineJoin>
{
public:
  static GType value_type() G_GNUC_CONST;
};

template<>
class Value<Cairo::HintMetrics> : public Glib::Value_Enum<Cairo::HintMetrics>
{
public:
  static GType value_type() G_GNUC_CONST;
};

#endif // DOXYGEN_SHOULD_SKIP_THIS

}


#endif /* _GOOCANVASMM_ENUMS_H */

