<?php
/**
 * $Horde: gollem/view.php,v 1.51.2.3 2007/01/02 13:54:52 jan Exp $
 *
 * Copyright 1999-2007 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999-2007 Max Kalika <max@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

$session_control = 'readonly';
$no_compress = true;
@define('GOLLEM_BASE', dirname(__FILE__));
require_once GOLLEM_BASE . '/lib/base.php';

$actionID = Util::getFormData('actionID');
$driver = Util::getFormData('driver');
$filedir = Util::getFormData('dir');
$filename = Util::getFormData('file');
$type = Util::getFormData('type');

if ($driver != $GLOBALS['gollem_be']['driver']) {
    $url = Util::addParameter(Horde::applicationUrl('login.php'), array('backend_key' => $driver, 'change_backend' => 1, 'url' => Horde::selfURL(true)), null, false);
    header('Location: ' . $url);
    exit;
}

$data = $GLOBALS['gollem_vfs']->read($filedir, $filename);
if (is_a($data, 'PEAR_Error')) {
    $notification->push(sprintf(_("Access denied to %s"), $filename), 'horde.error');
    header('Location: ' . Util::addParameter(Horde::applicationUrl('manager.php', true), 'actionID', $actionID));
    exit;
}

/* Run through action handlers. */
switch ($actionID) {
case 'download_file':
    $browser->downloadHeaders($filename, null, false, strlen($data));
    echo $data;
    break;

case 'view_file':
    require_once 'Horde/MIME/Contents.php';
    require_once 'Horde/MIME/Magic.php';
    require GOLLEM_BASE . '/config/mime_drivers.php';
    $mime = &new MIME_Part(MIME_Magic::extToMIME($type), $data);
    $mime->setName($filename);
    $contents = &new MIME_Contents($mime);
    $body = $contents->renderMIMEPart($mime);
    $type = $contents->getMIMEViewerType($mime);
    $browser->downloadHeaders($mime->getName(true, true), $type, true, strlen($body));
    echo $body;
    break;
}
