// Copyright 2009 The Go Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

#include <signal.h>
#include <stdarg.h>
#include <windef.h>
#include <winbase.h>
#include <wincon.h>

enum {
	$PROT_NONE = 0,
	$PROT_READ = 1,
	$PROT_WRITE = 2,
	$PROT_EXEC = 4,

	$MAP_ANON = 1,
	$MAP_PRIVATE = 2,

	$DUPLICATE_SAME_ACCESS = DUPLICATE_SAME_ACCESS,
	$THREAD_PRIORITY_HIGHEST = THREAD_PRIORITY_HIGHEST,

	$SIGINT = SIGINT,
	$CTRL_C_EVENT = CTRL_C_EVENT,
	$CTRL_BREAK_EVENT = CTRL_BREAK_EVENT,

	$CONTEXT_CONTROL = CONTEXT_CONTROL,
	$CONTEXT_FULL = CONTEXT_FULL,

	$EXCEPTION_ACCESS_VIOLATION = STATUS_ACCESS_VIOLATION,
	$EXCEPTION_BREAKPOINT = STATUS_BREAKPOINT,
	$EXCEPTION_FLT_DENORMAL_OPERAND = STATUS_FLOAT_DENORMAL_OPERAND,
	$EXCEPTION_FLT_DIVIDE_BY_ZERO = STATUS_FLOAT_DIVIDE_BY_ZERO,
	$EXCEPTION_FLT_INEXACT_RESULT = STATUS_FLOAT_INEXACT_RESULT,
	$EXCEPTION_FLT_OVERFLOW = STATUS_FLOAT_OVERFLOW,
	$EXCEPTION_FLT_UNDERFLOW = STATUS_FLOAT_UNDERFLOW,
	$EXCEPTION_INT_DIVIDE_BY_ZERO = STATUS_INTEGER_DIVIDE_BY_ZERO,
	$EXCEPTION_INT_OVERFLOW = STATUS_INTEGER_OVERFLOW,
};

typedef EXCEPTION_RECORD $ExceptionRecord;
#ifdef _X86_
typedef FLOATING_SAVE_AREA $FloatingSaveArea;
#endif
#ifdef _AMD64_
typedef M128A $M128a;
#endif
typedef CONTEXT $Context;
