# -*- Makefile -*-
#
# Copyright 2009 Free Software Foundation, Inc.
# 
# This file is part of GNU Radio
# 
# GNU Radio is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3, or (at your option)
# any later version.
# 
# GNU Radio is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with GNU Radio; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 51 Franklin Street,
# Boston, MA 02110-1301, USA.
# 

# Makefile.swig.gen for @NAME@.i

## Default install locations for these files:
##
## Default location for the Python directory is:
##  ${prefix}/lib/python${python_version}/site-packages/[category]/@NAME@
## Default location for the Python exec directory is:
##  ${exec_prefix}/lib/python${python_version}/site-packages/[category]/@NAME@
##
## The following can be overloaded to change the install location, but
## this has to be done in the including Makefile.am -before-
## Makefile.swig is included.

@NAME@_pythondir_category ?= @NAME@
@NAME@_pylibdir_category ?= $(@NAME@_pythondir_category)
@NAME@_pythondir = $(pythondir)/$(@NAME@_pythondir_category)
@NAME@_pylibdir = $(pyexecdir)/$(@NAME@_pylibdir_category)

# The .so libraries for the guile modules get installed whereever guile
# is installed, usually /usr/lib/guile/gnuradio/
# FIXME: determince whether these should be installed with gnuradio.
@NAME@_scmlibdir = $(libdir)

# The scm files for the guile modules get installed where ever guile
# is installed, usually /usr/share/guile/site/@NAME@
# FIXME: determince whether these should be installed with gnuradio.
@NAME@_scmdir = $(guiledir)

## SWIG headers are always installed into the same directory.

@NAME@_swigincludedir = $(swigincludedir)

## This is a template file for a "generated" Makefile addition (in
## this case, "Makefile.swig.gen").  By including the top-level
## Makefile.swig, this file will be used to generate the SWIG
## dependencies.  Assign the variable TOP_SWIG_FILES to be the list of
## SWIG .i files to generated wrappings for; there can be more than 1
## so long as the names are unique (no sorting is done on the
## TOP_SWIG_FILES list). This file explicitly assumes that a SWIG .i
## file will generate .cc, .py, and possibly .h files -- meaning that
## all of these files will have the same base name (that provided for
## the SWIG .i file).
##
## This code is setup to ensure parallel MAKE ("-j" or "-jN") does the
## right thing.  For more info, see <
## http://sources.redhat.com/automake/automake.html#Multiple-Outputs >

## Other cleaned files: dependency files generated by SWIG or this Makefile

MOSTLYCLEANFILES += $(DEPDIR)/*.S*

## Various SWIG variables.  These can be overloaded in the including
## Makefile.am by setting the variable value there, then including
## Makefile.swig .

@NAME@_swiginclude_HEADERS =		\
	@NAME@.i			\
	$(@NAME@_swiginclude_headers)

if PYTHON
@NAME@_pylib_LTLIBRARIES =		\
	_@NAME@.la

_@NAME@_la_SOURCES = 			\
	python/@NAME@.cc		\
	$(@NAME@_la_swig_sources)

@NAME@_python_PYTHON =			\
	@NAME@.py			\
	$(@NAME@_python)

_@NAME@_la_LIBADD =			\
	$(STD_SWIG_LA_LIB_ADD)		\
	$(@NAME@_la_swig_libadd)

_@NAME@_la_LDFLAGS =			\
	$(STD_SWIG_LA_LD_FLAGS)		\
	$(@NAME@_la_swig_ldflags)

_@NAME@_la_CXXFLAGS =			\
	$(STD_SWIG_CXX_FLAGS)		\
	-I$(top_builddir) 		\
	$(@NAME@_la_swig_cxxflags)

python/@NAME@.cc: @NAME@.py
@NAME@.py: @NAME@.i

# Include the python dependencies for this file
-include python/@NAME@.d

endif		# end of if python

if GUILE

@NAME@_scmlib_LTLIBRARIES = 		\
	libguile-gnuradio-@NAME@.la
libguile_gnuradio_@NAME@_la_SOURCES =	\
	guile/@NAME@.cc			\
	$(@NAME@_la_swig_sources)
nobase_@NAME@_scm_DATA = 		\
	gnuradio/@NAME@.scm 		\
	gnuradio/@NAME@-primitive.scm
libguile_gnuradio_@NAME@_la_LIBADD = 	\
	$(STD_SWIG_LA_LIB_ADD)		\
	$(@NAME@_la_swig_libadd)
libguile_gnuradio_@NAME@_la_LDFLAGS = 	\
	$(STD_SWIG_LA_LD_FLAGS)		\
	$(@NAME@_la_swig_ldflags)
libguile_gnuradio_@NAME@_la_CXXFLAGS = 	\
	$(STD_SWIG_CXX_FLAGS)		\
	-I$(top_builddir) 		\
	$(@NAME@_la_swig_cxxflags)

guile/@NAME@.cc: gnuradio/@NAME@.scm
gnuradio/@NAME@.scm: @NAME@.i
gnuradio/@NAME@-primitive.scm: gnuradio/@NAME@.scm

# Include the guile dependencies for this file
-include guile/@NAME@.d

endif				# end of GUILE

