/*
     This file is part of GNUnet.
     (C) 2005 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/plugins/fs/upload.h
 * @brief code for uploading with gnunet-gtk
 * @author Christian Grothoff
 */

#ifndef GTK_UPLOAD_H
#define GTK_UPLOAD_H

#include "fs.h"

void fs_upload_update (UploadList * list, unsigned long long completed,
                       unsigned long long total);

void fs_upload_complete (UploadList * list, struct GNUNET_ECRS_URI *uri);

void fs_upload_error (UploadList * list, const char *emsg);

void fs_upload_aborted (UploadList * list);

void fs_upload_stopped (UploadList * list);

/**
 * @param uri NULL if upload is not yet finished
 */
UploadList *fs_upload_started (struct GNUNET_FSUI_UploadList *fsui,
                               UploadList * parent,
                               const char *filename,
                               const struct GNUNET_ECRS_URI *uri,
                               unsigned long long total,
                               unsigned long long completed,
                               GNUNET_FSUI_State state);

#endif
