/* Device.c generated by valac 0.11.3, the Vala compiler
 * generated from Device.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gst/gst.h>


#define DVB_TYPE_ADAPTER_TYPE (dvb_adapter_type_get_type ())

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;
typedef struct _DVBDevicePrivate DVBDevicePrivate;

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gst_message_unref0(var) ((var == NULL) ? NULL : (var = (gst_message_unref (var), NULL)))

typedef enum  {
	DVB_DEVICE_ERROR_UNKNOWN_TYPE
} DVBDeviceError;
#define DVB_DEVICE_ERROR dvb_device_error_quark ()
typedef enum  {
	DVB_ADAPTER_TYPE_UNKNOWN,
	DVB_ADAPTER_TYPE_DVB_T,
	DVB_ADAPTER_TYPE_DVB_S,
	DVB_ADAPTER_TYPE_DVB_C
} DVBAdapterType;

struct _DVBDevice {
	GObject parent_instance;
	DVBDevicePrivate * priv;
};

struct _DVBDeviceClass {
	GObjectClass parent_class;
};

struct _DVBDevicePrivate {
	guint _Adapter;
	guint _Frontend;
	DVBChannelList* _Channels;
	GFile* _RecordingsDirectory;
	gchar* adapter_name;
	DVBAdapterType adapter_type;
};


static gpointer dvb_device_parent_class = NULL;

GQuark dvb_device_error_quark (void);
GType dvb_adapter_type_get_type (void) G_GNUC_CONST;
GType dvb_device_get_type (void) G_GNUC_CONST;
GType dvb_channel_list_get_type (void) G_GNUC_CONST;
#define DVB_DEVICE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_DEVICE, DVBDevicePrivate))
enum  {
	DVB_DEVICE_DUMMY_PROPERTY,
	DVB_DEVICE_ADAPTER,
	DVB_DEVICE_FRONTEND,
	DVB_DEVICE_TYPE,
	DVB_DEVICE_NAME,
	DVB_DEVICE_CHANNELS,
	DVB_DEVICE_RECORDINGS_DIRECTORY
};
#define DVB_DEVICE_PRIME 31
DVBDevice* dvb_device_new (guint adapter, guint frontend);
DVBDevice* dvb_device_construct (GType object_type, guint adapter, guint frontend);
DVBDevice* dvb_device_new_with_type (guint adapter, guint frontend);
static gboolean dvb_device_setAdapterTypeAndName (DVBDevice* self, guint adapter, guint frontend);
DVBDevice* dvb_device_new_full (guint adapter, guint frontend, GFile* channels_conf, GFile* recordings_dir, guint group_id, GError** error);
DVBAdapterType dvb_device_get_Type (DVBDevice* self);
void dvb_device_set_RecordingsDirectory (DVBDevice* self, GFile* value);
DVBChannelList* dvb_channel_list_new (GFile* channels);
DVBChannelList* dvb_channel_list_construct (GType object_type, GFile* channels);
void dvb_device_set_Channels (DVBDevice* self, DVBChannelList* value);
gboolean dvb_device_equal (DVBDevice* dev1, DVBDevice* dev2);
guint dvb_device_get_Adapter (DVBDevice* self);
guint dvb_device_get_Frontend (DVBDevice* self);
guint dvb_device_hash (DVBDevice* device);
guint dvb_device_hash_without_device (guint adapter, guint frontend);
gboolean dvb_device_is_busy (DVBDevice* self);
static void dvb_device_set_Adapter (DVBDevice* self, guint value);
static void dvb_device_set_Frontend (DVBDevice* self, guint value);
const gchar* dvb_device_get_Name (DVBDevice* self);
DVBChannelList* dvb_device_get_Channels (DVBDevice* self);
GFile* dvb_device_get_RecordingsDirectory (DVBDevice* self);
static void dvb_device_finalize (GObject* obj);
static void _vala_dvb_device_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_device_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GQuark dvb_device_error_quark (void) {
	return g_quark_from_static_string ("dvb_device_error-quark");
}


GType dvb_adapter_type_get_type (void) {
	static volatile gsize dvb_adapter_type_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_adapter_type_type_id__volatile)) {
		static const GEnumValue values[] = {{DVB_ADAPTER_TYPE_UNKNOWN, "DVB_ADAPTER_TYPE_UNKNOWN", "unknown"}, {DVB_ADAPTER_TYPE_DVB_T, "DVB_ADAPTER_TYPE_DVB_T", "dvb-t"}, {DVB_ADAPTER_TYPE_DVB_S, "DVB_ADAPTER_TYPE_DVB_S", "dvb-s"}, {DVB_ADAPTER_TYPE_DVB_C, "DVB_ADAPTER_TYPE_DVB_C", "dvb-c"}, {0, NULL, NULL}};
		GType dvb_adapter_type_type_id;
		dvb_adapter_type_type_id = g_enum_register_static ("DVBAdapterType", values);
		g_once_init_leave (&dvb_adapter_type_type_id__volatile, dvb_adapter_type_type_id);
	}
	return dvb_adapter_type_type_id__volatile;
}


DVBDevice* dvb_device_construct (GType object_type, guint adapter, guint frontend) {
	DVBDevice * self = NULL;
	self = (DVBDevice*) g_object_new (object_type, "Adapter", adapter, "Frontend", frontend, NULL);
	return self;
}


DVBDevice* dvb_device_new (guint adapter, guint frontend) {
	return dvb_device_construct (DVB_TYPE_DEVICE, adapter, frontend);
}


DVBDevice* dvb_device_new_with_type (guint adapter, guint frontend) {
	DVBDevice* result = NULL;
	DVBDevice* _tmp0_ = NULL;
	DVBDevice* device;
	_tmp0_ = dvb_device_new (adapter, frontend);
	device = _tmp0_;
	dvb_device_setAdapterTypeAndName (device, adapter, frontend);
	result = device;
	return result;
}


DVBDevice* dvb_device_new_full (guint adapter, guint frontend, GFile* channels_conf, GFile* recordings_dir, guint group_id, GError** error) {
	DVBDevice* result = NULL;
	DVBDevice* _tmp0_ = NULL;
	DVBDevice* device;
	DVBAdapterType _tmp1_;
	DVBChannelList* _tmp3_ = NULL;
	DVBChannelList* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (channels_conf != NULL, NULL);
	g_return_val_if_fail (recordings_dir != NULL, NULL);
	_tmp0_ = dvb_device_new_with_type (adapter, frontend);
	device = _tmp0_;
	_tmp1_ = dvb_device_get_Type (device);
	if (_tmp1_ == DVB_ADAPTER_TYPE_UNKNOWN) {
		GError* _tmp2_ = NULL;
		_tmp2_ = g_error_new (DVB_DEVICE_ERROR, DVB_DEVICE_ERROR_UNKNOWN_TYPE, "device %u,%u has unknown type", adapter, frontend);
		_inner_error_ = _tmp2_;
		if (_inner_error_->domain == DVB_DEVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (device);
			return NULL;
		} else {
			_g_object_unref0 (device);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	dvb_device_set_RecordingsDirectory (device, recordings_dir);
	_tmp3_ = dvb_channel_list_new (channels_conf);
	_tmp4_ = _tmp3_;
	dvb_device_set_Channels (device, _tmp4_);
	_g_object_unref0 (_tmp4_);
	result = device;
	return result;
}


gboolean dvb_device_equal (DVBDevice* dev1, DVBDevice* dev2) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	if (dev1 == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = dev2 == NULL;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	if (dev1->priv->_Adapter == dev2->priv->_Adapter) {
		_tmp1_ = dev2->priv->_Frontend == dev2->priv->_Frontend;
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	return result;
}


guint dvb_device_hash (DVBDevice* device) {
	guint result = 0U;
	guint _tmp0_;
	if (device == NULL) {
		result = (guint) 0;
		return result;
	}
	_tmp0_ = dvb_device_hash_without_device (device->priv->_Adapter, device->priv->_Frontend);
	result = _tmp0_;
	return result;
}


guint dvb_device_hash_without_device (guint adapter, guint frontend) {
	guint result = 0U;
	result = ((2 * DVB_DEVICE_PRIME) + (DVB_DEVICE_PRIME * adapter)) + frontend;
	return result;
}


static gpointer _gst_object_ref0 (gpointer self) {
	return self ? gst_object_ref (self) : NULL;
}


gboolean dvb_device_is_busy (DVBDevice* self) {
	gboolean result = FALSE;
	GstElement* _tmp0_ = NULL;
	GstElement* dvbsrc;
	GstPipeline* _tmp1_ = NULL;
	GstElement* pipeline;
	GstElement* _tmp2_;
	GstBus* _tmp3_ = NULL;
	GstBus* bus;
	gboolean busy_val;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gst_element_factory_make ("dvbsrc", "text_dvbsrc");
	dvbsrc = _tmp0_;
	if (dvbsrc == NULL) {
		g_critical ("Device.vala:106: Could not create dvbsrc element");
		result = TRUE;
		_gst_object_unref0 (dvbsrc);
		return result;
	}
	g_object_set ((GObject*) dvbsrc, "adapter", self->priv->_Adapter, NULL);
	g_object_set ((GObject*) dvbsrc, "frontend", self->priv->_Frontend, NULL);
	_tmp1_ = (GstPipeline*) gst_pipeline_new ("");
	pipeline = (GstElement*) _tmp1_;
	_tmp2_ = _gst_object_ref0 (dvbsrc);
	gst_bin_add (GST_BIN (pipeline), _tmp2_);
	gst_element_set_state (pipeline, GST_STATE_READY);
	_tmp3_ = gst_element_get_bus (pipeline);
	bus = _tmp3_;
	busy_val = FALSE;
	while (TRUE) {
		gboolean _tmp4_;
		GstMessage* _tmp5_ = NULL;
		GstMessage* msg;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = gst_bus_have_pending (bus);
		if (!_tmp4_) {
			break;
		}
		_tmp5_ = gst_bus_pop (bus);
		msg = _tmp5_;
		if (msg->type == GST_MESSAGE_ERROR) {
			_tmp6_ = msg->src == GST_OBJECT (dvbsrc);
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			GError* gerror;
			gchar* debug_text;
			GError* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			gerror = NULL;
			debug_text = NULL;
			gst_message_parse_error (msg, &_tmp7_, &_tmp8_);
			_g_error_free0 (gerror);
			gerror = _tmp7_;
			_g_free0 (debug_text);
			debug_text = _tmp8_;
			g_debug ("Device.vala:128: Error tuning: %s; %s", gerror->message, debug_text);
			busy_val = TRUE;
			_g_free0 (debug_text);
			_g_error_free0 (gerror);
		}
		_gst_message_unref0 (msg);
	}
	gst_element_set_state (pipeline, GST_STATE_NULL);
	result = busy_val;
	_gst_object_unref0 (bus);
	_gst_object_unref0 (pipeline);
	_gst_object_unref0 (dvbsrc);
	return result;
}


static gboolean dvb_device_setAdapterTypeAndName (DVBDevice* self, guint adapter, guint frontend) {
	gboolean result = FALSE;
	GstElement* _tmp0_ = NULL;
	GstElement* dvbsrc;
	GstPipeline* _tmp1_ = NULL;
	GstElement* pipeline;
	GstElement* _tmp2_;
	GstBus* _tmp3_ = NULL;
	GstBus* bus;
	gboolean success;
	gchar* adapter_type;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gst_element_factory_make ("dvbsrc", "test_dvbsrc");
	dvbsrc = _tmp0_;
	if (dvbsrc == NULL) {
		g_critical ("Device.vala:142: Could not create dvbsrc element");
		result = FALSE;
		_gst_object_unref0 (dvbsrc);
		return result;
	}
	g_object_set ((GObject*) dvbsrc, "adapter", adapter, NULL);
	g_object_set ((GObject*) dvbsrc, "frontend", frontend, NULL);
	_tmp1_ = (GstPipeline*) gst_pipeline_new ("type_name");
	pipeline = (GstElement*) _tmp1_;
	_tmp2_ = _gst_object_ref0 (dvbsrc);
	gst_bin_add (GST_BIN (pipeline), _tmp2_);
	gst_element_set_state (pipeline, GST_STATE_READY);
	_tmp3_ = gst_element_get_bus (pipeline);
	bus = _tmp3_;
	success = FALSE;
	adapter_type = NULL;
	while (TRUE) {
		gboolean _tmp4_;
		GstMessage* _tmp5_ = NULL;
		GstMessage* msg;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = gst_bus_have_pending (bus);
		if (!_tmp4_) {
			break;
		}
		_tmp5_ = gst_bus_pop (bus);
		msg = _tmp5_;
		if (msg->type == GST_MESSAGE_ELEMENT) {
			_tmp6_ = msg->src == GST_OBJECT (dvbsrc);
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			const GstStructure* _tmp7_ = NULL;
			const GstStructure* structure;
			const gchar* _tmp8_ = NULL;
			_tmp7_ = gst_message_get_structure (msg);
			structure = _tmp7_;
			_tmp8_ = gst_structure_get_name (structure);
			if (g_strcmp0 (_tmp8_, "dvb-adapter") == 0) {
				const gchar* _tmp9_ = NULL;
				gchar* _tmp10_ = NULL;
				gchar* _tmp11_;
				const gchar* _tmp12_ = NULL;
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_;
				_tmp9_ = gst_structure_get_string (structure, "type");
				_tmp10_ = g_strdup_printf ("%s", _tmp9_);
				_tmp11_ = _tmp10_;
				_g_free0 (adapter_type);
				adapter_type = _tmp11_;
				_tmp12_ = gst_structure_get_string (structure, "name");
				_tmp13_ = g_strdup_printf ("%s", _tmp12_);
				_tmp14_ = _tmp13_;
				_g_free0 (self->priv->adapter_name);
				self->priv->adapter_name = _tmp14_;
				success = TRUE;
				_gst_message_unref0 (msg);
				break;
			}
		} else {
			if (msg->type == GST_MESSAGE_ERROR) {
				GError* gerror;
				gchar* debug;
				GError* _tmp15_ = NULL;
				gchar* _tmp16_ = NULL;
				gerror = NULL;
				debug = NULL;
				gst_message_parse_error (msg, &_tmp15_, &_tmp16_);
				_g_error_free0 (gerror);
				gerror = _tmp15_;
				_g_free0 (debug);
				debug = _tmp16_;
				g_warning ("Device.vala:173: %s %s", gerror->message, debug);
				_g_free0 (debug);
				_g_error_free0 (gerror);
			}
		}
		_gst_message_unref0 (msg);
	}
	gst_element_set_state (pipeline, GST_STATE_NULL);
	if (g_strcmp0 (adapter_type, "DVB-T") == 0) {
		self->priv->adapter_type = DVB_ADAPTER_TYPE_DVB_T;
	} else {
		if (g_strcmp0 (adapter_type, "DVB-S") == 0) {
			self->priv->adapter_type = DVB_ADAPTER_TYPE_DVB_S;
		} else {
			if (g_strcmp0 (adapter_type, "DVB-C") == 0) {
				self->priv->adapter_type = DVB_ADAPTER_TYPE_DVB_C;
			} else {
				self->priv->adapter_type = DVB_ADAPTER_TYPE_UNKNOWN;
			}
		}
	}
	result = success;
	_g_free0 (adapter_type);
	_gst_object_unref0 (bus);
	_gst_object_unref0 (pipeline);
	_gst_object_unref0 (dvbsrc);
	return result;
}


guint dvb_device_get_Adapter (DVBDevice* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_Adapter;
	return result;
}


static void dvb_device_set_Adapter (DVBDevice* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_Adapter = value;
	g_object_notify ((GObject *) self, "Adapter");
}


guint dvb_device_get_Frontend (DVBDevice* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_Frontend;
	return result;
}


static void dvb_device_set_Frontend (DVBDevice* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_Frontend = value;
	g_object_notify ((GObject *) self, "Frontend");
}


DVBAdapterType dvb_device_get_Type (DVBDevice* self) {
	DVBAdapterType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->adapter_type;
	return result;
}


const gchar* dvb_device_get_Name (DVBDevice* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->adapter_name;
	return result;
}


DVBChannelList* dvb_device_get_Channels (DVBDevice* self) {
	DVBChannelList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_Channels;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void dvb_device_set_Channels (DVBDevice* self, DVBChannelList* value) {
	DVBChannelList* _tmp0_;
	DVBChannelList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->_Channels);
	self->priv->_Channels = _tmp1_;
	g_object_notify ((GObject *) self, "Channels");
}


GFile* dvb_device_get_RecordingsDirectory (DVBDevice* self) {
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_RecordingsDirectory;
	return result;
}


void dvb_device_set_RecordingsDirectory (DVBDevice* self, GFile* value) {
	GFile* _tmp0_;
	GFile* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->_RecordingsDirectory);
	self->priv->_RecordingsDirectory = _tmp1_;
	g_object_notify ((GObject *) self, "RecordingsDirectory");
}


static void dvb_device_class_init (DVBDeviceClass * klass) {
	dvb_device_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBDevicePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_device_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_device_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_device_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_ADAPTER, g_param_spec_uint ("Adapter", "Adapter", "Adapter", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_FRONTEND, g_param_spec_uint ("Frontend", "Frontend", "Frontend", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_TYPE, g_param_spec_enum ("Type", "Type", "Type", DVB_TYPE_ADAPTER_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_NAME, g_param_spec_string ("Name", "Name", "Name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_CHANNELS, g_param_spec_object ("Channels", "Channels", "Channels", DVB_TYPE_CHANNEL_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_RECORDINGS_DIRECTORY, g_param_spec_object ("RecordingsDirectory", "RecordingsDirectory", "RecordingsDirectory", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void dvb_device_instance_init (DVBDevice * self) {
	self->priv = DVB_DEVICE_GET_PRIVATE (self);
}


static void dvb_device_finalize (GObject* obj) {
	DVBDevice * self;
	self = DVB_DEVICE (obj);
	_g_object_unref0 (self->priv->_Channels);
	_g_object_unref0 (self->priv->_RecordingsDirectory);
	_g_free0 (self->priv->adapter_name);
	G_OBJECT_CLASS (dvb_device_parent_class)->finalize (obj);
}


GType dvb_device_get_type (void) {
	static volatile gsize dvb_device_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_device_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBDeviceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_device_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBDevice), 0, (GInstanceInitFunc) dvb_device_instance_init, NULL };
		GType dvb_device_type_id;
		dvb_device_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBDevice", &g_define_type_info, 0);
		g_once_init_leave (&dvb_device_type_id__volatile, dvb_device_type_id);
	}
	return dvb_device_type_id__volatile;
}


static void _vala_dvb_device_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBDevice * self;
	self = DVB_DEVICE (object);
	switch (property_id) {
		case DVB_DEVICE_ADAPTER:
		g_value_set_uint (value, dvb_device_get_Adapter (self));
		break;
		case DVB_DEVICE_FRONTEND:
		g_value_set_uint (value, dvb_device_get_Frontend (self));
		break;
		case DVB_DEVICE_TYPE:
		g_value_set_enum (value, dvb_device_get_Type (self));
		break;
		case DVB_DEVICE_NAME:
		g_value_set_string (value, dvb_device_get_Name (self));
		break;
		case DVB_DEVICE_CHANNELS:
		g_value_set_object (value, dvb_device_get_Channels (self));
		break;
		case DVB_DEVICE_RECORDINGS_DIRECTORY:
		g_value_set_object (value, dvb_device_get_RecordingsDirectory (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_device_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBDevice * self;
	self = DVB_DEVICE (object);
	switch (property_id) {
		case DVB_DEVICE_ADAPTER:
		dvb_device_set_Adapter (self, g_value_get_uint (value));
		break;
		case DVB_DEVICE_FRONTEND:
		dvb_device_set_Frontend (self, g_value_get_uint (value));
		break;
		case DVB_DEVICE_CHANNELS:
		dvb_device_set_Channels (self, g_value_get_object (value));
		break;
		case DVB_DEVICE_RECORDINGS_DIRECTORY:
		dvb_device_set_RecordingsDirectory (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



