# Copyright (C) 2005 Michael Gebhart
# 
# This file is part of Gnome-SplashScreen-Manager.
#
# Gnome-SplashScreen-Manager is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# Gnome-SplashScreen-Manager is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with Gnome-SplashScreen-Manager; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

module GnomeSplashScreenManager
  module SplashScreens

    def self.add_splash_screens_entry(xml_filename, name, filename, description, author, license)
      
      splash_screens_file = File.new(xml_filename, "r+")

      if (splash_screens_file == nil)
        puts "Error"

        return nil
      end

      doc = REXML::Document.new splash_screens_file

      root = doc.root
      splash_screens = root

      new_splash_screen = splash_screens.add_element("splash_screen")
      
      name_element = new_splash_screen.add_element("name")
      name_element.text = name

      filename_element = new_splash_screen.add_element("filename")
      filename_element.text = filename

      description_element = new_splash_screen.add_element("description")
      description_element.text = description

      author_element = new_splash_screen.add_element("author")
      author_element.text = author

      license_element = new_splash_screen.add_element("license")
      license_element.text = license

      output = ""
      doc.write(output, 0)

      splash_screens_file.truncate(0)
      splash_screens_file.rewind
      splash_screens_file.write(output)
      splash_screens_file.close

    end


    def self.get_current_splash_screen

      client = GConf::Client.default

      return client["/apps/gnome-session/options/splash_image"]
    
    end


    def self.get_current_splash_screen_active

      client = GConf::Client.default

      return client["/apps/gnome-session/options/show_splash_screen"]
  
    end


    def self.set_current_splash_screen(filename)

      client = GConf::Client.default

      client["/apps/gnome-session/options/splash_image"] = filename

    end


    def self.set_current_splash_screen_active(active)

      client = GConf::Client.default

      client["/apps/gnome-session/options/show_splash_screen"] = active
  
    end

    def self.find_splash_screen_with_filename(xml_filename, filename) 
      
      splash_screens_file = File.new(xml_filename, "r+")

      if (splash_screens_file == nil)
        puts "Error"

        return nil
      end

      doc = REXML::Document.new splash_screens_file

      root = doc.root
      splash_screens = root

      splash_screens.elements.each("splash_screen") { |splash_screen|
         
        splash_screen_filename = ""

        splash_screen.elements.each("filename") { |attribute|
          splash_screen_filename = attribute.text
        }

        if (splash_screen_filename == filename)
          return true
        end      
      }    

      return false  

    end


    def self.delete_splash_screens_entry(xml_filename, filename)
      splash_screens_file = File.new(xml_filename, "r+")

      if (splash_screens_file == nil)
        puts "Error"

        return nil
      end

      doc = REXML::Document.new splash_screens_file

      root = doc.root
      splash_screens = root

      splash_screens.elements.each("splash_screen") { |splash_screen|

        splash_screen_filename = ""

        splash_screen.elements.each("filename") { |attribute|
          splash_screen_filename = attribute.text
        }

        if (splash_screen_filename == filename)
          splash_screens.delete splash_screen
        end      
      }

      output = ""
      doc.write(output, 0)

      splash_screens_file.truncate(0)
      splash_screens_file.rewind
      splash_screens_file.write(output)
      splash_screens_file.close
    end


  	def self.download(source, target)
  	 
      puts "Source: #{source}\nTarget: #{target}"

      File.open(target, "w") { |io| 
        open(source) { |f|
          io.puts f.read
        }
      }

    end

    def self.download_pixbuf(url) 

      if (url == "")
        puts "Invalid URL"

        return nil
      end

    	loader = Gdk::PixbufLoader.new
    	open(url) { |f|
      	loader.last_write(f.read)
    	}
    	
      pixbuf = loader.pixbuf
    end

    def self.create_thumbnail(url)
      pixbuf = download_pixbuf(url)

      pixbuf.scale(130, 90, Gdk::Pixbuf::INTERP_BILINEAR)

    end

    def self.get_splash_screens(filename) 

      splash_screens_file = File.new(filename, "r+")

      if (splash_screens_file == nil)
        puts "Error"

        return nil
      end


      doc = REXML::Document.new splash_screens_file


      splash_screens = doc.root

      splash_screens.elements.each("splash_screen") { |splash_screen|
         
        splash_screen_name = ""
        splash_screen_description = ""
        splash_screen_filename = ""
        splash_screen_author = ""
        splash_screen_license = ""

        splash_screen.elements.each("name") { |attribute|
          splash_screen_name = attribute.text
        }

        splash_screen.elements.each("filename") { |attribute|
          splash_screen_filename = attribute.text
        }

        splash_screen.elements.each("description") { |attribute|
          splash_screen_description = attribute.text
        }

        splash_screen.elements.each("author") { |attribute|
          splash_screen_author = attribute.text
        }

        splash_screen.elements.each("license") { |attribute|
          splash_screen_license = attribute.text
        }

        if (splash_screen_name == nil)
          splash_screen_name = ""
        end

        if (splash_screen_filename == nil)
          splash_screen_filename = ""
        end

        if (splash_screen_description == nil)
          splash_screen_description = ""
        end

        if (splash_screen_author == nil)
          splash_screen_author = ""
        end

        if (splash_screen_license == nil)
          splash_screen_license = ""
        end


        if (File.exists?(splash_screen_filename))
          pixbuf = create_thumbnail(splash_screen_filename)
        else
          pixbuf = nil
        end

        yield(pixbuf, splash_screen_name, splash_screen_filename, splash_screen_description, splash_screen_author, splash_screen_license)

      }


      splash_screens_file.close

    end

  end
end
