#include <string.h>

#include "gm-mcp-vmoo-client.h"
#include "gm-mcp-session.h"
#include "widgets/gm-world-view.h"
#include "widgets/gm-world-text-view.h"
#include "gm-string.h"

#define GM_MCP_VMOO_CLIENT_GET_PRIVATE(object)( \
		G_TYPE_INSTANCE_GET_PRIVATE((object), \
		GM_TYPE_MCP_VMOO_CLIENT, GmMcpVmooClientPrivate))

/*struct _GmMcpVmooClientPrivate {

};*/

typedef struct _GmMcpVmooClientView {
	GmMcpVmooClient *package;
	GmWorldTextView *view;
	
	guint width;
	guint height;
	guint margin_width;
	guint margin_height;
	
	guint timeout;
} GmMcpVmooClientView;

/* Signals

enum {
	PROTO
	NUM_SIGNALS
};

static guint gm_mcp_vmoo_client_signals[NUM_SIGNALS] = {0};*/

G_DEFINE_TYPE(GmMcpVmooClient, gm_mcp_vmoo_client, GM_TYPE_MCP_PACKAGE)

void gm_mcp_vmoo_client_handle_simple(GmMcpPackage *package, gchar *suffix,
		GList *fields);
void gm_mcp_vmoo_client_create_view(GmMcpPackage *package, GObject *parent);
void gm_mcp_vmoo_client_set_session(GmMcpPackage *package, GObject *session);

static void
gm_mcp_vmoo_client_finalize(GObject *object) {
	//GmMcpVmooClient *obj = GM_MCP_VMOO_CLIENT(object);
	
	G_OBJECT_CLASS(gm_mcp_vmoo_client_parent_class)->finalize(object);
}

static void
gm_mcp_vmoo_client_class_init(GmMcpVmooClientClass *klass) {
	GObjectClass *object_class = G_OBJECT_CLASS(klass);
	GmMcpPackageClass *pklass = GM_MCP_PACKAGE_CLASS(klass);
	
	object_class->finalize = gm_mcp_vmoo_client_finalize;

	/*gm_mcp_vmoo_client_signals[PROTO] = 
		g_signal_new("proto",
			G_OBJECT_CLASS_TYPE(object_class),
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET(GmMcpVmooClientClass, proto),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE,
			0);*/
			
	pklass->name = "dns-com-vmoo-client";
	pklass->set_session = gm_mcp_vmoo_client_set_session;
	pklass->handle_simple = gm_mcp_vmoo_client_handle_simple;
	pklass->create_view = gm_mcp_vmoo_client_create_view;
		
	//g_type_class_add_private(object_class, sizeof(GmMcpVmooClientPrivate));
}

static void
gm_mcp_vmoo_client_init(GmMcpVmooClient *obj) {
	//obj->priv = GM_MCP_VMOO_CLIENT_GET_PRIVATE(obj);
}

GmMcpVmooClient *
gm_mcp_vmoo_client_new() {
	GmMcpVmooClient *obj = GM_MCP_VMOO_CLIENT(g_object_new(GM_TYPE_MCP_VMOO_CLIENT, NULL));
	
	return obj;
}

void
gm_mcp_vmoo_client_handle_simple(GmMcpPackage *package, gchar *suffix,
		GList *fields) {
	if (strcmp(suffix, "disconnect") == 0) {
		gm_world_prepare_disconnect(GM_MCP_SESSION_WORLD(
				GM_MCP_PACKAGE_SESSION(package)));
	}
}

void
gm_mcp_vmoo_client_set_session(GmMcpPackage *package, GObject *session) {
	GmMcpPackageClass *parent_class = g_type_class_peek_parent(
			GM_MCP_VMOO_CLIENT_GET_CLASS(package));
	gchar *iversion;
	
	parent_class->set_session(package, session);
	iversion = gm_string_remove_char(g_strdup(VERSION), '.');
	
	gm_mcp_session_send_simple(GM_MCP_SESSION(session), 
			"dns-com-vmoo-client-info", "name", "GnoeMoe",
			"text-version", VERSION, "internal-version", iversion,
			"reg-id", "0", "flags", "", NULL);
	
	g_free(iversion);
}

/* GmMcpVmooClientView */
void
gm_mcp_vmoo_client_view_update_metrics(GmMcpVmooClientView *view) {
	guint width, height, cwidth, cheight;
	gchar *w, *h;
    GtkAllocation *allocation = &(GTK_WIDGET(view->view)->allocation);
       
	width = (allocation->width - view->margin_width);
	height = (allocation->height - view->margin_width);

	gm_world_text_view_get_metrics(view->view, &cwidth, &cheight);
	
	if ((width % cwidth) != 0) {
		width = (width / cwidth);	
	} else {
		width = (width / cwidth) - 1;
	}

	if ((height % cheight) != 0) {
		height = (height / cheight);
	} else {
		height = (height / cheight) - 1;
	}
  
	if (view->width != width || view->height != height) {
		w = g_strdup_printf("%d", width);
		h = g_strdup_printf("%d", height);
		
		gm_mcp_session_send_simple(GM_MCP_PACKAGE_SESSION(view->package), 
				"dns-com-vmoo-client-screensize", "cols", w, "rows", h, NULL);
		g_free(w);
		g_free(h);
		
		view->width = width;
		view->height = height;
	}
}

gboolean
gm_mcp_vmoo_client_timeout_update(GmMcpVmooClientView *view) {
	view->timeout = 0;
	
	gm_mcp_vmoo_client_view_update_metrics(view);
	return FALSE;
}

void
gm_mcp_vmoo_client_install_timeout(GmMcpVmooClientView *view) {
	if (view->timeout) {
		g_source_remove(view->timeout);
	}
	
	view->timeout = g_timeout_add(500, 
			(GSourceFunc)(gm_mcp_vmoo_client_timeout_update), view);
}

void
on_gm_mcp_vmoo_client_text_view_size_allocate(GtkWidget *widget,
		GtkAllocation *allocation, GmMcpVmooClientView *view) {
	gm_mcp_vmoo_client_install_timeout(view);
}

void
on_gm_mcp_vmoo_client_character_size_changed(GmWorldTextView *v,
		guint width, guint height, GmMcpVmooClientView *view) {
	gm_mcp_vmoo_client_install_timeout(view);
}

void
on_gm_mcp_vmoo_client_view_weak_notify(gpointer data, GObject *obj) {
	GmMcpVmooClientView *view = (GmMcpVmooClientView *)(data);
	
	g_signal_handlers_disconnect_by_func(view->view, 
			on_gm_mcp_vmoo_client_text_view_size_allocate, view);
	g_signal_handlers_disconnect_by_func(view->view, 
			on_gm_mcp_vmoo_client_character_size_changed, view);

	g_free(data);
}

void
gm_mcp_vmoo_client_create_view(GmMcpPackage *package, GObject *parent) {
	GmMcpVmooClientView *client_view;
	
	if (!GM_IS_WORLD_VIEW(parent)) {
		return;
	}
	
	client_view = g_new0(GmMcpVmooClientView, 1);
	client_view->package = GM_MCP_VMOO_CLIENT(package);
	client_view->view = gm_world_view_text_view(GM_WORLD_VIEW(parent));
	
	client_view->width = 0;
	client_view->height = 0;

	client_view->margin_width = gtk_text_view_get_left_margin(
			GTK_TEXT_VIEW(client_view->view)) +
			gtk_text_view_get_right_margin(
			GTK_TEXT_VIEW(client_view->view));

	client_view->margin_height = gtk_text_view_get_pixels_above_lines(
			GTK_TEXT_VIEW(client_view->view)) +
			gtk_text_view_get_pixels_below_lines(
			GTK_TEXT_VIEW(client_view->view));

	g_signal_connect(client_view->view, "size-allocate",
			G_CALLBACK(on_gm_mcp_vmoo_client_text_view_size_allocate),
			client_view);
	g_signal_connect(client_view->view, "character_size_changed",
			G_CALLBACK(on_gm_mcp_vmoo_client_character_size_changed),
			client_view);

	g_object_weak_ref(G_OBJECT(package), 
			on_gm_mcp_vmoo_client_view_weak_notify, client_view);
}
