-------------------------------------------------------------------------------
--									     --
--  Filename        : $Source: /cvsroot/gnade/gnade/tools/import.adb,v $
--  Description     : Import a file into the data base                       --
--  Author          : Michael Erdmann                                        --
--  Created         : 5.4.2003                                               --
--  Last Modified By: $Author: persan $				     --
--  Last Modified On: $Date: 2007/08/25 12:43:35 $			     --
--  Status          : $State: Exp $					     --
--									     --
--  Copyright (C) 2000 - 2003 Michael Erdmann                                --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
--  Functional Description                                                   --
--  ======================                                                   --
--  This is a support module which allows you to insert data elements into   --
--  the database.                                                            --
--                                                                           --
--                                                                           --
--  Restrictions                                                             --
--  ============                                                             --
--  None                                                                     --
--                                                                           --
--  References                                                               --
--  ==========                                                               --
--  None                                                                     --
--                                                                           --
-------------------------------------------------------------------------------

with Ada.Strings.Unbounded;    use Ada.Strings.Unbounded;
with System;                   use System;
with Ada.Unchecked_Conversion;

with GNU.DB.SQLCLI;            use GNU.DB.SQLCLI;

with GNU.DB.SQLCLI.Info;       use GNU.DB.SQLCLI.Info;

with GNU.DB.SQLCLI.Environment_Attribute;
use GNU.DB.SQLCLI.Environment_Attribute;

with GNU.DB.SQLCLI.Connection_Attribute;
use  GNU.DB.SQLCLI.Connection_Attribute;


package body Import is

   Version : constant String := "$Id: import.adb,v 1.6 2007/08/25 12:43:35 persan Exp $";
   pragma Unreferenced (Version);
   EnvironmentHandle : SQLHENV;
   ConnectionHandle  : SQLHDBC;
   StatementHandle   : SQLHSTMT;

   package CLI renames GNU.DB.SQLCLI;

   -------------------
   -- Buffer_Record --
   -------------------
   type Buffer_Record is record
      Data      : aliased String (1 .. 4096);
      Indicator : aliased CLI.SQLINTEGER;
   end record;

   Buffer : array (1 .. 100) of Buffer_Record;

   ----------
   -- Move --
   ----------
   procedure Move (
                   S   : in String;
                   Nbr : in Natural) is
   begin
      if S = "" then
         Buffer (Nbr).Indicator := SQL_NULL_DATA;
      else
         Buffer (Nbr).Indicator := S'Length;
         for I in S'Range loop
            Buffer (Nbr).Data (I) := S (I);
         end loop;
      end if;
   end Move;

   -------------
   -- Prepare --
   -------------
   procedure Prepare (
                      Table       : in String;
                      Field_Names : in String_Array) is
      Q   : Unbounded_String := Null_Unbounded_String;
      V   : Unbounded_String := Null_Unbounded_String;
      Len : constant Natural          := 4095;
      RC  : CLI.SQLRETURN    := SQL_SUCCESS;
      pragma Unreferenced (RC);

      function To_SQLPOINTER is
        new Ada.Unchecked_Conversion (
                                      Source => Address, Target => SQLPOINTER);

   begin
      Q := To_Unbounded_String ("insert into " & Table & " ( ");
      V := To_Unbounded_String ("values ( ");
      for I in Field_Names'Range loop
         Q := Q & Field_Names (I);
         V := V & "?";

         if I < Field_Names'Length then
            Q := Q & ",";
            V := V & ",";
         end if;
      end loop;
      Q := Q & ")";
      V := V & ")";
      Q := Q & " " & V;

      --      Put_Line(To_String( Q ) );
      --      Put_Line(To_String( V ) );

      SQLAllocHandle (SQL_HANDLE_STMT, ConnectionHandle, StatementHandle);
      SQLPrepare (StatementHandle, To_String (Q));

      for I in Field_Names'Range loop

         RC := SQLBindParameter (StatementHandle,
                                 SQL_Parameter_Number (I),
                                 SQL_PARAM_INPUT,
                                 SQL_C_CHAR,
                                 SQL_VARCHAR,
                                 SQLUINTEGER (Len),
                                 0,
                                 To_SQLPOINTER (Buffer (I).Data'Address),
                                 4095,
                                 Buffer (I).Indicator'Access);
      end loop;

   end Prepare;

   -------------
   -- Execute --
   -------------
   procedure Execute (
                      Data : in String_Array) is
   begin
      for I in Data'Range loop
         Buffer (I).Data := (others => ' ');
         Move (To_String (Data (I)), I);
      end loop;
      SQLExecute (StatementHandle);
   end Execute;

   --------------
   -- Finalize --
   --------------
   procedure Finalize is
   begin
      SQLDisconnect (ConnectionHandle);

      SQLFreeHandle (SQL_HANDLE_DBC, ConnectionHandle);
      SQLFreeHandle (SQL_HANDLE_ENV, EnvironmentHandle);
   end Finalize;

   ----------------
   -- Initialize --
   ----------------
   procedure Initialize (
                         ServerName       : in String;
                         UserName         : in String;
                         Authentification : in String) is
   begin
      SQLAllocHandle (SQL_HANDLE_ENV, SQL_NULL_HANDLE, EnvironmentHandle);

      SQLSetEnvAttr  (
        EnvironmentHandle,
        Environment_Attribute_ODBC_Version'                        --'
          (Attribute => SQL_ATTR_ODBC_VERSION,
           Value     => SQL_OV_ODBC3)
       );

      SQLAllocHandle (SQL_HANDLE_DBC, EnvironmentHandle, ConnectionHandle);

      SQLConnect (ConnectionHandle => ConnectionHandle,
                  ServerName       => ServerName,
                  UserName         => UserName,
                  Authentication   => Authentification);
   end Initialize;

end Import;
