-------------------------------------------------------------------------------
--
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/gsql/gui_editor.adb,v $
--  Description     : managing the SQL eidtor
--  Author          : Michael Erdmann
--  Created         : 8.8.2001
--  Last Modified By: $Author: merdmann $
--  Last Modified On: $Date: 2003/11/16 12:11:18 $
--  Status          : $State: Exp $
--
--  Copyright (C) 2000 Michael Erdmann
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
-------------------------------------------------------------------------------

with Ada.Strings.Unbounded;    use Ada.Strings.Unbounded;
with Ada.Text_Io;              use Ada.Text_IO;
with Ada.Exceptions;           use Ada.Exceptions;
with Ada.Strings;              use Ada.Strings;
with Ada.Strings.Fixed;        use Ada.Strings.Fixed;
with Unchecked_Deallocation;

with Glib;                     use Glib;
-- Gdk
with Gdk;
with Gdk.Drawable;             use Gdk.Drawable;
with Gdk.Bitmap;               use Gdk.Bitmap;
with Gdk.Event;                use Gdk.Event;
with Gdk.Font;                 use Gdk.Font;
with Gdk.Color;                use Gdk.Color;
with Gdk.GC;                   use Gdk.GC;
with Gdk.Pixmap;               use Gdk.Pixmap;
with Gdk.Rectangle;            use Gdk.Rectangle;
with Gdk.Types;                use Gdk.Types;
with Gdk.Window;               use Gdk.Window;
-- Gtk
with Gtk.Rc;
with Gtk;                      use Gtk;
with Gtk.Arguments;            use Gtk.Arguments;
with Gtk.Box;                  use Gtk.Box;
with Gtk.Button;               use Gtk.Button;
with Gtk.Editable;             use Gtk.Editable;
with Gtk.Enums;                use Gtk.Enums;
with Gtk.Frame;                use Gtk.Frame;
with Gtk.Handlers;             use Gtk.Handlers;
with Gtk.Label;                use Gtk.Label;
with Gtk.Notebook;             use Gtk.Notebook;

with Gtkada.Handlers;          use Gtkada.Handlers;
with Gtk.Scrolled_Window;      use Gtk.Scrolled_Window;
with Gtk.Style;                use Gtk.Style;
with Gtk.Text;                 use Gtk.Text;
with Gtk.Window;               use Gtk.Window;
with Gtk.Widget;               use Gtk.Widget;
with Gtk.GEntry;               use Gtk.GEntry;

with GUI_Logging;              use GUI_Logging;
with GUI_Common;               use GUI_Common;

with GSQL_Types;               use GSQL_Types;
with Project_File;             use Project_File;
with Files;                    use Files;
with Contents_Handler;         use Contents_Handler;
with Text_Block;               use Text_Block;

package body GUI_Editor is

   Version         : constant String := "$Id: gui_editor.adb,v 1.20 2003/11/16 12:11:18 merdmann Exp $";

   --- ************************************************************************** ---
   --  ***                       C L A S S    D A T A                         *** ---
   --- ************************************************************************** ---

   Dismiss_CMD     : constant Natural := 1;

   --- ************************************************************************** ---
   --- ***                 I N S T A N C E     D A T A                        *** ---
   --- ************************************************************************** ---

   ----------------
   -- Get_Result --
   ----------------
   procedure Get_Result(
      This        : in  Object;
      Text        : out Text_Buffer;
      Last        : out Positive ) is
      -- copy the current editor contents into the buffer handled by the
      -- contents manager/handler.
      Description : Gtk_Text  renames This.Description;
      Query       : Gtk_Text  renames This.Query;
      Title       : Gtk_Entry renames This.Title;

      Result : Text_Buffer( 1..Max_Section_Length );
      Item   : Contents_Handler.Handle := Contents( This );
   begin
      Last := Text'First;
      Text(Last) := To_Unbounded_String( Get_Text( Title ) );
      Last := Last + 1;

      Put_Text_Block(
         Text, To_Text_Buffer(Get_Chars(Gtk_Editable(Description))), Last );
      Put_Text_Block(
         Text, To_Text_Buffer( Get_Chars( Gtk_Editable(Query))), Last);
   end Get_Result;

   -----------
   -- Query --
   -----------
   procedure Query(
      This   : in Object;
      Text   : out Text_Buffer;
      Last   : out Positive ) is
      -- get only the query
      Query  : Gtk_Text  renames This.Query;
   begin
      Last := Text'First;
      Insert( Text, To_Text_Buffer(Get_Chars(Gtk_Editable(Query))), Last );
   end Query;

   ---------------
   -- Set_Input --
   ---------------
   procedure Set_Input(
      This        : in Object;
      Text        : in Text_Buffer ) is
      --
      Description : Gtk_Text  renames This.Description;
      Query       : Gtk_Text  renames This.Query;
      Title       : Gtk_Entry renames This.Title;
      Last        : Positive := Text'First;

      procedure Read_Block(
         Editor : in Gtk_Text) is
      begin
         Freeze(Editor);
         while Last in Text'Range loop
            if Is_End_Of_Block( Text(Last) ) then
               Last := Last + 1;
               exit;
            end if;

            Insert( Editor,
                 Null_Font,
                 Null_Color,
                 Null_Color,
                 To_String( Text(Last) ) & Ascii.LF,
                 Gint (To_String( Text(Last) )'Length) + 1 );
            Last := Last + 1;
         end loop;
         Thaw( Editor );
      end Read_Block;

   begin
      Set_Text( Title, To_String( Text( Last ) ) );
      Last := Last + 1;

      Read_Block( Description );
      Read_Block( Query );
   end Set_Input;


   --- ************************************************************************** ---
   --- ***              Q U E R Y    E D I T O R    DEFINITION                *** ---
   --- ************************************************************************** ---

   ----------------
   -- Add_Editor --
   ----------------
   procedure Display(
      This        : in out Object;
      Box         : in out Gtk_Box ) is
      --- display the SQL editor
      Vbox        : Gtk_Box   renames This.Vbox;
      Title       : Gtk_Entry renames This.Title;
      Description : Gtk_Text  renames This.Description;
      Query       : Gtk_Text  renames This.Query;
      Text        : Text_Buffer( 1..Max_Section_Length );
      Last        : Positive := 1;
      ---
   begin
      Gtk_New_Vbox (Vbox);

      Entry_Field( Vbox, Title, "Title" );

      GUI_Common.Add_Editor( Vbox, Description, "Description" );
      GUI_Common.Add_Editor( Vbox, Query, "Query Text" );

      Load( Contents(This).all, Text, Last );
      Set_Input( This, Text(1..Last) );

      ----------------------
      Pack_Start( Box, Vbox );
      Show_All( Box );

      Add_Command( This, "Dismiss",    Dismiss_CMD    );
   end Display;

   -------------
   -- Command --
   -------------
   procedure Command(
      This : in out Object;
      Cmd  : in Natural ) is
   begin
      case Cmd is
         when Dismiss_CMD =>
            Remove_Sheet( This );
         when others =>
            GUI_Logging.Log("Pressed cmd: " & Natural'Image( Cmd ) );
      end case;

   end Command;

end GUI_Editor;

