/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#ifndef __GTK_VALUE_EDITOR_H__
#define __GTK_VALUE_EDITOR_H__


#include <gtk/gtkhbox.h>


G_BEGIN_DECLS



#define GTK_TYPE_VALUE_EDITOR                 (gtk_value_editor_get_type ())
#define GTK_VALUE_EDITOR(obj)                 (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_TYPE_VALUE_EDITOR, GtkValueEditor))
#define GTK_VALUE_EDITOR_CLASS(klass)         (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_TYPE_VALUE_EDITOR, GtkValueEditorClass))
#define GTK_IS_VALUE_EDITOR(obj)              (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_TYPE_VALUE_EDITOR))
#define GTK_IS_VALUE_EDITOR_CLASS(klass)      (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_TYPE_VALUE_EDITOR))
#define GTK_VALUE_EDITOR_GET_CLASS(obj)       (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_TYPE_VALUE_EDITOR, GtkValueEditorClass))


typedef struct _GtkValueEditor       GtkValueEditor;
typedef struct _GtkValueEditorClass  GtkValueEditorClass;

struct _GtkValueEditor
{
  GtkHBox  hbox;

  GList   *widget_list;

  GValue   value;
  GType    value_type;
};

struct _GtkValueEditorClass
{
  GtkHBoxClass parent_class;

  void (* value_changed) (GtkValueEditor *value_editor);
};


GType      gtk_value_editor_get_type (void) G_GNUC_CONST;

GtkWidget* gtk_value_editor_new                 (GType type);
GtkWidget* gtk_value_editor_new_with_param_spec (GParamSpec *param_spec);


GType      gtk_value_editor_get_value_type  (GtkValueEditor *value_editor);

GValue*    gtk_value_editor_get_value (GtkValueEditor *value_editor);
void       gtk_value_editor_set_value (GtkValueEditor *value_editor,
				       GValue         *value);



G_END_DECLS


#endif /* __GTK_VALUE_EDITOR_H__ */
