/*
 * Copyright (C) 2000-2010  Innocent De Marchi
 * email: tangram.peces@gmail.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <QtGui>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>



#include "comuns/constants.h"
#include "conjuntpeces.h"
#include "peca.h"


/*
	Constructor per defecte
	Crea el quadrat del tangram clàssic
*/
Peca::Peca()
{
	colorsAtzarPeca();	
	setEscala(ESCALA_GENERAL);
	creaPeca(T7_QUADRAT);	
}
/* 
Construeix la Peça segons el paràmetre passat
*/
Peca::Peca(int tipusDePeca){
	colorsAtzarPeca();
	setEscala(ESCALA_GENERAL);
	creaPeca(tipusDePeca);
}

//Col·loca la Peça a l'atzar dins les dimensions passades
//pels paràmetres maxX i maxY
Peca::Peca(int tipusDePeca,double pescala){
	setEscala(pescala);
	colorsAtzarPeca();
	creaPeca(tipusDePeca);
  //Eliminat degut a què la pesa no està encara posada a l'scene
  //i llavors no pot funcionar pecaEnLimits()
	//col·locam la peça a l'atzar
     //   colocaPecaAtzar(maxX,maxY);
}

//Constructor per les Peces que formen una figura
Peca::Peca(int tipusPeca,float posicio_X,float posicio_Y,float angle,
            int psimetria,double pescala ){
   setEscala(pescala);
   creaPeca(tipusPeca);
   setPos(posicio_X,posicio_Y);
   setAngleRotacio(angle);
   if(psimetria){
       simetriaPeca();
   }
}

void Peca::colocaPecaAtzar(int maxX,int maxY){
reiniciaAnglesVertex(tipusPeca);
//Cal evitar que la Peça quedi en algun
//angle "impossible"
//setAngleRotacio(normalitzaAngle((rand() % 5+1)*angleGirPeca*PI/180));
//setAngleRotacio(normalitzaAngle((rand() % 5+1) * PI/6));
setPos(qrand() % maxX,qrand() % maxY);
     while  (!pecaEnLimits()){
        setPos(qrand() % maxX,qrand() % maxY);
    }
}

void Peca::colocaPecaAtzar(){
//Cal evitar que la Peça quedi en algun
//angle "impossible"
reiniciaAnglesVertex(tipusPeca);
setAngleRotacio(normalitzaAngle((rand() % 5+1) * PI/4));
//setPos(qrand() % (int) 200 ,qrand() %  (int) 200);
setPos(qrand() % (int) scene()->width() ,qrand() %  (int) scene()->height());
    while  (!pecaEnLimits()){
       setPos(qrand() % (int) scene()->width() ,qrand() %  (int) scene()->height());
    }
}

//Determina el rectangle que cal actualitzar quan cal
//redibuixar la Peça
QRectF Peca::boundingRect() const
{	   
    const int marge = 1;
    QRectF rect;

    rect.adjust(-escala*modulsVertex.value(modulMesGran),
		-escala*modulsVertex.value(modulMesGran),
		+escala*modulsVertex.value(modulMesGran),
		+escala*modulsVertex.value(modulMesGran));
    return rect.adjusted(-marge, -marge, +marge, +marge);

 //Aquesta opció ajusta millor el rectangle (sense fer "ballar" la peça)
 //però deixa "rastre"
/*
   double cosMesGran,sinMesGran,cosAcc,sinAcc;
   cosMesGran=0;
   sinMesGran=0;
   for(int i=0;i<=numeroVertex-1;i++){
    cosAcc=escala*modulsVertex.value(i)*cos(anglesVertex.value(i));
    sinAcc=escala*modulsVertex.value(i)*sin(anglesVertex.value(i));
    if (abs(cosAcc)>cosMesGran){cosMesGran=abs(cosAcc);}
    if (abs(sinAcc)>sinMesGran){sinMesGran=abs(sinAcc);}
        }

  rect.adjust(-cosMesGran,-sinMesGran,+cosMesGran,+sinMesGran);
  return rect.adjusted(-marge, -marge, +marge, +marge);
 */
}

/*
Peca::~Peca()
{

}
*/

void Peca::mousePressEvent(QGraphicsSceneMouseEvent *event){
 if(!pecaMostra){
  if (shape().contains(event->pos()) && !pecaMostra){
	//Controlam el botó que s'ha clicat
	//Amb el botó esquerra+ Ctrl---> simetria de la peça
	if (event->button()==Qt::LeftButton){
	    if (event->modifiers().testFlag ( Qt::ControlModifier )){
		simetriaPeca();
                //comprova si la peça està en els limits de la zona de joc
                if(!pecaEnLimits()){
                    event->ignore();
                    simetriaPeca();
                }
		movimentPeca=0;
	    }
	    //la peça es pot moure
            else {
                movimentPeca=1;
                setZValue(20);
                setFlag(QGraphicsItem::ItemIsMovable,true);
              //  setSelected(true);
               }
	    }
	//Si es clica el botó mitjancer, es fa la simetria de la peça
	else if (event->button()==Qt::MidButton){
            setSelected(true);
            simetriaPeca();
            //comprova si la peça està en els limits de la zona de joc
                if(!pecaEnLimits()){
                    event->ignore();
                    simetriaPeca();
                }
	    movimentPeca=0;
	}
	else if (event->button()==Qt::RightButton){
            setSelected(true);
	    //rotació lliure de la peça
            if (angleGirPeca==ROTACIO_EXPERT){
	      movimentPeca=2;
	    }
            else { //rotació de la peça amb angle fix
                QPointF finalGir=event->pos()-centrePeca();//centreRectanglePeca();
                float angleFinal=atan2(finalGir.y(),finalGir.x());
                int acelera=1;
                if (angleFinal<0){angleFinal=angleFinal+2*PI;}
                //Això és per fer més ràpid el gir en el casos que
                //l'angle sigui petit;
                if (event->modifiers().testFlag ( Qt::ControlModifier ) &&
                    angleGirPeca<=15){
                  acelera=2;}
                //gira en un sentit o altre segons el punt del
                //clic
                double girFet;
                if (angleFinal>PI){
                   rotaPeca(acelera*angleGirPeca*PI/180);
                   girFet=acelera*angleGirPeca*PI/180;
                   }
                else {
                    rotaPeca(-acelera*angleGirPeca*PI/180);
                    girFet=acelera*angleGirPeca*PI/180;
                      }
                //comprova si la peça està en els limits de la zona de joc
                if(!pecaEnLimits()){
                    event->ignore();
                    rotaPeca(-girFet);
                    movimentPeca=0;
                }
                movimentPeca=0;
                }
	}
 }//final if contains
//el clic és fora de la silueta de la Peça
  else {
    setSelected(false);
    setZValue(0);
    setFlag(QGraphicsItem::ItemIsMovable,false);
    movimentPeca=0;
    event->ignore();
  }
}
 else {
     setSelected(false);
     event->ignore();
     setZValue(-1);
     movimentPeca=0;
 }

}//Peca::mousePressEvent

void Peca::mouseMoveEvent ( QGraphicsSceneMouseEvent *event){
if(!pecaMostra){
  if (shape().contains(event->pos())){
      if  (movimentPeca==1){
        QPointF darreraPos=pos();
	setFlag(QGraphicsItem::ItemIsMovable,true);
	QGraphicsItem::mouseMoveEvent(event);
     //   if(!pecaEnLimits() || pecaSuperposada()){
        if(!pecaEnLimits() ){
           event->ignore();
           setPos(darreraPos);
           if (angleGirPeca==ROTACIO_EXPERT){
               movimentPeca=2;
           }
         }
      }
      else if (movimentPeca==2){
        QPointF centre=centrePeca();//centreRectanglePeca();
       // QPointF centre=centreRectanglePeca();
	QPointF iniciGir=event->lastPos()-centre;
	QPointF finalGir=event->pos()-centre;
	float angleInici=atan2(iniciGir.y(),iniciGir.x());
	float angleFinal=atan2(finalGir.y(),finalGir.x());
	if (angleInici<0){angleInici=angleInici+2*PI;}
        if (angleFinal<0){angleFinal=angleFinal+2*PI;}
        //Si la tecla crtl està pitjada, llavors
        //la rotació es fa més "lenta"
        double precisio=1.0;
        if (event->modifiers().testFlag ( Qt::ControlModifier )){
                  precisio=0.2;}
        rotaPeca(precisio*(angleFinal-angleInici));
        if(!pecaEnLimits()){
           event->ignore();
           rotaPeca(precisio*(-angleFinal+angleInici));
           movimentPeca=1;
         };
	/*
	  QPointF center = boundingRect().center();
	  translate( center.x(), center.y() ); 
	  rotate(angleGir*180/PI);
	  translate( -center.x(), -center.y() );
	*/
      }
      
   }//final if contains
}
else {
     event->ignore();
     movimentPeca=0;
 }
}//final Peca::mouseMoveEvent

void Peca::mouseReleaseEvent(QGraphicsSceneMouseEvent *event){
 //controlam si cal "aferrar" la peça
 if (event->button()==Qt::LeftButton){
   if ( !event->modifiers().testFlag ( Qt::ControlModifier )){
       QPointF distancia;
       distancia= aferraPeca();
       setPos(pos()-distancia);
   }
}
// printf("Mouse release de Peça");
 //deseleccionam la Peça
 setSelected(false);
 setFlag(QGraphicsItem::ItemIsMovable,false);
 setZValue(0);
 //Deixam que "continuï" l'event
 QGraphicsItem::mouseReleaseEvent(event);
}//final Peca::mouseReleaseEvent

/*
  Calcula el trasllat necessari per
  "aferrar" la peça a la més propera
  AIxò queda aparcat
*/
QPointF Peca::aferraPeca(){
 QVector<QPointF> aquestaPeca;
 QVector<QPointF> altraPeca;
 QPointF desplacament, despActual;
 float distancia, distanciaActual;
 puntsVertexPeca(aquestaPeca);
 desplacament=QPointF(0,0);
 for(int i=0;i<=conjuntDePeces->arrayPeces.size()-1;i++){
     if(!(this->indexEnElConjunt == conjuntDePeces->arrayPeces[i]->indexEnElConjunt) ){
        conjuntDePeces->arrayPeces[i]->puntsVertexPeca(altraPeca);
        distancia=10000;
        for(int j=0;j<=aquestaPeca.size()-1;j++){
            for(int k=0;k<=altraPeca.size()-1;k++){
                despActual=aquestaPeca[j]-altraPeca[k];
                distanciaActual=sqrt(pow(despActual.x(),2)+pow(despActual.y(),2));
                if( (distanciaActual<distancia) && (distanciaActual<=5.0) ){
                   distancia=distanciaActual;
                   desplacament=despActual;
                }
            }
        }
     }
    }
return desplacament;
}


//determina si la peça està en els límits de l'escena
bool Peca::pecaEnLimits(){
    QVector<QPointF> vertexPeca;
    puntsVertexPeca(vertexPeca);
    bool enLimits=true;
    for(int j=0;j<=vertexPeca.size()-1;j++){
        if (!scene()->sceneRect().contains(vertexPeca.value(j))){
           enLimits=false;
        }
    }
return enLimits;
}//final Peca::pecaEnLimits()

//determina si la peça està superposada amb una altra
//Peró això de collidesWithPath no fa el que s'espera!!!
//Nomes controla la col·lisió del boundingRect no del Path!!!
bool Peca::pecaSuperposada(){
    QList<QGraphicsItem *> pecesSuperposades=collidingItems(Qt::IntersectsItemShape);
    bool xoca=false;
    foreach (QGraphicsItem *item, pecesSuperposades) {
      if (!xoca  && this != item){
         // xoca=collidesWithItem(item,Qt::IntersectsItemShape);
         xoca=this->collidesWithPath(item->shape(),Qt::IntersectsItemBoundingRect);
       //  xoca=this->collidesWithPath(item->shape(),Qt::IntersectsItemShape);
          }
    }
  return xoca;
}//final Peca::pecaSuperposada()

/*
Retorna una cadena amb les dades de la peça
per tal de formar figures
*/
QString Peca::cadenaPropietatsPeca( QPointF vertexSuperiorEsquerra){
    QString dades;
    dades=QString("%1").arg(tipusPeca)+" ";
    dades=dades+QString("%1").arg((pos().x()-vertexSuperiorEsquerra.rx()))+" "+
                QString("%1").arg((pos().y()-vertexSuperiorEsquerra.ry()))+" ";
    dades=dades+QString("%1").arg((anglesVertex[0]-angleInicial))+" ";
    if (simetriaBool){dades=dades+"1 ";}
       else {dades=dades+"0 ";}
 // printf(dades.toAscii()+ " dades peça \n");
  return dades;
}

void Peca::setColorPeca(const QColor &color)
{
    colorPeca = color;
    update();
}

QColor Peca::getColorPeca() const
{
    return colorPeca;
}

void Peca::colorsAtzarPeca(){
static bool primerCop = true;
//això per generar "aleatòriament" la llavor dels nombres aleatoris
     if (primerCop) {
         primerCop = false;
         QTime rellotge(0, 0, 0);
         qsrand(rellotge.secsTo(QTime::currentTime()));
     }
	setColorPeca(QColor(qrand() % 256, qrand() % 256, qrand() % 256,255));
	setColorLimits(getColorPeca());
}

void Peca::setColorLimits(const QColor &color)
{
    colorLimits = color;
    update();
}

QColor Peca::getColorLimits() const
{
    return colorLimits;
}

/**
  * Estableix l'angle de rotació de la Peça
  * (ho fa com a valor "absolut")
  *
  * L'angleRotacio nomès es fa servir per dur
  * "el compte" del que ha rotat la Peça i poder
  * passar aquest valor a la cadena de les propietats
  */
void Peca::setAngleRotacio(double angle){
   //reiniciaAnglesVertex();
	angleRotacio=-angle;
	//cal actualitzar els angles dels vertex
	actualitzaAnglesVertex(angle);
	//Actualitzam la peça
   // update();
}

void Peca::rotaPeca(double angle){                  
   angleRotacio=angleRotacio-angle; 
   actualitzaAnglesVertex(angle);
   }

//actualitza els angles dels vèrtex quan canvia
//angleRotacio
void Peca::actualitzaAnglesVertex(double angle){
//Actualitzam els angles dels vertex
for(int i=0;i<=numeroVertex-1;i++){
   anglesVertex.replace(i,normalitzaAngle(anglesVertex.value(i)+angle));
   }
if(ambArc){
 angleCentreArc=normalitzaAngle(angleCentreArc+angle);  
 }
 update();
}

//Normalitza l'angle entre 0 i 2PI
double Peca::normalitzaAngle(double angle) {
// printf ("Angle actual (normalitzaAngle) %lf  \n",angle );
	if ( angle < 0) {
	    angle += 2 * PI;
	}  
	while (angle>2*PI)      
       angle -= 2 * PI;
       
// printf ("Angle retornat (normalitzaAngle) %lf  \n",angle );
       return angle;
    }
 
 /*
 Normalitza l'angle entre 0 i 360
 */   
double Peca::normalitzaAngleGraus(double angle){
  if ( angle < 0){
  	 angle=angle+360;
 	}
   while (angle>360) 
   	 angle=angle-360;
   return angle;
}

//Retorna l'angle de rotació actual de la peça
double Peca::getAngleRotacio () {
	return angleRotacio;
}

void Peca::setEscala(double pescala){
	escala=pescala;
}


void Peca::estableixAngleGirPeca(double angle){
    angleGirPeca=angle;
    /*
    if (tipusPeca==T9T_TRAPEZI){
        angleGirPeca=ROTACIO_EXPERT;
    }
    */
}
double Peca::emetAngleGirPeca(){
    return angleGirPeca;
}

double Peca::getEscala() const{
	return escala;
}

/*
  Retorna (en el vector del parámetre) les coordenades
  dels vèrtex de la peça
*/
void Peca::puntsVertexPeca(QVector<QPointF> &pVertex){
    pVertex.clear();
    pVertex.resize(numeroVertex);
  // QPointF puntCentre = boundingRect().center();
   for(int i=0;i<=numeroVertex-1;i++){
       pVertex.replace(i, pos()+QPointF(
           escala*modulsVertex.value(i)*cos(anglesVertex.value(i)),
           escala*modulsVertex.value(i)*sin(anglesVertex.value(i))));
   }
}

/* Punts per controlar la solució*/
void Peca::puntsSolucio(QVector<QPointF> &pSol,float reduccio){

   for(int i=0;i<=numeroVertex-1;i++){
      // pSol.append(QPointF(
       pSol.append(pos()+QPointF(
           reduccio*escala*modulsVertex.value(i)*cos(anglesVertex.value(i)),
           reduccio*escala*modulsVertex.value(i)*sin(anglesVertex.value(i))));
    //  printf(QString("Punt peca %1-%2 \n").arg(pSol.value(i).x()).arg(pSol.value(i).y()).toAscii());       
       pSol.append(pos()+QPointF(
          reduccio*reduccio*escala*modulsVertex.value(i)*cos(anglesVertex.value(i)),
          reduccio*reduccio*escala*modulsVertex.value(i)*sin(anglesVertex.value(i))));

   }

   //afegim el punt central
 //  pSol.append(boundingRect().center());

 //es pot afegir un punt de l'arc per millorar la correcció
 if (ambArc){
        float iniciArc;
        QPainterPath polygonPath;
        iniciArc=0.0;
        QRectF rectangleArc;
        rectangleArc=emetArcPeca(iniciArc);
        QPointF puntActual(escala*modulsVertex.value(numeroVertex-1)*cos(anglesVertex.value(numeroVertex-1)),
                           escala*modulsVertex.value(numeroVertex-1)*sin(anglesVertex.value(numeroVertex-1)));
        polygonPath.moveTo(boundingRect().center()+puntActual);
        for(int i=1;i<=2;i++){
          polygonPath.arcMoveTo(rectangleArc,(iniciArc-i*angleArc/5));
          //El 0.7 és empiric
          QPointF puntArc(0.2*reduccio*polygonPath.currentPosition().x(),
                          0.2*reduccio*polygonPath.currentPosition().y());
          pSol.append(pos()+puntArc);
        }
       }
//printf(QString("Peca %1 numVertex= %2 pSolucio %3 \n").arg(tipusPeca).arg(numeroVertex).arg(pSol.size()).toAscii());
}

void Peca::puntsSolucio(QVector<QPointF> &pSol,QPointF vertSupEsq,float reduccio){

   for(int i=0;i<=numeroVertex-1;i++){
       pSol.append(pos()-vertSupEsq+QPointF(
           reduccio*escala*modulsVertex.value(i)*cos(anglesVertex.value(i)),
           reduccio*escala*modulsVertex.value(i)*sin(anglesVertex.value(i))));
    //  printf(QString("Punt peca %1-%2 \n").arg(pSol.value(i).x()).arg(pSol.value(i).y()).toAscii());
   }
}
/*
void Peca::puntsSolucio(QVector<QPointF> &pSol,float reduccio){
    pSol.clear();
    if (ambArc){
       pSol.resize(2*numeroVertex+1+2);}
    else pSol.resize(2*numeroVertex+1);
    //   pSol.resize(numeroVertex+1);
 //  QPointF puntCentre = boundingRect().center();
   for(int i=0;i<=numeroVertex-1;i++){
       pSol.replace(i, scenePos()+QPointF(
           reduccio*escala*modulsVertex.value(i)*cos(anglesVertex.value(i)),
           reduccio*escala*modulsVertex.value(i)*sin(anglesVertex.value(i))));
    //  printf(QString("Punt peca %1-%2 \n").arg(pSol.value(i).x()).arg(pSol.value(i).y()).toAscii());
   }
   for(int i=numeroVertex;i<=2*numeroVertex-1;i++){
       pSol.replace(i, scenePos()+QPointF(
           reduccio*reduccio*escala*modulsVertex.value(i)*cos(anglesVertex.value(i)),
           reduccio*reduccio*escala*modulsVertex.value(i)*sin(anglesVertex.value(i))));
   }
   //afegim el punt central
   pSol.replace(2*numeroVertex,pos()+boundingRect().center());
 //es pot afegir un punt de l'arc per millorar la correcció

 if (ambArc){
        float iniciArc;
        QPainterPath polygonPath;
        iniciArc=0.0;
        QRectF rectangleArc;
        rectangleArc=emetArcPeca(iniciArc);
        QPointF puntActual(escala*modulsVertex.value(numeroVertex-1)*cos(anglesVertex.value(numeroVertex-1)),
                           escala*modulsVertex.value(numeroVertex-1)*sin(anglesVertex.value(numeroVertex-1)));
        polygonPath.moveTo(boundingRect().center()+puntActual);
        for(int i=1;i<=2;i++){
          polygonPath.arcMoveTo(rectangleArc,(iniciArc-i*angleArc/5));
          //El 0.7 és empiric
          QPointF puntArc(scenePos().x()+0.7*reduccio*polygonPath.currentPosition().x(),
                          scenePos().y()+0.7*reduccio*polygonPath.currentPosition().y());
          pSol.replace(2*numeroVertex+i,puntArc);
        }
       }

}
*/

QPainterPath Peca::shape() 
{   
    //la silueta que retorna la funció i que dibuixa la peça
    QPainterPath polygonPath;
    /*calculam el punt central de la peça, en funció del centre
    del rectangle que ocupa*/
    QPolygonF polygon;
    for(int i=0;i<=numeroVertex-1;i++){
        polygon<<boundingRect().center()+QPointF(
    	   escala*modulsVertex.value(i)*cos(anglesVertex.value(i)),
    	   escala*modulsVertex.value(i)*sin(anglesVertex.value(i)));
        }

     polygonPath.addPolygon(polygon);

     /*afegim l'arc de la peça (si en té)*/
     if (ambArc){
     	float iniciArc;
     	iniciArc=0.0;
     	QRectF rectangleArc;
        rectangleArc=emetArcPeca(iniciArc);
     	QPointF puntActual(polygonPath.currentPosition());
     	polygonPath.arcMoveTo(rectangleArc,(iniciArc-angleArc/2));
     	//polygonPath.arcMoveTo(rectangleArc,(45-iniciArc-angleArc/2));
     	QPointF punt(polygonPath.currentPosition());
        polygonPath.moveTo(puntActual);
        QPointF puntFinal(escala*modulsVertex.value(0)*cos(anglesVertex.value(0)),
                          escala*modulsVertex.value(0)*sin(anglesVertex.value(0)) );
        polygonPath.quadTo(ajustBezier*punt,boundingRect().center()+puntFinal);
	//aquest moviment és per aconseguir que es tanqui be el dibuix
        polygonPath.moveTo(puntFinal);
        }
    /*tancam el dibuix de la silueta*/
    polygonPath.closeSubpath();
/*
    QVector<QPointF> pSolucio;
    puntsSolucio(pSolucio,0.9);
    QPolygonF polygon1(pSolucio);
    polygonPath.addPolygon(polygon1);
    polygonPath.closeSubpath();
    */

    return polygonPath;
}//Final Peca::shape

/*
Fa els càlculs per dibuixar l'arc de la Peça.
Retorna el rectangle i modifica els paràmetres
*/
QRectF Peca::emetArcPeca(float &angleInici){

      /* centre de la peça*/
    //  QPointF puntCentre =boundingRect().center();
      //centre de l'arc
      QVector<float> centre;
      centre.resize(2);
      centre.replace(0,escala*centreArc*cos((angleCentreArc)));           
      centre.replace(1,escala*centreArc*sin((angleCentreArc)));

//printf ("angle centre arc %lf  sin  %lf ,  \n",angleCentreArc,sin((angleCentreArc)));

      QVector<float> iniciArc  ;
      iniciArc.resize(2);
      iniciArc.replace(0,escala*modulsVertex.value(0)*cos(anglesVertex.value(0)));
      iniciArc.replace(1,escala*modulsVertex.value(0)*sin(anglesVertex.value(0)));

      QVector<float> finalArc;
      finalArc.resize(2);
      finalArc.replace(0,escala*modulsVertex.value(numeroVertex-1)*cos(anglesVertex.value(numeroVertex-1)));
      finalArc.replace(1,escala*modulsVertex.value(numeroVertex-1)*sin(anglesVertex.value(numeroVertex-1)));

      //càlcul del radi de l'arc
      QVector<float> vec_radi;
      vec_radi.resize(2);
      vec_radi.replace(0,iniciArc.value(0) - centre.value(0));
      vec_radi.replace(1,iniciArc.value(1) - centre.value(1));

      //el radi és el mòdul del vec_radi
      float radi;
      radi=sqrt(pow(vec_radi.value(0),2)+pow(vec_radi.value(1),2));
//printf ("Radi %lf ,  \n",radi );

      QVector<float> centreInici; 
        centreInici.resize(2);    
      	centreInici.replace(0,iniciArc.value(0)-centre.value(0));
      	centreInici.replace(1,iniciArc.value(1)-centre.value(1));

      QVector<float> centreFinal; 
        centreFinal.resize(2);     
      	centreFinal.replace(0,finalArc.value(0)-centre.value(0));
      	centreFinal.replace(1,finalArc.value(1)-centre.value(1));  

      
      //angle format pel radi amb l'inici (la recta de les 3)
      float anglePelRadi=0.0;
      if(simetriaBool){
           anglePelRadi=angleRadi(centreFinal);
        }
        else{           
           anglePelRadi=angleRadi(centreInici); 
        }
      angleInici=anglePelRadi;


  QRectF rectangleArc(centre.value(0)-radi,centre.value(1)-radi,2*radi,2*radi);
  return rectangleArc;

/* 
 printf ("Punt centre %lf , %lf \n",centre.value(0) , centre.value(1) );
 printf ("Punt inici %lf , %lf \n",inicidrawLineArc.value(0) , iniciArc.value(1) );
 printf ("Punt final %lf , %lf \n",finalArc.value(0) , finalArc.value(1) );
 printf ("Vector centre-inici %lf , %lf \n",centreInici.value(0) , centreInici.value(1) );
 printf ("Vector centre-final %lf , %lf \n",centreFinal.value(0) , centreFinal.value(1) );
 printf ("Radi %lf ,  \n",radi );
 printf ("Vector angle inicial %lf  \n",anglePelRadi );
 printf ("Vector angle final %lf  \n",angleRadi(centreFinal) );
 printf ("Vector angle arc %lf ,  \n",angleArc );
// printf ("Vector angle arc (directe) %lf ,  \n",anglePelRadi-anglePelArc );
*/ 	
}//final emetArcPeca

/*
Retorna l'angle format entre l'eix OX positiu i el vector
del centre de l'arc al punt d'inici de l'arc
*/
float Peca::angleRadi(QVector<float> VectorCentreInici){
	float angle;	
	//angle=atan(VectorCentreInici.value(1)/VectorCentreInici.value(0));	
	angle=atan2(VectorCentreInici.value(1),VectorCentreInici.value(0));
  //l'angle ho tornam en graus
 return (-angle*180/PI);
}
/*
Retorna l'angle (fitxe) de l'arc de la Peça
(es carrega quan es crea la peça)
*/
float Peca::angleArcPeca(){
 float angle;
 //centre de l'arc
      QVector<float> centre;
      centre.resize(2);
      centre.replace(0,escala*centreArc*
                        cos((angleCentreArc)));           
      centre.replace(1,escala*centreArc*
                        sin((angleCentreArc)));
      QVector<float> iniciArc  ;
      iniciArc.resize(2);
      iniciArc.replace(0,escala*modulsVertex.value(0)*cos(anglesVertex.value(0)));
      iniciArc.replace(1,escala*modulsVertex.value(0)*sin(anglesVertex.value(0)));
      QVector<float> finalArc;
      finalArc.resize(2);
      finalArc.replace(0,escala*modulsVertex.value(numeroVertex-1)*cos(anglesVertex.value(numeroVertex-1)));
      finalArc.replace(1,escala*modulsVertex.value(numeroVertex-1)*sin(anglesVertex.value(numeroVertex-1)));
      QVector<float> centreInici; 
        centreInici.resize(2);    
      	centreInici.replace(0,iniciArc.value(0)-centre.value(0));
      	centreInici.replace(1,iniciArc.value(1)-centre.value(1));
      QVector<float> centreFinal; 
        centreFinal.resize(2);     
      	centreFinal.replace(0,finalArc.value(0)-centre.value(0));
      	centreFinal.replace(1,finalArc.value(1)-centre.value(1));      
  angle=angleRadi(centreInici)-angleRadi(centreFinal);
 return angle;
}

/*funció obsoleta*/
QPointF Peca::centrePeca() const{
if(numeroVertex<20){
    QPointF centre;
    double accX,accY;
    accX=0;
    accY=0;
    for(int i=0;i<=numeroVertex-1;i++){
    accX =accX+escala*modulsVertex.value(i)*cos(anglesVertex.value(i));
    accY =accY+escala*modulsVertex.value(i)*sin(anglesVertex.value(i)); 
     }
    centre.setX(accX/numeroVertex);
    centre.setY(accY/numeroVertex);
    return centre;
}
else return boundingRect().center();
}

QPointF Peca::centreRectanglePeca(){
    QPointF centre = boundingRect().center();
    return centre;
}

void Peca::paint(QPainter *painter,
                 const QStyleOptionGraphicsItem *option,
                 QWidget * /* widget */){
if (pecaVisible){
    QPen pen(colorLimits);
    pen.setWidth(1);
    if(solucio ){
      painter->setBrush(Qt::white);
      //Aquesta és l'opció amb la qual s'obtenen els arxius d'imatge més petits
      //painter->setBrush(Qt::black); //setBrush(Qt::NoBrush); //setBrush(Qt::white);
      pen.setColor(Qt::red);}
    else  {
      painter->setBrush(colorPeca);
      pen.setColor(colorLimits);
      }
    painter->setPen(pen);    
    painter->setRenderHint(QPainter::Antialiasing);

    
    //transparent si està seleccionada
   // if (isSelected()){
    if (option->state & QStyle::State_Selected) {
       painter->setOpacity(transparencia);
     }

    painter->drawPath(shape());

  //  painter->drawRect(boundingRect());
/*
 //per dibuixar el centre de la peça
 QPointF centreD;
QPointF centreF=boundingRect().center();
   centreD=centrePeca();
   painter->setBrush(Qt::red);
   painter->drawPoint(centreD);
   painter->setBrush(Qt::black);
   painter->drawPoint(centreF);
 */
/*
if (tipusPeca==TCIRI_TRIANGLE_OBTUS_ARC){
   painter->setBrush(Qt::white);
   QPen pen(Qt::red);
    pen.setWidth(10);
   painter->setPen(pen);
  // painter->drawRect(boundingRect());
   QPointF centreD;
   centreD=centrePeca();
   painter->setPen(Qt::black);

   painter->drawPoint(centreD);
   QPointF centreF=boundingRect().center();
  // painter->setPen(Qt::red);
   painter->drawPoint(centreF);
   QVector<QPointF> vertexPeca;
   puntsVertexPeca(vertexPeca);
   for(int i=0;i<=vertexPeca.size()-1;i++){
     painter->drawPoint(vertexPeca.value(i));
   }
}
*/
  }
}//Final Peca::Paint


     /**
     * Canvia el valor de la propietat simetriaBool
     */
void Peca::canviaSimetriaPeca(){
     //canviam el valor de la propietat
     simetriaBool = !simetriaBool; 
    }
    
    /**
     * Fa la simetria de la figura, canviant
     * els angles
     */ 
    void Peca::simetriaPeca(){ 
         for(int i=0;i<=numeroVertex-1;i++){
            if (anglesVertex.value(i)<=PI && anglesVertex.value(i)>=0){
                anglesVertex.replace(i,PI-(anglesVertex.value(i)));
            } 
            else {
                anglesVertex.replace(i,3*PI-(anglesVertex.value(i))); 
            }
         }
        //Rectificam tambè l'angle inicial
        if (angleInicial<=PI && angleInicial>=0){
                angleInicial=PI-(angleInicial);
            } 
            else {
                angleInicial=3*PI-(angleInicial); 
            }
        //i l'angle de l'arc en el cas de les peces
        //amb arc
        if(ambArc){
        if (angleCentreArc<=PI && angleCentreArc>=0){
                angleCentreArc=PI-(angleCentreArc);
            } 
            else {
                angleCentreArc=3*PI-(angleCentreArc); 
            }           
        }
         
       //canviam el valor de la propietat
       simetriaBool = !simetriaBool; 

    //  update();
}//final Peca::simetriaPeca

/*
Simplement, fa update()
*/
void Peca::actualitzaPeca(){
    update();
}

/*
Crea la Peça segons el parámetre.
Estableix els valors
*/
void Peca::creaPeca(int pintPeca){
        setFlags(ItemIsMovable | ItemIsSelectable);
	switch (pintPeca){
            case TCII_ARC:
                numeroVertex=2;
                break;
	    case T7_TRIANGLE_PETIT:
            case T7_TRIANGLE_MITJA:
            case T7_TRIANGLE_GRAN:
            case T5_TRIANGLE_GRAN:
            case T6_TRIANGLE_PETIT:
            case T6_TRIANGLE_GRAN:
            case T9_TRIANGLE_EQUILATER:
            case T9_TRIANGLE_RECTANGLE:
            case T10_TRIANGLE_EQUILATER_GRAN:
            case T10_TRIANGLE_EQUILATER_PETIT:
            case TH_TRIANGLE_EQUILATER_PETIT:
            case TH_TRIANGLE_EQUILATER_MINUSCUL:
            case T11_TRIANGLE_RECTANGLE_GRAN:
            case T11_TRIANGLE_OBTUS:
            case TR_TRIANGLE_MOLT_PETIT:
            case TB_TRIANGLE_GRAN:
            case TB_TRIANGLE_MITJA:
            case TB_TRIANGLE_PETIT:
            case TOU_TRIANGLE_RECTANGLE_GRAN_ARC:
            case TOU_TRIANGLE_ISOSCELES_ARC:
            case TOU_TRIANGLE_ISOSCELES:
            case TOU_TRIANGLE_ISOSCELES_PETIT:
            case TCOR_TRIANGLE_ISOSCELES_ARC:
            case TCOR_TRIANGLE_ISOSCELES_PETIT_ARC:
            case TST_TRIANGLE_RECTANGLE:
            case TST_TRIANGLE_1:
            case TST_TRIANGLE_RECTANGLE_GRAN:
            case TST_TRIANGLE_2:
            case TST_TRIANGLE_3:
            case TST_TRIANGLE_4:
            case TST_TRIANGLE_5:
            case TST_TRIANGLE_6:
            case TST_TRIANGLE_7:
            //case T4_TRIANGLE:
            case TCIRI_TRIANGLE:
            case TCIRI_TRIANGLE_ARC:
            case TCIRI_TRIANGLE_OBTUS_ARC:
            case TCIRI_TRIANGLE_OBTUS_GRAN_ARC:
            case TCII_TRIANGLE_GRAN:
            case TCII_TRIANGLE_ISOSCELES_ARC:
            case TSL_TRIANGLE_PETIT:
            case TSL_TRIANGLE_GRAN:
            case T9T_TRIANGLE_ISOSCELES_PETIT:
            case T9T_TRIANGLE_ISOSCELES_GRAN:
            case T9T_TRIANGLE_RECTANGLE_PETIT:
            case T9T_TRIANGLE_RECTANGLE_GRAN_1:
            case T9T_TRIANGLE_RECTANGLE_GRAN_2:
            case TSTII_TRIANGLE_RECT_1:
            case TSTII_TRIANGLE_4:
            case TSTII_TRIANGLE_5:
            case TSTII_TRIANGLE_7:
            case TSTII_TRIANGLE_8:
            case TSTII_TRIANGLE_9:
		numeroVertex=3;
		break;

            case T7_QUADRAT:
            case T7_TRAPEZI:
            case T5_TRAPEZI:
            case T6_QUADRAT:
            case T6_TRAPEZI:
            case TF_TRAPEZI:
            case TX_TRAPEZI_MITJA:
            case TX_TRAPEZI_GRAN:
            case TX_TRAPEZI_PETIT:
            case TS_TRAPEZI:
            case T9_ROMBE:
            case T10_ROMBE:
            case TH_ROMBE_GRAN:
            case TH_ROMBE_PETIT:
            case TH_TRAPEZI:
            case TR_TRAPEZI:
            case TOU_TRAPEZI_ARC:
            case TST_QUADRILATER_9:
            case TST_QUADRILATER_10:
            case T4_TRAPEZI_GRAN:
            case T4_TRAPEZI_PETIT:
            case T7I_TRAPEZI:
            case T7I_PARALELOGRAM:
            case T7II_TRAPEZI:
            case TSL_QUADRAT:
            case TSL_TRAPEZI:
            case T9T_TRAPEZI:
            case T4II_TRAPEZI_1:
            case T4II_TRAPEZI_2:
            case TSTII_QUADRILATER_1:
            case TSTII_QUADRILATER_2:
		numeroVertex=4;
		break;

            case TX_PENTAGON:
            case TST_PENTAGON_8:
            case T4_PECA_GRAN:
            case T7I_PENTAGON:
            case T6II_DOS_TRIANGLES:
            case T6II_TRIANGLE_TRAPEZI:
            case TSTII_PENTAGON:
                numeroVertex=5;
                break;
            case TH_HEXAGON:
            case T6II_QUADRAT_TRIANGLE:
            case TSL_HEXAGON:
                numeroVertex=6;
                break;
	//Per defecte, es crea el quadrat del tangram clàssic
	    default:
		numeroVertex=4;
		pintPeca=T7_QUADRAT;
	  }//final switch

    //assignam el tamany als vectors
    modulsVertex.resize(numeroVertex);
    anglesVertex.resize(numeroVertex);
    //establix l'angle de rotació
    angleRotacio=0.0;
  //  setAngleRotacio(0.0);
    simetriaBool=false; 
    ambArc=false;
    solucio=false;
    pecaMostra=false;
    pecaVisible=true;
    centreArc=0.0;
    angleCentreArc=0.0;
    //inicialment, serà el primer
    modulMesGran=0;
    //inicialment 1.0
    ajustBezier=1.0;
    //inicialment, la peça no es mou
    movimentPeca=0;
    //inicialment el gir és lliure
    angleGirPeca=1.0;
    //Carregam les dades
    carregaDadesPeca(pintPeca);	
}//final Peca::creaPeca;centreRectanglePeca

/*
Carrega les dades de la peça segons
el valor del paràmetre
*/
void Peca::carregaDadesPeca(int pintPeca)
{	
    tipusPeca=pintPeca;
	switch (tipusPeca){
//Tangram clàssic
            case T7_QUADRAT:
                //Carregam els mòduls
                modulsVertex.replace(0,sqrt(1.0/2.0));//vertex 0
                modulsVertex.replace(1,sqrt(1.0/2.0));
                modulsVertex.replace(2,sqrt(1.0/2.0));
                modulsVertex.replace(3,sqrt(1.0/2.0));//vertex 3
            break;
            case T7_TRIANGLE_MITJA:
                //el triangle mitja te els catets
                //que  son l'arrel quadrada de 2 del triangle petit
                modulsVertex.replace(0,sqrt(2.0)*sqrt(5.0/9.0));
                modulsVertex.replace(1,sqrt(2.0)*sqrt(2.0/9.0));
                modulsVertex.replace(2,sqrt(2.0)*sqrt(5.0/9.0));
            break; 

            case T7_TRIANGLE_PETIT:
                modulsVertex.replace(0,sqrt(5.0/9.0));
                modulsVertex.replace(1,sqrt(2.0/9.0));
                modulsVertex.replace(2,sqrt(5.0/9.0));
            break;          
            
            case T7_TRIANGLE_GRAN:
                //el triangle gran te els catets
                //que dupliquen el catet del triangle petit
                modulsVertex.replace(0,sqrt(20.0/9.0));
                modulsVertex.replace(1,sqrt(8.0/9.0));
                modulsVertex.replace(2,sqrt(20.0/9.0));
            break;       
            //Cal anar en compte amb els trapezis. Cal fer-los iguals
            //per a què la simetria funcioni correctament!!
            case T7_TRAPEZI:
                modulsVertex.replace(0,sqrt(1.0/4.0));
                modulsVertex.replace(1,sqrt(5.0/4.0));
                modulsVertex.replace(2,sqrt(1.0/4.0));
                modulsVertex.replace(3,sqrt(5.0/4.0));
                modulMesGran=1;
            break; 

//Tangram 5   
            case T5_TRIANGLE_GRAN:
                modulsVertex.replace(0,sqrt(1.0));
                modulsVertex.replace(1,sqrt(5.0/2.0));
                modulsVertex.replace(2,sqrt(5.0/2.0));
                modulMesGran=1;
            break;           
            case T5_TRAPEZI:
                modulsVertex.replace(0,sqrt(1.0/2.0));
                modulsVertex.replace(1,sqrt(5.0/2.0));
                modulsVertex.replace(2,sqrt(1.0/2.0));
                modulsVertex.replace(3,sqrt(5.0/2.0));
                modulMesGran=1;
            break; 
//Tangram de Sam Lloyd 5 peces
            case TSL_TRIANGLE_PETIT:
                modulsVertex.replace(0,sqrt(5.0/18.0));
                modulsVertex.replace(1,sqrt(17.0/18.0));
                modulsVertex.replace(2,sqrt(4.0/9.0));
                modulMesGran=1;
            break;
            case TSL_TRIANGLE_GRAN:
                modulsVertex.replace(0,sqrt(25.0/18.0));
                modulsVertex.replace(1,sqrt(85.0/18.0));
                modulsVertex.replace(2,sqrt(20.0/9.0));
                modulMesGran=1;
            break;
            case TSL_QUADRAT:// és igual que T6_QUADRAT
                modulsVertex.replace(0,1.0);
                modulsVertex.replace(1,1.0);
                modulsVertex.replace(2,1.0);
                modulsVertex.replace(3,1.0);
            break;
            case TSL_TRAPEZI:
                modulsVertex.replace(0,1.0);
                modulsVertex.replace(1,1.0);
                modulsVertex.replace(2,sqrt(2.0)/2);
                modulsVertex.replace(3,1.0);
            break;
            case TSL_HEXAGON:
                modulsVertex.replace(0,sqrt(17.0/10.0));
                modulsVertex.replace(1,sqrt(37.0/10.0));
                modulsVertex.replace(2,sqrt(5.0/2.0));
                modulsVertex.replace(3,sqrt(1.0/10.0));
                modulsVertex.replace(4,sqrt(29.0/10.0));
                modulsVertex.replace(5,sqrt(16.0/5.0));
                modulMesGran=1;
            break;

//Tangram 6            
            case T6_TRAPEZI:
                modulsVertex.replace(0,sqrt(4.0/9.0));
		modulsVertex.replace(1,sqrt(20.0/9.0));
                modulsVertex.replace(2,sqrt(4.0/9.0));
                modulsVertex.replace(3,sqrt(20.0/9.0));
                modulMesGran=1;
            break; 
            case T6_QUADRAT:
                modulsVertex.replace(0,sqrt(1.0));
                modulsVertex.replace(1,sqrt(1.0));
                modulsVertex.replace(2,sqrt(1.0));
                modulsVertex.replace(3,sqrt(1.0));
            break;
            case T6_TRIANGLE_PETIT:
                //Els dos 41 haurien d'ésser 40, però així, amb el
                //arradoniment la cosa "ajusta" millor.
                modulsVertex.replace(0,sqrt(40.0/81.0));
                modulsVertex.replace(1,sqrt(16.0/81.0));
                modulsVertex.replace(2,sqrt(40.0/81.0));
            break;  
            case T6_TRIANGLE_GRAN:
                modulsVertex.replace(0,sqrt(160.0/81.0));
                modulsVertex.replace(1,sqrt(64.0/81.0));
                modulsVertex.replace(2,sqrt(160.0/81.0));
            break; 

//Tangram 6 II
            case T6II_DOS_TRIANGLES:
                modulsVertex.replace(0,sqrt(89.0/50.0));
                modulsVertex.replace(1,sqrt(29.0/50.0));
                modulsVertex.replace(2,sqrt(29.0/50.0));
                modulsVertex.replace(3,sqrt(89.0/50.0));
                modulsVertex.replace(4,sqrt(9.0/50.0));
            break;
            case T6II_TRIANGLE_TRAPEZI:
                modulsVertex.replace(0,sqrt(89.0/50.0));
                modulsVertex.replace(1,sqrt(29.0/50.0));
                modulsVertex.replace(2,sqrt(29.0/50.0));
                modulsVertex.replace(3,sqrt(109.0/50.0));
                modulsVertex.replace(4,sqrt(9.0/50.0));
                modulMesGran=3;
            break;
            case T6II_QUADRAT_TRIANGLE:
                modulsVertex.replace(0,sqrt(89.0/50.0));
                modulsVertex.replace(1,sqrt(29.0/50.0));
                modulsVertex.replace(2,sqrt(29.0/50.0));
                modulsVertex.replace(3,sqrt(109.0/50.0));
                modulsVertex.replace(4,sqrt(89.0/50.0));
                modulsVertex.replace(5,sqrt(9.0/50.0));
                modulMesGran=3;
            break;

//Tangram 7 I
            case T7I_TRAPEZI:
                modulsVertex.replace(0,sqrt(5.0/4.0));
                modulsVertex.replace(1,sqrt(5.0/4.0));
                modulsVertex.replace(2,sqrt((5-2*sqrt(3))/4.0));
                modulsVertex.replace(3,sqrt((5-2*sqrt(3))/4.0));
            break;
            case T7I_PARALELOGRAM:
                modulsVertex.replace(0,sqrt(7.0/4.0));
                modulsVertex.replace(1,sqrt(3.0/4.0));
                modulsVertex.replace(2,sqrt(7.0/4.0));
                modulsVertex.replace(3,sqrt(3.0/4.0));
            break;
            case T7I_PENTAGON:
                modulsVertex.replace(0,sqrt(4.0/3.0));
                modulsVertex.replace(1,sqrt(4.0/3.0));
                modulsVertex.replace(2,sqrt(21.0/9.0));
                modulsVertex.replace(3,sqrt(1.0/3.0));
                modulsVertex.replace(4,sqrt(4.0/3.0));
                modulMesGran=2;
                /*
                modulsVertex.replace(0,sqrt(37.0/16.0));
                modulsVertex.replace(1,sqrt(21.0/16.0));
                modulsVertex.replace(2,sqrt(25.0/16.0));
                modulsVertex.replace(3,sqrt(1.0/16.0));
                modulsVertex.replace(4,sqrt(13/16.0));*/
            break;

//Tangram 7 II Revathi
            case T7II_TRAPEZI:
                modulsVertex.replace(0,sqrt(17.0/8.0));
                modulsVertex.replace(1,sqrt(17.0/8.0));
                modulsVertex.replace(2,sqrt(5.0/8.0));
                modulsVertex.replace(3,sqrt(5.0/8.0));
            break;

//Tangram de Fletcher            
            case TF_TRAPEZI:
                modulsVertex.replace(0,sqrt(1.0/2.0));
                modulsVertex.replace(1,sqrt(5.0/2.0));
                modulsVertex.replace(2,sqrt(1.0/2.0));
                modulsVertex.replace(3,sqrt(5.0/2.0));
                modulMesGran=1;
            break;
 
//Tangram del xinès            
            case TX_TRAPEZI_MITJA:
                modulsVertex.replace(0,sqrt(5.0/4.0));
                modulsVertex.replace(1,sqrt(5.0/4.0));
                modulsVertex.replace(2,sqrt(1.0/4.0));
                modulsVertex.replace(3,sqrt(5.0/4.0));
            break;     
            case TX_TRAPEZI_GRAN:
                modulsVertex.replace(0,sqrt(10.0/4.0));
                modulsVertex.replace(1,sqrt(10.0/4.0));
                modulsVertex.replace(2,sqrt(1.0/2.0));
                modulsVertex.replace(3,sqrt(10.0/4.0));
            break;     
            case TX_PENTAGON:
                modulsVertex.replace(0,sqrt(10.0/16.0));
                modulsVertex.replace(1,sqrt(18.0/16.0));
                modulsVertex.replace(2,sqrt(10.0/16.0));
                modulsVertex.replace(3,sqrt(26.0/16.0));
                modulsVertex.replace(4,sqrt(26.0/16.0));
                modulMesGran=3;
            break;  
            
            case TX_TRAPEZI_PETIT:
                modulsVertex.replace(0,sqrt(10.0/16.0));
                modulsVertex.replace(1,sqrt(10.0/16.0));
                modulsVertex.replace(2,sqrt(2.0/16.0));
                modulsVertex.replace(3,sqrt(10.0/16.0));
            break;  

//Tangram de la saviesa            
            case TS_TRAPEZI:
                modulsVertex.replace(0,sqrt(1.0/2.0));
                modulsVertex.replace(1,sqrt(1.0/2.0));
                modulsVertex.replace(2,sqrt(10.0/4.0));
                modulsVertex.replace(3,sqrt(10.0/4.0));
                modulMesGran=2;
            break; 
            
//Tangram 9            
           case T9_TRIANGLE_EQUILATER:
                modulsVertex.replace(0,sqrt(2.0/3.0));
                modulsVertex.replace(1,sqrt(2.0/3.0));
                modulsVertex.replace(2,sqrt(2.0/3.0));
            break;  
            case T9_TRIANGLE_RECTANGLE:
                modulsVertex.replace(0,sqrt(13.0/18.0));
                modulsVertex.replace(1,sqrt(2.0/9.0));
                modulsVertex.replace(2,sqrt(7.0/18.0));
            break; 
            case T9_ROMBE:
                modulsVertex.replace(0,sqrt(1.0/2.0));
                modulsVertex.replace(1,sqrt(3.0/2.0));
                modulsVertex.replace(2,sqrt(1.0/2.0));
                modulsVertex.replace(3,sqrt(3.0/2.0));
                modulMesGran=1;
            break;
//Tangram "los nueve tangram"
           case T9T_TRIANGLE_ISOSCELES_PETIT:
            /*
                modulsVertex.replace(0,FACTOR_T9T*sqrt(0.5));
                modulsVertex.replace(1,FACTOR_T9T*sqrt(0.5));
                modulsVertex.replace(2,FACTOR_T9T*sqrt(0.25));
                */
                modulsVertex.replace(0,sqrt(7.0/16.0));
                modulsVertex.replace(1,sqrt(7.0/16.0));
                modulsVertex.replace(2,sqrt(3.0/16.0));
            break;
           case T9T_TRIANGLE_ISOSCELES_GRAN:
                modulsVertex.replace(0,1.5*sqrt(7.0/16.0));
                modulsVertex.replace(1,1.5*sqrt(7.0/16.0));
                modulsVertex.replace(2,1.5*sqrt(3.0/16.0));
                /*
                modulsVertex.replace(0,FACTOR_T9T*sqrt(9.0/8.0));
                modulsVertex.replace(1,FACTOR_T9T*sqrt(9.0/8.0));
                modulsVertex.replace(2,FACTOR_T9T*sqrt(9.0/16.0));
                */
            break;
           case T9T_TRIANGLE_RECTANGLE_PETIT:
                modulsVertex.replace(0,(sqrt(4.0/36.0)));
                modulsVertex.replace(1,(sqrt(13.0/36.0)));
                modulsVertex.replace(2,(sqrt(7.0/36.0)));
                modulMesGran=1;
                /*
                modulsVertex.replace(0,FACTOR_T9T*(sqrt(1.0/8.0)));
                modulsVertex.replace(1,FACTOR_T9T*(sqrt(5.0/16.0)));
                modulsVertex.replace(2,FACTOR_T9T*(sqrt(5.0/16.0)));
                modulMesGran=1;
                */
            break;
           case T9T_TRIANGLE_RECTANGLE_GRAN_1:
                modulsVertex.replace(0,2.0/3.0);
                modulsVertex.replace(1,sqrt(13.0/9.0));
                modulsVertex.replace(2,sqrt(7.0/9.0));
                modulMesGran=1;
                /*
                modulsVertex.replace(0,FACTOR_T9T*sqrt(73.0/64.0));
                modulsVertex.replace(1,FACTOR_T9T*sqrt(73.0/64.0));
                modulsVertex.replace(2,FACTOR_T9T*sqrt(25.0/64.0));
                */
            break;
           case T9T_TRIANGLE_RECTANGLE_GRAN_2:
                modulsVertex.replace(0,sqrt(1.0/3.0));
                modulsVertex.replace(1,sqrt(39.0/36.0));
                modulsVertex.replace(2,sqrt(7.0/12.0));
                modulMesGran=1;
                /*
                modulsVertex.replace(0,FACTOR_T9T*sqrt(5.0/4.0));
                modulsVertex.replace(1,FACTOR_T9T*sqrt(5.0/4.0));
                modulsVertex.replace(2,FACTOR_T9T*sqrt(5.0/4.0));
                */
            break;
           case T9T_TRAPEZI://modulsVertex.replace(0,2*sqrt(19.0/64.0));
                modulsVertex.replace(0,sqrt(19.0/64.0));
                modulsVertex.replace(1,sqrt(19.0/64.0));
                modulsVertex.replace(2,sqrt(7.0/64.0));// modulsVertex.replace(2,2*sqrt(7.0/64.0));
                modulsVertex.replace(3,sqrt(7.0/64.0));
                /*
                modulsVertex.replace(0,FACTOR_T9T*sqrt(29.0/80.0));
                modulsVertex.replace(1,FACTOR_T9T*sqrt(29.0/80.0));
                modulsVertex.replace(2,FACTOR_T9T*sqrt(1.0/10.0));// modulsVertex.replace(2,2*sqrt(7.0/64.0));
                modulsVertex.replace(3,FACTOR_T9T*sqrt(13.0/80.0));
                */

            break;
//Tangram 10
            case T10_TRIANGLE_EQUILATER_GRAN:
                modulsVertex.replace(0,sqrt(4.0/3.0));
                modulsVertex.replace(1,sqrt(4.0/3.0));
                modulsVertex.replace(2,sqrt(4.0/3.0));
            break; 
            case T10_TRIANGLE_EQUILATER_PETIT:
                modulsVertex.replace(0,sqrt(1.02/3.0));
                modulsVertex.replace(1,sqrt(1.02/3.0));
                modulsVertex.replace(2,sqrt(1.02/3.0));
            break;             
            case T10_ROMBE:
                modulsVertex.replace(0,sqrt(1.0/4.0));
                modulsVertex.replace(1,sqrt(3.0/4.0));
                modulsVertex.replace(2,sqrt(1.0/4.0));
                modulsVertex.replace(3,sqrt(3.0/4.0));
                modulMesGran=1;
            break;

/* Caldrà mirar això->possible nou tangram!
            case TCIRI_TRIANGLE:
                modulsVertex.replace(0,sqrt(4.0/3.0));
                modulsVertex.replace(1,sqrt(4.0/3.0));
                modulsVertex.replace(2,sqrt(4.0/3.0));
            break;
            case TCIRI_TRIANGLE_ARC:
                modulsVertex.replace(0,sqrt(4.0/3.0));
                modulsVertex.replace(1,sqrt(4.0/3.0));
                modulsVertex.replace(2,sqrt(4.0/3.0));
                ambArc=true;
                modulMesGran=0;
                ajustBezier=1.6;
                centreArc=modulsVertex.value(1);
            break;
 */
//Tangram Circular I
            case TCIRI_TRIANGLE:
                modulsVertex.replace(0,sqrt(5.0/9.0));
                modulsVertex.replace(1,sqrt(17.0/9.0));
                modulsVertex.replace(2,sqrt(8.0/9.0));
                modulMesGran=1;
            break;
            case TCIRI_TRIANGLE_ARC:
                modulsVertex.replace(0,sqrt(4.0/9.0));
                modulsVertex.replace(1,sqrt(7.0/9.0));
                modulsVertex.replace(2,sqrt(16.0/9.0));
                ambArc=true;
                modulMesGran=2;
                ajustBezier=2.0;
                centreArc=sqrt(28.0/9.0);
            break;
            case TCIRI_TRIANGLE_OBTUS_ARC:
                modulsVertex.replace(0,sqrt((20.0-8.0*sqrt(3.0))/9.0));
                modulsVertex.replace(1,sqrt((11.0+4.0*sqrt(3.0))/9.0));
                modulsVertex.replace(2,sqrt((20.0-8*sqrt(3.0))/9.0));
                ambArc=true;
                modulMesGran=1;
                ajustBezier=0.95;
                centreArc=modulsVertex.value(1);
            break;
            case TCIRI_TRIANGLE_OBTUS_GRAN_ARC:
                modulsVertex.replace(0,sqrt(2.0));
                modulsVertex.replace(1,1.0);
                modulsVertex.replace(2,sqrt(2.05));
                ambArc=true;
                modulMesGran=0;
                ajustBezier=2.0;
                centreArc=modulsVertex.value(0);
            break;

//Tangram circular II (8 peces)
            case TCII_TRIANGLE_GRAN:
                modulsVertex.replace(0,sqrt(4.0/9.0));
                modulsVertex.replace(1,sqrt(7.0/9.0));
                modulsVertex.replace(2,sqrt(13.0/9.0));
                ambArc=true;
                modulMesGran=2;
               // ajustBezier=1.125;
                ajustBezier=1;
               // ajustBezier=1.12225;
                //Ajustat empíricament
                centreArc=1;
               // centreArc=sqrt(120.0/144.0);
                //Real
               // centreArc=sqrt(37.0/144.0);
            break;
            case TCII_TRIANGLE_ISOSCELES_ARC:
                modulsVertex.replace(0,sqrt(13.0/16.0));
                modulsVertex.replace(1,0.25);
                modulsVertex.replace(2,sqrt(13.0/16.0));
                ambArc=true;
                modulMesGran=0;
                ajustBezier=1.0;
                centreArc=0.25;
                //valor real centreArc=sqrt(25.0/16.0);
            break;
            case TCII_ARC:
            //Valors empirics
              //  modulsVertex.replace(0,sqrt(39.0/16.0));
                modulsVertex.replace(0,sqrt(38.5/16.0));
                modulsVertex.replace(1,sqrt(38.5/16.0));
                ambArc=true;
                modulMesGran=0;
                ajustBezier=1.2555;//0.957;
                centreArc=0.5;// 0.3615;//0.2595 0.1215
                //centreArc=sqrt(63.0/16.0)
            break;

            
//Tangram 11
            case T11_TRIANGLE_RECTANGLE_GRAN:
                modulsVertex.replace(0,sqrt(13.0/9.0));
                modulsVertex.replace(1,sqrt(4.0/9.0));
                modulsVertex.replace(2,sqrt(7.0/9.0));
            break;
            case T11_TRIANGLE_OBTUS:
                modulsVertex.replace(0,sqrt(1.0/9.0));
                modulsVertex.replace(1,sqrt(7.0/9.0));
                modulsVertex.replace(2,sqrt(7.0/9.0));
                modulMesGran=1;
            break;

//Tangram rus            
            case TR_TRIANGLE_MOLT_PETIT:
            //És la meitat del triangle petit del tangram
            //clàssic
                modulsVertex.replace(0,sqrt(5.0/18.0));
                modulsVertex.replace(1,sqrt(2.0/18.0));
                modulsVertex.replace(2,sqrt(5.0/18.0));
            break;
            case TR_TRAPEZI:
                modulsVertex.replace(0,sqrt(5.0/16.0));
                modulsVertex.replace(1,sqrt(5.0/16.0));
                modulsVertex.replace(2,sqrt(17.0/16.0));
                modulsVertex.replace(3,sqrt(17.0/16.0));
                modulMesGran=2;
            break;
            
//Tangram de Brugnes            
            case TB_TRIANGLE_GRAN:
                modulsVertex.replace(0,sqrt((pow(b, 2.0)+4*pow(c, 2.0))/9.0));
                modulsVertex.replace(1,sqrt((pow(b, 2.0)+pow(c, 2.0))/9.0));
                modulsVertex.replace(2,sqrt((pow(c, 2.0)+4*pow(b, 2.0))/9.0));
                modulMesGran=2;
            break;  
            case TB_TRIANGLE_MITJA:
                modulsVertex.replace(0,sqrt((pow(c, 2.0)+4*pow(d, 2.0))/9.0));
                modulsVertex.replace(1,sqrt((pow(c, 2.0)+pow(d, 2.0))/9.0));
                modulsVertex.replace(2,sqrt((pow(d, 2.0)+4*pow(c, 2.0))/9.0));
                modulMesGran=2;
            break; 
             
            case TB_TRIANGLE_PETIT:
                modulsVertex.replace(0,sqrt((pow(d, 2.0)+4*pow(e, 2.0))/9.0));
                modulsVertex.replace(1,sqrt((pow(d, 2.0)+pow(e, 2.0))/9.0));
                modulsVertex.replace(2,sqrt((pow(e, 2.0)+4*pow(d, 2.0))/9.0));
                modulMesGran=2;
            break; 
            
            case TH_ROMBE_GRAN:
                modulsVertex.replace(0,2*sqrt(1.0/4.0));
                modulsVertex.replace(1,2*sqrt(3.0/4.0));
                modulsVertex.replace(2,2*sqrt(1.0/4.0));
                modulsVertex.replace(3,2*sqrt(3.0/4.0));
                modulMesGran=1;
                //Carregam els angles
                anglesInicialsPeca(T10_ROMBE);
            break;
            case TH_ROMBE_PETIT:
                //és la meitat que el rombe gran (del peces
                //10 i del hexagrama
                modulsVertex.replace(0,sqrt(1.0/4.0));
                modulsVertex.replace(1,sqrt(3.0/4.0));
                modulsVertex.replace(2,sqrt(1.0/4.0));
                modulsVertex.replace(3,sqrt(3.0/4.0));
                modulMesGran=1;
            break;            
            case TH_TRIANGLE_EQUILATER_MINUSCUL:
                //triangle equilàter meitat que l'equilàter del
                //peces 10
                modulsVertex.replace(0,sqrt(1.02/3.0));
                modulsVertex.replace(1,sqrt(1.02/3.0));
                modulsVertex.replace(2,sqrt(1.02/3.0));
            break;           
            case TH_HEXAGON:            
                modulsVertex.replace(0,2*(1.0/2.0));
                modulsVertex.replace(1,2*(1.0/2.0));
                modulsVertex.replace(2,2*(1.0/2.0));
                modulsVertex.replace(3,2*(1.0/2.0));
                modulsVertex.replace(4,2*(1.0/2.0));
                modulsVertex.replace(5,2*(1.0/2.0));
            break;          
            case TH_TRAPEZI:             
                modulsVertex.replace(0,2*sqrt(7.0/64.0));
                modulsVertex.replace(1,2*sqrt(7.0/64.0));
                modulsVertex.replace(2,2*sqrt(19.0/64.0));
                modulsVertex.replace(3,2*sqrt(19.0/64.0));
                modulMesGran=2;
            break;
            case TH_TRIANGLE_EQUILATER_PETIT:
                modulsVertex.replace(0,sqrt(4.0/3.0));
                modulsVertex.replace(1,sqrt(4.0/3.0));
                modulsVertex.replace(2,sqrt(4.0/3.0));
            break;                     
            
//Tangram de l'ou 
            case TOU_TRIANGLE_ISOSCELES_ARC:
                ambArc=true;
                modulsVertex.replace(0,1.5*
                        sqrt(((20.0-8.0*sqrt(2.0))*pow(o,2))/36.0));//vertex 0
                modulsVertex.replace(1,1.5*
                        sqrt(((8.0+4.0*sqrt(2.0))*pow(o,2))/36.0));
                modulsVertex.replace(2,1.5*
                        sqrt(((20.0-8.0*sqrt(2.0))*pow(o,2))/36.0));		 
		modulMesGran=1;
		ajustBezier=1.2;
                centreArc=modulsVertex.value(1);
            break; 
            case TOU_TRIANGLE_RECTANGLE_GRAN_ARC:
                ambArc=true;
                modulsVertex.replace(0,1.5*sqrt((8.0+pow(o,2))/9.0));
                modulsVertex.replace(1,1.5*sqrt((2.0+pow(o,2))/9.0));
                modulsVertex.replace(2,1.5*sqrt((2.0+4.0*pow(o,2))/9.0));
                modulMesGran=0;
                ajustBezier=1.5;
                centreArc=1.5*sqrt((20.0+6.0*sqrt(2.0)*o+pow(o,2))/9.0);
            break; 
            case TOU_TRIANGLE_ISOSCELES:
                modulsVertex.replace(0,1.5*sqrt(5.0/9.0));
                modulsVertex.replace(1,1.5*sqrt(2.0/9.0));
                modulsVertex.replace(2,1.5*sqrt(5.0/9.0));
            break;            
	    case TOU_TRAPEZI_ARC:
                ambArc=true;
                modulsVertex.replace(0,1.5*sqrt((5.0/4.0)-(sqrt(2.0)/2.0)));
                modulsVertex.replace(1,1.5*sqrt((9.0/4.0)-(3*sqrt(2.0)/2.0)));
                modulsVertex.replace(2,1.5*sqrt((9.0/4.0)-(3*sqrt(2.0)/2.0)));
                modulsVertex.replace(3,1.5*sqrt((5.0/4.0)-(sqrt(2.0)/2.0)));
		modulMesGran=0;
		ajustBezier=1.6;
                centreArc=1.5*0.5;
            break; 
            case TOU_TRIANGLE_ISOSCELES_PETIT:
                //el triangle mitja te els catets
                //que  son l'arrel quadrada de 2 del triangle petit
                modulsVertex.replace(0,0.8*sqrt((2.0*sqrt(2.0)/3.0)-(2.0/3.0)));
                modulsVertex.replace(1,1.5*sqrt((-20.0*sqrt(2.0)/9.0)+10.0/3.0));
                modulsVertex.replace(2,1.5*sqrt((-20.0*sqrt(2.0)/9.0)+10.0/3.0));
                modulMesGran=1;
                break; 

//Tangram del cor
	    case TCOR_TRIANGLE_ISOSCELES_ARC:
                ambArc=true;
                //Una mica més llarg perquè ajusti be amb l'arc
                modulsVertex.replace(0,sqrt(5.2/9.0));
                modulsVertex.replace(1,sqrt(2.0/9.0));
                modulsVertex.replace(2,sqrt(5.2/9.0));
		modulMesGran=0;
		ajustBezier=1.6;
                centreArc=modulsVertex.value(1);
            break;   
            case TCOR_TRIANGLE_ISOSCELES_PETIT_ARC:
                ambArc=true;
                modulsVertex.replace(0,(1.0/o)*sqrt(((20.0-8.0*sqrt(2.0))*pow(o,2))/36.0));
                modulsVertex.replace(1,(1.0/o)*sqrt(((8.0+4.0*sqrt(2.0))*pow(o,2))/36.0));
                modulsVertex.replace(2,(1.0/o)*sqrt(((20.0-8.0*sqrt(2.0))*pow(o,2))/36.0));
		modulMesGran=1;
		ajustBezier=1.3;
                centreArc=modulsVertex.value(1);
            break;

//Tangram Stomachion o Luculus Archimedius
            case TST_TRIANGLE_RECTANGLE:
                //el 27,5 està ajustat empíricament
                modulsVertex.replace(0,escalaStomachion*sqrt(27.50/144.0));
                modulsVertex.replace(1,escalaStomachion*sqrt(13.0/144.0));
                modulsVertex.replace(2,escalaStomachion*sqrt(5.0/18.0));
                modulMesGran=2;
            break;
            case TST_TRIANGLE_1:
                modulsVertex.replace(0,escalaStomachion*sqrt(17.0/36.0));
                modulsVertex.replace(1,escalaStomachion*sqrt(5.0/9.0));
                modulsVertex.replace(2,escalaStomachion*sqrt(29.0/36.0));
                modulMesGran=2;
            break;
            case TST_TRIANGLE_RECTANGLE_GRAN:
                modulsVertex.replace(0,escalaStomachion*sqrt(1.0/2.0));
                modulsVertex.replace(1,escalaStomachion*sqrt(5.0/16.0));
                modulsVertex.replace(2,escalaStomachion*sqrt(17.0/16.0));
                modulMesGran=2;
            break;
            case TST_TRIANGLE_2:
                modulsVertex.replace(0,escalaStomachion*sqrt(17.0/36.0));
                //està una mica "ajustat"
                modulsVertex.replace(1,escalaStomachion*sqrt((29.0+1.0)/144.0));
                modulsVertex.replace(2,escalaStomachion*sqrt(149.0/144.0));
                modulMesGran=2;
            break;
            case TST_TRIANGLE_3:
                modulsVertex.replace(0,escalaStomachion*sqrt(5.0/36.0));
                //està una mica "ajustat"
                modulsVertex.replace(1,escalaStomachion*sqrt(17.0/36.0));
                modulsVertex.replace(2,escalaStomachion*sqrt(13.0/18.0));
                modulMesGran=2;
            break;
            case TST_TRIANGLE_4:
                modulsVertex.replace(0,escalaStomachion*sqrt(1.0/18.0));
                modulsVertex.replace(1,escalaStomachion*sqrt(65.0/144.0));
                modulsVertex.replace(2,escalaStomachion*sqrt(101.0/144.0));
                modulMesGran=2;
            break;
            case TST_TRIANGLE_5:
                modulsVertex.replace(0,escalaStomachion*sqrt(65.0/144.0));
                modulsVertex.replace(1,escalaStomachion*sqrt(41.0/144.0));
                modulsVertex.replace(2,escalaStomachion*sqrt(2.0/9.0));
            break;
            case TST_TRIANGLE_6:
                modulsVertex.replace(0,escalaStomachion*sqrt(5.0/9.0));
                modulsVertex.replace(1,escalaStomachion*sqrt(25.0/18.0));
                modulsVertex.replace(2,escalaStomachion*sqrt(61.0/18.0));
                modulMesGran=2;
            break;
            case TST_TRIANGLE_7:
                modulsVertex.replace(0,escalaStomachion*sqrt(1.0/2.0));
                modulsVertex.replace(1,escalaStomachion*sqrt(1.0));
                modulsVertex.replace(2,escalaStomachion*sqrt(5.0/2.0));
                modulMesGran=2;
            break;
            case TST_PENTAGON_8:
                modulsVertex.replace(0,escalaStomachion*sqrt(65.0/64.0));
                modulsVertex.replace(1,escalaStomachion*sqrt(25.0/64.0));
                modulsVertex.replace(2,escalaStomachion*sqrt(73.0/64.0));
                modulsVertex.replace(3,escalaStomachion*sqrt(73.0/64.0));
                modulsVertex.replace(4,escalaStomachion*sqrt(25.0/64.0));
                modulMesGran=2;
            break;
            case TST_QUADRILATER_9:
                modulsVertex.replace(0,escalaStomachion*sqrt(25.0/64.0));
                modulsVertex.replace(1,escalaStomachion*sqrt(65.0/64.0));
                modulsVertex.replace(2,escalaStomachion*sqrt(25.0/64.0));
                modulsVertex.replace(3,escalaStomachion*sqrt(73.0/64.0));
                modulMesGran=3;
            break;
            case TST_QUADRILATER_10:
                //quadrilàter gran
                modulsVertex.replace(0,escalaStomachion*sqrt(2.5/4.0));
                modulsVertex.replace(1,escalaStomachion*sqrt(5.0/8.0));
                modulsVertex.replace(2,escalaStomachion*sqrt(9.0/8.0));
                modulsVertex.replace(3,escalaStomachion*sqrt(9.0/8.0));
                modulMesGran=3;
            break;

 //Tangram de 4 peces
            case T4_TRAPEZI_GRAN:
                modulsVertex.replace(0,sqrt(9.0/4.0));
                modulsVertex.replace(1,sqrt(9.0/4.0));
                modulsVertex.replace(2,sqrt((13-8*sqrt(2))/4.0));
                modulsVertex.replace(3,sqrt(9.0/4.0));
            break;
        /* ës igual al T7_TRIANGLE_PETIT
            case T4_TRIANGLE:
                modulsVertex.replace(0,sqrt(27.50/144.0));
                modulsVertex.replace(1,sqrt(13.0/144.0));
                modulsVertex.replace(2,sqrt(5.0/18.0));
            break;
        */
            case T4_TRAPEZI_PETIT:
                modulsVertex.replace(0,sqrt(3.0/4.0));
                modulsVertex.replace(1,sqrt(3.0/4.0));
                modulsVertex.replace(2,sqrt((7.0-4*sqrt(2))/4.0));
                modulsVertex.replace(3,sqrt(3.0/4.0));
            break;
            case T4_PECA_GRAN:
                modulsVertex.replace(0,sqrt(9.0/4.0));
                modulsVertex.replace(1,sqrt((13-8*sqrt(2))/4.0));
                modulsVertex.replace(2,sqrt(5.0/4.0));
                modulsVertex.replace(3,sqrt((5.0-2*sqrt(2))/4.0));
                modulsVertex.replace(4,sqrt(9.0/4.0));
            break;

//Tangram de 4 peces II
            case T4II_TRAPEZI_1:
                modulsVertex.replace(0,sqrt(13.0/8.0));
                modulsVertex.replace(1,sqrt(5.0/8.0));
                modulsVertex.replace(2,sqrt(9.0/8.0));
                modulsVertex.replace(3,sqrt(13.0/8.0));
            break;
            case T4II_TRAPEZI_2:
                modulsVertex.replace(0,sqrt(9.0/4.0));
                modulsVertex.replace(1,sqrt(5.0/4.0));
                modulsVertex.replace(2,sqrt(9.0/4.0));
                modulsVertex.replace(3,sqrt(5.0/4.0));
            break;

//Tangram Stomachion II
            case TSTII_QUADRILATER_1:
                modulsVertex.replace(0,sqrt(5.0/2.0));
                modulsVertex.replace(1,sqrt(5.0/2.0));
                modulsVertex.replace(2,sqrt(2));
                modulsVertex.replace(3,sqrt(2)/2.0);
            break;
            case TSTII_QUADRILATER_2:
                modulsVertex.replace(0,sqrt(25.0/18.0));
                modulsVertex.replace(1,sqrt(13.0/18.0));
                modulsVertex.replace(2,sqrt(17.0/18.0));
                modulsVertex.replace(3,sqrt(13.0/18.0));
            break;
            case TSTII_TRIANGLE_RECT_1:
                modulsVertex.replace(0,sqrt(40.0/81.0));
                modulsVertex.replace(1,sqrt(148.0/81.0));
                modulsVertex.replace(2,sqrt(52.0/81.0));
                modulMesGran=1;
            break;
            case TSTII_TRIANGLE_4:
                modulsVertex.replace(0,sqrt(136.0/81.0));
                modulsVertex.replace(1,sqrt(208.0/81.0));
                modulsVertex.replace(2,sqrt(40.0/81.0));
                modulMesGran=1;
            break;
            case TSTII_TRIANGLE_5:
                modulsVertex.replace(0,sqrt(58.0/81.0));
                modulsVertex.replace(1,sqrt(40.0/81.0));
                modulsVertex.replace(2,sqrt(34.0/81.0));
                modulMesGran=0;
            break;
            case TSTII_PENTAGON:
                modulsVertex.replace(0,1.0);
                modulsVertex.replace(1,1.0);
                modulsVertex.replace(2,sqrt(13.0/9.0));
                modulsVertex.replace(3,1.0);
                modulsVertex.replace(4,1.0);
                modulMesGran=2;
            break;
            case TSTII_TRIANGLE_7:
                modulsVertex.replace(0,sqrt(34.0/81.0));
                modulsVertex.replace(1,sqrt(52.0/81.0));
                modulsVertex.replace(2,sqrt(10.0/81.0));
                modulMesGran=1;
            break;
            case TSTII_TRIANGLE_8:
                modulsVertex.replace(0,sqrt(106.0/81.0));
                modulsVertex.replace(1,sqrt(250.0/81.0));
                modulsVertex.replace(2,sqrt(64.0/81.0));
                modulMesGran=1;
            break;
            case TSTII_TRIANGLE_9:
                modulsVertex.replace(0,sqrt(8.0/9.0));
                modulsVertex.replace(1,sqrt(10.0/9.0));
                modulsVertex.replace(2,sqrt(26.0/9.0));
                modulMesGran=2;
            break;




            default:
                //si es dona el cas....
                //farem el quadrat
                numeroVertex=4;
                tipusPeca=T7_QUADRAT;
                simetriaBool=false;
                //carregam els vèrtex
                modulsVertex.replace(0,sqrt(0.5));
                modulsVertex.replace(1,sqrt(0.5));
                modulsVertex.replace(2,sqrt(0.5));
                modulsVertex.replace(3,sqrt(0.5));
           }//final switch	
   
//Carregam els angles
anglesInicialsPeca(tipusPeca);
}//final Peca::carregaDadesPeca;

/**
  * Resta als anglesVertex el valor actual de
  * angleRotacio amb la qual cosa, la Peça es queda
  * de la mateixa manera en que està quan es crea
  * l'objecte
  */
void Peca::reiniciaAnglesVertex(int tPeca){
	//la simetria a false
       simetriaBool=false; 
       //reiniciam els valors dels anglesVertex
       anglesInicialsPeca(tPeca);
       //reiniciam angleRotacio
       setAngleRotacio(0.0);	
}
	/**
     * Carrega els angles inicials de la Peça
     * @param tPeca
     */
void Peca::anglesInicialsPeca(int tPeca ){

switch (tPeca){
      case T7_QUADRAT:
          angleInicial=atan2(1,1);
          anglesVertex.replace(0,atan2(1,1));
          anglesVertex.replace(1,atan2(1,-1));
          anglesVertex.replace(2,atan2(-1,-1));
          anglesVertex.replace(3,atan2(-1,1));
      break;

      case T7_TRIANGLE_PETIT:
      case T6_TRIANGLE_PETIT:
      case T6_TRIANGLE_GRAN:
      case TR_TRIANGLE_MOLT_PETIT:
          angleInicial=atan(0.5);
          anglesVertex.replace(0,atan(0.5));
          anglesVertex.replace(1,atan(-1)+PI);
          anglesVertex.replace(2,atan(2)+PI);
      break;

      case T7_TRIANGLE_MITJA:
      case TOU_TRIANGLE_ISOSCELES:
           angleInicial=atan(0.5);
           anglesVertex.replace(0,atan(0.5));
           anglesVertex.replace(1,atan(-1)+PI);
           anglesVertex.replace(2,atan(2)+PI);
      break;

            case T7_TRIANGLE_GRAN:
                angleInicial=atan(0.5);
                anglesVertex.replace(0,atan(0.5));
                anglesVertex.replace(1,atan(-1)+PI);
                anglesVertex.replace(2,atan(2)+PI);
            break;

            case T7_TRAPEZI:
                angleInicial=PI/2;
                anglesVertex.replace(0,PI/2);
                anglesVertex.replace(1,atan(-0.5)+PI);
                anglesVertex.replace(2,3*PI/2);
                anglesVertex.replace(3,2*PI+atan(-0.5));
            break;

            case T5_TRIANGLE_GRAN:
                angleInicial=PI/2;
                anglesVertex.replace(0,PI/2);
                anglesVertex.replace(1,atan(-1.0/3.0));
                anglesVertex.replace(2,atan(1.0/3.0)+PI);
            break;
            case T5_TRAPEZI:
                angleInicial=PI/2;
                anglesVertex.replace(0,PI/2);
                anglesVertex.replace(1,atan(-1.0/2.0)+PI);
                anglesVertex.replace(2,3*PI/2);
                anglesVertex.replace(3,2*PI+atan(-1.0/2.0));
            break;

            case T6_TRAPEZI:
            case TF_TRAPEZI:
                angleInicial=PI/2;
                anglesVertex.replace(0,PI/2);
                anglesVertex.replace(1,atan(-1.0/2.0)+PI);
                anglesVertex.replace(2,3*PI/2);
                anglesVertex.replace(3,2*PI+atan(-1.0/2.0));
            break;

            case TX_TRAPEZI_MITJA:
                angleInicial=atan(1.0/2.0);
                anglesVertex.replace(0,atan(1.0/2.0));
                anglesVertex.replace(1,PI-atan(1.0/2.0));
                anglesVertex.replace(2,3*PI/2);
                anglesVertex.replace(3,2*PI-atan(1.0/2.0));
            break;

            case TX_TRAPEZI_GRAN:
                angleInicial=atan(1.0/3.0)-PI;
                anglesVertex.replace(0,atan(1.0/3.0)-PI);
                anglesVertex.replace(1,PI-atan(1.0/3.0)-PI);
                anglesVertex.replace(2,5*PI/4-PI);
                anglesVertex.replace(3,2*PI-atan(1.0/3.0)-PI);
            break;
            case TX_PENTAGON:
                angleInicial=atan(sqrt(1.0)/2.0);
                anglesVertex.replace(0,atan(sqrt(1.0)/2.0));
                anglesVertex.replace(1,PI/2);
                anglesVertex.replace(2,PI-atan(1.0/2.0));
                anglesVertex.replace(3,atan(3.0/2.0)+PI);
                anglesVertex.replace(4,2*PI-atan(3.0/2.0));
            break;
            case TX_TRAPEZI_PETIT:
                angleInicial=atan(1.0/2.0);
                anglesVertex.replace(0,atan(1.0/2.0));
                anglesVertex.replace(1,PI-atan(1.0/2.0));
                anglesVertex.replace(2,3*PI/2);
                anglesVertex.replace(3,2*PI-atan(1.0/2.0));
            break;

            case TS_TRAPEZI:
                angleInicial=PI/4;
                anglesVertex.replace(0,PI/4);
                anglesVertex.replace(1,PI-PI/4);
                anglesVertex.replace(2,PI+atan(1.0/3.0));
                anglesVertex.replace(3,2*PI-atan(1.0/3.0));
            break;


            case T9_TRIANGLE_EQUILATER:
            case T10_TRIANGLE_EQUILATER_GRAN:
            case T10_TRIANGLE_EQUILATER_PETIT:
            case TH_TRIANGLE_EQUILATER_PETIT:
            case TH_TRIANGLE_EQUILATER_MINUSCUL:
                angleInicial=PI/2;
                anglesVertex.replace(0,PI/2);
                anglesVertex.replace(1,PI+atan(sqrt(3.0)/3.0));
                anglesVertex.replace(2,2*PI-atan(sqrt(3.0)/3.0));
            break;

            case T9_TRIANGLE_RECTANGLE:
                angleInicial=PI/2+atan(sqrt(3.0)/6.0);
                anglesVertex.replace(0,PI/2+atan(sqrt(3.0)/6.0));
                anglesVertex.replace(1,PI+atan(sqrt(3.0)));
                anglesVertex.replace(2,2.0*PI-atan(sqrt(3.0)/2.0));
            break;
            case T9_ROMBE:
            case T10_ROMBE:
            case TH_ROMBE_GRAN:
            case TH_ROMBE_PETIT:
                angleInicial=atan(sqrt(3.0)/3.0)+PI/2;
                anglesVertex.replace(0,atan(sqrt(3.0)/3.0)+PI/2);
                anglesVertex.replace(1,PI+atan(sqrt(3.0)/3.0));
                anglesVertex.replace(2,3*PI/2+atan(sqrt(3.0)/3.0));
                anglesVertex.replace(3,atan(sqrt(3.0)/3.0));
            break;


            case T11_TRIANGLE_RECTANGLE_GRAN:
                angleInicial=PI/2+atan(sqrt(3.0)/6.0);
                anglesVertex.replace(0,PI/2+atan(sqrt(3.0)/6.0));
                anglesVertex.replace(1,PI+atan(sqrt(3.0)));
                anglesVertex.replace(2,2.0*PI-atan(sqrt(3.0)/2.0));
            break;
            case T11_TRIANGLE_OBTUS:
                angleInicial=PI/2;
                anglesVertex.replace(0,PI/2);
                anglesVertex.replace(1,PI+atan(sqrt(3.0)/9.0));
                anglesVertex.replace(2,2.0*PI-atan(sqrt(3.0)/9.0));
            break;

            case TR_TRAPEZI:
                angleInicial=atan(1.0/2.0);
                anglesVertex.replace(0,atan(1.0/2.0));
                anglesVertex.replace(1,PI/2+atan(2.0));
                anglesVertex.replace(2,PI+atan(1.0/4.0));
                anglesVertex.replace(3,2*PI-atan(1.0/4.0));
            break;


            case TB_TRIANGLE_GRAN:
                angleInicial=PI-atan(2.0*c/b);
                anglesVertex.replace(0,PI-atan(2.0*c/b));
                anglesVertex.replace(1,PI+atan(c/b));
                anglesVertex.replace(2,2.0*PI-atan(c/(2.0*b)));
            break;
            case TB_TRIANGLE_MITJA:
                angleInicial=PI-atan(2.0*d/c);
                anglesVertex.replace(0,PI-atan(2.0*d/c));
                anglesVertex.replace(1,PI+atan(d/c));
                anglesVertex.replace(2,2.0*PI-atan(d/(2.0*c)));
            break;
            case TB_TRIANGLE_PETIT:
                angleInicial=PI-atan(2.0*e/d);
                anglesVertex.replace(0,PI-atan(2.0*e/d));
                anglesVertex.replace(1,PI+atan(e/d));
                anglesVertex.replace(2,2.0*PI-atan(e/(2.0*d)));
            break;
            case TH_HEXAGON:
                angleInicial=PI/3;
                anglesVertex.replace(0,PI/3);
                anglesVertex.replace(1,2*PI/3);
                anglesVertex.replace(2,PI);
                anglesVertex.replace(3,4*PI/3);
                anglesVertex.replace(4,5*PI/3);
                anglesVertex.replace(5,0.0);
            break;
            case TH_TRAPEZI:
                angleInicial=atan(sqrt(3.0)/2.0);
                anglesVertex.replace(0,atan(sqrt(3.0)/2.0));
                anglesVertex.replace(1,PI-atan(sqrt(3.0)/2.0));
                anglesVertex.replace(2,PI+atan(sqrt(3.0)/4.0));
                anglesVertex.replace(3,2*PI-atan(sqrt(3.0)/4.0));
            break;

//Tangram de l'ou
      case TOU_TRIANGLE_ISOSCELES_ARC:
          angleInicial=PI-atan((4-sqrt(2.0))/sqrt(2.0));
          anglesVertex.replace(0,PI-atan((4-sqrt(2.0))/sqrt(2.0)));
          anglesVertex.replace(1,atan((2+sqrt(2.0))/sqrt(2.0))+PI);
          anglesVertex.replace(2,atan((-1+sqrt(2.0))/sqrt(2.0)));
          angleCentreArc=anglesVertex.value(1);
          angleArc=angleArcPeca();
      break;
      case TOU_TRIANGLE_RECTANGLE_GRAN_ARC:
          angleInicial=atan(o/(2.0*sqrt(2.0)));
          anglesVertex.replace(0,atan(o/(2.0*sqrt(2.0))));
          anglesVertex.replace(1,PI-atan(o/sqrt(2.0)));
          anglesVertex.replace(2,PI+atan((2.0*o)/sqrt(2.0)));
          angleCentreArc=PI-atan((3.0*sqrt(2.0)+o)/sqrt(2.0));
          angleArc=angleArcPeca();
          /*
          angleInicial=PI+atan(o/sqrt(2.0));
          anglesVertex.replace(0,PI+atan(o/sqrt(2.0)));
          anglesVertex.replace(1,PI-atan(2.0*o/sqrt(2.0)));
          anglesVertex.replace(2,2.0*PI+atan(o/sqrt(2.0)));
          angleCentreArc=PI-atan((3.0*sqrt(2.0)+o)/sqrt(2.0));
          */
      break;
      case TOU_TRAPEZI_ARC:
	  angleInicial=PI-atan(1.0-sqrt(2.0)/2);
	  anglesVertex.replace(0,PI-atan(1.0-sqrt(2.0)/2));
	  anglesVertex.replace(1,PI+atan(sqrt(2.0)/2.0));
	  anglesVertex.replace(2,2*PI-atan(sqrt(2.0)/2.0));
	  anglesVertex.replace(3,atan(1.0-(sqrt(2.0)/2.0)));	  
	  angleCentreArc=3*PI/2;
	  angleArc=angleArcPeca();          
        break;
        case TOU_TRIANGLE_ISOSCELES_PETIT:
                angleInicial=PI/2;
                anglesVertex.replace(0,PI/2);
                anglesVertex.replace(1,atan(1.0/3.0)+PI);
                anglesVertex.replace(2,2*PI-atan(1.0/3.0));
            break;



      case TCOR_TRIANGLE_ISOSCELES_ARC:
	  angleInicial=atan(0.5);
	  anglesVertex.replace(0,atan(0.5));
	  anglesVertex.replace(1,atan(-1)+PI);
	  anglesVertex.replace(2,atan(2)+PI);	  
	  angleCentreArc=anglesVertex.value(1);
	  angleArc=angleArcPeca(); 
      break; 		  
      case TCOR_TRIANGLE_ISOSCELES_PETIT_ARC:
	  angleInicial=PI-atan((4-sqrt(2.0))/sqrt(2.0));
	  anglesVertex.replace(0,PI-atan((4-sqrt(2.0))/sqrt(2.0)));
	  anglesVertex.replace(1,atan((2+sqrt(2.0))/sqrt(2.0))+PI);
	  anglesVertex.replace(2,atan((-1+sqrt(2.0))/sqrt(2.0)));	  
	  angleCentreArc=anglesVertex.value(1);
	  angleArc=angleArcPeca(); 
      break;

//Tangram Stomachion o Luculus Archimedius
            case TST_TRIANGLE_RECTANGLE:
                //Canviat de 4.0 a 4.35 per ajustar-ho millor
                angleInicial=PI-atan(4.35/3.0);
                anglesVertex.replace(0,PI-atan(4.35/3.0));
                anglesVertex.replace(1,PI+atan(2.0/3.0));
                anglesVertex.replace(2,2.0*PI-atan(1.0/3.0));
            break;
            case TST_TRIANGLE_1:
                angleInicial=PI-atan(4.0);
                anglesVertex.replace(0,PI-atan(4.0));
                anglesVertex.replace(1,PI+atan(1.0/2.0));
                anglesVertex.replace(2,2.0*PI-atan(2.0/5.0));
            break;
            case TST_TRIANGLE_RECTANGLE_GRAN:
                angleInicial=PI-atan(1.0);
                anglesVertex.replace(0,PI-atan(1.0));
                anglesVertex.replace(1,PI+atan(1.0/2.0));
                anglesVertex.replace(2,2.0*PI-atan(1.0/4.0));
            break;
            case TST_TRIANGLE_2:
                angleInicial=PI-atan(4.0);
                anglesVertex.replace(0,PI-atan(4.0));
                anglesVertex.replace(1,PI-atan(2.0/5.0));
                anglesVertex.replace(2,2.0*PI-atan(10.0/7.0));
            break;
            case TST_TRIANGLE_3:
                angleInicial=PI-atan(2.0);
                anglesVertex.replace(0,PI-atan(2.0));
                anglesVertex.replace(1,PI+atan(1.0/4.0));
                anglesVertex.replace(2,2.0*PI-atan(1.0/5.0));
            break;
            case TST_TRIANGLE_4:
                angleInicial=PI-atan(1.0);
                anglesVertex.replace(0,PI-atan(1.0));
                anglesVertex.replace(1,PI+atan(1.0/8.0));
                anglesVertex.replace(2,2.0*PI-atan(1.0/10.0));
            break;
            case TST_TRIANGLE_5:
                angleInicial=atan(8.0);
                anglesVertex.replace(0,atan(8.0));
                anglesVertex.replace(1,PI+atan(4.0/5.0));
                anglesVertex.replace(2,2.0*PI-atan(1.0));
            break;
            case TST_TRIANGLE_6:
                angleInicial=PI-atan(1.0/2.0);
                anglesVertex.replace(0,PI-atan(1.0/2.0));
                anglesVertex.replace(1,PI+atan(1.0/7.0));
                anglesVertex.replace(2,2.0*PI-atan(1.0/11.0));
            break;
            case TST_TRIANGLE_7:
                angleInicial=PI-atan(1.0);
                anglesVertex.replace(0,PI-atan(1.0));
                anglesVertex.replace(1,PI);
                anglesVertex.replace(2,2.0*PI-atan(1.0/3.0));
            break;
            case TST_PENTAGON_8:
                angleInicial=PI-atan(8.0);
                anglesVertex.replace(0,PI-atan(8.0));
                anglesVertex.replace(1,PI-atan(4.0/3.0));
                anglesVertex.replace(2,PI+atan(8.0/3.0));
                anglesVertex.replace(3,2.0*PI-atan(8.0/3.0));
                anglesVertex.replace(4,atan(4.0/3.0));
            break;
            case TST_QUADRILATER_9:
                angleInicial=PI-atan(3.0/4.0);
                anglesVertex.replace(0,PI-atan(3.0/4.0));
                anglesVertex.replace(1,PI-atan(1.0/8.0));
                anglesVertex.replace(2,PI+atan(3.0/4.0));
                anglesVertex.replace(3,2*PI-atan(3.0/8.0));
            break;
            case TST_QUADRILATER_10:
                angleInicial=PI/2;
                anglesVertex.replace(0,PI/2);
                anglesVertex.replace(1,PI-atan(1.0/3.0));
                anglesVertex.replace(2,PI+atan(1.0));
                anglesVertex.replace(3,2*PI-atan(1.0));
            break;
//Tangram de 4 peces
            case T4_TRAPEZI_GRAN:
                angleInicial=PI-atan(2*sqrt(2));
                anglesVertex.replace(0,PI-atan(2*sqrt(2)));
                anglesVertex.replace(1,atan(2*sqrt(2)));
                anglesVertex.replace(2,2*PI+atan(2-2*sqrt(2)));
                anglesVertex.replace(3,PI+atan(2*sqrt(2)));
            break;
            /* és igual al T7_TRIANGLE_PETIT
            case T4_TRIANGLE:
                angleInicial=PI/2;
                anglesVertex.replace(0,PI/2);
                anglesVertex.replace(1,PI-atan(1.0/3.0));
                anglesVertex.replace(2,PI+atan(1.0));
            break;
            */
            case T4_TRAPEZI_PETIT:
                angleInicial=PI-atan(sqrt(2));
                anglesVertex.replace(0,PI-atan(sqrt(2)));
                anglesVertex.replace(1,atan(sqrt(2)));
                anglesVertex.replace(2,-atan(sqrt(2)-2));
                anglesVertex.replace(3,PI+atan(sqrt(2)));
            break;
            case T4_PECA_GRAN:
                angleInicial=PI-atan(2*sqrt(2));
                anglesVertex.replace(0,PI-atan(2*sqrt(2)));
                anglesVertex.replace(1,2*PI+atan(2*sqrt(2)-2));
                anglesVertex.replace(2,2*PI-atan(2.0));
                anglesVertex.replace(3,2*PI-atan(sqrt(2)/(sqrt(2)-1)));
                anglesVertex.replace(4,PI+atan(2*sqrt(2)));
            break;

//Tangram de 4 peces II
            case T4II_TRAPEZI_1:
                angleInicial=PI-atan(2.0/3.0);
                anglesVertex.replace(0,PI-atan(2.0/3.0));
                anglesVertex.replace(1,atan(2.0));
                anglesVertex.replace(2,0.0);
                anglesVertex.replace(3,PI+atan(2.0/3.0));
            break;
            case T4II_TRAPEZI_2:
                angleInicial=3*PI/4;
                anglesVertex.replace(0,3*PI/4);
                anglesVertex.replace(1,atan(3.0));
                anglesVertex.replace(2,7*PI/4);
                anglesVertex.replace(3,PI+atan(1.0/3.0));
            break;

/* Caldrà mirar això->possible nou tangram!
          case TCIRI_TRIANGLE_ARC:
              angleInicial=PI-atan((4-sqrt(2.0))/sqrt(2.0));
              anglesVertex.replace(0,PI-atan((4-sqrt(2.0))/sqrt(2.0)));
              anglesVertex.replace(1,atan((2+sqrt(2.0))/sqrt(2.0))+PI);
              anglesVertex.replace(2,atan((-1+sqrt(2.0))/sqrt(2.0)));
              angleCentreArc=anglesVertex.value(1);
              angleArc=angleArcPeca();
          break;
*/

 //Tangram circular I
          case TCIRI_TRIANGLE:
              angleInicial=PI-atan(0.5);
              anglesVertex.replace(0,PI-atan(0.5));
              anglesVertex.replace(1,atan(0.25));
              anglesVertex.replace(2,PI+atan(1.0));
          break;
          case TCIRI_TRIANGLE_ARC:
              angleInicial=PI-atan(1.0/sqrt(3.0));
              anglesVertex.replace(0,PI-atan(1.0/sqrt(3.0)));
              anglesVertex.replace(1,PI+atan(2.0/sqrt(3.0)));
              anglesVertex.replace(2,2*PI-atan(1.0/sqrt(3.0)));
              angleCentreArc=PI+atan(5.0/sqrt(3.0));
              angleArc=angleArcPeca();
          break;
          case TCIRI_TRIANGLE_OBTUS_ARC:
              angleInicial=atan(1.0/(sqrt(3)-1));
              anglesVertex.replace(0,atan(1.0/(sqrt(3.0)-1.0)));
              anglesVertex.replace(1,PI-atan(2.0/(sqrt(3.0)+2.0)));
              anglesVertex.replace(2,2*PI-atan(1.0/(4.0-sqrt(3.0))));
              angleCentreArc=PI+atan(2.0/(sqrt(3.0)+2.0));
              angleArc=angleArcPeca();
          break;
          case TCIRI_TRIANGLE_OBTUS_GRAN_ARC:
              angleInicial=PI-atan(1.0);
              anglesVertex.replace(0,PI-atan(1.0));
              anglesVertex.replace(1,PI);
              //ajustat manualment (hauri d'ésser 1.0)
              anglesVertex.replace(2,2*PI-atan(1.025));
              angleCentreArc=PI+atan(1.0);
              angleArc=angleArcPeca();
          break;

//Tangram circular II (8 peces)
          case TCII_TRIANGLE_GRAN:
              angleInicial=PI-atan(sqrt(3.0));
              anglesVertex.replace(0,PI-atan(sqrt(3.0)));
              anglesVertex.replace(1,atan(sqrt(3.0)/2.0));
              anglesVertex.replace(2,PI+atan(2*sqrt(3.0)));
              angleCentreArc=2*PI-atan(2*sqrt(3.0)/5.0);
              angleArc=60.0;//angleArcPeca();
           break;
          case TCII_TRIANGLE_ISOSCELES_ARC:           
              angleInicial=PI-atan(2*sqrt(3.0));
              anglesVertex.replace(0,PI-atan(2*sqrt(3.0)));
              anglesVertex.replace(1,0.0);
              anglesVertex.replace(2,PI+atan(2*sqrt(3.0)));
              angleCentreArc=0;
              angleArc=120;
           break;
          case TCII_ARC:
              angleInicial=PI-atan(sqrt(3.0)/6.0);
              anglesVertex.replace(0,PI-atan(sqrt(3.0)/6.0));
              anglesVertex.replace(1,atan(sqrt(3.0)/6.0));
              angleCentreArc=PI/2;
              angleArc=180;
           break;

//Tangram 7 I (Ivy)
            case T7I_TRAPEZI:
                angleInicial=PI-atan(1.0/2.0);
                anglesVertex.replace(0,PI-atan(1.0/2.0));
                anglesVertex.replace(1,atan(1.0/2.0));
                anglesVertex.replace(2,2*PI-atan(sqrt(3.0)-1));
                anglesVertex.replace(3,PI+atan(sqrt(3.0)-1));
            break;
            case T7I_PARALELOGRAM:
                angleInicial=PI-atan(sqrt(3.0)/5.0);
                anglesVertex.replace(0,PI-atan(sqrt(3.0)/5.0));
                anglesVertex.replace(1,atan(sqrt(3.0)/3.0));
                anglesVertex.replace(2,2*PI-atan(sqrt(3.0)/5.0));
                anglesVertex.replace(3,PI+atan(sqrt(3.0)/3.0));
            break;
            case T7I_PENTAGON:
                angleInicial=PI-atan(sqrt(3.0)/3.0);
                anglesVertex.replace(0,PI-atan(sqrt(3.0)/3.0));
                anglesVertex.replace(1,atan(sqrt(3.0)/3.0));
                anglesVertex.replace(2,2*PI-atan(sqrt(3.0)/9.0));
                anglesVertex.replace(3,2*PI-atan(sqrt(3.0)/3.0));
                anglesVertex.replace(4,3*PI/2);
                /*
                angleInicial=PI-atan(2*sqrt(3.0)/5.0);
                anglesVertex.replace(0,PI-atan(2*sqrt(3.0)/5.0));
                anglesVertex.replace(1,atan(2*sqrt(3.0)/3.0));
                anglesVertex.replace(2,0.0);
                anglesVertex.replace(3,0.0);
                anglesVertex.replace(4,PI+atan(2.0*sqrt(3.0)));*/

            break;

//Tangram 7 II Revathi
            case T7II_TRAPEZI:
                angleInicial=PI-atan(0.25);
                anglesVertex.replace(0,PI-atan(0.25));
                anglesVertex.replace(1,atan(0.25));
                anglesVertex.replace(2,2*PI-atan(0.5));
                anglesVertex.replace(3,PI+atan(0.5));
            break;

//Tangram 6 II
            case T6II_DOS_TRIANGLES:
                angleInicial=PI-atan(5.0/8.0);
                anglesVertex.replace(0,PI-atan(5.0/8.0));
                anglesVertex.replace(1,atan(2.5));
                anglesVertex.replace(2,2*PI-atan(2.5));
                anglesVertex.replace(3,PI+atan(5.0/8.0));
                anglesVertex.replace(4,PI);
            break;
            case T6II_TRIANGLE_TRAPEZI:
                angleInicial=PI-atan(5.0/8.0);
                anglesVertex.replace(0,PI-atan(5.0/8.0));
                anglesVertex.replace(1,atan(2.5));
                anglesVertex.replace(2,2*PI-atan(2.5));
                anglesVertex.replace(3,PI+atan(10.0/3.0));
                anglesVertex.replace(4,PI);
            break;
            case T6II_QUADRAT_TRIANGLE:
                angleInicial=PI-atan(5.0/8.0);
                anglesVertex.replace(0,PI-atan(5.0/8.0));
                anglesVertex.replace(1,atan(2.5));
                anglesVertex.replace(2,2*PI-atan(2.5));
                anglesVertex.replace(3,PI+atan(10.0/3.0));
                anglesVertex.replace(4,PI+atan(5.0/8.0));
                anglesVertex.replace(5,PI);
            break;

//Tangram Sam Lloyd 5 peces
            case TSL_TRIANGLE_PETIT:
            case TSL_TRIANGLE_GRAN:
                angleInicial=PI-atan(0.5);
                anglesVertex.replace(0,PI-atan(0.5));
                anglesVertex.replace(1,atan(0.25));
                anglesVertex.replace(2,PI+atan(1.0));
            break;
            case TSL_QUADRAT:
                angleInicial=3*PI/4;
                anglesVertex.replace(0,3*PI/4);
                anglesVertex.replace(1,PI/4);
                anglesVertex.replace(2,7*PI/4);
                anglesVertex.replace(3,5*PI/4);
            break;
            case TSL_TRAPEZI:
                angleInicial=3*PI/4;
                anglesVertex.replace(0,3*PI/4);
                anglesVertex.replace(1,PI/4);
                anglesVertex.replace(2,0);
                anglesVertex.replace(3,5*PI/4);
            break;
            case TSL_HEXAGON:
                angleInicial=PI-atan(0.25);
                anglesVertex.replace(0,PI-atan(0.25));
                anglesVertex.replace(1,atan(1.0/6.0));
                anglesVertex.replace(2,2*PI-atan(0.75));
                anglesVertex.replace(3,3*PI/2);
                anglesVertex.replace(4,PI+atan(5.0/2.0));
                anglesVertex.replace(5,PI+atan(1.0));
            break;

//Tangram "los nueve tangram"
           case T9T_TRIANGLE_ISOSCELES_PETIT:
           case T9T_TRIANGLE_ISOSCELES_GRAN:
                angleInicial=PI-atan(sqrt(3.0)/2.0);
                anglesVertex.replace(0,PI-atan(sqrt(3.0)/2.0));
                anglesVertex.replace(1,atan(sqrt(3.0)/2.0));
                anglesVertex.replace(2,3*PI/2);
                /*
                angleInicial=PI-atan(1.0);
                anglesVertex.replace(0,PI-atan(1.0));
                anglesVertex.replace(1,atan(1.0));
                anglesVertex.replace(2,3*PI/2);
                */
            break;
           case T9T_TRIANGLE_RECTANGLE_PETIT:
                angleInicial=PI-atan(1.0/sqrt(3.0));
                anglesVertex.replace(0,PI-atan(1.0/sqrt(3.0)));
                anglesVertex.replace(1,atan(1.0/(sqrt(3.0)*2.0)));
                anglesVertex.replace(2,PI+atan(2.0/sqrt(3.0)));
            break;

           case T9T_TRIANGLE_RECTANGLE_GRAN_1:
                angleInicial=PI-atan(1.0/sqrt(3.0));
                anglesVertex.replace(0,PI-atan(1.0/sqrt(3.0)));
                anglesVertex.replace(1,atan(1.0/(sqrt(3.0)*2.0)));
                anglesVertex.replace(2,PI+atan(2.0/sqrt(3.0)));
                /*
                angleInicial=atan(8.0/3.0);
                anglesVertex.replace(0,atan(8.0/3.0));
                anglesVertex.replace(1,2*PI-atan(8.0/3.0));
                anglesVertex.replace(2,PI+atan(4.0/3.0));
                */
            break;

           case T9T_TRIANGLE_RECTANGLE_GRAN_2:
                angleInicial=PI-atan(sqrt(3.0)/3.0);
                anglesVertex.replace(0,PI-atan(sqrt(3.0)/3.0));
                anglesVertex.replace(1,atan(sqrt(3.0)/6.0));
                anglesVertex.replace(2,PI+atan(2.0*sqrt(3.0)/3.0));
                /*
                angleInicial=PI-atan(0.5);
                anglesVertex.replace(0,PI-atan(0.5));
                anglesVertex.replace(1,atan(0.5));
                anglesVertex.replace(2,PI+atan(0.5));
                */
            break;
           case T9T_TRAPEZI:
                angleInicial=PI-atan(sqrt(3.0)/4.0);
                anglesVertex.replace(0,PI-atan(sqrt(3.0)/4.0));
                anglesVertex.replace(1,atan(sqrt(3.0)/4.0));
                anglesVertex.replace(2,2*PI-atan(sqrt(3.0)/2.0));
                anglesVertex.replace(3,PI+atan(sqrt(3.0)/2.0));
                /*
                angleInicial=PI-atan(2.0/5.0);
                anglesVertex.replace(0,PI-atan(2.0/5.0));
                anglesVertex.replace(1,atan(2.0/5.0));
                anglesVertex.replace(2,2*PI-atan(1.0));
                anglesVertex.replace(3,PI+atan(atan(2.0/3.0)));
                */
            break;

//Tangram Stomachion II
            case TSTII_QUADRILATER_1:
                angleInicial=PI-atan(0.5);
                anglesVertex.replace(0,PI-atan(0.5));
                anglesVertex.replace(1,atan(0.5));
                anglesVertex.replace(2,0.0);
                anglesVertex.replace(3,3*PI/2);
            break;
            case TSTII_QUADRILATER_2:
                angleInicial=PI-atan(4.0/3.0);
                anglesVertex.replace(0,PI-atan(4.0/3.0));
                anglesVertex.replace(1,2*PI-atan(2.0/3.0));
                anglesVertex.replace(2,2*PI-atan(4.0));
                anglesVertex.replace(3,PI+atan(2.0/3.0));
            break;
            case TSTII_TRIANGLE_RECT_1:
                angleInicial=PI-atan(1.0/3.0);
                anglesVertex.replace(0,PI-atan(1.0/3.0));
                anglesVertex.replace(1,atan(1.0/6.0));
                anglesVertex.replace(2,PI+atan(2.0/3.0));
            break;
            case TSTII_TRIANGLE_4:
                angleInicial=PI-atan(0.25);
                anglesVertex.replace(0,PI-atan(0.25));
                anglesVertex.replace(1,atan(0.2));
                anglesVertex.replace(2,PI+atan(2.0));
            break;
            case TSTII_TRIANGLE_5:
                angleInicial=PI-atan(0.4);
                anglesVertex.replace(0,PI-atan(0.4));
                anglesVertex.replace(1,atan(0.5));
                anglesVertex.replace(2,2*PI-atan(4.0));
            break;
            case TSTII_PENTAGON:
                angleInicial=3*PI/4;
                anglesVertex.replace(0,3*PI/4);
                anglesVertex.replace(1,PI/4);
                anglesVertex.replace(2,atan(0.2));
                anglesVertex.replace(3,7*PI/4);
                anglesVertex.replace(4,5*PI/4);
            break;
            case TSTII_TRIANGLE_7:
                angleInicial=PI-atan(0.25);
                anglesVertex.replace(0,PI-atan(0.25));
                anglesVertex.replace(1,atan(0.2));
                anglesVertex.replace(2,PI+atan(2.0));
            break;
            case TSTII_TRIANGLE_8:
                angleInicial=PI-atan(2.0/7.0);
                anglesVertex.replace(0,PI-atan(2.0/7.0));
                anglesVertex.replace(1,atan(2.0/11.0));
                anglesVertex.replace(2,5*PI/4);
            break;
            case TSTII_TRIANGLE_9:
                angleInicial=PI/2;
                anglesVertex.replace(0,PI/2);
                anglesVertex.replace(1,atan(0.5));
                anglesVertex.replace(2,PI+atan(3.0/2.0));
            break;


            default:{
                //si es dona el cas....
                //farem el quadrat
                //Carregam els angles
                angleInicial=atan(1.0);
                anglesVertex.replace(0,atan(1.0));
                anglesVertex.replace(1,atan(1.0)+PI/2);
                anglesVertex.replace(2,atan(1.0)+PI);
                anglesVertex.replace(3,atan(1.0)+3*PI/2);
            }

     }
}
